﻿// CodeGear C++Builder
// Copyright (c) 1995, 2023 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'FMX.uecGraphics.pas' rev: 36.00 (Windows)

#ifndef Fmx_UecgraphicsHPP
#define Fmx_UecgraphicsHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.SysUtils.hpp>
#include <System.Types.hpp>
#include <System.UITypes.hpp>
#include <System.Rtti.hpp>
#include <System.Classes.hpp>
#include <System.Math.hpp>
#include <System.Generics.Collections.hpp>
#include <System.Generics.Defaults.hpp>
#include <System.SyncObjs.hpp>
#include <System.UIConsts.hpp>
#include <System.Math.Vectors.hpp>
#include <FMX.TextLayout.hpp>
#include <FMX.uecMapUtil.hpp>
#include <FMX.jhHTMLGraphics.hpp>
#include <FMX.Graphics.hpp>
#include <FMX.Types.hpp>
#include <FMX.Controls.hpp>
#include <FMX.Forms.hpp>
#include <FMX.Objects.hpp>
#include <FMX.Platform.hpp>

//-- user supplied -----------------------------------------------------------

namespace Fmx
{
namespace Uecgraphics
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TECCanvas;
//-- type declarations -------------------------------------------------------
typedef Fmx::Graphics::TBrush TPen;

class PASCALIMPLEMENTATION TECCanvas : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Fmx::Graphics::TBitmap* FBitmap;
	Fmx::Graphics::TCanvas* _Canvas;
	Fmx::Jhhtmlgraphics::TGetDrawGraphic FGetDrawGraphic;
	int FWAngle;
	int _Angle;
	int _PenSize;
	double _CAngle;
	double _SAngle;
	int FAngle;
	System::Types::TPoint FCenterRotation;
	double CAngle;
	double SAngle;
	double FScale;
	System::Math::Vectors::TMatrix SaveMatrix;
	Fmx::Textlayout::TTextLayout* FLayout;
	int FBeginUpdate;
	Fmx::Graphics::TPathData* FPath;
	Fmx::Objects::TPath* FDPath;
	System::Generics::Collections::TObjectDictionary__2<System::UnicodeString,Fmx::Graphics::TPathData*>* TPathDataList;
	Fmx::Graphics::TFont* FFont;
	Fmx::Graphics::TBrush* FFill;
	Fmx::Graphics::TStrokeBrush* FStroke;
	float FOpacity;
	float FFillOpacity;
	int FTop;
	int FLeft;
	int FRight;
	int FBottom;
	int FWeight;
	int FWidth;
	int FHeight;
	Fmx::Graphics::TBrush* __fastcall getBrush();
	void __fastcall setBrush(Fmx::Graphics::TBrush* const Value);
	TPen* __fastcall getPen();
	void __fastcall setPen(TPen* const Value);
	Fmx::Graphics::TFont* __fastcall getFont();
	void __fastcall setFont(Fmx::Graphics::TFont* const Value);
	int __fastcall getWidth();
	void __fastcall setWidth(const int Value);
	int __fastcall getHeight();
	void __fastcall setHeight(const int Value);
	void __fastcall setFontColor(Fmx::Uecmaputil::TColor Color);
	Fmx::Uecmaputil::TColor __fastcall getFontColor();
	int __fastcall getFontsize();
	void __fastcall setFontsize(int Value);
	void __fastcall setScale(const double Value);
	void __fastcall FillText(const System::Types::TRectF &ARect, const System::UnicodeString AText, const bool WordWrap, const float AOpacity, const Fmx::Graphics::TFillTextFlags Flags, const Fmx::Types::TTextAlign ATextAlign, const Fmx::Types::TTextAlign AVTextAlign);
	void __fastcall setOpacity(float Value);
	float __fastcall getOpacity();
	void __fastcall setFillOpacity(float Value);
	float __fastcall getFillOpacity();
	void __fastcall setCanvas(Fmx::Graphics::TCanvas* CanvasValue);
	Fmx::Graphics::TCanvas* __fastcall getCanvas();
	void __fastcall setAngle(const int Value);
	
public:
	__fastcall TECCanvas(double ValueScale, Fmx::Graphics::TCanvas* ValueCanvas);
	__fastcall virtual ~TECCanvas();
	void __fastcall BeginTranslate(const int x, const int y);
	void __fastcall EndTranslate();
	void __fastcall Rotate(const double Value, const int x, const int y);
	bool __fastcall BeginUpdate();
	void __fastcall EndUpdate();
	void __fastcall CompensateRotation();
	void __fastcall SaveCanvas();
	void __fastcall RestoreCanvas();
	void __fastcall GrayScale();
	void __fastcall InvertColor();
	void __fastcall SepiaColor();
	void __fastcall LightColor(const System::Byte LightValue);
	void __fastcall DarkColor(const System::Byte DarkValue);
	void __fastcall RotationXYX2Y2(int &x, int &y, int &x2, int &y2);
	void __fastcall Ellipse(const Fmx::Uecmaputil::TDashStyle DashStyle = Fmx::Uecmaputil::TDashStyle(), const Fmx::Uecmaputil::TPenStyle Style = (Fmx::Uecmaputil::TPenStyle)(0x0))/* overload */;
	void __fastcall Ellipse(int x, int y, int X1, int Y1, const Fmx::Uecmaputil::TDashStyle DashStyle = Fmx::Uecmaputil::TDashStyle(), const Fmx::Uecmaputil::TPenStyle Style = (Fmx::Uecmaputil::TPenStyle)(0x0))/* overload */;
	System::LongBool __fastcall Polyline(const System::Types::TPoint *Points, const System::NativeInt Points_High, int Count = 0x0, int firstPoint = 0x0, const Fmx::Uecmaputil::TDashStyle DashStyle = Fmx::Uecmaputil::TDashStyle(), const Fmx::Uecmaputil::TPenStyle Style = (Fmx::Uecmaputil::TPenStyle)(0x0), const bool close = false);
	void __fastcall PolyBezier(const System::Types::TPoint *Points, const System::NativeInt Points_High, int Count);
	void __fastcall Poly(const bool Bezier, const System::Types::TPoint *Points, const System::NativeInt Points_High, int Count, int Weight, const Fmx::Uecmaputil::TColor Color, const Fmx::Uecmaputil::TPenStyle Style, const Fmx::Uecmaputil::TDashStyle DashStyle, int firstPoint = 0x0);
	void __fastcall Polygon(System::Types::TPoint *Points, const System::NativeInt Points_High, const Fmx::Uecmaputil::TDashStyle DashStyle = Fmx::Uecmaputil::TDashStyle(), const Fmx::Uecmaputil::TPenStyle Style = (Fmx::Uecmaputil::TPenStyle)(0x0), const bool fix2dc = true)/* overload */;
	void __fastcall DrawRotatedText(Fmx::Graphics::TCanvas* Canvas, const System::Types::TPointF &P, float RadAngle, const System::UnicodeString S, Fmx::Types::TTextAlign HTextAlign, Fmx::Types::TTextAlign VTextAlign)/* overload */;
	void __fastcall Polylines(const System::Math::Vectors::TPolygon Points, const Fmx::Uecmaputil::TDashStyle DashStyle, const Fmx::Uecmaputil::TPenStyle Style = (Fmx::Uecmaputil::TPenStyle)(0x0));
	void __fastcall Polygon(const System::Math::Vectors::TPolygon Points, const Fmx::Uecmaputil::TDashStyle DashStyle, const Fmx::Uecmaputil::TPenStyle Style = (Fmx::Uecmaputil::TPenStyle)(0x0))/* overload */;
	void __fastcall Polygon(Fmx::Graphics::TPathData* const Points, const Fmx::Uecmaputil::TDashStyle DashStyle, const Fmx::Uecmaputil::TPenStyle Style = (Fmx::Uecmaputil::TPenStyle)(0x0))/* overload */;
	void __fastcall FillRectangle(const System::Types::TRectF &rect)/* overload */;
	void __fastcall FillCircle(const System::Types::TRectF &rect);
	void __fastcall Clear(Fmx::Uecmaputil::TColor Color);
	void __fastcall setSize(const int W, const int H);
	void __fastcall AlphaBlendPolygon(const System::Types::TPoint *Points, const System::NativeInt Points_High, const Fmx::Uecmaputil::TColor Color, const System::Byte _Opacity);
	void __fastcall Rectangle(int x, int y, int X1, int Y1);
	void __fastcall FillRectangle(int x, int y, int X1, int Y1)/* overload */;
	void __fastcall RoundRect(int x, int y, int X1, int Y1, int rx, int ry);
	void __fastcall DrawStar(const System::Types::TRect &rect, const Fmx::Uecmaputil::TDashStyle DashStyle = Fmx::Uecmaputil::TDashStyle(), const Fmx::Uecmaputil::TPenStyle Style = (Fmx::Uecmaputil::TPenStyle)(0x0));
	void __fastcall DrawHexagon(const System::Types::TRect &rect, const Fmx::Uecmaputil::TDashStyle DashStyle = Fmx::Uecmaputil::TDashStyle(), const Fmx::Uecmaputil::TPenStyle Style = (Fmx::Uecmaputil::TPenStyle)(0x0));
	void __fastcall moveto(const int x, const int y);
	void __fastcall lineto(const int x, const int y);
	void __fastcall TextOut(const int x, const int y, const System::UnicodeString Text);
	void __fastcall TextRect(const System::Types::TRect &rect, int x, int y, const System::UnicodeString Text);
	void __fastcall DrawText(const System::UnicodeString Text, const System::Types::TRect &r, Fmx::Types::TTextAlign Align = (Fmx::Types::TTextAlign)(0x0));
	int __fastcall TextHeight(const System::UnicodeString Value);
	int __fastcall TextWidth(const System::UnicodeString Value);
	System::Types::TSize __fastcall TextExtent(const System::UnicodeString Value);
	void __fastcall Draw(int x, int y, Fmx::Uecmaputil::TGraphic* const graphic)/* overload */;
	void __fastcall Draw(int x, int y, Fmx::Uecmaputil::TGraphic* const graphic, int W, int H, const int OriginX = 0x0, const int OriginY = 0x0)/* overload */;
	void __fastcall PenWidth(int Value);
	void __fastcall setPenStyle(Fmx::Uecmaputil::TPenStyle Value);
	void __fastcall DrawData(const System::UnicodeString Data)/* overload */;
	void __fastcall DrawData(const System::UnicodeString Data, const System::Types::TRectF &rect)/* overload */;
	void __fastcall DrawData(Fmx::Graphics::TPathData* const Data)/* overload */;
	void __fastcall DrawPath();
	System::LongBool __fastcall PolylineToPath(const System::Types::TPoint *Points, const System::NativeInt Points_High, int Count);
	void __fastcall StylePolyline(int Weight, const Fmx::Uecmaputil::TColor Color, const Fmx::Uecmaputil::TPenStyle Style);
	virtual bool __fastcall DrawHTML(const System::UnicodeString HtmlText, const bool bdRightToLeft, System::Types::TRect &vRect, const unsigned cjhFlags, Fmx::Jhhtmlgraphics::TGetDrawGraphic doGetDrawGraphic, Fmx::Jhhtmlgraphics::TGetAreaAnchor doGetAreaAnchor = 0x0, const int HitID = 0xffffffff, const double _scale = 1.000000E+00);
	void __fastcall TextHTML(const System::UnicodeString HtmlText, const int x, const int y)/* overload */;
	void __fastcall TextHTML(const System::UnicodeString HtmlText, System::Types::TRect &vRect)/* overload */;
	System::Types::TRect __fastcall HTMLRect(const System::UnicodeString HtmlText);
	__property int WAngle = {read=FWAngle, write=FWAngle, nodefault};
	__property int Angle = {read=FAngle, write=setAngle, nodefault};
	__property double CosAngle = {read=CAngle, write=CAngle};
	__property double SinAngle = {read=SAngle, write=SAngle};
	__property double Scale = {read=FScale, write=setScale};
	__property Fmx::Uecmaputil::TColor FontColor = {read=getFontColor, write=setFontColor, nodefault};
	__property int FontSize = {read=getFontsize, write=setFontsize, nodefault};
	__property Fmx::Graphics::TBrush* Brush = {read=getBrush, write=setBrush};
	__property TPen* Pen = {read=getPen, write=setPen};
	__property int PenSize = {read=FWeight, write=PenWidth, nodefault};
	__property Fmx::Graphics::TFont* Font = {read=getFont, write=setFont};
	__property int Width = {read=getWidth, write=setWidth, nodefault};
	__property int Height = {read=getHeight, write=setHeight, nodefault};
	__property int Top = {read=FTop, write=FTop, nodefault};
	__property int Left = {read=FLeft, write=FLeft, nodefault};
	__property int Right = {read=FRight, write=FRight, nodefault};
	__property int Bottom = {read=FBottom, write=FBottom, nodefault};
	__property Fmx::Graphics::TBitmap* Bitmap = {read=FBitmap};
	__property Fmx::Jhhtmlgraphics::TGetDrawGraphic GetDrawGraphic = {read=FGetDrawGraphic, write=FGetDrawGraphic};
	__property float Opacity = {read=getOpacity, write=setOpacity};
	__property float FillOpacity = {read=getFillOpacity, write=setFillOpacity};
	__property Fmx::Graphics::TPathData* Path = {read=FPath};
	__property System::Types::TPoint CenterRotation = {read=FCenterRotation, write=FCenterRotation};
	__property int RotationAngle = {read=FAngle, write=setAngle, nodefault};
	__property Fmx::Graphics::TCanvas* Canvas = {read=getCanvas, write=setCanvas};
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE void __fastcall BubbleSortGraph(Fmx::Uecmaputil::TECAGraphInfo &A);
extern DELPHI_PACKAGE void __fastcall QuickSortGraph(Fmx::Uecmaputil::TECAGraphInfo &A, int iLo, int iHi);
extern DELPHI_PACKAGE System::Types::TPointF __fastcall RotatePoint(const System::Types::TPointF &APoint, const System::Types::TPointF &ACenter, const float AAngle);
extern DELPHI_PACKAGE Fmx::Uecmaputil::TGraphic* __fastcall PieGraphToBitmap(const int Radius, const Fmx::Uecmaputil::TECAGraphInfo &Data);
extern DELPHI_PACKAGE Fmx::Uecmaputil::TGraphic* __fastcall StackedBarToBitmap(const int W, const int H, const Fmx::Uecmaputil::TECAGraphInfo &Data);
}	/* namespace Uecgraphics */
}	/* namespace Fmx */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX_UECGRAPHICS)
using namespace Fmx::Uecgraphics;
#endif
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX)
using namespace Fmx;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Fmx_UecgraphicsHPP
