﻿// CodeGear C++Builder
// Copyright (c) 1995, 2023 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'FMX.uecMapUtil.pas' rev: 36.00 (Windows)

#ifndef Fmx_UecmaputilHPP
#define Fmx_UecmaputilHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.SysUtils.hpp>
#include <System.Types.hpp>
#include <System.UITypes.hpp>
#include <System.Rtti.hpp>
#include <System.Classes.hpp>
#include <FMX.Utils.hpp>
#include <System.Diagnostics.hpp>
#include <System.IOUtils.hpp>
#include <System.DateUtils.hpp>
#include <FMX.uecHttp.hpp>
#include <System.Generics.Collections.hpp>
#include <System.Generics.Defaults.hpp>
#include <System.SyncObjs.hpp>
#include <System.UIConsts.hpp>
#include <Soap.EncdDecd.hpp>
#include <System.NetEncoding.hpp>
#include <Winapi.ShellAPI.hpp>
#include <Winapi.Windows.hpp>
#include <Winapi.UrlMon.hpp>
#include <Winapi.WinInet.hpp>
#include <System.Win.ComObj.hpp>
#include <Winapi.ShlObj.hpp>
#include <Winapi.Messages.hpp>
#include <System.Net.URLClient.hpp>
#include <System.Net.HttpClient.hpp>
#include <System.Math.hpp>
#include <System.StrUtils.hpp>
#include <FMX.Types.hpp>
#include <FMX.Controls.hpp>
#include <FMX.Forms.hpp>
#include <FMX.Objects.hpp>
#include <FMX.Platform.hpp>
#include <FMX.Graphics.hpp>
#include <FMX.Dialogs.hpp>

//-- user supplied -----------------------------------------------------------

namespace Fmx
{
namespace Uecmaputil
{
//-- forward type declarations -----------------------------------------------
struct TECGraphData;
struct TECAGraphInfo;
struct Ellipsoid;
struct TLatLng;
struct TBoundsLatLng;
struct TDataGeoIP;
struct TECColorTolerance;
class DELPHICLASS TECFilterColor;
class DELPHICLASS TecTextReader;
class DELPHICLASS TecCSVReader;
class DELPHICLASS TecToken;
class DELPHICLASS TecBingDirection;
class DELPHICLASS TecHereDirection;
class DELPHICLASS TecGoogleDirection;
class DELPHICLASS TecGoogleStreetViewBitmap;
class DELPHICLASS TecUTFJson;
class DELPHICLASS TNativeMapObserver;
class DELPHICLASS TDisplayMapTiles;
struct TDoublePoint;
struct TDoubleArea;
class DELPHICLASS TECTilesCoordinatesConverter;
struct TIntPoint;
class DELPHICLASS TStringDataCache;
class DELPHICLASS TStringDataCacheList;
class DELPHICLASS TECWorldInfo;
class DELPHICLASS TFStringList;
class DELPHICLASS TThreadedTimer;
class DELPHICLASS TInternalStringList;
class DELPHICLASS TThreadStringList;
class DELPHICLASS TecNotifyMessage;
class DELPHICLASS TEcNotify;
//-- type declarations -------------------------------------------------------
struct DECLSPEC_DRECORD TECGraphData
{
public:
	double Value;
	System::Uitypes::TAlphaColor Color;
	System::Uitypes::TAlphaColor BorderColor;
	System::UnicodeString Legend;
};


typedef System::DynamicArray<TECGraphData> TECAGraphData;

enum DECLSPEC_DENUM TECChartType : unsigned char { ctPie, ctDonut, ctFillDonut, ctVerticalStackedBar, ctHorizontalStackedBar };

struct DECLSPEC_DRECORD TECAGraphInfo
{
	
private:
	typedef System::DynamicArray<int> _TECAGraphInfo__1;
	
	
public:
	TECAGraphData Serie;
	double Total;
	bool SortAscent;
	_TECAGraphInfo__1 Index;
	TECChartType Graph;
	System::Uitypes::TAlphaColor BorderColor;
	System::Uitypes::TAlphaColor DonutColor;
};


struct DECLSPEC_DRECORD Ellipsoid
{
public:
	System::UnicodeString Name;
	System::Extended Radius;
	System::Extended eccSquared;
};


enum DECLSPEC_DENUM TNbrThreadTile : unsigned char { ttOne, ttTwo, ttFour };

enum DECLSPEC_DENUM TToTxtAttr : unsigned char { ttaMap, ttaOverlays, ttaReplace, ttaGeofences, ttaGrids };

typedef System::Set<TToTxtAttr, TToTxtAttr::ttaMap, TToTxtAttr::ttaGrids> TToTxtType;

struct DECLSPEC_DRECORD TLatLng
{
public:
	double Lng;
	double Lat;
};


enum DECLSPEC_DENUM TLocationDirection : unsigned char { ldUnknown, ldNorth, ldNorthEast, ldEast, ldSouthEast, ldSouth, ldSouthWest, ldWest, ldNorthWest };

typedef System::DynamicArray<TLatLng> TArrayLatLng;

typedef System::DynamicArray<System::UnicodeString> TArrayString;

struct DECLSPEC_DRECORD TBoundsLatLng
{
public:
	double NELat;
	double NELng;
	double SWLat;
	double SWLng;
};


typedef System::DynamicArray<TBoundsLatLng> TArrayBoundsLatLng;

struct DECLSPEC_DRECORD TDataGeoIP
{
public:
	System::UnicodeString ip;
	System::UnicodeString country_code;
	System::UnicodeString country_name;
	System::UnicodeString region_code;
	System::UnicodeString region_name;
	System::UnicodeString city;
	System::UnicodeString zip_code;
	System::UnicodeString time_zone;
	double latitude;
	double longitude;
	int metro_code;
};


typedef System::UnicodeString ansistring;

typedef System::WideChar ansiChar;

typedef double TFloat;

typedef System::Uitypes::TAlphaColor TColor;

typedef Fmx::Graphics::TBitmap TIcon;

typedef Fmx::Graphics::TBitmap TileJpeg;

typedef Fmx::Graphics::TBitmap TilePng;

typedef Fmx::Graphics::TBitmap TGraphic;

typedef Fmx::Controls::TControl TWinControl;

enum DECLSPEC_DENUM TPenStyle : unsigned char { psSolid, psDot, psDash, psDashDot, psUserStyle };

typedef System::DynamicArray<float> TDashStyle;

enum DECLSPEC_DENUM TBrushStyle : unsigned char { bsSolid, bsClear, bsCross, bsDiagCross, bsBDiagonal, bsHorizontal, bsFDiagonal, bsVertical, bsGraphic };

typedef System::Generics::Collections::TList__1<System::Uitypes::TAlphaColor> TECColorList;

enum DECLSPEC_DENUM TFilterColor : unsigned char { fcNone, fcGrey, fcCustom, fcInvert, fcSepia };

enum DECLSPEC_DENUM TActionColor : unsigned char { acKeep, acReplace };

struct DECLSPEC_DRECORD TECColorTolerance
{
public:
	int R_min;
	int R_max;
	int G_min;
	int G_max;
	int B_min;
	int B_max;
};


typedef System::DynamicArray<TECColorTolerance> TECArrayColorTolerance;

class PASCALIMPLEMENTATION TECFilterColor : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TECColorList* FColors;
	System::Classes::TNotifyEvent FOnChange;
	TFilterColor FFilter;
	System::Byte FLightValue;
	System::Byte FDarkValue;
	TActionColor FActionColor;
	TECArrayColorTolerance FColorTolerance;
	double FTolerance;
	void __fastcall setTolerance(const double Value);
	void __fastcall setFilter(const TFilterColor Value);
	void __fastcall setLightValue(const System::Byte Value);
	void __fastcall setDarkValue(const System::Byte Value);
	
public:
	__fastcall TECFilterColor(const System::Classes::TNotifyEvent evtChange);
	__fastcall virtual ~TECFilterColor();
	__property TFilterColor Filter = {read=FFilter, write=setFilter, nodefault};
	__property TActionColor ActionColor = {read=FActionColor, write=FActionColor, nodefault};
	__property TECColorList* Colors = {read=FColors};
	__property double Tolerance = {read=FTolerance, write=setTolerance};
	__property System::Byte LightValue = {read=FLightValue, write=setLightValue, nodefault};
	__property System::Byte DarkValue = {read=FDarkValue, write=setDarkValue, nodefault};
};


enum DECLSPEC_DENUM TAnchorPosition : unsigned char { apTopLeft, apTopRight, apBottomLeft, apBottomRight, apCenter };

enum DECLSPEC_DENUM TMesureSystem : unsigned char { msMetric, msImperial, msNautical };

enum DECLSPEC_DENUM TScaleBarStyle : unsigned char { sbsLine, sbsBar };

enum DECLSPEC_DENUM TLocalCacheSetting : unsigned char { lcsReadWrite, lcsWrite };

enum DECLSPEC_DENUM TGeoDataFormat : unsigned char { gdfGeoJson, gdfKml, gdfGpx, gdfText };

enum DECLSPEC_DENUM TPOIShape : unsigned char { poiEllipse, poiStar, poiRect, poiTriangle, poiOwnerDraw, poiHexagon, poiDiamond, poiText, poiArrow, poiArrowHead, poiCross, poiDiagCross, poiDirectionSign, PoiNone };

enum DECLSPEC_DENUM TStreamType : unsigned char { stNone, stPng, stJpeg, stGeoJSON };

enum DECLSPEC_DENUM TPOIUnit : unsigned char { puPixel, puMeter };

enum DECLSPEC_DENUM TApiAltitude : unsigned char { altMapquest, altOpenElevation, altOpenTopoData, altCustom };

enum DECLSPEC_DENUM TMQRouteType : unsigned char { rtFastest, rtShortest, rtPedestrian, rtBicycle, rtMultimodal, rtCar, rtTruck };

enum DECLSPEC_DENUM TTileServer : unsigned char { tsNone, tsOpenMapQuest, tsOpenMapQuestSat, tsCloudMade, tsOSM, tsOpenCycleMap, tsOPNV, tsArcGisWorldTopoMap, tsArcGisWorldStreetMap, tsArcGisWorldImagery, tsBingRoad, tsBingAerial, tsBingAerialLabels, tsOwnerDraw, tsCustom, tsHereNormal, tsHereTerrain, tsHereMobile, tsHereHiRes, tsHereTransit, tsHereTraffic, tsHereFlow, tsHereTruck, tsHereTruckTransparent, tsHereHybrid, tsHereSatellite, tsHereReducedNight, tsHereNormalNight, tsHereXBNormalNight, tsMapBoxSatellite, tsMapBoxStreets, tsMapBoxStreetsSatellite, tsMapBoxStreetsBasic, tsMapBoxOutdoors, tsVectorMapZen, tsYandexNormal, tsYandexSatellite, tsYandexHybrid, tsYandexPeople, tsDigitalGlobeRecent, tsDigitalGlobeTerrain, tsOsmFr, tsOpenTopoMap, tsMapillary, 
	tsTomTomBasic, tsTomTomHybrid, tsTomTomNight, tsTomTomIncident, tsTomTomFlow, tsHyddaFull, tsOsmDe, tsTopPlusWebOpen, tsTopPlusWebOpenGrey, tsbingCanvasGray, tsbingCanvasDark, tsbingCanvasLight, tsBaseOpenSnowMap, tsPisteOpenSnowMap, tsHotOsm, tsIgn, tsCyclOSM, tsTomTomSat, tsOpenRailWayMap, tsArcGisWorldOceanBase, tsAqicn, tsThunderForest, tsHere, tsStadiaMaps, tsGeoApify, tsGoogle };

typedef System::Classes::TNotifyEvent TThreadWorkOnDirection;

typedef void __fastcall (__closure *TThreadOnLoadTile)(const TTileServer source, const int x, const int y, const int z, const System::UnicodeString LocalFilename, const bool save, System::Classes::TMemoryStream* const stream);

typedef void __fastcall (__closure *TOnMapServerTilePath)(System::UnicodeString &TileFilename, const int x, const int y, const int z);

typedef void __fastcall (__closure *TOnMapServerTileStream)(const int ThreadIndex, System::Classes::TMemoryStream* &TileStream, const int x, const int y, const int z);

typedef void __fastcall (__closure *TOnWorldMoveTo)(System::TObject* sender, const double latitude, const double longitude);

typedef void __fastcall (__closure *TOnProjectionLatLngToXY)(const double Lat, const double Lng, double &x, double &y);

typedef void __fastcall (__closure *TOnProjectionXYToLatLng)(const double x, const double y, double &Lat, double &Lng);

typedef void __fastcall (__closure *TOnConversionESPG)(double &Lat, double &Lng, const int ESPG);

enum DECLSPEC_DENUM TECPanoramioImageSize : unsigned char { pimMini_square, pimSquare, pimThumbnail, pimSmall, pimMedium, pimOriginal };

enum DECLSPEC_DENUM TEventType : unsigned char { gctAdress, gctAddRoute, gctAStreet, gctBeforeUpdateRoute, gctBounds, gctCloseWin, gctOpenWin, gctContains, gctElevation, gctIdle, gctError, gctNull, gctLink, gctEarth, gctHeading, gctTilt, gctMapClick, gctMapDblClick, gctMapDrag, gctMapDragEnd, gctMapDragStart, gctMapRightClick, gctMapType, gctMarkerClick, gctMarkerDblClick, gctMarkerRClick, gctMarkerDrag, gctMarkerDragStart, gctMarkerDragEnd, gctMoveMap, gctMouseMove, gctMouseOut, gctMouseOver, gctMouseDown, gctMouseUp, gctMoveMarker, gctUpdateOverlay, gctPanoramio, gctPlace, gctStreet, gctTilesLoaded, gctTimer, gctZoom, gctFirstLoad, gctDistanceMatrix, gctSpecial };

class PASCALIMPLEMENTATION TecTextReader : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::Sysutils::TBytes FBytesBuffet;
	System::UnicodeString FStringBuffet;
	System::WideChar *FPStringBuffet;
	System::UnicodeString FFileName;
	__int64 FOffsetFile;
	__int64 FileLength;
	__int64 iReaded;
	int FOffsetStringBuffet;
	int FBuffetSize;
	int FbuffetReadSize;
	System::Classes::TStream* FileStream;
	bool __fastcall FillBuffet();
	void __fastcall setBuffetSize(const int Value);
	
public:
	__fastcall TecTextReader();
	__fastcall virtual ~TecTextReader();
	bool __fastcall OpenFile(const System::UnicodeString sfilename);
	bool __fastcall OpenStream(System::Classes::TStream* const sstream);
	void __fastcall CloseFile();
	void __fastcall Reset();
	bool __fastcall EOF();
	System::UnicodeString __fastcall ReadLn();
	__property int BuffetSize = {read=FBuffetSize, write=setBuffetSize, nodefault};
	__property System::UnicodeString Filename = {read=FFileName};
};


class PASCALIMPLEMENTATION TecCSVReader : public TecTextReader
{
	typedef TecTextReader inherited;
	
private:
	System::WideChar FDelimiter;
	void __fastcall ParseCSVLine(const System::UnicodeString ALine, System::Classes::TStrings* const AFields);
	
public:
	int __fastcall ReadFields(System::Classes::TStrings* const AFields);
	__property System::WideChar Delimiter = {read=FDelimiter, write=FDelimiter, nodefault};
public:
	/* TecTextReader.Create */ inline __fastcall TecCSVReader() : TecTextReader() { }
	/* TecTextReader.Destroy */ inline __fastcall virtual ~TecCSVReader() { }
	
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TecToken : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FData;
	System::WideChar FSepa;
	int FPos;
	int FLength;
	void __fastcall setData(const System::UnicodeString Value);
	bool __fastcall getEndOfToken();
	
public:
	__fastcall TecToken();
	void __fastcall GotoCar(const System::WideChar Value);
	void __fastcall SkeepCar(const System::WideChar Value);
	System::WideChar __fastcall PrevCar();
	System::UnicodeString __fastcall Token();
	__property System::UnicodeString Data = {read=FData, write=setData};
	__property System::WideChar Sepa = {read=FSepa, write=FSepa, nodefault};
	__property bool EndOfToken = {read=getEndOfToken, nodefault};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TecToken() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TecBingDirection : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Fmx::Uechttp::TuecHttp* FHttp;
	System::Classes::TStringList* FWayPoints;
	System::Classes::TStringList* FJson;
	System::UnicodeString FApi;
	System::UnicodeString FKey;
	System::UnicodeString FOrigin;
	System::UnicodeString FDestination;
	bool FOptimize;
	int FDistance;
	int FDuration;
	TArrayLatLng FPoints;
	
public:
	__fastcall TecBingDirection();
	__fastcall virtual ~TecBingDirection();
	int __fastcall Direction();
	__property System::UnicodeString Key = {read=FKey, write=FKey};
	__property System::UnicodeString Origin = {read=FOrigin, write=FOrigin};
	__property System::UnicodeString Destination = {read=FDestination, write=FDestination};
	__property System::Classes::TStringList* WayPoints = {read=FWayPoints};
	__property int Distance = {read=FDistance, nodefault};
	__property int Duration = {read=FDuration, nodefault};
	__property TArrayLatLng Points = {read=FPoints};
	__property bool Optimize = {read=FOptimize, write=FOptimize, nodefault};
	__property System::Classes::TStringList* JSon = {read=FJson};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TecHereDirection : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Fmx::Uechttp::TuecHttp* FHttp;
	System::Classes::TStringList* FWayPoints;
	System::Classes::TStringList* FJson;
	System::UnicodeString FApi;
	System::UnicodeString FApp_code;
	System::UnicodeString FApp_Id;
	System::UnicodeString FParams;
	int FDistance;
	int FDuration;
	
public:
	__fastcall TecHereDirection();
	__fastcall virtual ~TecHereDirection();
	int __fastcall Direction();
	__property System::UnicodeString App_code = {read=FApp_code, write=FApp_code};
	__property System::UnicodeString App_id = {read=FApp_Id, write=FApp_Id};
	__property System::Classes::TStringList* WayPoints = {read=FWayPoints};
	__property System::UnicodeString Params = {read=FParams, write=FParams};
	__property int Distance = {read=FDistance, nodefault};
	__property int Duration = {read=FDuration, nodefault};
	__property System::Classes::TStringList* JSon = {read=FJson};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TecGoogleDirection : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Fmx::Uechttp::TuecHttp* FHttp;
	System::Classes::TStringList* FWayPoints;
	System::Classes::TStringList* FJson;
	System::UnicodeString FApi;
	System::UnicodeString FKey;
	System::UnicodeString FOrigin;
	System::UnicodeString FDestination;
	bool FOptimize;
	int FDistance;
	int FDuration;
	TArrayLatLng FPoints;
	
public:
	__fastcall TecGoogleDirection();
	__fastcall virtual ~TecGoogleDirection();
	int __fastcall Direction();
	__property System::UnicodeString Key = {read=FKey, write=FKey};
	__property System::UnicodeString Origin = {read=FOrigin, write=FOrigin};
	__property System::UnicodeString Destination = {read=FDestination, write=FDestination};
	__property System::Classes::TStringList* WayPoints = {read=FWayPoints};
	__property int Distance = {read=FDistance, nodefault};
	__property int Duration = {read=FDuration, nodefault};
	__property TArrayLatLng Points = {read=FPoints};
	__property bool Optimize = {read=FOptimize, write=FOptimize, nodefault};
	__property System::Classes::TStringList* JSon = {read=FJson};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TecGoogleStreetViewBitmap : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TGraphic* FBitmap;
	System::Classes::TMemoryStream* FMStream;
	System::UnicodeString FApiKey;
	System::UnicodeString FApiUrl;
	int FMinMeters;
	double FLatitude;
	double FLongitude;
	int FWidth;
	int FHeight;
	int FPano;
	double FFov;
	double FHeading;
	double FPitch;
	System::UnicodeString FUrl;
	bool __fastcall doUpdate();
	void __fastcall setFov(const double Value);
	void __fastcall setPitch(const double Value);
	void __fastcall setHeading(const double Value);
	void __fastcall setPano(const int Value);
	void __fastcall setWidth(const int Value);
	void __fastcall setHeight(const int Value);
	
public:
	__fastcall TecGoogleStreetViewBitmap();
	__fastcall virtual ~TecGoogleStreetViewBitmap();
	bool __fastcall setPosition(const double Lat, const double Lng);
	__property System::UnicodeString ApiUrl = {read=FApiUrl, write=FApiUrl};
	__property System::UnicodeString ApiKey = {read=FApiKey, write=FApiKey};
	__property TGraphic* Bitmap = {read=FBitmap};
	__property double latitude = {read=FLatitude};
	__property double longitude = {read=FLongitude};
	__property System::UnicodeString BitmapUrl = {read=FUrl};
	__property int Pano = {read=FPano, write=setPano, nodefault};
	__property double Fov = {read=FFov, write=setFov};
	__property double Heading = {read=FHeading, write=setHeading};
	__property double Pitch = {read=FPitch, write=setPitch};
	__property int Width = {read=FWidth, write=setWidth, nodefault};
	__property int Height = {read=FHeight, write=setHeight, nodefault};
	__property int MinMeters = {read=FMinMeters, write=FMinMeters, nodefault};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TecUTFJson : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::Classes::TStringList* FGrid;
	System::Classes::TStringList* FKey;
	System::Classes::TStringList* FData;
	System::UnicodeString FJson;
	void __fastcall setJSon(const System::UnicodeString Value);
	
public:
	__fastcall TecUTFJson(const System::UnicodeString valueJson);
	__fastcall virtual ~TecUTFJson();
	__property System::Classes::TStringList* Grid = {read=FGrid};
	__property System::Classes::TStringList* Key = {read=FKey};
	__property System::Classes::TStringList* Data = {read=FData};
	__property System::UnicodeString JSon = {read=FJson, write=setJSon};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TNativeMapObserver : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	bool FMapFree;
	System::Classes::TNotifyEvent FOnMapFree;
	System::Classes::TNotifyEvent FOnMapTileServer;
	System::Classes::TNotifyEvent FOnMapResize;
	System::Classes::TNotifyEvent FOnMapStartMove;
	System::Classes::TNotifyEvent FOnMapEndMove;
	System::Classes::TNotifyEvent FOnMapMove;
	System::Classes::TNotifyEvent FOnMapCompleteTiles;
	System::Classes::TNotifyEvent FOnMapMouseMove;
	System::Classes::TNotifyEvent FOnMapMouseDown;
	System::Classes::TNotifyEvent FOnMapMouseUp;
	System::Classes::TNotifyEvent FOnMapMouseClick;
	System::Classes::TNotifyEvent FOnMapBounds;
	System::Classes::TNotifyEvent FOnMapChangeBounds;
	System::Classes::TNotifyEvent FOnMapAddRoute;
	System::Classes::TNotifyEvent FOnMapErrorRoute;
	System::Classes::TNotifyEvent FOnMapChangeRoute;
	System::Classes::TNotifyEvent FOnMapRotation;
	System::Classes::TNotifyEvent FOnMapAnimation;
	System::Classes::TNotifyEvent FOnMapShapeDragStart;
	System::Classes::TNotifyEvent FOnMapShapeDrag;
	System::Classes::TNotifyEvent FOnMapShapeDragEnd;
	System::Classes::TNotifyEvent FOnMapShapeMove;
	System::Classes::TNotifyEvent FOnMapShapeDescription;
	System::Classes::TNotifyEvent FOnMapShapeProperties;
	System::Classes::TNotifyEvent FOnMapShapeHint;
	System::Classes::TNotifyEvent FOnMapShapeClick;
	System::Classes::TNotifyEvent FOnMapShapeOverIntent;
	System::Classes::TNotifyEvent FOnMapShapeLongClick;
	System::Classes::TNotifyEvent FOnMapShapeLongPress;
	System::Classes::TNotifyEvent FOnMapShapeDblClick;
	System::Classes::TNotifyEvent FOnMapShapeRightClick;
	System::Classes::TNotifyEvent FOnMapShapePathChange;
	System::Classes::TNotifyEvent FOnMapShapeMouseOut;
	System::Classes::TNotifyEvent FOnMapShapeMouseOver;
	System::Classes::TNotifyEvent FOnMapShapeMouseDown;
	System::Classes::TNotifyEvent FOnMapShapeMouseUp;
	System::Classes::TNotifyEvent FOnMapLoad;
	System::Classes::TNotifyEvent FOnShapesPaint;
	System::Classes::TNotifyEvent FOnMapActiveChange;
	System::Classes::TNotifyEvent FOnMapHiResChange;
	System::Classes::TNotifyEvent FOnMapPaint;
	System::Classes::TNotifyEvent FOnMapZoom;
	System::Classes::TNotifyEvent FOnMapShapesChange;
	System::Classes::TNotifyEvent FOnMapShapesOSMLoad;
	System::Classes::TNotifyEvent FOnMapScreenShots;
	System::Classes::TNotifyEvent FOnMapFitBounds;
	System::Classes::TNotifyEvent FOnMapMouseStop;
	System::Classes::TNotifyEvent FOnMapFocus;
	System::Classes::TNotifyEvent FOnMapLoadGraphic;
	System::Byte FMaxZoom;
	System::Byte FMinZoom;
	
public:
	__fastcall TNativeMapObserver();
	void __fastcall Send(const unsigned msg, System::TObject* WParam = (System::TObject*)(0x0));
	__property System::Classes::TNotifyEvent OnMapFree = {read=FOnMapFree, write=FOnMapFree};
	__property System::Classes::TNotifyEvent OnMapHiResChange = {read=FOnMapHiResChange, write=FOnMapHiResChange};
	__property System::Classes::TNotifyEvent OnMapActiveChange = {read=FOnMapActiveChange, write=FOnMapActiveChange};
	__property System::Classes::TNotifyEvent OnMapAnimation = {read=FOnMapAnimation, write=FOnMapAnimation};
	__property System::Classes::TNotifyEvent OnMapResize = {read=FOnMapResize, write=FOnMapResize};
	__property System::Classes::TNotifyEvent OnMapRotation = {read=FOnMapRotation, write=FOnMapRotation};
	__property System::Classes::TNotifyEvent OnMapStartMove = {read=FOnMapStartMove, write=FOnMapStartMove};
	__property System::Classes::TNotifyEvent OnMapMove = {read=FOnMapMove, write=FOnMapMove};
	__property System::Classes::TNotifyEvent OnMapMouseMove = {read=FOnMapMouseMove, write=FOnMapMouseMove};
	__property System::Classes::TNotifyEvent OnMapMouseStop = {read=FOnMapMouseStop, write=FOnMapMouseStop};
	__property System::Classes::TNotifyEvent OnMapMouseDown = {read=FOnMapMouseDown, write=FOnMapMouseDown};
	__property System::Classes::TNotifyEvent OnMapMouseUp = {read=FOnMapMouseUp, write=FOnMapMouseUp};
	__property System::Classes::TNotifyEvent OnMapMouseClick = {read=FOnMapMouseClick, write=FOnMapMouseClick};
	__property System::Classes::TNotifyEvent OnMapEndMove = {read=FOnMapEndMove, write=FOnMapEndMove};
	__property System::Classes::TNotifyEvent OnMapzoom = {read=FOnMapZoom, write=FOnMapZoom};
	__property System::Classes::TNotifyEvent OnMapLoad = {read=FOnMapLoad, write=FOnMapLoad};
	__property System::Classes::TNotifyEvent OnMapFocus = {read=FOnMapFocus, write=FOnMapFocus};
	__property System::Classes::TNotifyEvent OnMapBounds = {read=FOnMapBounds, write=FOnMapBounds};
	__property System::Classes::TNotifyEvent OnMapChangeBounds = {read=FOnMapChangeBounds, write=FOnMapChangeBounds};
	__property System::Classes::TNotifyEvent OnMapCompletetiles = {read=FOnMapCompleteTiles, write=FOnMapCompleteTiles};
	__property System::Classes::TNotifyEvent OnMapTileServer = {read=FOnMapTileServer, write=FOnMapTileServer};
	__property System::Classes::TNotifyEvent OnMapAddRoute = {read=FOnMapAddRoute, write=FOnMapAddRoute};
	__property System::Classes::TNotifyEvent OnMapErrorRoute = {read=FOnMapErrorRoute, write=FOnMapErrorRoute};
	__property System::Classes::TNotifyEvent OnMapChangeRoute = {read=FOnMapChangeRoute, write=FOnMapChangeRoute};
	__property System::Classes::TNotifyEvent OnMapPaint = {read=FOnMapPaint, write=FOnMapPaint};
	__property System::Classes::TNotifyEvent OnShapesPaint = {read=FOnShapesPaint, write=FOnShapesPaint};
	__property System::Classes::TNotifyEvent OnMapShapeDescription = {read=FOnMapShapeDescription, write=FOnMapShapeDescription};
	__property System::Classes::TNotifyEvent OnMapShapeProperties = {read=FOnMapShapeProperties, write=FOnMapShapeProperties};
	__property System::Classes::TNotifyEvent OnMapShapeHint = {read=FOnMapShapeHint, write=FOnMapShapeHint};
	__property System::Classes::TNotifyEvent OnMapShapeClick = {read=FOnMapShapeClick, write=FOnMapShapeClick};
	__property System::Classes::TNotifyEvent OnMapShapeLongClick = {read=FOnMapShapeLongClick, write=FOnMapShapeLongClick};
	__property System::Classes::TNotifyEvent OnMapShapeLongPress = {read=FOnMapShapeLongPress, write=FOnMapShapeLongPress};
	__property System::Classes::TNotifyEvent OnMapShapeOverIntent = {read=FOnMapShapeOverIntent, write=FOnMapShapeOverIntent};
	__property System::Classes::TNotifyEvent OnMapShapeMove = {read=FOnMapShapeMove, write=FOnMapShapeMove};
	__property System::Classes::TNotifyEvent OnMapShapeDblClick = {read=FOnMapShapeDblClick, write=FOnMapShapeDblClick};
	__property System::Classes::TNotifyEvent OnMapShapeMouseDown = {read=FOnMapShapeMouseDown, write=FOnMapShapeMouseDown};
	__property System::Classes::TNotifyEvent OnMapShapeMouseUp = {read=FOnMapShapeMouseUp, write=FOnMapShapeMouseUp};
	__property System::Classes::TNotifyEvent OnMapShapeMouseOut = {read=FOnMapShapeMouseOut, write=FOnMapShapeMouseOut};
	__property System::Classes::TNotifyEvent OnMapShapeMouseOver = {read=FOnMapShapeMouseOver, write=FOnMapShapeMouseOver};
	__property System::Classes::TNotifyEvent OnMapShapeDragStart = {read=FOnMapShapeDragStart, write=FOnMapShapeDragStart};
	__property System::Classes::TNotifyEvent OnMapShapeDrag = {read=FOnMapShapeDrag, write=FOnMapShapeDrag};
	__property System::Classes::TNotifyEvent OnMapShapeDragEnd = {read=FOnMapShapeDragEnd, write=FOnMapShapeDragEnd};
	__property System::Classes::TNotifyEvent OnMapShapePathChange = {read=FOnMapShapePathChange, write=FOnMapShapePathChange};
	__property System::Classes::TNotifyEvent OnMapShapeRightClick = {read=FOnMapShapeRightClick, write=FOnMapShapeRightClick};
	__property System::Classes::TNotifyEvent OnMapShapesChange = {read=FOnMapShapesChange, write=FOnMapShapesChange};
	__property System::Classes::TNotifyEvent OnMapShapesOSMLoad = {read=FOnMapShapesOSMLoad, write=FOnMapShapesOSMLoad};
	__property System::Classes::TNotifyEvent OnMapScreenShoots = {read=FOnMapScreenShots, write=FOnMapScreenShots};
	__property System::Classes::TNotifyEvent OnMapfitBounds = {read=FOnMapFitBounds, write=FOnMapFitBounds};
	__property System::Classes::TNotifyEvent OnMapLoadGraphic = {read=FOnMapLoadGraphic, write=FOnMapLoadGraphic};
	__property bool MapFree = {read=FMapFree, nodefault};
	__property System::Byte MaxZoom = {read=FMaxZoom, write=FMaxZoom, nodefault};
	__property System::Byte MinZoom = {read=FMinZoom, write=FMinZoom, nodefault};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TNativeMapObserver() { }
	
};


typedef System::DynamicArray<System::Byte> Fmx_Uecmaputil__11;

typedef System::DynamicArray<System::DynamicArray<System::Byte> > TArrayOfArrayOfByte;

typedef System::DynamicArray<Fmx::Graphics::TBitmap*> Fmx_Uecmaputil__21;

typedef System::DynamicArray<System::DynamicArray<Fmx::Graphics::TBitmap*> > TArrayOfArrayOfGraphic;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TDisplayMapTiles : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TArrayOfArrayOfByte FDisplay;
	TArrayOfArrayOfGraphic FTiles;
	int FTileSize;
	int FX;
	int FY;
	int FWidth;
	int FHeight;
	int FX0;
	int FY0;
	int FW0;
	int FH0;
	bool FEnabled;
	System::Syncobjs::TCriticalSection* FLock;
	
public:
	__fastcall TDisplayMapTiles();
	__fastcall virtual ~TDisplayMapTiles();
	void __fastcall Lock();
	void __fastcall unlock();
	bool __fastcall isTileSet();
	bool __fastcall isTileShow();
	void __fastcall ScrollTo(const int x, const int y);
	void __fastcall setSize(const int w, const int h);
	void __fastcall setTile(const int _x, const int _y, System::Byte tile);
	System::Byte __fastcall getTile(const int _x, const int _y);
	void __fastcall setGroupTile(const int _x, const int _y, System::Byte tile);
	bool __fastcall isTileXYVisible(const int tx, const int ty);
	void __fastcall Clear();
	void __fastcall ClearDisplay();
	void __fastcall Init();
	void __fastcall Show();
	__property TArrayOfArrayOfByte Display = {read=FDisplay};
	__property TArrayOfArrayOfGraphic tile = {read=FTiles};
	__property int x = {read=FX, write=FX, nodefault};
	__property int y = {read=FY, write=FY, nodefault};
	__property int x0 = {read=FX0, write=FX0, nodefault};
	__property int y0 = {read=FY0, write=FY0, nodefault};
	__property int w0 = {read=FW0, write=FW0, nodefault};
	__property int h0 = {read=FH0, write=FH0, nodefault};
	__property bool Enabled = {read=FEnabled, write=FEnabled, nodefault};
	__property int TileSize = {read=FTileSize, write=FTileSize, nodefault};
};

#pragma pack(pop)

enum DECLSPEC_DENUM TTileServerEarthType : unsigned char { etUnknown, etSphere, etEllipsoid };

enum DECLSPEC_DENUM TPointRounding : unsigned char { prUseRound, prUseFloor, prUseCeil, prUseTrunc };

struct DECLSPEC_DRECORD TDoublePoint
{
public:
	double x;
	double y;
};


#pragma pack(push,1)
struct DECLSPEC_DRECORD TDoubleArea
{
	
public:
	union
	{
		struct 
		{
			TDoublePoint TopLeft;
			TDoublePoint BottomRight;
		};
		struct 
		{
			double Left;
			double Top;
			double Right;
			double Bottom;
		};
		
	};
};
#pragma pack(pop)


typedef System::StaticArray<TDoublePoint, 4> TArrayDoublePoint4;

class PASCALIMPLEMENTATION TECTilesCoordinatesConverter : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	double FEarthSemiMajorAxis;
	double FEarthSemiMinorAxis;
	double FEcntrMajor;
	TTileServerEarthType FEarthType;
	int FTileSize;
	void __fastcall SetTileSize(int AValue);
	void __fastcall SetEarthDimentions(const TDoublePoint &AValue);
	TDoublePoint __fastcall GetEarthDimentions();
	void __fastcall SetEarthType(TTileServerEarthType AValue);
	double __fastcall GetEcntrMajor();
	System::Byte __fastcall CheckZoomLevelInternal(int AZoomLevel, bool RaiseErrors = true);
	void __fastcall CheckTilePosition(Winapi::Windows::TPoint &APos, System::Byte &VZoomLevel);
	System::LongWord __fastcall GetTilesAtZoom(System::Byte AZoomLevel);
	TDoublePoint __fastcall EllLatLonToRelative(const TDoublePoint &P);
	TDoublePoint __fastcall RelativeToEllLatLon(const TDoublePoint &P);
	TDoublePoint __fastcall RelativeToSphLatLon(const TDoublePoint &P);
	TDoublePoint __fastcall SphLatLonToRelative(const TDoublePoint &P);
	TDoublePoint __fastcall RelativeToTilePos(const TDoublePoint &P, System::Byte AZoomLevel);
	TDoublePoint __fastcall TilePosToRelative(const TDoublePoint &ATileAddress, System::Byte AZoomLevel);
	TDoubleArea __fastcall TilePosToRelativeRect(const Winapi::Windows::TPoint &P, System::Byte AZoom);
	TDoublePoint __fastcall TileNumber2LonLat(const TDoublePoint &P, System::Byte AZoomLevel, TTileServerEarthType AEarthType);
	double __fastcall CalcResolutionAtZoomLevelInMeters(int AZoomLevel, int ADpi, double ALat, double ASemiMajor);
	System::Byte __fastcall CalcZoomLevel(int AScreenSize, int AWorldSize, double AFraction);
	
public:
	__fastcall TECTilesCoordinatesConverter(const double ASemiMajor, const double ASemiMinor, TTileServerEarthType AEarthType, int ATileSize)/* overload */;
	System::Byte __fastcall CheckZoomLevel(int AZoomLevel);
	System::Byte __fastcall GetOptimalZoomLevelByBounds(const TArrayDoublePoint4 &AMapArea)/* overload */;
	System::Byte __fastcall GetOptimalZoomLevelByBounds(const TArrayDoublePoint4 &AMapArea, TTileServerEarthType AEarthType, const Winapi::Windows::TRect &AScreenSize, int ADpi)/* overload */;
	double __fastcall GetResolutionAtZoomLevel(int AZoomLevel, int ADpi = 0x60, double ALat = 0.000000E+00, double ASemiMajor = 6.378137E+06);
	System::LongInt __fastcall GetPixelsAtZoomLevel(System::Byte AZoomLevel);
	double __fastcall GetPixelsAtZoomLevelDouble(System::Byte AZoomLevel);
	Winapi::Windows::TPoint __fastcall GetTilePosByLatLonPos(const TDoublePoint &P, System::Byte AZoomLevel, TTileServerEarthType AEarthType);
	TDoublePoint __fastcall LonLat2TileNumber(const TDoublePoint &P, System::Byte AZoomLevel, TTileServerEarthType AEarthType);
	TDoublePoint __fastcall DegreesToCartesian(const TDoublePoint &P)/* overload */;
	TDoublePoint __fastcall DegreesToCartesian(const TDoublePoint &P, const double ASemiMajor, const double AEcntrMajorSqrt)/* overload */;
	TDoublePoint __fastcall CartesianToDegrees(const TDoublePoint &P)/* overload */;
	TDoublePoint __fastcall CartesianToDegrees(const TDoublePoint &P, const double ASemiMajor, const double AEcntrMajorSqrt)/* overload */;
	TDoublePoint __fastcall RelativeToDegrees(const TDoublePoint &P, TTileServerEarthType AEarthType);
	TDoublePoint __fastcall DegreesToRelative(const TDoublePoint &P, TTileServerEarthType AEarthType);
	TDoublePoint __fastcall GetTileOrigin(const Winapi::Windows::TPoint &P, System::Byte AZoomLevel, TTileServerEarthType AEarthType)/* overload */;
	TDoublePoint __fastcall GetTileOrigin(const TDoublePoint &P, System::Byte AZoomLevel, TTileServerEarthType AEarthType)/* overload */;
	TDoublePoint __fastcall GetTileNumberByLonLat(const TDoublePoint &P, System::Byte AZoomLevel, TTileServerEarthType AEarthType);
	TDoubleArea __fastcall GetTileBounds(const Winapi::Windows::TPoint &P, System::Byte AZoomLevel, TTileServerEarthType AEarthType);
	Winapi::Windows::TRect __fastcall LatLonRectToTilesRectExt(const TDoubleArea &Area, System::Byte AZoomLevel, TTileServerEarthType AEarthType);
	Winapi::Windows::TRect __fastcall LatLonRectToTilesRect(const TDoubleArea &Area, System::Byte AZoomLevel);
	TDoubleArea __fastcall LatLonRectToTilesRectDoubleExt(const TDoubleArea &Area, System::Byte AZoomLevel, TTileServerEarthType AEarthType);
	TDoubleArea __fastcall LatLonRectToTilesRectDouble(const TDoubleArea &Area, System::Byte AZoomLevel);
	TDoubleArea __fastcall TilesRectToLatLonRect(const Winapi::Windows::TRect &Area, System::Byte AZoomLevel, TTileServerEarthType AEarthType);
	double __fastcall CalcTrueScaleAtZoomLevel(const TArrayDoublePoint4 &AArea, double ASemiMajor, int AZoomLevel, int ADpi)/* overload */;
	double __fastcall CalcTrueScaleAtZoomLevel(double ALat, double ASemiMajor, int AZoomLevel, int ADpi)/* overload */;
	double __fastcall CalcScaleAtZoomLevel(double ASemiMajor, int AZoomLevel, int ADpi);
	TDoublePoint __fastcall PixelPos2RelativePos(const Winapi::Windows::TPoint &XY, System::Byte AZoom)/* overload */;
	TDoublePoint __fastcall PixelPos2RelativePos(const TDoublePoint &XY, System::Byte AZoom)/* overload */;
	TDoublePoint __fastcall PixelPos2RelativePos(const System::Types::TPointF &XY, System::Byte AZoom)/* overload */;
	TDoublePoint __fastcall Relative2PixelPos(const TDoublePoint &XY, System::Byte AZoom);
	TDoublePoint __fastcall PixelsToDegrees(const Winapi::Windows::TPoint &APnt, System::Byte AZoomLevel, TTileServerEarthType AEarthType);
	TDoublePoint __fastcall PixelsToDegreesD(const TDoublePoint &APnt, System::Byte AZoomLevel, TTileServerEarthType AEarthType);
	TDoublePoint __fastcall PixelsToDegreesF(const System::Types::TPointF &APnt, System::Byte AZoomLevel, TTileServerEarthType AEarthType);
	TDoublePoint __fastcall DegreesToPixels(const TDoublePoint &APnt, System::Byte AZoomLevel, TTileServerEarthType AEarthType);
	System::Types::TPointF __fastcall DegreesToPixelsF(const TDoublePoint &APnt, System::Byte AZoomLevel, TTileServerEarthType AEarthType);
	__property int TileSize = {read=FTileSize, write=SetTileSize, nodefault};
	__property TDoublePoint EarthDimentions = {read=GetEarthDimentions, write=SetEarthDimentions};
	__property double EarthEcntrMajor = {read=GetEcntrMajor};
	__property TTileServerEarthType EarthType = {read=FEarthType, write=SetEarthType, nodefault};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECTilesCoordinatesConverter() { }
	
};


struct DECLSPEC_DRECORD TIntPoint
{
public:
	__int64 x;
	__int64 y;
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TStringDataCache : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FData;
	unsigned FTime;
public:
	/* TObject.Create */ inline __fastcall TStringDataCache() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TStringDataCache() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TStringDataCacheList : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	unsigned FTimeMinutValid;
	System::Classes::TStringList* FList;
	System::UnicodeString __fastcall getData(const System::UnicodeString Index);
	void __fastcall setData(const System::UnicodeString Index, const System::UnicodeString Value);
	
public:
	__fastcall TStringDataCacheList(unsigned FMinutValid);
	__fastcall virtual ~TStringDataCacheList();
	__property System::UnicodeString Data[const System::UnicodeString index] = {read=getData, write=setData};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECWorldInfo : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TOnProjectionLatLngToXY FOnProjectionLatLngToXY;
	TOnProjectionXYToLatLng FOnProjectionXYToLatLng;
	TOnConversionESPG FOnConversionESPG;
	TOnConversionESPG FOnConversionESPGToLatLng;
	TOnWorldMoveTo FOnWorldMoveTo;
	bool FDragRect;
	bool FInGesture;
	bool FInClick;
	double FMax_Latitude;
	double FMax_longitude;
	double FMin_Latitude;
	double FMin_longitude;
	double FNorthEastLatitude;
	double FNorthEastLongitude;
	double FSouthWestLatitude;
	double FSouthWestLongitude;
	__int64 FTickMove;
	bool FChangeBounds;
	bool FChangeProjection;
	int FTileNX;
	int FTileNY;
	int FTileSX;
	int FTileSY;
	__int64 FMoveLeft;
	__int64 FMoveTop;
	__int64 FTop;
	__int64 FLeft;
	int FMaxTileSize;
	int FTileSize;
	int FScaleTileSize;
	int FDeltaWidth;
	int FDeltaHeight;
	int FTrueWidth;
	int FTrueHeight;
	int FWidth;
	int FHeight;
	float FScreenScale;
	float FScale;
	float FRotationAngle;
	__int64 FMaxXY;
	double FPrevRes;
	double FPrevLat;
	double FPrevLng;
	double FRes;
	int FPrevX;
	int FPrevY;
	System::Byte FMaxZoom;
	System::Byte FMinZoom;
	System::Byte FZoom;
	System::Byte FNextZoom;
	int FZoomScaleFactor;
	double FZoomAnimScale;
	int FMouseX;
	int FMouseY;
	double FMouseLat;
	double FMouseLng;
	double FAltitude;
	__int64 FTick;
	System::Syncobjs::TCriticalSection* FLock;
	void __fastcall setZoom(const System::Byte Value);
	void __fastcall SetTileSize(const int Value);
	void __fastcall LatLngToESPG_3857(double &Lat, double &Lng);
	void __fastcall ESPG_3857ToLatLng(double &lat, double &lng);
	
public:
	__fastcall TECWorldInfo();
	__fastcall virtual ~TECWorldInfo();
	void __fastcall Lock();
	void __fastcall unlock();
	void __fastcall LatLngToESPG(double &Lat, double &Lng, const int ESPG);
	void __fastcall ESPGToLatLng(double &Lat, double &Lng, const int ESPG);
	void __fastcall MoveTo(const double Lat, const double Lng);
	void __fastcall LatLngToXY(const double Lat, const double Lng, int &x, int &y);
	void __fastcall LatLngToWorldXY(const double Lat, const double Lng, int &x, int &y);
	void __fastcall XYToLatLng(const int x, const int y, double &Lat, double &Lng);
	void __fastcall WorldXYToLatLng(const int WorldX, const int WorldY, double &Lat, double &Lng);
	bool __fastcall ContainsLatLng(const double dLatitude, const double dLongitude);
	int __fastcall MeterToPixel(const int meter, const double latitude);
	double __fastcall PixelToMeter(const int Pixels, const double latitude, const int adigit = 0xfffffffe);
	void __fastcall AlignToTiles(const double Lat, const double Lng, double &AlignedLat, double &AlignedLng, TAnchorPosition AnchorPosition = (TAnchorPosition)(0x0));
	__property bool ChangeProjection = {read=FChangeProjection, write=FChangeProjection, nodefault};
	__property __int64 Left = {read=FLeft, write=FLeft};
	__property __int64 Top = {read=FTop, write=FTop};
	__property __int64 MoveLeft = {read=FMoveLeft, write=FMoveLeft};
	__property __int64 MoveTop = {read=FMoveTop, write=FMoveTop};
	__property int Width = {read=FWidth, write=FWidth, nodefault};
	__property int Height = {read=FHeight, write=FHeight, nodefault};
	__property int TrueWidth = {read=FTrueWidth, write=FTrueWidth, nodefault};
	__property int TrueHeight = {read=FTrueHeight, write=FTrueHeight, nodefault};
	__property int DeltaWidth = {read=FDeltaWidth, write=FDeltaWidth, nodefault};
	__property int DeltaHeight = {read=FDeltaHeight, write=FDeltaHeight, nodefault};
	__property int TileSX = {read=FTileSX, write=FTileSX, nodefault};
	__property int TileSY = {read=FTileSY, write=FTileSY, nodefault};
	__property int TileNX = {read=FTileNX, write=FTileNX, nodefault};
	__property int TileNY = {read=FTileNY, write=FTileNY, nodefault};
	__property bool ChangeBounds = {read=FChangeBounds, write=FChangeBounds, nodefault};
	__property double MouseLat = {read=FMouseLat, write=FMouseLat};
	__property double MouseLng = {read=FMouseLng, write=FMouseLng};
	__property int MouseX = {read=FMouseX, write=FMouseX, nodefault};
	__property int MouseY = {read=FMouseY, write=FMouseY, nodefault};
	__property double Res = {read=FRes};
	__property double ZoomAnimScale = {read=FZoomAnimScale, write=FZoomAnimScale};
	__property double NorthEastLatitude = {read=FNorthEastLatitude, write=FNorthEastLatitude};
	__property double NorthEastLongitude = {read=FNorthEastLongitude, write=FNorthEastLongitude};
	__property double SouthWestLatitude = {read=FSouthWestLatitude, write=FSouthWestLatitude};
	__property double SouthWestLongitude = {read=FSouthWestLongitude, write=FSouthWestLongitude};
	__property bool DragRect = {read=FDragRect, write=FDragRect, nodefault};
	__property bool InClick = {read=FInClick, write=FInClick, nodefault};
	__property bool InGesture = {read=FInGesture, write=FInGesture, nodefault};
	__property double _Max_Latitude = {read=FMax_Latitude, write=FMax_Latitude};
	__property double _Max_longitude = {read=FMax_longitude, write=FMax_longitude};
	__property double _Min_Latitude = {read=FMin_Latitude, write=FMin_Latitude};
	__property double _Min_longitude = {read=FMin_longitude, write=FMin_longitude};
	__property float Scale = {read=FScale, write=FScale};
	__property System::Byte Zoom = {read=FZoom, write=setZoom, nodefault};
	__property System::Byte NextZoom = {read=FNextZoom, write=FNextZoom, nodefault};
	__property System::Byte MaxZoom = {read=FMaxZoom, write=FMaxZoom, nodefault};
	__property System::Byte MinZoom = {read=FMinZoom, write=FMinZoom, nodefault};
	__property int ZoomScaleFactor = {read=FZoomScaleFactor, write=FZoomScaleFactor, nodefault};
	__property double Altitude = {read=FAltitude, write=FAltitude};
	__property float RotationAngle = {read=FRotationAngle, write=FRotationAngle};
	__property __int64 Tick = {read=FTick, write=FTick};
	__property __int64 TickMove = {read=FTickMove, write=FTickMove};
	__property int TileSize = {read=FTileSize, write=SetTileSize, nodefault};
	__property int MaxTileSize = {read=FMaxTileSize, nodefault};
	__property int ScaleTileSize = {read=FScaleTileSize, write=FScaleTileSize, nodefault};
	__property float ScreenScale = {read=FScreenScale, write=FScreenScale};
	__property TOnWorldMoveTo OnWorldMoveTo = {read=FOnWorldMoveTo, write=FOnWorldMoveTo};
	__property TOnProjectionLatLngToXY OnProjectionLatLngToXY = {read=FOnProjectionLatLngToXY, write=FOnProjectionLatLngToXY};
	__property TOnProjectionXYToLatLng OnProjectionXYToLatLng = {read=FOnProjectionXYToLatLng, write=FOnProjectionXYToLatLng};
	__property TOnConversionESPG OnConversionESPG = {read=FOnConversionESPG, write=FOnConversionESPG};
	__property TOnConversionESPG OnConversionESPGToLatLng = {read=FOnConversionESPGToLatLng, write=FOnConversionESPGToLatLng};
};


class PASCALIMPLEMENTATION TFStringList : public System::Classes::TStringList
{
	typedef System::Classes::TStringList inherited;
	
public:
	virtual int __fastcall IndexOf(const System::UnicodeString S);
	virtual bool __fastcall Find(const System::UnicodeString S, int &Index);
	int __fastcall SubIndexOf(const System::UnicodeString S);
	virtual System::UnicodeString __fastcall Get(int Index);
public:
	/* TStringList.Create */ inline __fastcall TFStringList()/* overload */ : System::Classes::TStringList() { }
	/* TStringList.Create */ inline __fastcall TFStringList(bool OwnsObjects)/* overload */ : System::Classes::TStringList(OwnsObjects) { }
	/* TStringList.Create */ inline __fastcall TFStringList(System::WideChar QuoteChar, System::WideChar Delimiter)/* overload */ : System::Classes::TStringList(QuoteChar, Delimiter) { }
	/* TStringList.Create */ inline __fastcall TFStringList(System::WideChar QuoteChar, System::WideChar Delimiter, System::Classes::TStringsOptions Options)/* overload */ : System::Classes::TStringList(QuoteChar, Delimiter, Options) { }
	/* TStringList.Create */ inline __fastcall TFStringList(System::Classes::TDuplicates Duplicates, bool Sorted, bool CaseSensitive)/* overload */ : System::Classes::TStringList(Duplicates, Sorted, CaseSensitive) { }
	/* TStringList.Destroy */ inline __fastcall virtual ~TFStringList() { }
	
};


class PASCALIMPLEMENTATION TThreadedTimer : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	bool FPause;
	bool _FTerminated;
	System::Syncobjs::TEvent* FEventPause;
	System::Syncobjs::TEvent* FEvent;
	unsigned FInterval;
	System::Classes::TNotifyEvent FOnTimer;
	void __fastcall setPause(const bool Value);
	void __fastcall setInterval(const unsigned Value);
	
protected:
	virtual void __fastcall Execute();
	void __fastcall DoTimer();
	
public:
	__fastcall TThreadedTimer(bool ACreateSuspended, unsigned AInterval);
	__fastcall virtual ~TThreadedTimer();
	void __fastcall doTermine();
	__property Terminated;
	__property System::Classes::TNotifyEvent OnTimer = {read=FOnTimer, write=FOnTimer};
	__property bool Pause = {read=FPause, write=setPause, nodefault};
	__property unsigned Interval = {read=FInterval, write=setInterval, nodefault};
};


class PASCALIMPLEMENTATION TInternalStringList : public System::Classes::TStringList
{
	typedef System::Classes::TStringList inherited;
	
public:
	virtual bool __fastcall Find(const System::UnicodeString S, int &Index);
	virtual int __fastcall IndexOf(const System::UnicodeString S);
public:
	/* TStringList.Create */ inline __fastcall TInternalStringList()/* overload */ : System::Classes::TStringList() { }
	/* TStringList.Create */ inline __fastcall TInternalStringList(bool OwnsObjects)/* overload */ : System::Classes::TStringList(OwnsObjects) { }
	/* TStringList.Create */ inline __fastcall TInternalStringList(System::WideChar QuoteChar, System::WideChar Delimiter)/* overload */ : System::Classes::TStringList(QuoteChar, Delimiter) { }
	/* TStringList.Create */ inline __fastcall TInternalStringList(System::WideChar QuoteChar, System::WideChar Delimiter, System::Classes::TStringsOptions Options)/* overload */ : System::Classes::TStringList(QuoteChar, Delimiter, Options) { }
	/* TStringList.Create */ inline __fastcall TInternalStringList(System::Classes::TDuplicates Duplicates, bool Sorted, bool CaseSensitive)/* overload */ : System::Classes::TStringList(Duplicates, Sorted, CaseSensitive) { }
	/* TStringList.Destroy */ inline __fastcall virtual ~TInternalStringList() { }
	
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TThreadStringList : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::UnicodeString operator[](const int Index) { return this->Strings[Index]; }
	
private:
	bool FLocked;
	TInternalStringList* FStringList;
	System::Syncobjs::TCriticalSection* FLock;
	System::Classes::TDuplicates __fastcall GetDuplicates();
	void __fastcall SetDuplicates(System::Classes::TDuplicates dup);
	int __fastcall GetCapacity();
	void __fastcall SetCapacity(int capa);
	System::UnicodeString __fastcall GetCommaText();
	void __fastcall SetCommaText(const System::UnicodeString S);
	int __fastcall GetCount();
	System::WideChar __fastcall GetDelimiter();
	void __fastcall SetDelimiter(System::WideChar delim);
	System::UnicodeString __fastcall GetDelimitedText();
	void __fastcall SetDelimitedText(const System::UnicodeString S);
	System::UnicodeString __fastcall GetNames(int Index);
	System::UnicodeString __fastcall GetValues(const System::UnicodeString Name);
	void __fastcall SetValues(const System::UnicodeString Name, const System::UnicodeString S);
	System::UnicodeString __fastcall GetStrings(const int Index);
	void __fastcall SetStrings(const int Index, const System::UnicodeString S);
	System::UnicodeString __fastcall GetAsText();
	void __fastcall SetAsText(const System::UnicodeString S);
	System::TObject* __fastcall GetObjects(int Index);
	void __fastcall SetObjects(int Index, System::TObject* const o);
	
public:
	__fastcall TThreadStringList();
	__fastcall virtual ~TThreadStringList();
	System::Classes::TStringList* __fastcall LockList();
	void __fastcall UnlockList();
	int __fastcall Add(const System::UnicodeString S);
	int __fastcall AddObject(const System::UnicodeString S, System::TObject* const o);
	System::TObject* __fastcall FindObject(const System::UnicodeString S, const bool MoveOnTop, const int LimitFromMove)/* overload */;
	System::TObject* __fastcall FindObject(const System::UnicodeString S)/* overload */;
	void __fastcall AddStrings(System::Classes::TStrings* Strings);
	void __fastcall Delete(int Index);
	void __fastcall Clear();
	void __fastcall Exchange(int Index1, int Index2);
	virtual bool __fastcall Find(const System::UnicodeString S, int &Index);
	void __fastcall Insert(int Index, const System::UnicodeString S);
	void __fastcall InsertObject(int Index, const System::UnicodeString S, System::TObject* const o);
	int __fastcall IndexOf(const System::UnicodeString S);
	bool __fastcall ExistsAndMovetoTop(const System::UnicodeString S);
	int __fastcall IndexOfName(const System::UnicodeString Name);
	int __fastcall IndexOfObject(System::TObject* const o);
	void __fastcall Sort();
	System::WideChar * __fastcall GetText();
	void __fastcall LoadFromFile(const System::UnicodeString Filename);
	void __fastcall LoadFromStream(System::Classes::TStream* stream);
	void __fastcall SaveToFile(const System::UnicodeString Filename);
	void __fastcall SaveToStream(System::Classes::TStream* stream);
	__property System::Classes::TDuplicates Duplicates = {read=GetDuplicates, write=SetDuplicates, nodefault};
	__property int Capacity = {read=GetCapacity, write=SetCapacity, nodefault};
	__property System::UnicodeString CommaText = {read=GetCommaText, write=SetCommaText};
	__property int Count = {read=GetCount, nodefault};
	__property System::WideChar Delimiter = {read=GetDelimiter, write=SetDelimiter, nodefault};
	__property System::UnicodeString DelimitedText = {read=GetDelimitedText, write=SetDelimitedText};
	__property System::UnicodeString Names[int Index] = {read=GetNames};
	__property System::TObject* Objects[int Index] = {read=GetObjects, write=SetObjects};
	__property System::UnicodeString Values[const System::UnicodeString Name] = {read=GetValues, write=SetValues};
	__property System::UnicodeString Strings[const int Index] = {read=GetStrings, write=SetStrings/*, default*/};
	__property System::UnicodeString Text = {read=GetAsText, write=SetAsText};
	__property bool Locked = {read=FLocked, nodefault};
};

#pragma pack(pop)

typedef TThreadStringList TCacheStringObject;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TecNotifyMessage : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	unsigned msg;
	bool Abort;
	System::TObject* WParam;
	System::TObject* LParam;
public:
	/* TObject.Create */ inline __fastcall TecNotifyMessage() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TecNotifyMessage() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TEcNotify : public System::Classes::TStringList
{
	typedef System::Classes::TStringList inherited;
	
private:
	System::Classes::TNotifyEvent FOnLocationChange;
	System::Classes::TNotifyEvent FOnPanTo;
	System::Classes::TNotifyEvent FOnCenter;
	System::Classes::TNotifyEvent FOnShowHint;
	System::Classes::TNotifyEvent FonFitBounds;
	System::Classes::TNotifyEvent FOnRepaint;
	System::Classes::TNotifyEvent FOnBounds;
	System::Classes::TNotifyEvent FOnHidehint;
	System::Classes::TNotifyEvent FOnLoad;
	System::Classes::TNotifyEvent FOnDirection;
	System::Classes::TNotifyEvent FOnReload;
	System::Classes::TNotifyEvent FOnShowAll;
	System::Classes::TNotifyEvent FOnSetRotation;
	System::Classes::TNotifyEvent FOnFocus;
	bool FInNotifyMessage;
	
public:
	__fastcall TEcNotify();
	__fastcall virtual ~TEcNotify();
	virtual void __fastcall Clear();
	void __fastcall Remove(System::TObject* WParam);
	void __fastcall NotifyMessage(unsigned MsgConst, System::TObject* WParam = (System::TObject*)(0x0), System::TObject* LParam = (System::TObject*)(0x0));
	void __fastcall PumpMessage();
	__property System::Classes::TNotifyEvent OnRepaint = {read=FOnRepaint, write=FOnRepaint};
	__property System::Classes::TNotifyEvent OnFitBounds = {read=FonFitBounds, write=FonFitBounds};
	__property System::Classes::TNotifyEvent OnShowHint = {read=FOnShowHint, write=FOnShowHint};
	__property System::Classes::TNotifyEvent OnPanTo = {read=FOnPanTo, write=FOnPanTo};
	__property System::Classes::TNotifyEvent OnShowAll = {read=FOnShowAll, write=FOnShowAll};
	__property System::Classes::TNotifyEvent OnSetRotation = {read=FOnSetRotation, write=FOnSetRotation};
	__property System::Classes::TNotifyEvent OnBounds = {read=FOnBounds, write=FOnBounds};
	__property System::Classes::TNotifyEvent OnHidehint = {read=FOnHidehint, write=FOnHidehint};
	__property System::Classes::TNotifyEvent OnLoad = {read=FOnLoad, write=FOnLoad};
	__property System::Classes::TNotifyEvent OnFocus = {read=FOnFocus, write=FOnFocus};
	__property System::Classes::TNotifyEvent OnDirection = {read=FOnDirection, write=FOnDirection};
	__property System::Classes::TNotifyEvent OnReload = {read=FOnReload, write=FOnReload};
	__property System::Classes::TNotifyEvent OnCenter = {read=FOnCenter, write=FOnCenter};
	__property System::Classes::TNotifyEvent OnLocationChange = {read=FOnLocationChange, write=FOnLocationChange};
};


//-- var, const, procedure ---------------------------------------------------
#define MSG_INCOMPLETE_DATA L"incomplete data"
#define _LABELS_AUTHORIZED L"_ect_label"
static const System::Word WM_EC_REPAINT = System::Word(0xbd0);
static const System::Word WM_EC_BOUNDS = System::Word(0xbd1);
static const System::Word WM_EC_HIDEHINT = System::Word(0xbd2);
static const System::Word WM_EC_ONLOAD = System::Word(0xbd3);
static const System::Word WM_EC_ONDIRECTION = System::Word(0xbd4);
static const System::Word WM_EC_FITBOUNDS = System::Word(0xbd5);
static const System::Word WM_SUBJECT_FREE = System::Word(0xbd6);
static const System::Word WM_SUBJECT_MOVE = System::Word(0xbd7);
static const System::Word WM_SUBJECT_BOUNDS = System::Word(0xbd8);
static const System::Word WM_SUBJECT_RESIZE = System::Word(0xbd9);
static const System::Word WM_SUBJECT_ZOOM = System::Word(0xbda);
static const System::Word WM_SUBJECT_TILESERVER = System::Word(0xbdb);
static const System::Word WM_SUBJECT_ADDROUTE = System::Word(0xbdc);
static const System::Word WM_SUBJECT_ERRORROUTE = System::Word(0xbdd);
static const System::Word WM_SUBJECT_CHANGEROUTE = System::Word(0xbde);
static const System::Word WM_SUBJECT_PAINT = System::Word(0xbdf);
static const System::Word WM_SUBJECT_STARTMOVE = System::Word(0xbe0);
static const System::Word WM_SUBJECT_ENDMOVE = System::Word(0xbe1);
static const System::Word WM_SUBJECT_ROTATION = System::Word(0xbe2);
static const System::Word WM_SUBJECT_MOUSEMOVE = System::Word(0xbe3);
static const System::Word WM_SUBJECT_MOUSECLICK = System::Word(0xbe4);
static const System::Word WM_SUBJECT_ANIMATION = System::Word(0xbe5);
static const System::Word WM_SUBJECT_SHAPECLICK = System::Word(0xbe6);
static const System::Word WM_SUBJECT_SHAPERIGHTCLICK = System::Word(0xbe7);
static const System::Word WM_SUBJECT_SHAPEDRAGSTART = System::Word(0xbe8);
static const System::Word WM_SUBJECT_SHAPEDRAG = System::Word(0xbe9);
static const System::Word WM_SUBJECT_SHAPEDRAGEND = System::Word(0xbea);
static const System::Word WM_SUBJECT_SHAPEDBLCLICK = System::Word(0xbeb);
static const System::Word WM_SUBJECT_SHAPEMOUSEOUT = System::Word(0xbec);
static const System::Word WM_SUBJECT_SHAPEMOUSEOVER = System::Word(0xbed);
static const System::Word WM_SUBJECT_SHAPEMOVE = System::Word(0xbee);
static const System::Word WM_SUBJECT_LOAD = System::Word(0xbef);
static const System::Word WM_SUBJECT_DESCRIPTION = System::Word(0xbf0);
static const System::Word WM_SUBJECT_HINT = System::Word(0xbf1);
static const System::Word WM_EC_RELOAD = System::Word(0xbf2);
static const System::Word WM_SUBJECT_MAPPAINT = System::Word(0xbf3);
static const System::Word WM_SUBJECT_SHAPESPAINT = System::Word(0xbf4);
static const System::Word WM_SUBJECT_HIRESCHANGE = System::Word(0xbf5);
static const System::Word WM_EC_CENTER = System::Word(0xbf5);
static const System::Word WM_SUBJECT_SHAPESCHANGE = System::Word(0xbf6);
static const System::Word WM_EC_LOCATIONCHANGE = System::Word(0xbf6);
static const System::Word WM_SUBJECT_ACTIVECHANGE = System::Word(0xbf7);
static const System::Word WM_SUBJECT_PROPERTIES = System::Word(0xbf8);
static const System::Word WM_EC_PANTO = System::Word(0xbf9);
static const System::Word WM_ROUTE_REQUEST = System::Word(0xbfa);
static const System::Word WM_SUBJECT_CHANGEBOUNDS = System::Word(0xbfb);
static const System::Word WM_SUBJECT_SHAPEPATHCHANGE = System::Word(0xbfc);
static const System::Word WM_SUBJECT_COMPLETETILES = System::Word(0xbfd);
static const System::Word WM_EC_SHOWALL = System::Word(0xbfe);
static const System::Word WM_EC_SHOWHINT = System::Word(0xbff);
static const System::Word WM_SUBJECT_SHAPEMOUSEDOWN = System::Word(0xc00);
static const System::Word WM_SUBJECT_SHAPEMOUSEUP = System::Word(0xc01);
static const System::Word WM_SUBJECT_OSMLOAD = System::Word(0xc02);
static const System::Word WM_SUBJECT_MOUSEDOWN = System::Word(0xc03);
static const System::Word WM_SUBJECT_MOUSEUP = System::Word(0xc04);
static const System::Word WM_SUBJECT_SCREENSHOOTS = System::Word(0xc05);
static const System::Word WM_SUBJECT_FITBOUNDS = System::Word(0xc06);
static const System::Word WM_EC_SET_ROTATION = System::Word(0xc07);
static const System::Word WM_SUBJECT_SHAPELONGCLICK = System::Word(0xc08);
static const System::Word WM_SUBJECT_SHAPELONGPRESS = System::Word(0xc09);
static const System::Word WM_SUBJECT_MOUSESTOP = System::Word(0xc0a);
static const System::Word WM_EC_ONFOCUS = System::Word(0xc0b);
static const System::Word WM_SUBJECT_FOCUS = System::Word(0xc0c);
static const System::Word WM_SUBJECT_LOAD_GRAPHIC = System::Word(0xc0d);
static const System::Word WM_SUBJECT_SHAPEOVERINTENT = System::Word(0xc0e);
#define _CSV_USE_QUOTE L"\",;'"
#define _OVERPASS_XAPI_SERVER L"https://www.overpass-api.de/api/xapi?"
#define _OVERPASS_API_RU_SERVER L"https://overpass.openstreetmap.ru/cgi/xapi?"
#define _MAPQUEST_XAPI_SERVER L"https://open.mapquestapi.com/xapi/api/0.6/"
#define _DEFAULT_XAPI_SERVER L"https://www.overpass-api.de/api/xapi?"
#define _DEFAULT_OVERPASS_INTERPRETER L"https://overpass-api.de/api/interpreter"
#define _DEFAULT_NOMINATIM L"https://nominatim.openstreetmap.org"
#define _BINGKEY_ L" AsuKX_R3Ik8uuJ17ko__7YAw6wGmFiw-nqN7BBn_1j6nCFi6beNMEt8WT"\
	L"tPtlXj4"
#define _CLOUDEMADEKEY_ L"4c3f266bd90c4540bced098bd8f2eb96"
#define _MAPQUESTKEY_ L"0LaZYUhUkhbGsuSj7QsRB7vuY9X29YCw"
#define _HERE_APP_ID_ L"GSbSxxYA-izeV_XuZpB0252OxY4A-p-HtTepnxTMFkU"
#define _HERE_APP_CODE_ L"AJKnXv84fjrb0KIHawS0Tg"
#define _HERE_COPYRIGHT_ L"Map data \u00a9 Here"
#define _HERE_MAP_TILE_ L"maps.ls.hereapi.com/maptile/2.1"
#define _GOOGLE_COPYRIGHT_ L"Map data \u00a9 Google"
#define _ERROR_TAKES_TOO_LONG L"ERROR takes too long"
static const short _ErrorAltitude = short(-9999);
static const System::Int8 _ERROR_LATLNG = System::Int8(-77);
static const System::Word _ERROR_CONNEXION = System::Word(0x309);
static const System::Int8 _MAX_EVENT_TYPE_ = System::Int8(0x64);
static const System::Word _MAX_WAIT_THREAD_ = System::Word(0xbb8);
static const int _MAX_TRIAL3D_TIME = int(0x1d4c0);
static const System::Int8 _MAX_TRIAL3D = System::Int8(0x5);
#define _PANORAMIO_GROUP_ L"_panoramio_"
#define _TRAFFIC_GROUP_ L"_traffic_"
#define _HINT_GROUP_ L"_hint_"
#define _EDIT_SHADOW_LINE_ L"_EDIT_SHADOW_LINE_"
#define _CRLF L"\r\n"
#define IDHTTP_REQUEST_USERAGENT L"TECNativeMap/5.3"
#define IDHTTP_REQUEST_REFERER L"https://www.google.com/"
#define IDHTTP_CHECKCONNEXION_URL L"https://www.openstreetmap.org"
static const System::Word IDHTTP_CONNECTTIMEOUT = System::Word(0xbb8);
static const System::Word IDHTTP_READTIMEOUT = System::Word(0xbb8);
static const unsigned COLOR_DEFAULT = unsigned(0xffcd5c5c);
static const unsigned HOVERCOLOR_DEFAULT = unsigned(0xff44ca55);
static const unsigned COLOR_BLUE = unsigned(0xff9f4000);
static const System::Byte TILE_SHOW = System::Byte(0xff);
static const System::Int8 TILE_SET = System::Int8(0x4);
static const System::Int8 TILE_WAIT = System::Int8(0x3);
static const System::Int8 TILE_HIDE = System::Int8(0x0);
static const System::Int8 TILE_INIT = System::Int8(0x1);
static const System::Word TILE_SIZE = System::Word(0x100);
static const System::Extended KM_2_EARTH_RADIUS = 1.275627E+04;
static const int EARTH_RADIUS = int(0x615299);
static const System::Extended PI_180 = 1.745329E-02;
static const System::Extended PI_DIV_180 = 1.745329E-02;
static const System::Extended PI_MUL_180 = 5.654867E+02;
static const System::Extended PI_EARTH_RADIUS = 4.007502E+07;
static const System::Extended PI_EARTH_RADIUS_2 = 2.003751E+07;
static const System::Extended MIN_LATITUDE = -8.505113E+01;
static const System::Extended MAX_LATITUDE = 8.505113E+01;
static const short MIN_LONGITUDE = short(-180);
static const System::Byte MAX_LONGITUDE = System::Byte(0xb4);
static const int WGS84_RADIUS_A = int(0x615299);
static const System::Extended WGS84_RADIUS_B = 6.356752E+06;
static const System::Extended DEG_TO_RAG = 1.745329E-02;
static const System::Extended RAD_TO_DEG = 5.729578E+01;
static const System::Extended INCH_IN_METER = 3.937008E+01;
static const System::Extended TWO_PI = 6.283185E+00;
static const System::Extended HALF_PI = 1.570796E+00;
static const System::Extended TWO_PI_INV = 1.591549E-01;
static const System::Extended EPSILON_HIGH = 1.000000E-16;
static const System::Extended EPSILON_MEDIUM = 1.000000E-12;
static const System::Extended EPSILON_LOW = 1.000000E-06;
static const System::Extended EPSILON_VERY_LOW = 1.000000E-03;
#define EPSILON_ZERO  (0.000000E+00)
static const System::Extended EPSILON = 1.000000E-12;
static const __int64 MAX_FPS = 0x0000000000000010LL;
static const __int64 MAX_MILLISECOND_FOR_STYLES = 0x0000000000000040LL;
static const System::Int8 MAX_DAY_IN_CACHE = System::Int8(0x1e);
static const __int64 TIMER_INTERVAL = 0x0000000000000010LL;
static const __int64 TIMER_ROTATION = 0x0000000000000010LL;
static const System::Byte TIMER_PAN = System::Byte(0xfa);
static const __int64 TICK_STYLES = 0x0000000000000010LL;
static const __int64 TICK_ANIMATION = 0x0000000000000010LL;
static const __int64 TICK_PAINT = 0x0000000000000010LL;
static const __int64 TICK_ROTATION = 0x0000000000000010LL;
static const __int64 TICK_ZOOM = 0x0000000000000010LL;
static const System::Byte TIMER_TILES_WAIT = System::Byte(0xfa);
static const System::Word MAX_SHAPE_SHOW_ON_MOVE_MAP = System::Word(0x9c40);
static const int MAX_SHAPE_DIRECT_CENTER = int(0xc3500);
static const System::Word DEFAULT_CACHETILE_SIZE = System::Word(0x200);
static const System::Int8 DEFAULT_MIN_CACHETILE_SIZE = System::Int8(0x20);
static const System::Word DEFAULT_DELAY_HINT = System::Word(0x7d0);
static const System::Word MAX_BITMAP_SIZE = System::Word(0x2000);
static const System::Int8 LOW_MAX_ZOOM = System::Int8(0xf);
static const System::Int8 LOW_MAX_ZOOM_1 = System::Int8(0xa);
static const System::Int8 LOW_MAX_ZOOM_2 = System::Int8(0x5);
static const System::Int8 LOW_MAX_DELTA_ZOOM = System::Int8(0x5);
static const System::Int8 MINIMAL_SIZE_GEOPOINT = System::Int8(0x4);
static const System::Int8 MINIMAL_SIZE_GEOPATH = System::Int8(0x4);
extern DELPHI_PACKAGE bool _HighSpeed_Bitmap;
extern DELPHI_PACKAGE bool _GlobalDisable;
extern DELPHI_PACKAGE System::UnicodeString _Locale;
extern DELPHI_PACKAGE int _MINIMAL_SIZE_GEOPOINT;
extern DELPHI_PACKAGE int _MINIMAL_SIZE_GEOPATH;
extern DELPHI_PACKAGE int _MAX_VECTOR_SHAPES_DRAW;
extern DELPHI_PACKAGE int _MAX_RECYCLE_SHAPES;
extern DELPHI_PACKAGE int _MAX_GEOJSON_LINE;
extern DELPHI_PACKAGE int _WINDOWS_INTERNET_TIMEOUT;
extern DELPHI_PACKAGE int _MAX_TIME_PAN;
extern DELPHI_PACKAGE double _MAX_AREA_XAPI;
extern DELPHI_PACKAGE TTileServer _DEF_TILE_SERVER;
extern DELPHI_PACKAGE System::UnicodeString _NOMINATIM_WEB_SERVICE;
extern DELPHI_PACKAGE System::UnicodeString _NOMINATIM_REVERSE_WEB_SERVICE;
extern DELPHI_PACKAGE System::UnicodeString _DIRECTION_WEB_SERVICE;
extern DELPHI_PACKAGE System::UnicodeString _GUIDANCE_WEB_SERVICE;
extern DELPHI_PACKAGE System::UnicodeString _ALTITUDES_WEB_SERVICE;
extern DELPHI_PACKAGE System::UnicodeString _STATICMAP_WEB_SERVICE;
extern DELPHI_PACKAGE System::UnicodeString _URL_OPEN_ELEVATION;
extern DELPHI_PACKAGE System::UnicodeString _URL_OPEN_TOPODATA;
extern DELPHI_PACKAGE System::UnicodeString _IDHTTP_REQUEST_USERAGENT;
extern DELPHI_PACKAGE System::UnicodeString _IDHTTP_REQUEST_REFERER;
extern DELPHI_PACKAGE System::UnicodeString _IDHTTP_PROXISERVER;
extern DELPHI_PACKAGE System::UnicodeString _IDHTTP_PROXIUSERNAME;
extern DELPHI_PACKAGE System::UnicodeString _IDHTTP_PROXIPASSWORD;
extern DELPHI_PACKAGE int _IDHTTP_PROXIPORT;
extern DELPHI_PACKAGE int _MAX_RELOAD_ERROR_TILE;
extern DELPHI_PACKAGE int _IDHTTP_CONNECTTIMEOUT;
extern DELPHI_PACKAGE int _IDHTTP_READTIMEOUT;
extern DELPHI_PACKAGE System::UnicodeString _IDHTTP_CHECKCONNEXION_URL;
extern DELPHI_PACKAGE unsigned _TIMER_TILES_WAIT;
extern DELPHI_PACKAGE unsigned _MILLISECOND_WAIT_BEFORE_CHECK_CACHE_SIZE;
extern DELPHI_PACKAGE unsigned _MILLISECOND_WAIT_BEFORE_AUTO_REPAINT;
extern DELPHI_PACKAGE unsigned _MAX_MILLISECOND_FOR_STYLES;
extern DELPHI_PACKAGE unsigned _MAX_MILLISECOND_BEFORE_PROCESSMESSAGES;
extern DELPHI_PACKAGE unsigned _MAX_MILLISECOND_FOR_CHECK_TILES;
extern DELPHI_PACKAGE unsigned _MAX_MILLISECOND_FOR_DIRECT_LOAD;
extern DELPHI_PACKAGE unsigned _MAX_MILLISECOND_BEFORE_STOP_CALCDRAW_MOVING;
extern DELPHI_PACKAGE unsigned _MAX_POLYGONFILL_MOVING;
extern DELPHI_PACKAGE unsigned _MAX_LINE_POINTS_MOVING;
extern DELPHI_PACKAGE unsigned _MAX_MILLISECOND_BEFORE_STOP_CALCDRAW;
extern DELPHI_PACKAGE unsigned _MAX_MILLISECOND_BEFORE_STOP_DRAW_MOVING;
extern DELPHI_PACKAGE unsigned _MAX_MILLISECOND_BEFORE_STOP_DRAW;
extern DELPHI_PACKAGE int _DELTA_BEFORE_TEST_TIMING_DRAW;
extern DELPHI_PACKAGE bool _USE_WININET;
extern DELPHI_PACKAGE bool _USE_LOCALCACHE_FOR_GEOCODING;
extern DELPHI_PACKAGE TColor _SHAPE_COLOR_DEFAULT;
extern DELPHI_PACKAGE System::UnicodeString _PLATEFORM_;
extern DELPHI_PACKAGE void *hSession;
extern DELPHI_PACKAGE System::UnicodeString _BingKey;
extern DELPHI_PACKAGE System::UnicodeString _CloudMadeKey;
extern DELPHI_PACKAGE System::UnicodeString _MapQuestKey;
extern DELPHI_PACKAGE System::UnicodeString _HereId;
extern DELPHI_PACKAGE System::UnicodeString _HereCode;
extern DELPHI_PACKAGE System::UnicodeString _MapBoxAccessToken;
extern DELPHI_PACKAGE System::Diagnostics::TStopwatch FStopwatch;
#define PREFIX_VECTOR_GROUP L"_JSON_"
#define SVG_PIN_HOLE L"M12,11.5A2.5,2.5 0 0,1 9.5,9A2.5,2.5 0 0,1 12,6.5A2.5,2.5 "\
	L"0 0,1 14.5,9A2.5,2.5 0 0,1 12,11.5M12,2A7,7 0 0,0 5,9C5,14"\
	L".25 12,22 12,22C12,22 19,14.25 19,9A7,7 0 0,0 12,2Z"
#define SVG_PIN L"M500,605c24.1,0,47.4-2.7,70-8.2V955c0,9.5-3.5,17.7-10.4,24"\
	L".6c-6.9,6.9-15.1,10.4-24.6,10.4h-70c-9.5,0-17.7-3.5-24.6-1"\
	L"0.4c-6.9-6.9-10.4-15.1-10.4-24.6V596.8C452.2,602.3,475.6,6"\
	L"05,500,605L500,605z M500,10c77.3,0,143.3,27.3,198,82s82,12"\
	L"0.7,82,198c0,77.3-27.3,143.3-82,198s-120.7,82-198,82c-77.3"\
	L",0-143.3-27.3-198-82c-54.7-54.7-82-120.7-82-198c0-77.3,27."\
	L"3-143.3,82-198C356.7,37.3,422.7,10,500,10L500,10z M500,132"\
	L".5c5.1,0,9.3-1.6,12.6-4.9s4.9-7.5,4.9-12.6c0-5.1-1.6-9.3-4"\
	L".9-12.6s-7.5-4.9-12.6-4.9c-53.2,0-98.6,18.8-136.2,56.3c-37"\
	L".6,37.6-56.3,82.9-56.3,136.2c0,5.1,1.6,9.3,4.9,12.6s7.5,4."\
	L"9,12.6,4.9c5.1,0,9.3-1.6,12.6-4.9s4.9-7.5,4.9-12.6c0-43.4,"\
	L"15.4-80.5,46.2-111.3S456.6,132.5,500,132.5L500,132.5z"
#define SVG_ROUND_PIN_HOLE L"M858.2,643.6c38.1-63,60-136.8,60-215.8C918.2,197,731,10,50"\
	L"0,10C269,10,81.8,197,81.8,427.8c0,78.8,21.8,152.5,59.8,215"\
	L".4c2.1,7.4,6.1,14.3,12.1,20.1l2.9,2.9c27.4,39.3,61.3,73.6,"\
	L"100.2,101.5l206.5,209.1c12.5,12.1,30.4,15.9,46.3,11.4c13,1"\
	L".2,26.4-3.1,36.4-13l205.9-213.8c35.3-26.7,66.3-58.8,91.6-9"\
	L"5.1l3.2-3.3C852.2,657.4,856.1,650.7,858.2,643.6z M500,298."\
	L"5c71.6,0,129.7,58.1,129.7,129.8c0,71.7-58.1,129.8-129.7,12"\
	L"9.8c-71.6,0-129.7-58.1-129.7-129.8C370.3,356.6,428.3,298.5"\
	L",500,298.5z"
#define SVG_ROUND_PIN L"M500,10c-202.9,0-367.5,164.6-367.5,367.5S500,990,500,990s3"\
	L"67.5-409.6,367.5-612.5S702.9,10,500,10z M500,622.5c-135.3,"\
	L"0-245-109.7-245-245c0-135.3,109.7-245,245-245c135.3,0,245,"\
	L"109.7,245,245C745,512.8,635.3,622.5,500,622.5z M500,255c-6"\
	L"7.6,0-122.5,54.9-122.5,122.5S432.4,500,500,500s122.5-54.9,"\
	L"122.5-122.5S567.6,255,500,255z"
#define GOOGLE_RED_DOT_ICON L"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYA"\
	L"AABzenr0AAAABGdBTUEAANbY1E9YMgAABPBJREFUWIWtl3tMW1Ucxw+0hf"\
	L"EorwIDhdFSKJRnaSnl0ZZXKa9CC4wCo1RhPESWuUQTFd2cuKiJ07hItrnB"\
	L"mFFnXOaymZllWZwic1uMYzGZyZZgMrc/xCnExCjh1Z+/c90qwr0Tj5J8cn"\
	L"O59/zO9/7O9/x+pwQACB8/dzjIrLuB3G6zkfM1xeSdEgN5WZ8lcicrDIkh"\
	L"wYM+Pj4jhJCjxIeMKEKCdzoT4wtfM2SLjxTnkbPVZvI9jqPjaRyhOSiCD+"\
	L"4LuIOBvqwvJ7u06TmxQYHnxL6+SzmR4dCZkgg7MlTQhVddVASIRaLl2KCA"\
	L"C89q1IZxWykn/H8RMOt2kGc06kfwa+cbFHHwTaMVPD1OgMe2ePH0tMC3TV"\
	L"XQqkzAiGTpiQxV/8y98f9JwHzXZrI3X9OJQeGIOQ+gHyfsawXPVicsbW32"\
	L"sozQ/9PnH5QVAC4PvJSbOUDHMwv4wVVPzlSacnHyhaMlBoCBdm6ipQfACR"\
	L"lwwXFLIc2E54Sl0DSNcZgEXG2wkmxZ2LlGTDv0//PkK4HH28GtUoAqVDrx"\
	L"ld0iZhLwqj7LJPL1hWtNlQC9reuenBPQ2wI3W2pBIvKFndq0SiYBmsjw5z"\
	L"Nl4Vyw1V9/qb4cHkX3ywIDuCu95/OEIToSkkOlQ0wC8O+wE11NjbX6C+mk"\
	L"YrHYC71fkwUc15WaSAONsAoY605V8gqgX75SAL3nE7AjK4UGGmMVcLBBEc"\
	L"/tc9YMuFRyGugQkwBTbNRTyWFSWO52snkAvZOFHtJGRTzHJGC4SKfFgjI/"\
	L"XleOhmr7d7sADfh1g5UWJM/e/Gwjk4CLdWXEGBN1zBQThcvQBp5u57omX+"\
	L"7+M/1V8bG0R5wet5WxFaLpdjvB1Cr9RaLZodwMLuh6ihEtWq/nawBryK+f"\
	L"2UrT7mIcJgEzXC9opm3Ygkaa21eo5d0Rq403WpxHjbd4wKirW8BeMMPaC+"\
	L"hAygKKOGTSN9GGdKbKzC0H/7q3wQSakTYizEDn/UbE3oza673MdW4m29KT"\
	L"d8s2+MN0hwMA2+/fJkd//N7VDMqQYGhPShimon9yOchdl52DScCtVpuX22"\
	L"115M6WOlFKWMjl9iT5mtpAU48HFgj39/vuelNV6K3WWjLVUuOFScAkdsOV"\
	L"3GiupktRRpdisvGvBgV4OPkRsxKIBWm3LqNryllDruH7K2EScKG2ZA1X7B"\
	L"aikYV/4lRu8maBfv0redkQ4e93E7eu/2V8hx7hVsJcB1Zz1VFB3izIqcCt"\
	L"CbgknBcWcd8rpEHQp1Y+OdloJV/ge6thEnDaalzDx8gpq1Ei9ZNM4XJwp5"\
	L"9Ldgvd83OnrEUJVxzl5GJ92RqYBBwvL+AFj2mk9KHot2ilg+1uPHCkg1wa"\
	L"NEGX6GyVmRcmAaNmPS/vlRrI9gxVdVTABlhEDxRsjAS7/OHBkxVF+CyfFy"\
	L"YBh016XkbNeeSN/JzYQIn4t89tpbARO+KgJs34Pk40hj9K+GAS8KIug5eh"\
	L"e2BRuvG0Rg14/WVfgVZGhQmJZhLwgjZdkD25mSQxRPqpPloGm4KDrr+Np/"\
	L"eDRh05IACTgF61UhAsywQPmx8GSSSQFCo9jz9CCJpRECYBPalKQQbSkkmW"\
	L"LGw/rYrykOCPXMly0qLcJAiTgP2YOiGosezyuF1UQEVczPAxNKDQrqEwCa"\
	L"CuFuKkpYj0qZPcVECHSr7tREUheRe3pxAPEvAHoSjT1B9h9DoAAAAASUVO"\
	L"RK5CYII="
#define GOOGLE_BLUE_DOT_ICON L"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYA"\
	L"AABzenr0AAAABGdBTUEAANbY1E9YMgAABPNJREFUWMO1lwtMm1UUx29pWY"\
	L"UCC21nVhzvxyaP8iqUMh6jDygwSikC5SlvRFgmgmOgA1Y2trn5ntscTKZx"\
	L"Gh9TMVt0WUQzpqjRqclMJJnJ3Ey2+VhMjBI24Hjut6RA+1XZnTb55cv9er"\
	L"9z//fcc8+5lwAA4cPS8ysp7r1OTF2XSFbtaZJS/DKJNQwJg+Nr1N6y0F6B"\
	L"QDBCCDlKn96ykG2BMaWp8ca9ohTLKNlQ8wExdf7IfU/tuBqDQv5NQGHXZa"\
	L"Jv+oTEaPvjJT5+p0Qi91mZXzyEJtbDuvUdEKpqANkaFeD7OYmPYjwqs0et"\
	L"azjDCf9PBFiQqIyt9+NsZwKiLGBs+xasg/NQtRvslO+Yh7xN30GQ0ooWye"\
	L"y61Ida7d/fiYDS/hmSkPtEnUBAQG0Zhao9ABVDAFbbPJRtn13ANse9p/+n"\
	L"lr4Gbm5uoNQNttHvmQWYu6+QzOoTKhz8hqb4KFTvBRxsbunATsxBDfZLs7"\
	L"5JPTGfZn0r3dx9lU1ATus54quIPeWPbq/es5zBF6h+HACDFXzkERPZLV+I"\
	L"mATEZu9Od3MTQm77N1CxE5Y9OKUc+xd0TIFQ6A7RWdtymARIFfGP+SqUnD"\
	L"HH2RuaP8VdUAseEhn3pG3HpaAxsSpATb1gYxKAv+EgZRkX5Y4zpIOKRCI7"\
	L"tO3YhwZkmKqeGhphFTAaltTIGXI0Tme+WABt8wm4F/MEtcMkAKP/UEC05Y"\
	L"48EBJfDQJCDjMJuDsoo2ulPByTzhy3z283BmjsSBWxILsn8VEmAaqNzydg"\
	L"np8xNJ2ByqHb2wU0AI1tX4JA4DafYNyXxiRA33QWvZD+KgKVu3iynyvQW3"\
	L"TZ/CKMOHvVmB7rApOAIsxg6NpQobv4ulJnW3Yyov0wfWM6Fv2ha/gosqj7"\
	L"Gmst+I2UYS7XFL+kx0ieTsx/hndHOAae2nKERv7NJNPBgtKBG5wdZgGcCD"\
	L"SiNg8Xo1HYUHOCd1dQ6DIZmidw3QXUA3WlA7cKEXsx2nLFTkn/NIlIaR8Q"\
	L"S+Rg6bmK5XepCCvmurKBv8BbGgrBsVX7qeiinl9I0dafOZgEFDx80Y6p8x"\
	L"IpfOQnoY987WRwXKWTF2g7WtsHYg/fH/I2nV9Z0HmRbOy4YIdJgPHBr5eQ"\
	L"v3mKJJuHtXQpctvO2QuUdRDQK9dAtMITYrQD9XTAHOy/GCYB2vpxJwwtn2"\
	L"GJjjsZGLNQI+gzLnsXiD2lU/rGs2JD8yR3hFsMcx5wJKf1K5KY97RBKBJD"\
	L"4ZbLt2LBNgte0mAIS2rppJ7SN044wSQgo2LMmcr38Pmu+wqx94Vk82Go2Y"\
	L"eR3zKJdV80nV45Fmho+dxp9sweWF/2Bi+ZVSfJ6hDtczTT1T4F9MABXr5B"\
	L"E9q6cTyOv88LkwB10Yu8aO47RtZqNud6eK3CGLiJhw4NrIk096ZXvENSS4"\
	L"7xwiQAI54XddERkpD3pMJdLPlT1/AxeHqvhqjM3rTUklcIvZTwwSQgRrfd"\
	L"BTai1A8SD4n8+8iMbrhLIvtdlf+sLIV6yDzCC5sAbb9LYg07iY8s5EO5fz"\
	L"Kuf8D55MIXSJLpEHKQFyYBYUnNLsG0THzk4a+vEEvw0Bl+WqnfQaKz+lzy"\
	L"vwjAO8MBmhW9pcHH8ehF8FrmEiYBSaYDLqGB5R9Z2EcFKMIM+/E65nLXUJ"\
	L"gEuNpSlPTyt0l48gM1VADegNrTKo4TDe4CV/yTgL8Bg0AIlCA8gh8AAAAA"\
	L"SUVORK5CYII="
#define GOOGLE_YELLOW_DOT_ICON L"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYA"\
	L"AABzenr0AAAABGdBTUEAANbY1E9YMgAABPRJREFUWMOtlwtQVFUYgA/sIg"\
	L"gstQtoNMpzVxritbwfuymPFTSUh/F+KGRRQeVMNCUCPkdp1AolRCCQSbDI"\
	L"GGh0yBCUUMAKHGdoBgonETOyJBwfxGv//nMpBPZu4qGd+Wbn3r33/N899z"\
	L"//f5YAAOHjjxtRZOjmBnL9x/Wk8XQAqSzzIXt3ughSEm28bW1E2To6OmWE"\
	L"kGNImY21cW5MlKXf/r2uwvKj3qShfhXp713P3U/H0RaDQh4lMPBTOLnYHE"\
	L"zysh3lFk8ZnhEKBRNyFwmkJtvClkx7SNtoB+5yU8Dzk/h789asZ71bGoM4"\
	L"8f9FYOhmFHk3y2EjPuloZPhyuHIpFNQjcXhJ0jTqv+Lhh861EBdthSOSiT"\
	L"cz7F+9/c/9CxIYHY4lB/LlqTgolBd7TwWcSAD1vTiYuBs7zeS9WIDxBPw9"\
	L"GU5U+gG+Htid55wxOhzDLvDrzxHkVO1KDww+dqzUB0+lcIFmBp4LJ4LX1V"\
	L"Qp6EyoT1YrlIP9EWwCnW0hxMVJfCYqYjn3ZI8KPhN6PSYrrJCZtH7bulrI"\
	L"JJC/20Up0NWFy9+t4aZ3vsE5gbF46O0OAz2hLuRudQxhEnB1Fuc4OYoBRu"\
	L"M1nr7tnAo2JduBqWQx902PZ70KKoG54u1lBjKpaBeTAH5KY16w4hJv7hPS"\
	L"oEKhcBp6rPkakrglSusEq0DF5lQprwB98pkC9JhPYMvrz9CBKlgFiiMjLB"\
	L"c0A0kJNnSgEiYBpf+SLJnMBCax6Dx2DtDlOJYAzk5icJNLtjEJFH7g7oYF"\
	L"ZbSlKRhgMvHxVgEm4PcdobQgqQ/skyuYBC6cDSYKf/Nqpb85J6C+Hzev4F"\
	L"PFKAlCVRbYIyT1tC8wCQxeiyQ4tXb6+oKhXblOU8VonkXoYL4cBALdu+e+"\
	L"CnS41R/JJnD7F+wFd2JJZalPMCbSSMFBd96EnJt4H2PPwOvHjxzyXDeG99"\
	L"NxmAUodJCSj7w20IZ0qm6VVglQJ0IrJqMO0aEzkDp6Z6oRLagZ/cvIn9Ek"\
	L"85UVO0wl+jA4EAWA7XdW8Adx8GA4BuxsRZAYZ11IpX8fiCS3rk/BJHCtZ9"\
	L"00dHMx0BcusJeZtGMAjVmgx3nbHEH85KKr3Z1rn6D39HWHTcMk0NUeOoue"\
	L"K8/TVxFIX0XXpYcNCrBO/HYjEgwNhbAjxymNBrzcHjILJoHmhkANOlpUtE"\
	L"mdjol+2CPo9749riAR6/deaArWbz+v4rZwM2GrA03BGnReDCEf7ndT6S8S"\
	L"wMDVcK5TjuPuCDelkP6i9K2ujhDyzdkgDZgE6muUGnz5uZLU1Sj1RMZ6fS"\
	L"VFXtzup61FRdf8CJ63ojPEJ84kUHPcnxfcppGA55YeDl39NF62iW44wNrS"\
	L"qLW5IYA01K3khUkACwovx8t9yRuv2a8xNzPA6Y8FX28zCA9bll37qYL7jQ"\
	L"8mgdIiL16oxPvvuVlg1t8//3UQLF2yGLLfdlBUYaAK/FPCB5PAzhwnXrAv"\
	L"IM7EVGLQ806WA7Zkg2Es06ZUTJs0k8D2bEet7NnuTGytRU2eHmZgucyo++"\
	L"hhL1J8yJMcKeCHSeDlNKlWsCwTmdTkMyNDPZDaiRrxTwjBZNQKk8BLqXZa"\
	L"yUiXEWdHcRGtitZWxl/g1ovERltphUmgqMBDKzSxMPPzqIAq0KKwutJP66"\
	L"qhMAlUVfhqpfaEgqRvlqZQgeQEm8yTePwJrgJt/JfA31YevDW0y0E4AAAA"\
	L"AElFTkSuQmCC"
#define GOOGLE_GREEN_DOT_ICON L"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYA"\
	L"AABzenr0AAAABGdBTUEAANbY1E9YMgAABHxJREFUWIWtl3ls1EUUx9+8mW"\
	L"5rty6llW53W+i2225Lr92eC/Sk0XiLsanxQLQGY4yYKJcKUlASRcshoRIC"\
	L"jUgwGkKqrUpC09A/ROIVz0KiiUgEbyMSj5Aq8nzz21hKf7+fwOAf30xmfz"\
	L"vvfWbmvTczQETgJBiZAXCI9V49iJcrADeWAD6SL2VHIC5D3mUKsVeBeEEJ"\
	L"bvO8K+QN/lm4okCJ9cUgXiwHeLc+MZ7tuPmw/JwXQH8UcGGoSmVfMqg86p"\
	L"Ss8JG8JUB4Ty7hrQGSsUmkPEl/8/dhfCAvLvoqrXH/D8ChmYALpt3Jsx2V"\
	L"12SRGKom+KaJ4HgLwc8tiZb7YriG8EY/KcBTOD/3vrHxFwXwZQNgV7iTjR"\
	L"IvbcLZD80ERxsJvhon3de//9JKYvN04u0hXBq6X483B/goDmJHeS3P/E98"\
	L"lp3/2mp3PFH6O/9PbC3llRCnuW2Cj+NmAGJvNciySwfltVOsmf2n44k60U"\
	L"rYkU0q7N0v9sSUEQA+mt+kpCSxr4bg++YLA/iumcSBOlJJkvDBvCuNAFS5"\
	L"7zFZ5mNjTbalF/0xkjcHSE1Otlrdt0H82EyyJp1UQdoTZgCA2yRHtRV4E4"\
	L"xbzpUak+7bAHgc3hbUWdFrCADbcW6Q998OoGc+HkD3HQHunUrajiGA3CKv"\
	L"y0rkuukKdAT0Cmw1ApAzJi+W4TSCrw1i4GgiEHUMqUrfcrMseLKoWqEc5T"\
	L"JsBdQFZQEXJTFYzQVJnsaugkazOvBqFGQ8/SUWwU8McOw8nevZ87bJ2Rmk"\
	L"or4B8UrUsBJyBYOBWFgly+O4JMTFxR4LrkVoZZhjA38TuytLjSshHOSz4E"\
	L"gDiI3Fl3NZPYmrC89dEfk78pnB//8L1xRdr8drO+YA/0J0R9rZKImdFY5Z"\
	L"YYm3SbwWI74fkFgZ7rScj1zMafhh/IwOzwLszFmlMjzEBgm+bTrb+THuH+"\
	L"H0DKWSvMnfYzn/lJ1/kpBZEL5Tf0b6cvF+XKpC79uy3W9fBZ3zi0Kk0j2H"\
	L"YbhmknUbOlA3JjOAweqz9WYtYHekzdqKoXEHlL6cjMwklao0xN3irTrbWD"\
	L"OA3ZV2vRHTR/QeOWdchdSzX17ARcnzOadushiIWle48TID6LcbEnurAB8v"\
	L"vEIlK4IP4olY4LyXeamEdwQXWTPmvJ8oM4Dny+zabrVJKs3zBa6NEPw+m8"\
	L"TrHPlKnuTf8/QKOYGbAWyZ7qwdZSAbMjbJtkyC0TbChzj4pqbuF7sqQOws"\
	L"d5QRAK6LOGtTCcj5uVery1ISy1+bTvKqKctEbykI/uYkM4DuiLPWFQOuCg"\
	L"eU1/OH6IuSykohfgs0Ws70o8RBZgCLQ+5aEgKVmfIZvxdIZSSfEKsLM8X6"\
	L"CIi1zjIDWBhy18P5wM+zfbKKX0S5qQfxmSLAp1lrnGUGMDfors4c4MvKLt"\
	L"4GkgVpQ7g0HzgYXWUGcHvQXXcxQKlvs34xyWnePmzPBpzjd5VZGj5V5K4N"\
	L"xcCR38UXTpItmT3iOQ5AzhA3mQH0lLiLUw7n5czTAPwCWiC2uafgudLwHy"\
	L"3o6Qne/mPvAAAAAElFTkSuQmCC"
static const System::Int8 _ZINDEX_ORDER_POLYGONE = System::Int8(0x1);
static const System::Int8 _ZINDEX_ORDER_LINE = System::Int8(0x2);
static const System::Int8 _ZINDEX_ORDER_MARKER = System::Int8(0x3);
static const System::Int8 _ZINDEX_ORDER_POI = System::Int8(0x4);
static const System::Int8 _ZINDEX_ORDER_WIN = System::Int8(0x5);
static const System::Int8 LOCALE_SISO639LANGNAME = System::Int8(0x59);
static const System::Extended TWO_PI_EARTH_RADIUS = 4.007502E+07;
static const System::Word MAX_MILLISECOND_BEFORE_STOP_DRAW = System::Word(0x3e8);
static const System::Byte MAX_MILLISECOND_BEFORE_STOP_DRAW_MOVING = System::Byte(0xc8);
static const System::Byte MAX_MILLISECOND_BEFORE_STOP_CALCDRAW_MOVING = System::Byte(0xc8);
static const int MAX_GEOJSON_LINE = int(0x4c4b40);
static const System::Word MAX_MILLISECOND_BEFORE_STOP_CALCDRAW = System::Word(0x2ee);
static const System::Word WINDOWS_INTERNET_TIMEOUT = System::Word(0x3e8);
static const System::Int8 MAX_MILLISECOND_BEFORE_PROCESSMESSAGES = System::Int8(0x50);
static const System::Int8 MAX_MILLISECOND_FOR_CHECK_TILES = System::Int8(0x19);
static const System::Byte MAX_MILLISECOND_FOR_DIRECT_LOAD = System::Byte(0x96);
#define _INIT_3D L"<html><meta http-equiv=\"content-type\" content=\"text/htm"\
	L"l; charset=utf-8\" /><head><script src=\"http://www.google"\
	L".com/jsapi?key=ABQIAAAAwbkbZLyhsmTCWXbTcjbgbRSzHs7K5SvaUdm"\
	L"8ua-Xxy_-2dYwMxQMhnagaawTo7L1FE1-amhuQxIlXw\"></script><sc"\
	L"ript>google.load(\"earth\", \"1\");var ge = null;function "\
	L"init() {google.earth.createInstance(\"map3d\", initCallbac"\
	L"k, failureCallback);} function initCallback(object) { ge ="\
	L" object;  ge.getWindow().setVisibility(true);}function fai"\
	L"lureCallback(object) { } </script></head><body onload=\"in"\
	L"it()\" id=\"body\"> <div id=\"map3d\" style=\"border: 1px "\
	L"solid silver; height: 600px; width: 800px;\"></div></body>"\
	L"</html>"
static const System::Int8 INTERVAL_THREADTILEPOOL = System::Int8(0x10);
static const int MAX_VECTOR_SHAPES_DRAW = int(0x2625a00);
static const int MAX_LINE_POINTS_MOVING = int(0x13880);
static const System::Word MAX_POLYGONFILL_MOVING = System::Word(0x3e8);
extern DELPHI_PACKAGE System::StaticArray<int, 360> _Sin360;
extern DELPHI_PACKAGE System::StaticArray<int, 360> _cos360;
extern DELPHI_PACKAGE void __fastcall debug_message(const System::UnicodeString avalue);
extern DELPHI_PACKAGE System::UnicodeString __fastcall UTMLetterDesignator(System::Extended Lat);
extern DELPHI_PACKAGE void __fastcall LLtoUTM(int ReferenceEllipsoid, const double Lat, const double Long, double &UTMNorthing, double &UTMEasting, System::UnicodeString &UTMZone);
extern DELPHI_PACKAGE void __fastcall UTMtoLL(int ReferenceEllipsoid, const double UTMNorthing, const double UTMEasting, System::UnicodeString UTMZone, double &Lat, double &Long);
extern DELPHI_PACKAGE System::UnicodeString __fastcall CodeOSMShortLink(const double Lat, const double Lng, const int zoom);
extern DELPHI_PACKAGE void __fastcall DecodeOSMShortLink(System::UnicodeString sc, double &Lat, double &Lng, int &zoom);
extern DELPHI_PACKAGE void __fastcall LocatorToLatlng(System::UnicodeString mh, double &Lat, double &Long);
extern DELPHI_PACKAGE System::UnicodeString __fastcall LatLngToLocator(const double Latinput, const double Longinput);
extern DELPHI_PACKAGE void __fastcall RotateRect(Winapi::Windows::TRect &R, int Angle);
extern DELPHI_PACKAGE TStreamType __fastcall GetStreamType(System::Classes::TStream* const stream);
extern DELPHI_PACKAGE System::UnicodeString __fastcall Crc32Str(const System::UnicodeString Data);
extern DELPHI_PACKAGE System::UnicodeString __fastcall ArrayLatLngToUrl(const double *dLatLngs, const System::NativeInt dLatLngs_High, const int FDecimalPrecision = 0x5, const System::UnicodeString _From = L"from=", const System::UnicodeString _to = L"to=");
extern DELPHI_PACKAGE System::UnicodeString __fastcall gettileURLGeoBase(const int x, const int y, const int z, const System::UnicodeString geoStreamServerURL, const int TileSize, const int TilesPerSuperTile = 0x4, const bool Satellite = false);
extern DELPHI_PACKAGE void __fastcall LatLon2TileXY(const double Lat, const double Lon, int z, int &TileX, int &TileY);
extern DELPHI_PACKAGE void __fastcall TileXY2LatLon(const int TileX, const int TileY, const int z, double &Lat, double &Lon);
extern DELPHI_PACKAGE double __fastcall tile2lon(int x, int z);
extern DELPHI_PACKAGE double __fastcall tile2lat(int y, int z);
extern DELPHI_PACKAGE unsigned __fastcall GetTickCountFrom(unsigned aFrom);
extern DELPHI_PACKAGE bool __fastcall ClipLine(Winapi::Windows::TPoint &P1, Winapi::Windows::TPoint &P2, int Xmin, int Xmax, int Ymin, int Ymax, bool &DrawLastPt);
extern DELPHI_PACKAGE System::UnicodeString __fastcall ArcGisReverse(const System::UnicodeString LocalCache, const double Lat, const double Lng, const int DecimalPrecision = 0x5, const bool OnlyLocal = false);
extern DELPHI_PACKAGE bool __fastcall ArcGisFind(System::UnicodeString &Data, const System::UnicodeString LocalCache, double &Lat, double &Lng);
extern DELPHI_PACKAGE bool __fastcall GeoapifyFind(System::UnicodeString &Data, const System::UnicodeString LocalCache, double &Lat, double &Lng, const System::UnicodeString ApiKey, System::Classes::TStringList* const ResultList);
extern DELPHI_PACKAGE TLatLng __fastcall ConvertLambert93ToWGS84(const double _X, const double _Y);
extern DELPHI_PACKAGE System::UnicodeString __fastcall UrlStaticGoogleStreetView(const double Lat, const double Lng, const int Width = 0x140, const int Height = 0xc8, const System::UnicodeString ApiKey = System::UnicodeString());
extern DELPHI_PACKAGE System::UnicodeString __fastcall UrlStaticGoogleMap(const double Lat, const double Lng, const System::Byte Zoom, const int Width = 0x140, const int Height = 0xc8, const System::UnicodeString MapName = L"roadmap", const System::UnicodeString ApiKey = System::UnicodeString());
extern DELPHI_PACKAGE bool __fastcall KeyIsDown(int KeyInQuestion);
extern DELPHI_PACKAGE unsigned __fastcall GetTickCount(void);
extern DELPHI_PACKAGE System::UnicodeString __fastcall PanoramioPhotoUrlSize(const System::UnicodeString PhotoUrl, TECPanoramioImageSize size);
extern DELPHI_PACKAGE System::UnicodeString __fastcall ExtractQuote(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall GetJSONParam(const System::UnicodeString Data, const System::UnicodeString sParam, int &end_pos, const int start = 0x1);
extern DELPHI_PACKAGE System::TDateTime __fastcall incMilliseconde(const System::TDateTime ADateTime, const __int64 AMillisecondes);
extern DELPHI_PACKAGE System::TDateTime __fastcall decMilliseconde(const System::TDateTime ADateTime, const __int64 AMillisecondes);
extern DELPHI_PACKAGE System::TDateTime __fastcall incMinute(const System::TDateTime ADateTime, const __int64 AMinutes);
extern DELPHI_PACKAGE System::TDateTime __fastcall decMinute(const System::TDateTime ADateTime, const __int64 AMinutes);
extern DELPHI_PACKAGE System::TDateTime __fastcall incHour(const System::TDateTime ADateTime, const __int64 AHeures);
extern DELPHI_PACKAGE System::TDateTime __fastcall decHour(const System::TDateTime ADateTime, const __int64 AHeures);
extern DELPHI_PACKAGE System::TDateTime __fastcall SetHourMinuteSeconde(const System::TDateTime ADateTime, const __int64 AHour, const __int64 AMinute, const __int64 ASeconde);
extern DELPHI_PACKAGE System::UnicodeString __fastcall ISO8601DateTimeToStr(System::TDateTime DateTime)/* overload */;
extern DELPHI_PACKAGE System::UnicodeString __fastcall ISO8601DateHHNNToStr(System::TDateTime DateTime);
extern DELPHI_PACKAGE System::UnicodeString __fastcall ISO8601DateTimeToStr(System::TDateTime DateTime, int tzbias)/* overload */;
extern DELPHI_PACKAGE System::UnicodeString __fastcall ISO8601DateToStr(System::TDateTime Date);
extern DELPHI_PACKAGE System::UnicodeString __fastcall ISO8601TimeToStr(System::TDateTime Time)/* overload */;
extern DELPHI_PACKAGE System::UnicodeString __fastcall ISO8601TimeToStr(System::TDateTime Date, int tzbias)/* overload */;
extern DELPHI_PACKAGE System::TDateTime __fastcall ISO8601StrToTime(const System::UnicodeString s);
extern DELPHI_PACKAGE System::TDateTime __fastcall ISO8601StrToDateTime(const System::UnicodeString s)/* overload */;
extern DELPHI_PACKAGE double __fastcall distance2d(double x1, double y1, double x2, double y2)/* overload */;
extern DELPHI_PACKAGE int __fastcall distance2d(int x1, int y1, int x2, int y2)/* overload */;
extern DELPHI_PACKAGE int __fastcall SqLineMagnitude(const int x1, const int y1, const int x2, const int y2)/* overload */;
extern DELPHI_PACKAGE double __fastcall SqLineMagnitude(const double x1, const double y1, const double x2, const double y2)/* overload */;
extern DELPHI_PACKAGE double __fastcall DistancePointLine(const double px, const double py, const double x1, const double y1, const double x2, const double y2)/* overload */;
extern DELPHI_PACKAGE double __fastcall MagnitudePointLine(const double px, const double py, const double x1, const double y1, const double x2, const double y2, double &prResX, double &prResY);
extern DELPHI_PACKAGE bool __fastcall Collinear(double x1, double y1, double x2, double y2, double x3, double y3);
extern DELPHI_PACKAGE double __fastcall IntersectPoint(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double &Nx, double &Ny);
extern DELPHI_PACKAGE int __fastcall point_inter_2_lines(const double x1, const double y1, const double x2, const double y2, const double x3, const double y3, const double x4, const double y4, double &x, double &y);
extern DELPHI_PACKAGE double __fastcall DistancePointLine(const double px, const double py, const double x1, const double y1, const double x2, const double y2, double &prResX, double &prResY)/* overload */;
extern DELPHI_PACKAGE System::UnicodeString __fastcall NumberToAlphabet(const int Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall DashStyleToString(const TDashStyle Value);
extern DELPHI_PACKAGE TDashStyle __fastcall StringToDashStyle(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall penStyleToString(const TPenStyle Value);
extern DELPHI_PACKAGE TPenStyle __fastcall StringToPenStyle(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall tsToString(const TTileServer Value);
extern DELPHI_PACKAGE TTileServer __fastcall StringToTs(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall puToStr(const TPOIUnit Value);
extern DELPHI_PACKAGE TPOIUnit __fastcall StrToPu(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall rtToStr(const TMQRouteType Value);
extern DELPHI_PACKAGE TMQRouteType __fastcall StrToRt(const System::UnicodeString Value);
extern DELPHI_PACKAGE TPOIShape __fastcall StrToPs(const System::UnicodeString Value);
extern DELPHI_PACKAGE void __fastcall poiShapeToStr(const TPOIShape Value, System::UnicodeString &Name);
extern DELPHI_PACKAGE System::UnicodeString __fastcall psToStr(const TPOIShape Value);
extern DELPHI_PACKAGE void __fastcall WaitCursor(const bool TrueFalseValue);
extern DELPHI_PACKAGE System::UnicodeString __fastcall RemoveAccent(const System::UnicodeString AInput);
extern DELPHI_PACKAGE bool __fastcall UrlToStream(const System::UnicodeString sUrl, System::Classes::TMemoryStream* const FMemoryStream);
extern DELPHI_PACKAGE bool __fastcall LoadBitmapFromStream(TGraphic* const FGraphic, System::Classes::TMemoryStream* const FMStream);
extern DELPHI_PACKAGE bool __fastcall LoadBitmapFromUrl(TGraphic* const FGraphic, const System::UnicodeString URL);
extern DELPHI_PACKAGE bool __fastcall GetFreeGeoIP(TDataGeoIP &Data, const System::UnicodeString ip = System::UnicodeString());
extern DELPHI_PACKAGE System::UnicodeString __fastcall ConvertOMQTravelMode(const System::UnicodeString TravelMode);
extern DELPHI_PACKAGE System::UnicodeString __fastcall URLEncodeOMQRoute(const double dStartLatitude, const double dStartLongitude, const double dEndLatitude, const double dEndLongitude, const System::UnicodeString TravelOptions, const bool OptimizeWaypoints, const System::UnicodeString sWayPoints, const bool avoidHighWays, const bool avoidTolls);
extern DELPHI_PACKAGE System::UnicodeString __fastcall AnsiToUtf8(const ansistring source);
extern DELPHI_PACKAGE ansistring __fastcall Utf8ToAnsi(const System::UnicodeString source);
extern DELPHI_PACKAGE int __fastcall FastPos(const System::UnicodeString aSourceString, const System::UnicodeString aFindString, const int aSourceLen, const int aFindLen, const int StartPos);
extern DELPHI_PACKAGE TGeoDataFormat __fastcall FindGeoDataFormat(const System::UnicodeString data);
extern DELPHI_PACKAGE bool __fastcall IsRecentFile(const System::UnicodeString Filename, double MaxDayMinutesInCache);
extern DELPHI_PACKAGE bool __fastcall IsRecentMinutesFile(const System::UnicodeString Filename, int MaxMinutesInCache);
extern DELPHI_PACKAGE System::UnicodeString __fastcall NormalizeLocalFilename(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall FilenameToIdString(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall StripCar(const System::UnicodeString Cars, const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall StripCars(const System::UnicodeString Cars, const System::UnicodeString Value);
extern DELPHI_PACKAGE bool __fastcall IsCarsFind(const System::UnicodeString Cars, const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall CsvQuote(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall EncodeCar(const System::UnicodeString Cars, const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall DecodeCar(const System::UnicodeString Cars, const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall EchapHTML(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall HTMLAttributDoubleQuotToSimpleQuot(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall EchapKML(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall EntityToString(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall UTF8Escape(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall AccentToEntity(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall StripHTML(const System::UnicodeString S);
extern DELPHI_PACKAGE System::Extended __fastcall rad2deg(System::Extended rad);
extern DELPHI_PACKAGE double __fastcall atan2(double y, double x);
extern DELPHI_PACKAGE double __fastcall AltitudeFromRangeTilt(const double range, const double tilt);
extern DELPHI_PACKAGE void __fastcall DecimalToDMS(const double Deci, double &D, double &M, double &S);
extern DELPHI_PACKAGE void __fastcall boundingCoordinates(const double Lat, const double Lng, const double Radius, double &latSW, double &lngSW, double &latNE, double &lngNE);
extern DELPHI_PACKAGE void __fastcall LatLngFromBearingDistance(const TLatLng &P1, double brng, double dKM, const TLatLng &P2);
extern DELPHI_PACKAGE void __fastcall LatLonFromDistanceBearing(double lat1, double lon1, double brng, double D, double &lat2, double &lon2);
extern DELPHI_PACKAGE int __fastcall bearing(double lat1, double lng1, double lat2, double lng2);
extern DELPHI_PACKAGE double __fastcall dbearing(double lat1, double lng1, double lat2, double lng2);
extern DELPHI_PACKAGE TLocationDirection __fastcall LocationDirection(double lat1, double lng1, double lat2, double lng2);
extern DELPHI_PACKAGE double __fastcall distance_ortho(double x1, double y1, double x2, double y2);
extern DELPHI_PACKAGE double __fastcall BoundingArea(const double latSW, const double lngSW, const double latNE, const double lngNE);
extern DELPHI_PACKAGE void __fastcall VincentyDirectDistance(const double _Lat1, const double _Lon1, const double bearing, const double _Dist, double &lat2, double &lon2);
extern DELPHI_PACKAGE double __fastcall VincentyInverseDistance(double dlat1, double dlon1, double dlat2, double dlon2, double &AzimuthInit, double &AzimuthFinal, int units = 0x1)/* overload */;
extern DELPHI_PACKAGE double __fastcall VincentyInverseDistance(double dlat1, double dlon1, double dlat2, double dlon2)/* overload */;
extern DELPHI_PACKAGE double __fastcall DistanceFrom(const double dLatitudeStart, const double dLongitudeStart, const double dLatitudeEnd, const double dLongitudeEnd);
extern DELPHI_PACKAGE void __fastcall DirectoryGetFiles(const System::UnicodeString Path, System::Classes::TStringList* Files);
extern DELPHI_PACKAGE void __fastcall DirectoryGetDirectorie(const System::UnicodeString Path, System::Classes::TStringList* Files);
extern DELPHI_PACKAGE int __fastcall StrToValueZoomed(const System::UnicodeString Values, const int Zoom, const int Default);
extern DELPHI_PACKAGE void __fastcall FromXYToLatLng(const int Zoom, const double iX, const double iY, double &dLatitude, double &dLongitude, const int TileSize = 0x100);
extern DELPHI_PACKAGE void __fastcall FromLatLngToXY(const int Zoom, const double dLatitude, const double dLongitude, double &iX, double &iY, const double Res, const int TileSize = 0x100);
extern DELPHI_PACKAGE void __fastcall DecodeLatLng(const System::UnicodeString Value, double &Lat, double &Lng, const System::Byte EncodePrecision = (System::Byte)(0x6));
extern DELPHI_PACKAGE System::UnicodeString __fastcall EncodeLatLng(const double Lat, const double Lng, const System::Byte EncodePrecision = (System::Byte)(0x6));
extern DELPHI_PACKAGE System::UnicodeString __fastcall KmlDescription(const System::UnicodeString description);
extern DELPHI_PACKAGE System::UnicodeString __fastcall KmlCDATA(const System::UnicodeString cdata);
extern DELPHI_PACKAGE System::UnicodeString __fastcall KmlExtendData(const System::UnicodeString NameValues);
extern DELPHI_PACKAGE bool __fastcall KmlExtractCoordinates(const System::UnicodeString KmlPlacemark, double &dLat, double &dLng, double &dAlt);
extern DELPHI_PACKAGE System::UnicodeString __fastcall KmlName(const System::UnicodeString Data);
extern DELPHI_PACKAGE System::UnicodeString __fastcall KmlDocument(const System::UnicodeString Data);
extern DELPHI_PACKAGE System::UnicodeString __fastcall KmlTime(const System::TDateTime ADateTime);
extern DELPHI_PACKAGE System::UnicodeString __fastcall KmlBeginEndTime(const System::TDateTime ADateTimeBegin, const System::TDateTime ADateTimeEnd);
extern DELPHI_PACKAGE System::UnicodeString __fastcall GpxDocument(const System::UnicodeString Data);
extern DELPHI_PACKAGE System::UnicodeString __fastcall GpxTime(const System::TDateTime ADateTime);
extern DELPHI_PACKAGE bool __fastcall ExtractWKTObjectGeometry(const System::UnicodeString wktField, int &i, const int l, System::UnicodeString &wktObject, System::Classes::TStringList* wktGeometry, bool &isMulti);
extern DELPHI_PACKAGE int __fastcall _MulDiv(int nNumber, int nNumerator, int nDenominator);
extern DELPHI_PACKAGE int __fastcall PosEx_Sha_Pas_2(const System::UnicodeString SubStr, const System::UnicodeString S, int Offset = 0x1);
extern DELPHI_PACKAGE bool __fastcall SameValue(double n1, double n2);
extern DELPHI_PACKAGE System::UnicodeString __fastcall BoolToStr(const bool Value);
extern DELPHI_PACKAGE bool __fastcall StrToBoolDef(const System::UnicodeString Value, const bool bDef);
extern DELPHI_PACKAGE bool __fastcall StrToBool(const System::UnicodeString Value);
extern DELPHI_PACKAGE bool __fastcall IsBool(const System::UnicodeString Value);
extern DELPHI_PACKAGE TArrayString __fastcall Explode(const System::UnicodeString S, System::WideChar Separator, int Limit);
extern DELPHI_PACKAGE System::UnicodeString __fastcall DoubleToIntStr(double Value, const int Digit = 0x2710);
extern DELPHI_PACKAGE double __fastcall StrToIntDouble(const System::UnicodeString Value, const int Digit = 0x2710);
extern DELPHI_PACKAGE System::UnicodeString __fastcall DoubleToStr(const double Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall DoubleToStrDigit(const double Value, const int Digit);
extern DELPHI_PACKAGE System::UnicodeString __fastcall DoubleDoubleToStr(const double value1, const double Value2);
extern DELPHI_PACKAGE System::UnicodeString __fastcall LatLngAltToStr(const double value1, const double Value2, const double Value3);
extern DELPHI_PACKAGE System::UnicodeString __fastcall TripleDoubleToStr(const double value1, const double Value2, const double Value3);
extern DELPHI_PACKAGE double __fastcall StrToDoubleDef(const System::UnicodeString Value, const double dDef);
extern DELPHI_PACKAGE double __fastcall StrToDouble(const System::UnicodeString Value);
extern DELPHI_PACKAGE void __fastcall DoubleStrToDouble(const System::UnicodeString value1, const System::UnicodeString Value2, double &dres1, double &dres2);
extern DELPHI_PACKAGE bool __fastcall IsNumeric(const System::UnicodeString Value);
extern DELPHI_PACKAGE double __fastcall TryStrToDouble(const System::UnicodeString Value, const double DefaultValue);
extern DELPHI_PACKAGE double __fastcall StrToDoubleSecu(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall AppDataPath(void);
extern DELPHI_PACKAGE void __fastcall WaitFor(unsigned delay_milliseconde);
extern DELPHI_PACKAGE System::Uitypes::TAlphaColor __fastcall HSLAtoRGBA(double h, double S, double l, double A);
extern DELPHI_PACKAGE System::Uitypes::TAlphaColor __fastcall GetHashColor(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::Uitypes::TAlphaColor __fastcall GetRandomColor(void);
extern DELPHI_PACKAGE System::Uitypes::TAlphaColor __fastcall GetContrastingColor(System::Uitypes::TAlphaColor Color);
extern DELPHI_PACKAGE System::Uitypes::TAlphaColor __fastcall GetInvertColor(System::Uitypes::TAlphaColor Color);
extern DELPHI_PACKAGE System::Uitypes::TAlphaColor __fastcall GetRandomPastelColor(void);
extern DELPHI_PACKAGE System::Uitypes::TAlphaColor __fastcall DegradeColor(System::Uitypes::TAlphaColor StartColor, System::Uitypes::TAlphaColor EndColor, double Pourcentage);
extern DELPHI_PACKAGE TColor __fastcall GetHighlightColorBy(TColor BaseColor, const int Value);
extern DELPHI_PACKAGE TColor __fastcall GetShadowColorBy(TColor BaseColor, const int Value);
extern DELPHI_PACKAGE void __fastcall FilterColorsBitmap(Fmx::Graphics::TBitmap* const FBitmap, TECFilterColor* const FilterColors);
extern DELPHI_PACKAGE System::UnicodeString __fastcall GetWindowsLanguage(unsigned LCTYPE);
extern DELPHI_PACKAGE int __fastcall SecureStrToInt(const System::UnicodeString S, const int def);
extern DELPHI_PACKAGE System::UnicodeString __fastcall strToken(System::UnicodeString &S, System::WideChar Seperator);
extern DELPHI_PACKAGE void __fastcall OpenInternet(void);
extern DELPHI_PACKAGE void __fastcall CloseInternet(void);
extern DELPHI_PACKAGE bool __fastcall DetectionConnexion(void);
extern DELPHI_PACKAGE int __fastcall Https_Post(const System::UnicodeString url, const ansistring Header, const ansistring PostData, ansistring &Response);
extern DELPHI_PACKAGE bool __fastcall WinInetDownloadToStream(const System::UnicodeString URL, System::Classes::TStream* stream, const System::LongInt Maxsize, const System::UnicodeString Headers = System::UnicodeString());
extern DELPHI_PACKAGE bool __fastcall DownloadToStream(const System::UnicodeString URL, System::Classes::TStream* stream, const System::LongInt Maxsize, const System::UnicodeString Headers = System::UnicodeString());
extern DELPHI_PACKAGE System::UnicodeString __fastcall DownloadToString(const System::UnicodeString URL, const System::UnicodeString Filename = System::UnicodeString());
extern DELPHI_PACKAGE System::UnicodeString __fastcall UTFStreamToString(System::Classes::TStream* const UTFStream);
extern DELPHI_PACKAGE ansistring __fastcall getECMapInfo(void);
extern DELPHI_PACKAGE ansistring __fastcall getTimeECMap(void);
extern DELPHI_PACKAGE System::UnicodeString __fastcall Encode64String(const System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall Decode64String(const System::UnicodeString Value);
extern DELPHI_PACKAGE bool __fastcall Decode64ToStream(const System::UnicodeString value64, System::Classes::TStream* stream);
extern DELPHI_PACKAGE System::UnicodeString __fastcall EncodeStreamTo64(System::Classes::TStream* stream);
extern DELPHI_PACKAGE System::UnicodeString __fastcall ParseURL(const System::UnicodeString URL, System::UnicodeString &Prot, System::UnicodeString &User, System::UnicodeString &Pass, System::UnicodeString &Host, System::UnicodeString &Port, System::UnicodeString &Path, System::UnicodeString &Para);
extern DELPHI_PACKAGE bool __fastcall isUrl(const System::UnicodeString Filename);
extern DELPHI_PACKAGE System::UnicodeString __fastcall UrlStreamToDataUri(const System::UnicodeString URL);
extern DELPHI_PACKAGE System::UnicodeString __fastcall UrlImageToDataUri(const System::UnicodeString URL);
extern DELPHI_PACKAGE System::UnicodeString __fastcall ECMapTempFileName(void);
extern DELPHI_PACKAGE bool __fastcall DownloadFile(const System::UnicodeString SourceFile, const System::UnicodeString DestFile);
extern DELPHI_PACKAGE bool __fastcall DownloadURL(const System::UnicodeString aUrl, System::UnicodeString &S);
extern DELPHI_PACKAGE void __fastcall OpenUrl(const System::UnicodeString sUrl);
extern DELPHI_PACKAGE System::UnicodeString __fastcall Remplace_FirstStr(const System::UnicodeString ch, const System::UnicodeString dh, const System::UnicodeString eh);
extern DELPHI_PACKAGE System::UnicodeString __fastcall Remplace_Str(const System::UnicodeString ch, const System::UnicodeString dh, const System::UnicodeString eh);
extern DELPHI_PACKAGE ansistring __fastcall Remplace_AStr(const ansistring ch, const ansistring dh, const ansistring eh);
extern DELPHI_PACKAGE System::UnicodeString __fastcall doURLEncode(const System::UnicodeString S);
extern DELPHI_PACKAGE TColor __fastcall StrToColor(const System::UnicodeString ValueName, const TColor defValue = (System::Uitypes::TAlphaColor)(0x0), System::Classes::TStringList* const ParamList = (System::Classes::TStringList*)(0x0));
extern DELPHI_PACKAGE System::UnicodeString __fastcall ColorToCesiumColor(const TColor Color, double opacity);
extern DELPHI_PACKAGE System::UnicodeString __fastcall ColorToKmlColor(const TColor Color, double opacity);
extern DELPHI_PACKAGE void __fastcall KmlColorToColorOpacity(const System::UnicodeString KmlColor, TColor &Color, double &opacity);
extern DELPHI_PACKAGE System::UnicodeString __fastcall ColorToHTML(const TColor Color);
extern DELPHI_PACKAGE int __fastcall PolySimplifyInt2D(TFloat Tol, const System::Types::TPoint *Orig, const System::NativeInt Orig_High, System::Types::TPoint *Simple, const System::NativeInt Simple_High);
extern DELPHI_PACKAGE void __fastcall PolyMarkerSimplifyInt2D(TFloat Tol, const System::Types::TPoint *Orig, const System::NativeInt Orig_High, bool *Marker, const System::NativeInt Marker_High);
extern DELPHI_PACKAGE TDoublePoint __fastcall DoublePoint(double AX, double AY);
extern DELPHI_PACKAGE Winapi::Windows::TPoint __fastcall PointFromDoublePointExt(const TDoublePoint &APoint, const TDoublePoint &ADelta, TPointRounding ARoundMode);
extern DELPHI_PACKAGE Winapi::Windows::TPoint __fastcall PointFromDoublePoint(const TDoublePoint &APoint, TPointRounding ARoundMode = (TPointRounding)(0x0));
extern DELPHI_PACKAGE TDoubleArea __fastcall DoubleArea(double ALeft, double ATop, double ARight, double ABottom)/* overload */;
extern DELPHI_PACKAGE TDoubleArea __fastcall DoubleArea(const TDoublePoint &ATopLeft, const TDoublePoint &ABottomRight)/* overload */;
extern DELPHI_PACKAGE TDoubleArea __fastcall DoubleArea(const Winapi::Windows::TRect &ARect)/* overload */;
extern DELPHI_PACKAGE TDoubleArea __fastcall DoubleArea(const System::Types::TRectF &ARect)/* overload */;
extern DELPHI_PACKAGE double __fastcall VincentiGeodeticInverse(const TDoublePoint &AP1, const TDoublePoint &AP2, const double AEllSemiMajor, const double AEllSemiMinor, /* out */ double &VAzimuth, /* out */ double &VFinalBearing);
extern DELPHI_PACKAGE TDoublePoint __fastcall VincentiGeodesicDirect(const TDoublePoint &P1, const double AAzimuth, const double ADistance, const double AEllSemiMajor, const double AEllSemiMinor);
extern DELPHI_PACKAGE double __fastcall CalculatePolygonArea(const TDoublePoint *APoints, const System::NativeInt APoints_High, const int ACount, const double AEllSemiMajor);
extern DELPHI_PACKAGE System::UnicodeString __fastcall SecondeToTimeStr(const int Sec);
extern DELPHI_PACKAGE System::TDateTime __fastcall UnixToDateTime(System::LongInt USec);
extern DELPHI_PACKAGE System::LongInt __fastcall DateTimeToMinutes(const System::TDateTime DateTime);
}	/* namespace Uecmaputil */
}	/* namespace Fmx */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX_UECMAPUTIL)
using namespace Fmx::Uecmaputil;
#endif
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX)
using namespace Fmx;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Fmx_UecmaputilHPP
