﻿// CodeGear C++Builder
// Copyright (c) 1995, 2023 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'FMX.jhHTMLGraphics.pas' rev: 36.00 (Windows)

#ifndef Fmx_JhhtmlgraphicsHPP
#define Fmx_JhhtmlgraphicsHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.SysUtils.hpp>
#include <System.Types.hpp>
#include <System.UITypes.hpp>
#include <System.Rtti.hpp>
#include <System.Classes.hpp>
#include <FMX.uecMapUtil.hpp>
#include <FMX.Graphics.hpp>
#include <FMX.PlatformExtensions.hpp>
#include <FMX.Dialogs.hpp>
#include <FMX.Types.hpp>
#include <FMX.Controls.hpp>
#include <FMX.Forms.hpp>
#include <FMX.Objects.hpp>
#include <FMX.Platform.hpp>
#include <System.UIConsts.hpp>

//-- user supplied -----------------------------------------------------------

namespace Fmx
{
namespace Jhhtmlgraphics
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TInfoLine;
class DELPHICLASS TjhHTMLText;
//-- type declarations -------------------------------------------------------
typedef void __fastcall (__closure *TGetDrawGraphic)(const System::UnicodeString Filename, Fmx::Uecmaputil::TGraphic* &gfx, const int x, const int y, int &l, int &h);

typedef void __fastcall (__closure *TGetAreaAnchor)(const int x, const int y, const int l, const int h, const int id, const System::UnicodeString anchor);

enum DECLSPEC_DENUM TApplyTagType : unsigned char { atBreak, atGoodTag, atBadTag, atText, atImg, atCenter, atTab, atvTab, atShape };

enum DECLSPEC_DENUM TShapeType : unsigned char { stNone, stRect, stCircle };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TInfoLine : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	float FAscent;
	float FHeight;
public:
	/* TObject.Create */ inline __fastcall TInfoLine() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TInfoLine() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TjhHTMLText : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	double FOldFontSize;
	double FScale;
	System::UnicodeString FImgSrc;
	int FImgWidth;
	int FImgHeight;
	int FimgDeltaY;
	System::UnicodeString FShape;
	TShapeType FShapeType;
	int FShapeWidth;
	int FShapeHeight;
	int FShapeDeltaY;
	Fmx::Uecmaputil::TColor FShapeColor;
	Fmx::Uecmaputil::TColor FShapeBorderColor;
	Fmx::Uecmaputil::TColor FOldColor;
	Fmx::Uecmaputil::TColor FOldBorderColor;
	int StartPosX;
	bool FBDRightToLeft;
	bool FCanCache;
	bool FIsLinkImg;
	bool FTagBreak;
	bool FTagH;
	System::UnicodeString FTagFont;
	bool FTagA;
	TGetDrawGraphic FDrawGraphic;
	TGetAreaAnchor FAreaAnchor;
	double FDeltaFontH;
	double FDeltaFontW;
	double FDeltaBR;
	double FTab;
	double FVTab;
	int FHitID;
	int FaX;
	int FaY;
	int FaH;
	int FaL;
	System::UnicodeString FaUrl;
	System::UnicodeString FTagLink;
	System::Classes::TStringList* FWordTagList;
	System::UnicodeString FWorkStr;
	System::UnicodeString FLineStartFontName;
	int FReduceH;
	int AutoBreak;
	bool FHoverFont;
	bool FBkHoverColor;
	bool FbkColor;
	Fmx::Uecmaputil::TColor FHoverTextColor;
	Fmx::Uecmaputil::TColor FHoverFillBkcolor;
	Fmx::Uecmaputil::TColor FTextColor;
	Fmx::Uecmaputil::TColor FFillBkcolor;
	Fmx::Graphics::TFont* FFont;
	Fmx::Graphics::TBrush* FFill;
	Fmx::Graphics::TStrokeBrush* FStroke;
	float FDecaleY;
	float FThisLineY;
	float x;
	float y;
	float FMaxWidth;
	float FMaxHeight;
	float FMaxAscent;
	float FLineStartFontSize;
	int FCurId;
	int FLineStartFontWidth;
	int FIndent1;
	int FIndent;
	int FCurLine;
	int FLineEndWordTagIdx;
	int FLineWordCount;
	int FWordCount;
	int FStaticLineHeight;
	unsigned FjhFlags;
	float FLineEndWordX;
	double FLeading;
	System::Types::TRect FRect;
	Fmx::Graphics::TCanvas* FCanvas;
	System::Uitypes::TFontStyles FLineStartStyle;
	bool FInCenterMode;
	bool FInPlainTextMode;
	bool FLineStartPlainTextMode;
	int FLastFontWidth;
	int FCurrentFontWidth;
	void __fastcall FillWordTagList();
	void __fastcall ProcessWordTagList();
	void __fastcall CalcWordTagList();
	bool __fastcall DrawLine(int vLineEndWordTagIdx, const bool draw = true);
	TApplyTagType __fastcall ApplyTag(System::UnicodeString str, const int id);
	void __fastcall SetTabPosition(const System::UnicodeString s);
	void __fastcall SetVTabPosition(const System::UnicodeString s);
	void __fastcall SetBRPosition(const System::UnicodeString s);
	System::UnicodeString __fastcall GetFontParam(const System::UnicodeString ParamLabStr, const System::UnicodeString s);
	void __fastcall SetFontName(System::UnicodeString s);
	void __fastcall SetFontSize(System::UnicodeString s);
	void __fastcall SetFontColor(System::UnicodeString s);
	void __fastcall SetFontBkColor(System::UnicodeString s);
	void __fastcall SetFontHoverColor(System::UnicodeString s);
	void __fastcall SetFontHoverBkColor(System::UnicodeString s);
	void __fastcall SetFontWidth(System::UnicodeString s);
	void __fastcall SetFontDeltaH(System::UnicodeString s);
	void __fastcall BreakWords(System::UnicodeString s);
	void __fastcall BreakLongWord(System::UnicodeString s, const int idx, const int startX);
	Fmx::Uecmaputil::TColor __fastcall HTMLColortoWinColor(System::UnicodeString s);
	bool __fastcall isText(const System::UnicodeString str);
	
public:
	__fastcall TjhHTMLText(const System::UnicodeString HTMLstr, const bool bdRightToLeft);
	__fastcall virtual ~TjhHTMLText();
	__property System::Classes::TStringList* WordTagList = {read=FWordTagList};
	__property bool CanCache = {read=FCanCache, nodefault};
};


//-- var, const, procedure ---------------------------------------------------
static const System::Int8 _START_INDEX_STRING = System::Int8(0x1);
static const System::Int8 _ReduceWidth = System::Int8(0x0);
static const System::Int8 JC_LEFT = System::Int8(0x0);
static const System::Int8 JC_RIGHT = System::Int8(0x1);
static const System::Int8 JC_CENTER = System::Int8(0x2);
static const System::Int8 JC_CALCRECT = System::Int8(0x4);
static const System::Int8 JC_STATIC_LEADING = System::Int8(0x10);
static const System::Int8 JC_LINE1_LABEL = System::Int8(0x20);
extern DELPHI_PACKAGE bool __fastcall jhDrawHTMLText(Fmx::Graphics::TCanvas* vCanvas, const System::UnicodeString vHTMLstr, const bool bdRightToLeft, System::Types::TRect &vRect, const unsigned cjhFlags, const double cLeading, const int cIndent1, const int cIndent, TGetDrawGraphic doGetDrawGraphic, TGetAreaAnchor doGetAreaAnchor = 0x0, const int HitID = 0xffffffff, const double _scale = 1.000000E+00);
}	/* namespace Jhhtmlgraphics */
}	/* namespace Fmx */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX_JHHTMLGRAPHICS)
using namespace Fmx::Jhhtmlgraphics;
#endif
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX)
using namespace Fmx;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Fmx_JhhtmlgraphicsHPP
