﻿// CodeGear C++Builder
// Copyright (c) 1995, 2023 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'FMX.uecgeoLocalise.pas' rev: 36.00 (Windows)

#ifndef Fmx_UecgeolocaliseHPP
#define Fmx_UecgeolocaliseHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.SysUtils.hpp>
#include <System.Types.hpp>
#include <System.UITypes.hpp>
#include <System.Rtti.hpp>
#include <System.Classes.hpp>
#include <System.StrUtils.hpp>
#include <FMX.Types.hpp>
#include <FMX.Controls.hpp>
#include <FMX.Forms.hpp>
#include <FMX.Objects.hpp>
#include <System.Generics.Collections.hpp>
#include <System.IOUtils.hpp>
#include <FMX.uecMapZip.hpp>
#include <FMX.uecHttp.hpp>
#include <FMX.uecMapUtil.hpp>
#include <FMX.uecOpenMapQuestServices.hpp>
#include <FMX.uecNativePlace.hpp>
#include <FMX.uecBingServices.hpp>
#include <FMX.ectXml.hpp>
#include <System.Generics.Defaults.hpp>

//-- user supplied -----------------------------------------------------------

namespace Fmx
{
namespace Uecgeolocalise
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TECGeoResult;
class DELPHICLASS TECIpInfoDBResult;
class DELPHICLASS TECIpInfoDB;
class DELPHICLASS TECRoutePathPoint;
class DELPHICLASS TECRoutePath;
class DELPHICLASS TECGeoLocalise;
class DELPHICLASS TECThreadDataRoute;
class DELPHICLASS TaddresspartsXML;
//-- type declarations -------------------------------------------------------
typedef void __fastcall (__closure *TOnReverseEvent)(System::TObject* sender, const System::UnicodeString Adress);

typedef void __fastcall (__closure *TOnAltitudeEvent)(System::TObject* sender, const System::UnicodeString Altitudes);

typedef void __fastcall (__closure *TOnTrafficLayer)(System::TObject* sender, const System::UnicodeString value);

typedef void __fastcall (*TOnGetAltitude)(const System::UnicodeString LocalCache, const double Latitude, const double Longitude, double &altitude);

typedef void __fastcall (*TOnGetAltitudes)(const System::UnicodeString LocalCache, const System::UnicodeString sLatLngs, System::UnicodeString &altitudes);

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECGeoResult : public Fmx::Uecopenmapquestservices::TNominatimResult
{
	typedef Fmx::Uecopenmapquestservices::TNominatimResult inherited;
	
public:
	/* TObject.Create */ inline __fastcall TECGeoResult() : Fmx::Uecopenmapquestservices::TNominatimResult() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TECGeoResult() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECIpInfoDBResult : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FstatusCode;
	System::UnicodeString FstatusMessage;
	System::UnicodeString FipAddress;
	System::UnicodeString FcountryCode;
	System::UnicodeString FcountryName;
	System::UnicodeString FregionName;
	System::UnicodeString FcityName;
	System::UnicodeString FzipCode;
	System::UnicodeString FtimeZone;
	double Flatitude;
	double Flongitude;
	
public:
	__property System::UnicodeString StatusCode = {read=FstatusCode};
	__property System::UnicodeString StatusMessage = {read=FstatusMessage};
	__property System::UnicodeString IpAddress = {read=FipAddress};
	__property System::UnicodeString CountryCode = {read=FcountryCode};
	__property System::UnicodeString CountryName = {read=FcountryName};
	__property System::UnicodeString RegionName = {read=FregionName};
	__property System::UnicodeString CityName = {read=FcityName};
	__property System::UnicodeString ZipCode = {read=FzipCode};
	__property System::UnicodeString TimeZone = {read=FtimeZone};
	__property double Latitude = {read=Flatitude};
	__property double Longitude = {read=Flongitude};
public:
	/* TObject.Create */ inline __fastcall TECIpInfoDBResult() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TECIpInfoDBResult() { }
	
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECIpInfoDB : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FKey;
	TECIpInfoDBResult* FGeoIpResult;
	unsigned FTiming;
	bool __fastcall getGeoIp(const System::UnicodeString country_city, const System::UnicodeString value_ip);
	
public:
	__fastcall TECIpInfoDB();
	__fastcall virtual ~TECIpInfoDB();
	bool __fastcall CountryGeoIP(const System::UnicodeString value_ip);
	bool __fastcall CityGeoIP(const System::UnicodeString value_ip);
	__property TECIpInfoDBResult* GeoIpResult = {read=FGeoIpResult};
	__property System::UnicodeString Key = {read=FKey, write=FKey};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECRoutePathPoint : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	double FLatitude;
	double FLongitude;
	double FAltitude;
	System::UnicodeString FInstructions;
	System::LongInt FDistance;
	System::UnicodeString __fastcall getText();
	System::UnicodeString __fastcall getToKml();
	System::UnicodeString __fastcall getToGpx();
	double __fastcall getAltitude();
	
public:
	__property double Altitude = {read=getAltitude};
	__property System::UnicodeString Instructions = {read=FInstructions};
	__property double Latitude = {read=FLatitude};
	__property double Longitude = {read=FLongitude};
	__property System::LongInt Distance = {read=FDistance, nodefault};
	__property System::UnicodeString Text = {read=getText};
	__property System::UnicodeString ToKml = {read=getToKml};
	__property System::UnicodeString ToGpx = {read=getToGpx};
public:
	/* TObject.Create */ inline __fastcall TECRoutePathPoint() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TECRoutePathPoint() { }
	
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECRoutePath : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECRoutePathPoint* operator[](int index) { return this->Point[index]; }
	
private:
	System::Generics::Collections::TList__1<TECRoutePathPoint*>* FList;
	System::LongInt FDistance;
	System::LongInt FDuration;
	TECRoutePathPoint* __fastcall getPoint(int index);
	
public:
	__fastcall TECRoutePath();
	__fastcall virtual ~TECRoutePath();
	int __fastcall add(const double dLatitude, const double dLongitude, const double dAltitude, const System::LongInt lDistance, const System::UnicodeString txt);
	void __fastcall clear();
	int __fastcall count();
	int __fastcall IndexOfLatLng(const double dLatitude, const double dLongitude);
	__property System::LongInt Distance = {read=FDistance, write=FDistance, nodefault};
	__property System::LongInt Duration = {read=FDuration, write=FDuration, nodefault};
	__property TECRoutePathPoint* Point[int index] = {read=getPoint/*, default*/};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECGeoLocalise : public System::Classes::TComponent
{
	typedef System::Classes::TComponent inherited;
	
private:
	Fmx::Uecmapzip::TECMapZip* FMapZip;
	Fmx::Uecopenmapquestservices::TOpenMapQuestServices* FMapQuest;
	Fmx::Uecbingservices::TBingServices* FBing;
	Fmx::Uecnativeplace::TECPlaces* FPlaces;
	Fmx::Uecmaputil::TApiAltitude FApiAltitude;
	TECGeoResult* FECGeoResult;
	TOnReverseEvent FOnReverse;
	TOnAltitudeEvent FOnAltitude;
	System::Classes::TNotifyEvent FOnASyncSearch;
	System::Classes::TNotifyEvent FOnSearch;
	System::Classes::TNotifyEvent FOnTraffic;
	TOnTrafficLayer FOnTrafficLayer;
	TOnGetAltitude FOnGetAltitude;
	TOnGetAltitudes FOnGetAltitudes;
	bool FOptimizeRoute;
	double FMaxDayInCache;
	bool FSSL;
	System::UnicodeString FNominatimServeur;
	System::UnicodeString FLocalCache;
	Fmx::Uecopenmapquestservices::TNominatimReverseResult* FReverseResult;
	int FDecimalPrecision;
	System::UnicodeString FLocale;
	void __fastcall setApiAltitude(const Fmx::Uecmaputil::TApiAltitude value);
	void __fastcall setDecimalPrecision(const int value);
	void __fastcall setLocalCache(const System::UnicodeString value);
	void __fastcall doASyncReverse(System::TObject* sender);
	void __fastcall doASyncAltitude(System::TObject* sender);
	void __fastcall doASyncSearch(System::TObject* sender);
	void __fastcall doSearch(System::TObject* sender);
	void __fastcall doTraffic(System::TObject* sender);
	Fmx::Uecnativeplace::TECPlaces* __fastcall getPlaces();
	int __fastcall getSearchCount();
	TECGeoResult* __fastcall getSearchResult(int index);
	System::Classes::TStringList* __fastcall getSearchResults();
	Fmx::Uecopenmapquestservices::TNominatimReverseResult* __fastcall getReverseResults();
	void __fastcall setTrafficIconLowImpact(const System::UnicodeString value);
	System::UnicodeString __fastcall getTrafficIconLowImpact();
	void __fastcall setTrafficIconMinor(const System::UnicodeString value);
	System::UnicodeString __fastcall getTrafficIconMinor();
	void __fastcall setTrafficIconModerate(const System::UnicodeString value);
	System::UnicodeString __fastcall getTrafficIconModerate();
	void __fastcall setTrafficIconRoadClosed(const System::UnicodeString value);
	System::UnicodeString __fastcall getTrafficIconRoadClosed();
	void __fastcall setTrafficIconSerious(const System::UnicodeString value);
	System::UnicodeString __fastcall getTrafficIconSerious();
	System::UnicodeString __fastcall getTrafficTxtResults();
	System::UnicodeString __fastcall getTrafficXmlResults();
	void __fastcall setOptimizeRoute(const bool value);
	
public:
	__fastcall virtual TECGeoLocalise(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TECGeoLocalise();
	bool __fastcall FrenchSearch(const System::UnicodeString data, double &Lat, double &Lng);
	bool __fastcall ArcGisFind(System::UnicodeString &data, double &Lat, double &Lng);
	System::UnicodeString __fastcall ArcGisReverse(const double Lat, const double Lng, const bool OnlyLocal = false);
	int __fastcall OpenStreetMapSearch(const System::UnicodeString address, const bool onlyLocal = false);
	int __fastcall OpenStreetMapStructuredSearch(const System::UnicodeString address, const bool onlyLocal = false);
	void __fastcall ASynchOpenStreetMapSearch(const System::UnicodeString address);
	void __fastcall ASynchOpenStreetMapStructuredSearch(const System::UnicodeString address);
	System::UnicodeString __fastcall OpenStreetMapReverse(const double Latitude, const double Longitude, const bool onlyLocal = false);
	void __fastcall ASynchOpenStreetMapReverse(const double Latitude, const double Longitude);
	int __fastcall Search(const System::UnicodeString address, const bool onlyLocal = false);
	void __fastcall ASyncSearch(const System::UnicodeString address, const System::UnicodeString Url_Service = System::UnicodeString());
	System::UnicodeString __fastcall Reverse(const double Latitude, const double Longitude, const bool onlyLocal = false);
	void __fastcall ASyncReverse(const double Latitude, const double Longitude);
	double __fastcall Altitude(const double Latitude, const double Longitude);
	System::UnicodeString __fastcall Altitudes(const System::UnicodeString sLatLngs);
	void __fastcall AsyncAltitude(const System::UnicodeString sLatLngs);
	bool __fastcall AlignLatLngToRoute(double &dLatitude, double &dLongitude);
	void __fastcall PlaceSearch(const double Lat, const double Lng, const System::UnicodeString Tags);
	unsigned __fastcall AbortPlaceSearchIfMaxTime(const unsigned MaxTimeInSecond);
	void __fastcall AbortPlaceSearch();
	void __fastcall TrafficArea(const double dLatSW, const double dLngSW, const double dLatNE, const double dLngNE);
	__property Fmx::Uecopenmapquestservices::TOpenMapQuestServices* MapQuestServices = {read=FMapQuest};
	__property Fmx::Uecnativeplace::TECPlaces* Places = {read=getPlaces};
	__property System::UnicodeString NominatimServeur = {read=FNominatimServeur, write=FNominatimServeur};
	__property int SearchCount = {read=getSearchCount, nodefault};
	__property TECGeoResult* SearchResult[int index] = {read=getSearchResult};
	__property System::Classes::TStringList* SearchResults = {read=getSearchResults};
	__property Fmx::Uecopenmapquestservices::TNominatimReverseResult* ReverseResults = {read=getReverseResults};
	__property System::UnicodeString Locale = {read=FLocale, write=FLocale};
	__property System::UnicodeString TrafficTxtResults = {read=getTrafficTxtResults};
	__property System::UnicodeString TrafficXmlResults = {read=getTrafficXmlResults};
	__property System::UnicodeString TrafficIconLowImpact = {read=getTrafficIconLowImpact, write=setTrafficIconLowImpact};
	__property System::UnicodeString TrafficIconMinor = {read=getTrafficIconMinor, write=setTrafficIconMinor};
	__property System::UnicodeString TrafficIconModerate = {read=getTrafficIconModerate, write=setTrafficIconModerate};
	__property System::UnicodeString TrafficIconSerious = {read=getTrafficIconSerious, write=setTrafficIconSerious};
	__property System::UnicodeString TrafficIconRoadClosed = {read=getTrafficIconRoadClosed, write=setTrafficIconRoadClosed};
	__property TOnTrafficLayer OnTrafficLayer = {read=FOnTrafficLayer, write=FOnTrafficLayer};
	__property System::UnicodeString LocalCache = {read=FLocalCache, write=setLocalCache};
	__property double MaxDayInCache = {read=FMaxDayInCache, write=FMaxDayInCache};
	__property bool OptimizeRoute = {read=FOptimizeRoute, write=setOptimizeRoute, nodefault};
	__property int DecimalPrecision = {read=FDecimalPrecision, write=setDecimalPrecision, nodefault};
	__property bool SSL = {read=FSSL, write=FSSL, nodefault};
	__property Fmx::Uecmapzip::TECMapZip* MapZip = {read=FMapZip, write=FMapZip};
	__property Fmx::Uecmaputil::TApiAltitude ApiAltitude = {read=FApiAltitude, write=setApiAltitude, nodefault};
	__property TOnGetAltitude OnGetAltitude = {read=FOnGetAltitude, write=FOnGetAltitude};
	__property TOnGetAltitudes OnGetAltitudes = {read=FOnGetAltitudes, write=FOnGetAltitudes};
	
__published:
	__property TOnReverseEvent OnReverse = {read=FOnReverse, write=FOnReverse};
	__property TOnAltitudeEvent OnAltitude = {read=FOnAltitude, write=FOnAltitude};
	__property System::Classes::TNotifyEvent OnSearch = {read=FOnSearch, write=FOnSearch};
	__property System::Classes::TNotifyEvent OnASyncSearch = {read=FOnASyncSearch, write=FOnASyncSearch};
	__property System::Classes::TNotifyEvent OnTraffic = {read=FOnTraffic, write=FOnTraffic};
};


typedef void __fastcall (*TECThreadRoutingUrl)(TECThreadDataRoute* sender);

typedef void __fastcall (*TECThreadRoutingExecute)(TECThreadDataRoute* sender, bool &valid);

typedef void __fastcall (*TECThreadRoutingDownload)(TECThreadDataRoute* sender, System::Classes::TStringStream* &StringStream);

class PASCALIMPLEMENTATION TECThreadDataRoute : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Fmx::Uechttp::TuecHttp* FHttp;
	bool FValid;
	bool FASynchronous;
	System::Classes::TStringList* FDirectionsResults;
	bool FAddRoute;
	bool FOnlyLocal;
	bool FSSL;
	double FMaxDayInCache;
	System::UnicodeString FEngineKey;
	System::UnicodeString FEngineName;
	System::UnicodeString FUrl;
	System::UnicodeString FParams;
	System::UnicodeString FRequestResult;
	System::UnicodeString FLocale;
	System::Classes::TStringList* FAddressWayPoints;
	System::Classes::TStringList* FLatLngWayPoints;
	TECRoutePath* FRoutePath;
	System::TObject* FLine;
	int FRouteDrawingTime;
	bool FOptimizedRoute;
	Fmx::Uecmaputil::TMQRouteType FRouteType;
	TECGeoLocalise* FGeoLocalise;
	System::Classes::TNotifyEvent FOnTerminate;
	System::Classes::TNotifyEvent FOnLinePathChange;
	TECThreadRoutingUrl FOnRoutingUrl;
	TECThreadRoutingUrl FOnValidRoutingUrl;
	TECThreadRoutingDownload FOnRoutingDownload;
	TECThreadRoutingExecute FOnRoutingExecute;
	
public:
	__fastcall TECThreadDataRoute(TECGeoLocalise* GeoValue);
	__fastcall virtual ~TECThreadDataRoute();
	__property Fmx::Uechttp::TuecHttp* Http = {read=FHttp};
	__property bool ASynchronous = {read=FASynchronous, write=FASynchronous, nodefault};
	__property bool AddRoute = {read=FAddRoute, write=FAddRoute, nodefault};
	__property int RouteDrawingTime = {read=FRouteDrawingTime, write=FRouteDrawingTime, nodefault};
	__property System::Classes::TStringList* DirectionsResults = {read=FDirectionsResults, write=FDirectionsResults};
	__property System::UnicodeString Url = {read=FUrl, write=FUrl};
	__property System::UnicodeString Params = {read=FParams, write=FParams};
	__property System::Classes::TStringList* AddressWayPoints = {read=FAddressWayPoints};
	__property System::Classes::TStringList* LatLngWayPoints = {read=FLatLngWayPoints};
	__property System::UnicodeString Locale = {read=FLocale, write=FLocale};
	__property double MaxDayInCache = {read=FMaxDayInCache, write=FMaxDayInCache};
	__property System::UnicodeString RequestResult = {read=FRequestResult, write=FRequestResult};
	__property System::UnicodeString EngineKey = {read=FEngineKey, write=FEngineKey};
	__property System::UnicodeString EngineName = {read=FEngineName, write=FEngineName};
	__property TECRoutePath* RoutePath = {read=FRoutePath, write=FRoutePath};
	__property System::TObject* Line = {read=FLine, write=FLine};
	__property bool OptimizedRoute = {read=FOptimizedRoute, write=FOptimizedRoute, nodefault};
	__property Fmx::Uecmaputil::TMQRouteType RouteType = {read=FRouteType, write=FRouteType, nodefault};
	__property TECGeoLocalise* GeoLocalise = {read=FGeoLocalise};
	__property bool OnlyLocal = {read=FOnlyLocal, write=FOnlyLocal, nodefault};
	__property bool SSL = {read=FSSL, write=FSSL, nodefault};
	__property bool Valid = {read=FValid, write=FValid, nodefault};
	__property System::Classes::TNotifyEvent OnTerminate = {read=FOnTerminate, write=FOnTerminate};
	__property System::Classes::TNotifyEvent OnLinePathChange = {read=FOnLinePathChange, write=FOnLinePathChange};
	__property TECThreadRoutingDownload OnRoutingDownload = {read=FOnRoutingDownload, write=FOnRoutingDownload};
	__property TECThreadRoutingExecute OnRoutingExecute = {read=FOnRoutingExecute, write=FOnRoutingExecute};
	__property TECThreadRoutingUrl OnRoutingUrl = {read=FOnRoutingUrl, write=FOnRoutingUrl};
	__property TECThreadRoutingUrl OnValidRoutingUrl = {read=FOnValidRoutingUrl, write=FOnValidRoutingUrl};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TaddresspartsXML : public Fmx::Ectxml::TectXML
{
	typedef Fmx::Ectxml::TectXML inherited;
	
private:
	System::UnicodeString FData;
	bool FOk;
	
protected:
	virtual void __fastcall doOnText();
	virtual void __fastcall doOnTag();
	
public:
	__property System::UnicodeString Data = {read=FData};
	__property bool Ok = {read=FOk, write=FOk, nodefault};
public:
	/* TectXML.Create */ inline __fastcall TaddresspartsXML() : Fmx::Ectxml::TectXML() { }
	/* TectXML.Destroy */ inline __fastcall virtual ~TaddresspartsXML() { }
	
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
}	/* namespace Uecgeolocalise */
}	/* namespace Fmx */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX_UECGEOLOCALISE)
using namespace Fmx::Uecgeolocalise;
#endif
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX)
using namespace Fmx;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Fmx_UecgeolocaliseHPP
