﻿// CodeGear C++Builder
// Copyright (c) 1995, 2023 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'FMX.uecHeatmap.pas' rev: 36.00 (Windows)

#ifndef Fmx_UecheatmapHPP
#define Fmx_UecheatmapHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.SysUtils.hpp>
#include <System.Types.hpp>
#include <System.UITypes.hpp>
#include <System.Rtti.hpp>
#include <System.Classes.hpp>
#include <System.StrUtils.hpp>
#include <System.SyncObjs.hpp>
#include <System.UIConsts.hpp>
#include <System.Math.hpp>
#include <System.Generics.Collections.hpp>
#include <System.Generics.Defaults.hpp>
#include <System.Math.Vectors.hpp>
#include <FMX.uecMapUtil.hpp>
#include <FMX.Dialogs.hpp>
#include <FMX.Types.hpp>
#include <FMX.Graphics.hpp>
#include <FMX.Controls.hpp>
#include <FMX.Forms.hpp>
#include <FMX.Objects.hpp>
#include <FMX.Platform.hpp>

//-- user supplied -----------------------------------------------------------

namespace Fmx
{
namespace Uecheatmap
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS THeatColorValue;
class DELPHICLASS THeatPalette;
class DELPHICLASS TThreadHeatMap;
class DELPHICLASS TecHeatMap;
//-- type declarations -------------------------------------------------------
typedef System::DynamicArray<System::Uitypes::TAlphaColor> TArrayColor;

typedef System::DynamicArray<int> TArrayInteger;

class PASCALIMPLEMENTATION THeatColorValue : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	double R;
	double G;
	double B;
	double A;
	double Value;
public:
	/* TObject.Create */ inline __fastcall THeatColorValue() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~THeatColorValue() { }
	
};


typedef System::Generics::Collections::TList__1<THeatColorValue*> TECHeatPaletteList;

class PASCALIMPLEMENTATION THeatPalette : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TECHeatPaletteList* FPalette;
	System::Classes::TNotifyEvent FOnChange;
	bool FLock;
	double __fastcall NormaliseValue(const double Value);
	
public:
	__fastcall THeatPalette();
	__fastcall virtual ~THeatPalette();
	void __fastcall Lock();
	void __fastcall UnLock();
	void __fastcall Clear();
	void __fastcall Reset();
	void __fastcall AddColor(const System::Byte R, const System::Byte G, const System::Byte B, const double Value)/* overload */;
	void __fastcall AddColor(const System::Byte R, const System::Byte G, const System::Byte B, const System::Byte A, const double Value)/* overload */;
	void __fastcall getColor(System::Byte &R, System::Byte &G, System::Byte &B, const double Value)/* overload */;
	void __fastcall getColor(System::Byte &R, System::Byte &G, System::Byte &B, System::Byte &A, const double Value)/* overload */;
};


class PASCALIMPLEMENTATION TThreadHeatMap : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	TecHeatMap* FHeatmap;
	
public:
	__fastcall TThreadHeatMap(TecHeatMap* Heatmap, System::Classes::TNotifyEvent doOnTerminate);
	__fastcall virtual ~TThreadHeatMap();
	virtual void __fastcall Execute();
};


class PASCALIMPLEMENTATION TecHeatMap : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	int FLeft;
	int FTop;
	int FLength;
	TThreadHeatMap* FThreadHeatMap;
	TArrayInteger FValues;
	TArrayInteger FDatas;
	TArrayColor FColors;
	int FMaxValue;
	int FRadius;
	int FWidth;
	int FHeight;
	THeatPalette* FPalette;
	Fmx::Uecmaputil::TGraphic* FBitmap;
	bool FPointIsDisc;
	System::Classes::TNotifyEvent FOnUpdate;
	void __fastcall Calc();
	void __fastcall Update();
	Fmx::Uecmaputil::TGraphic* __fastcall getBitmap();
	void __fastcall doTerminateThread(System::TObject* sender);
	
public:
	__fastcall TecHeatMap(const int aWidth, const int aHeight, System::Classes::TNotifyEvent EventPaleteChange);
	__fastcall virtual ~TecHeatMap();
	void __fastcall CopyToBitmap(Fmx::Uecmaputil::TGraphic* Value);
	void __fastcall setSize(const int aWidth, const int aHeight);
	bool __fastcall Add(const int X, const int Y, const int Value);
	void __fastcall Clear();
	int __fastcall getValue(const int X, const int Y);
	bool __fastcall Ready();
	bool __fastcall BeginUpdate();
	__property TArrayInteger Datas = {read=FDatas};
	__property TArrayInteger Values = {read=FValues};
	__property int Width = {read=FWidth, nodefault};
	__property int Height = {read=FHeight, nodefault};
	__property Fmx::Uecmaputil::TGraphic* Bitmap = {read=getBitmap};
	__property int MaxValue = {read=FMaxValue, write=FMaxValue, nodefault};
	__property int Radius = {read=FRadius, write=FRadius, nodefault};
	__property bool PointIsDisc = {read=FPointIsDisc, write=FPointIsDisc, nodefault};
	__property THeatPalette* Palette = {read=FPalette};
	__property int Left = {read=FLeft, write=FLeft, nodefault};
	__property int Top = {read=FTop, write=FTop, nodefault};
	__property System::Classes::TNotifyEvent OnUpdate = {read=FOnUpdate, write=FOnUpdate};
};


//-- var, const, procedure ---------------------------------------------------
}	/* namespace Uecheatmap */
}	/* namespace Fmx */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX_UECHEATMAP)
using namespace Fmx::Uecheatmap;
#endif
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX)
using namespace Fmx;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Fmx_UecheatmapHPP
