unit FMX.uecLegendPanel;

interface
 uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics,  FMX.Objects, System.UIConsts,
  FMX.Layouts,FMX.Controls.Presentation,FMX.StdCtrls,FMX.uecNativeMapControl;


type

TGraphic = TBitmap;
TColor   = TAlphaColor;

TPanelCustomLegende = class(TRectangle)
  private
   function  getBorderColor : TColor;
   procedure setBorderColor(const AColor:TColor);
   function  getColor : TColor;
   procedure setColor(const AColor:TColor);

  protected

  public
    property BorderColor : TColor read getBorderColor write setBorderColor;
    property Color : TColor read getColor write setColor;
  end;

  TVisualAlignment = (valLeft,valRight);
  TVisualStyle  =  (vsFrame,vsFillRect,vsSolidLine,vsDotLine,vsDashLine,vsDashDotLine);

  TItemLegend = class(TRectangle)
  private
   FOnItemCheckBoxChange,
   FOnItemClick : TNotifyEvent;
   FCheckBox: TCheckBox;
   FColor,
   FSepa    : TPanelCustomLegende;
   FPCaption: TPanelCustomLegende;
   FCaption : TLabel;
   FLine    : TLine;
   FImage   : TImage;
   FTagObject : TObject;
   FVisualStyle : TVisualStyle;
   FVisualAlignment : TVisualAlignment;
   FItemAlignment   : TTextAlign;

   function   getColor : TColor;
   procedure  setColor(const AColor:TColor);

   function   getBorderColor : TColor;
   procedure  setBorderColor(const AColor:TColor);

   function   getGraphic : TGraphic;
   procedure  setGraphic(const AGraphic:TGraphic);

   function   getCaption : string;
   procedure  setCaption(const ACaption:String);

   procedure setItemAlignment(const AValue:TTextAlign);
   procedure setVisualAlignment(const AValue:TVisualAlignment);

   procedure setVisualStyle(const AValue:TVisualStyle);
   procedure setVisualWeight(const AValue:integer);
   function  getVisualWeight : integer;


   procedure setVisualWidth(const AValue:integer);
   function  getVisualWidth:integer;

   procedure setFontSize(const AValue:integer);
   function  getFontSize:integer;

   procedure setFontName(const AValue:string);
   function  getFontName : string;

   procedure setFontColor(const AValue:TColor);
   function  getFontColor : TColor;

   procedure setItemChecked(const AValue:boolean);
   function  getItemChecked:boolean;

   procedure setItemCheckBox(const AValue:boolean);
   function  getItemCheckBox:boolean;

   procedure setItemHeight(const AValue:integer);
   function  getItemHeight:integer;
   function  MinHeight:integer;

   procedure  doclick(Sender:TObject);
   procedure  doCheckBox(Sender:TObject);
  public
    constructor Create(AOwner:TComponent); override;

    function isGraphic:boolean;

    property ItemColor   : TColor read getColor     write setColor;
    property ItemBorderColor   : TColor read getBorderColor  write setBorderColor;
    property ItemCaption : String read getCaption   write setCaption;
    property ItemChecked : boolean read getItemChecked write setItemChecked;
    property ItemCheckBox: boolean read getItemCheckBox write setItemCheckBox;
    property ItemGraphic : TGraphic read getGraphic write setGraphic;
    property ItemVisualStyle : TVisualStyle read FVisualStyle write setVisualStyle;
    property ItemVisualWidth : integer read getVisualWidth write setVisualWidth;
    property ItemVisualWeight: integer read getVisualWeight write setVisualWeight;

    property ItemVisualAlignment : TVisualAlignment read FVisualAlignment write setVisualAlignment;
    property ItemAlignment : TTextAlign read FItemAlignment write setItemAlignment;
    property ItemFontSize : integer read getFontsize write setFontSize;
    property ItemFontName : string read getFontName write setFontName;
    property ItemFontColor : TColor read getFontColor write setFontColor;
    property ItemHeight: integer read getItemHeight write setItemHeight;



    property ItemObject : TObject read FTagObject write FTagObject;
  end;


  TPanelLegend = class(TPanelCustomLegende)
  private
   FScrollBox:TScrollBox;
   FFooter,
   FTitle : TLabel;
   FList  : TList;
   FOnItemCheckBoxChange : TNotifyEvent;
   FOnItemClick : TNotifyEvent;
   FItemHeight  : integer;
   FVisualWeight,
   FVisualWidth : integer;
   FFontSize    : integer;
   FItemAlignment   : TTextAlign;
   FVisualAlignment : TVisualAlignment;
   FItemCheckBox: boolean;

   procedure doClick(Sender : TObject);

   procedure setItemHeight( const AValue : integer);
   procedure doCheckBoxChange(Sender : TObject);

   procedure setVisualAlignment( const AValue : TVisualAlignment);
   procedure setItemCheckBox(const AValue:boolean);
   procedure setItemAlignment(const AValue:TTextAlign);

   procedure setVisualWeight( const AValue : integer);

   procedure setVisualWidth( const AValue : integer);
   procedure setFontSize( const AValue : integer);

   procedure setTitleFontSize( const AValue : integer);
   function  getTitleFontSize : integer;

   function  getTitleFontName : string;
   procedure setTitleFontName( const AValue : string);

   function  getFontColor : TColor;
   procedure setFontColor( const AValue : TColor);

   function  getTitle : string;
   procedure setTitle(const ATitle:string);

   function  getTitleAlignment : TTextAlign;
   procedure setTitleAlignment(const AValue:TTextAlign);

   function  getFooterAlignment : TTextAlign;
   procedure setFooterAlignment(const AValue:TTextAlign);
   function  getFooter : string;
   procedure setFooter(const ATitle:string);
   procedure setFooterFontSize( const AValue : integer);
   function  getFooterFontSize : integer;

   function getCount:integer;
   function getItem(index:integer): TItemLegend;
  public
   constructor Create(AOwner:TComponent); override;
   destructor  Destroy;override;


   function Add(const ACaption:string;
                const AColor:TColor;
                const AStyle:TVisualStyle=vsFillRect;
                const AObject:TObject=nil):TItemLegend;  overload;
   function Add(const ACaption:string;
                const AGraphic:TGraphic;
                const AObject:TObject=nil):TItemLegend; overload;

   procedure Delete(index:integer);

   property Count : integer read getCount;
   property Items[Index:integer] : TItemLegend read getItem;

   property VisualAlignment : TVisualAlignment read FVisualAlignment write setVisualAlignment;
   property VisualWidth   : integer read FVisualWidth write setVisualWidth;
   property VisualWeight  : integer read FVisualWeight write setVisualWeight;
   property ItemAlignment : TTextAlign read FItemAlignment write setItemAlignment;
   property ItemCheckBox  : boolean    read FItemCheckBox  write setItemCheckBox;

   property ItemFontSize  : integer read FFontSize write setFontSize;
   property ItemHeight    : integer    read FItemHeight write setItemHeight;

   property TitleFontSize : integer read getTitleFontSize write setTitleFontSize;
   property FooterFontSize: integer read getFooterFontSize write setFooterFontSize;
   property FontName      : string  read getTitleFontName write setTitleFontName;
   property FontColor     : TColor  read getFontColor     write setFontColor;


   property Title : string read getTitle write setTitle;
   property TitleAlignment : TTextAlign read getTitleAlignment write setTitleAlignment;
   property Footer : string read getFooter write setFooter;
   property FooterAlignment : TTextAlign read getFooterAlignment write setFooterAlignment;

   property OnItemClick : TNotifyEvent read FOnItemClick write FOnItemClick;
  end;


  TLegendComponent = class(TECCustomTool)
  private
   FLegend : TPanelLegend;
   FXYRadius : single;

   procedure setXYRadius(const Value: single);
  public
   constructor Create(Map : TNativeMapControl);  override;
   destructor  Destroy; override;

   property Legend : TPanelLegend read FLegend;
   property XYRadius : single read FXYRadius write setXYRadius;
  end;


implementation

function Largest(x, y: integer): integer; {$IFDEF D2010_OR_HIGHER}inline;
{$ENDIF}
begin
  if x > y then
    Result := x
  else
    Result := y;
end;

function GetShadowColorBy(BaseColor: TColor; const Value: integer): TColor;
begin

  TAlphaColorRec(BaseColor).R :=
    Largest(TAlphaColorRec(BaseColor).R - Value, 0);
  TAlphaColorRec(BaseColor).G :=
    Largest(TAlphaColorRec(BaseColor).G - Value, 0);
  TAlphaColorRec(BaseColor).B :=
    Largest(TAlphaColorRec(BaseColor).B - Value, 0);

  Result := BaseColor;

end;

constructor TLegendComponent.Create(Map : TNativeMapControl);
begin
   inherited;

   FLegend := TPanelLegend.create(Map);
    // Anchoring the panel on the map
   add('Legend',FLegend,ecTopRight);
   XYRadius := 0;
end;


Destructor TLegendComponent.Destroy;
begin
  inherited;
  FLegend.Free;
end;

procedure TLegendComponent.setXYRadius(const Value: single);
begin


  if Value <= 10 then
    FXYRadius := Value
  else
  if FXYRadius=10 then
   exit
  else
    FXYRadius := 10;



   FLegend.XRadius := FXYRadius;
   FLegend.YRadius := FXYRadius;

end;



 function TPanelLegend.getCount:integer;
begin
 result := FList.count;
end;

function TPanelLegend.getItem(index:integer): TItemLegend;
begin
  result := nil;

  if (index>=0) and (index<FList.Count) then
   result := TItemLegend(FList[index]);
end;


procedure TPanelLegend.Delete(index:integer);
begin
    if (index>=0) and (index<FList.Count) then
    begin
     TItemLegend(FList[index]).free;
     FList.Delete(index);
    end;
end;

function  TPanelLegend.getTitle : string;
begin
  result := FTitle.Text;
end;

procedure TPanelLegend.setTitle(const ATitle:string);
begin
 FTitle.text := ATitle;

 FTitle.Visible := ATitle<>'';

 if FTitle.Visible then
  FTitle.position.y := 0;
end;


function  TPanelLegend.getTitleAlignment : TTextAlign;
begin
  result := FTitle.TextSettings.HorzAlign;
end;

procedure TPanelLegend.setTitleAlignment(const AValue:TTextAlign);
begin
  FTitle.TextSettings.HorzAlign := AValue;
end;

function  TPanelLegend.getFooterAlignment : TTextAlign;
begin
  result := FFooter.TextSettings.HorzAlign;
end;

procedure TPanelLegend.setFooterAlignment(const AValue:TTextAlign);
begin
 FFooter.TextSettings.HorzAlign := AValue;
end;


function  TPanelLegend.getFooter : string;
begin
 result := FFooter.Text;
end;

procedure TPanelLegend.setFooter(const ATitle:string);
begin
 FFooter.Text := ATitle;

 FFooter.Visible := ATitle<>'';

 if FFOoter.Visible then
  FFooter.Position.y := Height;


end;

procedure TPanelLegend.setFooterFontSize( const AValue : integer);
begin
 FFooter.TextSettings.font.size := AValue;
end;

function  TPanelLegend.getFooterFontSize : integer;
begin
  result := round(FFooter.TextSettings.font.size);
end;

constructor TPanelLegend.Create(AOwner:TComponent);
begin

  inherited Create(AOwner);



  FList := TList.create;

  FVisualAlignment := valLeft;
  {$IF CompilerVersion >= 27 }
    FItemAlignment := TTextAlign.Leading;
  {$ELSE}
    FItemAlignment := TTextAlign.taLeading;
  {$ENDIF}

  Parent := TFmxObject(AOwner);
  
  Height := 150;
  width  := 150;

  Opacity := 1;

  padding.left := 3;
  padding.top  := 3;
  padding.right := 3;
  padding.bottom:=3;


  FTitle            := TLabel.Create(AOwner);
  FTitle.Parent     := self;


  FTitle.Text := '';
  FTitle.StyledSettings := [];


  FTitle.TextSettings.font.size  := 20;
  FTitle.Font.style := [TFontStyle.fsBold];

  FTitle.autoSize   := true;
  {$IF CompilerVersion >= 27 }
  FTitle.align      := TAlignLayout.Top;
  {$ELSE}
  FTitle.align      := TAlignLayout.alTop;
  {$ENDIF}
  FTitle.Visible    := false;


  FScrollBox := TScrollBox.Create(AOwner);
  FScrollBox.Parent := self;
  {$IF CompilerVersion >= 27 }
  FScrollBox.align  := TAlignLayout.Client;
  {$ELSE}
  FScrollBox.align  := TAlignLayout.alClient;
  {$ENDIF}

  FScrollBox.position.y    := FTitle.Height;

  FFooter            := TLabel.Create(AOwner);
  FFooter.Parent     := self;
  FFooter.text := '';
  FFooter.font.size  := 10;
  FFooter.autoSize   := true;
  {$IF CompilerVersion >= 27 }
  FFooter.align      := TAlignLayout.Bottom;
  {$ELSE}
  FFooter.align      := TAlignLayout.alBottom;
  {$ENDIF}
  FFooter.Visible    := false;
  {$IF CompilerVersion >= 27 }
    FooterAlignment    := TTextAlign.Center;
  {$ELSE}
    FooterAlignment    := TTextAlign.taCenter;
  {$ENDIF}


  FVisualWidth     := 16;
  FFontSize        := 14;
  FItemHeight      := 24;
  FVisualWeight    := 2;

end;

destructor  TPanelLegend.Destroy;
begin
  FList.free;
  inherited;
end;

function TPanelLegend.getTitleFontSize : integer;
begin
  result := round(FTitle.TextSettings.font.size);
end;

procedure TPanelLegend.setTitleFontSize( const AValue : integer);
begin
  FTitle.TextSettings.font.size := AValue;
end;

function TPanelLegend.getTitleFontName : string ;
begin
  result := FTitle.TextSettings.font.Family;
end;

procedure TPanelLegend.setTitleFontName( const AValue : string);
var i:integer;
begin
  FTitle.TextSettings.font.Family  := AValue;
  FFooter.TextSettings.Font.Family := AValue;

  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemFontName := AValue;
end;

function  TPanelLegend.getFontColor : TColor;
begin
  result := FTitle.TextSettings.fontcolor;
end;

procedure TPanelLegend.setFontColor( const AValue : TColor);
var i:integer;
begin
  FTitle.TextSettings.fontColor  := AValue;
  FFooter.TextSettings.FontColor := AValue;

  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemFontColor := AValue;

end;

procedure TPanelLegend.setFontSize( const AValue : integer);
var i:integer;
begin
  FFontSize := AValue;
  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemFontSize := AValue;
end;


procedure TPanelLegend.setItemAlignment(const AValue:TtextAlign);
 var i:integer;
begin


  FItemAlignment := AValue;
  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemAlignment := AValue;


end;

procedure TPanelLegend.setItemCheckBox(const AValue:boolean);
var i:integer;
begin

  FItemCheckBox := AValue;
  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemCheckBox := AValue;


end;


procedure TPanelLegend.setItemHeight( const AValue : integer);
var i:integer;
begin

  FItemHeight := AValue;
  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemHeight := AValue;

end;

procedure TPanelLegend.setVisualWeight( const AValue : integer);
var i:integer;
begin

 FVisualWeight := AValue;


  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemVisualWeight := AValue;

end;

procedure TPanelLegend.setVisualAlignment( const AValue : TVisualAlignment);
 var i:integer;
begin


  FVisualAlignment := AValue;
  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemVisualAlignment := AValue;

end;


procedure TPanelLegend.setVisualWidth( const AValue : integer);
var i:integer;
begin
  FVisualWidth := AValue;
  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemVisualWidth := AValue;
end;

procedure TPanelLegend.doClick(Sender : TObject);
begin
  if assigned(FOnItemClick) then
   FOnItemClick(Sender);
end;

procedure TPanelLegend.doCheckBoxChange(Sender : TObject);
begin
  if assigned(FOnItemCheckBoxChange) then
   FOnItemCheckBoxChange(Sender);
end;


function TPanelLegend.Add(const ACaption:string;const AGraphic:TGraphic; const AObject:TObject=nil):TItemLegend;
begin
  result                 := TItemLegend.Create(FScrollBox);
  result.FOnItemClick    := doClick;
  result.FOnItemCheckBoxChange := doCheckBoxChange;
  result.ItemGraphic     := AGraphic;
  result.ItemCaption     := ACaption;
  result.tagObject       := AObject;
  result.ItemVisualWidth := VisualWidth;
  result.ItemFontSize    := ItemFontsize;
  result.ItemFontName    := FontName;
  result.position.y      := FList.count*result.Height;
  result.ItemVisualAlignment := FVisualAlignment;
  result.ItemAlignment := FItemAlignment;
  result.ItemCheckBox := ItemCheckBox;
  FList.add(result);
end;



function TPanelLegend.Add(const ACaption:string;const AColor:TColor;const AStyle:TVisualStyle=vsFillRect; const AObject:TObject=nil):TItemLegend;
begin
  result                 := TItemLegend.Create(FScrollBox);
  result.FOnItemClick    := doClick;
  result.FOnItemCheckBoxChange := doCheckBoxChange;

  if AStyle=vsFrame then
  begin
   result.ItemColor       := claNull;
   result.itemBorderColor := AColor;
  end
  else
  result.ItemColor       := AColor;

  result.ItemCaption     := ACaption;
  result.tagObject       := AObject;
  result.ItemVisualWidth := VisualWidth;
  result.ItemFontSize    := ItemFontsize;
  result.ItemFontName    := FontName;
  result.ItemVisualStyle := AStyle;
  result.position.y      := FList.count*result.Height;
  result.ItemVisualAlignment := FVisualAlignment;
  result.ItemAlignment := FItemAlignment;
  result.ItemVisualWeight := FVisualWeight;
  result.ItemCheckBox := ItemCheckBox;



  FList.add(result);
end;



procedure  TItemLegend.doclick(Sender:TObject);
begin
  if assigned(FOnItemClick) then
   FOnItemClick(Self);
end;


procedure  TItemLegend.doCheckBox(Sender:TObject);
begin
  if assigned(FOnItemCheckBoxChange) then
   FOnItemCheckBoxChange(Self);
end;

function   TItemLegend.getColor : TColor;
begin
  result := FColor.Fill.Color;
end;


function   TItemLegend.getGraphic : TGraphic;
begin
   result := FImage.Bitmap;
end;

procedure  TItemLegend.setGraphic(const AGraphic:TGraphic);
begin
 if assigned(AGraphic) then
 begin

  FImage.Bitmap.Assign(AGraphic);
  FImage.Width := AGraphic.Width;
  Height       := AGraphic.Height+Padding.Top+Padding.Bottom;


  FColor.Width       := Largest(round(FImage.Width),round(FColor.Width));

  FImage.Visible     := true;
  FLine.Visible      := false;
  FColor.Fill.Color  := 0;//Fill.Color;
  FColor.BorderColor := 0;//fill.Color;
 end
 else ItemVisualStyle    := ItemVisualStyle ;
end;

procedure  TItemLegend.setColor(const AColor:TColor);
begin
 FImage.Visible     := false;
 FImage.bitmap.assign(nil);
 FLine.Stroke.Color := AColor;
 FColor.fill.Color  := AColor;
 FColor.Stroke.Color := AColor;
 {$IF CompilerVersion >= 27 }
  FColor.fill.Kind := TBrushKind.solid;
  FColor.Stroke.Kind := TBrushKind.solid;
{$ELSE}
  FColor.fill.Kind := TBrushKind.bkSolid;
  FColor.Stroke.Kind := TBrushKind.bkSolid;
{$ENDIF}
 FColor.BorderColor := GetShadowColorBy(AColor,32);
end;


procedure  TItemLegend.setBorderColor(const AColor:TColor);
begin
  FColor.BorderColor := AColor;
end;

function  TItemLegend.getBorderColor:TColor;
begin
  result := FColor.BorderColor;
end;

procedure TItemLegend.setItemAlignment(const AValue:TTextAlign);
begin
 FItemAlignment     := AValue;
 Fcaption.TextAlign := AValue;
end;

procedure TItemLegend.setVisualAlignment(const AValue:TVisualAlignment);
begin

  FVisualAlignment := AValue;

  if FVisualAlignment=valRight then
  begin
   {$IF CompilerVersion >= 27 }
    FColor.Align          := TAlignLayout.Right;
   {$ELSE}
    FColor.Align          := TAlignLayout.alRight;
   {$ENDIF}
   {$IF CompilerVersion >= 27 }
    FSepa.Align          := TAlignLayout.Right;
   {$ELSE}
    FSepa.Align          := TAlignLayout.alRight;
   {$ENDIF}
    FSepa.Left   := FCaption.position.x+FCaption.Width;
    FColor.Left  := Fsepa.Left+7;
  end
  else
  begin
   {$IF CompilerVersion >= 27 }
    FColor.Align          := TAlignLayout.Left;
   {$ELSE}
    FColor.Align          := TAlignLayout.alLeft;
   {$ENDIF}
   {$IF CompilerVersion >= 27 }
    FSepa.Align          := TAlignLayout.Left;
   {$ELSE}
    FSepa.Align          := TAlignLayout.Left;
   {$ENDIF}
    FColor.Left := 0;
    FSepa.Left  := FColor.Width;
  end;


end;


procedure TItemLegend.setVisualStyle(const AValue:TVisualStyle);
begin
 FImage.Visible     := false;
 FImage.bitmap.assign(nil);
 FLine.visible := (AValue<>vsFrame) and (AValue<>vsFillRect);
 FVisualStyle  := AValue;
  if FLine.visible then
 begin
  FColor.Color := 0;//TPanelLegend(Parent.Parent.Parent).fill.Color;
  FColor.BorderColor := 0;//FColor.fill.Color;
  case AValue of
    vsSolidLine  : FLine.Stroke.Dash := TStrokeDash.Solid;
    vsDotLine    : FLine.Stroke.Dash := TStrokeDash.Dot;
    vsDashLine   : FLine.Stroke.Dash := TStrokeDash.Dash;
    vsDashDotLine: FLine.Stroke.Dash := TStrokeDash.DashDot;
  end;

 end
 else
 begin
   if AValue=vsFrame then
   FColor.Color       := claNull
   else
   begin
   FColor.Color := FLine.stroke.Color;
   FColor.BorderColor := FLine.stroke.Color;
   end;
 end;
end;

procedure TItemLegend.setVisualWeight(const AValue:integer);
begin
 FLine.Stroke.Thickness := AValue;
 FLine.Margins.Bottom   := (FColor.Height - FLine.Stroke.Thickness) / 2;
end;

function  TItemLegend.getVisualWeight : integer;
begin
  result := round(FLine.Stroke.Thickness);
end;


procedure TItemLegend.setVisualWidth(const AValue:integer);
begin
  FColor.Width := AValue;
end;

function TItemLegend.getVisualWidth:integer;
begin
  result := round(FColor.Width);
end;


procedure TItemLegend.setItemCheckBox(const AValue:boolean);
begin
 FCheckBox.Visible := AValue;
 FCheckBox.position.x    := 0;
end;

function  TItemLegend.getItemCheckBox:boolean;
begin
 result := FCheckBox.Visible;
end;

procedure TItemLegend.setItemChecked(const AValue:boolean);
begin
  FCheckBox.isChecked := AValue;
end;

function  TItemLegend.getItemChecked:boolean;
begin
 result := FCheckBox.isChecked ;
end;

procedure TItemLegend.setItemHeight(const AValue:integer);
begin
  Height := Largest(AValue,MinHeight);
end;

function  TItemLegend.getItemHeight:integer;
begin
 result := round(Height);
end;

function  TItemLegend.MinHeight:integer;
begin
   result := round(FCaption.Canvas.textHeight(FCaption.text) + Padding.Top+ Padding.Bottom);
end;


procedure TItemLegend.setFontColor(const AValue:TColor);
begin
  Fcaption.TextSettings.FontColor := AValue;
end;

function  TItemLegend.getFontColor:TColor;
begin
 result := Fcaption.TextSettings.FontColor;
end;

procedure TItemLegend.setFontName(const AValue:string);
begin
 Fcaption.TextSettings.Font.Family := AValue;
 ItemFontSize := ItemFontSize;
end;

function  TItemLegend.getFontName:string;
begin
  result := Fcaption.TextSettings.Font.Family;
end;


procedure TItemLegend.setFontSize(const AValue:integer);
begin
   FCaption.AutoSize := true;
   Fcaption.TextSettings.Font.Size := AValue;
   ItemHeight :=  round(Avalue + Padding.Top+ Padding.Bottom);
   FLine.Margins.Bottom   := (FColor.Height - FLine.Stroke.Thickness) / 2;
   FCaption.AutoSize := false;
end;

function  TItemLegend.getFontSize:integer;
begin
  result := round(Fcaption.Font.Size);
end;


function   TItemLegend.getCaption : string;
begin
  result := FCaption.text;
end;

procedure  TItemLegend.setCaption(const ACaption:String);
begin
   FCaption.text := ACaption;

   FCaption.AutoSize := true;
   ItemHeight := round(Fcaption.TextSettings.Font.Size + Padding.Top+ Padding.Bottom);
   FLine.Margins.Bottom   := (FColor.Height - FLine.Stroke.Thickness) / 2;
   FCaption.AutoSize := false;
end;


function TItemLegend.isGraphic:boolean;
begin
   result := assigned(ItemGraphic) and (ItemGraphic.Width>0);
end;

constructor TItemLegend.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);

  FVisualStyle := vsFrame;

  // parent is TScrollBoxContent
  Parent           := TFmxObject(AOwner);


   {$IF CompilerVersion >= 27 }
     fill.Kind := TBrushKind.None;
     Stroke.Kind := TBrushKind.None;
   {$ELSE}
     fill.Kind := TBrushKind.bkNone;
     Stroke.Kind := TBrushKind.bkNone;
    {$ENDIF}

  // TScrollBoxContent > TScrollBox > TPanelLegend
  (*Fill.Color       := TPanelLegend(Parent.Parent.Parent).Fill.Color;
  Stroke.Color     := TPanelLegend(Parent.Parent.Parent).Fill.Color;*)

  {$IF CompilerVersion >= 27 }
  Align            := TAlignLayout.Top;
  {$ELSE}
  Align            := TAlignLayout.alTop;
  {$ENDIF}

  Padding.Top      := 3;
  Padding.Bottom   := 3;
  Padding.Left     := 3;
  Padding.right    := 3;

  FColor                := TPanelCustomLegende.Create(AOwner);
  FColor.Parent         := self;
  {$IF CompilerVersion >= 27 }
  FColor.Align          := TAlignLayout.Left;
  {$ELSE}
  FColor.Align          := TAlignLayout.alLeft;
  {$ENDIF}
  FColor.Width          := 16;

  FColor.Padding.Left   := 0;
  FColor.Padding.right  := 0;
  FColor.Padding.top    := 0;
  FColor.Padding.bottom := 0;
  FColor.OnClick:= doclick;
  FColor.Cursor := crHandPoint;

   {$IF CompilerVersion >= 27 }
     FCOlor.fill.Kind := TBrushKind.None;
    // FCOlor.Stroke.Kind := TBrushKind.None;
   {$ELSE}
     FCOlor.fill.Kind := TBrushKind.bkNone;
     //FColor.Stroke.Kind := TBrushKind.bkNone;
    {$ENDIF}

  FLine         := TLine.Create(AOwner);
  FLine.Parent  := FColor;
   {$IF CompilerVersion >= 27 }
  FLine.Align        := TAlignLayout.client;
  {$ELSE}
  FLine.Align        := TAlignLayout.alVerCenter;
  {$ENDIF}
  FLine.OnClick      := doclick;
  FLine.Cursor       := crHandPoint;
  FLine.LineType     := TLineType.Bottom;
  FLine.visible      := false;

  FLine.Margins.Bottom   := (FColor.Height - FLine.Stroke.Thickness) / 2;

  FImage              := TImage.Create(AOwner);
  FImage.Parent       := FColor;
  {$IF CompilerVersion >= 27 }
  FImage.Align        := TAlignLayout.Client;
  {$ELSE}
  FImage.Align        := TAlignLayout.alClient;
  {$ENDIF}
  FImage.OnClick      := doclick;
  FImage.Cursor       := crHandPoint;
  FImage.WrapMode     := TImageWrapMode.fit;
  FImage.Visible      := false;


  FSepa := TPanelCustomLegende.Create(AOwner);
  FSepa.Parent := self;
  FSepa.Position.X := FImage.Width;
  FSepa.Left   := FColor.Width;
  {$IF CompilerVersion >= 27 }
  FSepa.Align  := TAlignLayout.Left;
  {$ELSE}
  FSepa.Align  := TAlignLayout.alLeft;
  {$ENDIF}
  FSepa.Width := Padding.left;
  {$IF CompilerVersion >= 27 }
     FSepa.fill.Kind := TBrushKind.None;
     FSepa.Stroke.Kind := TBrushKind.None;
   {$ELSE}
     FSepa.fill.Kind := TBrushKind.bkNone;
     FSepa.Stroke.Kind := TBrushKind.bkNone;
    {$ENDIF}


  FPCaption := TPanelCustomLegende.Create(AOwner);
  FPCaption.Parent := self;
  FPCaption.Left   := FSepa.Left+10;
   {$IF CompilerVersion >= 27 }
  FPCaption.Align  := TAlignLayout.Client;
  {$ELSE}
  FPCaption.Align  := TAlignLayout.alClient;
  {$ENDIF}

  {$IF CompilerVersion >= 27 }
   FPCaption.fill.Kind := TBrushKind.None;
   FPCaption.Stroke.Kind := TBrushKind.None;
   {$ELSE}
    FPCaption.fill.Kind := TBrushKind.bkNone;
    FPCaption.Stroke.Kind := TBrushKind.bkNone;
   {$ENDIF}



  FCaption := TLabel.Create(AOwner);
  FCaption.StyledSettings := [];

  FCaption.Parent := FPCaption; //self;
  FCaption.OnClick:= doclick;
  FCaption.Cursor := crHandPoint;
  Height := Fcaption.TextSettings.Font.Size + Padding.Top+ Padding.Bottom;
  {$IF CompilerVersion >= 27 }
  FCaption.Align  := TAlignLayout.bottom;
  {$ELSE}
  FCaption.Align  := TAlignLayout.alBottom;
  {$ENDIF}
  FCaption.WordWrap := false;
  FCaption.HitTest:= true;

  FCheckBox := TCheckBox.Create(AOwner);
  FCheckBox.Parent         := self;
  {$IF CompilerVersion >= 27 }
  FCheckBox.Align          := TAlignLayout.Left;
  {$ELSE}
  FCheckBox.Align          := TAlignLayout.alLeft;
  {$ENDIF}
  FCheckBox.Width          := 24;
  FCheckBox.text           := '';
  FCheckBox.position.x     := 0;
  FCheckBox.OnClick        := doCheckBox;

end;

procedure TPanelCustomLegende.setBorderColor(const AColor:TColor);
begin
 Stroke.Color := AColor;
end;

procedure TPanelCustomLegende.setColor(const AColor:TColor);
begin
  Fill.Color := AColor;
end;

function TPanelCustomLegende.getBorderColor : TColor;
begin
 result := Stroke.Color ;
end;

function TPanelCustomLegende.getColor : TColor ;
begin
  result := Fill.Color;
end;




end.
