﻿// CodeGear C++Builder
// Copyright (c) 1995, 2023 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'FMX.uecNativeMapControl.pas' rev: 36.00 (Windows)

#ifndef Fmx_UecnativemapcontrolHPP
#define Fmx_UecnativemapcontrolHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.SysUtils.hpp>
#include <System.Types.hpp>
#include <System.UITypes.hpp>
#include <System.Rtti.hpp>
#include <System.Classes.hpp>
#include <System.StrUtils.hpp>
#include <System.Threading.hpp>
#include <System.Generics.Collections.hpp>
#include <System.Generics.Defaults.hpp>
#include <FMX.ImgList.hpp>
#include <System.Messaging.hpp>
#include <System.Math.Vectors.hpp>
#include <System.SyncObjs.hpp>
#include <System.UIConsts.hpp>
#include <FMX.Graphics.hpp>
#include <FMX.Dialogs.hpp>
#include <FMX.Gestures.hpp>
#include <System.IOUtils.hpp>
#include <FMX.Ani.hpp>
#include <FMX.uecVectorStyles_standard.hpp>
#include <FMX.Layouts.hpp>
#include <FMX.uecNativeMeasureMap.hpp>
#include <FMX.uecMapZip.hpp>
#include <FMX.uecOpenWeather.hpp>
#include <FMX.uecGeoHash.hpp>
#include <FMX.uecOpenLocationCode.hpp>
#include <FMX.uecHeatmap.hpp>
#include <FMX.uecHttp.hpp>
#include <FMX.uecGraphics.hpp>
#include <FMX.uecBingRest.hpp>
#include <FMX.uecMapUtil.hpp>
#include <FMX.uecMapFile.hpp>
#include <FMX.uecNativeShape.hpp>
#include <FMX.uecgeoLocalise.hpp>
#include <FMX.uecThreadGraphics.hpp>
#include <FMX.uecNativeTileServer.hpp>
#include <FMX.Types.hpp>
#include <FMX.Controls.hpp>
#include <FMX.Forms.hpp>
#include <FMX.Objects.hpp>
#include <FMX.Platform.hpp>

//-- user supplied -----------------------------------------------------------

namespace Fmx
{
namespace Uecnativemapcontrol
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TECComponent;
class DELPHICLASS TECComponents;
class DELPHICLASS TECMapComponents;
class DELPHICLASS TECCustomTool;
class DELPHICLASS TOLCNativeMap;
class DELPHICLASS TECScaleBar;
class DELPHICLASS TECNativeFreeHand;
class DELPHICLASS TECNativeGeoHash;
class DELPHICLASS TECOverlayTileLayer;
class DELPHICLASS TECVaneTiles;
class DELPHICLASS TECOpenWeatherTilesLayer;
class DELPHICLASS TECHeatmapLayer;
class DELPHICLASS TECNativeLayer;
class DELPHICLASS TECTimeDimension;
struct TECRecordLayer;
class DELPHICLASS TECNativeWMS;
struct TECRecordFeature;
class DELPHICLASS TECNativeWFS;
class DELPHICLASS TECWMSLayers;
class DELPHICLASS TECWFSLayers;
class DELPHICLASS TECNativeUTFLayer;
class DELPHICLASS TLayoutMapItemDraw;
class DELPHICLASS TLayoutMap;
class DELPHICLASS TNativeMapControl;
class DELPHICLASS TECNativeMap;
class DELPHICLASS TECXapiLayer;
class DELPHICLASS TECOffScreenScreenShot;
class DELPHICLASS TECIsoChrone;
class DELPHICLASS TECRouting;
class DELPHICLASS TECItinerarySegment;
class DELPHICLASS TECItinerary;
class DELPHICLASS TECTurnByTurn;
struct TAirQualityItem;
struct TAirQualityCity;
class DELPHICLASS TAirQualityData;
class DELPHICLASS TECAirQuality;
class DELPHICLASS TECBBoxData;
class DELPHICLASS TECBBoxDataCacheList;
class DELPHICLASS TECGoogle;
class DELPHICLASS TECTomTomIncidentData;
class DELPHICLASS TECTomTom;
class DELPHICLASS TECTomTomIncident;
class DELPHICLASS TECPTV;
class DELPHICLASS TECSelectArea;
class DELPHICLASS TECGrid;
class DELPHICLASS TECGrids;
struct TECChartField;
class DELPHICLASS TECChartItem;
class DELPHICLASS TECChartLayer;
class DELPHICLASS TECChartLayers;
class DELPHICLASS TECBubbleItem;
class DELPHICLASS TECBubbleLayer;
class DELPHICLASS TECBubbleLayers;
class DELPHICLASS TECGraticule;
class DELPHICLASS TECDrawPath;
class DELPHICLASS TECDownLoadTiles;
class DELPHICLASS TThreadECDownLoadTiles;
struct TECOverPassData;
class DELPHICLASS TEOverPass;
class DELPHICLASS TECOverPassApiLayer;
class DELPHICLASS TECOverPass;
class DELPHICLASS TECBoundary;
class DELPHICLASS TECSnapDrag;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TECComponentAlign : unsigned char { ecNone, ecTopLeft, ecTopRight, ecBottomLeft, ecBottomRight, ecLeftTop, ecRightTop, ecLeftBottom, ecRightBottom, ecTopCenter, ecBottomCenter, ecLeftCenter, ecRightCenter };

typedef Fmx::Controls::TControl TECDelphiComponent;

typedef void __fastcall (__closure *TECComponentRemove)(TECComponent* const AComponent);

typedef void __fastcall (__closure *TECComponentMove)(TECComponent* const AComponent, const int NewIndex);

class PASCALIMPLEMENTATION TECComponent : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FName;
	TECDelphiComponent* FComponent;
	TECComponentAlign FAlign;
	System::Classes::TNotifyEvent FOnUpdate;
	TECComponentRemove FdoRemove;
	TECComponentMove FdoMove;
	void __fastcall setAlign(const TECComponentAlign value);
	void __fastcall setComponent(TECDelphiComponent* const value);
	void __fastcall setLeft(const int value);
	void __fastcall setTop(const int value);
	int __fastcall getLeft();
	int __fastcall getTop();
	void __fastcall setWidth(const int value);
	void __fastcall setHeight(const int value);
	int __fastcall getWidth();
	int __fastcall getHeight();
	void __fastcall setVisible(const bool value);
	bool __fastcall getVisible();
	float __fastcall getOpacity();
	void __fastcall setOpacity(const float value);
	__property System::Classes::TNotifyEvent OnUpdate = {read=FOnUpdate, write=FOnUpdate};
	
public:
	void __fastcall Remove();
	void __fastcall Move(const int NewIndex);
	__property System::UnicodeString Name = {read=FName, write=FName};
	__property TECDelphiComponent* Component = {read=FComponent, write=setComponent};
	__property TECComponentAlign Align = {read=FAlign, write=setAlign, nodefault};
	__property int Width = {read=getWidth, write=setWidth, nodefault};
	__property int Height = {read=getHeight, write=setHeight, nodefault};
	__property int Top = {read=getTop, write=setTop, nodefault};
	__property int Left = {read=getLeft, write=setLeft, nodefault};
	__property bool Visible = {read=getVisible, write=setVisible, nodefault};
	__property float Opacity = {read=getOpacity, write=setOpacity};
public:
	/* TObject.Create */ inline __fastcall TECComponent() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TECComponent() { }
	
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECComponents : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECComponent* operator[](int index) { return this->Component[index]; }
	
private:
	System::Classes::TList* FList;
	int FTop;
	int FLeft;
	int FBottom;
	int FRight;
	int FMargin;
	void __fastcall doCheckAlign(System::TObject* Sender);
	void __fastcall doMove(TECComponent* const AComponent, const int NewIndex);
	void __fastcall setLeft(const int value);
	void __fastcall setTop(const int value);
	void __fastcall setBottom(const int value);
	void __fastcall setRight(const int value);
	void __fastcall setMargin(const int value);
	TECComponent* __fastcall getComponent(int index);
	
public:
	__fastcall TECComponents();
	__fastcall virtual ~TECComponents();
	TECComponent* __fastcall Add(const System::UnicodeString AName, TECDelphiComponent* const AComponent, const TECComponentAlign AAlign);
	TECComponent* __fastcall Find(const System::UnicodeString AName);
	int __fastcall IndexOf(const System::UnicodeString AName);
	void __fastcall Remove(const System::UnicodeString AName)/* overload */;
	void __fastcall Remove(const int AIndex)/* overload */;
	void __fastcall Remove(TECComponent* const AComponent)/* overload */;
	void __fastcall Move(const int CurIndex, const int NewIndex);
	void __fastcall Clear();
	int __fastcall Count();
	__property TECComponent* Component[int index] = {read=getComponent/*, default*/};
	__property int Top = {read=FTop, write=setTop, nodefault};
	__property int Left = {read=FLeft, write=setLeft, nodefault};
	__property int Bottom = {read=FBottom, write=setBottom, nodefault};
	__property int Right = {read=FRight, write=setRight, nodefault};
	__property int Margin = {read=FMargin, write=setMargin, nodefault};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECMapComponents : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECComponent* operator[](int index) { return this->Component[index]; }
	
private:
	TNativeMapControl* FMap;
	TECComponents* FECComponents;
	TECComponent* __fastcall getComponent(int index);
	
public:
	__fastcall TECMapComponents(TNativeMapControl* const Map);
	__fastcall virtual ~TECMapComponents();
	TECComponent* __fastcall Add(const System::UnicodeString AName, TECDelphiComponent* const AComponent, const TECComponentAlign AAlign)/* overload */;
	TECComponent* __fastcall Add(const int AMargin, const TECComponentAlign AAlign)/* overload */;
	int __fastcall IndexOf(const System::UnicodeString AName);
	void __fastcall Remove(const System::UnicodeString AName)/* overload */;
	void __fastcall Remove(const int AIndex)/* overload */;
	void __fastcall Remove(TECComponent* const AComponent)/* overload */;
	void __fastcall Move(const int CurIndex, const int NewIndex);
	void __fastcall Clear();
	int __fastcall Count();
	__property TECComponent* Component[int index] = {read=getComponent/*, default*/};
};

#pragma pack(pop)

enum DECLSPEC_DENUM TECCustomToolLayout : unsigned char { ctlVertical, ctlHorizontal };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECCustomTool : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TNativeMapControl* FMap;
	TECComponent* FComponent;
	TECCustomToolLayout FLayout;
	void __fastcall setAlign(const TECComponentAlign value);
	TECComponentAlign __fastcall getAlign();
	int __fastcall getWidth();
	void __fastcall setWidth(const int value);
	int __fastcall getHeight();
	void __fastcall setHeight(const int value);
	bool __fastcall getVisible();
	void __fastcall setVisible(const bool value);
	float __fastcall getOpacity();
	void __fastcall setOpacity(const float value);
	
protected:
	virtual void __fastcall setLayout(const TECCustomToolLayout value);
	
public:
	__fastcall virtual TECCustomTool(TNativeMapControl* Map);
	__fastcall virtual ~TECCustomTool();
	void __fastcall Add(const System::UnicodeString Name, TECDelphiComponent* const AComponent, const TECComponentAlign AAlign);
	__property TECComponentAlign Align = {read=getAlign, write=setAlign, nodefault};
	__property TECComponent* Component = {read=FComponent};
	__property TNativeMapControl* Map = {read=FMap};
	__property TECCustomToolLayout Layout = {read=FLayout, write=setLayout, nodefault};
	__property int Width = {read=getWidth, write=setWidth, nodefault};
	__property int Height = {read=getHeight, write=setHeight, nodefault};
	__property float Opacity = {read=getOpacity, write=setOpacity};
	__property bool Visible = {read=getVisible, write=setVisible, nodefault};
};

#pragma pack(pop)

typedef System::DynamicArray<System::TDateTime> ArrayOfTime;

enum DECLSPEC_DENUM TLegendPosition : unsigned char { lpTopLeft, lpTopRight, lpBottomLeft, lpBottomRight, lpTopCenter, lpBottomCenter, lpLeftCenter, lpRightCenter };

class PASCALIMPLEMENTATION TOLCNativeMap : public Fmx::Uecopenlocationcode::TecOpenLocationCode
{
	typedef Fmx::Uecopenlocationcode::TecOpenLocationCode inherited;
	
private:
	TNativeMapControl* FMap;
	
public:
	void __fastcall MoveTo(const System::UnicodeString OpenLocationCode);
public:
	/* TecOpenLocationCode.Create */ inline __fastcall TOLCNativeMap() : Fmx::Uecopenlocationcode::TecOpenLocationCode() { }
	
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TOLCNativeMap() { }
	
};


typedef void __fastcall (__closure *TOnMapLatLng)(System::TObject* sender, const double Lat, const double Lng);

typedef void __fastcall (__closure *TOnBeforeUrl)(System::TObject* sender, System::UnicodeString &Url);

typedef void __fastcall (__closure *TOnMapMouseWheel)(System::TObject* sender, const int wheelDelta);

typedef void __fastcall (__closure *TOnClusterClick)(System::TObject* sender, Fmx::Uecnativeshape::TECCluster* const Cluster);

typedef void __fastcall (__closure *TOnErrorLoadTiles)(System::TObject* sender, const int X, const int Y, const int Z, bool &ReloadTile);

typedef void __fastcall (__closure *TOnLoadGroup)(System::TObject* sender, const System::UnicodeString GroupName, const bool FinishLoading);

typedef void __fastcall (__closure *TOnPanoramioClick)(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item, const System::UnicodeString ownerId, const System::UnicodeString ownerName, const System::UnicodeString PhotoId, const System::UnicodeString PhotoDate, const System::UnicodeString PhotoTitle, const System::UnicodeString PhotoUrl, const System::UnicodeString copyright);

typedef void __fastcall (__closure *TOnShape)(Fmx::Uecnativeshape::TECShape* sender);

typedef void __fastcall (__closure *TOnMapPaint)(System::TObject* sender, Fmx::Uecgraphics::TECCanvas* const canvas);

typedef void __fastcall (__closure *TOnReticlePaint)(System::TObject* sender, Fmx::Uecgraphics::TECCanvas* const canvas, const int X, const int Y);

typedef void __fastcall (__closure *TOnMapSelectRect)(System::TObject* sender, const double SWLat, const double SWLng, const double NELat, const double NELng);

typedef void __fastcall (__closure *TOnMapGeofence)(System::TObject* sender, Fmx::Uecnativeshape::TECBaseGeofence* const Geofence, Fmx::Uecnativeshape::TECShape* const Item);

typedef void __fastcall (__closure *TOnFutureSnap)(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Guide, const double Lat, const double Lng);

typedef void __fastcall (__closure *TGetPolygoneFromID)(const __int64 Id, System::UnicodeString &JSON);

enum DECLSPEC_DENUM TLastAction : unsigned char { laNone, laZoomPlus, laZoomMoins, laPan, laTile, laAnimation, laZoomAnim };

enum DECLSPEC_DENUM TMapAnimation : unsigned char { maNone, maZoom, maPinchZoom, maPan };

enum DECLSPEC_DENUM TDragRect : unsigned char { drNone, drZoom, drSelect, drManualSelect };

enum DECLSPEC_DENUM TFrameKey : unsigned char { fkBasemap, fkShapestoDraw, fkShapesDraw, fkMapDraw };

enum DECLSPEC_DENUM TShapeDragMode : unsigned char { sdmShape, sdmMultiShapes };

enum DECLSPEC_DENUM TPositionOnMap : unsigned char { pmOutside, pmTopLeft, pmTop, pmTopRight, pmLeft, pmCenter, pmRight, pmBottomLeft, pmBottom, pmBottomRight };

typedef System::Word TECDirection;

enum DECLSPEC_DENUM TECScaleBarDivision : unsigned char { sbdNone, sbdOne, sbdFour };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECScaleBar : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::TObject* FScaleMap;
	TNativeMapControl* FMap;
	void __fastcall setMaxWidth(const int value);
	int __fastcall getMaxWidth();
	void __fastcall setXMargin(const int value);
	void __fastcall setYMargin(const int value);
	void __fastcall setBarSize(const int value);
	void __fastcall setStyle(const Fmx::Uecmaputil::TScaleBarStyle value);
	void __fastcall setPosition(const Fmx::Uecmaputil::TAnchorPosition value);
	void __fastcall setShadow(const bool value);
	void __fastcall setColor(const Fmx::Uecmaputil::TColor value);
	void __fastcall setSecondaryColor(const Fmx::Uecmaputil::TColor value);
	void __fastcall setOpacity(const System::Byte Value);
	void __fastcall setVisible(const bool value);
	Fmx::Uecmaputil::TScaleBarStyle __fastcall getStyle();
	int __fastcall getXMargin();
	int __fastcall getYMargin();
	int __fastcall getBarSize();
	Fmx::Uecmaputil::TAnchorPosition __fastcall getPosition();
	bool __fastcall getShadow();
	Fmx::Uecmaputil::TColor __fastcall getColor();
	Fmx::Uecmaputil::TColor __fastcall getSecondaryColor();
	System::Byte __fastcall getOpacity();
	bool __fastcall getVisible();
	Fmx::Uecmaputil::TMesureSystem __fastcall getMesureSystem();
	System::UnicodeString __fastcall GetLegends(Fmx::Uecmaputil::TMesureSystem i);
	int __fastcall GetWidths(Fmx::Uecmaputil::TMesureSystem i);
	System::UnicodeString __fastcall GetScaleLegend();
	int __fastcall GetScaleWidth();
	void __fastcall setMesureSystem(const Fmx::Uecmaputil::TMesureSystem value);
	void __fastcall setDivision(const TECScaleBarDivision value);
	TECScaleBarDivision __fastcall getDivision();
	void __fastcall setFontSize(const int value);
	int __fastcall getFontSize();
	
public:
	__fastcall TECScaleBar(TNativeMapControl* const AMap);
	__fastcall virtual ~TECScaleBar();
	__property Fmx::Uecmaputil::TAnchorPosition AnchorPosition = {read=getPosition, write=setPosition, nodefault};
	__property Fmx::Uecmaputil::TColor Color = {read=getColor, write=setColor, nodefault};
	__property Fmx::Uecmaputil::TColor SecondaryColor = {read=getSecondaryColor, write=setSecondaryColor, nodefault};
	__property TECScaleBarDivision Division = {read=getDivision, write=setDivision, nodefault};
	__property int FontSize = {read=getFontSize, write=setFontSize, nodefault};
	__property int MaxWidth = {read=getMaxWidth, write=setMaxWidth, nodefault};
	__property Fmx::Uecmaputil::TScaleBarStyle Style = {read=getStyle, write=setStyle, nodefault};
	__property int ScaleWidth = {read=GetScaleWidth, nodefault};
	__property System::UnicodeString ScaleLegend = {read=GetScaleLegend};
	__property int Widths[Fmx::Uecmaputil::TMesureSystem i] = {read=GetWidths};
	__property System::UnicodeString Legends[Fmx::Uecmaputil::TMesureSystem i] = {read=GetLegends};
	__property Fmx::Uecmaputil::TMesureSystem MeasureSystem = {read=getMesureSystem, write=setMesureSystem, nodefault};
	__property bool Shadow = {read=getShadow, write=setShadow, nodefault};
	__property int Thickness = {read=getBarSize, write=setBarSize, nodefault};
	__property bool Visible = {read=getVisible, write=setVisible, nodefault};
	__property int XMargin = {read=getXMargin, write=setXMargin, nodefault};
	__property int YMargin = {read=getYMargin, write=setYMargin, nodefault};
	__property System::Byte Opacity = {read=getOpacity, write=setOpacity, nodefault};
};

#pragma pack(pop)

typedef void __fastcall (__closure *TOnFreeHandPermission)(System::TObject* sender, bool &valid);

class PASCALIMPLEMENTATION TECNativeFreeHand : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Fmx::Uecnativeshape::TECShapesList* FSelectionList;
	Fmx::Uecnativeshape::TOnShapeFilter FSelectionFilter;
	System::Uitypes::TMouseButton FMouseButton;
	TOnFreeHandPermission FOnPermission;
	System::Classes::TNotifyEvent FOnSelection;
	System::Classes::TNotifyEvent FOnValidSelection;
	System::Classes::TNotifyEvent FOnDraw;
	Fmx::Uecnativeshape::TECShapePolygone* FPoly;
	Fmx::Uecnativeshape::TECShapeLine* FLine;
	Fmx::Uecnativeshape::TECShape* FPrevFocus;
	Fmx::Uecnativeshape::TECShape* FCursor;
	Fmx::Uecnativeshape::TECShapes* FGroup;
	bool FAutomaticMapMovement;
	bool FAttached;
	Fmx::Uecmaputil::TNativeMapObserver* FObserver;
	TNativeMapControl* FMap;
	bool FisSelection;
	void __fastcall setCursor(Fmx::Uecnativeshape::TECShape* const Value);
	void __fastcall WM_ShapeMouseDown(System::TObject* sender);
	void __fastcall WM_ShapeMouseUp(System::TObject* sender);
	void __fastcall setDraw(const bool Value);
	bool __fastcall getDraw();
	void __fastcall setSelection(const bool Value);
	bool __fastcall getSelection();
	void __fastcall CreateCursor();
	
public:
	__fastcall TECNativeFreeHand(TNativeMapControl* Map);
	__fastcall virtual ~TECNativeFreeHand();
	__property bool AutomaticMapMovement = {read=FAutomaticMapMovement, write=FAutomaticMapMovement, nodefault};
	__property bool Draw = {read=getDraw, write=setDraw, nodefault};
	__property bool Selection = {read=getSelection, write=setSelection, nodefault};
	__property System::Uitypes::TMouseButton MouseButton = {read=FMouseButton, write=FMouseButton, nodefault};
	__property Fmx::Uecnativeshape::TECShape* Cursor = {read=FCursor, write=setCursor};
	__property Fmx::Uecnativeshape::TECShapeLine* Line = {read=FLine};
	__property Fmx::Uecnativeshape::TECShapePolygone* PolygoneSelection = {read=FPoly};
	__property Fmx::Uecnativeshape::TECShapesList* SelectionList = {read=FSelectionList};
	__property Fmx::Uecnativeshape::TOnShapeFilter SelectionFilter = {read=FSelectionFilter, write=FSelectionFilter};
	Fmx::Uecnativeshape::TECShapeLine* __fastcall AddLine(const System::UnicodeString GroupName = System::UnicodeString());
	Fmx::Uecnativeshape::TECShapePolygone* __fastcall AddPolygone(const System::UnicodeString GroupName = System::UnicodeString());
	__property System::Classes::TNotifyEvent OnValidSelection = {read=FOnValidSelection, write=FOnValidSelection};
	__property System::Classes::TNotifyEvent OnSelection = {read=FOnSelection, write=FOnSelection};
	__property System::Classes::TNotifyEvent OnDraw = {read=FOnDraw, write=FOnDraw};
	__property TOnFreeHandPermission OnPermission = {read=FOnPermission, write=FOnPermission};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECNativeGeoHash : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TNativeMapControl* FMap;
	
public:
	__fastcall TECNativeGeoHash(TNativeMapControl* Map);
	void __fastcall Decode(const System::UnicodeString geohash, double &latitude, double &longitude);
	System::UnicodeString __fastcall Encode(const double latitude, const double longitude, const int precision = 0xc);
	Fmx::Uecgeohash::TCardinalGeoHash __fastcall CardinalPoints(const System::UnicodeString geohash);
	void __fastcall MoveTo(const System::UnicodeString geohash);
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECNativeGeoHash() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECOverlayTileLayer : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TNativeMapControl* FMap;
	Fmx::Uecnativetileserver::TNativeMapServer* FNativeMapServer;
	System::Byte FMinZoom;
	System::Byte FMaxZoom;
	int FDrawTile;
	int FConnexionTimeOut;
	int FResponseTimeOut;
	int FZIndex;
	System::UnicodeString FUserAgent;
	bool FVisible;
	bool FWaitForComplete;
	bool FScreenComplete;
	System::UnicodeString __fastcall getTimeWMS();
	void __fastcall setTimeWMS(const System::UnicodeString Value);
	System::UnicodeString __fastcall getName();
	void __fastcall setName(const System::UnicodeString Value);
	System::UnicodeString __fastcall getMapStyle();
	void __fastcall setMapStyle(const System::UnicodeString Value);
	System::UnicodeString __fastcall getLocalCache();
	void __fastcall setLocalCache(const System::UnicodeString Value);
	double __fastcall getOpacity();
	void __fastcall setOpacity(const double Value);
	void __fastcall setTileFilename(const Fmx::Uecmaputil::TOnMapServerTilePath Value);
	void __fastcall setTileStream(const Fmx::Uecmaputil::TOnMapServerTileStream Value);
	Fmx::Uecmaputil::TOnMapServerTilePath __fastcall getTileFilename();
	Fmx::Uecmaputil::TOnMapServerTileStream __fastcall getTileStream();
	void __fastcall SetTileServer(const Fmx::Uecmaputil::TTileServer Value);
	Fmx::Uecmaputil::TTileServer __fastcall getTileServer();
	void __fastcall setConnexionTimout(const int Value);
	void __fastcall setResponseTimout(const int Value);
	void __fastcall setUserAgent(const System::UnicodeString Value);
	double __fastcall getMaxDayInCache();
	void __fastcall setMaxDayInCache(const double Value);
	void __fastcall setZindex(const int Value);
	
public:
	__fastcall TECOverlayTileLayer(TNativeMapControl* Map);
	__fastcall virtual ~TECOverlayTileLayer();
	void __fastcall WMS_Legend(const bool show, const TLegendPosition position = (TLegendPosition)(0x1), const System::Byte fopacity = (System::Byte)(0x64), const int XMargin = 0x7, const int YMargin = 0x7);
	void __fastcall AddWMSLayer(const System::UnicodeString Url, const System::UnicodeString layers, const int ESPG = 0x10e6);
	void __fastcall DeleteWMSLayer();
	int __fastcall IndexOf();
	void __fastcall ExChange(const int Value);
	void __fastcall MoveTo(const int Value);
	__property System::UnicodeString LocalCache = {read=getLocalCache, write=setLocalCache};
	__property System::UnicodeString Name = {read=getName, write=setName};
	__property System::UnicodeString WMS_Time = {read=getTimeWMS, write=setTimeWMS};
	__property System::UnicodeString MapStyle = {read=getMapStyle, write=setMapStyle};
	__property Fmx::Uecnativetileserver::TNativeMapServer* MapServer = {read=FNativeMapServer};
	__property System::Byte MaxZoom = {read=FMaxZoom, write=FMaxZoom, nodefault};
	__property System::Byte MinZoom = {read=FMinZoom, write=FMinZoom, nodefault};
	__property double MaxDayInCache = {read=getMaxDayInCache, write=setMaxDayInCache};
	__property double Opacity = {read=getOpacity, write=setOpacity};
	__property Fmx::Uecmaputil::TTileServer TileServer = {read=getTileServer, write=SetTileServer, nodefault};
	__property Fmx::Uecmaputil::TOnMapServerTilePath TileFilename = {read=getTileFilename, write=setTileFilename};
	__property Fmx::Uecmaputil::TOnMapServerTileStream TileStream = {read=getTileStream, write=setTileStream};
	__property int ConnexionTimeOut = {read=FConnexionTimeOut, write=setConnexionTimout, nodefault};
	__property int ResponseTimeOut = {read=FResponseTimeOut, write=setResponseTimout, nodefault};
	__property System::UnicodeString USerAgent = {read=FUserAgent, write=setUserAgent};
	__property bool Visible = {read=FVisible, write=FVisible, nodefault};
	__property int DrawTile = {read=FDrawTile, write=FDrawTile, nodefault};
	__property bool WaitForComplete = {read=FWaitForComplete, write=FWaitForComplete, nodefault};
	__property bool ScreenComplete = {read=FScreenComplete, write=FScreenComplete, nodefault};
	__property int ZIndex = {read=FZIndex, write=setZindex, nodefault};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECVaneTiles : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FUrlEndPoint;
	System::UnicodeString FApiKey;
	System::UnicodeString FSelect;
	System::UnicodeString FFrom;
	System::UnicodeString FWhere;
	System::UnicodeString FOrder;
	System::UnicodeString FOp;
	System::UnicodeString FColor;
	
public:
	__fastcall TECVaneTiles(const System::UnicodeString key);
	System::UnicodeString __fastcall getTiles(const int X, const int Y, const int Z);
	__property System::UnicodeString APiKey = {read=FApiKey, write=FApiKey};
	__property System::UnicodeString Select = {read=FSelect, write=FSelect};
	__property System::UnicodeString From = {read=FFrom, write=FFrom};
	__property System::UnicodeString Where = {read=FWhere, write=FWhere};
	__property System::UnicodeString Op = {read=FOp, write=FOp};
	__property System::UnicodeString Order = {read=FOrder, write=FOrder};
	__property System::UnicodeString Color = {read=FColor, write=FColor};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECVaneTiles() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TOWTileServer : unsigned char { owPrecipitation, owSnow, owClouds, owPressure, owTemp, owWind };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECOpenWeatherTilesLayer : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FKey;
	System::UnicodeString FUrl;
	TNativeMapControl* FMap;
	Fmx::Uecmaputil::TNativeMapObserver* FObserver;
	void __fastcall doOnMapFree(System::TObject* sender);
	void __fastcall getPrecipitation(System::UnicodeString &TileFilename, const int X, const int Y, const int Z);
	void __fastcall getSnow(System::UnicodeString &TileFilename, const int X, const int Y, const int Z);
	void __fastcall getClouds(System::UnicodeString &TileFilename, const int X, const int Y, const int Z);
	void __fastcall getPressure(System::UnicodeString &TileFilename, const int X, const int Y, const int Z);
	void __fastcall getTemp(System::UnicodeString &TileFilename, const int X, const int Y, const int Z);
	void __fastcall getWind(System::UnicodeString &TileFilename, const int X, const int Y, const int Z);
	void __fastcall setMap(TNativeMapControl* const MapValue);
	System::UnicodeString __fastcall _name(const TOWTileServer Value);
	
public:
	__fastcall TECOpenWeatherTilesLayer(TNativeMapControl* const MapValue);
	__fastcall virtual ~TECOpenWeatherTilesLayer();
	TECOverlayTileLayer* __fastcall Add(const TOWTileServer Layer);
	TECOverlayTileLayer* __fastcall Get(const TOWTileServer Layer);
	void __fastcall Remove(const TOWTileServer Layer);
	void __fastcall RemoveAll();
	__property TNativeMapControl* Map = {read=FMap, write=setMap};
	__property System::UnicodeString key = {read=FKey, write=FKey};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECHeatmapLayer : public System::TObject
{
	typedef System::TObject inherited;
	
	
private:
	typedef System::DynamicArray<double> _TECHeatmapLayer__1;
	
	
private:
	Fmx::Uecmaputil::TNativeMapObserver* FObserver;
	Fmx::Uecnativeshape::TECShapes* FShapes;
	Fmx::Uecnativeshape::TECShapeMarker* FHeatMarker;
	TECNativeMap* FMap;
	System::Classes::TNotifyEvent FOnChangeZoom;
	System::Classes::TNotifyEvent FOnUpdate;
	double FNELatitude;
	double FNELongitude;
	double FSWLatitude;
	double FSWLongitude;
	_TECHeatmapLayer__1 FHeatData;
	Fmx::Uecheatmap::TecHeatMap* FHeatmap;
	System::Byte FMinZoom;
	System::Byte FMaxZoom;
	double FMaxValue;
	int FReelLength;
	int FCount;
	bool FChange;
	bool FAutomaticUpdate;
	bool FUpdateWhenReady;
	bool FShow;
	bool FVisible;
	unsigned FLastUpdate;
	void __fastcall doOnMapChangeBounds(System::TObject* sender);
	void __fastcall doOnMapChangeZoom(System::TObject* sender);
	void __fastcall doOnMapEndMove(System::TObject* sender);
	void __fastcall doOnMapAnimation(System::TObject* sender);
	void __fastcall doOnMapFree(System::TObject* sender);
	void __fastcall doOnHeatUpdate(System::TObject* sender);
	void __fastcall setShow(const bool Value);
	void __fastcall setVisible(const bool Value);
	bool __fastcall getVisible();
	System::Byte __fastcall getOpacity();
	void __fastcall setOpacity(const System::Byte Value);
	int __fastcall getGroupZindex();
	void __fastcall setGroupZindex(const int Value);
	int __fastcall getZindex();
	void __fastcall setZindex(const int Value);
	Fmx::Uecheatmap::THeatPalette* __fastcall getPalette();
	bool __fastcall getPointIsDisc();
	void __fastcall setPointIsDisc(const bool Value);
	int __fastcall getRadius();
	void __fastcall setRadius(const int Value);
	void __fastcall setMinZoom(const System::Byte Value);
	void __fastcall setMaxZoom(const System::Byte Value);
	bool __fastcall getReady();
	void __fastcall doPaletteChange(System::TObject* sender);
	void __fastcall getBounds();
	
public:
	__fastcall TECHeatmapLayer(TECNativeMap* _FMap);
	__fastcall virtual ~TECHeatmapLayer();
	void __fastcall Clear();
	void __fastcall fitBounds();
	void __fastcall Add(const double latitude, const double longitude, const double Value = 1.000000E+00);
	void __fastcall Delete(const double latitude, const double longitude, const double Value = 1.000000E+00)/* overload */;
	void __fastcall Delete(const int index)/* overload */;
	void __fastcall setSize(const int AValue);
	int __fastcall getValue(const double Lat, const double Lng);
	void __fastcall Update();
	__property Fmx::Uecheatmap::THeatPalette* Palette = {read=getPalette};
	__property bool AutomaticUpdate = {read=FAutomaticUpdate, write=FAutomaticUpdate, nodefault};
	__property bool Ready = {read=getReady, nodefault};
	__property TECNativeMap* Map = {read=FMap};
	__property bool Visible = {read=getVisible, write=setVisible, nodefault};
	__property bool Show = {read=FShow, write=setShow, nodefault};
	__property bool PointIsDisc = {read=getPointIsDisc, write=setPointIsDisc, nodefault};
	__property int Radius = {read=getRadius, write=setRadius, nodefault};
	__property System::Byte MinZoom = {read=FMinZoom, write=setMinZoom, nodefault};
	__property System::Byte MaxZoom = {read=FMaxZoom, write=setMaxZoom, nodefault};
	__property System::Byte Opacity = {read=getOpacity, write=setOpacity, nodefault};
	__property int GroupZIndex = {read=getGroupZindex, write=setGroupZindex, nodefault};
	__property int ZIndex = {read=getZindex, write=setZindex, nodefault};
	__property System::Classes::TNotifyEvent OnUpdate = {read=FOnUpdate, write=FOnUpdate};
	__property System::Classes::TNotifyEvent OnChangeZoom = {read=FOnChangeZoom, write=FOnChangeZoom};
};


class PASCALIMPLEMENTATION TECNativeLayer : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Fmx::Uecmaputil::TNativeMapObserver* FObserver;
	Fmx::Uecnativeshape::TECShapes* FShapes;
	TNativeMapControl* FMap;
	TECBBoxDataCacheList* FCacheBox;
	Fmx::Uecnativeshape::TECShapeInfoWindow* FInfoWindows;
	int FMaxShapes;
	unsigned FLastMove;
	unsigned FMinTiming;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnShapeRightClick;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnShapeClick;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnShapeMove;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnShapeDrag;
	System::Classes::TNotifyEvent FOnPathChange;
	System::Classes::TNotifyEvent FOnDescription;
	System::Classes::TNotifyEvent FOnhint;
	System::Classes::TNotifyEvent FOnMouseClick;
	System::Classes::TNotifyEvent FOnMouseMove;
	System::Classes::TNotifyEvent FOnMapLoad;
	System::Classes::TNotifyEvent FOnMapHiResChange;
	TOnMapPaint FOnShapesPaint;
	TOnMapPaint FOnMapPaint;
	System::Byte __fastcall getMinZoom();
	System::Byte __fastcall getMaxZoom();
	void __fastcall setMinZoom(System::Byte Value);
	void __fastcall setMaxZoom(System::Byte Value);
	virtual int __fastcall getZindex();
	virtual void __fastcall setZindex(int Value);
	virtual System::Byte __fastcall getOpacity();
	virtual void __fastcall setOpacity(System::Byte Value);
	bool __fastcall getClickable();
	void __fastcall setClickable(bool Value);
	bool __fastcall getVisible();
	void __fastcall setMaxShapes(const int Value);
	void __fastcall _doOnMapEndMove(System::TObject* sender);
	void __fastcall _doOnMapChangeBounds(System::TObject* sender);
	void __fastcall _doOnMapChangeZoom(System::TObject* sender);
	void __fastcall _doOnMapCompleteTiles(System::TObject* sender);
	bool __fastcall getIsMoving();
	Fmx::Uecnativeshape::TECShapeInfoWindow* __fastcall getInfoWindow();
	
protected:
	virtual void __fastcall setVisible(const bool Value);
	virtual void __fastcall doOnMapEndMove(System::TObject* sender);
	virtual void __fastcall doOnMapCompleteTiles(System::TObject* sender);
	virtual void __fastcall doOnMapChangeBounds(System::TObject* sender);
	virtual void __fastcall doOnMapChangeZoom(System::TObject* sender);
	virtual void __fastcall doOnMapFree(System::TObject* sender);
	virtual void __fastcall doOnShapeClick(System::TObject* sender);
	virtual void __fastcall doOnShapeDescription(System::TObject* sender);
	virtual void __fastcall doOnShapeHint(System::TObject* sender);
	virtual void __fastcall doOnShapeMove(System::TObject* sender);
	virtual void __fastcall doOnShapeDrag(System::TObject* sender);
	virtual void __fastcall doOnShapeRightClick(System::TObject* sender);
	virtual void __fastcall doOnMapMouseMove(System::TObject* sender);
	virtual void __fastcall doOnMapMouseClick(System::TObject* sender);
	virtual void __fastcall doOnMapLoad(System::TObject* sender);
	virtual void __fastcall doOnMapPaint(System::TObject* sender);
	virtual void __fastcall doOnShapesPaint(System::TObject* sender);
	virtual void __fastcall doOnMapHiResChange(System::TObject* sender);
	virtual void __fastcall doOnPathChange(System::TObject* sender);
	
public:
	__fastcall virtual TECNativeLayer(TNativeMapControl* _FMap, const System::UnicodeString Name);
	__fastcall virtual ~TECNativeLayer();
	virtual void __fastcall Clear();
	void __fastcall OpenWindow(double Lat, double Lng, const System::UnicodeString Content, int Width = 0x140);
	void __fastcall CloseWindow();
	__property TECBBoxDataCacheList* CacheBox = {read=FCacheBox};
	__property Fmx::Uecnativeshape::TECShapeInfoWindow* InfoWindow = {read=getInfoWindow};
	__property bool isMoving = {read=getIsMoving, nodefault};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnShapeClick = {read=FOnShapeClick, write=FOnShapeClick};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnShapeMove = {read=FOnShapeMove, write=FOnShapeMove};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnShapeDrag = {read=FOnShapeDrag, write=FOnShapeDrag};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnShapeRightClick = {read=FOnShapeRightClick, write=FOnShapeRightClick};
	__property System::Classes::TNotifyEvent OnMouseMove = {read=FOnMouseMove, write=FOnMouseMove};
	__property System::Classes::TNotifyEvent OnMouseClick = {read=FOnMouseClick, write=FOnMouseClick};
	__property System::Classes::TNotifyEvent OnMapHiResChange = {read=FOnMapHiResChange, write=FOnMapHiResChange};
	__property System::Classes::TNotifyEvent OnPathChange = {read=FOnPathChange, write=FOnPathChange};
	__property System::Classes::TNotifyEvent OnMapLoad = {read=FOnMapLoad, write=FOnMapLoad};
	__property TOnMapPaint OnMapPaint = {read=FOnMapPaint, write=FOnMapPaint};
	__property TOnMapPaint OnShapesPaint = {read=FOnShapesPaint, write=FOnShapesPaint};
	__property System::Classes::TNotifyEvent OnMapShapeDescription = {read=FOnDescription, write=FOnDescription};
	__property System::Classes::TNotifyEvent OnMapShapehint = {read=FOnhint, write=FOnhint};
	__property TNativeMapControl* Map = {read=FMap};
	__property Fmx::Uecnativeshape::TECShapes* Shapes = {read=FShapes};
	__property bool Visible = {read=getVisible, write=setVisible, nodefault};
	__property int MaxShapes = {read=FMaxShapes, write=setMaxShapes, nodefault};
	__property System::Byte MaxZoom = {read=getMaxZoom, write=setMaxZoom, nodefault};
	__property System::Byte MinZoom = {read=getMinZoom, write=setMinZoom, nodefault};
	__property int ZIndex = {read=getZindex, write=setZindex, nodefault};
	__property bool Clickable = {read=getClickable, write=setClickable, nodefault};
	__property System::Byte Opacity = {read=getOpacity, write=setOpacity, nodefault};
	__property unsigned MinTiming = {read=FMinTiming, write=FMinTiming, nodefault};
	__property Fmx::Uecmaputil::TNativeMapObserver* Observer = {read=FObserver};
};


class PASCALIMPLEMENTATION TECTimeDimension : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	bool FLoop;
	bool FPause;
	bool FEnabled;
	int FCurrentStep;
	System::TDateTime FStartTime;
	System::TDateTime FEndTime;
	System::TDateTime FCurrentTime;
	System::TDateTime FEndTimeOver;
	System::UnicodeString FTime;
	__int64 FPeriodMillisecondes;
	__int64 FTransitionMillisecondes;
	__int64 FLastTransition;
	void __fastcall setStartTime(const System::TDateTime Value);
	void __fastcall setEndTime(const System::TDateTime Value);
	
public:
	ArrayOfTime Times;
	int __fastcall AddTime(const System::TDateTime *aTimes, const System::NativeInt aTimes_High);
	__property bool Enabled = {read=FEnabled, nodefault};
	__property bool Pause = {read=FPause, nodefault};
	__property bool Loop = {read=FLoop, write=FLoop, nodefault};
	__property System::TDateTime StartTime = {read=FStartTime, write=setStartTime};
	__property System::TDateTime EndTime = {read=FEndTime, write=setEndTime};
	__property System::TDateTime CurrentTime = {read=FCurrentTime};
	__property int CurrentStep = {read=FCurrentStep, nodefault};
	__property System::UnicodeString Time = {read=FTime};
	__property __int64 PeriodMillisecondes = {read=FPeriodMillisecondes, write=FPeriodMillisecondes};
	__property __int64 TransitionMillisecondes = {read=FTransitionMillisecondes, write=FTransitionMillisecondes};
public:
	/* TObject.Create */ inline __fastcall TECTimeDimension() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TECTimeDimension() { }
	
};


struct DECLSPEC_DRECORD TECRecordLayer
{
public:
	System::UnicodeString Name;
	System::UnicodeString Title;
	double NELat;
	double NELng;
	double SWLat;
	double SWLng;
};


typedef System::DynamicArray<TECRecordLayer> TAECRecordLayers;

class PASCALIMPLEMENTATION TECNativeWMS : public TECNativeLayer
{
	typedef TECNativeLayer inherited;
	
private:
	TECTimeDimension* FTimeDimension;
	TAECRecordLayers FLayersList;
	bool FEnabled;
	System::Byte FLoadingPercent;
	double fopacity;
	double FMax_NELat;
	double FMax_NELng;
	double FMin_SWLat;
	double FMin_SWLng;
	int FZIndex;
	int FESPG;
	System::UnicodeString FSESPG;
	System::UnicodeString FLayers;
	System::UnicodeString FUrl;
	System::UnicodeString FName;
	TECOverlayTileLayer* FOverlay;
	System::UnicodeString FTime;
	System::UnicodeString FParams;
	System::UnicodeString FCRS;
	System::UnicodeString FVersion;
	System::UnicodeString FStyles;
	bool FWaitComplete;
	bool FLegend;
	int FLegendXMargin;
	int FLegendYMargin;
	System::Byte FOpacityLegend;
	TLegendPosition FLegendPosition;
	System::UnicodeString FCapabilities;
	System::UnicodeString FFeatureInfo;
	void __fastcall CheckTimeDimension();
	void __fastcall doUpdate();
	void __fastcall setESPG(const int Value);
	void __fastcall setLegendXMargin(const int Value);
	void __fastcall setLegendYMargin(const int Value);
	void __fastcall setLegend(const bool Value);
	void __fastcall setStyles(const System::UnicodeString Value);
	void __fastcall setTime(const System::UnicodeString Value);
	void __fastcall setVersion(const System::UnicodeString Value);
	void __fastcall setUrl(const System::UnicodeString Value);
	void __fastcall setLayers(const System::UnicodeString Value);
	void __fastcall setOpacityLegend(const System::Byte Value);
	void __fastcall setLegendPosition(const TLegendPosition Value);
	void __fastcall setEnabledTimeDimension(const bool Value);
	bool __fastcall getEnabledTimeDimension();
	void __fastcall setPauseTimeDimension(const bool Value);
	bool __fastcall getPauseTimeDimension();
	void __fastcall doOnCapabilities(System::TObject* sender);
	void __fastcall doOnFeatureInfo(System::TObject* sender);
	void __fastcall SetToCapabilities();
	bool __fastcall getEnabled();
	virtual int __fastcall getZindex();
	virtual void __fastcall setZindex(int Value);
	HIDESBASE double __fastcall getOpacity();
	HIDESBASE void __fastcall setOpacity(double Value);
	void __fastcall setStepTimeDimension(const int NewStep);
	int __fastcall getStepTimeDimension();
	void __fastcall getAllLayers();
	
protected:
	virtual void __fastcall setVisible(const bool Value);
	virtual void __fastcall doOnMapEndMove(System::TObject* sender);
	
public:
	__fastcall TECNativeWMS(TNativeMapControl* _FMap, const System::UnicodeString Url, const System::UnicodeString layers, const System::UnicodeString Name);
	__fastcall virtual ~TECNativeWMS();
	void __fastcall Refresh();
	void __fastcall StartTimeDimension();
	void __fastcall EndTimeDimension();
	void __fastcall NextTimeDimension();
	void __fastcall PrevTimeDimension();
	void __fastcall BoundingBox(const double NELat = 8.505113E+01, const double NELng = 1.800000E+02, const double SWLat = -8.505113E+01, const double SWLng = -1.800000E+02);
	void __fastcall GetCapabilities();
	void __fastcall GetFeatureInfo();
	__property int ESPG = {read=FESPG, write=setESPG, nodefault};
	__property System::UnicodeString layers = {read=FLayers, write=setLayers};
	__property System::UnicodeString Styles = {read=FStyles, write=setStyles};
	__property System::UnicodeString Time = {read=FTime, write=setTime};
	__property bool Legend = {read=FLegend, write=setLegend, nodefault};
	__property System::UnicodeString Url = {read=FUrl, write=setUrl};
	__property System::UnicodeString Version = {read=FVersion, write=setVersion};
	__property bool Enabled = {read=getEnabled, nodefault};
	__property TAECRecordLayers LayersList = {read=FLayersList};
	__property System::Byte LegendOpacity = {read=FOpacityLegend, write=setOpacityLegend, nodefault};
	__property TLegendPosition LegendPosition = {read=FLegendPosition, write=setLegendPosition, nodefault};
	__property int LegendXMargin = {read=FLegendXMargin, write=setLegendXMargin, nodefault};
	__property int LegendYMargin = {read=FLegendYMargin, write=setLegendYMargin, nodefault};
	__property System::UnicodeString Name = {read=FName};
	__property double Opacity = {read=getOpacity, write=setOpacity};
	__property TECTimeDimension* TimeDimension = {read=FTimeDimension};
	__property bool EnabledTimeDimension = {read=getEnabledTimeDimension, write=setEnabledTimeDimension, nodefault};
	__property bool PauseTimeDimension = {read=getPauseTimeDimension, write=setPauseTimeDimension, nodefault};
	__property int StepTimeDimension = {read=getStepTimeDimension, write=setStepTimeDimension, nodefault};
	__property System::Byte LoadingPercentTimeDimension = {read=FLoadingPercent, nodefault};
	__property bool WaitComplete = {read=FWaitComplete, write=FWaitComplete, nodefault};
	__property System::UnicodeString Capabilities = {read=FCapabilities};
	__property System::UnicodeString FeatureInfo = {read=FFeatureInfo};
	__property double NELat = {read=FMax_NELat};
	__property double NELng = {read=FMax_NELng};
	__property double SWLat = {read=FMin_SWLat};
	__property double SWLng = {read=FMin_SWLng};
};


struct DECLSPEC_DRECORD TECRecordFeature
{
public:
	System::UnicodeString FType;
	System::UnicodeString Name;
	System::UnicodeString Title;
	double NELat;
	double NELng;
	double SWLat;
	double SWLng;
};


typedef System::DynamicArray<TECRecordFeature> TAECRecordFeatures;

class PASCALIMPLEMENTATION TECNativeWFS : public TECNativeLayer
{
	typedef TECNativeLayer inherited;
	
private:
	double FMax_NELat;
	double FMax_NELng;
	double FMin_SWLat;
	double FMin_SWLng;
	TECBBoxDataCacheList* FCache;
	int FMaxFeature;
	int FESPG;
	bool FEnabled;
	TAECRecordFeatures FFeatures;
	System::UnicodeString FCapabilities;
	System::UnicodeString FDescribeFeatureType;
	System::UnicodeString FSESPG;
	System::UnicodeString FRequest;
	System::UnicodeString FTypeNames;
	System::UnicodeString FUrl;
	System::UnicodeString FName;
	bool FFlagDestroy;
	bool FOrderLatLng;
	System::UnicodeString FTime;
	System::UnicodeString FParams;
	System::UnicodeString FCRS;
	System::UnicodeString FTYPES;
	System::UnicodeString FCount;
	System::UnicodeString FVersion;
	System::UnicodeString FStyles;
	System::UnicodeString FPropertyName;
	bool FReQuery;
	bool FBeginQuery;
	bool FValidRequest;
	double FSWLat;
	double FSWLng;
	double FNELat;
	double FNELng;
	__int64 FLastRefresh;
	bool FAutoRefresh;
	bool FRoundBoxToTiles;
	void __fastcall doUpdate();
	void __fastcall doQuery();
	void __fastcall getAllFeatures();
	void __fastcall setPropertyName(const System::UnicodeString Value);
	void __fastcall setMaxFeature(const int Value);
	void __fastcall setESPG(const int Value);
	void __fastcall setRoundBoxToTiles(const bool Value);
	void __fastcall setStyles(const System::UnicodeString Value);
	void __fastcall setTime(const System::UnicodeString Value);
	void __fastcall setAutoRefresh(const bool Value);
	void __fastcall setOrderLatLng(const bool Value);
	void __fastcall setParams(const System::UnicodeString Value);
	void __fastcall setVersion(const System::UnicodeString Value);
	void __fastcall setUrl(const System::UnicodeString Value);
	void __fastcall setTypeNames(const System::UnicodeString Value);
	bool __fastcall doGetFeature(const double NELat, const double NELng, const double SWLat, const double SWLng, const int Width, const int Height);
	void __fastcall doOnLoad(System::TObject* sender);
	void __fastcall SetToCapabilities();
	bool __fastcall getEnabled();
	void __fastcall doOnCapabilities(System::TObject* sender);
	void __fastcall doOnDescribeFeatureType(System::TObject* sender);
	
protected:
	virtual void __fastcall doOnMapEndMove(System::TObject* sender);
	
public:
	__fastcall TECNativeWFS(TNativeMapControl* _FMap, const System::UnicodeString Url, const System::UnicodeString Typenames, const System::UnicodeString Name);
	__fastcall virtual ~TECNativeWFS();
	void __fastcall BoundingBox(const double NELat = 8.505113E+01, const double NELng = 1.800000E+02, const double SWLat = -8.505113E+01, const double SWLng = -1.800000E+02);
	void __fastcall GetCapabilities();
	void __fastcall getDescribeFeatureType();
	void __fastcall GetFeature(const double NELat, const double NELng, const double SWLat, const double SWLng)/* overload */;
	void __fastcall GetFeature(const System::UnicodeString ATypeNames = System::UnicodeString())/* overload */;
	__property bool AutoRefresh = {read=FAutoRefresh, write=setAutoRefresh, nodefault};
	__property bool Enabled = {read=getEnabled, nodefault};
	__property int MaxFeature = {read=FMaxFeature, write=setMaxFeature, nodefault};
	__property int ESPG = {read=FESPG, write=setESPG, nodefault};
	__property System::UnicodeString Typenames = {read=FTypeNames, write=setTypeNames};
	__property System::UnicodeString Styles = {read=FStyles, write=setStyles};
	__property System::UnicodeString Time = {read=FTime, write=setTime};
	__property System::UnicodeString PropertyName = {read=FPropertyName, write=setPropertyName};
	__property System::UnicodeString Params = {read=FParams, write=setParams};
	__property System::UnicodeString Url = {read=FUrl, write=setUrl};
	__property System::UnicodeString Version = {read=FVersion, write=setVersion};
	__property System::UnicodeString Name = {read=FName};
	__property __int64 LastRefresh = {read=FLastRefresh};
	__property bool RoundBoxToTiles = {read=FRoundBoxToTiles, write=setRoundBoxToTiles, nodefault};
	__property bool OrderLatLng = {read=FOrderLatLng, write=setOrderLatLng, nodefault};
	__property bool ValidRequest = {read=FValidRequest, nodefault};
	__property System::UnicodeString Request = {read=FRequest};
	__property TAECRecordFeatures FeatureTypeList = {read=FFeatures};
	__property System::UnicodeString Capabilities = {read=FCapabilities};
	__property System::UnicodeString DescribeFeatureType = {read=FDescribeFeatureType};
	__property double NELat = {read=FMax_NELat};
	__property double NELng = {read=FMax_NELng};
	__property double SWLat = {read=FMin_SWLat};
	__property double SWLng = {read=FMin_SWLng};
};


class PASCALIMPLEMENTATION TECWMSLayers : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECNativeWMS* operator[](const int index) { return this->Layer[index]; }
	
private:
	TNativeMapControl* FMap;
	System::Classes::TStringList* FList;
	System::Classes::TNotifyEvent FOnEnabledTimeDimension;
	System::Classes::TNotifyEvent FOnEnabled;
	System::Classes::TNotifyEvent FOnChangeTimeDimension;
	System::Classes::TNotifyEvent FOnLoadingTimeDimension;
	System::Classes::TNotifyEvent FOnCapabilities;
	System::Classes::TNotifyEvent FOnFeatureInfo;
	TECNativeWMS* __fastcall getLayer(const int index)/* overload */;
	TECNativeWMS* __fastcall getLayer(const System::UnicodeString index)/* overload */;
	void __fastcall CheckTimeDimension();
	void __fastcall DisableTimeDimension();
	
public:
	__fastcall TECWMSLayers(TNativeMapControl* _FMap);
	__fastcall virtual ~TECWMSLayers();
	int __fastcall Count();
	void __fastcall Refresh();
	void __fastcall Clear();
	TECNativeWMS* __fastcall Add(const System::UnicodeString Url, const System::UnicodeString layers = System::UnicodeString(), const System::UnicodeString Name = System::UnicodeString());
	void __fastcall Delete(const System::UnicodeString Name)/* overload */;
	void __fastcall Delete(const int index)/* overload */;
	void __fastcall Delete(TECNativeWMS* const index)/* overload */;
	int __fastcall IndexOf(const System::UnicodeString Name);
	__property TECNativeWMS* Layer[const int index] = {read=getLayer/*, default*/};
	__property TECNativeWMS* Layer[const System::UnicodeString index] = {read=getLayer};
	__property System::Classes::TNotifyEvent OnCapabilities = {read=FOnCapabilities, write=FOnCapabilities};
	__property System::Classes::TNotifyEvent OnFeatureInfo = {read=FOnFeatureInfo, write=FOnFeatureInfo};
	__property System::Classes::TNotifyEvent OnEnabled = {read=FOnEnabled, write=FOnEnabled};
	__property System::Classes::TNotifyEvent OnChangeTimeDimension = {read=FOnChangeTimeDimension, write=FOnChangeTimeDimension};
	__property System::Classes::TNotifyEvent OnLoadingTimeDimension = {read=FOnLoadingTimeDimension, write=FOnLoadingTimeDimension};
	__property System::Classes::TNotifyEvent OnEnabledTimeDimension = {read=FOnEnabledTimeDimension, write=FOnEnabledTimeDimension};
};


class PASCALIMPLEMENTATION TECWFSLayers : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECNativeWFS* operator[](const int index) { return this->Layer[index]; }
	
private:
	TNativeMapControl* FMap;
	System::Classes::TStringList* FList;
	System::Classes::TNotifyEvent FOnEnabled;
	System::Classes::TNotifyEvent FOnCapabilities;
	System::Classes::TNotifyEvent FOnDescribeFeatureType;
	System::Classes::TNotifyEvent FOnBeginQuery;
	System::Classes::TNotifyEvent FOnEndQuery;
	TECNativeWFS* __fastcall getLayer(const int index)/* overload */;
	TECNativeWFS* __fastcall getLayer(const System::UnicodeString index)/* overload */;
	
public:
	__fastcall TECWFSLayers(TNativeMapControl* _FMap);
	__fastcall virtual ~TECWFSLayers();
	int __fastcall Count();
	void __fastcall Clear();
	TECNativeWFS* __fastcall Add(const System::UnicodeString Url, const System::UnicodeString layers, const System::UnicodeString Name);
	void __fastcall Delete(const System::UnicodeString Name)/* overload */;
	void __fastcall Delete(const int index)/* overload */;
	void __fastcall Delete(TECNativeWFS* const index)/* overload */;
	int __fastcall IndexOf(const System::UnicodeString Name);
	__property TECNativeWFS* Layer[const int index] = {read=getLayer/*, default*/};
	__property TECNativeWFS* Layer[const System::UnicodeString index] = {read=getLayer};
	__property System::Classes::TNotifyEvent OnBeginQuery = {read=FOnBeginQuery, write=FOnBeginQuery};
	__property System::Classes::TNotifyEvent OnEndQuery = {read=FOnEndQuery, write=FOnEndQuery};
	__property System::Classes::TNotifyEvent OnCapabilities = {read=FOnCapabilities, write=FOnCapabilities};
	__property System::Classes::TNotifyEvent OnDescribeFeatureType = {read=FOnDescribeFeatureType, write=FOnDescribeFeatureType};
	__property System::Classes::TNotifyEvent OnEnabled = {read=FOnEnabled, write=FOnEnabled};
};


class PASCALIMPLEMENTATION TECNativeUTFLayer : public TECNativeLayer
{
	typedef TECNativeLayer inherited;
	
private:
	Fmx::Uecnativetileserver::TNativeMapServer* FServer;
	Fmx::Uecmaputil::TecUTFJson* FTecUTFJson;
	System::Classes::TNotifyEvent FOnMouseOut;
	System::Classes::TNotifyEvent FOnMouseOver;
	System::Classes::TStringList* FData;
	System::UnicodeString FDataMouseOn;
	System::Byte FResolution;
	void __fastcall ExtractData(const System::UnicodeString s);
	System::UnicodeString __fastcall getData(const System::UnicodeString index);
	void __fastcall doOnLoadTile(System::TObject* sender, const int X, const int Y, const int Z, const int t);
	
protected:
	virtual void __fastcall doOnMapMouseMove(System::TObject* sender);
	virtual void __fastcall doOnMapMouseClick(System::TObject* sender);
	
public:
	__fastcall TECNativeUTFLayer(TNativeMapControl* _FMap, const System::UnicodeString Name, Fmx::Uecmaputil::TOnMapServerTilePath FTilePath);
	__fastcall virtual ~TECNativeUTFLayer();
	__property System::Classes::TNotifyEvent OnMouseOut = {read=FOnMouseOut, write=FOnMouseOut};
	__property System::Classes::TNotifyEvent OnMouseOver = {read=FOnMouseOver, write=FOnMouseOver};
	__property System::UnicodeString Data[const System::UnicodeString index] = {read=getData};
	__property System::Byte Resolution = {read=FResolution, write=FResolution, nodefault};
};


typedef int TZoomScaleFactor;

enum DECLSPEC_DENUM TRoutingEngine : unsigned char { reMapQuest, reMapZen, reOSRM, reMapBox, reOpenStreetMap, reTomTom, reCustom, reValhalla, rePTV };

typedef void __fastcall (__closure *TOnDrawToLayoutMap)(Fmx::Graphics::TCanvas* const ACanvas);

#pragma pack(push,4)
class PASCALIMPLEMENTATION TLayoutMapItemDraw : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::UnicodeString Name;
	TLegendPosition Position;
	Fmx::Uecnativetileserver::TTileServerInfo* TileServerInfo;
	System::Byte Opacity;
	Fmx::Graphics::TBitmap* FBitmap;
	System::UnicodeString FUrlBitmap;
public:
	/* TObject.Create */ inline __fastcall TLayoutMapItemDraw() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TLayoutMapItemDraw() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TLayoutMap : public Fmx::Layouts::TLayout
{
	typedef Fmx::Layouts::TLayout inherited;
	
private:
	System::Generics::Collections::TList__1<TLayoutMapItemDraw*>* FDrawList;
	System::Generics::Collections::TList__1<TOnDrawToLayoutMap>* FDrawToList;
	TNativeMapControl* FMap;
	void __fastcall Delete(const System::UnicodeString Name)/* overload */;
	void __fastcall Add(const System::UnicodeString Name, const TLegendPosition APosition, Fmx::Graphics::TBitmap* const ABitmap, const System::Byte AOpacity)/* overload */;
	void __fastcall Add(const System::UnicodeString Name, const TLegendPosition APosition, const System::UnicodeString AUrlBitmap, const System::Byte AOpacity)/* overload */;
	void __fastcall Add(Fmx::Uecnativetileserver::TTileServerInfo* const ATileServerInfo)/* overload */;
	void __fastcall UpdateOpacity(const System::UnicodeString Name, const System::Byte AOpacity);
	__property TNativeMapControl* Map = {read=FMap, write=FMap};
	
protected:
	virtual void __fastcall Paint();
	
public:
	__fastcall virtual TLayoutMap(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TLayoutMap();
	void __fastcall Add(const TOnDrawToLayoutMap AValue)/* overload */;
	void __fastcall Delete(const TOnDrawToLayoutMap AValue)/* overload */;
	void __fastcall Clear();
};


class PASCALIMPLEMENTATION TNativeMapControl : public Fmx::Objects::TShape
{
	typedef Fmx::Objects::TShape inherited;
	
	
private:
	typedef System::DynamicArray<System::Types::TPoint> _TNativeMapControl__1;
	
	
public:
	Fmx::Uecnativeshape::TECShapes* operator[](const System::UnicodeString Value) { return this->Group[Value]; }
	
private:
	TECMapComponents* FMapComponents;
	bool FScreenCompleteBaseTile;
	TShapeDragMode FShapeDragMode;
	System::UnicodeString FUserAgent;
	TECNativeGeoHash* FGeoHash;
	TOLCNativeMap* FOpenLocationCode;
	TECGraticule* FGraticule;
	TECBubbleLayers* FECBubbleLayers;
	TECChartLayers* FECChartLayers;
	Fmx::Uecnativemeasuremap::TECNativeMeasureMap* FMeasureTool;
	TECNativeFreeHand* FFreeHand;
	TECDrawPath* FDrawPath;
	TECTomTom* FTomTom;
	TECGoogle* FGoogle;
	TECAirQuality* FAirQuality;
	int FSpeedRotation;
	Fmx::Uecmapzip::TECMapZip* FMapZip;
	Fmx::Uecnativeshape::TECGeofences* FECGeofences;
	__int64 FDownTime;
	System::Types::TPoint FDownClicPos;
	System::Types::TPoint FDownPos;
	System::Types::TPoint FDownState;
	__int64 FMoveTime;
	TECXapiLayer* FXapiLayer;
	double FMaxDayInCache;
	int FRequestTiles;
	int FDrawTiles;
	int FDrawBaseTiles;
	double FDeltaLatDrag;
	double FDeltaLngDrag;
	System::Types::TPoint FVector;
	__int64 FSpeed;
	__int64 FLastRemoveGroup;
	__int64 FTicks;
	bool FDIRECT_PAINT_TO_FORM;
	bool FOffScreen;
	bool FFlagDestroy;
	Fmx::Uecmaputil::TNativeMapObserver* FObserver;
	_TNativeMapControl__1 FTileSort;
	int _Width;
	int _Height;
	System::Uitypes::TCursor FOldCursor;
	TLastAction FLastAction;
	TDragRect FDragRect;
	__int64 FLastPrecharging;
	bool FScreenComplete;
	bool FPrechargingScreen;
	bool FDownRight;
	bool FZoomEffect;
	bool FZoomEffectBeforeDblClick;
	bool FZooming;
	bool FDrawOverlayTilesWhenMoving;
	int FZoomEffectDelay;
	bool FSuperZoom;
	Fmx::Uecnativeshape::TECShapes* FDragZoomShapes;
	Fmx::Uecnativeshape::TECShapeLine* FDragZoomLine;
	double FDownRightLat;
	double FDownRightLng;
	bool FUseInfoWindowDescription;
	int FMapActive;
	System::Classes::TNotifyEvent FOnChangeMapActive;
	TECOffScreenScreenShot* FECOffScreenScreenShot;
	double FScaleGestureZoom;
	int FActualZoomGesture;
	int FActualDistanceGestureZoom;
	int FLastDistanceGestureZoom;
	bool FInGestureZoomPlus;
	bool FInGestureZoom;
	bool FInRotation;
	bool FInZoom;
	bool FBeginGesture;
	Fmx::Platform::_di_IFMXApplicationEventService aFMXApplicationEventService;
	int FMaxWidthHeight;
	int FNextAngle;
	int FMaxAngle;
	int FIncAngle;
	bool FAnimAngle;
	Fmx::Types::TAlignLayout FOldAlign;
	Fmx::Uecmaputil::TEcNotify* FNotify;
	bool FHiRes;
	int FscrollingDirection;
	bool FEnableTouchRotation;
	bool FOverSizeForRotation;
	Fmx::Graphics::TBitmap* FTrueSizeScreenShot;
	TECRouting* FRouting;
	Fmx::Uecmaputil::TDisplayMapTiles* FDisplayMapTiles;
	TECWMSLayers* FECWMSLayers;
	TECWFSLayers* FECWFSLayers;
	System::Generics::Collections::TList__1<Fmx::Uecmaputil::TNativeMapObserver*>* FObservers;
	System::Generics::Collections::TList__1<TNativeMapControl*>* FViewList;
	System::Generics::Collections::TList__1<TECOverlayTileLayer*>* FOverlays;
	int FDoRepaint;
	bool inUpdateStyles;
	Fmx::Uecnativetileserver::TNativeMapServer* FOverlayServer;
	Fmx::Uecnativetileserver::TNativeMapServer* FMapServer;
	int FPrevZoom;
	int FPrevTileSize;
	int FLowBaseTile;
	Fmx::Uecmaputil::TThreadedTimer* FThreadedPumpRotation;
	Fmx::Uecmaputil::TThreadedTimer* FThreadedTimer;
	Fmx::Uecnativeshape::TOnLoadShapes FOnLoadShapes;
	TOnLoadGroup FOnLoadGroup;
	bool FChangeTileServer;
	bool FBackgroundComplete;
	bool FInPaintView;
	bool FResizing;
	bool FDragStart;
	TOnMapMouseWheel FOnMapMouseWheel;
	TOnMapPaint FOnShapesPaint;
	TOnMapPaint FOnMapPaint;
	TOnReticlePaint FOnReticlePaint;
	Fmx::Uecnativeshape::TOnAddShapeToView FOnAddShapeToView;
	TOnMapSelectRect FOnSelectRect;
	TOnMapSelectRect FOnSelectChange;
	TOnMapGeofence FOnEnterGeofence;
	TOnMapGeofence FOnLeaveGeofence;
	System::Classes::TNotifyEvent FOnChangeTileServer;
	System::Classes::TNotifyEvent FSaveOnCompleteTiles;
	System::Classes::TNotifyEvent FOnCompleteTiles;
	System::Classes::TNotifyEvent FOnOutOfBounds;
	System::Classes::TNotifyEvent FOnCloseInfoWindow;
	System::Classes::TNotifyEvent FOnShapeAutoHide;
	System::Classes::TNotifyEvent FOnShapeAutoShow;
	System::Classes::TNotifyEvent FOnShapePathChange;
	System::Classes::TNotifyEvent FOnTraffic;
	System::Classes::TNotifyEvent FOnPanoramio;
	System::Classes::TNotifyEvent FOnShapeDragEnd;
	System::Classes::TNotifyEvent FOnChangeMapBounds;
	System::Classes::TNotifyEvent FOnChangeMapZoom;
	System::Classes::TNotifyEvent FOnMapDrag;
	System::Classes::TNotifyEvent FOnMapDragStart;
	System::Classes::TNotifyEvent FOnTilesTimeout;
	System::Classes::TNotifyEvent FOnMapDragEnd;
	System::Classes::TNotifyEvent FOnMapFitBounds;
	System::Classes::TNotifyEvent FOnShapeFocus;
	System::Classes::TNotifyEvent FOnShapeOverIntent;
	TOnMapLatLng FOnEditMapClick;
	TOnMapLatLng FOnMapClick;
	TOnMapLatLng FOnMapLongClick;
	TOnMapLatLng FOnMapRightClick;
	TOnMapLatLng FOnMapMove;
	TOnMapLatLng FOnMapMouseMove;
	TOnMapLatLng FOnMapMouseStop;
	TOnMapLatLng FOnMapMouseUp;
	TOnMapLatLng FOnMapMouseDown;
	TOnMapLatLng FOnMapDblClick;
	Fmx::Uecnativeshape::TOnShapeMove FOnShapeDrag;
	Fmx::Uecnativeshape::TOnShapeMove FOnShapeMove;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnShapeMouseDown;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnShapeMouseUp;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnShapeClick;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnShapeLongClick;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnShapeRightClick;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnShapeDblClick;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnshapeMouseOut;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnShapeMouseOver;
	System::Classes::TNotifyEvent FOnLongPress;
	__int64 FTimeForMouseStop;
	__int64 FStart_Press;
	Fmx::Uecnativeshape::TOnRoutePath FOnRoutePath;
	TOnClusterClick FOnClusterClick;
	TOnPanoramioClick FOnPanoramioClick;
	TOnBeforeUrl FOnBeforeUrl;
	bool FHideShapesWhenWaitingTile;
	bool FHideShapesWhenZoom;
	bool FMouseWheelZoom;
	bool FDblClickZoom;
	bool FAntiFreezeOnLoad;
	bool FTraffic;
	bool FMouseDown;
	System::Uitypes::TMouseButton FMouseDownButton;
	double _min_Latitude;
	double _max_Latitude;
	double _min_longitude;
	double _max_longitude;
	int FTilePPI;
	int FTileSize;
	int FTileZoom;
	int maxOfZoom;
	int FX;
	int FY;
	int FLowFX;
	int FLowFY;
	int FOffsetX;
	int FOffsetY;
	__int64 FMaxTiles;
	__int64 FMaxX;
	int FMaxY;
	int FLowZoom;
	int FLowTileSize;
	int FWheelZoomScaleFactorIncrement;
	int FMouseX;
	int FMouseY;
	TZoomScaleFactor FZoomScaleFactor;
	TZoomScaleFactor FDelayZoomScaleFactor;
	TMapAnimation FMapAnimation;
	bool FFullZoomAfterGestureZoom;
	bool FTwoOrMoreFingers;
	Fmx::Types::TTouchEvent FOldOnTouch;
	Fmx::Uecmaputil::TLatLng FGestureZoomLatLngStart;
	bool FTouchZoom_NoPan;
	Fmx::Types::TTouches FLastTouches;
	Fmx::Uecmaputil::TLatLng FTouchZoomCenterStart;
	double FLastTouchDistance;
	Fmx::Uecmaputil::TLatLng FZoomLatLngStart;
	Fmx::Uecmaputil::TLatLng FZoomLatLng;
	int FZoomAnimNext;
	int FZoomAnimFromSize;
	int FZoomAnimToSize;
	__int64 FZoomAnimTimeStart;
	__int64 FZoomAnimDelay;
	bool FCancelThisFrame;
	bool FZoomChanged;
	bool FInZoomAround;
	bool FAutorizeZoomAnim;
	System::LongInt FMaxInertiaSpeed;
	__int64 _LastMouseMove;
	__int64 FTimeMouseMove;
	__int64 FInertiaThreshold;
	bool FInMouseMove;
	bool FLimitBorder;
	bool FInertiaScroll;
	__int64 FPrechargingDelay;
	System::Byte FPrechargingTilesDepth;
	bool FPrechargingTiles;
	Fmx::Uecmaputil::TLatLng FLastLatLngZoom;
	bool FInMouseWheel;
	bool FZoomPlus_Animation;
	int FCenterZoomX2;
	int FCenterZoomY2;
	int FCenterZoomX;
	int FCenterZoomY;
	bool FuseExternControlEvents;
	bool FForeground;
	unsigned FStartRotation;
	System::Types::TRectF FRectTile;
	System::Types::TRectF FRectMap;
	System::Types::TRectF FViewPort;
	int FOrientationChangedId;
	Fmx::Uecmaputil::TTileServer FTileServer;
	Fmx::Uecgraphics::TECCanvas* FECCanvas;
	Fmx::Uecmaputil::TECWorldInfo* FWorldInfo;
	Fmx::Uecmaputil::TECWorldInfo* FPriveWorldInfo;
	int FAlfWidth;
	int FAlfHeight;
	int PrevStartX;
	int PrevStartY;
	int startX;
	int startY;
	int FTileX;
	int FTileY;
	int FWorldX;
	int FWorldY;
	double FLatitude;
	double Flongitude;
	bool FinSetCenter;
	bool FFirstPaint;
	bool FDblClick;
	bool FBlockResize;
	bool FDraggable;
	bool FFocusedShapeWhenClicking;
	bool FFocusedShapeWhenHovering;
	int FMaxTimeForDrawMoving;
	int FMAX_SHAPE_SHOW_ON_MOVE_MAP;
	int FMAX_SHAPE_FOR_DIRECT_CENTER;
	double FLatEndPan;
	double FLngEndPan;
	double FLatDeltaPan;
	double FLngDeltaPan;
	unsigned FStartPan;
	unsigned FLastdoPan;
	unsigned FLastdoZoom;
	unsigned FLastScreenShot;
	unsigned FLastdoPaint;
	unsigned FLastdoTick;
	unsigned FLastDoStyles;
	System::Byte FZoom;
	System::Byte FMinZoom;
	System::Byte FMaxZoom;
	Fmx::Uecthreadgraphics::TThreadRest* FThreadRest;
	__int64 FTickZoom;
	bool FMouseEnter;
	bool FMouseLeave;
	TECScaleBar* FScaleBar;
	Fmx::Forms::TCommonCustomForm* FParentForm;
	TLayoutMap* FOverlayScreen;
	bool FuseExternControlIDLE;
	bool FInitSize;
	unsigned FTimeExternControlIDLE;
	System::Classes::TNotifyEvent FOnErrorConnexion;
	System::Uitypes::TMouseButton FMouseButtonDragZoom;
	int FXCopyrightTile;
	int FYCopyrightTile;
	int FCopyrightWidth;
	int FCopyrightHeight;
	Fmx::Graphics::TFont* FCopyrightFont;
	int FCopyrightSize;
	Fmx::Uecmaputil::TColor FCopyrightColor;
	Fmx::Uecmaputil::TColor FEmptyTileColor;
	Fmx::Uecmaputil::TLatLng FNewCenter;
	Fmx::Uecmaputil::TLatLng FMouseLatLng;
	System::UnicodeString FBaseDir;
	unsigned FTimeLongClick;
	Fmx::Uecnativeshape::TECShapesGroup* FShapesGroup;
	Fmx::Uecgeolocalise::TECGeoLocalise* FGeoLocalise;
	TECSnapDrag* FECSnapDrag;
	TECOverPass* FECOverPass;
	TECBoundary* FECBoundary;
	System::Types::TPoint FLowStartXY;
	bool Flag_LimitBox;
	bool FLoaded;
	bool inPaint;
	bool Valide_Map;
	bool FShowCopyrightTile;
	System::UnicodeString FPTVKey;
	System::UnicodeString FOpenCycleMapKey;
	System::UnicodeString FDigitalGlobeToken;
	System::UnicodeString FMapBoxKey;
	System::UnicodeString FVectorMapZenKey;
	System::UnicodeString FStadiaMapsKey;
	System::UnicodeString FTraceStrackKey;
	System::UnicodeString FHereParam;
	System::UnicodeString _Direction_Params;
	Fmx::Uecgeolocalise::TECRoutePath* _Direction_RoutePath;
	Fmx::Uecmaputil::TLocalCacheSetting LCS1;
	bool FForceRefreshDisplayedTiles;
	int PPI;
	int FMinLowZoom;
	bool FUseLowZoom;
	bool FinNotify;
	bool FOnlyLocal;
	bool FSSL;
	Fmx::Uecmaputil::TToTxtType FToTxtType;
	int FMaxXY;
	int FDoDraw;
	double FSelectedArea;
	bool FNotMoveMapIfMouseReachesEdge;
	bool FCheckBackgroundComplete;
	bool FOKCheckCacheSize;
	__int64 FLastCheckCacheSize;
	__int64 FMaximumTilesTimeout;
	__int64 FTimeLastTile;
	System::UnicodeString FIgnKey;
	bool FEditableAddPointByClickOnMap;
	bool FCancelAnimationWhenRotation;
	bool FReticle;
	Fmx::Uecmaputil::TColor FReticleColor;
	TECSelectArea* FECSelectArea;
	TECPTV* FECPTV;
	bool FDarkMode;
	bool FLightMode;
	TECGrids* FECGrids;
	__int64 FStart_Delayed_Repaint;
	__int64 FRepaint_after_ms;
	__int64 FStart_Delayed_ZoomScaleFactor;
	int FInitialMaxShapeShowOnMoveMap;
	int FMarginHint;
	TECOpenWeatherTilesLayer* FECOpenWeatherTilesLayer;
	void __fastcall UpdateComponents();
	void __fastcall setOSMShortLink(const System::UnicodeString AShortLink);
	System::UnicodeString __fastcall getOSMShortLink();
	void __fastcall setDarkMode(const bool Value);
	void __fastcall setLightMode(const bool Value);
	bool __fastcall GetReverseScrollingDirection();
	void __fastcall SetReverseScrollingDirection(const bool Value);
	System::UnicodeString __fastcall getDefaultHintProperty();
	void __fastcall setDefaultHintProperty(const System::UnicodeString Value);
	void __fastcall setMarginHint(const int Value);
	Fmx::Uecnativeshape::TECShapeInfoWindow* __fastcall getInfoWindowDescription();
	Fmx::Uecnativeshape::TECShapeLine* __fastcall getEditShadowLine();
	Fmx::Uecnativeshape::TECShape* __fastcall getEditShape();
	void __fastcall setDragShape(Fmx::Uecnativeshape::TECShape* const Value);
	Fmx::Uecnativeshape::TECShape* __fastcall getDragShape();
	TECOpenWeatherTilesLayer* __fastcall getOpenWeatherTilesLayer();
	void __fastcall Delayed_Repaint(const __int64 repaint_after_ms);
	void __fastcall setMaxDayInCache(const double Value);
	TECXapiLayer* __fastcall getXapiLayer();
	Fmx::Uecopenweather::TECOpenWeather* __fastcall getOpenWeather();
	Fmx::Uecnativeshape::TECGeofences* __fastcall getGeofences();
	void __fastcall MoveMapIfMouseReachesEdge(const int Delta = 0x20);
	void __fastcall LockDraw();
	void __fastcall UnLockDraw();
	bool __fastcall OkDraw();
	Fmx::Uecnativeshape::TECCartoStyles* __fastcall getCartoStyles();
	void __fastcall setDrawVectorTiles(const bool Value);
	bool __fastcall getDrawVectorTiles();
	System::Types::TPoint __fastcall getLowLevelStartXY(const int lowZoom);
	bool __fastcall getSaveEncodedPolyline();
	void __fastcall setSaveEncodedPolyline(const bool Value);
	System::UnicodeString __fastcall getLocale();
	void __fastcall setLocale(const System::UnicodeString Value);
	void __fastcall setCopyrightColor(const Fmx::Uecmaputil::TColor Value);
	void __fastcall setCopyrightSize(const int Value);
	System::UnicodeString __fastcall getCloudMadeKey();
	System::UnicodeString __fastcall getBingKey();
	System::UnicodeString __fastcall getMapQuestKey();
	System::UnicodeString __fastcall getVectorMapZenKey();
	System::UnicodeString __fastcall getMapBoxKey();
	System::UnicodeString __fastcall getDigitalGlobeToken();
	System::UnicodeString __fastcall getOpenCycleMapKey();
	System::UnicodeString __fastcall getTomTomKey();
	System::UnicodeString __fastcall getPTVKey();
	System::UnicodeString __fastcall getAqicnKey();
	System::UnicodeString __fastcall getStadiaMapsKey();
	System::UnicodeString __fastcall getTraceStrackKey();
	void __fastcall setOpenCycleMapKey(const System::UnicodeString key);
	void __fastcall setCloudMadeKey(const System::UnicodeString key);
	void __fastcall setBingKey(const System::UnicodeString key);
	void __fastcall setMapQuestKey(const System::UnicodeString key);
	void __fastcall setVectorMapZenKey(const System::UnicodeString Value);
	void __fastcall setMapBoxKey(const System::UnicodeString Value);
	void __fastcall setDigitalGlobeToken(const System::UnicodeString Value);
	void __fastcall setTomTomKey(const System::UnicodeString Value);
	void __fastcall setPTVKey(const System::UnicodeString Value);
	void __fastcall setAqicnKey(const System::UnicodeString Value);
	void __fastcall setStadiaMapsKey(const System::UnicodeString Value);
	void __fastcall setTraceStrackKey(const System::UnicodeString Value);
	void __fastcall setHereParam(const System::UnicodeString Value);
	void __fastcall setHereID(const System::UnicodeString key);
	System::UnicodeString __fastcall getHereID();
	System::UnicodeString __fastcall getHereParam();
	System::UnicodeString __fastcall getIgnKey();
	void __fastcall setIgnKey(const System::UnicodeString key);
	void __fastcall setWorldLeftTop(const System::Types::TPoint &Value);
	System::Types::TPoint __fastcall getWorldLeftTop();
	System::UnicodeString __fastcall getUrl();
	void __fastcall setUrl(const System::UnicodeString Value);
	void __fastcall setAddress(const System::UnicodeString Value);
	System::UnicodeString __fastcall getAddress();
	void __fastcall setGeoLocalise(Fmx::Uecgeolocalise::TECGeoLocalise* Value);
	TECSnapDrag* __fastcall getSnapDrag();
	TECBoundary* __fastcall getBoundary();
	TECOverPass* __fastcall getOverPass();
	void __fastcall doOnDirection(System::TObject* sender, const System::UnicodeString Params, Fmx::Uecgeolocalise::TECRoutePath* routePath);
	void __fastcall setOnTraffic(System::Classes::TNotifyEvent Event);
	void __fastcall settrafficLayer(const bool Value);
	void __fastcall setOnAddShapeToView(Fmx::Uecnativeshape::TOnAddShapeToView Event);
	void __fastcall setOnLoadShapes(Fmx::Uecnativeshape::TOnLoadShapes Event);
	void __fastcall doOnLoadShapes(System::TObject* sender, const System::UnicodeString ShapeType, const int index, const int max, bool &cancel);
	void __fastcall doOnHotSpot(System::TObject* sender, const System::UnicodeString ValueUrl);
	void __fastcall setOnShapePathChange(System::Classes::TNotifyEvent Event);
	void __fastcall setOnCloseInfoWindow(System::Classes::TNotifyEvent Event);
	void __fastcall setOnShapeAutoHide(System::Classes::TNotifyEvent Event);
	void __fastcall setOnShapeAutoShow(System::Classes::TNotifyEvent Event);
	Fmx::Uecnativeshape::TECShapes* __fastcall getShapes();
	Fmx::Uecnativeshape::TECShapes* __fastcall getShapesGroup(const System::UnicodeString Value)/* overload */;
	Fmx::Uecnativeshape::TECShapes* __fastcall getShapesGroup(const int Value)/* overload */;
	Fmx::Uecnativeshape::TECGroupShapesList* __fastcall getShapesGroups();
	Fmx::Uecnativeshape::TECSelectedShapesList* __fastcall getSelected();
	void __fastcall doThreadTimer(System::TObject* sender);
	void __fastcall doOnServerClearCache(System::TObject* sender);
	void __fastcall doAnimationZoom();
	void __fastcall doAnimationPan();
	void __fastcall doStopAnimation();
	void __fastcall setWaitingForDestruction(const bool Value);
	bool __fastcall getWaitingForDestruction();
	Fmx::Uecmaputil::TNbrThreadTile __fastcall getNbrThreadTile();
	void __fastcall setNbrThreadTile(const Fmx::Uecmaputil::TNbrThreadTile Value);
	void __fastcall setMapActive(const bool Value);
	bool __fastcall getMapActive();
	void __fastcall setOnlyOneOpenInfoWindow(const bool Value);
	bool __fastcall getOnlyOneOpenInfoWindow();
	Fmx::Uecmaputil::TECFilterColor* __fastcall getBaseMapColorsFilter();
	void __fastcall doMapLayoutResize(System::TObject* sender);
	void __fastcall SetuseExternControlEvents(const bool Value);
	bool __fastcall HandleAppEvent(Fmx::Platform::TApplicationEvent AAppEvent, System::TObject* AContext);
	void __fastcall doThreadPumpRotation(System::TObject* sender);
	void __fastcall doOnMove(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item, bool &cancel);
	void __fastcall doGeofences(Fmx::Uecnativeshape::TECShape* const Item);
	bool __fastcall isBaseMapReady(const bool true_if_move)/* overload */;
	bool __fastcall isBaseMapReady(const double Lat, const double Lng, const int AZoom)/* overload */;
	void __fastcall CheckOverlaysReady();
	void __fastcall RepaintMap(bool Cached = false)/* overload */;
	void __fastcall doOnLoadTile(System::TObject* sender, const int X, const int Y, const int Z, const int t);
	void __fastcall doOnLoadOverlayTile(System::TObject* sender, const int X, const int Y, const int Z, const int t);
	void __fastcall doErrorConnexion(System::TObject* sender);
	void __fastcall SetCacheSize(const System::Word AValue);
	System::Word __fastcall getCacheSize();
	Fmx::Uecnativetileserver::TTileServerInfo* __fastcall getTileServerInfo();
	double __fastcall getTileServerOpacity();
	void __fastcall setTileServerOpacity(const double Value);
	void __fastcall LoadScreenZoomAround(const Fmx::Uecmaputil::TLatLng &LatLngZoom, const int NewZoom);
	void __fastcall LoadScreenZoom(const double Lat, const double Lng, const int level)/* overload */;
	void __fastcall LoadScreenZoom(const double Lat, const double Lng)/* overload */;
	void __fastcall LoadScreenZoom(TECOverlayTileLayer* const FOV)/* overload */;
	void __fastcall SetZoom(const System::Byte Value);
	void __fastcall setMinZoom(const System::Byte Value);
	void __fastcall setMaxZoom(const System::Byte Value);
	void __fastcall setZoomScaleFactor(const TZoomScaleFactor zoomscale);
	void __fastcall _setZoomScaleFactor(const TZoomScaleFactor zoomscale);
	double __fastcall getNumericalZoom();
	void __fastcall setNumericalZoom(const double Value);
	double __fastcall getNorthEastLatitude();
	double __fastcall getNorthEastLongitude();
	double __fastcall getSouthWestLatitude();
	double __fastcall getSouthWestLongitude();
	TECSelectArea* __fastcall getSelectArea();
	TECPTV* __fastcall getPTV();
	void __fastcall SetTileServer(const Fmx::Uecmaputil::TTileServer Value);
	Fmx::Uecmaputil::TTileServer __fastcall getTileServer();
	void __fastcall setCopyrightTile(const System::UnicodeString Value);
	System::UnicodeString __fastcall getCopyrightTile();
	System::UnicodeString __fastcall getFilenameStartEditLine();
	void __fastcall setFilenameStartEditLine(const System::UnicodeString Value);
	System::UnicodeString __fastcall getFilenameEndEditLine();
	void __fastcall setFilenameEndEditLine(const System::UnicodeString Value);
	System::UnicodeString __fastcall getFilenamePointEditLine();
	void __fastcall setFilenamePointEditLine(const System::UnicodeString Value);
	System::UnicodeString __fastcall getLocalCache();
	void __fastcall setLocalCache(const System::UnicodeString Value);
	System::UnicodeString __fastcall getLocalArchive();
	void __fastcall setLocalArchive(const System::UnicodeString Value);
	void __fastcall _SetCenter(const Fmx::Uecmaputil::TLatLng &AValue);
	Fmx::Uecmaputil::TLatLng __fastcall GetCenter();
	Fmx::Uecmaputil::TIntPoint __fastcall GetMouseMapPixel(int X, int Y);
	bool __fastcall getExitEditableClickLastPointLine();
	void __fastcall setExitEditableClickLastPointLine(const bool Value);
	Fmx::Uecnativeshape::TECShape* __fastcall getShapeBringToFront();
	void __fastcall setShapeBringToFront(Fmx::Uecnativeshape::TECShape* const Value);
	void __fastcall doRepaint(TFrameKey FrameKey = (TFrameKey)(0x0));
	void __fastcall EC_Repaint(System::TObject* sender);
	void __fastcall TileServerChanged(System::TObject* sender);
	void __fastcall FilterColorsChanged(System::TObject* sender);
	void __fastcall doOnTouch(System::TObject* sender, const Fmx::Types::TTouches Touches, const Fmx::Types::TTouchAction Action);
	void __fastcall doZoomTouch(System::TObject* sender, const Fmx::Types::TTouches Touches, const Fmx::Types::TTouchAction Action);
	void __fastcall doMapGesture(System::TObject* sender, const Fmx::Types::TGestureEventInfo &EventInfo, bool &Handled);
	void __fastcall handleGestureZoom(const Fmx::Types::TGestureEventInfo &EventInfo);
	bool __fastcall setViewZoom(const int FromSize, const int NextSize, const int MaxSize, const int NextZoom, const Fmx::Uecmaputil::TLatLng &CibleLatLng, Fmx::Uecmaputil::TLatLng &CenterLatLng);
	void __fastcall OrientationChangedHandler(System::TObject* const sender, System::Messaging::TMessageBase* const Msg);
	void __fastcall EC_FitBounds(System::TObject* sender);
	void __fastcall EC_Set_Rotation(System::TObject* sender);
	void __fastcall EC_ShowHint(System::TObject* sender);
	void __fastcall EC_PanTo(System::TObject* sender);
	void __fastcall EC_ShowAll(System::TObject* sender);
	void __fastcall EC_Center(System::TObject* sender);
	void __fastcall EC_ONLOAD(System::TObject* sender);
	void __fastcall EC_ONFOCUS(System::TObject* sender);
	void __fastcall EC_Bounds(System::TObject* sender);
	void __fastcall EC_OnDirection(System::TObject* sender);
	void __fastcall setOverSizeForRotation(const bool Value);
	void __fastcall doOverSizeResize(System::TObject* sender);
	void __fastcall setLatitude(const double Lat);
	void __fastcall setLongitude(const double Lng);
	bool __fastcall _UpdateBounds(const bool bAll = true);
	bool __fastcall UpdateBounds(const bool bAll = true);
	void __fastcall Scrollto(const double Lat, const double Lng);
	void __fastcall setLimitBoundingBox(Fmx::Uecmaputil::TLatLng &Value);
	void __fastcall setToKml(const System::UnicodeString Value);
	System::UnicodeString __fastcall getToKml();
	void __fastcall setToGpx(const System::UnicodeString Value);
	System::UnicodeString __fastcall getToGPX();
	void __fastcall setToTxt(const System::UnicodeString Value);
	System::UnicodeString __fastcall getToTxt();
	void __fastcall setToGeoJSon(const System::UnicodeString Value);
	System::UnicodeString __fastcall getToGeoJSon();
	void __fastcall Notify(unsigned MsgConst, System::TObject* WParam = (System::TObject*)(0x0));
	Fmx::Graphics::TBitmap* __fastcall getBitmap();
	void __fastcall setDraggable(const bool Value);
	void __fastcall setTileSize(const int Value);
	void __fastcall setTilePPI(const int Value);
	void __fastcall WorldMoveTo(System::TObject* sender, const double latitude, const double longitude);
	void __fastcall setMAX_SHAPE_SHOW_ON_MOVE_MAP(const int Value);
	void __fastcall setMaxTimeForDrawMoving(const int Value);
	TNativeMapControl* __fastcall getView(int index);
	int __fastcall getViewCount();
	int __fastcall getGroupCount();
	void __fastcall setDirectLoadLocalTile(const bool Value);
	bool __fastcall getDirectLoadLocalTile();
	void __fastcall setIdle(bool Value);
	bool __fastcall getIdle();
	float __fastcall getScaleFactor();
	void __fastcall setScaleFactor(const float Value);
	TECOffScreenScreenShot* __fastcall getOffScreenScreenShot();
	Fmx::Uecnativeshape::TOnCreateJSONPoint __fastcall getOnCreateJSONPoint();
	void __fastcall setOnCreateJSONPoint(const Fmx::Uecnativeshape::TOnCreateJSONPoint Value);
	void __fastcall setUserAgent(const System::UnicodeString Value);
	void __fastcall setSSL(const bool Value);
	void __fastcall setOnlyLocal(const bool Value);
	Fmx::Uecnativeshape::TOnGetScale __fastcall getOnGetScale();
	void __fastcall setOnGetScale(Fmx::Uecnativeshape::TOnGetScale Value);
	bool __fastcall getDontScaleMarkerToZoomIfSelected();
	void __fastcall setDontScaleMarkerToZoomIfSelected(bool Value);
	bool __fastcall getScaleMarkerToZoom();
	void __fastcall setScaleMarkerToZoom(bool Value);
	void __fastcall setToTxtType(const Fmx::Uecmaputil::TToTxtType Value);
	Fmx::Uecnativeshape::TECShape* __fastcall getMouseOverShape();
	void __fastcall setMouseOverShape(Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall Draw_Reticle();
	void __fastcall Draw_Copyright();
	void __fastcall FMXDraw_Copyright(Fmx::Graphics::TCanvas* const ACanvas);
	void __fastcall DrawOffScreen(const System::Classes::TNotifyEvent EventDraw);
	void __fastcall doOnOSMLoaded(System::TObject* sender);
	void __fastcall setFocusedShapeWhenHovering(const bool Value);
	void __fastcall doASyncPathChange(System::TObject* sender);
	void __fastcall setConversionESPG(Fmx::Uecmaputil::TOnConversionESPG Value);
	Fmx::Uecmaputil::TOnConversionESPG __fastcall getConversionESPG();
	void __fastcall setESPGToLatLng(Fmx::Uecmaputil::TOnConversionESPG Value);
	Fmx::Uecmaputil::TOnConversionESPG __fastcall getESPGToLatLng();
	System::Classes::TNotifyEvent __fastcall getOnChangeEditable();
	void __fastcall setOnChangeEditable(System::Classes::TNotifyEvent sender);
	
protected:
	virtual void __fastcall Loaded();
	virtual void __fastcall Resize();
	void __fastcall setHiRes(const bool Value);
	virtual void __fastcall DoMatrixChanged(System::TObject* sender);
	virtual void __fastcall MouseWheel(System::Classes::TShiftState Shift, int wheelDelta, bool &Handled);
	virtual void __fastcall MouseDown(System::Uitypes::TMouseButton Button, System::Classes::TShiftState Shift, float X, float Y);
	virtual void __fastcall MouseUp(System::Uitypes::TMouseButton Button, System::Classes::TShiftState Shift, float X, float Y);
	void __fastcall MouseUpInit(System::Uitypes::TMouseButton Button, System::Classes::TShiftState Shift, int X, int Y);
	void __fastcall MouseDownInit(System::Uitypes::TMouseButton Button, System::Classes::TShiftState Shift, int X, int Y);
	virtual void __fastcall MouseMove(System::Classes::TShiftState Shift, float X, float Y);
	void __fastcall MouseMoveInit(System::Classes::TShiftState Shift, int X, int Y);
	virtual void __fastcall DoMouseLeave();
	virtual void __fastcall DoMouseEnter();
	virtual void __fastcall DblClick();
	virtual void __fastcall Paint();
	void __fastcall setIcons(Fmx::Imglist::TCustomImageList* Value);
	Fmx::Imglist::TCustomImageList* __fastcall getIcons();
	Fmx::Uecnativeshape::TECShapeInfoWindow* __fastcall getHintInfoWindow();
	void __fastcall RepaintView();
	void __fastcall WM_Subject_Destroy(System::TObject* sender);
	void __fastcall WM_Shape_Move(System::TObject* sender);
	unsigned __fastcall getTimerSpeed();
	void __fastcall setTimerSpeed(const unsigned Value);
	void __fastcall CheckCacheSize();
	void __fastcall PauseTiles(const bool Value);
	__int64 __fastcall ASyncLoad(const System::UnicodeString Url, const System::Classes::TNotifyEvent Notify, System::TObject* const TagObject = (System::TObject*)(0x0))/* overload */;
	__int64 __fastcall ASyncLoad(const System::UnicodeString Url, const System::Classes::TNotifyEvent Notify, const System::Classes::TNotifyEvent Execute, System::TObject* const TagObject = (System::TObject*)(0x0))/* overload */;
	void __fastcall setTimeTileServerWMS(const System::UnicodeString Value);
	System::UnicodeString __fastcall getTimeTileServerWMS();
	
public:
	__fastcall virtual TNativeMapControl(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TNativeMapControl();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	bool __fastcall isMoving();
	void __fastcall ProcessMessages();
	void __fastcall setTileHeader(const System::UnicodeString Name, const System::UnicodeString Value);
	void __fastcall setUseWinINET(const bool use);
	void __fastcall setProxyParams(const System::UnicodeString server, const int port, const System::UnicodeString username = System::UnicodeString(), System::UnicodeString password = System::UnicodeString());
	void __fastcall AddView(TNativeMapControl* const view);
	void __fastcall ReleaseView(TNativeMapControl* const view);
	void __fastcall ReleaseAllView();
	void __fastcall ForceRefreshDisplayedTiles();
	int __fastcall ShapesCount();
	HIDESBASE void __fastcall Lock();
	void __fastcall UnLock();
	void __fastcall AddStreamTile(System::Classes::TMemoryStream* const TileStream, const int X, const int Y, const int Z, TECOverlayTileLayer* const OverlayTile = (TECOverlayTileLayer*)(0x0));
	System::UnicodeString __fastcall XYZToGeoBaseTile(const int X, const int Y, const int Z, const System::UnicodeString geoStreamServerURL, const int geoTilesPerSuperTile = 0x4, const bool geoSatellite = false);
	virtual void __fastcall SetBounds(float X, float Y, float AWidth, float AHeight);
	virtual bool __fastcall PointInObject(float X, float Y);
	bool __fastcall AnimRotationAngleTo(const int Value);
	bool __fastcall getNoInfowindowRotation();
	void __fastcall setNoInfowindowRotation(const bool Value);
	void __fastcall ControlParent(Fmx::Uecmaputil::TWinControl* Value);
	void __fastcall Detach(Fmx::Uecmaputil::TNativeMapObserver* Observer);
	void __fastcall Attach(Fmx::Uecmaputil::TNativeMapObserver* Observer);
	void __fastcall PreLoadGraphic(const System::UnicodeString Filename);
	Fmx::Uecmaputil::TGraphic* __fastcall getGraphic(const System::UnicodeString Filename);
	bool __fastcall IsValidGraphic(const System::UnicodeString Filename);
	void __fastcall RemoveGraphic(const System::UnicodeString Value, const bool shared = true);
	void __fastcall ClearGraphics();
	Fmx::Uecnativeshape::TECShape* __fastcall Add(const Fmx::Uecnativeshape::TNativeShape shape, const double Lat, const double Lng, const System::UnicodeString GroupName = System::UnicodeString());
	Fmx::Uecnativeshape::TECShapeLine* __fastcall AddRoute(Fmx::Uecgeolocalise::TECRoutePath* const routePath, const System::UnicodeString GroupName = System::UnicodeString());
	Fmx::Uecnativeshape::TECShapePOI* __fastcall AddPOI(const double Lat, const double Lng, const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapePOI* __fastcall AddPOI(const double SWLat, const double SWLng, const double NELat, const double NELng, const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapePOI* __fastcall AddCircle(const double Lat, const double Lng, const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapePOI* __fastcall AddCircle(const double SWLat, const double SWLng, const double NELat, const double NELng, const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapePOI* __fastcall AddPoint(const double Lat, const double Lng, const System::UnicodeString GroupName = System::UnicodeString());
	Fmx::Uecnativeshape::TECShapeMarker* __fastcall AddMarker(const double Lat, const double Lng, const System::UnicodeString GroupName = System::UnicodeString());
	Fmx::Uecnativeshape::TECShapeLine* __fastcall AddLine(const double Lat, const double Lng, const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapeLine* __fastcall AddLine(const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapeLine* __fastcall AddLineFromAddress(const System::UnicodeString address, const System::UnicodeString GroupName = System::UnicodeString());
	Fmx::Uecnativeshape::TECShapePolygone* __fastcall AddPolygoneFromAddress(const System::UnicodeString address, const System::UnicodeString GroupName = System::UnicodeString());
	Fmx::Uecnativeshape::TECShapeLine* __fastcall AddEncodedLine(const System::UnicodeString EncodedLine, const System::Byte precision = (System::Byte)(0x5), const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapeLine* __fastcall AddLine(const double *dLatLngs, const System::NativeInt dLatLngs_High, const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapeLine* __fastcall AddLine(TECNativeFreeHand* const vFreeHand, const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapeLine* __fastcall AddLine(Fmx::Uecnativeshape::TECShapeLine* const dLine, const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapeLine* __fastcall AddGeodesicLine(const double SLat, const double SLng, const double ELat, const double ELng, const System::UnicodeString GroupName = System::UnicodeString(), const int maxSegmentLength = 0x1388);
	Fmx::Uecnativeshape::TECShapePolygone* __fastcall AddPolygone(const Fmx::Uecopenlocationcode::TecOLC_CODEAREA &olcArea, const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapePolygone* __fastcall AddPolygone(TECNativeFreeHand* const vFreeHand, const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapePolygone* __fastcall AddPolygone(const double Lat, const double Lng, const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapePolygone* __fastcall AddPolygone(const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapePolygone* __fastcall AddPolygone(Fmx::Uecnativeshape::TECShapeLine* const dLine, const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapePolygone* __fastcall AddEncodedPolygone(const System::UnicodeString EncodedLine, const System::Byte precision = (System::Byte)(0x5), const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapePolygone* __fastcall AddPolygone(const double *dLatLngs, const System::NativeInt dLatLngs_High, const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapePolygone* __fastcall AddPolygone(const Fmx::Uecmaputil::TLatLng &SouthWest, const Fmx::Uecmaputil::TLatLng &NorthEast, const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	Fmx::Uecnativeshape::TECShapeInfoWindow* __fastcall AddInfoWindow(const double Lat, const double Lng, const System::UnicodeString GroupName = System::UnicodeString());
	HIDESBASE void __fastcall Remove(Fmx::Uecnativeshape::TECShape* const shape);
	TECOverlayTileLayer* __fastcall getOverlayTilesByName(const System::UnicodeString Value);
	TECOverlayTileLayer* __fastcall AddOverlayTiles(Fmx::Uecmaputil::TOnMapServerTilePath getOverlayTiles, const System::UnicodeString Name = L"Overlay_Tiles", const System::Byte MaxZoom = (System::Byte)(0x12), const System::Byte MinZoom = (System::Byte)(0x2), const Fmx::Uecmaputil::TTileServer aTileServer = (Fmx::Uecmaputil::TTileServer)(0x4));
	TECOverlayTileLayer* __fastcall AddOverlayTileServer(Fmx::Uecmaputil::TTileServer Value);
	TECOverlayTileLayer* __fastcall AddOverlayTileServerWMS(const System::UnicodeString Url, const System::UnicodeString layers, const int ESPG = 0x10e6);
	void __fastcall TileServerWMS(const System::UnicodeString Url, const System::UnicodeString layers, const int ESPG = 0x10e6);
	void __fastcall WMS_Legend(const bool show, const TLegendPosition position = (TLegendPosition)(0x1), const System::Byte Opacity = (System::Byte)(0x64), const int XMargin = 0x7, const int YMargin = 0x7);
	TECOverlayTileLayer* __fastcall AddOverlayStreamTiles(Fmx::Uecmaputil::TOnMapServerTileStream getOverlayStreamTiles, const System::UnicodeString Name = L"Overlay_StreamTiles", const System::Byte MaxZoom = (System::Byte)(0x12), const System::Byte MinZoom = (System::Byte)(0x2));
	void __fastcall RemoveOverlayTiles(const int index)/* overload */;
	void __fastcall RemoveOverlayTiles(const Fmx::Uecmaputil::TTileServer Value)/* overload */;
	void __fastcall RemoveOverlayTiles(const System::UnicodeString Value)/* overload */;
	void __fastcall RemoveOverlayTiles(TECOverlayTileLayer* const overlay)/* overload */;
	void __fastcall RemoveAllOverlayTiles();
	void __fastcall Clear();
	void __fastcall ClearTilesThread();
	void __fastcall ClearMemoryCache();
	void __fastcall ClearMemoryCacheAndDisconnect();
	void __fastcall ShowHintAtPos(const double Lat, const double Lng, const System::UnicodeString Hint, const unsigned DelayHint = (unsigned)(0x7d0));
	bool __fastcall ReadyToClose();
	HIDESBASE void __fastcall BeginUpdate();
	HIDESBASE void __fastcall EndUpdate();
	void __fastcall SaveToFile(const System::UnicodeString Filename);
	void __fastcall LoadFromFile(const System::UnicodeString Filename);
	void __fastcall setCenter(const double Lat, const double Lng);
	void __fastcall DelayCenter(const double Lat, const double Lng);
	void __fastcall Bounds(const double NELat, const double NELng, const double SWLat, const double SWLng)/* overload */;
	void __fastcall Bounds(const TECRecordLayer &recLayer)/* overload */;
	void __fastcall Bounds(const TECRecordFeature &recFeature)/* overload */;
	void __fastcall UnBoundingBox();
	void __fastcall BoundingBox(const double NELat = 8.505113E+01, const double NELng = 1.800000E+02, const double SWLat = -8.505113E+01, const double SWLng = -1.800000E+02);
	void __fastcall fitBounds()/* overload */;
	void __fastcall fitBounds(Fmx::Uecnativeshape::TECShapes* const *Shapes, const System::NativeInt Shapes_High)/* overload */;
	void __fastcall fitBounds(const double NELat, const double NELng, const double SWLat, const double SWLng)/* overload */;
	void __fastcall fitBounds(const Fmx::Uecopenlocationcode::TecOLC_CODEAREA &olcArea)/* overload */;
	void __fastcall fitBoundsRadius(const double dLat, const double dLng, const double dRadiusKm);
	bool __fastcall isGroupExists(const System::UnicodeString Name);
	int __fastcall FindByKeyValue(Fmx::Uecnativeshape::TECShapes* const G, const System::UnicodeString key, const System::UnicodeString Value, System::Generics::Collections::TList__1<Fmx::Uecnativeshape::TECShape*>* const ShapeList)/* overload */;
	int __fastcall FindByKeyValue(const System::UnicodeString key, const System::UnicodeString Value, System::Generics::Collections::TList__1<Fmx::Uecnativeshape::TECShape*>* const ShapeList)/* overload */;
	int __fastcall FindShapeByArea(const double SWALat, const double SWALng, const double NEALat, const double NEALng, System::Generics::Collections::TList__1<Fmx::Uecnativeshape::TECShape*>* const ShapeList, const Fmx::Uecnativeshape::TNativeShapes FilterShapes = Fmx::Uecnativeshape::TNativeShapes() , Fmx::Uecnativeshape::TOnShapeFilter Filter = 0x0);
	int __fastcall FindShapeByKMDistance(const double FLat, const double FLng, const double FKMDistance, System::Generics::Collections::TList__1<Fmx::Uecnativeshape::TECShape*>* const ShapeList, const Fmx::Uecnativeshape::TNativeShapes FilterShapes = Fmx::Uecnativeshape::TNativeShapes() , Fmx::Uecnativeshape::TOnShapeFilter Filter = 0x0);
	int __fastcall FindShapeByFilter(System::Generics::Collections::TList__1<Fmx::Uecnativeshape::TECShape*>* const ShapeList, const Fmx::Uecnativeshape::TNativeShapes FilterShapes, Fmx::Uecnativeshape::TOnShapeFilter Filter);
	void __fastcall Invalidate();
	void __fastcall ReLoad(const bool reloadGraphicThreadPool = true);
	void __fastcall PanTo(const double Lat, const double Lng, const int max_time_pan = 0xfa);
	void __fastcall FromLatLngToBoundingBoxTile(const double Lat, const double Lng, double &NELat, double &NELng, double &SWLat, double &SWLng, const int aTileSize = 0x0);
	void __fastcall BoundingBoxTiles(const double _NELat, const double _NELng, const double _SWLat, const double _SWLng, double &NELat, double &NELng, double &SWLat, double &SWLng);
	void __fastcall BoundingBoxTilesScreen(double &NELat, double &NELng, double &SWLat, double &SWLng);
	Fmx::Uecmaputil::TLatLng __fastcall FromXYToLatLng(int X, int Y);
	void __fastcall FromLatLngToXY(const double Lat, const double Lng, int &X, int &Y)/* overload */;
	void __fastcall FromLatLngToXY(const Fmx::Uecmaputil::TLatLng &LatLng, int &X, int &Y)/* overload */;
	TPositionOnMap __fastcall GetPositionOnMap(const double Lat, const double Lng);
	HIDESBASE void __fastcall Move(const TECDirection Direction, const double DistanceKM);
	void __fastcall ScrollXY(const int X, const int Y);
	Fmx::Uecmaputil::TLatLng __fastcall ScrollLatLngXY(const double Lat, const double Lng, const int X, const int Y);
	void __fastcall setProjection(Fmx::Uecmaputil::TOnProjectionLatLngToXY ProjLatLngToXY, Fmx::Uecmaputil::TOnProjectionXYToLatLng ProjXYYoLatLng);
	System::LongInt __fastcall TopGroupZIndex();
	void __fastcall ShowInfoWindow(const double Lat, const double Lng, const System::UnicodeString Content);
	void __fastcall ShowInfoWindowDescription(const double Lat, const double Lng, Fmx::Uecnativeshape::TECShape* const shape, const bool UpdateItem = true)/* overload */;
	void __fastcall ShowInfoWindowDescription(Fmx::Uecnativeshape::TECShape* const shape, const bool UpdateItem = true)/* overload */;
	Fmx::Uecgeolocalise::TECRoutePath* __fastcall GetRoutePathByAdress(const System::UnicodeString StartAdress, const System::UnicodeString EndAdress, const Fmx::Uecmaputil::TMQRouteType routeType = (Fmx::Uecmaputil::TMQRouteType)(0x0), const System::UnicodeString Params = System::UnicodeString());
	Fmx::Uecgeolocalise::TECRoutePath* __fastcall GetRoutePathFrom(const double *dLatLngs, const System::NativeInt dLatLngs_High, const Fmx::Uecmaputil::TMQRouteType routeType = (Fmx::Uecmaputil::TMQRouteType)(0x0), const System::UnicodeString Params = System::UnicodeString());
	void __fastcall GetASyncRoutePathByAdress(const System::UnicodeString StartAdress, const System::UnicodeString EndAdress, const Fmx::Uecmaputil::TMQRouteType routeType = (Fmx::Uecmaputil::TMQRouteType)(0x0), const System::UnicodeString Params = System::UnicodeString());
	void __fastcall GetASyncRoutePathFrom(const double *dLatLngs, const System::NativeInt dLatLngs_High, const Fmx::Uecmaputil::TMQRouteType routeType = (Fmx::Uecmaputil::TMQRouteType)(0x0), const System::UnicodeString Params = System::UnicodeString());
	void __fastcall ZoomAround(const Fmx::Uecmaputil::TLatLng &LatLngZoom, const int NewZoom);
	void __fastcall ZoomScaleFactorAround(const Fmx::Uecmaputil::TLatLng &LatLngZoom, const int NewZoomScaleFactor);
	void __fastcall ZoomScaleFactorAroundFix(const Fmx::Uecmaputil::TLatLng &LatLngZoom, const int NewZoomScaleFactor);
	bool __fastcall isMouseDownButton(System::Uitypes::TMouseButton Value);
	System::Uitypes::TAlphaColor __fastcall GetMouseColor();
	System::Uitypes::TAlphaColor __fastcall GetXYColor(const int X, const int Y);
	__property TLayoutMap* OverlayScreen = {read=FOverlayScreen};
	__property TECSelectArea* SelectArea = {read=getSelectArea};
	__property TECPTV* PTV = {read=getPTV};
	__property TECGrids* Grids = {read=FECGrids};
	__property double MaxDayInCache = {read=FMaxDayInCache, write=setMaxDayInCache};
	__property System::UnicodeString address = {read=getAddress, write=setAddress};
	__property bool useExternControlIDLE = {read=getIdle, write=setIdle, nodefault};
	__property double SelectedArea = {read=FSelectedArea};
	__property bool CancelAnimationWhenRotation = {read=FCancelAnimationWhenRotation, write=FCancelAnimationWhenRotation, nodefault};
	__property Fmx::Uecmaputil::TLatLng Center = {read=GetCenter, write=_SetCenter};
	__property Fmx::Uecmaputil::TLatLng MouseLatLng = {read=FMouseLatLng};
	__property int MouseX = {read=FMouseX, nodefault};
	__property int MouseY = {read=FMouseY, nodefault};
	__property bool ShowCopyrightTile = {read=FShowCopyrightTile, write=FShowCopyrightTile, nodefault};
	__property Fmx::Uecmaputil::TColor CopyrightColor = {read=FCopyrightColor, write=setCopyrightColor, nodefault};
	__property int CopyrightSize = {read=FCopyrightSize, write=setCopyrightSize, nodefault};
	__property System::UnicodeString CopyrightTile = {read=getCopyrightTile, write=setCopyrightTile};
	__property bool DirectLoadLocalTile = {read=getDirectLoadLocalTile, write=setDirectLoadLocalTile, nodefault};
	__property TECRouting* Routing = {read=FRouting};
	__property bool DrawVectorTiles = {read=getDrawVectorTiles, write=setDrawVectorTiles, nodefault};
	__property Fmx::Uecmaputil::TColor EmptyTileColor = {read=FEmptyTileColor, write=FEmptyTileColor, nodefault};
	__property System::UnicodeString FilenameStartEditLine = {read=getFilenameStartEditLine, write=setFilenameStartEditLine};
	__property System::UnicodeString FilenameEndEditLine = {read=getFilenameEndEditLine, write=setFilenameEndEditLine};
	__property System::UnicodeString FilenamePointEditLine = {read=getFilenamePointEditLine, write=setFilenamePointEditLine};
	__property bool ReverseScrollingDirection = {read=GetReverseScrollingDirection, write=SetReverseScrollingDirection, nodefault};
	__property Fmx::Uecmapzip::TECMapZip* MapArchive = {read=FMapZip};
	__property System::UnicodeString LocalCache = {read=getLocalCache, write=setLocalCache};
	__property System::UnicodeString LocalArchive = {read=getLocalArchive, write=setLocalArchive};
	__property System::UnicodeString Locale = {read=getLocale, write=setLocale};
	__property Fmx::Uecnativeshape::TECGeofences* Geofences = {read=getGeofences};
	__property Fmx::Graphics::TBitmap* ScreenShot = {read=getBitmap};
	__property TECOffScreenScreenShot* ScreenShots = {read=getOffScreenScreenShot};
	__property bool ScreenCompleteBaseTile = {read=FScreenCompleteBaseTile, nodefault};
	__property int SpeedRotation = {read=FSpeedRotation, write=FSpeedRotation, nodefault};
	__property System::Byte MinZoom = {read=FMinZoom, write=setMinZoom, nodefault};
	__property System::Byte MaxZoom = {read=FMaxZoom, write=setMaxZoom, nodefault};
	__property bool DrawOverlayTilesWhenMoving = {read=FDrawOverlayTilesWhenMoving, write=FDrawOverlayTilesWhenMoving, nodefault};
	__property int MaxShapeShowOnMoveMap = {read=FMAX_SHAPE_SHOW_ON_MOVE_MAP, write=setMAX_SHAPE_SHOW_ON_MOVE_MAP, nodefault};
	__property int MaxTimeForDrawMoving = {read=FMaxTimeForDrawMoving, write=setMaxTimeForDrawMoving, nodefault};
	__property int MaxShapesForDirectCenter = {read=FMAX_SHAPE_FOR_DIRECT_CENTER, write=FMAX_SHAPE_FOR_DIRECT_CENTER, nodefault};
	__property bool InertiaScroll = {read=FInertiaScroll, write=FInertiaScroll, nodefault};
	__property __int64 InertiaThreshold = {read=FInertiaThreshold, write=FInertiaThreshold};
	__property System::LongInt MaxInertiaSpeed = {read=FMaxInertiaSpeed, write=FMaxInertiaSpeed, nodefault};
	__property bool PrechargingTiles = {read=FPrechargingTiles, write=FPrechargingTiles, nodefault};
	__property __int64 PrechargingTilesDelay = {read=FPrechargingDelay, write=FPrechargingDelay};
	__property System::Byte PrechargingTilesDepth = {read=FPrechargingTilesDepth, write=FPrechargingTilesDepth, nodefault};
	__property TShapeDragMode ShapeDragMode = {read=FShapeDragMode, write=FShapeDragMode, nodefault};
	__property System::UnicodeString OSMShortLink = {read=getOSMShortLink, write=setOSMShortLink};
	__property bool Dark = {read=FDarkMode, write=setDarkMode, nodefault};
	__property bool Light = {read=FLightMode, write=setLightMode, nodefault};
	__property System::Word TileCacheSize = {read=getCacheSize, write=SetCacheSize, default=512};
	__property Fmx::Uecnativetileserver::TTileServerInfo* TileServerInfo = {read=getTileServerInfo};
	__property int TileSize = {read=FTileSize, write=setTileSize, nodefault};
	__property int TilePPI = {read=FTilePPI, write=setTilePPI, nodefault};
	__property double TileServerOpacity = {read=getTileServerOpacity, write=setTileServerOpacity};
	__property __int64 MaximumTilesTimeout = {read=FMaximumTilesTimeout, write=FMaximumTilesTimeout};
	__property System::Uitypes::TMouseButton MouseButtonDragZoom = {read=FMouseButtonDragZoom, write=FMouseButtonDragZoom, nodefault};
	__property int MarginHint = {read=FMarginHint, write=setMarginHint, nodefault};
	__property System::UnicodeString DefaultHintProperty = {read=getDefaultHintProperty, write=setDefaultHintProperty};
	__property bool SuperZoom = {read=FSuperZoom, write=FSuperZoom, nodefault};
	__property bool UseInfoWindowDescription = {read=FUseInfoWindowDescription, write=FUseInfoWindowDescription, nodefault};
	__property Fmx::Uecnativeshape::TECShapeInfoWindow* InfowindowDescription = {read=getInfoWindowDescription};
	__property Fmx::Uecnativeshape::TECShapeLine* EditShadowLine = {read=getEditShadowLine};
	__property Fmx::Uecnativeshape::TECShape* EditShape = {read=getEditShape};
	__property Fmx::Uecnativeshape::TECShape* DragShape = {read=getDragShape, write=setDragShape};
	__property Fmx::Uecnativeshape::TECShape* ShapeBringToFront = {read=getShapeBringToFront, write=setShapeBringToFront};
	__property bool EditableAddPointByClickOnMap = {read=FEditableAddPointByClickOnMap, write=FEditableAddPointByClickOnMap, nodefault};
	__property bool ExitEditableClickLastPointLine = {read=getExitEditableClickLastPointLine, write=setExitEditableClickLastPointLine, nodefault};
	__property Fmx::Uecnativeshape::TECShape* MouseOverShape = {read=getMouseOverShape, write=setMouseOverShape};
	__property Fmx::Uecopenweather::TECOpenWeather* OpenWeather = {read=getOpenWeather};
	__property TECOpenWeatherTilesLayer* OpenWeatherTilesLayer = {read=getOpenWeatherTilesLayer};
	__property TECScaleBar* ScaleBar = {read=FScaleBar};
	__property double NorthEastLatitude = {read=getNorthEastLatitude};
	__property double NorthEastLongitude = {read=getNorthEastLongitude};
	__property double SouthWestLatitude = {read=getSouthWestLatitude};
	__property double SouthWestLongitude = {read=getSouthWestLongitude};
	__property Fmx::Uecnativeshape::TECShapes* Shapes = {read=getShapes};
	__property Fmx::Uecnativeshape::TECShapes* Group[const System::UnicodeString Value] = {read=getShapesGroup/*, default*/};
	__property Fmx::Uecnativeshape::TECShapes* Group[const int Value] = {read=getShapesGroup};
	__property Fmx::Uecnativeshape::TECGroupShapesList* Groups = {read=getShapesGroups};
	__property int Count = {read=getGroupCount, nodefault};
	__property TNativeMapControl* Views[int index] = {read=getView};
	__property int ViewCount = {read=getViewCount, nodefault};
	__property Fmx::Uecnativeshape::TECSelectedShapesList* Selected = {read=getSelected};
	__property Fmx::Uecnativeshape::TECShapeInfoWindow* HintInfoWindow = {read=getHintInfoWindow};
	__property Fmx::Uecmaputil::TECFilterColor* ColorFilter = {read=getBaseMapColorsFilter};
	__property float ScaleFactor = {read=getScaleFactor, write=setScaleFactor};
	__property TECWMSLayers* WMSLayers = {read=FECWMSLayers};
	__property TECWFSLayers* WFSLayers = {read=FECWFSLayers};
	__property Fmx::Imglist::TCustomImageList* Icons = {read=getIcons, write=setIcons};
	__property bool TouchZoom_NoPan = {read=FTouchZoom_NoPan, write=FTouchZoom_NoPan, nodefault};
	__property bool EnableTouchRotation = {read=FEnableTouchRotation, write=FEnableTouchRotation, nodefault};
	__property bool OverSizeForRotation = {read=FOverSizeForRotation, write=setOverSizeForRotation, nodefault};
	__property bool NoInfowindowRotation = {read=getNoInfowindowRotation, write=setNoInfowindowRotation, nodefault};
	__property bool UseExternControlEvents = {read=FuseExternControlEvents, write=SetuseExternControlEvents, nodefault};
	__property double ScaleGestureZoom = {read=FScaleGestureZoom, write=FScaleGestureZoom};
	__property bool HiRes = {read=FHiRes, write=setHiRes, nodefault};
	__property bool TrafficLayer = {read=FTraffic, write=settrafficLayer, nodefault};
	__property unsigned TimerSpeed = {read=getTimerSpeed, write=setTimerSpeed, nodefault};
	__property System::UnicodeString toKml = {read=getToKml, write=setToKml};
	__property System::UnicodeString toGpx = {read=getToGPX, write=setToGpx};
	__property Fmx::Uecmaputil::TToTxtType ToTxtType = {read=FToTxtType, write=setToTxtType, nodefault};
	__property System::UnicodeString toTxt = {read=getToTxt, write=setToTxt};
	__property System::UnicodeString toGeoJSon = {read=getToGeoJSon, write=setToGeoJSon};
	__property System::UnicodeString Url = {read=getUrl, write=setUrl};
	__property TECBubbleLayers* BubbleLayers = {read=FECBubbleLayers};
	__property TECChartLayers* ChartLayers = {read=FECChartLayers};
	__property TECNativeGeoHash* geohash = {read=FGeoHash};
	__property TECNativeFreeHand* FreeHand = {read=FFreeHand};
	__property TECDrawPath* DrawPath = {read=FDrawPath};
	__property TECTomTom* TomTom = {read=FTomTom};
	__property Fmx::Uecnativemeasuremap::TECNativeMeasureMap* MeasureTool = {read=FMeasureTool, write=FMeasureTool};
	__property TECGoogle* Google = {read=FGoogle};
	__property TECAirQuality* AirQuality = {read=FAirQuality};
	__property TECGraticule* Graticule = {read=FGraticule};
	__property TOLCNativeMap* OpenLocationCode = {read=FOpenLocationCode};
	__property bool SaveEncodedPolyline = {read=getSaveEncodedPolyline, write=setSaveEncodedPolyline, nodefault};
	__property bool SSL = {read=FSSL, write=setSSL, nodefault};
	__property System::UnicodeString USerAgent = {read=FUserAgent, write=setUserAgent};
	__property bool OnlyLocal = {read=FOnlyLocal, write=setOnlyLocal, nodefault};
	__property int MinLowZoom = {read=FMinLowZoom, write=FMinLowZoom, nodefault};
	__property bool UseLowZoom = {read=FUseLowZoom, write=FUseLowZoom, nodefault};
	__property bool NotMoveMapIfMouseReachesEdge = {read=FNotMoveMapIfMouseReachesEdge, write=FNotMoveMapIfMouseReachesEdge, nodefault};
	__property bool ScaleMarkerToZoom = {read=getScaleMarkerToZoom, write=setScaleMarkerToZoom, nodefault};
	__property bool DontScaleMarkerToZoomIfSelected = {read=getDontScaleMarkerToZoomIfSelected, write=setDontScaleMarkerToZoomIfSelected, nodefault};
	__property bool AntiFreezeOnLoad = {read=FAntiFreezeOnLoad, write=FAntiFreezeOnLoad, nodefault};
	__property TECMapComponents* Components = {read=FMapComponents};
	__property System::UnicodeString CloudMadKey = {read=getCloudMadeKey, write=setCloudMadeKey};
	__property System::UnicodeString BingKey = {read=getBingKey, write=setBingKey};
	__property System::UnicodeString MapQuestKey = {read=getMapQuestKey, write=setMapQuestKey};
	__property System::UnicodeString VectorMapZenKey = {read=getVectorMapZenKey, write=setVectorMapZenKey};
	__property System::UnicodeString MapBoxToken = {read=getMapBoxKey, write=setMapBoxKey};
	__property System::UnicodeString ThunderforestKey = {read=getOpenCycleMapKey, write=setOpenCycleMapKey};
	__property System::UnicodeString StadiaMapsKey = {read=getStadiaMapsKey, write=setStadiaMapsKey};
	__property System::UnicodeString TraceStrackKey = {read=getTraceStrackKey, write=setTraceStrackKey};
	__property System::UnicodeString DigitalGlobeToken = {read=getDigitalGlobeToken, write=setDigitalGlobeToken};
	__property System::UnicodeString IgnKey = {read=getIgnKey, write=setIgnKey};
	__property System::UnicodeString HereApiKey = {read=getHereID, write=setHereID};
	__property System::UnicodeString HereParam = {read=getHereParam, write=setHereParam};
	__property System::UnicodeString TomTomKey = {read=getTomTomKey, write=setTomTomKey};
	__property System::UnicodeString PTVKey = {read=getPTVKey, write=setPTVKey};
	__property System::UnicodeString AqicnKey = {read=getAqicnKey, write=setAqicnKey};
	__property Fmx::Uecgeolocalise::TECGeoLocalise* GeoLocalise = {read=FGeoLocalise};
	__property int WheelZoomScaleFactorIncrement = {read=FWheelZoomScaleFactorIncrement, write=FWheelZoomScaleFactorIncrement, nodefault};
	__property int RequestTiles = {read=FRequestTiles, nodefault};
	__property int DrawTiles = {read=FDrawTiles, nodefault};
	__property Fmx::Uecnativeshape::TECCartoStyles* Styles = {read=getCartoStyles};
	__property TECSnapDrag* SnapDrag = {read=getSnapDrag};
	__property TECBoundary* Boundary = {read=getBoundary};
	__property TECOverPass* OverPassApi = {read=getOverPass};
	__property Fmx::Uecnativeshape::TOnCreateJSONPoint OnCreateJSONPoint = {read=getOnCreateJSONPoint, write=setOnCreateJSONPoint};
	__property Fmx::Uecnativeshape::TOnGetScale OnGetScale = {read=getOnGetScale, write=setOnGetScale};
	__property TECXapiLayer* XapiLayer = {read=getXapiLayer};
	__property Fmx::Uecmaputil::TECWorldInfo* WorldInfo = {read=FWorldInfo};
	__property int WorldX = {read=FWorldX, nodefault};
	__property int WorldY = {read=FWorldY, nodefault};
	__property System::Types::TPoint WorldLeftTop = {read=getWorldLeftTop, write=setWorldLeftTop};
	__property int TileX = {read=FTileX, nodefault};
	__property int TileY = {read=FTileY, nodefault};
	__property System::UnicodeString WMS_Time = {read=getTimeTileServerWMS, write=setTimeTileServerWMS};
	__property unsigned TimeLongClick = {read=FTimeLongClick, write=FTimeLongClick, nodefault};
	__property __int64 TimeMouseStop = {read=FTimeForMouseStop, write=FTimeForMouseStop};
	__property bool BackgroundComplete = {read=FBackgroundComplete, nodefault};
	__property bool DirectPaintToForm = {read=FDIRECT_PAINT_TO_FORM, write=FDIRECT_PAINT_TO_FORM, nodefault};
	__property Fmx::Uecmaputil::TOnConversionESPG LatLngToESPG = {read=getConversionESPG, write=setConversionESPG};
	__property Fmx::Uecmaputil::TOnConversionESPG ESPGToLatLng = {read=getESPGToLatLng, write=setESPGToLatLng};
	__property System::Classes::TNotifyEvent OnChangeEditable = {read=getOnChangeEditable, write=setOnChangeEditable};
	
__published:
	__property bool FocusedShapeWhenClicking = {read=FFocusedShapeWhenClicking, write=FFocusedShapeWhenClicking, default=1};
	__property bool FocusedShapeWhenHovering = {read=FFocusedShapeWhenHovering, write=setFocusedShapeWhenHovering, default=0};
	__property bool HideShapesWhenZoom = {read=FHideShapesWhenZoom, write=FHideShapesWhenZoom, nodefault};
	__property bool HideShapesWhenWaitingTile = {read=FHideShapesWhenWaitingTile, write=FHideShapesWhenWaitingTile, nodefault};
	__property bool DblClickZoom = {read=FDblClickZoom, write=FDblClickZoom, nodefault};
	__property bool MouseWheelZoom = {read=FMouseWheelZoom, write=FMouseWheelZoom, nodefault};
	__property double latitude = {read=FLatitude, write=setLatitude};
	__property double longitude = {read=Flongitude, write=setLongitude};
	__property bool Reticle = {read=FReticle, write=FReticle, nodefault};
	__property Fmx::Uecmaputil::TColor ReticleColor = {read=FReticleColor, write=FReticleColor, nodefault};
	__property TOnReticlePaint OnReticlePaint = {read=FOnReticlePaint, write=FOnReticlePaint};
	__property System::Byte Zoom = {read=FZoom, write=SetZoom, default=14};
	__property TZoomScaleFactor ZoomScaleFactor = {read=FZoomScaleFactor, write=setZoomScaleFactor, nodefault};
	__property double NumericalZoom = {read=getNumericalZoom, write=setNumericalZoom};
	__property bool ZoomEffect = {read=FZoomEffect, write=FZoomEffect, default=1};
	__property int ZoomEffectDelay = {read=FZoomEffectDelay, write=FZoomEffectDelay, default=500};
	__property TDragRect DragRect = {read=FDragRect, write=FDragRect, nodefault};
	__property bool Draggable = {read=FDraggable, write=setDraggable, nodefault};
	__property bool FullZoomAfterGestureZoom = {read=FFullZoomAfterGestureZoom, write=FFullZoomAfterGestureZoom, nodefault};
	__property bool TwoOrMoreFingers = {read=FTwoOrMoreFingers, write=FTwoOrMoreFingers, nodefault};
	__property Fmx::Uecmaputil::TTileServer TileServer = {read=getTileServer, write=SetTileServer, default=4};
	__property bool OnlyOneOpenInfoWindow = {read=getOnlyOneOpenInfoWindow, write=setOnlyOneOpenInfoWindow, nodefault};
	__property bool WaitingForDestruction = {read=getWaitingForDestruction, write=setWaitingForDestruction, nodefault};
	__property bool Active = {read=getMapActive, write=setMapActive, nodefault};
	__property Fmx::Uecmaputil::TNbrThreadTile NbrThreadTile = {read=getNbrThreadTile, write=setNbrThreadTile, nodefault};
	__property System::Classes::TNotifyEvent OnChangeMapActive = {read=FOnChangeMapActive, write=FOnChangeMapActive};
	__property System::Classes::TNotifyEvent OnTilesTimeout = {read=FOnTilesTimeout, write=FOnTilesTimeout};
	__property System::Classes::TNotifyEvent OnChangeMapBounds = {read=FOnChangeMapBounds, write=FOnChangeMapBounds};
	__property System::Classes::TNotifyEvent OnChangeMapZoom = {read=FOnChangeMapZoom, write=FOnChangeMapZoom};
	__property System::Classes::TNotifyEvent OnCompleteTiles = {read=FOnCompleteTiles, write=FOnCompleteTiles};
	__property System::Classes::TNotifyEvent OnChangeTileServer = {read=FOnChangeTileServer, write=FOnChangeTileServer};
	__property System::Classes::TNotifyEvent OnMapFitBounds = {read=FOnMapFitBounds, write=FOnMapFitBounds};
	__property TOnMapSelectRect OnMapSelectChange = {read=FOnSelectChange, write=FOnSelectChange};
	__property TOnMapSelectRect OnMapSelectRect = {read=FOnSelectRect, write=FOnSelectRect};
	__property TOnMapLatLng OnEditMapClick = {read=FOnEditMapClick, write=FOnEditMapClick};
	__property TOnMapLatLng OnMapClick = {read=FOnMapClick, write=FOnMapClick};
	__property TOnMapLatLng OnMapLongClick = {read=FOnMapLongClick, write=FOnMapLongClick};
	__property TOnMapLatLng OnMapRightClick = {read=FOnMapRightClick, write=FOnMapRightClick};
	__property TOnMapLatLng OnMapMove = {read=FOnMapMove, write=FOnMapMove};
	__property TOnMapLatLng OnMapMouseMove = {read=FOnMapMouseMove, write=FOnMapMouseMove};
	__property TOnMapLatLng OnMapMouseStop = {read=FOnMapMouseStop, write=FOnMapMouseStop};
	__property TOnMapLatLng OnMapMouseUp = {read=FOnMapMouseUp, write=FOnMapMouseUp};
	__property TOnMapLatLng OnMapMouseDown = {read=FOnMapMouseDown, write=FOnMapMouseDown};
	__property TOnMapMouseWheel OnMapMouseWheel = {read=FOnMapMouseWheel, write=FOnMapMouseWheel};
	__property TOnMapLatLng OnMapDblClick = {read=FOnMapDblClick, write=FOnMapDblClick};
	__property System::Classes::TNotifyEvent OnMapDragStart = {read=FOnMapDragStart, write=FOnMapDragStart};
	__property System::Classes::TNotifyEvent OnMapDragEnd = {read=FOnMapDragEnd, write=FOnMapDragEnd};
	__property System::Classes::TNotifyEvent OnMapDrag = {read=FOnMapDrag, write=FOnMapDrag};
	__property TOnMapPaint OnMapPaint = {read=FOnMapPaint, write=FOnMapPaint};
	__property TOnMapPaint OnShapesPaint = {read=FOnShapesPaint, write=FOnShapesPaint};
	__property System::Classes::TNotifyEvent OnOutOfBounds = {read=FOnOutOfBounds, write=FOnOutOfBounds};
	__property Fmx::Uecnativeshape::TOnShapeMove OnShapeMove = {read=FOnShapeMove, write=FOnShapeMove};
	__property Fmx::Uecnativeshape::TOnShapeMove OnShapeDrag = {read=FOnShapeDrag, write=FOnShapeDrag};
	__property System::Classes::TNotifyEvent OnShapeDragEnd = {read=FOnShapeDragEnd, write=FOnShapeDragEnd};
	__property System::Classes::TNotifyEvent OnShapeFocus = {read=FOnShapeFocus, write=FOnShapeFocus};
	__property System::Classes::TNotifyEvent OnShapeOverIntent = {read=FOnShapeOverIntent, write=FOnShapeOverIntent};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnShapeMouseOver = {read=FOnShapeMouseOver, write=FOnShapeMouseOver};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnShapeMouseOut = {read=FOnshapeMouseOut, write=FOnshapeMouseOut};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnShapeMouseDown = {read=FOnShapeMouseDown, write=FOnShapeMouseDown};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnShapeMouseup = {read=FOnShapeMouseUp, write=FOnShapeMouseUp};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnShapeClick = {read=FOnShapeClick, write=FOnShapeClick};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnShapeLongClick = {read=FOnShapeLongClick, write=FOnShapeLongClick};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnShapeRightClick = {read=FOnShapeRightClick, write=FOnShapeRightClick};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnShapeDblClick = {read=FOnShapeDblClick, write=FOnShapeDblClick};
	__property System::Classes::TNotifyEvent OnShapePathChange = {read=FOnShapePathChange, write=setOnShapePathChange};
	__property System::Classes::TNotifyEvent OnCloseInfoWindow = {read=FOnCloseInfoWindow, write=setOnCloseInfoWindow};
	__property System::Classes::TNotifyEvent OnShapeAutoHide = {read=FOnShapeAutoHide, write=setOnShapeAutoHide};
	__property System::Classes::TNotifyEvent OnShapeAutoShow = {read=FOnShapeAutoShow, write=setOnShapeAutoShow};
	__property Fmx::Uecnativeshape::TOnRoutePath OnRoutePath = {read=FOnRoutePath, write=FOnRoutePath};
	__property TOnLoadGroup OnLoad = {read=FOnLoadGroup, write=FOnLoadGroup};
	__property Fmx::Uecnativeshape::TOnLoadShapes OnLoadShapes = {read=FOnLoadShapes, write=setOnLoadShapes};
	__property System::Classes::TNotifyEvent OnLongPress = {read=FOnLongPress, write=FOnLongPress};
	__property Fmx::Uecnativeshape::TOnAddShapeToView OnAddShapeToView = {read=FOnAddShapeToView, write=setOnAddShapeToView};
	__property TOnMapGeofence OnEnterGeofence = {read=FOnEnterGeofence, write=FOnEnterGeofence};
	__property TOnMapGeofence OnLeaveGeofence = {read=FOnLeaveGeofence, write=FOnLeaveGeofence};
	__property System::Classes::TNotifyEvent OnPanoramio = {read=FOnPanoramio};
	__property TOnPanoramioClick OnPanoramioClick = {read=FOnPanoramioClick, write=FOnPanoramioClick};
	__property TOnClusterClick OnClusterClick = {read=FOnClusterClick, write=FOnClusterClick};
	__property System::Classes::TNotifyEvent OnTraffic = {read=FOnTraffic, write=setOnTraffic};
	__property TOnBeforeUrl OnBeforeUrl = {read=FOnBeforeUrl, write=FOnBeforeUrl};
	__property System::Classes::TNotifyEvent OnErrorConnexion = {read=FOnErrorConnexion, write=FOnErrorConnexion};
	__property Align = {default=0};
	__property Cursor = {default=0};
	__property Enabled = {default=1};
	__property Height;
	__property Visible = {default=1};
	__property Width;
	__property Tag = {default=0};
	__property Anchors;
	__property TabOrder = {default=-1};
	__property TabStop = {default=1};
	__property OnKeyUp;
	__property OnKeyDown;
	__property CanFocus = {default=0};
	__property ClipChildren = {default=0};
	__property ClipParent = {default=0};
	__property DragMode = {default=0};
	__property EnableDragHighlight = {default=1};
	__property Locked = {default=0};
	__property HitTest = {default=1};
	__property Margins;
	__property Opacity;
	__property Padding;
	__property PopupMenu;
	__property position;
	__property RotationAngle = {default=0};
	__property RotationCenter;
	__property Scale;
	__property Size;
	__property TouchTargetExpansion;
	__property OnResize;
};


class PASCALIMPLEMENTATION TECNativeMap : public TNativeMapControl
{
	typedef TNativeMapControl inherited;
	
public:
	bool __fastcall ContainsLatLng(const double dLatitude, const double dLongitude);
	double __fastcall Altitude(const double dLatitude, const double dLongitude);
	System::UnicodeString __fastcall GetAddressFromLatLng(const double dLatitude, const double dLongitude);
	void __fastcall LatLngToUTM(const double latitude, const double longitude, double &UTMNorthing, double &UTMEasting, System::UnicodeString &UTMZone);
	void __fastcall UTMToLatLng(const double UTMNorthing, const double UTMEasting, const System::UnicodeString UTMZone, double &Lat, double &Lng);
	System::UnicodeString __fastcall LatLngToQTHLocator(const double Lat, const double Lng);
	void __fastcall QTHLocatorToLatlng(System::UnicodeString Locator, double &Lat, double &Lng);
	bool __fastcall GetLatLngFromAddress(const System::UnicodeString sAddress, double &dLatitude, double &dLongitude);
	bool __fastcall GetLatLngStructuredAddress(double &dLatitude, double &dLongitude, const System::UnicodeString sAddress)/* overload */;
	bool __fastcall GetLatLngStructuredAddress(double &dLatitude, double &dLongitude, const System::UnicodeString street, const System::UnicodeString city, const System::UnicodeString amenity = System::UnicodeString(), const System::UnicodeString county = System::UnicodeString(), const System::UnicodeString state = System::UnicodeString(), const System::UnicodeString country = System::UnicodeString(), const System::UnicodeString postalcode = System::UnicodeString())/* overload */;
	bool __fastcall StructuredAddress(const System::UnicodeString sAddress)/* overload */;
	bool __fastcall StructuredAddress(const System::UnicodeString street, const System::UnicodeString city, const System::UnicodeString amenity = System::UnicodeString(), const System::UnicodeString county = System::UnicodeString(), const System::UnicodeString state = System::UnicodeString(), const System::UnicodeString country = System::UnicodeString(), const System::UnicodeString postalcode = System::UnicodeString())/* overload */;
	void __fastcall LatLonFromDistanceBearing(double lat1, double lon1, double meters, double brng, double &lat2, double &lon2);
	void __fastcall boundingCoordinates(const double Lat, const double Lng, const double Radius, double &latSW, double &lngSW, double &latNE, double &lngNE);
	int __fastcall bearing(double lat1, double lng1, double lat2, double lng2);
	double __fastcall RoadDistance(const System::UnicodeString *AddressPoints, const System::NativeInt AddressPoints_High, const System::UnicodeString UrlEngine = L"https://routing.openstreetmap.de/routed-car/route/v1/driving/")/* overload */;
	double __fastcall RoadDistance(const double *LatLngPoints, const System::NativeInt LatLngPoints_High, const System::UnicodeString UrlEngine = L"https://routing.openstreetmap.de/routed-car/route/v1/driving/")/* overload */;
	double __fastcall RoadDistance(Fmx::Uecnativeshape::TECShape* const *Shapes, const System::NativeInt Shapes_High, const System::UnicodeString UrlEngine = L"https://routing.openstreetmap.de/routed-car/route/v1/driving/")/* overload */;
	double __fastcall DistanceFrom(const double dLatitudeStart, const double dLongitudeStart, const double dLatitudeEnd, const double dLongitudeEnd);
	double __fastcall VincentyInverseDistance(double lat1, double lon1, double lat2, double lon2);
	void __fastcall VincentyDirectDistance(double lat1, double lon1, double bearing, double Dist, double &lat2, double &lon2);
	int __fastcall PixelDistance(const double dLatitudeStart, const double dLongitudeStart, const double dLatitudeEnd, const double dLongitudeEnd)/* overload */;
	int __fastcall PixelDistance(Fmx::Uecnativeshape::TECShape* const shapeA, Fmx::Uecnativeshape::TECShape* const shapeB)/* overload */;
	int __fastcall MeterToPixel(const int meter, double Lat = -7.700000E+01)/* overload */;
	int __fastcall MeterToPixel(const double meter, double Lat = -7.700000E+01)/* overload */;
	double __fastcall PixelToMeter(const int Pixels, double Lat = -7.700000E+01)/* overload */;
	double __fastcall PixelToMeter(const double Pixels, double Lat = -7.700000E+01)/* overload */;
public:
	/* TNativeMapControl.Create */ inline __fastcall virtual TECNativeMap(System::Classes::TComponent* AOwner) : TNativeMapControl(AOwner) { }
	/* TNativeMapControl.Destroy */ inline __fastcall virtual ~TECNativeMap() { }
	
};


class PASCALIMPLEMENTATION TECXapiLayer : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::TObject* FXapiLayer;
	System::Classes::TNotifyEvent FOnStartSearch;
	Fmx::Uecnativeshape::TECShapes* FShapes;
	bool FJunction;
	void __fastcall setJunction(bool Value);
	TOnShape __fastcall getOnClick();
	void __fastcall setOnClick(TOnShape Value);
	System::Classes::TNotifyEvent __fastcall getOnChange();
	void __fastcall setOnChange(System::Classes::TNotifyEvent Value);
	System::UnicodeString __fastcall getSearch();
	void __fastcall setSearch(const System::UnicodeString Value);
	bool __fastcall getVisible();
	void __fastcall setVisible(const bool Value);
	int __fastcall getMaxItem();
	void __fastcall setMaxItem(const int Value);
	int __fastcall getDecimalPrecision();
	void __fastcall setDecimalPrecision(int Value);
	void __fastcall doOnStartSearch(System::TObject* sender);
	
public:
	__fastcall TECXapiLayer(TNativeMapControl* Map);
	__fastcall virtual ~TECXapiLayer();
	bool __fastcall Bound(double NELat, double NELng, double SWLat, double SWLng);
	bool __fastcall LoadFromFile(const System::UnicodeString Filename);
	void __fastcall OpenWindow(double Lat, double Lng, const System::UnicodeString Content, int Width = 0x140);
	void __fastcall CloseWindow();
	__property Fmx::Uecnativeshape::TECShapes* Shapes = {read=FShapes};
	__property System::UnicodeString Search = {read=getSearch, write=setSearch};
	__property bool Visible = {read=getVisible, write=setVisible, nodefault};
	__property int MaxItem = {read=getMaxItem, write=setMaxItem, nodefault};
	__property int DecimalPrecision = {read=getDecimalPrecision, write=setDecimalPrecision, nodefault};
	__property bool Junction = {read=FJunction, write=setJunction, nodefault};
	__property TOnShape OnClick = {read=getOnClick, write=setOnClick};
	__property System::Classes::TNotifyEvent OnChange = {read=getOnChange, write=setOnChange};
	__property System::Classes::TNotifyEvent OnStartSearch = {read=FOnStartSearch, write=FOnStartSearch};
};


typedef void __fastcall (__closure *TOnScreenShot)(const System::UnicodeString Name, Fmx::Graphics::TBitmap* const ScreenShot);

typedef void __fastcall (__closure *TOnBeforeScreenShot)(TNativeMapControl* const Map);

class PASCALIMPLEMENTATION TECOffScreenScreenShot : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TNativeMapControl* FMap;
	unsigned FTime;
	bool OkForNextScreenShoot;
	Fmx::Uecmaputil::TThreadStringList* FWaitList;
	System::Generics::Collections::TList__1<TNativeMapControl*>* FActiveOffScreenMaps;
	System::Generics::Collections::TList__1<TNativeMapControl*>* FOffScreenMaps;
	int FWidth;
	int FHeight;
	double FScaleFactor;
	bool FShowShapes;
	Fmx::Uecmaputil::TTileServer FTileServer;
	TOnBeforeScreenShot FOnBeforeScreenShot;
	TOnScreenShot FOnScreenShot;
	void __fastcall doTilesTimeout(System::TObject* sender);
	void __fastcall doScreenShot(System::TObject* sender);
	void __fastcall ProcessMessages();
	TNativeMapControl* __fastcall getOffScreenMap();
	void __fastcall setWidth(const int Value);
	void __fastcall setHeight(const int Value);
	int __fastcall getCount();
	
public:
	__fastcall TECOffScreenScreenShot(TNativeMapControl* const Map);
	__fastcall virtual ~TECOffScreenScreenShot();
	void __fastcall ScreenShot(const double latitude, const double longitude, const System::Byte Zoom, const System::UnicodeString Name = System::UnicodeString())/* overload */;
	void __fastcall ScreenShot(const double NELat, const double NELng, const double SWLat, const double SWLng, const System::UnicodeString Name = System::UnicodeString())/* overload */;
	void __fastcall ScreenShot(const double dLat, const double dLng, const double dRadiusKm, const System::UnicodeString Name = System::UnicodeString())/* overload */;
	void __fastcall cancel(const int Value)/* overload */;
	void __fastcall cancel(const System::UnicodeString Name)/* overload */;
	void __fastcall CancelAll();
	int __fastcall Progress(const int Value)/* overload */;
	int __fastcall Progress(const System::UnicodeString Name)/* overload */;
	__property int Count = {read=getCount, nodefault};
	__property int Width = {read=FWidth, write=setWidth, nodefault};
	__property int Height = {read=FHeight, write=setHeight, nodefault};
	__property Fmx::Uecmaputil::TTileServer TileServer = {read=FTileServer, write=FTileServer, nodefault};
	__property double ScaleFactor = {read=FScaleFactor, write=FScaleFactor};
	__property bool ShowShapes = {read=FShowShapes, write=FShowShapes, nodefault};
	__property TOnBeforeScreenShot OnBeforeScreenShot = {read=FOnBeforeScreenShot, write=FOnBeforeScreenShot};
	__property TOnScreenShot OnScreenShot = {read=FOnScreenShot, write=FOnScreenShot};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECIsoChrone : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FKey;
	System::UnicodeString FMaskUrl;
	System::UnicodeString FServerUrl;
	Fmx::Uechttp::TuecHttp* FHttp;
	TRoutingEngine FRoutingEngine;
	Fmx::Uecnativeshape::TECShapes* FGroup;
	System::UnicodeString __fastcall MakeUrl(const double Lat, const double Lng, Fmx::Uecnativeshape::TECShape* const *Shapes, const System::NativeInt Shapes_High, const System::UnicodeString contour, const double *DeltaContour, const System::NativeInt DeltaContour_High, Fmx::Uecmaputil::TMQRouteType routeType = (Fmx::Uecmaputil::TMQRouteType)(0x2));
	bool __fastcall LoadIsoChrone(const System::UnicodeString Url, Fmx::Uecnativeshape::TECShape* const *Shapes, const System::NativeInt Shapes_High);
	
public:
	__fastcall TECIsoChrone(TNativeMapControl* Map);
	__fastcall virtual ~TECIsoChrone();
	bool __fastcall Time(const double Lat, const double Lng, Fmx::Uecnativeshape::TECShape* const *Shapes, const System::NativeInt Shapes_High, const double *mnTime, const System::NativeInt mnTime_High, Fmx::Uecmaputil::TMQRouteType routeType = (Fmx::Uecmaputil::TMQRouteType)(0x2))/* overload */;
	bool __fastcall Distance(const double Lat, const double Lng, Fmx::Uecnativeshape::TECShape* const *Shapes, const System::NativeInt Shapes_High, const double *kmDistance, const System::NativeInt kmDistance_High, Fmx::Uecmaputil::TMQRouteType routeType = (Fmx::Uecmaputil::TMQRouteType)(0x2))/* overload */;
	bool __fastcall Time(const double Lat, const double Lng, Fmx::Uecnativeshape::TECShapeList* const ShapeList, const double *mnTime, const System::NativeInt mnTime_High, Fmx::Uecmaputil::TMQRouteType routeType = (Fmx::Uecmaputil::TMQRouteType)(0x2))/* overload */;
	bool __fastcall Distance(const double Lat, const double Lng, Fmx::Uecnativeshape::TECShapeList* const ShapeList, const double *kmDistance, const System::NativeInt kmDistance_High, Fmx::Uecmaputil::TMQRouteType routeType = (Fmx::Uecmaputil::TMQRouteType)(0x2))/* overload */;
	__property System::UnicodeString ServerURL = {read=FServerUrl, write=FServerUrl};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECRouting : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Fmx::Uechttp::TuecHttp* FHttp;
	TECIsoChrone* FIsoChrone;
	bool FAsynchronous;
	TRoutingEngine FRoutingEngine;
	TNativeMapControl* FMap;
	Fmx::Uecmaputil::TNativeMapObserver* FObserver;
	TECTurnByTurn* FTurnByTurn;
	TECItinerary* FECItinerary;
	System::TObject* FecNativeLineToRoute;
	System::UnicodeString FOSMR_MATCH_URL;
	Fmx::Uecnativeshape::TOnAddRoute FOnAddRoute;
	Fmx::Uecnativeshape::TOnChangeRoute FOnChangeRoute;
	Fmx::Uecnativeshape::TOnErrorRoute FOnErrorRoute;
	Fmx::Uecnativeshape::TOnDrawRoute FOnDrawRoute;
	System::UnicodeString FStartMarkerFilename;
	System::UnicodeString FEndMarkerFilename;
	int FRouteDrawingTime;
	Fmx::Uecmaputil::TMQRouteType FRouteType;
	System::UnicodeString FGroupName;
	Fmx::Uecmaputil::TColor FColor;
	int FWeight;
	bool FEditOnClick;
	void __fastcall setMap(TNativeMapControl* Value);
	void __fastcall setOptimizeRoute(const bool Value);
	bool __fastcall getOptimizeRoute();
	void __fastcall doNotifyRoute(System::TObject* sender);
	void __fastcall doNotifyChangeRoute(System::TObject* sender);
	void __fastcall doNotifyErrorRoute(System::TObject* sender);
	void __fastcall UpdateStartAndEnd(System::TObject* sender);
	void __fastcall doOnDrawAllRoute(System::TObject* sender);
	void __fastcall doCreateShapeLinePoint(System::TObject* sender, Fmx::Uecnativeshape::TECShapes* const Group, Fmx::Uecnativeshape::TECShape* &ShapeLinePoint, const double Lat, const double Lng, const int index);
	Fmx::Uecnativeshape::TECShapeLine* __fastcall getEditRoute();
	void __fastcall setEditRoute(Fmx::Uecnativeshape::TECShapeLine* Value);
	void __fastcall setRouteType(Fmx::Uecmaputil::TMQRouteType Value);
	void __fastcall setColor(Fmx::Uecmaputil::TColor Value);
	void __fastcall setWeight(int Value);
	void __fastcall UpdateColors(Fmx::Uecnativeshape::TECShapeLine* Line);
	void __fastcall doOnLineClick(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall setEngineUrl(Fmx::Uecgeolocalise::TECThreadRoutingUrl RoutingEngineUrl);
	Fmx::Uecgeolocalise::TECThreadRoutingUrl __fastcall getEngineUrl();
	void __fastcall setEngineValidUrl(Fmx::Uecgeolocalise::TECThreadRoutingUrl RoutingEngineUrl);
	Fmx::Uecgeolocalise::TECThreadRoutingUrl __fastcall getEngineValidUrl();
	void __fastcall setEngineExecute(Fmx::Uecgeolocalise::TECThreadRoutingExecute RoutingEngineExecute);
	Fmx::Uecgeolocalise::TECThreadRoutingExecute __fastcall getEngineExecute();
	void __fastcall setEngineDownload(Fmx::Uecgeolocalise::TECThreadRoutingDownload RoutingEngineDownload);
	Fmx::Uecgeolocalise::TECThreadRoutingDownload __fastcall getEngineDownload();
	void __fastcall setEngineName(const System::UnicodeString EngineName);
	System::UnicodeString __fastcall getEngineName();
	void __fastcall setEngineKey(const System::UnicodeString EngineKey);
	System::UnicodeString __fastcall getEngineKey();
	Fmx::Uecnativeshape::TECShapeLine* __fastcall getFutureRoute();
	
public:
	__fastcall TECRouting();
	__fastcall virtual ~TECRouting();
	bool __fastcall Match(const double *dLatLngs, const System::NativeInt dLatLngs_High, Fmx::Uecnativeshape::TECShapeLine* Line);
	__property bool Asynchronous = {read=FAsynchronous, write=FAsynchronous, nodefault};
	void __fastcall Engine(TRoutingEngine Value, const System::UnicodeString APiKey = System::UnicodeString());
	int __fastcall CountRequests();
	void __fastcall ClearPendingRequests();
	void __fastcall Request(const System::UnicodeString StartAdress, const System::UnicodeString EndAdress, const System::UnicodeString Params = System::UnicodeString(), Fmx::Uecnativeshape::TECShapeLine* Line = (Fmx::Uecnativeshape::TECShapeLine*)(0x0))/* overload */;
	void __fastcall Request(const double *dLatLngs, const System::NativeInt dLatLngs_High, const System::UnicodeString Params = System::UnicodeString(), Fmx::Uecnativeshape::TECShapeLine* Line = (Fmx::Uecnativeshape::TECShapeLine*)(0x0))/* overload */;
	__property Fmx::Uecgeolocalise::TECThreadRoutingUrl EngineUrl = {read=getEngineUrl, write=setEngineUrl};
	__property Fmx::Uecgeolocalise::TECThreadRoutingUrl EngineValidUrl = {read=getEngineValidUrl, write=setEngineValidUrl};
	__property Fmx::Uecgeolocalise::TECThreadRoutingExecute EngineExecute = {read=getEngineExecute, write=setEngineExecute};
	__property Fmx::Uecgeolocalise::TECThreadRoutingDownload EngineDownload = {read=getEngineDownload, write=setEngineDownload};
	__property System::UnicodeString EngineName = {read=getEngineName, write=setEngineName};
	__property System::UnicodeString EngineKey = {read=getEngineKey, write=setEngineKey};
	__property Fmx::Uecnativeshape::TECShapeLine* FutureRoute = {read=getFutureRoute};
	__property Fmx::Uecnativeshape::TECShapeLine* EditRoute = {read=getEditRoute, write=setEditRoute};
	__property bool EditOnClick = {read=FEditOnClick, write=FEditOnClick, nodefault};
	__property System::UnicodeString GroupName = {read=FGroupName, write=FGroupName};
	__property bool OptimizeRoute = {read=getOptimizeRoute, write=setOptimizeRoute, nodefault};
	__property TRoutingEngine RoutingEngine = {read=FRoutingEngine, nodefault};
	__property Fmx::Uecnativeshape::TOnAddRoute OnAddRoute = {read=FOnAddRoute, write=FOnAddRoute};
	__property Fmx::Uecnativeshape::TOnChangeRoute OnChangeRoute = {read=FOnChangeRoute, write=FOnChangeRoute};
	__property Fmx::Uecnativeshape::TOnErrorRoute OnErrorRoute = {read=FOnErrorRoute, write=FOnErrorRoute};
	__property Fmx::Uecnativeshape::TOnDrawRoute OnDrawRoute = {read=FOnDrawRoute, write=FOnDrawRoute};
	__property System::UnicodeString StartMarkerFilename = {read=FStartMarkerFilename, write=FStartMarkerFilename};
	__property System::UnicodeString EndMarkerFilename = {read=FEndMarkerFilename, write=FEndMarkerFilename};
	__property int RouteDrawingTime = {read=FRouteDrawingTime, write=FRouteDrawingTime, nodefault};
	__property Fmx::Uecmaputil::TMQRouteType routeType = {read=FRouteType, write=setRouteType, nodefault};
	__property Fmx::Uecmaputil::TColor Color = {read=FColor, write=setColor, nodefault};
	__property int Weight = {read=FWeight, write=setWeight, nodefault};
	__property TECTurnByTurn* TurnByTurn = {read=FTurnByTurn};
	__property TECItinerary* Itinerary = {read=FECItinerary};
	__property TECIsoChrone* IsoChrone = {read=FIsoChrone, write=FIsoChrone};
	__property System::UnicodeString OSMR_Match_Url = {read=FOSMR_MATCH_URL, write=FOSMR_MATCH_URL};
};


class PASCALIMPLEMENTATION TECItinerarySegment : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	int a;
	int b;
	Fmx::Uecmaputil::TLatLng FPointA;
	Fmx::Uecmaputil::TLatLng FPointB;
	double FKm;
	System::UnicodeString FInstruction;
	System::UnicodeString FManoeuver;
	
public:
	__property System::UnicodeString Instruction = {read=FInstruction};
	__property System::UnicodeString Manoeuver = {read=FManoeuver};
	__property double DistanceKM = {read=FKm};
	__property Fmx::Uecmaputil::TLatLng PointA = {read=FPointA};
	__property Fmx::Uecmaputil::TLatLng PointB = {read=FPointB};
public:
	/* TObject.Create */ inline __fastcall TECItinerarySegment() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TECItinerarySegment() { }
	
};


typedef void __fastcall (__closure *TOnSelectedItinerarySegment)(TECItinerary* sender);

class PASCALIMPLEMENTATION TECItinerary : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECItinerarySegment* operator[](const int index) { return this->Segment[index]; }
	
private:
	TECNativeMap* FMap;
	Fmx::Uecmaputil::TNativeMapObserver* FObserver;
	System::Classes::TNotifyEvent FOldOnDestroy;
	int FOldMinPointForUseDouglasPeucker;
	int FSegmentIndex;
	Fmx::Uecnativeshape::TECShapeLine* FSelected_route;
	Fmx::Uecnativeshape::TECShapeLine* FSelected_segment;
	System::Classes::TList* FSegments;
	System::Classes::TNotifyEvent FOnChangeRoute;
	TOnSelectedItinerarySegment FOnSelectedItinerarySegment;
	void __fastcall setMap(TECNativeMap* Value);
	TECItinerarySegment* __fastcall getSegment(const int index);
	int __fastcall getCount();
	void __fastcall setRoute(Fmx::Uecnativeshape::TECShapeLine* const Value);
	void __fastcall setSegmentIndex(const int Value);
	System::UnicodeString __fastcall getArrival();
	System::UnicodeString __fastcall getStart();
	void __fastcall doOnShapeClick(System::TObject* sender);
	void __fastcall doDestroy(System::TObject* sender);
	
public:
	__fastcall TECItinerary();
	__fastcall virtual ~TECItinerary();
	void __fastcall ShowInstruction(const int index);
	void __fastcall ShowSegment(const int index);
	__property int Count = {read=getCount, nodefault};
	__property Fmx::Uecnativeshape::TECShapeLine* Route = {read=FSelected_route, write=setRoute};
	__property Fmx::Uecnativeshape::TECShapeLine* SegmentRoute = {read=FSelected_segment};
	__property TECItinerarySegment* Segment[const int index] = {read=getSegment/*, default*/};
	__property int SegmentIndex = {read=FSegmentIndex, write=setSegmentIndex, nodefault};
	__property System::UnicodeString Arrival = {read=getArrival};
	__property System::UnicodeString Start = {read=getStart};
	__property TOnSelectedItinerarySegment OnSelectedItinerarySegment = {read=FOnSelectedItinerarySegment, write=FOnSelectedItinerarySegment};
	__property System::Classes::TNotifyEvent OnChangeRoute = {read=FOnChangeRoute, write=FOnChangeRoute};
};


typedef void __fastcall (__closure *TOnTurnByTurnInstruction)(TECTurnByTurn* sender, const System::UnicodeString Instruction, const double Distance);

typedef void __fastcall (__closure *TOnTurnByTurnAlert)(TECTurnByTurn* sender, const System::UnicodeString Instruction, const double Distance);

typedef void __fastcall (__closure *TOnTurnByTurnError)(TECTurnByTurn* sender, const double Lat, const double Lng, const int ErrorCounter);

class PASCALIMPLEMENTATION TECTurnByTurn : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Fmx::Uecnativeshape::TECShapeLine* FLine;
	Fmx::Uecmaputil::TLatLng FLastInstructionPos;
	Fmx::Uecmaputil::TLatLng FLastPos;
	System::UnicodeString FLastFlagInstruction;
	bool FFlagInstruction;
	int FFlagError;
	TOnTurnByTurnInstruction FOnInstruction;
	TOnTurnByTurnAlert FOnAlert;
	TOnTurnByTurnInstruction FOnAfterInstruction;
	System::Classes::TNotifyEvent FOnArrival;
	TOnTurnByTurnError FOnError;
	System::Classes::TNotifyEvent FOnConnectRoute;
	System::Classes::TNotifyEvent FOnDeconnectRoute;
	Fmx::Uecmaputil::TLatLng FNextInstructionPosition;
	System::UnicodeString FNextManeuver;
	System::UnicodeString FNextInstruction;
	double FNextInstructionInKm;
	int FErrorDistance;
	int FArrivalDistance;
	int FAlertDistance;
	int FExecutionDistance;
	void __fastcall setLine(Fmx::Uecnativeshape::TECShapeLine* const Value);
	
public:
	__fastcall TECTurnByTurn();
	bool __fastcall position(const double Lat, const double Lng);
	__property Fmx::Uecnativeshape::TECShapeLine* Line = {read=FLine, write=setLine};
	__property System::UnicodeString NextInstruction = {read=FNextInstruction};
	__property System::UnicodeString NextManeuver = {read=FNextManeuver};
	__property double NextInstructionInKm = {read=FNextInstructionInKm};
	__property Fmx::Uecmaputil::TLatLng NextInstructionPosition = {read=FNextInstructionPosition};
	__property int ArrivalDistance = {read=FArrivalDistance, write=FArrivalDistance, nodefault};
	__property int AlertDistance = {read=FAlertDistance, write=FAlertDistance, nodefault};
	__property int ExecutionDistance = {read=FExecutionDistance, write=FExecutionDistance, nodefault};
	__property int ErrorDistance = {read=FErrorDistance, write=FErrorDistance, nodefault};
	__property TOnTurnByTurnAlert OnAlert = {read=FOnAlert, write=FOnAlert};
	__property System::Classes::TNotifyEvent OnArrival = {read=FOnArrival, write=FOnArrival};
	__property TOnTurnByTurnError OnError = {read=FOnError, write=FOnError};
	__property TOnTurnByTurnInstruction OnInstruction = {read=FOnInstruction, write=FOnInstruction};
	__property TOnTurnByTurnInstruction OnAfterInstruction = {read=FOnAfterInstruction, write=FOnAfterInstruction};
	__property System::Classes::TNotifyEvent OnConnectRoute = {read=FOnConnectRoute, write=FOnConnectRoute};
	__property System::Classes::TNotifyEvent OnDeconnectRoute = {read=FOnDeconnectRoute, write=FOnDeconnectRoute};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECTurnByTurn() { }
	
};


enum DECLSPEC_DENUM TAirQualityIndex : unsigned char { usepa_aqi, usepa_pm25, usepa_10, usepa_o3, usepa_no2, usepa_so2, usepa_co, asean_pm10 };

enum DECLSPEC_DENUM TAirQualityLevel : unsigned char { aqlGood, aqlModerate, aqlUnhealthySensitive, aqlUnhealthy, aqlVeryUnhealthy, aqlHazardous };

typedef System::StaticArray<System::Uitypes::TAlphaColor, 6> TAirQualityPalette;

struct DECLSPEC_DRECORD TAirQualityItem
{
public:
	System::UnicodeString Name;
	double Value;
};


typedef System::DynamicArray<TAirQualityItem> TAirQualityPollutants;

typedef System::DynamicArray<TAirQualityItem> TAirQualityWeather;

struct DECLSPEC_DRECORD TAirQualityCity
{
public:
	bool Ok;
	System::UnicodeString Query;
	System::UnicodeString JSON;
	System::UnicodeString Name;
	double latitude;
	double longitude;
	TAirQualityItem DominantPollutant;
	TAirQualityPollutants Pollutants;
	TAirQualityWeather Weather;
	System::UnicodeString IsoTime;
	System::TDateTime Time;
	TAirQualityLevel level;
	System::Uitypes::TAlphaColor LevelColor;
};


typedef void __fastcall (__closure *TAirQualityOnJson)(System::TObject* sender, const System::UnicodeString Query, const System::UnicodeString JSON);

typedef void __fastcall (__closure *TAirQualityEvent)(const TAirQualityCity &sender);

#pragma pack(push,4)
class PASCALIMPLEMENTATION TAirQualityData : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::UnicodeString Query;
	System::UnicodeString response;
	bool Map;
	bool station;
	bool hover;
	bool city;
public:
	/* TObject.Create */ inline __fastcall TAirQualityData() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TAirQualityData() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECAirQuality : public System::TObject
{
	typedef System::TObject inherited;
	
	
private:
	typedef System::StaticArray<System::UnicodeString, 6> _TECAirQuality__1;
	
	
private:
	_TECAirQuality__1 FLegends;
	TECOverlayTileLayer* FOverlay;
	TAirQualityIndex FAirQualityIndex;
	TNativeMapControl* FMap;
	System::UnicodeString _CACHE_;
	Fmx::Uecnativeshape::TECShapes* FShapes;
	Fmx::Uechttp::TuecHttp* FHttp;
	System::Classes::TStringList* FSList;
	bool FShowLayer;
	int FStationSize;
	System::UnicodeString FUrlFeedGeo;
	System::UnicodeString FUrlMapBounds;
	TAirQualityCity FCity;
	TAirQualityPalette FPalette;
	TAirQualityOnJson FOnJson;
	TAirQualityEvent FOnClick;
	TAirQualityEvent FOnHover;
	System::Classes::TNotifyEvent FOnRequest;
	double FNELat;
	double FNELng;
	double FSWLat;
	double FSWLng;
	bool FFirstActivate;
	Fmx::Uecmaputil::TNativeMapObserver* FObserver;
	void __fastcall setKey(const System::UnicodeString Value);
	System::UnicodeString __fastcall getKey();
	void __fastcall setShowLayer(const bool Value);
	void __fastcall setLayerIndex(const TAirQualityIndex Value);
	void __fastcall doJson(System::TObject* sender);
	void __fastcall doMapEndMove(System::TObject* sender);
	void __fastcall doHoverStation(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall doClickStation(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall ActiveObserver(const bool Active);
	void __fastcall getJSONMap(const double Lat, const double Lng, const double lat2, const double lng2);
	void __fastcall getJSONStation(const double Lat, const double Lng, const bool hover);
	void __fastcall JsonToAQCity(const System::UnicodeString JSON, TAirQualityCity &rCity);
	System::UnicodeString __fastcall getLegend(const TAirQualityLevel index);
	
public:
	__fastcall TECAirQuality(TNativeMapControl* Map);
	__fastcall virtual ~TECAirQuality();
	void __fastcall getJSON(const double Lat, const double Lng)/* overload */;
	void __fastcall getJSON(const System::UnicodeString city)/* overload */;
	void __fastcall getJSON(const double Lat, const double Lng, const double lat2, const double lng2)/* overload */;
	TAirQualityCity __fastcall JsonToAirQualityCity(const System::UnicodeString JSON);
	__property System::UnicodeString Legend[const TAirQualityLevel index] = {read=getLegend};
	__property System::UnicodeString key = {read=getKey, write=setKey};
	__property bool Visible = {read=FShowLayer, write=setShowLayer, nodefault};
	__property TAirQualityIndex AirQualityIndex = {read=FAirQualityIndex, write=setLayerIndex, nodefault};
	__property TAirQualityCity city = {read=FCity};
	__property int StationSize = {read=FStationSize, write=FStationSize, nodefault};
	__property TAirQualityOnJson OnJson = {read=FOnJson, write=FOnJson};
	__property TAirQualityEvent OnClick = {read=FOnClick, write=FOnClick};
	__property TAirQualityEvent OnHover = {read=FOnHover, write=FOnHover};
	__property System::Classes::TNotifyEvent OnRequest = {read=FOnRequest, write=FOnRequest};
};


class PASCALIMPLEMENTATION TECBBoxData : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	double NELat;
	double NELng;
	double SWLat;
	double SWLng;
	__int64 Age;
	System::UnicodeString Query;
	System::UnicodeString Data;
public:
	/* TObject.Create */ inline __fastcall TECBBoxData() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TECBBoxData() { }
	
};


class PASCALIMPLEMENTATION TECBBoxDataCacheList : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECBBoxData* operator[](int index) { return this->Data[index]; }
	
private:
	System::Classes::TList* FList;
	__int64 FCacheTime;
	TECBBoxData* __fastcall getData(int index);
	
public:
	__fastcall TECBBoxDataCacheList();
	__fastcall virtual ~TECBBoxDataCacheList();
	System::UnicodeString __fastcall Get(const double NELat, const double NELng, const double SWLat, const double SWLng, const System::UnicodeString Query = System::UnicodeString());
	void __fastcall Add(const double NELat, const double NELng, const double SWLat, const double SWLng, const System::UnicodeString Data, const System::UnicodeString Query = System::UnicodeString());
	int __fastcall Count();
	void __fastcall Clear();
	__property __int64 CacheTime = {read=FCacheTime, write=FCacheTime};
	__property TECBBoxData* Data[int index] = {read=getData/*, default*/};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECGoogle : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TNativeMapControl* FMap;
	System::UnicodeString FKey;
	System::UnicodeString FStyles;
	Fmx::Uecmaputil::TecGoogleStreetViewBitmap* FGoogleStreetViewBitmap;
	void __fastcall setKey(const System::UnicodeString Value);
	void __fastcall setLang(const System::UnicodeString Value);
	void __fastcall setStyles(const System::UnicodeString Value);
	void __fastcall setRegion(const System::UnicodeString Value);
	System::UnicodeString __fastcall getLang();
	System::UnicodeString __fastcall getRegion();
	
public:
	__fastcall TECGoogle(TNativeMapControl* Map);
	__fastcall virtual ~TECGoogle();
	__property System::UnicodeString APiKey = {read=FKey, write=setKey};
	__property System::UnicodeString Styles = {read=FStyles, write=setStyles};
	__property System::UnicodeString Lang = {read=getLang, write=setLang};
	__property System::UnicodeString Region = {read=getRegion, write=setRegion};
	__property Fmx::Uecmaputil::TecGoogleStreetViewBitmap* StreetView = {read=FGoogleStreetViewBitmap};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECTomTomIncidentData : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	double NELat;
	double NELng;
	double SWLat;
	double SWLng;
	__int64 Age;
	System::UnicodeString Data;
public:
	/* TObject.Create */ inline __fastcall TECTomTomIncidentData() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TECTomTomIncidentData() { }
	
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECTomTom : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TECTomTomIncident* FTomTomIncident;
	System::UnicodeString FKey;
	System::UnicodeString FLanguage;
	TNativeMapControl* FMap;
	System::UnicodeString _CACHE_;
	
public:
	__fastcall TECTomTom(TNativeMapControl* Map);
	__fastcall virtual ~TECTomTom();
	bool __fastcall Search(System::UnicodeString Data, double &Lat, double &Lng);
	__property TECTomTomIncident* Incident = {read=FTomTomIncident};
	__property System::UnicodeString key = {read=FKey, write=FKey};
	__property System::UnicodeString Language = {read=FLanguage, write=FLanguage};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECTomTomIncident : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TNativeMapControl* FMap;
	Fmx::Types::TTimer* FTimer;
	System::UnicodeString FGroupName;
	System::UnicodeString FStyle;
	bool FFirstActivate;
	double _FNELat;
	double _FNELng;
	double _FSWLat;
	double _FSWLng;
	double FNELat;
	double FNELng;
	double FSWLat;
	double FSWLng;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnClick;
	Fmx::Uecnativeshape::TECShapes* FIncidentGroup;
	System::Classes::TList* FIncidentCacheList;
	__int64 FIncidentCacheTime;
	Fmx::Uecmaputil::TNativeMapObserver* FObserver;
	Fmx::Uecnativeshape::TECShapeInfoWindow* FIncidentWindow;
	Fmx::Uecnativeshape::TInfoWindowStyle FIncidentStyle;
	Fmx::Uecmaputil::TColor FIncidentBorderColor;
	Fmx::Uecmaputil::TColor FIncidentFontColor;
	System::Classes::TStringList* FCategoryLabel;
	System::UnicodeString FTextDelay;
	System::UnicodeString FTextLength;
	System::UnicodeString FTextFrom;
	System::UnicodeString FTextTo;
	int FBreak;
	int FTab;
	int FWidth;
	int FYanchor;
	bool FShowInfoWindow;
	bool FinLoad;
	TECTomTomIncidentData* __fastcall getIncidentFromCache(const double NELat, const double NELng, const double SWLat, const double SWLng);
	void __fastcall doOnLoad(System::TObject* sender);
	void __fastcall doMapEndMove(System::TObject* sender);
	void __fastcall doMouseOver(System::TObject* sender);
	void __fastcall doMouseOut(System::TObject* sender);
	void __fastcall doMouseUp(System::TObject* sender);
	void __fastcall doOnClick(System::TObject* sender);
	void __fastcall ActiveObserver(const bool Active);
	bool __fastcall getIncidentLayer();
	void __fastcall setIncidentLayer(const bool Value);
	void __fastcall setIncidentStyle(const Fmx::Uecnativeshape::TInfoWindowStyle Value);
	void __fastcall setIncidentColor(const Fmx::Uecmaputil::TColor Value);
	void __fastcall setIncidentBorderColor(const Fmx::Uecmaputil::TColor Value);
	void __fastcall LoadIncident();
	void __fastcall LoadDataIncident(TECTomTomIncidentData* const Data);
	void __fastcall doOnCallTomTom(System::TObject* sender);
	void __fastcall doOnLoadData(System::TObject* sender);
	void __fastcall setIncidentCacheTime(const __int64 Value);
	void __fastcall doOnTimer(System::TObject* sender);
	void __fastcall setStyle(const System::UnicodeString Value);
	
public:
	__fastcall TECTomTomIncident(TNativeMapControl* Map);
	__fastcall virtual ~TECTomTomIncident();
	__property System::Classes::TStringList* CategoryLabel = {read=FCategoryLabel};
	__property Fmx::Uecnativeshape::TECShapes* Group = {read=FIncidentGroup};
	__property System::UnicodeString GroupName = {read=FGroupName};
	__property __int64 CacheTime = {read=FIncidentCacheTime, write=setIncidentCacheTime};
	__property bool Layer = {read=getIncidentLayer, write=setIncidentLayer, nodefault};
	__property Fmx::Uecnativeshape::TInfoWindowStyle InfoStyle = {read=FIncidentStyle, write=setIncidentStyle, nodefault};
	__property Fmx::Uecmaputil::TColor FontColor = {read=FIncidentFontColor, write=setIncidentColor, nodefault};
	__property Fmx::Uecmaputil::TColor BorderColor = {read=FIncidentBorderColor, write=setIncidentBorderColor, nodefault};
	__property int Break = {read=FBreak, write=FBreak, nodefault};
	__property System::UnicodeString Style = {read=FStyle, write=setStyle};
	__property bool ShowInfoWindow = {read=FShowInfoWindow, write=FShowInfoWindow, nodefault};
	__property int Tab = {read=FTab, write=FTab, nodefault};
	__property System::UnicodeString TextDelay = {read=FTextDelay, write=FTextDelay};
	__property System::UnicodeString TextLength = {read=FTextLength, write=FTextLength};
	__property System::UnicodeString TextFrom = {read=FTextFrom, write=FTextFrom};
	__property System::UnicodeString TextTo = {read=FTextTo, write=FTextTo};
	__property int Width = {read=FWidth, write=FWidth, nodefault};
	__property int YAnchor = {read=FYanchor, write=FYanchor, nodefault};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnClick = {read=FOnClick, write=FOnClick};
};


enum DECLSPEC_DENUM TPTVBaseMapLayer : unsigned char { none, amber, blackmarble, classic, gravelpit, sandbox, silica, silkysand, satellite };

enum DECLSPEC_DENUM TPTVvehicleType : unsigned char { car, Truck };

enum DECLSPEC_DENUM TPTVForegroundLayer : unsigned char { background, transport, labels, trafficIncidents, trafficPatterns, restrictions, toll };

typedef System::Set<TPTVForegroundLayer, TPTVForegroundLayer::background, TPTVForegroundLayer::toll> TPTVForegroundLayers;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECPTV : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TNativeMapControl* FMap;
	TECOverlayTileLayer* FOverlayTileLayer;
	System::UnicodeString FLayers;
	System::UnicodeString FOverlays;
	System::UnicodeString FStyle;
	System::UnicodeString FVehicule;
	System::UnicodeString FPTV_COPYRIGHT;
	TPTVBaseMapLayer FBaseMapLayer;
	TPTVForegroundLayers FForegroundLayers;
	TPTVForegroundLayers FOverlayLayers;
	TPTVvehicleType FVehicleType;
	Fmx::Uecmaputil::TTileServer FMapTileServer;
	void __fastcall get_PTV_TileMap(System::UnicodeString &TileFilename, const int X, const int Y, const int Z);
	void __fastcall get_PTV_SatelliteTileMap(System::UnicodeString &TileFilename, const int X, const int Y, const int Z);
	void __fastcall get_PTV_OverlayTileMap(System::UnicodeString &TileFilename, const int X, const int Y, const int Z);
	void __fastcall setVehicleType(TPTVvehicleType Value);
	System::UnicodeString __fastcall getApiKey();
	void __fastcall setApiKey(const System::UnicodeString Value);
	void __fastcall setBaseMapLayer(TPTVBaseMapLayer Value);
	void __fastcall setForegroundLayers(TPTVForegroundLayers Value);
	void __fastcall setOverlayLayers(TPTVForegroundLayers Value);
	
public:
	__fastcall TECPTV(TNativeMapControl* const Map);
	__fastcall virtual ~TECPTV();
	__property System::UnicodeString APiKey = {read=getApiKey, write=setApiKey};
	__property TPTVBaseMapLayer BaseMapLayer = {read=FBaseMapLayer, write=setBaseMapLayer, nodefault};
	__property TPTVForegroundLayers ForegroundLayers = {read=FForegroundLayers, write=setForegroundLayers, nodefault};
	__property TPTVForegroundLayers OverlayLayers = {read=FOverlayLayers, write=setOverlayLayers, nodefault};
	__property System::UnicodeString PTV_COPYRIGHT = {read=FPTV_COPYRIGHT, write=FPTV_COPYRIGHT};
	__property TPTVvehicleType VehicleType = {read=FVehicleType, write=setVehicleType, nodefault};
};

#pragma pack(pop)

enum DECLSPEC_DENUM TECAreaType : unsigned char { atRectangle, atCircle };

typedef void __fastcall (__closure *TOnUpdateMetric)(TECSelectArea* const sender, System::UnicodeString &Value);

class PASCALIMPLEMENTATION TECSelectArea : public System::TObject
{
	typedef System::TObject inherited;
	
	
private:
	typedef System::DynamicArray<Fmx::Uecnativeshape::TECShapePOI*> _TECSelectArea__1;
	
	
private:
	TNativeMapControl* FMap;
	Fmx::Uecnativeshape::TECShapes* FShapes;
	Fmx::Uecnativeshape::TECShape* FArea;
	System::Classes::TNotifyEvent FOnClick;
	System::Classes::TNotifyEvent FOnDblClick;
	System::Classes::TNotifyEvent FOnLongPress;
	System::Classes::TNotifyEvent FOnRightClick;
	System::Classes::TNotifyEvent FOnChange;
	TOnUpdateMetric FOnUpdateMetric;
	Fmx::Uecmaputil::TColor FColor;
	bool FShowMetric;
	bool FAreaMove;
	TECAreaType FAreaType;
	_TECSelectArea__1 FArrayEditPOI;
	double FAreaKM;
	double FWidthKM;
	double FHeightKM;
	double FNELat;
	double FNELng;
	double FSWLat;
	double FSWLng;
	Fmx::Uecmaputil::TLatLng FCenter;
	void __fastcall setColor(const Fmx::Uecmaputil::TColor Value);
	bool __fastcall getVisible();
	void __fastcall setVisible(const bool Value);
	void __fastcall setShowMetric(const bool Value);
	void __fastcall setAreatType(const TECAreaType Value);
	void __fastcall doUpdateMetrics();
	void __fastcall doOnChange(System::TObject* sender);
	void __fastcall doAreaFree(System::TObject* sender);
	void __fastcall doAreaMove(System::TObject* sender);
	void __fastcall doAreaDrag(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item, bool &cancel);
	void __fastcall doAreaClick(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall doAreaDblClick(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall doAreaRightClick(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall doAreaLongPress(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall doShapeDrag(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item, bool &cancel);
	void __fastcall doShapeEndDrag(System::TObject* sender);
	void __fastcall addEditPOI(const double Lat, const double Lng, const int Tag);
	void __fastcall ClearEditPOI();
	void __fastcall InitArea();
	
public:
	__fastcall TECSelectArea(TNativeMapControl* const Map);
	__fastcall virtual ~TECSelectArea();
	void __fastcall setPosition(const double Lat, const double Lng);
	void __fastcall Boundary(const double dNELat, const double dNELng, const double dSWLat, const double dSWLng);
	void __fastcall fitBounds();
	__property TECAreaType AreaType = {read=FAreaType, write=setAreatType, nodefault};
	__property double Area = {read=FAreaKM};
	__property double Width = {read=FWidthKM};
	__property double Height = {read=FHeightKM};
	__property Fmx::Uecmaputil::TLatLng Center = {read=FCenter};
	__property Fmx::Uecmaputil::TColor Color = {read=FColor, write=setColor, nodefault};
	__property Fmx::Uecnativeshape::TECShapes* Group = {read=FShapes};
	__property double NELat = {read=FNELat};
	__property double NELng = {read=FNELng};
	__property double SWLat = {read=FSWLat};
	__property double SWLng = {read=FSWLng};
	__property bool Visible = {read=getVisible, write=setVisible, nodefault};
	__property bool ShowMetrics = {read=FShowMetric, write=setShowMetric, nodefault};
	__property System::Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
	__property System::Classes::TNotifyEvent OnClick = {read=FOnClick, write=FOnClick};
	__property System::Classes::TNotifyEvent OnDblClick = {read=FOnDblClick, write=FOnDblClick};
	__property System::Classes::TNotifyEvent OnLongPress = {read=FOnLongPress, write=FOnLongPress};
	__property System::Classes::TNotifyEvent OnRightClick = {read=FOnRightClick, write=FOnRightClick};
	__property TOnUpdateMetric OnUpdateMetric = {read=FOnUpdateMetric, write=FOnUpdateMetric};
};


enum DECLSPEC_DENUM TECGridType : unsigned char { gtTable, gtPolygon };

enum DECLSPEC_DENUM TECHeaderLabelPosition : unsigned char { hlpTop, hlpBottom, hlpLeft, hlpRight };

typedef System::DynamicArray<Fmx::Uecnativeshape::TECShapePolygone*> Fmx_Uecnativemapcontrol__14;

typedef System::DynamicArray<System::DynamicArray<Fmx::Uecnativeshape::TECShapePolygone*> > TECGridCells;

typedef void __fastcall (__closure *TOnEditChange)(TECGrid* const Grid);

typedef void __fastcall (__closure *TOnHeaderLabel)(const int index, System::UnicodeString &Value);

typedef void __fastcall (__closure *TOnHeaderClick)(TECGrid* const Grid, const System::UnicodeString Text, const int index, const TECHeaderLabelPosition position);

typedef void __fastcall (__closure *TOnCellEvent)(TECGrid* const Grid, Fmx::Uecnativeshape::TECShapePolygone* const Cell);

class PASCALIMPLEMENTATION TECGrid : public System::TObject
{
	typedef System::TObject inherited;
	
	
private:
	typedef System::DynamicArray<Fmx::Uecnativeshape::TECShapePOI*> _TECGrid__1;
	
	
private:
	TNativeMapControl* FMap;
	TECGridCells FCells;
	int FCol;
	int FRow;
	Fmx::Uecmaputil::TColor FHeaderFontColor;
	Fmx::Graphics::TFont* FHeaderFont;
	bool FIgnoreCellCentroidOutsidePolygon;
	Fmx::Uecmaputil::TColor FHoverColor;
	Fmx::Uecmaputil::TColor FCellColor;
	System::Byte FCellWeight;
	_TECGrid__1 FArrayEditPOI;
	System::Byte fopacity;
	bool FShowHeaderLabel;
	TOnHeaderLabel FOnHeaderColLabel;
	TOnHeaderLabel FOnHeaderRowLabel;
	TOnHeaderClick FOnHeaderClick;
	TOnEditChange FOnEditChange;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnEditHandleClick;
	TOnCellEvent FOnCellLongPress;
	TOnCellEvent FOnCellRightClick;
	TOnCellEvent FOnCellClick;
	TOnCellEvent FOnCellDblClick;
	Fmx::Uecnativeshape::TECShapes* FShapes;
	double FNELat;
	double FNELng;
	double FSWLat;
	double FSWLng;
	TECGridType FGridType;
	int FZIndex;
	int FCellSizeMeter;
	bool FEditable;
	Fmx::Uecnativeshape::TECShapePolygone* FFocusBorder;
	Fmx::Uecnativeshape::TECShapePolygone* FEditBorder;
	void __fastcall Reset();
	void __fastcall BuildGridTable();
	void __fastcall BuildGridPolygon(Fmx::Uecnativeshape::TECShapePolygone* const P);
	void __fastcall setCellSizeMeter(const int Value);
	int __fastcall getCellSizeMeter();
	void __fastcall setCellWeight(const System::Byte Value);
	void __fastcall setHoverColor(const Fmx::Uecmaputil::TColor Value);
	void __fastcall doEditBordeMove(System::TObject* sender);
	void __fastcall doShapeDrag(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item, bool &cancel);
	void __fastcall doShapeEndDrag(System::TObject* sender);
	void __fastcall doEditHandleClick(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall doEditClick(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall doEditDblClick(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall doEditRightClick(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall doEditLongPress(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall addEditPOI(const double Lat, const double Lng, const int Tag, const int col, const int row);
	void __fastcall ClearEditPOI();
	void __fastcall setEditable(const bool Value);
	void __fastcall setShowHeaderLabel(const bool Value);
	void __fastcall setZindex(const int Value);
	Fmx::Uecnativeshape::TECShapePolygone* __fastcall getCell(int ColIndex, int RowIndex);
	void __fastcall doCellMouseDown(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall doCellClick(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall doCellDblClick(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall doCellRightClick(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	void __fastcall doCellLongPress(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	Fmx::Uecnativeshape::TECShapePOI* __fastcall addHeaderLabel(const double Lat, const double Lng);
	void __fastcall doHeaderLabelClick(System::TObject* sender, Fmx::Uecnativeshape::TECShape* const Item);
	System::UnicodeString __fastcall getHeaderLabelCol(const int index);
	System::UnicodeString __fastcall getHeaderLabelRow(const int index);
	System::UnicodeString __fastcall getToTxt();
	void __fastcall setToTxt(const System::UnicodeString Value);
	System::UnicodeString __fastcall getName();
	void __fastcall setOpacity(const System::Byte Value);
	
public:
	__fastcall TECGrid(TNativeMapControl* const Map, const System::UnicodeString Name);
	__fastcall virtual ~TECGrid();
	void __fastcall Clear();
	void __fastcall setPosition(const double Lat, const double Lng);
	void __fastcall Update();
	__property Fmx::Uecnativeshape::TECShapes* Group = {read=FShapes};
	void __fastcall Boundary(const double dNELat, const double dNELng, const double dSWLat, const double dSWLng);
	void __fastcall setSize(const int icol, const int irow);
	void __fastcall fitBounds();
	void __fastcall PolygonToGrid(Fmx::Uecnativeshape::TECShapePolygone* const P, const int aCellSizeMeter);
	Fmx::Uecnativeshape::TECShapePolygone* __fastcall getCellAt(const double Lat, const double Lng);
	__property System::UnicodeString Name = {read=getName};
	__property TECGridType GridType = {read=FGridType, nodefault};
	__property int CellSizeMeter = {read=getCellSizeMeter, write=setCellSizeMeter, nodefault};
	__property Fmx::Uecmaputil::TColor CellColor = {read=FCellColor, write=FCellColor, nodefault};
	__property Fmx::Uecmaputil::TColor HoverColor = {read=FHoverColor, write=setHoverColor, nodefault};
	__property System::Byte CellWeight = {read=FCellWeight, write=setCellWeight, nodefault};
	__property Fmx::Uecnativeshape::TECShapePolygone* Cells[int ColIndex][int RowIndex] = {read=getCell/*, default*/};
	__property int col = {read=FCol, nodefault};
	__property bool Editable = {read=FEditable, write=setEditable, nodefault};
	__property Fmx::Graphics::TFont* HeaderFont = {read=FHeaderFont};
	__property Fmx::Uecmaputil::TColor HeaderFontColor = {read=FHeaderFontColor, write=FHeaderFontColor, nodefault};
	__property bool IgnoreCellCentroidOutsidePolygon = {read=FIgnoreCellCentroidOutsidePolygon, write=FIgnoreCellCentroidOutsidePolygon, nodefault};
	__property System::Byte Opacity = {read=fopacity, write=setOpacity, nodefault};
	__property int row = {read=FRow, nodefault};
	__property double NELat = {read=FNELat};
	__property double NELng = {read=FNELng};
	__property double SWLat = {read=FSWLat};
	__property double SWLng = {read=FSWLng};
	__property bool ShowHeaderLabel = {read=FShowHeaderLabel, write=setShowHeaderLabel, nodefault};
	__property int ZIndex = {read=FZIndex, write=setZindex, nodefault};
	__property System::UnicodeString toTxt = {read=getToTxt, write=setToTxt};
	__property TOnCellEvent OnCellClick = {read=FOnCellClick, write=FOnCellClick};
	__property TOnCellEvent OnCellDblClick = {read=FOnCellDblClick, write=FOnCellDblClick};
	__property TOnCellEvent OnCellRightClick = {read=FOnCellRightClick, write=FOnCellRightClick};
	__property TOnCellEvent OnCellLongPress = {read=FOnCellLongPress, write=FOnCellLongPress};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnEditHandleClick = {read=FOnEditHandleClick, write=FOnEditHandleClick};
	__property TOnEditChange OnEditChange = {read=FOnEditChange, write=FOnEditChange};
	__property TOnHeaderLabel OnHeaderColLabel = {read=FOnHeaderColLabel, write=FOnHeaderColLabel};
	__property TOnHeaderLabel OnHeaderRowLabel = {read=FOnHeaderRowLabel, write=FOnHeaderRowLabel};
	__property TOnHeaderClick OnHeaderClick = {read=FOnHeaderClick, write=FOnHeaderClick};
};


class PASCALIMPLEMENTATION TECGrids : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECGrid* operator[](int index) { return this->Grid[index]; }
	
private:
	System::Classes::TStringList* FList;
	TNativeMapControl* FMap;
	bool FBeginClear;
	TECGrid* FEditableGrid;
	TECGrid* FFocusedGrid;
	System::Classes::TNotifyEvent FOnChange;
	TOnEditChange FOnEditChange;
	System::Classes::TNotifyEvent FOnFocusedGrid;
	TOnHeaderLabel FOnHeaderColLabel;
	TOnHeaderLabel FOnHeaderRowLabel;
	TOnHeaderClick FOnHeaderClick;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnEditHandleClick;
	TOnCellEvent FOnCellLongPress;
	TOnCellEvent FOnCellRightClick;
	TOnCellEvent FOnCellClick;
	TOnCellEvent FOnCellDblClick;
	TECGrid* __fastcall getGrid(int index)/* overload */;
	TECGrid* __fastcall getGrid(System::UnicodeString index)/* overload */;
	void __fastcall setFocusedGrid(TECGrid* const Value);
	System::UnicodeString __fastcall getToTxt();
	void __fastcall setToTxt(const System::UnicodeString Value);
	void __fastcall setEditableGrid(TECGrid* const Value);
	void __fastcall doChange(System::TObject* sender);
	System::UnicodeString __fastcall getUniqueName(const System::UnicodeString GridName);
	
public:
	__fastcall TECGrids(TNativeMapControl* const Map);
	__fastcall virtual ~TECGrids();
	void __fastcall Clear();
	TECGrid* __fastcall Add(const System::UnicodeString GridName = System::UnicodeString())/* overload */;
	TECGrid* __fastcall Add(Fmx::Uecnativeshape::TECShapePolygone* const Poly, const int CellSizeMeter = 0x1f4, const System::UnicodeString GridName = System::UnicodeString())/* overload */;
	TECGrid* __fastcall Add(const int col, const int row, const System::UnicodeString GridName = System::UnicodeString())/* overload */;
	int __fastcall Count();
	int __fastcall getList(System::Classes::TStrings* const aList);
	__property TECGrid* FocusedGrid = {read=FFocusedGrid, write=setFocusedGrid};
	__property TECGrid* Grid[int index] = {read=getGrid/*, default*/};
	__property TECGrid* Grid[System::UnicodeString index] = {read=getGrid};
	__property TECGrid* EditableGrid = {read=FEditableGrid, write=setEditableGrid};
	__property System::UnicodeString toTxt = {read=getToTxt, write=setToTxt};
	__property System::Classes::TNotifyEvent OnFocusedGrid = {read=FOnFocusedGrid, write=FOnFocusedGrid};
	__property TOnCellEvent OnCellClick = {read=FOnCellClick, write=FOnCellClick};
	__property TOnCellEvent OnCellDblClick = {read=FOnCellDblClick, write=FOnCellDblClick};
	__property TOnCellEvent OnCellRightClick = {read=FOnCellRightClick, write=FOnCellRightClick};
	__property TOnCellEvent OnCellLongPress = {read=FOnCellLongPress, write=FOnCellLongPress};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnEditHandleClick = {read=FOnEditHandleClick, write=FOnEditHandleClick};
	__property TOnEditChange OnEditChange = {read=FOnEditChange, write=FOnEditChange};
	__property TOnHeaderLabel OnHeaderColLabel = {read=FOnHeaderColLabel, write=FOnHeaderColLabel};
	__property TOnHeaderLabel OnHeaderRowLabel = {read=FOnHeaderRowLabel, write=FOnHeaderRowLabel};
	__property TOnHeaderClick OnHeaderClick = {read=FOnHeaderClick, write=FOnHeaderClick};
	__property System::Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
};


struct DECLSPEC_DRECORD TECChartField
{
public:
	System::UnicodeString Legend;
	Fmx::Uecmaputil::TColor Color;
};


typedef System::DynamicArray<TECChartField> TECAChartField;

typedef System::DynamicArray<double> TECAChartData;

enum DECLSPEC_DENUM TECChartDataSort : unsigned char { cdsNone, cdsAscending, cdsDescending };

class PASCALIMPLEMENTATION TECChartItem : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::UnicodeString operator[](const System::UnicodeString index) { return this->Value[index]; }
	
private:
	double FLat;
	double FLng;
	TECAChartData FData;
	double FTotal;
	Fmx::Uecnativeshape::TPropertyValue* FPropertyValue;
	TECChartLayer* FLayer;
	Fmx::Uecnativeshape::TECShapeMarker* FShape;
	System::UnicodeString __fastcall getValue(const System::UnicodeString index);
	void __fastcall setProperty(const System::UnicodeString index, const System::UnicodeString Value);
	System::UnicodeString __fastcall getProperties();
	void __fastcall setProperties(const System::UnicodeString Value);
	
public:
	__fastcall TECChartItem(TECChartLayer* const aLayer);
	__fastcall virtual ~TECChartItem();
	System::UnicodeString __fastcall PropertyFormat(const System::UnicodeString mask);
	__property double Lat = {read=FLat, write=FLat};
	__property double Lng = {read=FLng, write=FLng};
	__property TECAChartData Data = {read=FData};
	__property System::UnicodeString Properties = {read=getProperties, write=setProperties};
	__property TECChartLayer* Layer = {read=FLayer};
	__property Fmx::Uecnativeshape::TECShapeMarker* shape = {read=FShape};
	__property System::UnicodeString Value[const System::UnicodeString index] = {read=getValue, write=setProperty/*, default*/};
};


typedef void __fastcall (*TOnValidHint)(TECChartItem* const sender, const int index, const double percent, const double Value, System::UnicodeString &Hint);

class PASCALIMPLEMENTATION TECChartLayer : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECChartItem* operator[](const int index) { return this->List[index]; }
	
private:
	TECNativeMap* FMap;
	System::UnicodeString FName;
	System::Classes::TList* FList;
	Fmx::Uecnativeshape::TECShapes* FShapes;
	TECAChartField FFields;
	System::UnicodeString FCaption;
	TECChartDataSort FSort;
	int FMaxChartSize;
	int FMinChartSize;
	int FBarThickness;
	System::Byte fopacity;
	Fmx::Uecmaputil::TColor FColor;
	Fmx::Uecmaputil::TColor FBorderColor;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnClick;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnRightClick;
	Fmx::Uecmaputil::TNativeMapObserver* FObserver;
	Fmx::Uecmaputil::TECChartType FChartType;
	TOnValidHint FOnValidHint;
	bool __fastcall ValidEvent(const Fmx::Uecnativeshape::TOnShapeMouseEvent Event, System::TObject* const sender);
	int __fastcall getCount();
	Fmx::Uecnativeshape::TLabelShape* __fastcall getLabels();
	void __fastcall doOnClick(System::TObject* sender);
	void __fastcall doOnRightClick(System::TObject* sender);
	TECChartItem* __fastcall getList(const int index);
	void __fastcall setZindex(const int index);
	int __fastcall getZindex();
	System::Byte __fastcall getMaxZoom();
	void __fastcall setMaxZoom(const System::Byte Value);
	System::Byte __fastcall getMinZoom();
	void __fastcall setMinZoom(const System::Byte Value);
	Fmx::Uecmaputil::TColor __fastcall getHintColor();
	void __fastcall setHintColor(Fmx::Uecmaputil::TColor aColor);
	bool __fastcall getVisible();
	void __fastcall setVisible(const bool Value);
	
public:
	__fastcall TECChartLayer(TECNativeMap* Map, const System::UnicodeString ValueName);
	__fastcall virtual ~TECChartLayer();
	void __fastcall Clear();
	int __fastcall AddField(const System::UnicodeString Legend, Fmx::Uecmaputil::TColor Color);
	TECChartItem* __fastcall Add(const double Lat, const double Lng, const System::UnicodeString Properties = System::UnicodeString())/* overload */;
	void __fastcall Delete(const int index);
	void __fastcall fitBounds();
	void __fastcall Update();
	__property System::UnicodeString Caption = {read=FCaption, write=FCaption};
	__property int BarThickness = {read=FBarThickness, write=FBarThickness, nodefault};
	__property System::Uitypes::TAlphaColor Color = {read=FColor, write=FColor, nodefault};
	__property System::Uitypes::TAlphaColor BorderColor = {read=FBorderColor, write=FBorderColor, nodefault};
	__property int Count = {read=getCount, nodefault};
	__property TECAChartField Fields = {read=FFields};
	__property System::Uitypes::TAlphaColor HintColor = {read=getHintColor, write=setHintColor, nodefault};
	__property Fmx::Uecnativeshape::TLabelShape* labels = {read=getLabels};
	__property int MaxChartSize = {read=FMaxChartSize, write=FMaxChartSize, nodefault};
	__property int MinChartSize = {read=FMinChartSize, write=FMinChartSize, nodefault};
	__property System::Byte Opacity = {read=fopacity, write=fopacity, nodefault};
	__property Fmx::Uecmaputil::TECChartType ChartType = {read=FChartType, write=FChartType, nodefault};
	__property System::Byte MaxZoom = {read=getMaxZoom, write=setMaxZoom, nodefault};
	__property System::Byte MinZoom = {read=getMinZoom, write=setMinZoom, nodefault};
	__property bool Visible = {read=getVisible, write=setVisible, nodefault};
	__property System::UnicodeString Name = {read=FName};
	__property TECChartItem* List[const int index] = {read=getList/*, default*/};
	__property TECChartDataSort Sort = {read=FSort, write=FSort, nodefault};
	__property int ZIndex = {read=getZindex, write=setZindex, nodefault};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnClick = {read=FOnClick, write=FOnClick};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnRightClick = {read=FOnRightClick, write=FOnRightClick};
	__property TOnValidHint OnValidHint = {read=FOnValidHint, write=FOnValidHint};
};


class PASCALIMPLEMENTATION TECChartLayers : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECChartLayer* operator[](const System::UnicodeString index) { return this->Layer[index]; }
	
private:
	TECNativeMap* FMap;
	int FMaxChartSize;
	int FMinChartSize;
	int FBarThickness;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnClick;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnRightClick;
	System::Classes::TNotifyEvent FOnChange;
	System::Classes::TStringList* FList;
	TECChartLayer* __fastcall getLayer(const System::UnicodeString index);
	TECChartLayer* __fastcall getList(const int index);
	int __fastcall getCount();
	void __fastcall doChange(System::TObject* sender);
	
public:
	__fastcall TECChartLayers(TECNativeMap* Map);
	__fastcall virtual ~TECChartLayers();
	TECChartLayer* __fastcall Add(const System::UnicodeString Name);
	void __fastcall Delete(const System::UnicodeString Name)/* overload */;
	void __fastcall Delete(const int index)/* overload */;
	void __fastcall Clear();
	int __fastcall getLayers(System::Classes::TStrings* const aList);
	__property int Count = {read=getCount, nodefault};
	__property int MaxChartSize = {read=FMaxChartSize, write=FMaxChartSize, nodefault};
	__property int MinChartSize = {read=FMinChartSize, write=FMinChartSize, nodefault};
	__property int BarThickness = {read=FBarThickness, write=FBarThickness, nodefault};
	__property TECChartLayer* Layer[const System::UnicodeString index] = {read=getLayer/*, default*/};
	__property TECChartLayer* List[const int index] = {read=getList};
	__property System::Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnClick = {read=FOnClick, write=FOnClick};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnRightClick = {read=FOnRightClick, write=FOnRightClick};
};


typedef void __fastcall (__closure *TECOnEditBubble)(Fmx::Uecnativeshape::TECShapePOI* const BubbleShape);

class PASCALIMPLEMENTATION TECBubbleItem : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::UnicodeString operator[](const System::UnicodeString index) { return this->Value[index]; }
	
private:
	double FLat;
	double FLng;
	double FSize;
	Fmx::Uecnativeshape::TPropertyValue* FPropertyValue;
	TECBubbleLayer* FLayer;
	System::UnicodeString __fastcall getValue(const System::UnicodeString index);
	void __fastcall setProperty(const System::UnicodeString index, const System::UnicodeString Value);
	System::UnicodeString __fastcall getProperties();
	void __fastcall setProperties(const System::UnicodeString Value);
	
public:
	__fastcall TECBubbleItem(TECBubbleLayer* const aLayer);
	__fastcall virtual ~TECBubbleItem();
	System::UnicodeString __fastcall PropertyFormat(const System::UnicodeString mask);
	__property double Lat = {read=FLat, write=FLat};
	__property double Lng = {read=FLng, write=FLng};
	__property double Size = {read=FSize, write=FSize};
	__property System::UnicodeString Properties = {read=getProperties, write=setProperties};
	__property TECBubbleLayer* Layer = {read=FLayer};
	__property System::UnicodeString Value[const System::UnicodeString index] = {read=getValue, write=setProperty/*, default*/};
};


class PASCALIMPLEMENTATION TECBubbleLayer : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECBubbleItem* operator[](const int index) { return this->List[index]; }
	
private:
	TECNativeMap* FMap;
	System::UnicodeString FName;
	System::Classes::TList* FList;
	Fmx::Uecnativeshape::TECShapes* FShapes;
	Fmx::Uecmaputil::TColor FColor;
	int FMaxItemSize;
	int FMinItemSize;
	System::Byte fopacity;
	System::UnicodeString FHint;
	System::UnicodeString FHintProperty;
	TECOnEditBubble FOnEditBubble;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnClick;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnRightClick;
	Fmx::Uecmaputil::TNativeMapObserver* FObserver;
	Fmx::Uecmaputil::TPOIShape FShape;
	Fmx::Uecheatmap::THeatPalette* FColorPalette;
	bool FUseColorPalette;
	bool __fastcall ValidEvent(const Fmx::Uecnativeshape::TOnShapeMouseEvent Event, System::TObject* const sender);
	int __fastcall getCount();
	Fmx::Uecnativeshape::TLabelShape* __fastcall getLabels();
	void __fastcall doOnClick(System::TObject* sender);
	void __fastcall doOnRightClick(System::TObject* sender);
	TECBubbleItem* __fastcall getList(const int index);
	void __fastcall setZindex(const int index);
	int __fastcall getZindex();
	System::Byte __fastcall getMaxZoom();
	void __fastcall setMaxZoom(const System::Byte Value);
	System::Byte __fastcall getMinZoom();
	void __fastcall setMinZoom(const System::Byte Value);
	void __fastcall setHint(const System::UnicodeString Value);
	bool __fastcall getVisible();
	void __fastcall setVisible(const bool Value);
	Fmx::Uecmaputil::TColor __fastcall getHintColor();
	void __fastcall setHintColor(Fmx::Uecmaputil::TColor aColor);
	
public:
	__fastcall TECBubbleLayer(TECNativeMap* Map, const System::UnicodeString ValueName);
	__fastcall virtual ~TECBubbleLayer();
	void __fastcall Clear();
	TECBubbleItem* __fastcall Add(const double Lat, const double Lng, const double Size, const System::UnicodeString Properties = System::UnicodeString())/* overload */;
	TECBubbleItem* __fastcall Add(const System::UnicodeString location, double Size, const System::UnicodeString Properties = System::UnicodeString())/* overload */;
	void __fastcall Delete(const int index);
	void __fastcall fitBounds();
	void __fastcall Update();
	__property Fmx::Uecmaputil::TColor Color = {read=FColor, write=FColor, nodefault};
	__property Fmx::Uecheatmap::THeatPalette* ColorPalette = {read=FColorPalette};
	__property bool UseColorPalette = {read=FUseColorPalette, write=FUseColorPalette, nodefault};
	__property int Count = {read=getCount, nodefault};
	__property System::UnicodeString HintProperty = {read=FHintProperty, write=FHintProperty};
	__property System::UnicodeString Hint = {read=FHint, write=setHint};
	__property Fmx::Uecmaputil::TColor HintColor = {read=getHintColor, write=setHintColor, nodefault};
	__property int MaxItemSize = {read=FMaxItemSize, write=FMaxItemSize, nodefault};
	__property int MinItemSize = {read=FMinItemSize, write=FMinItemSize, nodefault};
	__property Fmx::Uecnativeshape::TLabelShape* labels = {read=getLabels};
	__property System::Byte Opacity = {read=fopacity, write=fopacity, nodefault};
	__property Fmx::Uecmaputil::TPOIShape shape = {read=FShape, write=FShape, nodefault};
	__property System::Byte MaxZoom = {read=getMaxZoom, write=setMaxZoom, nodefault};
	__property System::Byte MinZoom = {read=getMinZoom, write=setMinZoom, nodefault};
	__property bool Visible = {read=getVisible, write=setVisible, nodefault};
	__property System::UnicodeString Name = {read=FName};
	__property TECBubbleItem* List[const int index] = {read=getList/*, default*/};
	__property int ZIndex = {read=getZindex, write=setZindex, nodefault};
	__property TECOnEditBubble OnEditBubble = {read=FOnEditBubble, write=FOnEditBubble};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnClick = {read=FOnClick, write=FOnClick};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnRightClick = {read=FOnRightClick, write=FOnRightClick};
};


class PASCALIMPLEMENTATION TECBubbleLayers : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECBubbleLayer* operator[](const System::UnicodeString index) { return this->Layer[index]; }
	
private:
	TECNativeMap* FMap;
	Fmx::Uecmaputil::TColor FColor;
	Fmx::Uecmaputil::TPOIShape FShape;
	int FMaxItemSize;
	int FMinItemSize;
	System::Byte fopacity;
	TECOnEditBubble FOnEditBubble;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnClick;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnRightClick;
	System::Classes::TNotifyEvent FOnChange;
	System::Classes::TStringList* FList;
	bool FUseColorPalette;
	TECBubbleLayer* __fastcall getLayer(const System::UnicodeString index);
	TECBubbleLayer* __fastcall getList(const int index);
	int __fastcall getCount();
	void __fastcall doChange(System::TObject* sender);
	
public:
	__fastcall TECBubbleLayers(TECNativeMap* Map);
	__fastcall virtual ~TECBubbleLayers();
	TECBubbleLayer* __fastcall Add(const System::UnicodeString Name);
	void __fastcall Delete(const System::UnicodeString Name)/* overload */;
	void __fastcall Delete(const int index)/* overload */;
	void __fastcall Clear();
	int __fastcall getLayers(System::Classes::TStrings* const aList);
	__property Fmx::Uecmaputil::TColor Color = {read=FColor, write=FColor, nodefault};
	__property bool UseColorPalette = {read=FUseColorPalette, write=FUseColorPalette, nodefault};
	__property int Count = {read=getCount, nodefault};
	__property int MaxItemSize = {read=FMaxItemSize, write=FMaxItemSize, nodefault};
	__property int MinItemSize = {read=FMinItemSize, write=FMinItemSize, nodefault};
	__property TECBubbleLayer* Layer[const System::UnicodeString index] = {read=getLayer/*, default*/};
	__property TECBubbleLayer* List[const int index] = {read=getList};
	__property System::Byte Opacity = {read=fopacity, write=fopacity, nodefault};
	__property Fmx::Uecmaputil::TPOIShape shape = {read=FShape, write=FShape, nodefault};
	__property System::Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
	__property TECOnEditBubble OnEditBubble = {read=FOnEditBubble, write=FOnEditBubble};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnClick = {read=FOnClick, write=FOnClick};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnRightClick = {read=FOnRightClick, write=FOnRightClick};
};


enum DECLSPEC_DENUM TECGraticuleUnit : unsigned char { guDegrees, guDecimalDegrees, guQTHLocator, guUTM, guOLC, guGeoHash };

enum DECLSPEC_DENUM TGraticuleLabelPosition : unsigned char { gpTop, gpRight, gpBottom, gpLeft };

typedef System::Set<TGraticuleLabelPosition, TGraticuleLabelPosition::gpTop, TGraticuleLabelPosition::gpLeft> TGraticuleLabelPositions;

typedef System::StaticArray<int, 22> TGraticuleInterval;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECGraticule : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	TECNativeMap* FMap;
	bool FVisible;
	bool FShowMousePosition;
	System::Byte fopacity;
	Fmx::Uecmaputil::TPenStyle FPenStyle;
	TECGraticuleUnit FLabelUnit;
	int FLineSize;
	Fmx::Uecmaputil::TColor FLineColor;
	Fmx::Uecmaputil::TColor FLabelColor;
	TGraticuleLabelPositions FLabelPositions;
	TGraticuleInterval FZoomInterval;
	Fmx::Graphics::TFont* FLabelFont;
	void __fastcall setVisible(const bool Value);
	void __fastcall setOpacity(const System::Byte Value);
	void __fastcall setPenStyle(const Fmx::Uecmaputil::TPenStyle Value);
	void __fastcall setLabelUnit(const TECGraticuleUnit Value);
	void __fastcall setLineColor(const Fmx::Uecmaputil::TColor Value);
	void __fastcall setLineSize(const int Value);
	void __fastcall setLabelColor(const Fmx::Uecmaputil::TColor Value);
	void __fastcall setLabelPositions(const TGraticuleLabelPositions Value);
	void __fastcall setLabelFont(Fmx::Graphics::TFont* const Value);
	void __fastcall Draw(Fmx::Uecgraphics::TECCanvas* const canvas);
	
public:
	__fastcall TECGraticule(TECNativeMap* Map);
	__fastcall virtual ~TECGraticule();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	void __fastcall Update();
	__property bool Visible = {read=FVisible, write=setVisible, nodefault};
	__property bool ShowMousePosition = {read=FShowMousePosition, write=FShowMousePosition, nodefault};
	__property Fmx::Uecmaputil::TPenStyle LineStyle = {read=FPenStyle, write=setPenStyle, nodefault};
	__property Fmx::Uecmaputil::TColor LineColor = {read=FLineColor, write=setLineColor, nodefault};
	__property int LineSize = {read=FLineSize, write=setLineSize, nodefault};
	__property TECGraticuleUnit LabelUnit = {read=FLabelUnit, write=setLabelUnit, nodefault};
	__property Fmx::Uecmaputil::TColor LabelColor = {read=FLabelColor, write=setLabelColor, nodefault};
	__property Fmx::Graphics::TFont* LabelFont = {read=FLabelFont, write=setLabelFont};
	__property TGraticuleLabelPositions LabelPositions = {read=FLabelPositions, write=setLabelPositions, nodefault};
	__property System::Byte Opacity = {read=fopacity, write=setOpacity, nodefault};
	__property TGraticuleInterval ZoomInterval = {read=FZoomInterval};
};

#pragma pack(pop)

enum DECLSPEC_DENUM TECDrawPathType : unsigned char { dptStraight, dptPedestrian, dptBicycle, dptCar };

typedef void __fastcall (__closure *TECDrawPathPaintCursor)(Fmx::Uecgraphics::TECCanvas* const canvas);

typedef void __fastcall (__closure *TECDrawPathReady)(const bool Ready);

typedef void __fastcall (__closure *TECDrawPathActivate)(const bool Activate);

class PASCALIMPLEMENTATION TECDrawPath : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TNativeMapControl* FMap;
	Fmx::Uecmaputil::TNativeMapObserver* FObserver;
	Fmx::Uecnativeshape::TECShapes* FEditLineGroup;
	Fmx::Uecnativeshape::TECShapeLine* FWorkLine;
	Fmx::Uecnativeshape::TECShapeLine* FDirectPath;
	TRoutingEngine FRoutingEngine;
	Fmx::Uecnativeshape::TOnChangeRoute FOnChangeRoute;
	Fmx::Uecnativeshape::TOnErrorRoute FOnErrorRoute;
	Fmx::Uecmaputil::TMQRouteType FRouteType;
	TECDrawPathType FPathType;
	TECDrawPathPaintCursor FOnPaintCursor;
	bool FActivate;
	bool FAddPointOnClick;
	bool FisReady;
	bool FisUndo;
	bool FEditStartLine;
	Fmx::Uecmaputil::TLatLng FEditLineLastPoint;
	bool FShowCursor;
	System::Uitypes::TCursor FOldCursor;
	System::Uitypes::TCursor FOldCursorMove;
	System::UnicodeString FCursorData;
	System::UnicodeString FGroupName;
	TECDrawPathReady FOnReady;
	TECDrawPathActivate FOnActivate;
	System::Classes::TNotifyEvent FOnError;
	void __fastcall doOnChangeRoute(Fmx::Uecnativeshape::TECShapeLine* sender, const System::UnicodeString Params);
	void __fastcall doOnErrorRoute(System::TObject* sender, Fmx::Uecgeolocalise::TECThreadDataRoute* const dataroute);
	void __fastcall doChangeMapBounds(System::TObject* sender);
	void __fastcall doMapClick(System::TObject* sender);
	void __fastcall doMouseMove(System::TObject* sender);
	void __fastcall doDrawCross(System::TObject* sender);
	void __fastcall setShowCursor(const bool Value);
	void __fastcall setActivate(const bool Value);
	void __fastcall setPathType(const TECDrawPathType Value);
	void __fastcall setOnPaintCursor(const TECDrawPathPaintCursor Value);
	void __fastcall setAddPointOnClick(const bool Value);
	void __fastcall doAddPoint(const double latitude, const double longitude);
	void __fastcall setCursorData(const System::UnicodeString Value);
	bool __fastcall isMouseCenter();
	
public:
	__fastcall TECDrawPath(TNativeMapControl* Map);
	__fastcall virtual ~TECDrawPath();
	void __fastcall AddPoint()/* overload */;
	void __fastcall AddPoint(const double latitude, const double longitude)/* overload */;
	bool __fastcall GetPath(Fmx::Uecnativeshape::TECShapeLine* const Line);
	void __fastcall Undo();
	__property System::UnicodeString CursorData = {read=FCursorData, write=setCursorData};
	__property System::UnicodeString Name = {read=FGroupName};
	__property bool Activate = {read=FActivate, write=setActivate, nodefault};
	__property bool AddPointOnClick = {read=FAddPointOnClick, write=setAddPointOnClick, nodefault};
	__property bool isReady = {read=FisReady, nodefault};
	__property bool isUndo = {read=FisUndo, nodefault};
	__property TECDrawPathType PathType = {read=FPathType, write=setPathType, nodefault};
	__property bool ShowCursor = {read=FShowCursor, write=setShowCursor, nodefault};
	__property TECDrawPathActivate OnActivate = {read=FOnActivate, write=FOnActivate};
	__property System::Classes::TNotifyEvent OnError = {read=FOnError, write=FOnError};
	__property TECDrawPathReady OnReady = {read=FOnReady, write=FOnReady};
	__property TECDrawPathPaintCursor OnPaintCursor = {read=FOnPaintCursor, write=setOnPaintCursor};
};


class PASCALIMPLEMENTATION TECDownLoadTiles : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Fmx::Uecnativetileserver::TNativeMapServer* FMapServer;
	Fmx::Uecmaputil::TTileServer FTileServer;
	TThreadECDownLoadTiles* FThreadECDownLoadTiles;
	int FStartCountTiles;
	int FStartDownLoadTiles;
	int FWaitingBetweenTiles;
	int FCountTiles;
	int FDownLoadTiles;
	bool FWait;
	bool FForceRefreshTiles;
	System::UnicodeString FDirectoryTiles;
	int FTag;
	int FTileSize;
	int FTilePPI;
	bool FSSL;
	bool FDownLoading;
	System::TObject* FTagObject;
	int FStartX;
	int FStartY;
	System::Byte FStartZoom;
	bool FPause;
	int FFromZoom;
	int FToZoom;
	double FNorthEastLatitude;
	double FNorthEastLongitude;
	double FSouthWestLatitude;
	double FSouthWestLongitude;
	System::Classes::TNotifyEvent FOnErrorConnexion;
	System::Classes::TNotifyEvent FOnDownLoad;
	System::Classes::TNotifyEvent FOnEndDownLoad;
	TOnErrorLoadTiles FOnErrorLoadTiles;
	void __fastcall setUserAgent(const System::UnicodeString Value);
	System::UnicodeString __fastcall getUserAgent();
	void __fastcall setPause(const bool Value);
	void __fastcall setDirectoryTiles(const System::UnicodeString Value);
	void __fastcall setTileSize(const int Value);
	void __fastcall setTilePPI(const int Value);
	void __fastcall SetTileServer(const Fmx::Uecmaputil::TTileServer Value);
	Fmx::Uecmaputil::TTileServer __fastcall getTileServer();
	System::UnicodeString __fastcall getTileName();
	void __fastcall setTileName(const System::UnicodeString Value);
	bool __fastcall getForceRefreshTiles();
	void __fastcall setForceRefreshTiles(const bool Value);
	void __fastcall doOnLoadTile(System::TObject* sender, const int X, const int Y, const int Z, const int t);
	void __fastcall doOnErrorTile(System::TObject* sender, const int X, const int Y, const int Z, const int t);
	void __fastcall doEndLoadTile(System::TObject* sender);
	void __fastcall doErrorConnexion(System::TObject* sender);
	void __fastcall setSSL(const bool Value);
	void __fastcall setOnlyLocal(const bool Value);
	bool __fastcall getOnlyLocal();
	Fmx::Uecnativetileserver::TTileServerInfo* __fastcall getTileServerInfo();
	void __fastcall setMaxDayInCache(const double Value);
	double __fastcall getMaxDayInCache();
	System::UnicodeString __fastcall getGoogleKey();
	System::UnicodeString __fastcall getBingKey();
	System::UnicodeString __fastcall getMapQuestKey();
	System::UnicodeString __fastcall getVectorMapZenKey();
	System::UnicodeString __fastcall getMapBoxKey();
	System::UnicodeString __fastcall getDigitalGlobeToken();
	System::UnicodeString __fastcall getStadiaMapsKey();
	System::UnicodeString __fastcall getTraceStrackKey();
	System::UnicodeString __fastcall getOpenCycleMapKey();
	System::UnicodeString __fastcall getTomTomKey();
	System::UnicodeString __fastcall getPTVKey();
	System::UnicodeString __fastcall getAqicnKey();
	void __fastcall setOpenCycleMapKey(const System::UnicodeString key);
	void __fastcall setStadiaMapsKey(const System::UnicodeString key);
	void __fastcall setTraceStrackKey(const System::UnicodeString key);
	void __fastcall setGoogleKey(const System::UnicodeString key);
	void __fastcall setBingKey(const System::UnicodeString key);
	void __fastcall setMapQuestKey(const System::UnicodeString key);
	void __fastcall setVectorMapZenKey(const System::UnicodeString Value);
	void __fastcall setMapBoxKey(const System::UnicodeString Value);
	void __fastcall setDigitalGlobeToken(const System::UnicodeString Value);
	void __fastcall setTomTomKey(const System::UnicodeString Value);
	void __fastcall setPTVKey(const System::UnicodeString Value);
	void __fastcall setAqicnKey(const System::UnicodeString Value);
	void __fastcall setHereParam(const System::UnicodeString Value);
	void __fastcall setHereID(const System::UnicodeString key);
	System::UnicodeString __fastcall getHereID();
	System::UnicodeString __fastcall getHereParam();
	System::UnicodeString __fastcall getIgnKey();
	void __fastcall setIgnKey(const System::UnicodeString key);
	System::UnicodeString __fastcall getGoogleStyles();
	void __fastcall setGoogleStyles(const System::UnicodeString Value);
	
public:
	__fastcall TECDownLoadTiles(const int msWaitingBetweenTiles);
	__fastcall virtual ~TECDownLoadTiles();
	void __fastcall cancel();
	void __fastcall DownLoadTiles(const int FromZoom, const int ToZoom, const double NorthEastLatitude, const double NorthEastLongitude, const double SouthWestLatitude, const double SouthWestLongitude)/* overload */;
	void __fastcall DownLoadTiles(const int FromZoom, const int ToZoom, const double NorthEastLatitude, const double NorthEastLongitude, const double SouthWestLatitude, const double SouthWestLongitude, const int startX, const int startY, const System::Byte StartZoom, const int StartCountTiles, const int StartDownLoadtiles)/* overload */;
	__property bool Pause = {read=FPause, write=setPause, nodefault};
	__property int CountTotalTiles = {read=FCountTiles, nodefault};
	__property int CountDownLoadTiles = {read=FDownLoadTiles, nodefault};
	__property bool DownLoading = {read=FDownLoading, nodefault};
	__property System::UnicodeString DirectoryTiles = {read=FDirectoryTiles, write=setDirectoryTiles};
	__property bool ForceRefreshTiles = {read=getForceRefreshTiles, write=setForceRefreshTiles, nodefault};
	__property double MaxDayInCache = {read=getMaxDayInCache, write=setMaxDayInCache};
	__property System::UnicodeString TileName = {read=getTileName, write=setTileName};
	__property Fmx::Uecnativetileserver::TTileServerInfo* TileServerInfo = {read=getTileServerInfo};
	__property Fmx::Uecmaputil::TTileServer TileServer = {read=getTileServer, write=SetTileServer, default=4};
	__property int TileSize = {read=FTileSize, write=setTileSize, nodefault};
	__property int TilePPI = {read=FTilePPI, write=setTilePPI, nodefault};
	__property bool SSL = {read=FSSL, write=setSSL, nodefault};
	__property bool OnlyLocal = {read=getOnlyLocal, write=setOnlyLocal, nodefault};
	__property System::UnicodeString USerAgent = {read=getUserAgent, write=setUserAgent};
	__property int startX = {read=FStartX, write=FStartX, nodefault};
	__property int startY = {read=FStartY, write=FStartY, nodefault};
	__property System::Byte StartZoom = {read=FStartZoom, write=FStartZoom, nodefault};
	__property int StartCountTiles = {read=FStartCountTiles, write=FStartCountTiles, nodefault};
	__property int StartDownLoadtiles = {read=FStartDownLoadTiles, write=FStartDownLoadTiles, nodefault};
	__property int FromZoom = {read=FFromZoom, write=FFromZoom, nodefault};
	__property int ToZoom = {read=FToZoom, write=FToZoom, nodefault};
	__property double NorthEastLatitude = {read=FNorthEastLatitude, write=FNorthEastLatitude};
	__property double NorthEastLongitude = {read=FNorthEastLongitude, write=FNorthEastLongitude};
	__property double SouthWestLatitude = {read=FSouthWestLatitude, write=FSouthWestLatitude};
	__property double SouthWestLongitude = {read=FSouthWestLongitude, write=FSouthWestLongitude};
	__property System::UnicodeString BingKey = {read=getBingKey, write=setBingKey};
	__property System::UnicodeString GoogleKey = {read=getGoogleKey, write=setGoogleKey};
	__property System::UnicodeString GoogleStyles = {read=getGoogleStyles, write=setGoogleStyles};
	__property System::UnicodeString MapQuestKey = {read=getMapQuestKey, write=setMapQuestKey};
	__property System::UnicodeString VectorMapZenKey = {read=getVectorMapZenKey, write=setVectorMapZenKey};
	__property System::UnicodeString TomTomKey = {read=getTomTomKey, write=setTomTomKey};
	__property System::UnicodeString PTVKey = {read=getPTVKey, write=setPTVKey};
	__property System::UnicodeString MapBoxToken = {read=getMapBoxKey, write=setMapBoxKey};
	__property System::UnicodeString AqicnKey = {read=getAqicnKey, write=setAqicnKey};
	__property System::UnicodeString IgnKey = {read=getIgnKey, write=setIgnKey};
	__property System::UnicodeString ThunderforestKey = {read=getOpenCycleMapKey, write=setOpenCycleMapKey};
	__property System::UnicodeString StadiaMapsKey = {read=getStadiaMapsKey, write=setStadiaMapsKey};
	__property System::UnicodeString TraceStrackKey = {read=getTraceStrackKey, write=setTraceStrackKey};
	__property System::UnicodeString DigitalGlobeToken = {read=getDigitalGlobeToken, write=setDigitalGlobeToken};
	__property System::UnicodeString HereApiKey = {read=getHereID, write=setHereID};
	__property System::UnicodeString HereParam = {read=getHereParam, write=setHereParam};
	__property int Tag = {read=FTag, write=FTag, nodefault};
	__property System::TObject* TagObject = {read=FTagObject, write=FTagObject};
	__property System::Classes::TNotifyEvent OnDownLoad = {read=FOnDownLoad, write=FOnDownLoad};
	__property System::Classes::TNotifyEvent OnEndDownLoad = {read=FOnEndDownLoad, write=FOnEndDownLoad};
	__property TOnErrorLoadTiles OnErrorLoadTiles = {read=FOnErrorLoadTiles, write=FOnErrorLoadTiles};
	__property System::Classes::TNotifyEvent OnErrorConnexion = {read=FOnErrorConnexion, write=FOnErrorConnexion};
};


class PASCALIMPLEMENTATION TThreadECDownLoadTiles : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	unsigned FTiming;
	TECDownLoadTiles* FECDownLoadTiles;
	int FStartX;
	int FStartY;
	System::Byte FStartZoom;
	System::Byte FSZoom;
	System::Byte FEZoom;
	bool FStop;
	double FNorthEastLatitude;
	double FNorthEastLongitude;
	double FSouthWestLatitude;
	double FSouthWestLongitude;
	int _X;
	int _Y;
	int _Z;
	void __fastcall doLoadTile();
	void __fastcall doErrorTile();
	
protected:
	virtual void __fastcall Execute();
	
public:
	__fastcall TThreadECDownLoadTiles(TECDownLoadTiles* Value, const System::Byte SZoom, const System::Byte EZoom, const double NorthEastLatitude, const double NorthEastLongitude, const double SouthWestLatitude, const double SouthWestLongitude, int startX, int startY, System::Byte StartZoom, System::Classes::TNotifyEvent _OnTerminate);
	__fastcall virtual ~TThreadECDownLoadTiles();
	void __fastcall Stop();
};


enum DECLSPEC_DENUM TOSMData : unsigned char { odNode, odWay, odRel };

typedef System::Set<TOSMData, TOSMData::odNode, TOSMData::odRel> TSetOSMData;

enum DECLSPEC_DENUM TBinaryFilterOSM : unsigned char { bfAnd, bfOr };

struct DECLSPEC_DRECORD TECOverPassData
{
public:
	System::UnicodeString Data;
	System::UnicodeString Query;
};


typedef void __fastcall (__closure *TECOnOverPass)(const TECOverPassData &Value);

typedef void __fastcall (__closure *TECOnOverPassLayerData)(const System::UnicodeString XmlValue);

class PASCALIMPLEMENTATION TEOverPass : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TECOnOverPass OnDataEvent;
	TECOverPassData Data;
public:
	/* TObject.Create */ inline __fastcall TEOverPass() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TEOverPass() { }
	
};


class PASCALIMPLEMENTATION TECOverPassApiLayer : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TECBBoxDataCacheList* FCacheBox;
	TECOnOverPassLayerData FOnData;
	TECOverPass* FParent;
	TNativeMapControl* FMap;
	System::UnicodeString FQuery;
	int FSecondeTimeOut;
	Fmx::Types::TTimer* FTimer;
	Fmx::Uecnativeshape::TECShapes* FGroup;
	Fmx::Uecnativeshape::TECShapeInfoWindow* FInfoWindows;
	double _FNELat;
	double _FNELng;
	double _FSWLat;
	double _FSWLng;
	double FNELat;
	double FNELng;
	double FSWLat;
	double FSWLng;
	Fmx::Uecnativeshape::TOnShapeMouseEvent FOnClick;
	Fmx::Uecmaputil::TNativeMapObserver* FObserver;
	__int64 FLastCall;
	bool FChangePosition;
	bool FinLoad;
	System::Classes::TNotifyEvent FOnBeginQuery;
	System::Classes::TNotifyEvent FOnEndQuery;
	void __fastcall setQuery(const System::UnicodeString Value);
	void __fastcall ActiveObserver(const bool Active);
	void __fastcall doOnLoad(System::TObject* sender);
	void __fastcall doMapEndMove(System::TObject* sender);
	void __fastcall doOnClick(System::TObject* sender);
	void __fastcall setLayer(const bool Value);
	bool __fastcall getLayer();
	void __fastcall doOnCallOverPass(System::TObject* sender);
	void __fastcall doOnLoadData(System::TObject* sender);
	void __fastcall UpdateLayer();
	void __fastcall setSecondeTimeOut(const int Value);
	void __fastcall doTimeOut(System::TObject* sender);
	
public:
	__fastcall TECOverPassApiLayer(TECOverPass* const Parent);
	__fastcall virtual ~TECOverPassApiLayer();
	void __fastcall Clear();
	void __fastcall OpenWindow(double Lat, double Lng, const System::UnicodeString Content, int Width = 0x140);
	void __fastcall Tag(const System::UnicodeString tag_name, const System::UnicodeString tag_value, const TSetOSMData Data = (TSetOSMData() << TOSMData::odNode << TOSMData::odWay ))/* overload */;
	void __fastcall Tag(const System::UnicodeString tag_name, const System::UnicodeString *tag_values, const System::NativeInt tag_values_High, const TSetOSMData Data = (TSetOSMData() << TOSMData::odNode << TOSMData::odWay ), const TBinaryFilterOSM Op = (TBinaryFilterOSM)(0x0))/* overload */;
	void __fastcall Tag(const System::UnicodeString *tags, const System::NativeInt tags_High, const TSetOSMData Data = (TSetOSMData() << TOSMData::odNode << TOSMData::odWay ), const TBinaryFilterOSM Op = (TBinaryFilterOSM)(0x0))/* overload */;
	void __fastcall amenity(System::UnicodeString amenity_value, const TSetOSMData Data = (TSetOSMData() << TOSMData::odNode << TOSMData::odWay ))/* overload */;
	void __fastcall amenity(System::UnicodeString *amenity_values, const System::NativeInt amenity_values_High, const TSetOSMData Data = (TSetOSMData() << TOSMData::odNode << TOSMData::odWay ), const TBinaryFilterOSM Op = (TBinaryFilterOSM)(0x1))/* overload */;
	__property System::UnicodeString Query = {read=FQuery, write=setQuery};
	__property Fmx::Uecnativeshape::TECShapes* Group = {read=FGroup};
	__property bool Visible = {read=getLayer, write=setLayer, nodefault};
	__property int TimeOut = {read=FSecondeTimeOut, write=setSecondeTimeOut, nodefault};
	__property System::Classes::TNotifyEvent OnBeginQuery = {read=FOnBeginQuery, write=FOnBeginQuery};
	__property System::Classes::TNotifyEvent OnEndQuery = {read=FOnEndQuery, write=FOnEndQuery};
	__property Fmx::Uecnativeshape::TOnShapeMouseEvent OnClick = {read=FOnClick, write=FOnClick};
	__property TECOnOverPassLayerData OnData = {read=FOnData, write=FOnData};
};


class PASCALIMPLEMENTATION TECOverPass : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TNativeMapControl* FMap;
	Fmx::Uecmaputil::TNativeMapObserver* FObserver;
	Fmx::Uecnativeshape::TECShapePolygone* FFilterPolygone;
	System::Classes::TNotifyEvent FOldOnDestroy;
	System::UnicodeString FFilterPolygoneString;
	System::UnicodeString FCache;
	System::UnicodeString FUrl;
	TECOnOverPass FOnData;
	int FPendingQuery;
	int FSecondeTimeOut;
	TECOverPassApiLayer* FECOverPassApiLayer;
	void __fastcall doOnCallOverPass(System::TObject* sender);
	void __fastcall doOnLoadData(System::TObject* sender);
	void __fastcall setFilterPolygone(Fmx::Uecnativeshape::TECShapePolygone* const Value);
	void __fastcall doOnRemovePolygone(System::TObject* sender);
	void __fastcall doUpdatePolygone(System::TObject* sender);
	
public:
	__fastcall TECOverPass(TNativeMapControl* Map);
	__fastcall virtual ~TECOverPass();
	void __fastcall Query(const System::UnicodeString Value, const TECOnOverPass OnDataEvent = 0x0);
	void __fastcall StreetNames(const System::UnicodeString bbox = System::UnicodeString(), const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	void __fastcall StreetNames(const double SWLatitude, const double SWLongitude, const double NELatitude, const double NELongitude, const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	void __fastcall Streets(const System::UnicodeString bbox = System::UnicodeString(), const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	void __fastcall Streets(const double SWLatitude, const double SWLongitude, const double NELatitude, const double NELongitude, const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	void __fastcall Tag(const System::UnicodeString *tags, const System::NativeInt tags_High, const TSetOSMData Data = (TSetOSMData() << TOSMData::odNode << TOSMData::odWay ), const TBinaryFilterOSM Op = (TBinaryFilterOSM)(0x0), const System::UnicodeString bbox = System::UnicodeString(), const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	void __fastcall Tag(const System::UnicodeString tag_name, const System::UnicodeString *tag_values, const System::NativeInt tag_values_High, const TSetOSMData Data = (TSetOSMData() << TOSMData::odNode << TOSMData::odWay ), const TBinaryFilterOSM Op = (TBinaryFilterOSM)(0x0), const System::UnicodeString bbox = System::UnicodeString(), const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	void __fastcall Tag(const System::UnicodeString tag_name = System::UnicodeString(), const System::UnicodeString tag_value = System::UnicodeString(), const TSetOSMData Data = (TSetOSMData() << TOSMData::odNode << TOSMData::odWay ), const System::UnicodeString bbox = System::UnicodeString(), const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	void __fastcall Tag(const double SWLatitude, const double SWLongitude, const double NELatitude, const double NELongitude, const System::UnicodeString tag_name = System::UnicodeString(), const System::UnicodeString tag_value = System::UnicodeString(), const TSetOSMData Data = (TSetOSMData() << TOSMData::odNode << TOSMData::odWay ), const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	void __fastcall Tag(const double SWLatitude, const double SWLongitude, const double NELatitude, const double NELongitude, const System::UnicodeString *tags, const System::NativeInt tags_High, const TSetOSMData Data = (TSetOSMData() << TOSMData::odNode << TOSMData::odWay ), const TBinaryFilterOSM Op = (TBinaryFilterOSM)(0x0), const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	void __fastcall Tag(const double SWLatitude, const double SWLongitude, const double NELatitude, const double NELongitude, const System::UnicodeString tag_name, const System::UnicodeString *tag_values, const System::NativeInt tag_values_High, const TSetOSMData Data = (TSetOSMData() << TOSMData::odNode << TOSMData::odWay ), const TBinaryFilterOSM Op = (TBinaryFilterOSM)(0x0), const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	void __fastcall amenity(const System::UnicodeString amenity_value = System::UnicodeString(), const TSetOSMData Data = (TSetOSMData() << TOSMData::odNode << TOSMData::odWay ), const System::UnicodeString bbox = System::UnicodeString(), const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	void __fastcall amenity(const double SWLatitude, const double SWLongitude, const double NELatitude, const double NELongitude, const System::UnicodeString amenity_value = System::UnicodeString(), const TSetOSMData Data = (TSetOSMData() << TOSMData::odNode << TOSMData::odWay ), const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	void __fastcall amenity(const System::UnicodeString *amenity_values, const System::NativeInt amenity_values_High, const TSetOSMData Data = (TSetOSMData() << TOSMData::odNode << TOSMData::odWay ), const TBinaryFilterOSM Op = (TBinaryFilterOSM)(0x0), const System::UnicodeString bbox = System::UnicodeString(), const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	void __fastcall amenity(const double SWLatitude, const double SWLongitude, const double NELatitude, const double NELongitude, const System::UnicodeString *amenity_values, const System::NativeInt amenity_values_High, const TSetOSMData Data = (TSetOSMData() << TOSMData::odNode << TOSMData::odWay ), const TBinaryFilterOSM Op = (TBinaryFilterOSM)(0x0), const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	void __fastcall Data(const System::UnicodeString bbox = System::UnicodeString(), const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	void __fastcall Data(const double SWLatitude, const double SWLongitude, const double NELatitude, const double NELongitude, const TECOnOverPass OnDataEvent = 0x0)/* overload */;
	__property System::UnicodeString Url = {read=FUrl, write=FUrl};
	__property int PendingQuery = {read=FPendingQuery, nodefault};
	__property Fmx::Uecnativeshape::TECShapePolygone* FilterPolygone = {read=FFilterPolygone, write=setFilterPolygone};
	__property int TimeOut = {read=FSecondeTimeOut, write=FSecondeTimeOut, nodefault};
	__property TECOnOverPass OnData = {read=FOnData, write=FOnData};
	__property TECOverPassApiLayer* Layer = {read=FECOverPassApiLayer};
};


class PASCALIMPLEMENTATION TECBoundary : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TNativeMapControl* FMap;
	Fmx::Uechttp::TuecHttp* FHttp;
	System::UnicodeString FPath;
	Fmx::Uecnativeshape::TECShapes* FShapes;
	System::Classes::TStringList* FList;
	System::UnicodeString FNominatimUrl;
	System::UnicodeString FOverPassUrl;
	Fmx::Uecnativeshape::TECShapesList* FShapeList;
	Fmx::Uecnativeshape::TIntegerRangeZoom* FAdminLevelFromZoom;
	__int64 FOSMId;
	System::Classes::TStringList* FOSMTags;
	TGetPolygoneFromID FGetPolygoneFromID;
	void __fastcall SetOverPassUrl(const System::UnicodeString Value);
	void __fastcall SetNominatimUrl(const System::UnicodeString Value);
	System::UnicodeString __fastcall GetAdminLevelFromZoom();
	void __fastcall SetAdminLevelFromZoom(const System::UnicodeString Value = System::UnicodeString());
	System::UnicodeString __fastcall getGroupName();
	void __fastcall setGroupName(const System::UnicodeString Value);
	int __fastcall NominatimQuery(const System::UnicodeString QueryParams);
	
public:
	__fastcall TECBoundary(TNativeMapControl* Map);
	__fastcall virtual ~TECBoundary();
	void __fastcall Clear();
	int __fastcall address(const System::UnicodeString Value, const int limit = 0x1);
	int __fastcall location(const double Lat, const double Lng, const System::Byte Zoom = (System::Byte)(0x12));
	int __fastcall Filter(const double Lat, const double Lng, const System::UnicodeString AreaFilter);
	int __fastcall Administrative(const double Lat, const double Lng, int level = 0x0);
	void __fastcall fitBounds();
	__property System::UnicodeString OverPassUrl = {read=FOverPassUrl, write=SetOverPassUrl};
	__property System::UnicodeString NominatimUrl = {read=FNominatimUrl, write=SetNominatimUrl};
	__property __int64 Id = {read=FOSMId};
	__property System::Classes::TStringList* tags = {read=FOSMTags};
	__property System::UnicodeString AdminLevelFromZoom = {read=GetAdminLevelFromZoom, write=SetAdminLevelFromZoom};
	__property Fmx::Uecnativeshape::TECShapes* Shapes = {read=FShapes};
	__property System::UnicodeString GroupName = {read=getGroupName, write=setGroupName};
	__property TGetPolygoneFromID GetPolygoneFromID = {read=FGetPolygoneFromID, write=FGetPolygoneFromID};
	__property Fmx::Uecnativeshape::TECShapesList* Items = {read=FShapeList};
};


class PASCALIMPLEMENTATION TECSnapDrag : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Fmx::Uecmaputil::TNativeMapObserver* FObserver;
	TNativeMapControl* FMap;
	Fmx::Uecnativeshape::TECShapes* FSnapGroup;
	Fmx::Uecnativeshape::TECShapeLine* FSnapLine;
	Fmx::Uecnativeshape::TECShapePOI* FSnapPOI;
	Fmx::Uecnativeshape::TECShapesList* FSnapMarkers;
	Fmx::Uecnativeshape::TECShapesList* FGuideLines;
	Fmx::Uecnativeshape::TECShape* FSnapGuide;
	bool FMultipleSelection;
	bool FTargetLine;
	System::Classes::TNotifyEvent FOnNoSnap;
	System::Classes::TNotifyEvent FOnSnap;
	TOnFutureSnap FOnFutureSnap;
	bool FMeterDistance;
	int FSnapDistance;
	Fmx::Uecnativeshape::TECShape* FSnapShape;
	double NLat;
	double NLng;
	double FPrevLat;
	double FPrevLng;
	Fmx::Uecnativeshape::TECShape* __fastcall getShape();
	void __fastcall Detach_Observer();
	void __fastcall WM_ShapeDrag(System::TObject* sender);
	void __fastcall WM_ShapeDragEnd(System::TObject* sender);
	void __fastcall WM_ShapeMouseDown(System::TObject* sender);
	void __fastcall FindNearestGuide(double &NLat, double &NLng);
	void __fastcall setTargetLine(const bool Value);
	
public:
	__fastcall TECSnapDrag();
	__fastcall virtual ~TECSnapDrag();
	void __fastcall ClearMarker();
	bool __fastcall AddMarker(Fmx::Uecnativeshape::TECShape* const Marker);
	void __fastcall RemoveMarker(Fmx::Uecnativeshape::TECShape* const Marker);
	void __fastcall SnapMarker(Fmx::Uecnativeshape::TECShape* const Marker);
	void __fastcall ClearGuide();
	bool __fastcall AddGuide(Fmx::Uecnativeshape::TECShapeLine* const Guide);
	void __fastcall RemoveGuide(Fmx::Uecnativeshape::TECShapeLine* const Guide);
	void __fastcall CancelSnap();
	__property bool MeterDistance = {read=FMeterDistance, write=FMeterDistance, nodefault};
	__property bool MultipleSelection = {read=FMultipleSelection, write=FMultipleSelection, nodefault};
	__property bool TargetLine = {read=FTargetLine, write=setTargetLine, nodefault};
	__property Fmx::Uecnativeshape::TECShape* SnapShape = {read=getShape};
	__property int SnapDistance = {read=FSnapDistance, write=FSnapDistance, nodefault};
	__property Fmx::Uecnativeshape::TECShape* SnapGuide = {read=FSnapGuide};
	__property System::Classes::TNotifyEvent OnSnap = {read=FOnSnap, write=FOnSnap};
	__property System::Classes::TNotifyEvent OnNoSnap = {read=FOnNoSnap, write=FOnNoSnap};
	__property TOnFutureSnap OnFutureSnap = {read=FOnFutureSnap, write=FOnFutureSnap};
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE System::UnicodeString __fastcall EncodeStyleValue(const System::UnicodeString Value);
}	/* namespace Uecnativemapcontrol */
}	/* namespace Fmx */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX_UECNATIVEMAPCONTROL)
using namespace Fmx::Uecnativemapcontrol;
#endif
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX)
using namespace Fmx;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Fmx_UecnativemapcontrolHPP
