﻿// CodeGear C++Builder
// Copyright (c) 1995, 2023 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'FMX.uecNativePlace.pas' rev: 36.00 (Windows)

#ifndef Fmx_UecnativeplaceHPP
#define Fmx_UecnativeplaceHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.SysUtils.hpp>
#include <System.Types.hpp>
#include <System.UITypes.hpp>
#include <System.Rtti.hpp>
#include <System.Classes.hpp>
#include <System.SyncObjs.hpp>
#include <System.Math.hpp>
#include <System.Generics.Collections.hpp>
#include <System.StrUtils.hpp>
#include <FMX.uecMapZip.hpp>
#include <FMX.uecMapUtil.hpp>
#include <FMX.uecOpenMapQuestServices.hpp>
#include <System.IOUtils.hpp>
#include <FMX.Dialogs.hpp>
#include <FMX.Types.hpp>
#include <FMX.Controls.hpp>
#include <FMX.Forms.hpp>
#include <FMX.Objects.hpp>
#include <FMX.Platform.hpp>
#include <System.Generics.Defaults.hpp>

//-- user supplied -----------------------------------------------------------

namespace Fmx
{
namespace Uecnativeplace
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TThreadedPoolPlaces;
class DELPHICLASS TECPlaceResult;
class DELPHICLASS TECPlaceResults;
class DELPHICLASS TECPlaces;
//-- type declarations -------------------------------------------------------
class PASCALIMPLEMENTATION TThreadedPoolPlaces : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	TECPlaces* FMap;
	System::Classes::TStringStream* datastream;
	System::Classes::TNotifyEvent FEvent;
	System::Syncobjs::TEvent* StartEvent;
	System::UnicodeString FLocalFilename;
	System::UnicodeString FLocalCache;
	bool FSynchro;
	bool FOnlyLocal;
	System::UnicodeString FTags;
	bool FAbort;
	bool FInSearch;
	void __fastcall doExecute();
	void __fastcall setLocalFilename(const System::UnicodeString value);
	
protected:
	virtual void __fastcall Execute();
	void __fastcall doEvent();
	
public:
	__fastcall TThreadedPoolPlaces(bool ACreateSuspended, System::Classes::TNotifyEvent Event, TECPlaces* const EMap, const System::UnicodeString Cache, const bool onlylocal);
	__fastcall virtual ~TThreadedPoolPlaces();
	void __fastcall Abort();
	void __fastcall Search(const System::UnicodeString value);
	__property bool InSearch = {read=FInSearch, nodefault};
	__property System::UnicodeString Localfilename = {read=FLocalFilename, write=setLocalFilename};
};


class PASCALIMPLEMENTATION TECPlaceResult : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	bool FIsTag;
	Fmx::Uecmaputil::TThreadStringList* FData;
	Fmx::Uecmaputil::TThreadStringList* FDetail;
	System::Classes::TStringList* FWay;
	double FLatitude;
	double FLongitude;
	System::UnicodeString __fastcall getResult(const System::UnicodeString key);
	void __fastcall setResult(const System::UnicodeString key, const System::UnicodeString value);
	System::UnicodeString __fastcall getNameResult(const int index);
	int __fastcall getCountResult();
	System::UnicodeString __fastcall getRawResult();
	
public:
	__fastcall TECPlaceResult(TECPlaces* EPlaces);
	__fastcall virtual ~TECPlaceResult();
	void __fastcall Assign(TECPlaceResult* value);
	__property System::UnicodeString Result[const System::UnicodeString key] = {read=getResult, write=setResult};
	__property System::UnicodeString NameResult[const int index] = {read=getNameResult};
	__property int CountResult = {read=getCountResult, nodefault};
	__property double Latitude = {read=FLatitude};
	__property double Longitude = {read=FLongitude};
	__property System::Classes::TStringList* Way = {read=FWay};
	__property Fmx::Uecmaputil::TThreadStringList* Data = {read=FData};
	__property System::UnicodeString RawResult = {read=getRawResult};
	__property bool isTag = {read=FIsTag, nodefault};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECPlaceResults : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECPlaceResult* operator[](int index) { return this->Result[index]; }
	
private:
	TECPlaces* FPlaces;
	System::Generics::Collections::TList__1<TECPlaceResult*>* FList;
	System::Syncobjs::TCriticalSection* FLock;
	TECPlaceResult* __fastcall getECPlaceResult(int index);
	
protected:
	__fastcall TECPlaceResults(TECPlaces* EPlace);
	
private:
	int __fastcall add(TECPlaceResult* const value);
	
public:
	__fastcall virtual ~TECPlaceResults();
	void __fastcall Lock();
	void __fastcall UnLock();
	void __fastcall Clear();
	int __fastcall Count();
	void __fastcall Delete(const int index);
	__property TECPlaceResult* Result[int index] = {read=getECPlaceResult/*, default*/};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECPlaces : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::Syncobjs::TCriticalSection* CritSect;
	bool FOnlyLocal;
	Fmx::Uecmapzip::TECMapZip* FMapZip;
	TThreadedPoolPlaces* FThreadedPoolPlaces;
	System::Classes::TNotifyEvent FOnPlacesSearch;
	System::UnicodeString FLocalCache;
	bool FJunction;
	int FDecimalPrecision;
	TECPlaceResults* FResults;
	System::UnicodeString FData;
	System::UnicodeString FXapiServer;
	System::UnicodeString FStatus;
	System::UnicodeString FAdress;
	double FLatSW;
	double FLngSW;
	double FLatNE;
	double FLngNE;
	double FLatitude;
	double FLongitude;
	int FMaxResult;
	int FItemDetail;
	int FRadius;
	bool FWay;
	unsigned FTimingSearch;
	void __fastcall setLatitude(const double value);
	void __fastcall setLongitude(const double value);
	void __fastcall doSearch(System::TObject* sender);
	bool __fastcall isSearching();
	void __fastcall setLocalCache(const System::UnicodeString value);
	void __fastcall setOnlyLocal(const bool value);
	bool __fastcall getSynchro();
	void __fastcall setSynchro(bool value);
	
public:
	__fastcall TECPlaces();
	__fastcall virtual ~TECPlaces();
	void __fastcall Abort();
	void __fastcall LoadFromFile(const System::UnicodeString filename);
	void __fastcall Search(const System::UnicodeString Tags);
	void __fastcall TextSearch(const System::UnicodeString TextQuery);
	__property System::UnicodeString Adress = {read=FAdress, write=FAdress};
	__property System::UnicodeString Status = {read=FStatus};
	__property int ItemDetail = {read=FItemDetail, nodefault};
	__property double Latitude = {read=FLatitude, write=setLatitude};
	__property double Longitude = {read=FLongitude, write=setLongitude};
	__property bool isWay = {read=FWay, nodefault};
	__property double LatSW = {read=FLatSW, write=FLatSW};
	__property double LngSW = {read=FLngSW, write=FLngSW};
	__property double LatNE = {read=FLatNE, write=FLatNE};
	__property double LngNE = {read=FLngNE, write=FLngNE};
	__property int DecimalPrecision = {read=FDecimalPrecision, write=FDecimalPrecision, nodefault};
	__property int Radius = {read=FRadius, write=FRadius, nodefault};
	__property bool Searching = {read=isSearching, nodefault};
	__property unsigned TimingSearch = {read=FTimingSearch, nodefault};
	__property int MaxResult = {read=FMaxResult, write=FMaxResult, nodefault};
	__property TECPlaceResults* Results = {read=FResults};
	__property System::UnicodeString Data = {read=FData};
	__property System::Classes::TNotifyEvent OnPlacesSearch = {read=FOnPlacesSearch, write=FOnPlacesSearch};
	__property System::UnicodeString XapiServer = {read=FXapiServer, write=FXapiServer};
	__property bool Junction = {read=FJunction, write=FJunction, nodefault};
	__property Fmx::Uecmapzip::TECMapZip* MapArchive = {read=FMapZip, write=FMapZip};
	__property System::UnicodeString LocalCache = {read=FLocalCache, write=setLocalCache};
	__property bool onlylocal = {read=FOnlyLocal, write=setOnlyLocal, nodefault};
	__property bool Synchro = {read=getSynchro, write=setSynchro, nodefault};
};


//-- var, const, procedure ---------------------------------------------------
}	/* namespace Uecnativeplace */
}	/* namespace Fmx */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX_UECNATIVEPLACE)
using namespace Fmx::Uecnativeplace;
#endif
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX)
using namespace Fmx;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Fmx_UecnativeplaceHPP
