﻿// CodeGear C++Builder
// Copyright (c) 1995, 2023 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'FMX.uecNativeTileServer.pas' rev: 36.00 (Windows)

#ifndef Fmx_UecnativetileserverHPP
#define Fmx_UecnativetileserverHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.SysUtils.hpp>
#include <System.Types.hpp>
#include <System.UITypes.hpp>
#include <System.Rtti.hpp>
#include <System.Classes.hpp>
#include <System.SyncObjs.hpp>
#include <System.UIConsts.hpp>
#include <FMX.Graphics.hpp>
#include <FMX.Dialogs.hpp>
#include <System.Threading.hpp>
#include <FMX.uecHttp.hpp>
#include <FMX.uecMapZip.hpp>
#include <FMX.uecBingRest.hpp>
#include <FMX.uecMapUtil.hpp>
#include <FMX.uecNativeShape.hpp>
#include <FMX.uecThreadGraphics.hpp>
#include <System.IOUtils.hpp>
#include <System.Generics.Collections.hpp>
#include <System.Generics.Defaults.hpp>
#include <FMX.Surfaces.hpp>
#include <FMX.Types.hpp>
#include <FMX.Controls.hpp>
#include <FMX.Forms.hpp>
#include <FMX.Objects.hpp>
#include <FMX.Platform.hpp>

//-- user supplied -----------------------------------------------------------

namespace Fmx
{
namespace Uecnativetileserver
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TFactoryGraphicTile;
class DELPHICLASS TTileServerInfo;
class DELPHICLASS TECProjection;
class DELPHICLASS TECProjectionEllipticalMercator;
class DELPHICLASS TNativeMapServer;
//-- type declarations -------------------------------------------------------
typedef void __fastcall (__closure *TOnLoadTile)(System::TObject* sender, const int x, const int y, const int z, const int t);

typedef bool __fastcall (*TOnTileFromCache)(const bool MoveOnTop, const System::UnicodeString _Mask);

typedef Fmx::Uecmaputil::TThreadStringList TPyramidCacheTile;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TFactoryGraphicTile : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Fmx::Uecmaputil::TThreadStringList* FTiles;
	
public:
	__fastcall TFactoryGraphicTile();
	__fastcall virtual ~TFactoryGraphicTile();
	Fmx::Uecmaputil::TGraphic* __fastcall Get();
	void __fastcall Release(Fmx::Uecmaputil::TGraphic* const value);
};

#pragma pack(pop)

enum DECLSPEC_DENUM TLegendPosition : unsigned char { lpTopLeft, lpTopRight, lpBottomLeft, lpBottomRight, lpTopCenter, lpBottomCenter, lpLeftCenter, lpRightCenter };

class PASCALIMPLEMENTATION TTileServerInfo : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Fmx::Uecmaputil::TStreamType StreamType;
	System::UnicodeString FHttp_Https;
	System::UnicodeString FStyle;
	System::UnicodeString FName;
	bool FBing;
	Fmx::Uecmaputil::TGraphic* FErrorTile;
	int FMaxReloadErrorTile;
	TNativeMapServer* FServer;
	System::Classes::TNotifyEvent FChangeServerTiles;
	System::Classes::TNotifyEvent FSaveChangeServerTiles;
	System::Classes::TNotifyEvent FUpdateSSL;
	System::Classes::TNotifyEvent FUpdateTimeout;
	System::Classes::TNotifyEvent FUpdate;
	System::Classes::TNotifyEvent FSaveUpdate;
	int FConnexionTimeout;
	int FResponseTimeout;
	Fmx::Uecmaputil::TECWorldInfo* FWorldInfo;
	System::UnicodeString FUrlWMS;
	System::UnicodeString FVersionWMS;
	System::UnicodeString FUrlLegendWMS;
	System::UnicodeString FLayersWMS;
	System::UnicodeString FSESPG;
	System::UnicodeString FTimeWMS;
	System::UnicodeString FStyleWMS;
	bool FLegendWMS;
	int FLegendXMarginWMS;
	int FLegendYMarginWMS;
	System::Byte FOpacityLegendWMS;
	TLegendPosition FLegendPosition;
	int FESPG;
	Fmx::Uecmaputil::TGraphic* FGraphicLegend;
	System::UnicodeString FUserAgent;
	System::Classes::TStringList* FMapStyles;
	bool FSSL;
	Fmx::Uecmaputil::TOnMapServerTilePath FGetTileFilename;
	Fmx::Uecmaputil::TOnMapServerTileStream FGetTileStream;
	System::UnicodeString _Name;
	Fmx::Uecmaputil::TOnMapServerTilePath _FGetTileFilename;
	void __fastcall setErrorTile(Fmx::Uecmaputil::TGraphic* const value);
	void __fastcall setStreamType(const Fmx::Uecmaputil::TStreamType value);
	void __fastcall setGetTileFilename(const Fmx::Uecmaputil::TOnMapServerTilePath value);
	void __fastcall setGetTileStream(const Fmx::Uecmaputil::TOnMapServerTileStream value);
	void __fastcall setName(const System::UnicodeString value);
	void __fastcall setStyle(const System::UnicodeString value);
	void __fastcall setSSL(const bool value);
	void __fastcall setConnexionTimout(const int value);
	void __fastcall setResponseTimeout(const int value);
	void __fastcall setUserAgent(const System::UnicodeString value);
	void __fastcall GetTileWMS(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall setTimeWMS(const System::UnicodeString value);
	void __fastcall setLegendWMS(bool value);
	void __fastcall setLegendXMarginWMS(int value);
	void __fastcall setLegendYMarginWMS(int value);
	void __fastcall setOpacityLegendWMS(System::Byte value);
	void __fastcall setLegendPosition(TLegendPosition value);
	void __fastcall setStyleWMS(const System::UnicodeString value);
	void __fastcall setVersionWMS(const System::UnicodeString value);
	
public:
	System::Byte MinZoom;
	System::Byte MaxZoom;
	System::UnicodeString Key;
	System::UnicodeString CopyRight;
	System::UnicodeString TilePath;
	bool LocalExt;
	bool LocalPath;
	__fastcall TTileServerInfo(Fmx::Uecmaputil::TECWorldInfo* WorldInfo);
	__fastcall virtual ~TTileServerInfo();
	void __fastcall AddWMSLayer(const System::UnicodeString url, const System::UnicodeString layers, const int ESPG = 0x10e6);
	void __fastcall DeleteWMSLayer();
	void __fastcall beginupdate();
	void __fastcall endupdate();
	__property System::UnicodeString WMS_Url = {read=FUrlWMS};
	__property System::UnicodeString WMS_UrlLegend = {read=FUrlLegendWMS};
	__property System::UnicodeString WMS_Layers = {read=FLayersWMS, write=FLayersWMS};
	__property System::UnicodeString WMS_Time = {read=FTimeWMS, write=setTimeWMS};
	__property System::UnicodeString WMS_Style = {read=FStyleWMS, write=setStyleWMS};
	__property bool WMS_Legend = {read=FLegendWMS, write=setLegendWMS, nodefault};
	__property int WMS_LegendXMargin = {read=FLegendXMarginWMS, write=setLegendXMarginWMS, nodefault};
	__property int WMS_LegendYMargin = {read=FLegendYMarginWMS, write=setLegendYMarginWMS, nodefault};
	__property System::Byte WMS_OpacityLegend = {read=FOpacityLegendWMS, write=setOpacityLegendWMS, nodefault};
	__property TLegendPosition WMS_LegendPosition = {read=FLegendPosition, write=setLegendPosition, nodefault};
	__property Fmx::Uecmaputil::TGraphic* WMS_GraphicLegend = {read=FGraphicLegend, write=FGraphicLegend};
	__property System::UnicodeString WMS_Version = {read=FVersionWMS, write=setVersionWMS};
	__property System::UnicodeString Name = {read=FName, write=setName};
	__property System::UnicodeString MapStyle = {read=FStyle, write=setStyle};
	__property System::UnicodeString Style = {read=FStyle, write=setStyle};
	__property Fmx::Uecmaputil::TOnMapServerTilePath GetTileFilename = {read=FGetTileFilename, write=setGetTileFilename};
	__property Fmx::Uecmaputil::TOnMapServerTileStream GetTileStream = {read=FGetTileStream, write=setGetTileStream};
	__property Fmx::Uecmaputil::TStreamType TileFormat = {read=StreamType, write=setStreamType, nodefault};
	__property bool SSL = {read=FSSL, write=setSSL, nodefault};
	__property int ConnexionTimeout = {read=FConnexionTimeout, write=setConnexionTimout, nodefault};
	__property int ResponseTimeout = {read=FResponseTimeout, write=setResponseTimeout, nodefault};
	__property System::UnicodeString UserAgent = {read=FUserAgent, write=setUserAgent};
	__property Fmx::Uecmaputil::TGraphic* ErrorTile = {read=FErrorTile, write=setErrorTile};
	__property int MaxReloadErrorTile = {read=FMaxReloadErrorTile, write=FMaxReloadErrorTile, nodefault};
	__property System::Classes::TStringList* MapStyles = {read=FMapStyles};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECProjection : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Fmx::Uecnativeshape::TECShapesGroup* FECShapesGroup;
	
public:
	__fastcall TECProjection(Fmx::Uecnativeshape::TECShapesGroup* const ShapesGroup);
	virtual void __fastcall getProjLatLngToXY(const double Lat, const double Lng, double &x, double &y);
	virtual void __fastcall getProjXYToLatLng(const double x, const double y, double &Lat, double &Lng);
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECProjection() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECProjectionEllipticalMercator : public TECProjection
{
	typedef TECProjection inherited;
	
private:
	Fmx::Uecmaputil::TECTilesCoordinatesConverter* FCoordConvertor;
	
public:
	__fastcall TECProjectionEllipticalMercator(Fmx::Uecnativeshape::TECShapesGroup* const ShapesGroup);
	__fastcall virtual ~TECProjectionEllipticalMercator();
	virtual void __fastcall getProjLatLngToXY(const double Lat, const double Lng, double &x, double &y);
	virtual void __fastcall getProjXYToLatLng(const double x, const double y, double &Lat, double &Lng);
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TNativeMapServer : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	bool FSynchronize;
	bool FFreeCache;
	Fmx::Uecmaputil::TGraphic* FErrorTile;
	TECProjection* FProjection;
	Fmx::Uecnativeshape::TECShapesGroup* FECShapesGroup;
	int FIntervalThreadPool;
	Fmx::Graphics::TCanvas* FCanvas;
	bool FDraw;
	bool FGoogleTraffic;
	System::UnicodeString FGoogleLang;
	System::UnicodeString FGoogleRegion;
	System::UnicodeString FGoogleStyles;
	System::UnicodeString FLocale;
	System::UnicodeString FGeoApifyKey;
	System::UnicodeString FOpenCycleMapKey;
	System::UnicodeString FDigitalGlobeToken;
	System::UnicodeString FMapBoxToken;
	System::UnicodeString FIgnKey;
	System::UnicodeString FTomTomKey;
	System::UnicodeString FVectorMapZenKey;
	System::UnicodeString FHereParam;
	System::UnicodeString FHereApp_id;
	System::UnicodeString FGoogleKey;
	System::UnicodeString FGoogleSession;
	System::UnicodeString FHereApp_code;
	System::UnicodeString FAqicnKey;
	System::UnicodeString FPTVKey;
	System::UnicodeString FStadiaMapsKey;
	System::UnicodeString FMapToolKitKey;
	Fmx::Uecbingrest::TecBingRest* FecBingRest;
	System::Syncobjs::TCriticalSection* FLock;
	TTileServerInfo* FTileServerInfo;
	Fmx::Uecmaputil::TThreadStringList* FTileVisible;
	System::Classes::TStringList* _FTileVisible;
	TPyramidCacheTile* FCache;
	System::Word F3CacheSize;
	System::Word F3QCacheSize;
	System::Word FCacheSize;
	System::Word FNeverthisCacheSize;
	Fmx::Uecmaputil::TWinControl* FParent;
	System::Classes::TMemoryStream* FMemoryFile;
	Fmx::Uecmaputil::TGraphic* FTile;
	Fmx::Uecmapzip::TECMapZip* FMapZip;
	Fmx::Uecthreadgraphics::TThreadSaveTile* FThreadSaveTile;
	System::Byte FIDThreadTilePool;
	Fmx::Uecthreadgraphics::TThreadTilePool* FThreadTilePool;
	Fmx::Uecthreadgraphics::TThreadTilePool* FThreadTilePoolB;
	Fmx::Uecthreadgraphics::TThreadTilePool* FThreadTilePoolC;
	Fmx::Uecthreadgraphics::TThreadTilePool* FThreadTilePoolD;
	Fmx::Uecthreadgraphics::TThreadSendObject* FThreadSendObject;
	TOnLoadTile FOnLoadTile;
	TOnLoadTile FOnErrorTile;
	System::Classes::TNotifyEvent FOnErrorConnexion;
	System::Classes::TNotifyEvent FOnClearCache;
	Fmx::Uechttp::TuecHttp* FDHttp;
	System::Classes::TMemoryStream* DStream;
	bool FStringGrid;
	bool FCancel;
	System::Classes::TStringList* FStringTile;
	Fmx::Graphics::TBitmap* FWaitTile;
	Fmx::Uecmaputil::TEcNotify* FNotify;
	Fmx::Surfaces::TBitmapSurface* FBitmapSurface;
	Fmx::Uecmaputil::TTileServer FSaveTileServer;
	Fmx::Uecmaputil::TTileServer FTileServer;
	Fmx::Uecmaputil::TOnMapServerTilePath FSaveTileFilename;
	Fmx::Uecmaputil::TOnMapServerTileStream FSaveTileStream;
	System::UnicodeString FSaveName;
	System::UnicodeString FSaveCopyright;
	System::UnicodeString FMASK_LocalTile;
	System::UnicodeString FMASK_Tile;
	System::UnicodeString FMASK_ZOOM;
	System::UnicodeString FMASK_SEPA;
	System::UnicodeString FMASK_SOURCE_X_Y_Z;
	System::UnicodeString FSaveLocalCache;
	System::UnicodeString FLocalCache;
	Fmx::Uecmaputil::TLocalCacheSetting FLocalCacheSetting;
	System::UnicodeString FTileServerInfoName;
	System::UnicodeString FPPI;
	System::UnicodeString FTileSize;
	bool FFirstRun;
	bool FFilterColors;
	System::UnicodeString FVariableName;
	bool FInCheckCacheSize;
	bool FDirectLoadLocalTile;
	Fmx::Uecmaputil::TNbrThreadTile FNbrThreadTile;
	bool FOnlyLocal;
	bool FPause;
	bool FTileOk;
	int FIntTileSize;
	int FLastZoom;
	double FMaxDayInCache;
	double FOpacity;
	void __fastcall setMaxDayInCache(double value);
	void __fastcall setSSL(const bool value);
	bool __fastcall getSSL();
	System::Word __fastcall GetCacheCount();
	void __fastcall SetCacheSize(const System::Word AValue);
	void __fastcall UpdateGoogleSession();
	void __fastcall SetTileServer(const Fmx::Uecmaputil::TTileServer value);
	void __fastcall setGoogleTraffic(const bool value);
	void __fastcall setGoogleStyles(const System::UnicodeString value);
	void __fastcall setGoogleLang(const System::UnicodeString value);
	void __fastcall setGoogleRegion(const System::UnicodeString value);
	Fmx::Uecmaputil::TOnProjectionLatLngToXY __fastcall getProjLatLngToXY();
	Fmx::Uecmaputil::TOnProjectionXYToLatLng __fastcall getProjXYToLatLng();
	bool __fastcall GetStringTileFromCache(const bool MoveOnTop, const System::UnicodeString _Mask);
	bool __fastcall GetTileFromCache(const bool MoveOnTop, const System::UnicodeString _Mask);
	void __fastcall doTileInfoAddCache(System::TObject* sender);
	bool __fastcall GetFromLocalCacheStream(int x, int y, int z, System::Classes::TMemoryStream* const stream);
	void __fastcall ReleaseToCache(Fmx::Uecmaputil::TTileServer source, int x, int y, int z);
	System::UnicodeString __fastcall getUrlTile(const int x, const int y, const int z)/* overload */;
	void __fastcall UpdateTileFormat(System::TObject* sender);
	void __fastcall UpdateSSL(System::TObject* sender);
	void __fastcall UpdateServerTiles(System::TObject* sender);
	void __fastcall UpdateServerTimeout(System::TObject* sender);
	void __fastcall setStringGrid(bool value);
	void __fastcall setCancel(bool value);
	void __fastcall setPause(bool value);
	void __fastcall setLocalCache(const System::UnicodeString value);
	void __fastcall setLocalCacheSetting(const Fmx::Uecmaputil::TLocalCacheSetting value);
	void __fastcall getTileStreamZ(const int ThreadIndex, System::Classes::TMemoryStream* &TileStream, const int x, const int y, const int z);
	void __fastcall setMapZip(Fmx::Uecmapzip::TECMapZip* ArchiveZip);
	void __fastcall GetBaseSnowMap(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetPisteSnowMap(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetIGN_Plan(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOpenRailWay(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetEmpty(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOSM(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOSMFr(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHotOSM(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall getCyclOSM(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOSMDe(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetVectorMapZen(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetTomTomBasic(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetTomTomSat(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetTomTomHybrid(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetTomTomNight(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetTomTomIncident(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetTomTomFlow(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetTopPlusWebOpen(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHyddaFull(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOpenMapQuest(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetArcGisWorldTopoMap(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetArcGisWorldImagery(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetArcGisWorldOceanBase(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetArcGisWorldStreetMap(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOpenMapQuestSat(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetCloudMade(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOpenCycleMap(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GeThunderForest(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetStadiaMaps(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetGeoapify(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOPNV(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetAqicn(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetMappilaryCoverage(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereNormal(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereTerrain(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHere(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetGoogle(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereSatellite(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereHybrid(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereMobile(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereHiRes(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereTransit(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereTruck(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereTruckTransparent(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereTraffic(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereFlow(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereReducedNight(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereNormalNight(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereXBNormalNight(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetYandexNormal(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetYandexSatellite(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetYandexHybrid(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetYandexPeople(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOpenTopoMap(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetMapBoxStreet(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetMapBoxSatellite(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetMapBoxStreetSatellite(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetMapBoxStreetBasic(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetMapBoxOutdoors(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetDigitalGlobeRecent(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetDigitalGlobeTerrain(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall setOpacity(const double value);
	void __fastcall setTileSize(const System::UnicodeString value);
	void __fastcall updateTileServerInfoName();
	void __fastcall setFilterColors(const bool value);
	
public:
	__fastcall TNativeMapServer(Fmx::Uecnativeshape::TECShapesGroup* ShapesGroup, Fmx::Uecmaputil::TWinControl* WinControl, int IntervalThread, Fmx::Uecmaputil::TColor BackColor);
	__fastcall virtual ~TNativeMapServer();
	void __fastcall CloneCache(TNativeMapServer* Master);
	void __fastcall Lock();
	void __fastcall UnLock();
	void __fastcall BeginDraw();
	void __fastcall EndDraw();
	void __fastcall CheckCacheSize();
	void __fastcall Repaint();
	void __fastcall setCustomHeader(const System::UnicodeString header, const System::UnicodeString value);
	void __fastcall setUseWinINET(const bool use);
	void __fastcall setProxyParams(const System::UnicodeString server, const int port, const System::UnicodeString username = System::UnicodeString(), System::UnicodeString password = System::UnicodeString());
	void __fastcall AddToCache(Fmx::Uecmaputil::TTileServer source, int x, int y, int z, System::Classes::TMemoryStream* const stream)/* overload */;
	void __fastcall AddToCache(Fmx::Uecmaputil::TTileServer source, Fmx::Uecthreadgraphics::TTileInfo* t)/* overload */;
	System::Byte __fastcall IsScreenComplete(const int StartX, const int StartY, const int MaxX, const int MaxY, const int z);
	void __fastcall DrawTile(const bool visible, const __int64 x, const __int64 y, const __int64 z, const __int64 tsize, const System::Types::TRectF &FRectMap, Fmx::Uecmaputil::TGraphic* Tile = (Fmx::Graphics::TBitmap*)(0x0), const bool _update = true);
	void __fastcall PrechargingTile(const int x, const int y, const int z, const bool clear = false);
	bool __fastcall DownLoadTile(const int x, const int y, const int z);
	void __fastcall FreeDownLoadTile();
	bool __fastcall GetStreamTile(System::Classes::TMemoryStream* &MemoryStream, const int x, const int y, const int z);
	void __fastcall PreChargingTiles(const int TileX, const int TileY, const int TileX2, const int TileY2, const int z);
	void __fastcall ChargingTileFromBounds(int z, double NorthEastLatitude, double NorthEastLongitude, double SouthWestLatitude, double SouthWestLongitude);
	System::UnicodeString __fastcall GetStringTile(int x, int y, int z);
	void __fastcall CancelActiveThread();
	void __fastcall ClearThread();
	void __fastcall ClearThreadNoPreload();
	void __fastcall ClearCache();
	void __fastcall Disconnect();
	int __fastcall LoadingTiles();
	int __fastcall LoadingViewTiles();
	void __fastcall setOnlyLocal(const bool value);
	int __fastcall AddTilesToListFromBounds(System::Classes::TStringList* &List, int z, double NorthEastLatitude, double NorthEastLongitude, double SouthWestLatitude, double SouthWestLongitude);
	void __fastcall reLoad();
	void __fastcall reLoadNoWait();
	__property System::UnicodeString VariableName = {read=FVariableName, write=FVariableName};
	__property Fmx::Uecbingrest::TecBingRest* BingRest = {read=FecBingRest};
	__property Fmx::Graphics::TCanvas* Canvas = {read=FCanvas, write=FCanvas};
	__property bool Draw = {read=FDraw, write=FDraw, nodefault};
	__property bool FilterColors = {read=FFilterColors, write=setFilterColors, nodefault};
	__property bool DirectLoadLocalTile = {read=FDirectLoadLocalTile, write=FDirectLoadLocalTile, nodefault};
	__property System::UnicodeString ThunderForestKey = {read=FOpenCycleMapKey, write=FOpenCycleMapKey};
	__property System::UnicodeString GeoApifyKey = {read=FGeoApifyKey, write=FGeoApifyKey};
	__property System::UnicodeString StadiaMapsKey = {read=FStadiaMapsKey, write=FStadiaMapsKey};
	__property System::UnicodeString MapToolKitKey = {read=FMapToolKitKey, write=FMapToolKitKey};
	__property System::UnicodeString MapBoxToken = {read=FMapBoxToken, write=FMapBoxToken};
	__property System::UnicodeString DigitalGlobeToken = {read=FDigitalGlobeToken, write=FDigitalGlobeToken};
	__property System::UnicodeString HereApp_id = {read=FHereApp_id, write=FHereApp_id};
	__property System::UnicodeString HereApp_code = {read=FHereApp_code, write=FHereApp_code};
	__property System::UnicodeString HereParam = {read=FHereParam, write=FHereParam};
	__property System::UnicodeString VectorMapZenKey = {read=FVectorMapZenKey, write=FVectorMapZenKey};
	__property System::UnicodeString TomTomKey = {read=FTomTomKey, write=FTomTomKey};
	__property System::UnicodeString PTVKey = {read=FPTVKey, write=FPTVKey};
	__property System::UnicodeString AqicnKey = {read=FAqicnKey, write=FAqicnKey};
	__property System::UnicodeString GoogleKey = {read=FGoogleKey, write=FGoogleKey};
	__property System::UnicodeString IgnKey = {read=FIgnKey, write=FIgnKey};
	__property System::Word CacheSize = {read=FCacheSize, write=SetCacheSize, nodefault};
	__property System::Word CacheCount = {read=GetCacheCount, nodefault};
	__property Fmx::Uecmapzip::TECMapZip* MapZip = {read=FMapZip, write=setMapZip};
	__property System::UnicodeString LocalCache = {read=FLocalCache, write=setLocalCache};
	__property Fmx::Uecmaputil::TLocalCacheSetting LocalCacheSetting = {read=FLocalCacheSetting, write=setLocalCacheSetting, nodefault};
	__property System::UnicodeString TileSize = {read=FTileSize, write=setTileSize};
	__property System::UnicodeString PPI = {read=FPPI, write=FPPI};
	__property Fmx::Uecmaputil::TGraphic* GraphicTile = {read=FTile};
	__property TPyramidCacheTile* CacheTile = {read=FCache};
	__property Fmx::Uecmaputil::TThreadStringList* TileVisible = {read=FTileVisible};
	__property int IntTileSize = {read=FIntTileSize, nodefault};
	__property bool GoogleTraffic = {read=FGoogleTraffic, write=setGoogleTraffic, nodefault};
	__property System::UnicodeString GoogleStyles = {read=FGoogleStyles, write=setGoogleStyles};
	__property System::UnicodeString GoogleLang = {read=FGoogleLang, write=setGoogleLang};
	__property System::UnicodeString GoogleRegion = {read=FGoogleRegion, write=setGoogleRegion};
	__property Fmx::Uecmaputil::TTileServer TileServer = {read=FTileServer, write=SetTileServer, default=4};
	__property TTileServerInfo* TileServerInfo = {read=FTileServerInfo};
	__property bool StringGrid = {read=FStringGrid, write=setStringGrid, nodefault};
	__property bool Cancel = {read=FCancel, write=setCancel, nodefault};
	__property bool Pause = {read=FPause, write=setPause, nodefault};
	__property bool TileOK = {read=FTileOk, write=FTileOk, nodefault};
	__property bool OnlyLocal = {read=FOnlyLocal, write=setOnlyLocal, nodefault};
	__property double Opacity = {read=FOpacity, write=setOpacity};
	__property TOnLoadTile OnLoadTile = {read=FOnLoadTile, write=FOnLoadTile};
	__property TOnLoadTile OnErrorTile = {read=FOnErrorTile, write=FOnErrorTile};
	__property System::Classes::TNotifyEvent OnErrorConnexion = {read=FOnErrorConnexion, write=FOnErrorConnexion};
	__property System::Classes::TNotifyEvent OnClearCache = {read=FOnClearCache, write=FOnClearCache};
	__property Fmx::Uecmaputil::TNbrThreadTile NbrThreadTile = {read=FNbrThreadTile, write=FNbrThreadTile, nodefault};
	__property Fmx::Uecmaputil::TEcNotify* Notify = {read=FNotify, write=FNotify};
	__property System::Classes::TStringList* StringTile = {read=FStringTile};
	__property System::UnicodeString MASK_SOURCE_X_Y_Z = {read=FMASK_SOURCE_X_Y_Z};
	__property Fmx::Uecmaputil::TOnProjectionLatLngToXY ProjLatLngToXY = {read=getProjLatLngToXY};
	__property Fmx::Uecmaputil::TOnProjectionXYToLatLng ProjXYToLatLng = {read=getProjXYToLatLng};
	__property bool SSL = {read=getSSL, write=setSSL, nodefault};
	__property bool Synchronize = {read=FSynchronize, write=FSynchronize, nodefault};
	__property double MaxDayInCache = {read=FMaxDayInCache, write=setMaxDayInCache};
};


//-- var, const, procedure ---------------------------------------------------
}	/* namespace Uecnativetileserver */
}	/* namespace Fmx */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX_UECNATIVETILESERVER)
using namespace Fmx::Uecnativetileserver;
#endif
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX)
using namespace Fmx;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Fmx_UecnativetileserverHPP
