﻿// CodeGear C++Builder
// Copyright (c) 1995, 2023 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'FMX.uecOpenLocationCode.pas' rev: 36.00 (Windows)

#ifndef Fmx_UecopenlocationcodeHPP
#define Fmx_UecopenlocationcodeHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.SysUtils.hpp>
#include <System.Types.hpp>
#include <System.UITypes.hpp>
#include <System.Rtti.hpp>
#include <System.Classes.hpp>
#include <System.StrUtils.hpp>
#include <System.SyncObjs.hpp>
#include <System.UIConsts.hpp>
#include <System.Math.hpp>
#include <System.Generics.Collections.hpp>
#include <System.Generics.Defaults.hpp>
#include <System.Math.Vectors.hpp>
#include <FMX.uecMapUtil.hpp>
#include <FMX.Types.hpp>

//-- user supplied -----------------------------------------------------------

namespace Fmx
{
namespace Uecopenlocationcode
{
//-- forward type declarations -----------------------------------------------
struct TecOLC_CODEAREA;
struct TecOLC_DECODE_PAIR_SEQUENCE;
class DELPHICLASS TecOpenLocationCode;
//-- type declarations -------------------------------------------------------
struct DECLSPEC_DRECORD TecOLC_CODEAREA
{
public:
	double latitudeLo;
	double longitudeLo;
	double latitudeHi;
	double longitudeHi;
	double latitudeCenter;
	double longitudeCenter;
	int codeLength;
};


struct DECLSPEC_DRECORD TecOLC_DECODE_PAIR_SEQUENCE
{
public:
	double value0;
	double value1;
};


typedef System::DynamicArray<double> TecOLC_PAIR_RESOLUTIONS;

class PASCALIMPLEMENTATION TecOpenLocationCode : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::WideChar FSEPARATOR;
	int FSEPARATOR_POSITION;
	System::WideChar FPADDING_CHARACTER;
	System::UnicodeString FCODE_ALPHABET;
	int FENCODING_BASE;
	double FLATITUDE_MAX;
	double FLONGITUDE_MAX;
	int FPAIR_CODE_LENGTH;
	TecOLC_PAIR_RESOLUTIONS FPAIR_RESOLUTIONS;
	int FGRID_COLUMNS;
	int FGRID_ROWS;
	double FGRID_SIZE_DEGREES;
	int FMIN_TRIMMABLE_CODE_LEN;
	double __fastcall clipLatitude(const double latitude);
	double __fastcall normalizeLongitude(const double longitude);
	double __fastcall computeLatitudePrecision(const int codeLength);
	System::UnicodeString __fastcall encodePairs(const double latitude, const double longitude, const int codeLength);
	System::UnicodeString __fastcall encodeGrid(const double latitude, const double longitude, const int codeLength);
	TecOLC_CODEAREA __fastcall decodePairs(const System::UnicodeString code);
	TecOLC_DECODE_PAIR_SEQUENCE __fastcall decodePairsSequence(const System::UnicodeString code, const int offset);
	TecOLC_CODEAREA __fastcall decodeGrid(const System::UnicodeString code);
	TecOLC_CODEAREA __fastcall CodeArea(const double latitudeLo, const double longitudeLo, const double latitudeHi, const double longitudeHi, const int codeLength);
	
public:
	__fastcall TecOpenLocationCode();
	System::UnicodeString __fastcall Encode(const double latitude, const double longitude, const int codeLength = 0xa);
	TecOLC_CODEAREA __fastcall Decode(const System::UnicodeString code);
	System::UnicodeString __fastcall Shorten(const System::UnicodeString code, const double latitude, const double longitude);
	System::UnicodeString __fastcall recoverNearest(const System::UnicodeString shortCode, const double referenceLatitude, const double referenceLongitude);
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TecOpenLocationCode() { }
	
};


//-- var, const, procedure ---------------------------------------------------
static const System::Int8 OLC_CODE_PRECISION_NORMAL = System::Int8(0xa);
static const System::Int8 OLC_CODE_PRECISION_EXTRA = System::Int8(0xb);
}	/* namespace Uecopenlocationcode */
}	/* namespace Fmx */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX_UECOPENLOCATIONCODE)
using namespace Fmx::Uecopenlocationcode;
#endif
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX)
using namespace Fmx;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Fmx_UecopenlocationcodeHPP
