﻿// CodeGear C++Builder
// Copyright (c) 1995, 2023 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'FMX.uecThreadGraphics.pas' rev: 36.00 (Windows)

#ifndef Fmx_UecthreadgraphicsHPP
#define Fmx_UecthreadgraphicsHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.SysUtils.hpp>
#include <System.Types.hpp>
#include <System.UITypes.hpp>
#include <System.Rtti.hpp>
#include <System.Classes.hpp>
#include <System.SyncObjs.hpp>
#include <System.UIConsts.hpp>
#include <System.Generics.Collections.hpp>
#include <System.Generics.Defaults.hpp>
#include <FMX.uecMapUtil.hpp>
#include <FMX.Surfaces.hpp>
#include <FMX.uecHttp.hpp>
#include <System.Net.URLClient.hpp>
#include <System.Net.HttpClient.hpp>
#include <FMX.Types.hpp>
#include <FMX.Controls.hpp>
#include <FMX.Forms.hpp>
#include <FMX.Objects.hpp>
#include <FMX.Platform.hpp>
#include <FMX.Graphics.hpp>

//-- user supplied -----------------------------------------------------------

namespace Fmx
{
namespace Uecthreadgraphics
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TNotifyEventGraphic;
class DELPHICLASS TMemoryStreamFactory;
class DELPHICLASS TRestData;
class DELPHICLASS TRestDataCreator;
class DELPHICLASS TThreadRest;
class DELPHICLASS TThreadSendObject;
class DELPHICLASS TTileInfo;
class DELPHICLASS TTileInfoFactory;
class DELPHICLASS TThreadTilePool;
class DELPHICLASS TThreadUriStream;
class DELPHICLASS TThreadTile;
class DELPHICLASS TThreadSaveTile;
class DELPHICLASS TThreadGraphicPool;
//-- type declarations -------------------------------------------------------
class PASCALIMPLEMENTATION TNotifyEventGraphic : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::Classes::TNotifyEvent Event;
public:
	/* TObject.Create */ inline __fastcall TNotifyEventGraphic() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TNotifyEventGraphic() { }
	
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TMemoryStreamFactory : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::Generics::Collections::TList__1<System::Classes::TMemoryStream*>* FStreams;
	System::Syncobjs::TCriticalSection* FCritSect;
	int FMaxCache;
	void __fastcall Lock();
	void __fastcall UnLock();
	void __fastcall Clear();
	
public:
	__fastcall TMemoryStreamFactory();
	__fastcall virtual ~TMemoryStreamFactory();
	System::Classes::TMemoryStream* __fastcall GetMemoryStream();
	void __fastcall ReleaseMemoryStream(System::Classes::TMemoryStream* const value);
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TRestData : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Fmx::Uechttp::TuecHttp* FHttp;
	TRestDataCreator* FParent;
	System::UnicodeString FUrl;
	System::Classes::TStringStream* FStringStream;
	System::Classes::TMemoryStream* FResponse;
	System::UnicodeString FStringResponse;
	System::Classes::TNotifyEvent FExecute;
	System::Classes::TNotifyEvent FNotify;
	System::TObject* FTAgObject;
	__int64 FTickCount;
	System::UnicodeString __fastcall getDataString();
	
public:
	__fastcall TRestData(TRestDataCreator* Parent);
	__fastcall virtual ~TRestData();
	void __fastcall Release();
	void __fastcall Abort();
	__property Fmx::Uechttp::TuecHttp* Http = {read=FHttp};
	__property System::UnicodeString Url = {read=FUrl};
	__property System::Classes::TMemoryStream* Response = {read=FResponse};
	__property System::UnicodeString StringResponse = {read=FStringResponse, write=FStringResponse};
	__property System::UnicodeString DataStringResponse = {read=getDataString};
	__property System::TObject* TagObject = {read=FTAgObject, write=FTAgObject};
	__property __int64 TickCount = {read=FTickCount};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TRestDataCreator : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::Generics::Collections::TList__1<TRestData*>* FRestDataCache;
	System::Syncobjs::TCriticalSection* FCritSect;
	int FMaxCache;
	Fmx::Uechttp::TuecHttp* FHttp;
	
public:
	__fastcall TRestDataCreator(Fmx::Uechttp::TuecHttp* const eHttp);
	__fastcall virtual ~TRestDataCreator();
	void __fastcall Clear();
	void __fastcall Lock();
	void __fastcall UnLock();
	TRestData* __fastcall getRestData(const System::UnicodeString Url, const System::Classes::TNotifyEvent eNotify, System::TObject* const eTagObject = (System::TObject*)(0x0))/* overload */;
	TRestData* __fastcall getRestData(const System::UnicodeString Url, const System::Classes::TNotifyEvent eNotify, const System::Classes::TNotifyEvent eExecute, System::TObject* const eTagObject = (System::TObject*)(0x0))/* overload */;
	void __fastcall releaseRestData(TRestData* const value);
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TThreadRest : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	Fmx::Uechttp::TuecHttp* FHttp;
	bool _FTerminated;
	TRestDataCreator* FRestDataCreator;
	System::Classes::TNotifyEvent FNotifyEvent;
	System::Syncobjs::TEvent* FEventJob;
	Fmx::Uecmaputil::TThreadStringList* FList;
	TRestData* FRestData;
	bool FWaitForJob;
	void __fastcall setWaitForJob(const bool value);
	__property bool WaitForJob = {read=FWaitForJob, write=setWaitForJob, nodefault};
	
protected:
	virtual void __fastcall Execute();
	void __fastcall DoRest();
	void __fastcall doSend();
	
public:
	__fastcall TThreadRest(bool ACreateSuspended, System::Classes::TNotifyEvent Event);
	__int64 __fastcall Add(const System::UnicodeString Url, const System::Classes::TNotifyEvent eNotify, System::TObject* const eTagObject = (System::TObject*)(0x0))/* overload */;
	__int64 __fastcall Add(const System::UnicodeString Url, const System::Classes::TNotifyEvent eNotify, const System::Classes::TNotifyEvent eExecute, System::TObject* const eTagObject = (System::TObject*)(0x0))/* overload */;
	void __fastcall Remove(const System::UnicodeString Url);
	int __fastcall Count();
	void __fastcall Clear();
	__fastcall virtual ~TThreadRest();
	void __fastcall doTermine();
	__property Terminated;
};


class PASCALIMPLEMENTATION TThreadSendObject : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	bool _FTerminated;
	System::Classes::TNotifyEvent FNotifyEvent;
	System::Syncobjs::TEvent* FEventJob;
	Fmx::Uecmaputil::TThreadStringList* FList;
	bool FWaitForJob;
	System::TObject* FSendObject;
	void __fastcall setWaitForJob(const bool value);
	__property bool WaitForJob = {read=FWaitForJob, write=setWaitForJob, nodefault};
	
protected:
	virtual void __fastcall Execute();
	void __fastcall DoRest();
	void __fastcall doSend();
	
public:
	__fastcall TThreadSendObject(bool ACreateSuspended, System::Classes::TNotifyEvent Event);
	bool __fastcall Add(System::TObject* const value);
	void __fastcall Remove(System::TObject* const value);
	void __fastcall Clear();
	int __fastcall Count();
	__fastcall virtual ~TThreadSendObject();
	void __fastcall doTermine();
	__property Terminated;
};


class PASCALIMPLEMENTATION TTileInfo : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TTileInfoFactory* FTileInfoFactory;
	System::UnicodeString FZXY;
	System::UnicodeString FStyle;
	System::UnicodeString FServerName;
	System::UnicodeString FLocalFilename;
	System::UnicodeString FUrl;
	Fmx::Uecmaputil::TTileServer FTileServer;
	int FThreadIndex;
	int FErrorCode;
	int FX;
	int FY;
	int FZ;
	bool FIsRecentFile;
	bool FIsUrl;
	bool FError;
	Fmx::Uecmaputil::TGraphic* FErrorTile;
	int FMaxReloadErrorTile;
	System::Classes::TMemoryStream* FStream;
	Fmx::Uecmaputil::TStreamType FStreamType;
	Fmx::Uecmaputil::TOnMapServerTilePath FGetTileFilename;
	Fmx::Uecmaputil::TOnMapServerTileStream FGetTileStream;
	bool FLast;
	bool FSave;
	void __fastcall setStream(System::Classes::TMemoryStream* const value);
	
public:
	__fastcall virtual ~TTileInfo();
	void __fastcall Release();
	__property bool isUrl = {read=FIsUrl, write=FIsUrl, nodefault};
	__property bool IsRecentFile = {read=FIsRecentFile, write=FIsRecentFile, nodefault};
	__property int X = {read=FX, write=FX, nodefault};
	__property int Y = {read=FY, write=FY, nodefault};
	__property int Z = {read=FZ, write=FZ, nodefault};
	__property System::UnicodeString ZXY = {read=FZXY, write=FZXY};
	__property System::UnicodeString Url = {read=FUrl, write=FUrl};
	__property int ThreadIndex = {read=FThreadIndex, nodefault};
	__property bool Save = {read=FSave, write=FSave, nodefault};
	__property bool Last = {read=FLast, nodefault};
	__property bool Error = {read=FError, write=FError, nodefault};
	__property int ErrorCode = {read=FErrorCode, write=FErrorCode, nodefault};
	__property int MaxReloadErrorTile = {read=FMaxReloadErrorTile, write=FMaxReloadErrorTile, nodefault};
	__property Fmx::Uecmaputil::TGraphic* ErrorTile = {read=FErrorTile, write=FErrorTile};
	__property Fmx::Uecmaputil::TTileServer TileServer = {read=FTileServer, write=FTileServer, nodefault};
	__property System::Classes::TMemoryStream* Stream = {read=FStream, write=setStream};
	__property Fmx::Uecmaputil::TStreamType StreamType = {read=FStreamType, nodefault};
	__property System::UnicodeString Style = {read=FStyle, write=FStyle};
	__property System::UnicodeString ServerName = {read=FServerName, write=FServerName};
	__property System::UnicodeString LocalFilename = {read=FLocalFilename, write=FLocalFilename};
	__property Fmx::Uecmaputil::TOnMapServerTileStream GetTileStream = {read=FGetTileStream, write=FGetTileStream};
	__property Fmx::Uecmaputil::TOnMapServerTilePath GetTileFilename = {read=FGetTileFilename, write=FGetTileFilename};
public:
	/* TObject.Create */ inline __fastcall TTileInfo() : System::TObject() { }
	
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TTileInfoFactory : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::Generics::Collections::TList__1<TTileInfo*>* FTiles;
	System::Syncobjs::TCriticalSection* FCritSect;
	int FMaxCache;
	void __fastcall Lock();
	void __fastcall UnLock();
	
public:
	__fastcall TTileInfoFactory();
	__fastcall virtual ~TTileInfoFactory();
	void __fastcall Clear();
	TTileInfo* __fastcall GetTileInfo();
	void __fastcall ReleaseTileInfo(TTileInfo* value);
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TThreadTilePool : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	TTileInfoFactory* FTileInfoFactory;
	int FThreadIndex;
	int FConnexionTimeOut;
	int FResponseTimeOut;
	int FGetCount;
	bool FLoading;
	unsigned DownloadTime;
	bool _FTerminated;
	System::Classes::TNotifyEvent FNotifyEvent;
	System::Syncobjs::TEvent* FEventJob;
	System::Syncobjs::TEvent* FEventPause;
	System::Syncobjs::TEvent* FEvent;
	unsigned FInterval;
	Fmx::Uecmaputil::TThreadStringList* FList;
	System::UnicodeString FUserAgent;
	bool FUSE_WININET;
	void *FNetHandle;
	System::Classes::TStringList* FCustomHeaders;
	System::Net::Httpclient::THTTPClient* IdHTTP;
	System::Net::Httpclient::_di_IHTTPResponse IdResponse;
	TTileInfo* FSendTileInfo;
	TTileInfo* FTileInfo;
	Fmx::Uecmaputil::TThreadStringList* FSendList;
	bool FisDownLoad;
	bool FWaitForJob;
	bool FPause;
	void __fastcall setPause(const bool value);
	void __fastcall setWaitForJob(const bool value);
	void __fastcall setConnexionTimout(const int value);
	void __fastcall setResponseTimout(const int value);
	void __fastcall setUserAgent(const System::UnicodeString value);
	__property bool WaitForJob = {read=FWaitForJob, write=setWaitForJob, nodefault};
	bool __fastcall GetisDownLoad();
	
protected:
	virtual void __fastcall Execute();
	void __fastcall DoStream();
	bool __fastcall doDownLoad();
	void __fastcall doSend();
	void __fastcall doExternStream();
	
public:
	__fastcall TThreadTilePool(int ThreadIndex, bool ACreateSuspended, unsigned AInterval, System::Classes::TNotifyEvent Event, Fmx::Uecmaputil::TThreadStringList* SendList);
	bool __fastcall get(const System::UnicodeString Url, Fmx::Uecmaputil::TTileServer TileServer, int X, int Y, int Z, const System::UnicodeString local_filename = System::UnicodeString(), Fmx::Uecmaputil::TOnMapServerTileStream FGetTileStream = 0x0)/* overload */;
	bool __fastcall get(TTileInfo* TileInfo)/* overload */;
	void __fastcall Add(const System::UnicodeString Url, Fmx::Uecmaputil::TTileServer TileServer, int X, int Y, int Z, const System::UnicodeString local_filename = System::UnicodeString(), Fmx::Uecmaputil::TOnMapServerTileStream FGetTileStream = 0x0, const System::UnicodeString ZXY = System::UnicodeString())/* overload */;
	void __fastcall Add(TTileInfo* TileInfo)/* overload */;
	void __fastcall Remove(TTileInfo* TileInfo);
	bool __fastcall isPending(const System::UnicodeString Url);
	void __fastcall Clear();
	void __fastcall ForceDisconnect();
	void __fastcall setProxyParams(const System::UnicodeString server, const int port, const System::UnicodeString username = System::UnicodeString(), System::UnicodeString password = System::UnicodeString());
	void __fastcall setCustomHeader(const System::UnicodeString header, const System::UnicodeString value);
	System::UnicodeString __fastcall getCustomHeader(const System::UnicodeString header);
	int __fastcall Count();
	__fastcall virtual ~TThreadTilePool();
	void __fastcall doTermine();
	__property Terminated;
	__property TTileInfoFactory* TileInfoFactory = {read=FTileInfoFactory};
	__property bool isDownLoad = {read=GetisDownLoad, nodefault};
	__property int GetCount = {read=FGetCount, nodefault};
	__property bool Pause = {read=FPause, write=setPause, nodefault};
	__property System::Classes::TNotifyEvent NotifyEvent = {read=FNotifyEvent, write=FNotifyEvent};
	__property bool USE_WININET = {read=FUSE_WININET, write=FUSE_WININET, nodefault};
	__property int ConnexionTimeOut = {read=FConnexionTimeOut, write=setConnexionTimout, nodefault};
	__property int ResponseTimeOut = {read=FResponseTimeOut, write=setResponseTimout, nodefault};
	__property System::UnicodeString UserAgent = {read=FUserAgent, write=setUserAgent};
};


class PASCALIMPLEMENTATION TThreadUriStream : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	System::UnicodeString FUrl;
	System::UnicodeString FData;
	System::UnicodeString FUri;
	bool FBusy;
	bool FImg;
	bool FCancel;
	System::Classes::TMemoryStream* FStream;
	System::Classes::TNotifyEvent FNotifyEvent;
	System::Classes::TNotifyEvent FUpdate;
	void __fastcall setCancel(bool value);
	
public:
	__fastcall TThreadUriStream(bool ACreateSuspended, const System::UnicodeString Url, const System::UnicodeString _Data, const bool img, System::Classes::TNotifyEvent NotifyEvent, System::Classes::TNotifyEvent NUpdate);
	__fastcall virtual ~TThreadUriStream();
	virtual void __fastcall Execute();
	void __fastcall doSend();
	__property System::Classes::TMemoryStream* Stream = {read=FStream};
	__property System::UnicodeString Data = {read=FData};
	__property System::UnicodeString Uri = {read=FUri};
	__property System::UnicodeString Url = {read=FUrl};
	__property System::Classes::TNotifyEvent Update = {read=FUpdate};
	__property bool img = {read=FImg, nodefault};
	__property bool Cancel = {read=FCancel, write=setCancel, nodefault};
};


class PASCALIMPLEMENTATION TThreadTile : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	System::UnicodeString FUrl;
	bool FBusy;
	Fmx::Uecmaputil::TTileServer FTileServer;
	bool FCancel;
	int FX;
	int FY;
	int FZ;
	void *FNetHandle;
	System::Classes::TMemoryStream* FStream;
	System::Classes::TNotifyEvent FNotifyEvent;
	System::Net::Httpclient::THTTPClient* IdHTTP;
	void __fastcall setCancel(bool value);
	
public:
	__fastcall TThreadTile(bool ACreateSuspended, const System::UnicodeString Url, Fmx::Uecmaputil::TTileServer _TileServer, int X, int Y, int Z, System::Classes::TNotifyEvent NotifyEvent);
	__fastcall virtual ~TThreadTile();
	virtual void __fastcall Execute();
	void __fastcall doSend();
	__property System::Classes::TMemoryStream* Stream = {read=FStream};
	__property int X = {read=FX, nodefault};
	__property int Y = {read=FY, nodefault};
	__property int Z = {read=FZ, nodefault};
	__property bool Cancel = {read=FCancel, write=setCancel, nodefault};
	__property Fmx::Uecmaputil::TTileServer TileServer = {read=FTileServer, write=FTileServer, nodefault};
};


class PASCALIMPLEMENTATION TThreadSaveTile : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	bool _FTerminated;
	System::Syncobjs::TEvent* FEvent;
	unsigned FInterval;
	Fmx::Uecmaputil::TThreadStringList* FList;
	void __fastcall doSave();
	
protected:
	virtual void __fastcall Execute();
	
public:
	__fastcall TThreadSaveTile(bool ACreateSuspended, unsigned AInterval);
	void __fastcall Add(const System::UnicodeString filename, TTileInfo* const tile);
	void __fastcall Remove(const System::UnicodeString filename);
	void __fastcall Clear();
	__fastcall virtual ~TThreadSaveTile();
	void __fastcall doTermine();
	__property Terminated;
};


class PASCALIMPLEMENTATION TThreadGraphicPool : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	Fmx::Uechttp::TuecHttp* FecHttp;
	Fmx::Uecmaputil::TGraphic* FErrorTile;
	bool _FTerminated;
	int FOkForSend;
	System::Syncobjs::TEvent* FEventJob;
	System::Syncobjs::TEvent* FEventPause;
	System::Syncobjs::TEvent* FEvent;
	unsigned FInterval;
	System::Classes::TMemoryStream* FStream;
	Fmx::Uecmaputil::TThreadStringList* FSends;
	Fmx::Uecmaputil::TThreadStringList* FList;
	System::Generics::Collections::TDictionary__2<System::UnicodeString,Fmx::Graphics::TBitmap*>* FGraphics;
	Fmx::Uecmaputil::TThreadStringList* FStreams;
	System::UnicodeString FUrl;
	bool FWaitForJob;
	bool FPause;
	void __fastcall setPause(const bool value);
	void __fastcall setWaitForJob(const bool value);
	__property bool WaitForJob = {read=FWaitForJob, write=setWaitForJob, nodefault};
	
protected:
	virtual void __fastcall Execute();
	void __fastcall DoGraphic();
	void __fastcall doSend();
	void __fastcall setGraphic(const System::UnicodeString url_Filename, Fmx::Uecmaputil::TGraphic* const graphic);
	Fmx::Uecmaputil::TGraphic* __fastcall getGraphic(const System::UnicodeString url_Filename);
	
public:
	__fastcall TThreadGraphicPool(bool ACreateSuspended, unsigned AInterval, Fmx::Uecmaputil::TGraphic* const AErrorTile, System::Classes::TNotifyEvent Event);
	void __fastcall Add(const System::UnicodeString Url);
	void __fastcall Delete(const System::UnicodeString Url);
	void __fastcall AddTop(const System::UnicodeString Url);
	void __fastcall Remove(const System::UnicodeString Url, const bool FreeGraphic = true);
	void __fastcall Clear();
	void __fastcall ClearAndFree();
	bool __fastcall isValid(const System::UnicodeString Url);
	int __fastcall Count();
	int __fastcall GraphicCount();
	void __fastcall Attach(System::Classes::TNotifyEvent Event);
	void __fastcall Detach(System::Classes::TNotifyEvent Event);
	__fastcall virtual ~TThreadGraphicPool();
	void __fastcall doTermine();
	__property Terminated;
	__property Fmx::Uecmaputil::TGraphic* graphic[const System::UnicodeString index] = {read=getGraphic, write=setGraphic};
	__property System::UnicodeString Url = {read=FUrl};
	__property bool Pause = {read=FPause, write=setPause, nodefault};
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE void *_GLobal_NetHandle;
extern DELPHI_PACKAGE TThreadGraphicPool* __fastcall GetThreadGraphicPool(System::Classes::TNotifyEvent Event);
extern DELPHI_PACKAGE void __fastcall ReleaseThreadGraphicPool(System::Classes::TNotifyEvent Event);
}	/* namespace Uecthreadgraphics */
}	/* namespace Fmx */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX_UECTHREADGRAPHICS)
using namespace Fmx::Uecthreadgraphics;
#endif
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_FMX)
using namespace Fmx;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Fmx_UecthreadgraphicsHPP
