﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'StrBuffer.pas' rev: 37.00 (Windows)

#ifndef StrBufferHPP
#define StrBufferHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <System.SysUtils.hpp>

//-- user supplied -----------------------------------------------------------

namespace Strbuffer
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TStrBuffer;
struct TSegment;
class DELPHICLASS TSegmentBuffer;
//-- type declarations -------------------------------------------------------
#pragma pack(push,4)
class PASCALIMPLEMENTATION TStrBuffer : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	int FCount;
	int FCapacity;
	char *FBuff;
	
protected:
	__classmethod void __fastcall Error(const System::UnicodeString Msg, int Data);
	
public:
	__fastcall TStrBuffer();
	__fastcall virtual ~TStrBuffer();
	void __fastcall SaveToStream(System::Classes::TStream* Stream);
	void __fastcall SaveToFile(const System::UnicodeString FileName);
	void __fastcall LoadFromFile(const System::UnicodeString FileName);
	void __fastcall LoadFromStream(System::Classes::TStream* Stream);
	void __fastcall Clear();
	void __fastcall Add(const System::AnsiString aValue)/* overload */;
	void __fastcall SetCapacity(int NewCapacity);
	System::AnsiString __fastcall GetText();
	int __fastcall GetCount();
};

#pragma pack(pop)

typedef TSegment *PSegment;

struct DECLSPEC_DRECORD TSegment
{
public:
	PSegment Next;
	int Size;
	int Count;
	System::StaticArray<char, 1> Data;
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TSegmentBuffer : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	int FCount;
	int FCapacity;
	PSegment FFirst;
	PSegment FLast;
	
protected:
	__classmethod void __fastcall Error(const System::UnicodeString Msg, int Data);
	
public:
	__fastcall TSegmentBuffer();
	__fastcall virtual ~TSegmentBuffer();
	void __fastcall SaveToStream(System::Classes::TStream* Stream);
	void __fastcall SaveToFile(const System::UnicodeString FileName);
	void __fastcall LoadFromFile(const System::UnicodeString FileName);
	void __fastcall LoadFromStream(System::Classes::TStream* Stream);
	void __fastcall Clear();
	void __fastcall AddSegment(int aSize);
	void __fastcall Add(const char aValue)/* overload */;
	void __fastcall Add(const System::AnsiString aValue)/* overload */;
	void __fastcall Add(const char * aValue, int aCnt)/* overload */;
	System::AnsiString __fastcall GetText();
	int __fastcall GetCount();
	__property System::AnsiString Text = {read=GetText};
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
static _DELPHI_CONST int MaxBuffSize = int(0x7ffffff);
#define SBufferIndexError L"Buffer index out of bounds (%d)"
#define SBufferCapacityError L"Buffer capacity out of bounds (%d)"
#define SBufferCountError L"Buffer count out of bounds (%d)"
}	/* namespace Strbuffer */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_STRBUFFER)
using namespace Strbuffer;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// StrBufferHPP
