﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'UECGraphics.pas' rev: 37.00 (Windows)

#ifndef UECGraphicsHPP
#define UECGraphicsHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <Vcl.Forms.hpp>
#include <Winapi.Messages.hpp>
#include <System.SysUtils.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <Vcl.Controls.hpp>
#include <UECMapUtil.hpp>
#include <System.Math.hpp>
#include <System.Generics.Collections.hpp>
#include <System.Generics.Defaults.hpp>
#include <Vcl.Direct2D.hpp>
#include <Winapi.D2D1.hpp>
#include <Winapi.Wincodec.hpp>
#include <vector_tile.hpp>
#include <System.RegularExpressions.hpp>
#include <System.Threading.hpp>
#include <Vcl.ExtCtrls.hpp>
#include <Vcl.Imaging.pngimage.hpp>
#include <Vcl.Imaging.jpeg.hpp>
#include <jhHTMLGraphics.hpp>
#include <System.UITypes.hpp>
#include <System.Types.hpp>

//-- user supplied -----------------------------------------------------------

namespace Uecgraphics
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TECGraph;
class DELPHICLASS TVectorIcon;
class DELPHICLASS TVectorText;
class DELPHICLASS TECCanvas;
struct TCustomVectorExpressionValue;
class DELPHICLASS TFactoryExpression;
struct TZoomValue;
class DELPHICLASS TPropertyGet;
class DELPHICLASS TBaseExpression;
class DELPHICLASS TZoomExpression;
class DELPHICLASS TMatchExpression;
class DELPHICLASS TCaseExpression;
class DELPHICLASS TCoalesceExpression;
class DELPHICLASS TConCatExpression;
class DELPHICLASS TNotExpression;
class DELPHICLASS TBooleanExpression;
class DELPHICLASS TNumberExpression;
class DELPHICLASS TCompareExpression;
class DELPHICLASS TAllExpression;
class DELPHICLASS TAnyExpression;
class DELPHICLASS TResolvedImageExpression;
class DELPHICLASS TInterpolateExpression;
class DELPHICLASS TGetExpression;
class DELPHICLASS THasExpression;
class DELPHICLASS TInExpression;
class DELPHICLASS TCustomVectorExpression;
class DELPHICLASS TColorVectorExpression;
class DELPHICLASS TIntegerVectorExpression;
class DELPHICLASS TDoubleVectorExpression;
class DELPHICLASS TCustomVectorPainter;
class DELPHICLASS TCustomVectorFilter;
class DELPHICLASS TVectorPaint;
class DELPHICLASS TPropertyVectorFilter;
class DELPHICLASS TPropertyVectorFilters;
class DELPHICLASS TVectorLayerStyleRule;
class DELPHICLASS TVectorLayerStyleRules;
class DELPHICLASS TVectorIndexSprite;
class DELPHICLASS TVectorSprite;
class DELPHICLASS TVectorLayer;
class DELPHICLASS TVectorLayers;
class DELPHICLASS TVectorStyles;
//-- type declarations -------------------------------------------------------
typedef System::StaticArray<tagRGBTRIPLE, 65536> TRGBTripleArray;

typedef TRGBTripleArray *pRGBTripleArray;

class PASCALIMPLEMENTATION TECGraph : public System::TObject
{
	typedef System::TObject inherited;
	
	
private:
	typedef System::DynamicArray<System::Types::TPoint> _TECGraph__1;
	
	typedef System::DynamicArray<double> _TECGraph__2;
	
	typedef System::DynamicArray<double> _TECGraph__3;
	
	
private:
	int FYLegend;
	bool FIsSetupOK;
	double MinX;
	double MaxX;
	double MinY;
	double MaxY;
	double ScaleX;
	double ScaleY;
	_TECGraph__1 Points;
	double TickSpacingX;
	double TickSpacingY;
	int FMouseY;
	int FMouseX;
	double FAltitudeX;
	double FDistanceX;
	int FMArginY;
	System::UnicodeString FAltLegende;
	System::UnicodeString FDistLegende;
	Vcl::Graphics::TBitmap* FBitmap;
	float FScreenScale;
	System::Uitypes::TColor FBackGroundColor;
	System::Uitypes::TColor FGraphColor;
	System::Uitypes::TColor FAxeColor;
	int FFontSize;
	int FMaxTickX;
	int FMaxTickY;
	int FLeft;
	int FTop;
	int FWidth;
	int FHeight;
	int FMarginX;
	int FBeginIndex;
	int FEndIndex;
	bool __fastcall setup();
	void __fastcall DrawGraph(Vcl::Direct2d::TDirect2DCanvas* Canvas)/* overload */;
	void __fastcall DrawGraph(Vcl::Graphics::TCanvas* Canvas)/* overload */;
	int __fastcall getMarginY();
	
public:
	_TECGraph__2 Distances;
	_TECGraph__3 Altitudes;
	__fastcall TECGraph();
	__fastcall virtual ~TECGraph();
	Vcl::Graphics::TBitmap* __fastcall BlankBitmap();
	Vcl::Graphics::TBitmap* __fastcall GetBitmapGraph();
	bool __fastcall isDrawPointAxis();
	void __fastcall setMouseXY(int AX, int AY);
	double __fastcall GetAltitudeFromDistance(const double DistanceKM);
	int __fastcall GetXFromDistance(const double DistanceKM);
	int __fastcall GetIndexFromDistance(const double DistanceKM);
	__property int MouseX = {read=FMouseX, nodefault};
	__property int MouseY = {read=FMouseY, nodefault};
	__property double DistanceX = {read=FDistanceX};
	__property double AltitudeX = {read=FAltitudeX};
	__property int MArginY = {read=getMarginY, write=FMArginY, nodefault};
	__property System::UnicodeString AltLegende = {read=FAltLegende, write=FAltLegende};
	__property System::UnicodeString DistLegende = {read=FDistLegende, write=FDistLegende};
	__property float ScreenScale = {read=FScreenScale, write=FScreenScale};
	__property System::Uitypes::TColor BackGroundColor = {read=FBackGroundColor, write=FBackGroundColor, nodefault};
	__property System::Uitypes::TColor GraphColor = {read=FGraphColor, write=FGraphColor, nodefault};
	__property System::Uitypes::TColor AxeColor = {read=FAxeColor, write=FAxeColor, nodefault};
	__property int FontSize = {read=FFontSize, write=FFontSize, nodefault};
	__property int MaxTickX = {read=FMaxTickX, write=FMaxTickX, nodefault};
	__property int MaxTickY = {read=FMaxTickY, write=FMaxTickY, nodefault};
	__property int Left = {read=FLeft, write=FLeft, nodefault};
	__property int Top = {read=FTop, write=FTop, nodefault};
	__property int Width = {read=FWidth, write=FWidth, nodefault};
	__property int Height = {read=FHeight, write=FHeight, nodefault};
	__property int MarginX = {read=FMarginX, write=FMarginX, nodefault};
	__property int BeginIndex = {read=FBeginIndex, write=FBeginIndex, nodefault};
	__property int EndIndex = {read=FEndIndex, write=FEndIndex, nodefault};
};


class PASCALIMPLEMENTATION TVectorIcon : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::Types::TRect FRect;
	int FX;
	int FY;
	int FW;
	int FH;
	int FIX;
	int FIY;
	double FIW;
	double FIH;
	double FZindex;
	
public:
	__property System::Types::TRect Rect = {read=FRect, write=FRect};
	__property int X = {read=FX, write=FX, nodefault};
	__property int Y = {read=FY, write=FY, nodefault};
	__property int W = {read=FW, write=FW, nodefault};
	__property int H = {read=FH, write=FH, nodefault};
	__property int iX = {read=FIX, write=FIX, nodefault};
	__property int iY = {read=FIY, write=FIY, nodefault};
	__property double iW = {read=FIW, write=FIW};
	__property double iH = {read=FIH, write=FIH};
	__property double Zindex = {read=FZindex, write=FZindex};
public:
	/* TObject.Create */ inline __fastcall TVectorIcon() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TVectorIcon() { }
	
};


class PASCALIMPLEMENTATION TVectorText : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::Types::TRect FRect;
	System::UnicodeString FFontName;
	System::UnicodeString FText;
	double FFontSize;
	double FZindex;
	System::Uitypes::TColor FColor;
	
public:
	__property System::UnicodeString FontName = {read=FFontName, write=FFontName};
	__property System::UnicodeString Text = {read=FText, write=FText};
	__property double FontSize = {read=FFontSize, write=FFontSize};
	__property double Zindex = {read=FZindex, write=FZindex};
	__property System::Uitypes::TColor Color = {read=FColor, write=FColor, nodefault};
	__property System::Types::TRect Rect = {read=FRect, write=FRect};
public:
	/* TObject.Create */ inline __fastcall TVectorText() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TVectorText() { }
	
};


typedef System::Classes::TStringList TVectorLabelList;

typedef System::Generics::Collections::TObjectList__1<TVectorText*> TVectorTextList;

typedef System::Generics::Collections::TObjectList__1<TVectorIcon*> TVectorIconList;

class PASCALIMPLEMENTATION TECCanvas : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TVectorLayerStyleRule* FRule;
	TVectorLabelList* FVectorLabelList;
	TVectorTextList* FDrawVectorTextList;
	TVectorTextList* FVectorTextList;
	TVectorIconList* FDrawVectorIconList;
	TVectorIconList* FVectorIconList;
	TVectorStyles* FVectorStyles;
	bool FisInMove;
	int FPPI;
	System::Classes::TNotifyEvent FOnRepaint;
	Vcl::Graphics::TBitmap* FBitmap;
	Vcl::Graphics::TCanvas* _Canvas;
	Uecmaputil::TDashStyle FDash;
	Jhhtmlgraphics::TGetDrawGraphic FGetDrawGraphic;
	int FWAngle;
	int _Angle;
	int _PenSize;
	double _CAngle;
	double _SAngle;
	int FAngle;
	System::Types::TPoint FCenterRotation;
	double CAngle;
	double SAngle;
	double FScale;
	Vcl::Graphics::TBrush* _Brush;
	Vcl::Graphics::TPen* _Pen;
	HRGN FSaveRgn;
	Vcl::Graphics::TFont* FFont;
	System::Byte FOpacity;
	System::Byte FFillOpacity;
	Uecmaputil::TPenStyle PenStyle;
	bool FUse2DCanvas;
	Vcl::Direct2d::TDirect2DCanvas* DCanvas;
	int FTop;
	int FLeft;
	int FRight;
	int FBottom;
	int FWorldTop;
	int FWorldLeft;
	int FWeight;
	int FWidth;
	int FHeight;
	void __fastcall doOnChangeVectorStyles(System::TObject* Sender);
	Vcl::Graphics::TBrush* __fastcall getBrush();
	void __fastcall setBrush(Vcl::Graphics::TBrush* const Value);
	Vcl::Graphics::TPen* __fastcall getPen();
	void __fastcall setPen(Vcl::Graphics::TPen* const Value);
	Vcl::Graphics::TFont* __fastcall getFont();
	void __fastcall setFont(Vcl::Graphics::TFont* const Value);
	int __fastcall getWidth();
	void __fastcall setWidth(const int Value);
	int __fastcall getHeight();
	void __fastcall setHeight(const int Value);
	void __fastcall setFontColor(System::Uitypes::TColor Color);
	System::Uitypes::TColor __fastcall getFontColor();
	int __fastcall getFontsize();
	void __fastcall setFontsize(int Value);
	void __fastcall setUse2DCAnvas(const bool Value);
	void __fastcall setOpacity(System::Byte Value);
	System::Byte __fastcall getOpacity();
	void __fastcall setFillOpacity(System::Byte Value);
	System::Byte __fastcall getFillOpacity();
	void __fastcall setCanvas(Vcl::Graphics::TCanvas* CanvasValue);
	Vcl::Graphics::TCanvas* __fastcall getCanvas();
	void __fastcall setAngle(const int Value);
	
public:
	System::Types::TRect RectView;
	__fastcall TECCanvas(double ValueScale, Vcl::Graphics::TCanvas* ValueCanvas);
	__fastcall virtual ~TECCanvas();
	void __fastcall Repaint();
	void __fastcall BeginTranslate(const int X, const int Y);
	void __fastcall EndTranslate();
	void __fastcall SaveCanvas();
	void __fastcall RestoreCanvas();
	void __fastcall Clip(const double X, const double Y, const double W, const double H);
	void __fastcall UnClip();
	void __fastcall GrayScale();
	void __fastcall InvertColor();
	void __fastcall SepiaColor();
	void __fastcall LightColor(const System::Byte LightValue);
	void __fastcall DarkColor(const System::Byte DarkValue);
	void __fastcall RotationXYX2Y2(int &X, int &Y, int &x2, int &y2);
	void __fastcall BeginVMt();
	void __fastcall DrawVMTLabels();
	void __fastcall DrawVMTIcons();
	void __fastcall DrawVMT(const int X, const int Y, const double MapZoom, const double Zoom, Vector_tile::TDecodedTile* const Tile, const bool DrawBackGround = true);
	void __fastcall Ellipse(const Uecmaputil::TDashStyle DashStyle = Uecmaputil::TDashStyle(), const Uecmaputil::TPenStyle Style = (Uecmaputil::TPenStyle)(0x0))/* overload */;
	void __fastcall Ellipse(int X, int Y, int X1, int Y1, const Uecmaputil::TDashStyle DashStyle = Uecmaputil::TDashStyle(), const Uecmaputil::TPenStyle Style = (Uecmaputil::TPenStyle)(0x0))/* overload */;
	System::LongBool __fastcall Polyline(const System::Types::TPoint *Points, const System::NativeInt Points_High, int Count = 0x0, int firstPoint = 0x0, const Uecmaputil::TDashStyle DashStyle = Uecmaputil::TDashStyle(), const Uecmaputil::TPenStyle Style = (Uecmaputil::TPenStyle)(0x0), const bool close = false);
	void __fastcall PolyBezier(const System::Types::TPoint *Points, const System::NativeInt Points_High, int Count);
	void __fastcall Poly(const bool Bezier, const System::Types::TPoint *Points, const System::NativeInt Points_High, int Count, int Weight, const System::Uitypes::TColor Color, const Uecmaputil::TPenStyle Style, const Uecmaputil::TDashStyle DashStyle, int firstPoint = 0x0);
	void __fastcall Polygon(System::Types::TPoint *Points, const System::NativeInt Points_High, const Uecmaputil::TDashStyle DashStyle = Uecmaputil::TDashStyle(), const Uecmaputil::TPenStyle Style = (Uecmaputil::TPenStyle)(0x0), const bool fix2dc = false)/* overload */;
	void __fastcall BeginDraw();
	void __fastcall EndDraw();
	void __fastcall FillRectangle(const System::Types::TRect &Rect)/* overload */;
	void __fastcall FillCircle(const System::Types::TRect &Rect);
	void __fastcall Clear(System::Uitypes::TColor Color);
	void __fastcall setSize(const int W, const int H);
	void __fastcall AlphaBlendPolygon(const System::Types::TPoint *Points, const System::NativeInt Points_High, const System::Uitypes::TColor Color, const System::Byte _Opacity);
	void __fastcall Rectangle(int X, int Y, int X1, int Y1);
	void __fastcall FillRectangle(int X, int Y, int X1, int Y1)/* overload */;
	void __fastcall RoundRect(int X, int Y, int X1, int Y1, int rx, int ry);
	void __fastcall DrawStar(const System::Types::TRect &Rect, const Uecmaputil::TDashStyle DashStyle = Uecmaputil::TDashStyle(), const Uecmaputil::TPenStyle Style = (Uecmaputil::TPenStyle)(0x0));
	void __fastcall DrawHexagon(const System::Types::TRect &Rect, const Uecmaputil::TDashStyle DashStyle = Uecmaputil::TDashStyle(), const Uecmaputil::TPenStyle Style = (Uecmaputil::TPenStyle)(0x0));
	void __fastcall moveto(const int X, const int Y);
	void __fastcall lineto(const int X, const int Y);
	void __fastcall TextOut(const int X, const int Y, const System::UnicodeString Text);
	void __fastcall TextRect(const System::Types::TRect &Rect, int X, int Y, const System::UnicodeString Text);
	void __fastcall DrawText(const System::UnicodeString Text, const System::Types::TRect &r, System::Classes::TAlignment Align = (System::Classes::TAlignment)(0x2));
	int __fastcall TextHeight(const System::UnicodeString Value);
	int __fastcall TextWidth(const System::UnicodeString Value);
	System::Types::TSize __fastcall TextExtent(const System::UnicodeString Value);
	void __fastcall Draw(int X, int Y, Vcl::Graphics::TGraphic* const graphic)/* overload */;
	void __fastcall Draw(int X, int Y, Vcl::Graphics::TGraphic* const graphic, int W, int H, const double DOpacity = -1.000000E+00, int OriginX = 0x0, int OriginY = 0x0, double RatioSizeX = 1.000000E+00, double RatioSizeY = 1.000000E+00, Winapi::D2d1::_di_ID2D1Bitmap G2DBitmap = Winapi::D2d1::_di_ID2D1Bitmap())/* overload */;
	void __fastcall PenWidth(int Value);
	void __fastcall setPenStyle(Uecmaputil::TPenStyle Value);
	virtual bool __fastcall DrawHTML(const System::UnicodeString HtmlText, const bool bdRightToLeft, System::Types::TRect &vRect, const unsigned cjhFlags, Jhhtmlgraphics::TGetDrawGraphic doGetDrawGraphic, Jhhtmlgraphics::TGetAreaAnchor doGetAreaAnchor = 0x0, const int HitID = 0xffffffff, const double _scale = 1.000000E+00);
	void __fastcall TextHTML(const System::UnicodeString HtmlText, const int X, const int Y)/* overload */;
	void __fastcall TextHTML(const System::UnicodeString HtmlText, System::Types::TRect &vRect)/* overload */;
	System::Types::TRect __fastcall HTMLRect(const System::UnicodeString HtmlText);
	__property int WAngle = {read=FWAngle, write=FWAngle, nodefault};
	__property int Angle = {read=FAngle, write=setAngle, nodefault};
	__property double CosAngle = {read=CAngle, write=CAngle};
	__property double SinAngle = {read=SAngle, write=SAngle};
	__property double Scale = {read=FScale, write=FScale};
	__property System::Uitypes::TColor FontColor = {read=getFontColor, write=setFontColor, nodefault};
	__property int FontSize = {read=getFontsize, write=setFontsize, nodefault};
	__property Vcl::Graphics::TBrush* Brush = {read=getBrush, write=setBrush};
	__property Vcl::Graphics::TPen* Pen = {read=getPen, write=setPen};
	__property int PenSize = {read=FWeight, write=PenWidth, nodefault};
	__property Vcl::Graphics::TFont* Font = {read=getFont, write=setFont};
	__property int Width = {read=getWidth, write=setWidth, nodefault};
	__property int Height = {read=getHeight, write=setHeight, nodefault};
	__property int WorldTop = {read=FWorldTop, write=FWorldTop, nodefault};
	__property int WorldLeft = {read=FWorldLeft, write=FWorldLeft, nodefault};
	__property int Top = {read=FTop, write=FTop, nodefault};
	__property int Left = {read=FLeft, write=FLeft, nodefault};
	__property int Right = {read=FRight, write=FRight, nodefault};
	__property int Bottom = {read=FBottom, write=FBottom, nodefault};
	__property int PPI = {read=FPPI, write=FPPI, nodefault};
	__property bool isInMove = {read=FisInMove, write=FisInMove, nodefault};
	__property Vcl::Graphics::TBitmap* Bitmap = {read=FBitmap};
	__property Jhhtmlgraphics::TGetDrawGraphic GetDrawGraphic = {read=FGetDrawGraphic, write=FGetDrawGraphic};
	__property System::Byte Opacity = {read=getOpacity, write=setOpacity, nodefault};
	__property System::Byte FillOpacity = {read=getFillOpacity, write=setFillOpacity, nodefault};
	__property bool Use2DCanvas = {read=FUse2DCanvas, write=setUse2DCAnvas, nodefault};
	__property Vcl::Direct2d::TDirect2DCanvas* D2DCanvas = {read=DCanvas};
	__property System::Types::TPoint CenterRotation = {read=FCenterRotation, write=FCenterRotation};
	__property int RotationAngle = {read=FAngle, write=setAngle, nodefault};
	__property Vcl::Graphics::TCanvas* Canvas = {read=getCanvas, write=setCanvas};
	__property System::Classes::TNotifyEvent OnRepaint = {read=FOnRepaint, write=FOnRepaint};
	__property TVectorStyles* VectorStyles = {read=FVectorStyles};
	__property TVectorTextList* VectorTextList = {read=FVectorTextList};
	__property TVectorIconList* VectorIconList = {read=FVectorIconList};
	__property TVectorLayerStyleRule* Rule = {read=FRule};
};


enum DECLSPEC_DENUM TExpressionType : unsigned char { etString, etBoolean, etColor, etInteger, etDouble, etPoint, etExpression, etError };

typedef System::Generics::Collections::TObjectDictionary__2<System::UnicodeString,TBaseExpression*> TBaseExpressions;

struct DECLSPEC_DRECORD TCustomVectorExpressionValue
{
public:
	TExpressionType EType;
	System::UnicodeString toString;
	TBaseExpression* Expression;
	
public:
	int Tag;
	union
	{
		struct 
		{
			System::Types::TPoint toPoint;
		};
		struct 
		{
			bool toBoolean;
		};
		struct 
		{
			double toDouble;
		};
		struct 
		{
			int toInteger;
		};
		struct 
		{
			System::Uitypes::TColor toColor;
		};
		
	};
};


enum DECLSPEC_DENUM TExpressionName : unsigned char { eaNone, eaAll, eaAny, eaCase, eaCoalesce, eaMatch, eaWithin, eaConCat, eaInterpolate, eaInterpolate_hcl, eaInterpolate_lab, eaIn, eaImage, eaNotIn, eaEqual, eaNot, eaNotEgal, eaLess, eaLessOrEqual, eaGreather, eaGreatherOrEqual, eaHas, eaGet, eaZoom, eaBoolean, eaNumber };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TFactoryExpression : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TBaseExpressions* FExpressions;
	TBaseExpression* __fastcall BuildExpression(Uecmaputil::TJsonArgumentList* const AArg, const System::UnicodeString LitteralExpression);
	TBaseExpression* __fastcall getExpression(const System::UnicodeString LitteralExpression);
	
public:
	__fastcall TFactoryExpression();
	__fastcall virtual ~TFactoryExpression();
	bool __fastcall isExpression(const System::UnicodeString AValue)/* overload */;
	bool __fastcall isExpression(Uecmaputil::TJsonArgumentList* AArg)/* overload */;
	TExpressionName __fastcall ExpressionName(const System::UnicodeString AValue);
	bool __fastcall toBoolean(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature, const System::UnicodeString AValue, bool &AResult);
	bool __fastcall toNumber(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature, const System::UnicodeString AValue, double &AResult);
	bool __fastcall to_String(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature, const System::UnicodeString AValue, System::UnicodeString &AResult);
	void __fastcall Clear();
	void __fastcall BuildExpressionValue(const System::UnicodeString LitteralExpression, TCustomVectorExpressionValue &FOutput);
	__property TBaseExpression* Expression[const System::UnicodeString index] = {read=getExpression};
};

#pragma pack(pop)

struct DECLSPEC_DRECORD TZoomValue
{
public:
	double Zoom;
	TCustomVectorExpressionValue Value;
};


typedef System::DynamicArray<TZoomValue> TZoomValues;

class PASCALIMPLEMENTATION TPropertyGet : public System::Classes::TStringList
{
	typedef System::Classes::TStringList inherited;
	
private:
	System::UnicodeString FKey;
	
public:
	HIDESBASE System::UnicodeString __fastcall GetValue(const System::UnicodeString AValue);
	__property System::UnicodeString Key = {read=FKey, write=FKey};
public:
	/* TStringList.Create */ inline __fastcall TPropertyGet()/* overload */ : System::Classes::TStringList() { }
	/* TStringList.Create */ inline __fastcall TPropertyGet(bool OwnsObjects)/* overload */ : System::Classes::TStringList(OwnsObjects) { }
	/* TStringList.Create */ inline __fastcall TPropertyGet(System::WideChar QuoteChar, System::WideChar Delimiter)/* overload */ : System::Classes::TStringList(QuoteChar, Delimiter) { }
	/* TStringList.Create */ inline __fastcall TPropertyGet(System::WideChar QuoteChar, System::WideChar Delimiter, System::Classes::TStringsOptions Options)/* overload */ : System::Classes::TStringList(QuoteChar, Delimiter, Options) { }
	/* TStringList.Create */ inline __fastcall TPropertyGet(System::Classes::TDuplicates Duplicates, bool Sorted, bool CaseSensitive)/* overload */ : System::Classes::TStringList(Duplicates, Sorted, CaseSensitive) { }
	/* TStringList.Create */ inline __fastcall TPropertyGet(System::Classes::TStringsOptions Options, System::Classes::TDuplicates Duplicates)/* overload */ : System::Classes::TStringList(Options, Duplicates) { }
	/* TStringList.Destroy */ inline __fastcall virtual ~TPropertyGet() { }
	
};


enum DECLSPEC_DENUM TIconAnchor : unsigned char { iaCenter, iaTop, iaLeft, iaRight, iaBottom, iaTopLeft, iaTopRight, iaBottomLeft, iaBottomRight };

enum DECLSPEC_DENUM TIconTextFit : unsigned char { itfNone, itfWidth, itfHeight, itfBoth };

enum DECLSPEC_DENUM TTextTransform : unsigned char { ttNone, ttUpperCase, ttLowerCase };

enum DECLSPEC_DENUM TExpressionKey : unsigned char { ekKey, ekType };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TBaseExpression : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TZoomValues FZoomValues;
	System::UnicodeString FLitteral;
	System::UnicodeString FExpression;
	TExpressionName FName;
	Uecmaputil::TJsonArgumentList* FArgument;
	virtual void __fastcall setExpression(const System::UnicodeString AValue);
	virtual void __fastcall setLitteral(const System::UnicodeString AValue);
	
public:
	__fastcall virtual TBaseExpression();
	__fastcall virtual ~TBaseExpression();
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	__property Uecmaputil::TJsonArgumentList* Arguments = {read=FArgument};
	__property System::UnicodeString Expression = {read=FExpression, write=setExpression};
	__property TExpressionName Name = {read=FName, nodefault};
	__property System::UnicodeString Litteral = {read=FLitteral, write=setLitteral};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TZoomExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
public:
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
public:
	/* TBaseExpression.Create */ inline __fastcall virtual TZoomExpression() : TBaseExpression() { }
	/* TBaseExpression.Destroy */ inline __fastcall virtual ~TZoomExpression() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TMatchExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
private:
	System::Classes::TStringList* FLabels;
	TBaseExpression* FInput;
	TCustomVectorExpressionValue FFAllBack;
	System::UnicodeString FInputValue;
	virtual void __fastcall setExpression(const System::UnicodeString AValue);
	
public:
	__fastcall virtual TMatchExpression();
	__fastcall virtual ~TMatchExpression();
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
};


class PASCALIMPLEMENTATION TCaseExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
private:
	System::Classes::TStringList* FLabels;
	TBaseExpression* FInput;
	TCustomVectorExpressionValue FFAllBack;
	System::UnicodeString FInputValue;
	virtual void __fastcall setExpression(const System::UnicodeString AValue);
	
public:
	__fastcall virtual TCaseExpression();
	__fastcall virtual ~TCaseExpression();
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TCoalesceExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
private:
	System::Classes::TStringList* FExpressions;
	TBaseExpression* FInput;
	System::UnicodeString FInputValue;
	virtual void __fastcall setExpression(const System::UnicodeString AValue);
	
public:
	__fastcall virtual TCoalesceExpression();
	__fastcall virtual ~TCoalesceExpression();
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TConCatExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
private:
	System::Classes::TStringList* FExpressions;
	TBaseExpression* FInput;
	System::UnicodeString FInputValue;
	virtual void __fastcall setExpression(const System::UnicodeString AValue);
	
public:
	__fastcall virtual TConCatExpression();
	__fastcall virtual ~TConCatExpression();
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TNotExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
public:
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
public:
	/* TBaseExpression.Create */ inline __fastcall virtual TNotExpression() : TBaseExpression() { }
	/* TBaseExpression.Destroy */ inline __fastcall virtual ~TNotExpression() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TBooleanExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
private:
	System::Classes::TStringList* FExpressions;
	TBaseExpression* FInput;
	virtual void __fastcall setExpression(const System::UnicodeString AValue);
	
public:
	__fastcall virtual TBooleanExpression();
	__fastcall virtual ~TBooleanExpression();
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TNumberExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
private:
	System::Classes::TStringList* FExpressions;
	TBaseExpression* FInput;
	virtual void __fastcall setExpression(const System::UnicodeString AValue);
	
public:
	__fastcall virtual TNumberExpression();
	__fastcall virtual ~TNumberExpression();
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TCompareExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
private:
	System::Classes::TStringList* FExpressions;
	virtual void __fastcall setExpression(const System::UnicodeString AValue);
	
public:
	__fastcall virtual TCompareExpression();
	__fastcall virtual ~TCompareExpression();
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TAllExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
private:
	System::Classes::TStringList* FExpressions;
	TBaseExpression* FInput;
	System::UnicodeString FInputValue;
	virtual void __fastcall setExpression(const System::UnicodeString AValue);
	
public:
	__fastcall virtual TAllExpression();
	__fastcall virtual ~TAllExpression();
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TAnyExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
private:
	System::Classes::TStringList* FExpressions;
	TBaseExpression* FInput;
	System::UnicodeString FInputValue;
	virtual void __fastcall setExpression(const System::UnicodeString AValue);
	
public:
	__fastcall virtual TAnyExpression();
	__fastcall virtual ~TAnyExpression();
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TResolvedImageExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
private:
	TBaseExpression* FInput;
	System::UnicodeString FInputValue;
	virtual void __fastcall setExpression(const System::UnicodeString AValue);
	
public:
	__fastcall virtual ~TResolvedImageExpression();
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
public:
	/* TBaseExpression.Create */ inline __fastcall virtual TResolvedImageExpression() : TBaseExpression() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TInterpolateExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
private:
	TZoomValues FZoomValues;
	TBaseExpression* FInput;
	System::UnicodeString FInputValue;
	virtual void __fastcall setExpression(const System::UnicodeString AValue);
	
public:
	__fastcall virtual ~TInterpolateExpression();
	void __fastcall Clear();
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
public:
	/* TBaseExpression.Create */ inline __fastcall virtual TInterpolateExpression() : TBaseExpression() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TGetExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
public:
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
public:
	/* TBaseExpression.Create */ inline __fastcall virtual TGetExpression() : TBaseExpression() { }
	/* TBaseExpression.Destroy */ inline __fastcall virtual ~TGetExpression() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION THasExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
public:
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
public:
	/* TBaseExpression.Create */ inline __fastcall virtual THasExpression() : TBaseExpression() { }
	/* TBaseExpression.Destroy */ inline __fastcall virtual ~THasExpression() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TInExpression : public TBaseExpression
{
	typedef TBaseExpression inherited;
	
public:
	virtual TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
public:
	/* TBaseExpression.Create */ inline __fastcall virtual TInExpression() : TBaseExpression() { }
	/* TBaseExpression.Destroy */ inline __fastcall virtual ~TInExpression() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TCustomVectorExpression : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FExpression;
	double FBase;
	TPropertyGet* FGet;
	TBaseExpression* FBaseExpression;
	System::UnicodeString FStringExpressionName;
	TExpressionName FValueExpressionName;
	void __fastcall setExpressionName(const System::UnicodeString AValue);
	virtual void __fastcall setExpression(const System::UnicodeString AExpression);
	
public:
	__fastcall virtual ~TCustomVectorExpression();
	bool __fastcall setGet(const System::UnicodeString AExpression);
	TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	System::UnicodeString __fastcall getValueString(const System::UnicodeString AExpression, const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	__property double Base = {read=FBase, write=FBase};
	__property System::UnicodeString Expression = {read=FExpression, write=setExpression};
	__property System::UnicodeString ExpressionName = {read=FStringExpressionName, write=setExpressionName};
public:
	/* TObject.Create */ inline __fastcall TCustomVectorExpression() : System::TObject() { }
	
};


class PASCALIMPLEMENTATION TColorVectorExpression : public TCustomVectorExpression
{
	typedef TCustomVectorExpression inherited;
	
private:
	TZoomValues FZoomValues;
	
public:
	virtual void __fastcall setExpression(const System::UnicodeString AExpression);
	HIDESBASE TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	__fastcall virtual ~TColorVectorExpression();
public:
	/* TObject.Create */ inline __fastcall TColorVectorExpression() : TCustomVectorExpression() { }
	
};


class PASCALIMPLEMENTATION TIntegerVectorExpression : public TCustomVectorExpression
{
	typedef TCustomVectorExpression inherited;
	
private:
	TZoomValues FZoomValues;
	TPropertyGet* FGetMatch;
	
public:
	virtual void __fastcall setExpression(const System::UnicodeString AExpression);
	HIDESBASE TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	__fastcall virtual ~TIntegerVectorExpression();
public:
	/* TObject.Create */ inline __fastcall TIntegerVectorExpression() : TCustomVectorExpression() { }
	
};


class PASCALIMPLEMENTATION TDoubleVectorExpression : public TCustomVectorExpression
{
	typedef TCustomVectorExpression inherited;
	
private:
	TZoomValues FZoomValues;
	TPropertyGet* FGetMatch;
	
public:
	virtual void __fastcall setExpression(const System::UnicodeString AExpression);
	HIDESBASE TCustomVectorExpressionValue __fastcall GetValue(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	__fastcall virtual ~TDoubleVectorExpression();
public:
	/* TObject.Create */ inline __fastcall TDoubleVectorExpression() : TCustomVectorExpression() { }
	
};


class PASCALIMPLEMENTATION TCustomVectorPainter : public TCustomVectorExpression
{
	typedef TCustomVectorExpression inherited;
	
private:
	TColorVectorExpression* FFillColor;
	TColorVectorExpression* FBorderColor;
	TColorVectorExpression* FLineColor;
	TColorVectorExpression* FCircleFillColor;
	TColorVectorExpression* FCircleStrokeColor;
	TDoubleVectorExpression* FCircleRadius;
	TDoubleVectorExpression* FCircleStrokeWidth;
	TDoubleVectorExpression* FLineWidth;
	TDoubleVectorExpression* FIconSize;
	TDoubleVectorExpression* FFillTranslateXY;
	TDoubleVectorExpression* FCircleOpacity;
	TDoubleVectorExpression* FCircleStrokeOpacity;
	TDoubleVectorExpression* FFillOpacity;
	TDoubleVectorExpression* FLineOpacity;
	Uecmaputil::TDashStyle FDash;
	System::UnicodeString FPattern;
	TBaseExpression* FPatternExpression;
	System::UnicodeString FFontName;
	TColorVectorExpression* FTextColor;
	TDoubleVectorExpression* FTextPadding;
	TDoubleVectorExpression* FtextSize;
	TColorVectorExpression* FTextHaloColor;
	TDoubleVectorExpression* FTextTranslateXY;
	TDoubleVectorExpression* FtextHaloWidth;
	TDoubleVectorExpression* FTextOffset;
	TDoubleVectorExpression* FTextMaxWidth;
	TBaseExpression* FTextField;
	TBaseExpression* FTextSortKey;
	TDoubleVectorExpression* FIconTranslateXY;
	void __fastcall setFillColor(const System::UnicodeString AValue);
	void __fastcall setCircleFillColor(const System::UnicodeString AValue);
	void __fastcall setFillPattern(const System::UnicodeString AValue);
	void __fastcall setBorderColor(const System::UnicodeString AValue);
	void __fastcall setLineColor(const System::UnicodeString AValue);
	void __fastcall setCircleStrokeColor(const System::UnicodeString AValue);
	void __fastcall setFillTranslate(const System::UnicodeString AValue);
	void __fastcall setLineWidth(const System::UnicodeString AValue);
	void __fastcall setCircleStrokeWidth(const System::UnicodeString AValue);
	void __fastcall setCircleRadius(const System::UnicodeString AValue);
	void __fastcall setIconSize(const System::UnicodeString AValue);
	void __fastcall setFillOpacity(const System::UnicodeString AValue);
	void __fastcall setLineOpacity(const System::UnicodeString AValue);
	void __fastcall setCircleOpacity(const System::UnicodeString AValue);
	void __fastcall setCircleStrokeOpacity(const System::UnicodeString AValue);
	void __fastcall setTextColor(const System::UnicodeString AValue);
	void __fastcall setTextHaloColor(const System::UnicodeString AValue);
	void __fastcall setTextHaloWidth(const System::UnicodeString AValue);
	void __fastcall setTextField(const System::UnicodeString AValue);
	void __fastcall setTextSize(const System::UnicodeString AValue);
	void __fastcall setTextSortKey(const System::UnicodeString AValue);
	void __fastcall setTextTranslate(const System::UnicodeString AValue);
	void __fastcall setTextOffset(const System::UnicodeString AValue);
	void __fastcall setTextMaxWidth(const System::UnicodeString AValue);
	void __fastcall setTextPadding(const System::UnicodeString AValue);
	void __fastcall setTextFontName(const System::UnicodeString AValue);
	void __fastcall setIconTranslate(const System::UnicodeString AValue);
	void __fastcall setDash(const System::UnicodeString AValue);
	virtual void __fastcall setExpression(const System::UnicodeString AExpression);
	
public:
	__fastcall virtual ~TCustomVectorPainter();
	virtual void __fastcall Paint(TECCanvas* const ACanvas, const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	virtual bool __fastcall isInView(TECCanvas* const ACanvas, const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	double __fastcall getLineOpacity(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	double __fastcall getFillOpacity(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	int __fastcall getLineWidth(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	System::Uitypes::TColor __fastcall getFillColor(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	System::Uitypes::TColor __fastcall getBorderColor(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	System::Uitypes::TColor __fastcall getLineColor(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	System::Uitypes::TColor __fastcall getTextColor(const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	__property Uecmaputil::TDashStyle Dash = {read=FDash};
	__property System::UnicodeString Pattern = {read=FPattern};
	__property TBaseExpression* PatternExpression = {read=FPatternExpression};
public:
	/* TObject.Create */ inline __fastcall TCustomVectorPainter() : TCustomVectorExpression() { }
	
};


class PASCALIMPLEMENTATION TCustomVectorFilter : public TCustomVectorExpression
{
	typedef TCustomVectorExpression inherited;
	
public:
	virtual bool __fastcall Filter(const double Zoom, Vector_tile::TDecodedFeature* DecodedFeature);
public:
	/* TCustomVectorExpression.Destroy */ inline __fastcall virtual ~TCustomVectorFilter() { }
	
public:
	/* TObject.Create */ inline __fastcall TCustomVectorFilter() : TCustomVectorExpression() { }
	
};


class PASCALIMPLEMENTATION TVectorPaint : public TCustomVectorPainter
{
	typedef TCustomVectorPainter inherited;
	
public:
	virtual void __fastcall Paint(TECCanvas* const ACanvas, const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
	virtual bool __fastcall isInView(TECCanvas* const ACanvas, const double Zoom, Vector_tile::TDecodedFeature* const DecodedFeature);
public:
	/* TCustomVectorPainter.Destroy */ inline __fastcall virtual ~TVectorPaint() { }
	
public:
	/* TObject.Create */ inline __fastcall TVectorPaint() : TCustomVectorPainter() { }
	
};


class PASCALIMPLEMENTATION TPropertyVectorFilter : public TCustomVectorFilter
{
	typedef TCustomVectorFilter inherited;
	
private:
	System::Classes::TStringList* FValueList;
	System::UnicodeString FKey;
	TExpressionKey FExpressionKey;
	void __fastcall setKey(const System::UnicodeString AValue);
	
public:
	__fastcall TPropertyVectorFilter();
	__fastcall virtual ~TPropertyVectorFilter();
	virtual bool __fastcall Filter(const double Zoom, Vector_tile::TDecodedFeature* DecodedFeature);
	__property System::Classes::TStringList* Values = {read=FValueList};
	__property System::UnicodeString Key = {read=FKey, write=setKey};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TPropertyVectorFilters : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::Classes::TList* FList;
	TExpressionName FValueExpressionName;
	
public:
	__fastcall TPropertyVectorFilters();
	__fastcall virtual ~TPropertyVectorFilters();
	void __fastcall addFilter(const System::UnicodeString AValue);
	bool __fastcall Filter(const double Zoom, Vector_tile::TDecodedFeature* DecodedFeature);
	__property TExpressionName ValueExpressionName = {read=FValueExpressionName, write=FValueExpressionName, nodefault};
};

#pragma pack(pop)

enum DECLSPEC_DENUM TVectorLayerType : unsigned char { vltFill, vltLine, vltSymbol, vltCircle, vltHeatmap, vltFill_extrusion, vltRaster, vltHillshade, vltBackground, vtNone };

typedef System::Generics::Collections::TDictionary__2<Vector_tile::TDecodedFeature*,bool> TRuleFilterFeature;

class PASCALIMPLEMENTATION TVectorLayerStyleRule : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FId;
	System::UnicodeString FSource;
	System::UnicodeString FSource_Layer;
	System::UnicodeString FImageName;
	TVectorLayerType FType;
	double FMaxZoom;
	double FMinZoom;
	int FZindex;
	bool FVisible;
	TPropertyVectorFilters* FFilter;
	TCustomVectorPainter* FPainter;
	TBaseExpression* FImage;
	TIconAnchor FImageAnchor;
	TIconTextFit FIconTextFit;
	TCustomVectorExpression* FText_Field;
	TTextTransform FText_Transform;
	System::UnicodeString FText_Font;
	TIntegerVectorExpression* FText_Size;
	int FText_Width;
	TVectorStyles* FParent;
	Vector_tile::TGeomType FSymbol_Placement;
	TRuleFilterFeature* FRuleFilterFeature;
	void __fastcall setVisible(const bool AValue);
	
public:
	__fastcall TVectorLayerStyleRule(TVectorStyles* const AParent);
	__fastcall virtual ~TVectorLayerStyleRule();
	bool __fastcall isShow(const double Zoom, Vector_tile::TDecodedFeature* DecodedFeature, const bool isMove = false);
	__property System::UnicodeString Id = {read=FId, write=FId};
	__property TVectorLayerType LayerType = {read=FType, write=FType, nodefault};
	__property System::UnicodeString Source = {read=FSource, write=FSource};
	__property System::UnicodeString Source_Layer = {read=FSource_Layer, write=FSource_Layer};
	__property double MaxZoom = {read=FMaxZoom, write=FMaxZoom};
	__property double MinZoom = {read=FMinZoom, write=FMinZoom};
	__property int Zindex = {read=FZindex, write=FZindex, nodefault};
	__property bool Visible = {read=FVisible, write=setVisible, nodefault};
	__property TPropertyVectorFilters* Filter = {read=FFilter, write=FFilter};
	__property TCustomVectorPainter* Painter = {read=FPainter, write=FPainter};
	__property TBaseExpression* Image = {read=FImage, write=FImage};
	__property System::UnicodeString ImageName = {read=FImageName, write=FImageName};
	__property TIconAnchor ImageAnchor = {read=FImageAnchor, write=FImageAnchor, nodefault};
	__property TIconTextFit IconTextFit = {read=FIconTextFit, write=FIconTextFit, nodefault};
	__property TCustomVectorExpression* Text_Field = {read=FText_Field, write=FText_Field};
	__property TTextTransform Text_Transform = {read=FText_Transform, write=FText_Transform, nodefault};
	__property System::UnicodeString Text_Font = {read=FText_Font, write=FText_Font};
	__property TIntegerVectorExpression* Text_Size = {read=FText_Size, write=FText_Size};
	__property int Text_Width = {read=FText_Width, write=FText_Width, nodefault};
	__property Vector_tile::TGeomType Symbol_Placement = {read=FSymbol_Placement, write=FSymbol_Placement, nodefault};
	__property TVectorStyles* Parent = {read=FParent};
};


class PASCALIMPLEMENTATION TVectorLayerStyleRules : public System::Generics::Collections::TObjectList__1<TVectorLayerStyleRule*>
{
	typedef System::Generics::Collections::TObjectList__1<TVectorLayerStyleRule*> inherited;
	
public:
	__fastcall TVectorLayerStyleRules();
	__fastcall virtual ~TVectorLayerStyleRules();
};


typedef System::Generics::Collections::TObjectDictionary__2<System::UnicodeString,TVectorLayerStyleRules*> TVectorLayerStyles;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TVectorIndexSprite : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	int X;
	int Y;
	int Width;
	int Height;
	int PixelRatio;
public:
	/* TObject.Create */ inline __fastcall TVectorIndexSprite() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TVectorIndexSprite() { }
	
};

#pragma pack(pop)

typedef System::Generics::Collections::TObjectDictionary__2<System::UnicodeString,TVectorIndexSprite*> TVectorIndexSprites;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TVectorSprite : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Vcl::Graphics::TGraphic* FSprite;
	TVectorIndexSprites* FIndex;
	Winapi::D2d1::_di_ID2D1Bitmap FDBitmap;
	
public:
	__fastcall TVectorSprite();
	__fastcall virtual ~TVectorSprite();
	void __fastcall LoadFromFile(const System::UnicodeString ASprite, const System::UnicodeString AIndex);
	__property Vcl::Graphics::TGraphic* Sprite = {read=FSprite};
	__property TVectorIndexSprites* SpriteIndex = {read=FIndex};
	__property Winapi::D2d1::_di_ID2D1Bitmap DBitmap = {read=FDBitmap, write=FDBitmap};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TVectorLayer : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FName;
	int FMinZoom;
	int FMaxZoom;
	bool FVisible;
	System::Classes::TNotifyEvent FOnChange;
	void __fastcall setVisible(const bool AValue);
	void __fastcall setMinZoom(const int AValue);
	void __fastcall setMaxZoom(const int AValue);
	
public:
	__property System::UnicodeString Name = {read=FName};
	__property int MinZoom = {read=FMinZoom, write=setMinZoom, nodefault};
	__property int MaxZoom = {read=FMaxZoom, write=setMaxZoom, nodefault};
	__property bool Visible = {read=FVisible, write=setVisible, nodefault};
public:
	/* TObject.Create */ inline __fastcall TVectorLayer() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TVectorLayer() { }
	
};


class PASCALIMPLEMENTATION TVectorLayers : public System::Generics::Collections::TObjectList__1<TVectorLayer*>
{
	typedef System::Generics::Collections::TObjectList__1<TVectorLayer*> inherited;
	
public:
	TVectorLayer* __fastcall AddFromName(const System::UnicodeString AValue);
	void __fastcall AddFromVector_layers(const System::UnicodeString AValue);
	HIDESBASE TVectorLayer* __fastcall IndexOf(const System::UnicodeString AName);
public:
	/* {System_Generics_Collections}TObjectList<UECGraphics_TVectorLayer>.Create */ inline __fastcall TVectorLayers()/* overload */ : System::Generics::Collections::TObjectList__1<TVectorLayer*>() { }
	/* {System_Generics_Collections}TObjectList<UECGraphics_TVectorLayer>.Create */ inline __fastcall TVectorLayers(bool AOwnsObjects)/* overload */ : System::Generics::Collections::TObjectList__1<TVectorLayer*>(AOwnsObjects) { }
	/* {System_Generics_Collections}TObjectList<UECGraphics_TVectorLayer>.Create */ inline __fastcall TVectorLayers(const System::DelphiInterface<System::Generics::Defaults::IComparer__1<TVectorLayer*> > AComparer, bool AOwnsObjects)/* overload */ : System::Generics::Collections::TObjectList__1<TVectorLayer*>(AComparer, AOwnsObjects) { }
	/* {System_Generics_Collections}TObjectList<UECGraphics_TVectorLayer>.Create */ inline __fastcall TVectorLayers(System::Generics::Collections::TEnumerable__1<TVectorLayer*>* const Collection, bool AOwnsObjects)/* overload */ : System::Generics::Collections::TObjectList__1<TVectorLayer*>(Collection, AOwnsObjects) { }
	/* {System_Generics_Collections}TObjectList<UECGraphics_TVectorLayer>.Destroy */ inline __fastcall virtual ~TVectorLayers() { }
	
public:
	/* {System_Generics_Collections}TList<UECGraphics_TVectorLayer>.Create */ inline __fastcall TVectorLayers(const System::DelphiInterface<System::Generics::Defaults::IComparer__1<TVectorLayer*> > AComparer)/* overload */ : System::Generics::Collections::TObjectList__1<TVectorLayer*>(AComparer) { }
	/* {System_Generics_Collections}TList<UECGraphics_TVectorLayer>.Create */ inline __fastcall TVectorLayers(System::Generics::Collections::TEnumerable__1<TVectorLayer*>* const Collection)/* overload */ : System::Generics::Collections::TObjectList__1<TVectorLayer*>(Collection) { }
	/* {System_Generics_Collections}TList<UECGraphics_TVectorLayer>.Create */ inline __fastcall TVectorLayers(const System::DelphiInterface<System::IEnumerable__1<TVectorLayer*> > Collection)/* overload */ : System::Generics::Collections::TObjectList__1<TVectorLayer*>(Collection) { }
	/* {System_Generics_Collections}TList<UECGraphics_TVectorLayer>.Create */ inline __fastcall TVectorLayers(TVectorLayer* const *Values, const System::NativeInt Values_High)/* overload */ : System::Generics::Collections::TObjectList__1<TVectorLayer*>(Values, Values_High) { }
	
};


class PASCALIMPLEMENTATION TVectorStyles : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FHostName;
	bool FBeginUpdate;
	TVectorLayerStyles* FVectorLayerStyles;
	TVectorPaint* FBackGroundPaint;
	System::UnicodeString FJson;
	TVectorLayers* FLayers;
	TVectorSprite* FSprite;
	System::Classes::TNotifyEvent FOnChange;
	TVectorLayerStyleRules* __fastcall getVectorLayerStyleRules(const System::UnicodeString Source_Layer);
	void __fastcall setJSOnStyle(const System::UnicodeString AJson);
	TVectorLayerStyleRule* __fastcall AddRule(const System::UnicodeString SId, const System::UnicodeString SType, const System::UnicodeString SLayer, const System::UnicodeString SPaint, const System::UnicodeString SFilter, const System::UnicodeString SLayout, const System::UnicodeString SMinZoom, const System::UnicodeString SMaxZoom);
	
public:
	__fastcall TVectorStyles();
	__fastcall virtual ~TVectorStyles();
	void __fastcall Clear();
	TVectorLayerStyleRule* __fastcall addRuleLayer(const System::UnicodeString JSonLayer);
	bool __fastcall DeleteRule(TVectorLayerStyleRule* const ARule);
	void __fastcall EnabledMatchRule(const System::UnicodeString Match, const bool AEnabled);
	void __fastcall BeginUpdate();
	void __fastcall EndUpdate();
	void __fastcall Update();
	bool __fastcall LoadFromFile(const System::UnicodeString AFilename);
	__property System::UnicodeString JSon = {read=FJson, write=setJSOnStyle};
	__property TVectorLayers* Layers = {read=FLayers};
	__property TVectorLayerStyleRules* VectorLayerStyles[const System::UnicodeString Source_Layer] = {read=getVectorLayerStyleRules};
	__property TVectorSprite* Sprite = {read=FSprite};
	__property TVectorPaint* BackGroundPaint = {read=FBackGroundPaint};
	__property System::Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE void __fastcall BubbleSortGraph(Uecmaputil::TECAGraphInfo &A);
extern DELPHI_PACKAGE void __fastcall QuickSortGraph(Uecmaputil::TECAGraphInfo &A, int iLo, int iHi);
extern DELPHI_PACKAGE Vcl::Imaging::Pngimage::TPngImage* __fastcall getPngFromBitmap(Vcl::Graphics::TBitmap* const bmp, const System::Uitypes::TColor TransparentColor);
extern DELPHI_PACKAGE void __fastcall setAlphaFromColor(Vcl::Imaging::Pngimage::TPngImage* png, const System::Uitypes::TColor CO);
extern DELPHI_PACKAGE Vcl::Graphics::TGraphic* __fastcall PieGraphToBitmap(const int Radius, const Uecmaputil::TECAGraphInfo &Data);
extern DELPHI_PACKAGE Vcl::Graphics::TGraphic* __fastcall StackedBarToBitmap(const int W, const int H, const Uecmaputil::TECAGraphInfo &Data);
}	/* namespace Uecgraphics */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_UECGRAPHICS)
using namespace Uecgraphics;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// UECGraphicsHPP
