﻿// CodeGear C++Builder
// Copyright (c) 1995, 2023 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Vcl.Clipbrd.pas' rev: 36.00 (Windows)

#ifndef Vcl_ClipbrdHPP
#define Vcl_ClipbrdHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <Winapi.Messages.hpp>
#include <System.Classes.hpp>
#include <System.SysUtils.hpp>
#include <Vcl.Graphics.hpp>

//-- user supplied -----------------------------------------------------------

namespace Vcl
{
namespace Clipbrd
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TClipboard;
class DELPHICLASS EClipboardException;
//-- type declarations -------------------------------------------------------
#pragma pack(push,4)
class PASCALIMPLEMENTATION TClipboard : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	int FOpenRefCount;
	HWND FClipboardWindow;
	bool FAllocated;
	bool FEmptied;
	void __fastcall AssignGraphic(Vcl::Graphics::TGraphic* Source);
	void __fastcall AssignPicture(Vcl::Graphics::TPicture* Source);
	void __fastcall AssignToBitmap(Vcl::Graphics::TBitmap* Dest);
	void __fastcall AssignToMetafile(Vcl::Graphics::TMetafile* Dest);
	void __fastcall AssignToPicture(Vcl::Graphics::TPicture* Dest);
	System::UnicodeString __fastcall GetAsText();
	HWND __fastcall GetClipboardWindow();
	int __fastcall GetFormatCount();
	unsigned __fastcall GetFormats(int Index);
	void __fastcall SetAsText(const System::UnicodeString Value);
	
protected:
	virtual void __fastcall Adding();
	virtual void __fastcall AssignTo(System::Classes::TPersistent* Dest);
	virtual void __fastcall WndProc(Winapi::Messages::TMessage &Message);
	void __fastcall MainWndProc(Winapi::Messages::TMessage &Message);
	void __fastcall SetBuffer(unsigned Format, void *Buffer, System::NativeInt Size);
	__property HWND Handle = {read=GetClipboardWindow, nodefault};
	__property int OpenRefCount = {read=FOpenRefCount, nodefault};
	
public:
	__fastcall virtual ~TClipboard();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	virtual void __fastcall Clear();
	virtual void __fastcall Close();
	System::Classes::TComponent* __fastcall GetComponent(System::Classes::TComponent* Owner, System::Classes::TComponent* Parent);
	Winapi::Windows::THandle __fastcall GetAsHandle(unsigned Format);
	bool __fastcall HasFormat(unsigned Format);
	virtual void __fastcall Open();
	void __fastcall SetComponent(System::Classes::TComponent* Component);
	void __fastcall SetAsHandle(unsigned Format, Winapi::Windows::THandle Value);
	int __fastcall GetTextBuf(System::WideChar * Buffer, int BufSize);
	void __fastcall SetTextBuf(System::WideChar * Buffer);
	__property System::UnicodeString AsText = {read=GetAsText, write=SetAsText};
	__property int FormatCount = {read=GetFormatCount, nodefault};
	__property unsigned Formats[int Index] = {read=GetFormats};
public:
	/* TObject.Create */ inline __fastcall TClipboard() : System::Classes::TPersistent() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION EClipboardException : public System::Sysutils::Exception
{
	typedef System::Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ inline __fastcall EClipboardException(const System::UnicodeString Msg) : System::Sysutils::Exception(Msg) { }
	/* Exception.CreateFmt */ inline __fastcall EClipboardException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High) : System::Sysutils::Exception(Msg, Args, Args_High) { }
	/* Exception.CreateRes */ inline __fastcall EClipboardException(System::NativeUInt Ident)/* overload */ : System::Sysutils::Exception(Ident) { }
	/* Exception.CreateRes */ inline __fastcall EClipboardException(System::PResStringRec ResStringRec)/* overload */ : System::Sysutils::Exception(ResStringRec) { }
	/* Exception.CreateResFmt */ inline __fastcall EClipboardException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High) { }
	/* Exception.CreateResFmt */ inline __fastcall EClipboardException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High) { }
	/* Exception.CreateHelp */ inline __fastcall EClipboardException(const System::UnicodeString Msg, int AHelpContext) : System::Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ inline __fastcall EClipboardException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext) : System::Sysutils::Exception(Msg, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall EClipboardException(System::NativeUInt Ident, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall EClipboardException(System::PResStringRec ResStringRec, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall EClipboardException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall EClipboardException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High, AHelpContext) { }
	/* Exception.Destroy */ inline __fastcall virtual ~EClipboardException() { }
	
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE unsigned CF_PICTURE;
extern DELPHI_PACKAGE unsigned CF_COMPONENT;
extern DELPHI_PACKAGE TClipboard* __fastcall Clipboard(void);
extern DELPHI_PACKAGE TClipboard* __fastcall SetClipboard(TClipboard* NewClipboard);
}	/* namespace Clipbrd */
}	/* namespace Vcl */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_VCL_CLIPBRD)
using namespace Vcl::Clipbrd;
#endif
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_VCL)
using namespace Vcl;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Vcl_ClipbrdHPP
