﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'jhHTMLGraphics.pas' rev: 37.00 (Windows)

#ifndef jhHTMLGraphicsHPP
#define jhHTMLGraphicsHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.UITypes.hpp>
#include <System.SysUtils.hpp>
#include <System.Classes.hpp>
#include <Winapi.Windows.hpp>
#include <Vcl.Graphics.hpp>
#include <UECMapUtil.hpp>
#include <System.Types.hpp>

//-- user supplied -----------------------------------------------------------

namespace Jhhtmlgraphics
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TjhHTMLText;
//-- type declarations -------------------------------------------------------
typedef void __fastcall (__closure *TGetDrawGraphic)(const System::UnicodeString Filename, Vcl::Graphics::TGraphic* &gfx, const int x, const int y, int &l, int &h);

typedef void __fastcall (__closure *TGetAreaAnchor)(const int x, const int y, const int l, const int h, const int id, const System::UnicodeString anchor);

enum DECLSPEC_DENUM TApplyTagType : unsigned char { atBreak, atGoodTag, atBadTag, atText, atImg, atCenter, atTab, atvTab, atShape };

enum DECLSPEC_DENUM TShapeType : unsigned char { stNone, stRect, stCircle };

class PASCALIMPLEMENTATION TjhHTMLText : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	double FOldFontSize;
	double FScale;
	System::UnicodeString FImgSrc;
	int FImgWidth;
	int FImgHeight;
	int FimgDeltaY;
	System::UnicodeString FShape;
	TShapeType FShapeType;
	int FShapeWidth;
	int FShapeHeight;
	int FShapeDeltaY;
	System::Uitypes::TColor FShapeColor;
	System::Uitypes::TColor FShapeBorderColor;
	System::Uitypes::TColor FOldColor;
	System::Uitypes::TColor FOldBorderColor;
	int StartPosX;
	bool FBDRightToLeft;
	bool FCanCache;
	bool FIsLinkImg;
	bool FTagBreak;
	bool FTagH;
	System::UnicodeString FTagFont;
	bool FTagA;
	TGetDrawGraphic FDrawGraphic;
	TGetAreaAnchor FAreaAnchor;
	double FDeltaFontH;
	double FDeltaFontW;
	double FDeltaBR;
	double FTab;
	double FVTab;
	int FHitID;
	int FaX;
	int FaY;
	int FaH;
	int FaL;
	System::UnicodeString FaUrl;
	System::UnicodeString FTagLink;
	System::Classes::TStringList* FWordTagList;
	System::UnicodeString FWorkStr;
	System::UnicodeString FLineStartFontName;
	int FReduceH;
	int AutoBreak;
	bool FHoverFont;
	bool FBkHoverColor;
	bool FbkColor;
	System::Uitypes::TColor FHoverTextColor;
	System::Uitypes::TColor FHoverFillBkcolor;
	System::Uitypes::TColor FTextColor;
	System::Uitypes::TColor FFillBkcolor;
	int Fppi;
	int FMaxWidth;
	int FMaxHeight;
	int FThisLineY;
	int FLineStartFontSize;
	int FLineStartFontHeight;
	int FCurId;
	int FLineStartFontWidth;
	int FIndent1;
	int FIndent;
	int FCurLine;
	int FLineEndWordTagIdx;
	int FLineWordCount;
	int FWordCount;
	int FStaticLineHeight;
	unsigned FjhFlags;
	int FLineEndWordX;
	double FLeading;
	Winapi::Windows::TRect FRect;
	Vcl::Graphics::TCanvas* FCanvas;
	System::Uitypes::TFontStyles FLineStartStyle;
	System::Uitypes::TColor FLineStartFontColor;
	Vcl::Graphics::TFont* FBaseFont;
	Vcl::Graphics::TFont* FLastFont;
	bool FInCenterMode;
	bool FInPlainTextMode;
	bool FLineStartPlainTextMode;
	int FLastFontWidth;
	int FCurrentFontWidth;
	void __fastcall FillWordTagList();
	void __fastcall ProcessWordTagList();
	void __fastcall CalcWordTagList();
	bool __fastcall DrawLine(int vLineEndWordTagIdx, const bool draw = true);
	TApplyTagType __fastcall ApplyTag(System::UnicodeString str, const int id);
	void __fastcall SetTabPosition(const System::UnicodeString s);
	void __fastcall SetVTabPosition(const System::UnicodeString s);
	void __fastcall SetBRPosition(const System::UnicodeString s);
	System::UnicodeString __fastcall GetFontParam(const System::UnicodeString ParamLabStr, const System::UnicodeString s);
	void __fastcall SetFontName(System::UnicodeString s);
	void __fastcall SetFontSize(System::UnicodeString s);
	void __fastcall SetFontColor(System::UnicodeString s);
	void __fastcall SetFontBkColor(System::UnicodeString s);
	void __fastcall SetFontHoverColor(System::UnicodeString s);
	void __fastcall SetFontHoverBkColor(System::UnicodeString s);
	void __fastcall SetFontWidth(System::UnicodeString s);
	void __fastcall SetFontDeltaH(System::UnicodeString s);
	void __fastcall BreakWords(System::UnicodeString s);
	void __fastcall BreakLongWord(System::UnicodeString s, const int idx, const int startX);
	System::Uitypes::TColor __fastcall HTMLColortoWinColor(System::UnicodeString s);
	bool __fastcall isText(const System::UnicodeString str);
	
public:
	__fastcall TjhHTMLText(const System::UnicodeString HTMLstr, const bool bdRightToLeft);
	__fastcall virtual ~TjhHTMLText();
	__property System::Classes::TStringList* WordTagList = {read=FWordTagList};
	__property bool CanCache = {read=FCanCache, nodefault};
};


//-- var, const, procedure ---------------------------------------------------
static _DELPHI_CONST System::Int8 _START_INDEX_STRING = System::Int8(0x1);
static _DELPHI_CONST System::Int8 _ReduceWidth = System::Int8(0xe);
static _DELPHI_CONST System::Int8 JC_LEFT = System::Int8(0x0);
static _DELPHI_CONST System::Int8 JC_RIGHT = System::Int8(0x1);
static _DELPHI_CONST System::Int8 JC_CENTER = System::Int8(0x2);
static _DELPHI_CONST System::Int8 JC_CALCRECT = System::Int8(0x4);
static _DELPHI_CONST System::Int8 JC_STATIC_LEADING = System::Int8(0x10);
static _DELPHI_CONST System::Int8 JC_LINE1_LABEL = System::Int8(0x20);
extern DELPHI_PACKAGE bool __fastcall jhDrawHTMLText(Vcl::Graphics::TCanvas* vCanvas, const System::UnicodeString vHTMLstr, const bool bdRightToLeft, Winapi::Windows::TRect &vRect, const unsigned cjhFlags, const double cLeading, const int cIndent1, const int cIndent, TGetDrawGraphic doGetDrawGraphic, TGetAreaAnchor doGetAreaAnchor = 0x0, const int HitID = 0xffffffff, const double _scale = 1.000000E+00);
}	/* namespace Jhhtmlgraphics */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_JHHTMLGRAPHICS)
using namespace Jhhtmlgraphics;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// jhHTMLGraphicsHPP
