unit uecLegendPanel;

interface
 uses
  Windows, messages,forms,sysutils,Classes, Graphics,  Controls, StdCtrls, ExtCtrls,
  uecNativeMapControl,uecmaputil;


type




TVisualStyle  = (vsFrame,vsFillRect,vsSolidLine,vsDotLine,vsDashLine,vsDashDotLine);
TPanelCustomLegende = class(TPanel)
  private
   FBorderColor : TColor;
   FStyle : TVisualStyle;
   FWeight: integer;

   procedure setStyle(const AValue:TVisualStyle);
   procedure setWeight(const AValue:integer);
   procedure setBorderColor(const AColor:TColor);
   procedure WMEraseBkgnd(var Message: TWmEraseBkgnd); message WM_ERASEBKGND;

  protected
    procedure Paint; override;
  public
    property BorderColor : TColor read FBorderColor write setBorderColor;
    property Style       : TVisualStyle read FStyle write setStyle;
    property Weight      : integer read FWeight write setWeight;

  end;



  TVisualAlignment = (valLeft,valRight);

  TItemLegend = class(TPanel)
  private
   FOnItemCheckBoxChange,
   FOnItemClick : TNotifyEvent;
   FVisualColor : TColor;

   FCheckBox: TCheckBox;
   FColor,
   FSepa    : TPanelCustomLegende;
   FPCaption: TPanelCustomLegende;
   FCaption : TLabel;
   FImage   : TImage;
   FTagObject : TObject;

   FVisualAlignment : TVisualAlignment;
   FItemAlignment   : TAlignment;

   function   getColor : TColor;
   procedure  setColor(const AColor:TColor);

   function   getBorderColor : TColor;
   procedure  setBorderColor(const AColor:TColor);

   function   getGraphic : TGraphic;
   procedure  setGraphic(const AGraphic:TGraphic);

   function   getCaption : string;
   procedure  setCaption(const ACaption:String);

   procedure setVisualStyle(const AValue:TVisualStyle);
   function  getVisualStyle : TVisualStyle;
   procedure setVisualWeight(const AValue:integer);
   function  getVisualWeight : integer;

   procedure setItemAlignment(const AValue:TAlignment);

   procedure setVisualAlignment(const AValue:TVisualAlignment);
   procedure setVisualWidth(const AValue:integer);
   function  getVisualWidth:integer;
   procedure setFontSize(const AValue:integer);
   function  getFontSize:integer;

   procedure setFontName(const AValue:string);
   function  getFontName:string;
   procedure setFontColor(const AValue:TColor);
   function  getFontColor:TColor;


   procedure setItemHeight(const AValue:integer);
   function  getItemHeight:integer;

   procedure setItemChecked(const AValue:boolean);
   function  getItemChecked:boolean;

   procedure setItemCheckBox(const AValue:boolean);
   function  getItemCheckBox:boolean;

   procedure setItemCursor(const AValue:TCursor);
   function  getItemCursor:TCursor;

   function MinHeight:integer;

   procedure  doclick(Sender:TObject);
   procedure  doCheckBox(Sender : TObject);
  public
    constructor Create(AOwner:TComponent); override;

    function isGraphic:boolean;

    property ItemColor   : TColor read getColor     write setColor;
    property ItemBorderColor   : TColor read getBorderColor     write setBorderColor;
    property ItemCaption : String read getCaption   write setCaption;
    property ItemChecked : boolean read getItemChecked write setItemChecked;
    property ItemCheckBox: boolean read getItemCheckBox write setItemCheckBox;
    property ItemGraphic : TGraphic read getGraphic write setGraphic;
    property ItemVisualStyle : TVisualStyle read getVisualStyle write setVisualStyle;
    property ItemVisualWidth : integer read getVisualWidth write setVisualWidth;
    property ItemVisualWeight: integer read getVisualWeight write setVisualWeight;
    property ItemVisualAlignment : TVisualAlignment read FVisualAlignment write setVisualAlignment;
    property ItemAlignment : TAlignment read FItemAlignment write setItemAlignment;
    property ItemFontSize : integer read getFontsize write setFontSize;
    property ItemFontName : string read getFontName  write setFontName;
    property ItemFontColor : TColor read getFontColor  write setFontColor;
    property ItemHeight: integer read getItemHeight write setItemHeight;

    property ItemCursor : TCursor read getItemCursor write setItemCursor;


    property ItemObject : TObject read FTagObject write FTagObject;
  end;


  TPanelLegend = class(TPanelCustomLegende)
  private
   FScrollBox:TScrollBox;
   FFooter,
   FTitle : TLabel;
   FList  : TList;
   FOnItemClick : TNotifyEvent;
   FOnItemCheckBoxChange : TNotifyEvent;
   FItemHeight      : integer;
   FItemAlignment   : TAlignment;
   FVisualAlignment : TVisualAlignment;
   FVisualWidth : integer;
   FVisualWeight: integer;
   FFontSize    : integer;
   FItemCheckBox: boolean;

   procedure doClick(Sender : TObject);
   procedure doCheckBoxChange(Sender : TObject);

   procedure setOnItemClick( const AValue : TNotifyEvent);


   procedure setVisualAlignment( const AValue : TVisualAlignment);

   procedure setItemCheckBox(const AValue:boolean);
   procedure setItemAlignment(const AValue:TAlignment);

   procedure setItemHeight( const AValue : integer);

   procedure setVisualWidth( const AValue : integer);

   procedure setVisualWeight( const AValue : integer);
   procedure setFontSize( const AValue : integer);

   procedure setTitleFontSize( const AValue : integer);
   function  getTitleFontSize : integer;

   function  getTitleFontName : string;
   procedure setTitleFontName( const AValue : string);

   function  getFontColor : TColor;
   procedure setFontColor( const AValue : TColor);

   function  getTitle : string;
   procedure setTitle(const ATitle:string);

   function  getTitleAlignment : TAlignment;
   procedure setTitleAlignment(const AValue:TAlignment);

   function  getFooterAlignment : TAlignment;
   procedure setFooterAlignment(const AValue:TAlignment);
   function  getFooter : string;
   procedure setFooter(const ATitle:string);
   procedure setFooterFontSize( const AValue : integer);
   function  getFooterFontSize : integer;

   function getCount:integer;
   function getItem(index:integer): TItemLegend;

  public
   constructor Create(AOwner:TComponent); override;
   destructor  Destroy;override;


   function Add(const ACaption:string;
                const AColor:TColor;
                const AStyle:TVisualStyle=vsFillRect;
                const AObject:TObject=nil):TItemLegend;  overload;

   function Add(const ACaption:string;
                const AGraphic:TGraphic;
                const AObject:TObject=nil):TItemLegend; overload;

   procedure Delete(index:integer);

   property Count : integer read getCount;
   property Items[Index:integer] : TItemLegend read getItem;

   property VisualAlignment : TVisualAlignment read FVisualAlignment write setVisualAlignment;
   property VisualWidth   : integer read FVisualWidth write setVisualWidth;
   property VisualWeight  : integer read FVisualWeight write setVisualWeight;

   property ItemAlignment : TAlignment read FItemAlignment write setItemAlignment;
   property ItemCheckBox  : boolean    read FItemCheckBox  write setItemCheckBox;

   property ItemHeight    : integer    read FItemHeight write setItemHeight;
   property ItemFontSize  : integer read FFontSize write setFontSize;

   property TitleFontSize : integer read getTitleFontSize  write setTitleFontSize;
   property FooterFontSize: integer read getFooterFontSize write setFooterFontSize;
   property FontName : string  read getTitleFontName write setTitleFontName;
   property FontColor: TColor  read getFontColor     write setFontColor;

   property Title : string read getTitle write setTitle;
   property TitleAlignment : TAlignment read getTitleAlignment write setTitleAlignment;
   property Footer : string read getFooter write setFooter;
   property FooterAlignment : TAlignment read getFooterAlignment write setFooterAlignment;
   property OnItemClick : TNotifyEvent read FOnItemClick write setOnItemClick;
   property OnItemCheckBoxChange : TNotifyEvent read FOnItemCheckBoxChange write FOnItemCheckBoxChange;
  end;


  TLegendComponent = class(TECCustomTool)
  private
   FLegend : TPanelLegend;

  public
   constructor Create(Map : TNativeMapControl);  override;
   destructor  Destroy; override;

   property Legend : TPanelLegend read FLegend;

  end;


implementation

function Largest(x, y: integer): integer; {$IFDEF D2010_OR_HIGHER}inline;
{$ENDIF}
begin
  if x > y then
    Result := x
  else
    Result := y;
end;

function GetShadowColorBy(BaseColor: TColor; const Value: integer): TColor;
begin

  Result := RGB(Largest(GetRValue(ColorToRGB(BaseColor)) - Value, 0),
    Largest(GetGValue(ColorToRGB(BaseColor)) - Value, 0),
    Largest(GetBValue(ColorToRGB(BaseColor)) - Value, 0));

end;



constructor TLegendComponent.Create(Map : TNativeMapControl);
begin
   inherited;

   FLegend := TPanelLegend.create(Map);
    // Anchoring the panel on the map
   add('Legend',FLegend,ecTopRight);


end;

Destructor TLegendComponent.Destroy;
begin
  inherited;
  FLegend.Free;
end;


 function TPanelLegend.getCount:integer;
begin
 result := FList.count;
end;

function TPanelLegend.getItem(index:integer): TItemLegend;
begin
  result := nil;

  if (index>=0) and (index<FList.Count) then
   result := TItemLegend(FList[index]);
end;


procedure TPanelLegend.Delete(index:integer);
begin
    if (index>=0) and (index<FList.Count) then
    begin
     TItemLegend(FList[index]).free;
     FList.Delete(index);
    end;
end;

function  TPanelLegend.getTitle : string;
begin
  result := trim(FTitle.caption);
end;

procedure TPanelLegend.setTitle(const ATitle:string);
begin
 FTitle.caption := ATitle;

 FTitle.Visible := ATitle<>'';

 if FTitle.Visible then
  FTitle.Top := 0;

 {$IF CompilerVersion < 21 }
 // fake margin
 if FTitle.visible then
  FTitle.caption := ' '+FTitle.caption+' ';{$IFEND}
end;

function  TPanelLegend.getTitleAlignment : TAlignment;
begin
  result := FTitle.Alignment;
end;

procedure TPanelLegend.setTitleAlignment(const AValue:TAlignment);
begin
  FTitle.Alignment := AValue;
end;

function  TPanelLegend.getFooterAlignment : TAlignment;
begin
  result := FFooter.Alignment;
end;

procedure TPanelLegend.setFooterAlignment(const AValue:TAlignment);
begin
 FFooter.Alignment := AValue;
end;


function  TPanelLegend.getFooter : string;
begin
 result := trim(FFooter.Caption);
end;

procedure TPanelLegend.setFooter(const ATitle:string);
begin
 FFooter.caption := ATitle;

 FFooter.Visible := ATitle<>'';

 if FFOoter.Visible then
  FFooter.Top := Height;

 {$IF CompilerVersion < 21 }
 // fake margin
 if FFooter.visible then
  FFooter.caption := ' '+FFooter.caption+' ';{$IFEND}
end;

procedure TPanelLegend.setFooterFontSize( const AValue : integer);
begin
 FFooter.font.size := AValue;
end;

function  TPanelLegend.getFooterFontSize : integer;
begin
  result := FFooter.font.size;
end;

constructor TPanelLegend.Create(AOwner:TComponent);
begin

  inherited Create(AOwner);

  ParentBackGround := false;

  FList := TList.create;

  Parent := TWinControl(AOwner);
  //Align  := alTop;
  Height := 150;
  width  := 150;
 {$IF CompilerVersion >= 21 }
  padding.left := 3;
  padding.top  := 3;
  padding.right := 3;
  padding.bottom:= 3;
 {$IFEND}


  FTitle            := TLabel.Create(AOwner);
  FTitle.Parent     := self;

  FVisualAlignment := valLeft;
  FItemAlignment := taLeftJustify;


  FTitle.caption := '';
  FTitle.font.size  := 20;
  FTitle.Font.style := [fsBold];
  FTitle.autoSize   := true;
  FTitle.align      := alTop;
  FTitle.Visible    := false;

  FScrollBox := TScrollBox.Create(AOwner);
  FScrollBox.Parent := self;
  FScrollBox.align  := alClient;
  FScrollBox.top    := FTitle.Height;
  FScrollBox.BorderStyle := bsNone;

  FFooter            := TLabel.Create(AOwner);
  FFooter.Parent     := self;
  FFooter.caption := '';
  FFooter.font.size  := 10;
  FFooter.autoSize   := true;
  FFooter.align      := alBottom;
  FFooter.Visible    := false;
  FooterAlignment    := taCenter;

   {$IF CompilerVersion >= 21 }
    FTitle.alignwithmargins  := true;
    FFooter.alignwithmargins := true;
   {$IFEND}


  FVisualWidth     := 16;
  FFontSize        := 11;
  FItemHeight      := 24;
  FVisualWeight    := 2;



end;

destructor  TPanelLegend.Destroy;
begin
  FList.free;
  inherited;
end;

function TPanelLegend.getTitleFontSize : integer;
begin
  result := FTitle.font.size;
end;

procedure TPanelLegend.setTitleFontSize( const AValue : integer);
begin
  FTitle.font.size := AValue;
end;


function  TPanelLegend.getFontColor : TColor;
begin
  result := FTitle.Font.Color;
end;

procedure TPanelLegend.setFontColor( const AValue : TColor);
begin
  FTitle.Font.Color  := AValue;
  FFooter.Font.Color := AValue;

end;

function TPanelLegend.getTitleFontName : string ;
begin
  result := FTitle.font.name;
end;

procedure TPanelLegend.setTitleFontName( const AValue : string);
var i:integer;
begin
  FTitle.font.name  := AValue;
  FFooter.font.name := AValue;
  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemFontName := AValue;
end;




procedure TPanelLegend.setFontSize( const AValue : integer);
var i:integer;
begin
 {$IF CompilerVersion >= 35 }
  FScrollBox.LockDrawing;
{$IFEND}

  FFontSize := AValue;
  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemFontSize := AValue;

 {$IF CompilerVersion >= 35 }
  FScrollBox.UnLockDrawing;
{$IFEND}
end;


procedure TPanelLegend.setItemCheckBox(const AValue:boolean);
var i:integer;
begin

{$IF CompilerVersion >= 35 }
  FScrollBox.LockDrawing;
{$IFEND}
  FItemCheckBox := AValue;
  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemCheckBox := AValue;

 {$IF CompilerVersion >= 35 }
  FScrollBox.UnLockDrawing;
{$IFEND}
end;


procedure TPanelLegend.setItemAlignment(const AValue:TAlignment);
 var i:integer;
begin

{$IF CompilerVersion >= 35 }
  FScrollBox.LockDrawing;
{$IFEND}
  FItemAlignment := AValue;
  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemAlignment := AValue;

 {$IF CompilerVersion >= 35 }
  FScrollBox.UnLockDrawing;
{$IFEND}
end;



procedure TPanelLegend.setOnItemClick( const AValue : TNotifyEvent);
var i:integer;
begin
  FOnItemClick := AValue;

  if assigned(AValue) then
  begin
   for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemCursor := crHandPoint;
  end
  else
  begin
   for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).Cursor := crDefault;
  end


end;

procedure TPanelLegend.setVisualAlignment( const AValue : TVisualAlignment);
 var i:integer;
begin

{$IF CompilerVersion >= 35 }
  FScrollBox.LockDrawing;
{$IFEND}
  FVisualAlignment := AValue;
  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemVisualAlignment := AValue;

 {$IF CompilerVersion >= 35 }
  FScrollBox.UnLockDrawing;
{$IFEND}
end;


procedure TPanelLegend.setItemHeight( const AValue : integer);
var i:integer;
begin

{$IF CompilerVersion >= 35 }
  FScrollBox.LockDrawing;
{$IFEND}
  FItemHeight := AValue;
  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemHeight := AValue;

 {$IF CompilerVersion >= 35 }
  FScrollBox.UnLockDrawing;
{$IFEND}
end;




procedure TPanelLegend.setVisualWeight( const AValue : integer);
var i:integer;
begin

 FVisualWeight := AValue;
{$IF CompilerVersion >= 35 }
  FScrollBox.LockDrawing;
{$IFEND}

  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemVisualWeight := AValue;

 {$IF CompilerVersion >= 35 }
  FScrollBox.UnLockDrawing;
{$IFEND}
end;

procedure TPanelLegend.setVisualWidth( const AValue : integer);
var i:integer;
begin

 FVisualWidth := AValue;
{$IF CompilerVersion >= 35 }
  FScrollBox.LockDrawing;
{$IFEND}
  FVisualWidth := AValue;
  for i := 0 to FList.Count-1 do
   TItemLegend(FList[i]).ItemVisualWidth := AValue;

 {$IF CompilerVersion >= 35 }
  FScrollBox.UnLockDrawing;
{$IFEND}
end;

procedure TPanelLegend.doClick(Sender : TObject);
begin
  if assigned(FOnItemClick) then
   FOnItemClick(Sender);
end;

procedure TPanelLegend.doCheckBoxChange(Sender : TObject);
begin
  if assigned(FOnItemCheckBoxChange) then
   FOnItemCheckBoxChange(Sender);
end;



function TPanelLegend.Add(const ACaption:string;const AGraphic:TGraphic; const AObject:TObject=nil):TItemLegend;

begin
 {$IF CompilerVersion >= 35 }
  FScrollBox.LockDrawing;
{$IFEND}
  result             := TItemLegend.Create(FScrollBox);
  result.FOnItemClick:= doClick;
  result.FOnItemCheckBoxChange := doCheckBoxChange;
  result.ItemCaption := ACaption;
  result.ItemObject  := AObject;
  result.ItemVisualWidth := VisualWidth;
  result.ItemFontSize    := ItemFontsize;
  result.ItemFontName := FontName;
  result.top     := 1+(FList.count+1)*result.Height;
  result.ItemVisualAlignment := FVisualAlignment;
  result.ItemAlignment := FItemAlignment;
  result.ItemGraphic := AGraphic;

  result.ItemCheckBox := ItemCheckBox;

  if assigned(FOnItemClick) then
  begin
   result.ItemCursor := crHandPoint;
  end
  else
  begin
   result.ItemCursor := crDefault;
  end ;

  FList.add(result);


 {$IF CompilerVersion >= 35 }
  FScrollBox.UnLockDrawing;
{$IFEND}
end;



function TPanelLegend.Add(const ACaption:string;
                          const AColor:TColor;
                          const AStyle:TVisualStyle=vsFillRect; const AObject:TObject=nil):TItemLegend;
begin
 {$IF CompilerVersion >= 35 }
  FScrollBox.LockDrawing;
{$IFEND}
  result             := TItemLegend.Create(FScrollBox);
  result.FOnItemClick:= doClick;
  result.FOnItemCheckBoxChange := doCheckBoxChange;
  if AStyle=vsFrame then
  begin
   result.ItemColor   := clNone;
   result.ItemBorderColor := AColor;
  end
  else
  result.ItemColor   := AColor;
  result.ItemVisualStyle := AStyle;
  result.ItemCaption := ACaption;
  result.ItemObject   := AObject;
  result.ItemVisualWidth := VisualWidth;
  result.ItemFontSize    := ItemFontsize;
  result.ItemFontName := FontName;
  result.top     := 1+(FList.count+1)*result.Height;
  result.ItemVisualAlignment := FVisualAlignment;
  result.ItemAlignment := FItemAlignment;
  result.ItemHeight  := FItemHeight;
  result.ItemVisualWeight := FVisualWeight;

  result.ItemCheckBox := ItemCheckBox;

  if assigned(FOnItemClick) then
  begin
   result.ItemCursor := crHandPoint;
  end
  else
  begin
   result.ItemCursor := crDefault;
  end ;


  FList.add(result);
 {$IF CompilerVersion >= 35 }
  FScrollBox.UnLockDrawing;
{$IFEND}


end;



function TItemLegend.isGraphic:boolean;
begin
   result := assigned(ItemGraphic);
end;

procedure  TItemLegend.doclick(Sender:TObject);
begin
  if assigned(FOnItemClick) then
   FOnItemClick(Self);
end;


procedure  TItemLegend.doCheckBox(Sender:TObject);
begin
  if assigned(FOnItemCheckBoxChange) then
   FOnItemCheckBoxChange(Self);
end;


function   TItemLegend.getColor : TColor;
begin
  result := FColor.Color;
end;


function   TItemLegend.getGraphic : TGraphic;
begin
   result := FImage.Picture.Graphic;
end;

procedure  TItemLegend.setGraphic(const AGraphic:TGraphic);
begin
 if assigned(AGraphic) then
 begin
  //FColor.Width := AGraphic.Width;
  FImage.Picture.Assign(AGraphic);
  FImage.Width := AGraphic.Width;
  Height       := AGraphic.Height;
  {$IF CompilerVersion >= 21 }
   Height := Height + Padding.Top+Padding.Bottom ;
  {$IFEND}
  FImage.Visible     := true;
  FColor.ParentColor := true;
  FColor.Width       := Largest(FImage.Width,FColor.Width);
  FColor.BorderColor := clNone;
 end
 else begin
       ItemVisualStyle := ItemVisualStyle;
       setColor(FVisualColor);
      end;
end;

procedure  TItemLegend.setColor(const AColor:TColor);
begin
 FImage.Visible     := false;
 FImage.Picture.assign(nil);
 FVisualColor       := AColor;
 FColor.Color       := AColor;
 FColor.BorderColor := GetShadowColorBy(AColor,32);
end;

procedure  TItemLegend.setBorderColor(const AColor:TColor);
begin
 FColor.BorderColor := AColor;
end;

function  TItemLegend.getBorderColor:TColor;
begin
 result := FColor.BorderColor ;
end;


procedure TItemLegend.setVisualStyle(const AValue:TVisualStyle);
begin
  FImage.Visible     := false;
  FImage.picture.assign(nil);
  FColor.Style := AValue;
end;

function  TItemLegend.getVisualStyle : TVisualStyle;
begin
  result := FColor.Style;
end;

procedure TItemLegend.setVisualWeight(const AValue:integer);
begin
  FColor.Weight := AValue;
end;

function  TItemLegend.getVisualWeight : integer;
begin
  result := FColor.Weight;
end;


procedure TItemLegend.setItemAlignment(const AValue:TAlignment);
begin
 FItemAlignment     := AValue;
 Fcaption.Alignment := AValue;
end;

procedure TItemLegend.setVisualAlignment(const AValue:TVisualAlignment);
begin
{$IF CompilerVersion >= 35 }
  LockDrawing;
{$IFEND}

  FVisualAlignment := AValue;

  if FVisualAlignment=valRight then
  begin
    //FCheckBox.Align  := alRight;
    FColor.Align := alRight;
    FSepa.Align  := alRight;
    FSepa.Left   := FCaption.Left+FCaption.Width;
    FColor.Left  := Fsepa.Left+7;

  end
  else
  begin
    FColor.Align := alLeft;
    FSepa.Align  := alLeft;
    FCheckBox.Align  := alLeft;
    FCheckBox.Left := 0;
    FColor.Left := FCheckBox.width;
    FSepa.Left  := FColor.Width;
  end;
 {$IF CompilerVersion >= 35 }
  UnLockDrawing;
{$IFEND}

end;

procedure TItemLegend.setVisualWidth(const AValue:integer);
begin

{$IF CompilerVersion >= 35 }
  LockDrawing;
{$IFEND}
  FColor.Width := AValue;

{$IF CompilerVersion >= 35 }
  UnLockDrawing;
{$IFEND}
end;

function TItemLegend.getVisualWidth:integer;
begin
  result := FColor.Width;
end;

procedure TItemLegend.setFontColor(const AValue:TColor);
begin
  Fcaption.Font.color := AValue;
end;

function  TItemLegend.getFontColor:TColor;
begin
 result := Fcaption.Font.color;
end;

procedure TItemLegend.setFontName(const AValue:string);
begin
 Fcaption.Font.Name := AValue;
 ItemFontSize := ItemFontSize;
end;

function  TItemLegend.getFontName:string;
begin
  result := Fcaption.Font.Name;
end;


procedure TItemLegend.setItemCheckBox(const AValue:boolean);
begin
 FCheckBox.Visible := AValue;
 FCheckBox.Left    := 0;
end;

function  TItemLegend.getItemCheckBox:boolean;
begin
 result := FCheckBox.Visible;
end;

procedure TItemLegend.setItemChecked(const AValue:boolean);
begin
  FCheckBox.Checked := AValue;
end;

function  TItemLegend.getItemChecked:boolean;
begin
 result := FCheckBox.Checked ;
end;

procedure TItemLegend.setItemHeight(const AValue:integer);
begin
  Height := Largest(AValue,MinHeight);
end;

function  TItemLegend.getItemHeight:integer;
begin
 result := Height;
end;

function  TItemLegend.MinHeight:integer;
begin
   result := FCaption.Canvas.textHeight(FCaption.Caption) {$IF CompilerVersion >= 21 }+ Padding.Top+ Padding.Bottom{$ELSE}+14{$IFEND};
end;

procedure TItemLegend.setFontSize(const AValue:integer);
begin
 {$IF CompilerVersion >= 35 }
  LockDrawing;
{$IFEND}
   FCaption.AutoSize := true;
   Fcaption.Font.Size := AValue;
   Height := MinHeight;
   FCaption.AutoSize := false;
{$IF CompilerVersion >= 35 }
  UnLockDrawing;
{$IFEND}
end;

function  TItemLegend.getFontSize:integer;
begin
  result := Fcaption.Font.Size;
end;


function   TItemLegend.getCaption : string;
begin
  result := FCaption.Caption;
end;

procedure  TItemLegend.setCaption(const ACaption:String);
begin
   FCaption.Caption := {$IF CompilerVersion < 21 }' '+{$IFEND}ACaption;

   FCaption.AutoSize := true;
   Height := MinHeight;
   FCaption.AutoSize := false;
end;




procedure TItemLegend.setItemCursor(const AValue:TCursor);
begin
 FColor.Cursor   := AValue;
 FImage.Cursor   := AValue;
 FCaption.Cursor := AValue;
end;

function  TItemLegend.getItemCursor:TCursor;
begin
  result := FColor.Cursor;
end;

constructor TItemLegend.Create(AOwner:TComponent);
{$IF CompilerVersion < 21 }
var padding:TLabel;
    _parent:TPanel;
{$IFEND}
begin
 inherited Create(AOwner);


  ParentBackGround := false;

  Parent           := TWinControl(AOwner);
  Align            := alTop;
  ParentColor      := true;
  BevelInner       := bvNone;
  BevelOuter       := bvNone;
  {$IF CompilerVersion >= 21 }
  Padding.Top      := 3;
  Padding.Bottom   := 3;
  Padding.Left     := 3;
  Padding.right    := 3;
  {$ELSE}
   padding := TLabel.Create(AOwner);
   padding.Parent  := self;
   padding.Caption := '';
   padding.height   := 4;
   padding.Align   := albottom;
   _parent := TPanel.create(AOwner);

   _parent.Parent           := self;
   _parent.Align            := alClient;
   _parent.ParentColor      := true;
   _parent.BevelInner       := bvNone;
   _parent.BevelOuter       := bvNone;

   padding := TLabel.Create(AOwner);
   padding.Parent  := _parent;
   padding.Caption := ' ';
   padding.Width   := 7;
   padding.Align   := alLeft;
  {$IFEND}


  FColor                := TPanelCustomLegende.Create(AOwner);
  FColor.Weight         := 2;
  FColor.Parent         := {$IF CompilerVersion >= 21 }self{$ELSE}_parent{$IFEND};
  FColor.Align          := alLeft;
  FColor.Width          := 16;
  FColor.BevelInner     := bvNone;
  FColor.BevelOuter     := bvNone;
  {$IF CompilerVersion >= 21 }
  FColor.Padding.Left   := 0;
  FColor.Padding.right  := 0;
  FColor.Padding.top    := 0;
  FColor.Padding.bottom := 0;
  {$ELSE}
   FColor.Left := 7;
  {$IFEND}

  FColor.OnClick:= doclick;


  FImage              := TImage.Create(AOwner);
  FImage.Parent       := FColor;
  FImage.Align        := alClient;
  FImage.OnClick      := doclick;

  FImage.Center       := true;
  FImage.Proportional := true;
  FImage.Stretch      := true;
  FImage.Visible      := false;


  FSepa := TPanelCustomLegende.Create(AOwner);
  FSepa.Parent := {$IF CompilerVersion >= 21 }self{$ELSE}_parent{$IFEND};
  FSepa.Left   := FColor.Width;
  FSepa.Align  := alLeft;
  FSepa.Width := {$IF CompilerVersion >= 21 }Padding.left{$ELSE}7{$IFEND} ;

  if FSepa.Width<7 then
   FSepa.Width := 7;

  FSepa.ParentColor      := true;

  FSepa.BorderColor := clNone;
  FSepa.BevelInner := bvNone;
  FSepa.BevelOuter := bvNone;

  FPCaption := TPanelCustomLegende.Create(AOwner);
  FPCaption.Parent := {$IF CompilerVersion >= 21 }self{$ELSE}_parent{$IFEND};
  FPCaption.Left   := FSepa.Left+10;
  FPCaption.ParentColor      := true;
  FPCaption.BorderColor := clNone;
  FPCaption.BevelInner := bvNone;
  FPCaption.BevelOuter := bvNone;
  FPCaption.Align      := alclient;

  FCaption := TLabel.Create(AOwner);
  FCaption.Parent := FPCaption;
  FCaption.OnClick:= doclick;

  Height := MinHeight;
  FCaption.Align  := albottom;


  FCheckBox := TCheckBox.Create(AOwner);
  FCheckBox.Parent         := {$IF CompilerVersion >= 21 }self{$ELSE}_parent{$IFEND};
  FCheckBox.Align          := alLeft;
  FCheckBox.Width          := 24;
  FCheckBox.Caption        := '';
  FCheckBox.Left           := 0;
  FCheckBox.OnClick        := doCheckBox;


  ItemVisualAlignment:=valLeft;



end;




procedure TPanelCustomLegende.setStyle(const AValue:TVisualStyle);
begin
 FStyle := AValue;
 invalidate;
end;

procedure TPanelCustomLegende.setBorderColor(const AColor:TColor);
begin
 FBorderColor := AColor;
 invalidate;
end;


procedure TPanelCustomLegende.setWeight(const AValue:integer);
begin
  FWeight := AValue;
  invalidate;
end;

// avoid flickering
procedure TPanelCustomLegende.WMEraseBkgnd(var Message: TWmEraseBkgnd);
begin
  Message.Result := 0
end;



procedure TPanelCustomLegende.Paint;
var
  vRect: TRect;
  y,i    : integer;
begin

   vRect := GetClientRect;


   case FStyle of
     vsFrame,
     vsFillRect:
     begin
      if Color<>clNone then
       Canvas.Brush.Color := color
      else
       Canvas.Brush.Color := TPanel(Parent).Color;
       Canvas.FillRect(vREct) ;


       if BorderColor<>clNone then
       begin
        Canvas.Brush.Color := BorderColor;
        Canvas.FrameRect(vRect);
       end;
      end
     else
     begin
       Canvas.Brush.Color := TPanel(Parent).color;
       Canvas.FillRect(vREct) ;
       Canvas.Brush.Color := TPanel(Parent).color;
       Canvas.FrameRect(vRect);

       Canvas.Pen.Color := color;

        y := (vREct.Bottom - FWeight) div 2;
        case FStyle of
          vsSolidLine: Canvas.Pen.Style := Graphics.psSolid;
          vsDotLine: Canvas.Pen.Style := Graphics.psDot;
          vsDashLine: Canvas.Pen.Style := Graphics.psDash;
          vsDashDotLine: Canvas.Pen.Style := Graphics.psDashDot;
        end;
       Canvas.Pen.width := 1;
       for i:=0 to FWeight-1 do
       begin
        canvas.MoveTo(0,y);
        canvas.LineTo(vRect.Right,y);
        inc(y);
       end;

     end;


   end;


end;

end.
