﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'uecMapillary.pas' rev: 37.00 (Windows)

#ifndef uecMapillaryHPP
#define uecMapillaryHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <Winapi.Messages.hpp>
#include <System.SysUtils.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <Vcl.StdCtrls.hpp>
#include <Vcl.Controls.hpp>
#include <uecNativeMapControl.hpp>
#include <uecNativeShape.hpp>
#include <UECMapZIP.hpp>
#include <System.DateUtils.hpp>
#include <System.Math.hpp>
#include <vector_tile.hpp>
#include <System.Generics.Collections.hpp>
#include <System.Generics.Defaults.hpp>
#include <Vcl.Dialogs.hpp>
#include <Vcl.Forms.hpp>
#include <Vcl.ExtCtrls.hpp>
#include <UECMapUtil.hpp>
#include <uecHttp.hpp>
#include <System.StrUtils.hpp>
#include <System.SyncObjs.hpp>
#include <System.Types.hpp>
#include <System.UITypes.hpp>

//-- user supplied -----------------------------------------------------------

namespace Uecmapillary
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TMapillaryImage;
class DELPHICLASS TMapillarySequence;
struct TSequenceImage;
struct TDataDetections;
struct TTrafficSign;
class DELPHICLASS TMapillarySequences;
class DELPHICLASS TMapillaryTile;
class DELPHICLASS TMapillaryTiles;
class DELPHICLASS TThreadMapillary;
class DELPHICLASS TMapillary;
class DELPHICLASS TECMapillaryLayer;
//-- type declarations -------------------------------------------------------
class PASCALIMPLEMENTATION TMapillaryImage : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TMapillary* FMapillary;
	System::TDateTime FCaptured_at;
	__int64 FCompass_angle;
	double FLat;
	double FLng;
	__int64 FId;
	System::UnicodeString FUrl256;
	System::UnicodeString FUrl1024;
	System::UnicodeString FUrl2048;
	System::UnicodeString FSequence_id;
	__int64 FOrganization_id;
	bool FPano;
	System::UnicodeString FAccessToken;
	System::UnicodeString FLocalCache;
	double FMaxDayInCache;
	void __fastcall GetImageFields();
	System::UnicodeString __fastcall getUrl256();
	System::UnicodeString __fastcall getUrl1024();
	System::UnicodeString __fastcall getUrl2048();
	
public:
	__fastcall TMapillaryImage(TMapillary* const Mapillary);
	__property __int64 Compass_angle = {read=FCompass_angle, write=FCompass_angle};
	__property double Lat = {read=FLat, write=FLat};
	__property double Lng = {read=FLng, write=FLng};
	__property System::UnicodeString Sequence_id = {read=FSequence_id, write=FSequence_id};
	__property __int64 Organization_id = {read=FOrganization_id, write=FOrganization_id};
	__property __int64 Id = {read=FId, write=FId};
	__property System::TDateTime Captured_at = {read=FCaptured_at, write=FCaptured_at};
	__property bool is_Pano = {read=FPano, write=FPano, nodefault};
	__property System::UnicodeString Url256 = {read=getUrl256};
	__property System::UnicodeString Url1024 = {read=getUrl1024};
	__property System::UnicodeString Url2048 = {read=getUrl2048};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TMapillaryImage() { }
	
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TMapillarySequence : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TMapillaryImage* operator[](int index) { return this->Images[index]; }
	
private:
	System::UnicodeString FSequence_id;
	System::Uitypes::TColor FColor;
	bool FValidateDate;
	System::Generics::Collections::TList__1<TMapillaryImage*>* FImages;
	Winapi::Windows::TRTLCriticalSection FCritSect;
	TMapillaryImage* __fastcall getImage(int index);
	void __fastcall Sort();
	void __fastcall Lock();
	void __fastcall UnLock();
	int __fastcall add(TMapillaryImage* item);
	
public:
	__fastcall TMapillarySequence();
	__fastcall virtual ~TMapillarySequence();
	void __fastcall Clear();
	int __fastcall Count();
	__property TMapillaryImage* Images[int index] = {read=getImage/*, default*/};
	__property System::UnicodeString Sequence_id = {read=FSequence_id};
	__property System::Uitypes::TColor Color = {read=FColor, nodefault};
};

#pragma pack(pop)

struct DECLSPEC_DRECORD TSequenceImage
{
public:
	TMapillarySequence* Sequence;
	int ImageIndex;
};


struct DECLSPEC_DRECORD TDataDetections
{
public:
	System::UnicodeString id;
	System::UnicodeString value;
	System::UnicodeString create_at;
	System::UnicodeString geometry;
};


struct DECLSPEC_DRECORD TTrafficSign
{
public:
	__int64 id;
	System::TDateTime First_seen_at;
	System::TDateTime last_seen_at;
	double lat;
	double lng;
	System::UnicodeString value;
};


typedef System::Generics::Collections::TList__1<TSequenceImage> TListSequenceImage;

typedef System::Generics::Collections::TList__1<TDataDetections> TListDataDetections;

typedef System::Generics::Collections::TList__1<TTrafficSign> TListTrafficSign;

typedef System::Generics::Collections::TObjectDictionary__2<System::UnicodeString,TMapillarySequence*> TListSequences;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TMapillarySequences : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TMapillarySequence* operator[](int index) { return this->Sequences[index]; }
	
private:
	TListSequences* FList;
	TMapillarySequence* L;
	System::UnicodeString FPrevSequence;
	TMapillarySequence* __fastcall getMapillaryImageList(int index);
	TMapillarySequence* __fastcall getMapillaryImageListName(const System::UnicodeString index);
	void __fastcall Clear();
	int __fastcall addMapillaryImage(TMapillaryImage* const image);
	
public:
	__fastcall TMapillarySequences();
	__fastcall virtual ~TMapillarySequences();
	int __fastcall Count();
	__property TMapillarySequence* Sequences[int index] = {read=getMapillaryImageList/*, default*/};
	__property TMapillarySequence* Sequence[const System::UnicodeString index] = {read=getMapillaryImageListName};
	System::UnicodeString __fastcall getName(const int index);
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TMapillaryTile : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TMapillarySequences* FSequences;
	TListTrafficSign* FTrafficSign;
	int FX;
	int FY;
	bool FShow;
	
public:
	__fastcall TMapillaryTile();
	__fastcall virtual ~TMapillaryTile();
	__property TMapillarySequences* Sequences = {read=FSequences};
	__property TListTrafficSign* TrafficSign = {read=FTrafficSign};
	__property int X = {read=FX, nodefault};
	__property int Y = {read=FY, nodefault};
	__property bool Show = {read=FShow, nodefault};
};

#pragma pack(pop)

typedef System::Generics::Collections::TObjectDictionary__2<System::UnicodeString,TMapillaryTile*> TMapillaryTileList;

typedef System::Generics::Collections::TList__1<Uecmaputil::TBoundsLatLng> TMapillaryAreaList;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TMapillaryTiles : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TMapillaryTile* operator[](const int index) { return this->Tile[index]; }
	
private:
	Winapi::Windows::TRTLCriticalSection FCritSect;
	TMapillaryTileList* FList;
	TMapillaryTile* __fastcall getTile(const int index);
	void __fastcall Lock();
	void __fastcall UnLock();
	void __fastcall Clear();
	void __fastcall add(const System::UnicodeString key, TMapillaryTile* const value);
	bool __fastcall TryGetValue(const System::UnicodeString key, TMapillaryTile* &value);
	
public:
	__fastcall TMapillaryTiles();
	__fastcall virtual ~TMapillaryTiles();
	int __fastcall Count();
	__property TMapillaryTile* Tile[const int index] = {read=getTile/*, default*/};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TThreadMapillary : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	TMapillary* FMapillary;
	double FNorthEastLatitude;
	double FNorthEastLongitude;
	double FSouthWestLatitude;
	double FSouthWestLongitude;
	
public:
	__fastcall TThreadMapillary(TMapillary* Mapillary, double NorthEastLatitude, double NorthEastLongitude, double SouthWestLatitude, double SouthWestLongitude, System::Classes::TNotifyEvent doOnTerminate);
	virtual void __fastcall Execute();
public:
	/* TThread.Destroy */ inline __fastcall virtual ~TThreadMapillary() { }
	
};


class PASCALIMPLEMENTATION TMapillary : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Uechttp::TuecHttp* _image_http;
	System::Classes::TStringList* _image_strings;
	TMapillaryTiles* FTiles;
	System::Classes::TMemoryStream* FBitmapStream;
	System::Classes::TStringStream* FDetectionStream;
	System::UnicodeString FAccessToken;
	System::UnicodeString FCoverageUrl;
	System::UnicodeString FTrafficSignUrl;
	System::UnicodeString FLocalCache;
	double FMaxDayInCache;
	Uecmaputil::TECWorldInfo* MapillaryWorld;
	Uechttp::TuecHttp* Http;
	System::Classes::TMemoryStream* Stream;
	TThreadMapillary* FThreadMapillary;
	System::Classes::TNotifyEvent FOnCoverageTiles;
	Vector_tile::TTile* Tile;
	Vector_tile::TLayer* layer;
	TMapillaryAreaList* FAreaList;
	void __fastcall setLocalCache(const System::UnicodeString value);
	void __fastcall doCoverageTiles(double NorthEastLatitude, double NorthEastLongitude, double SouthWestLatitude, double SouthWestLongitude);
	void __fastcall doFillTile();
	void __fastcall doEndThread(System::TObject* sender);
	
public:
	__fastcall TMapillary();
	__fastcall virtual ~TMapillary();
	void __fastcall Abort();
	bool __fastcall LoadMapillaryBitmap(const System::UnicodeString url, Vcl::Graphics::TBitmap* const FBitmap);
	int __fastcall DetectionsImage(const __int64 image_id, TListDataDetections* const List);
	bool __fastcall Bounds(double NorthEastLatitude, double NorthEastLongitude, double SouthWestLatitude, double SouthWestLongitude);
	__property TMapillaryTiles* Tiles = {read=FTiles};
	__property System::UnicodeString AccessToken = {read=FAccessToken, write=FAccessToken};
	__property System::UnicodeString CoverageUrl = {read=FCoverageUrl, write=FCoverageUrl};
	__property System::UnicodeString TrafficSignUrl = {read=FTrafficSignUrl, write=FTrafficSignUrl};
	__property System::UnicodeString LocalCache = {read=FLocalCache, write=setLocalCache};
	__property double MaxDayInCache = {read=FMaxDayInCache, write=FMaxDayInCache};
	__property System::Classes::TNotifyEvent OnCoverageTiles = {read=FOnCoverageTiles, write=FOnCoverageTiles};
};


typedef void __fastcall (__closure *TOnMapillaryLayerClick)(TECMapillaryLayer* layer, Uecnativeshape::TECShape* item, TMapillarySequence* MapillarySequence, int ImageIndex);

typedef void __fastcall (__closure *TOnMapillaryLayerTrafficSignClick)(TECMapillaryLayer* layer, Uecnativeshape::TECShape* item, TListTrafficSign* ListTrafficSign, int TrafficSignIndex);

typedef void __fastcall (__closure *TOnMapillarySequenceColor)(TECMapillaryLayer* layer, TMapillarySequence* MappilarySequence, System::Uitypes::TColor &SequenceColor);

class PASCALIMPLEMENTATION TECMapillaryLayer : public Uecnativemapcontrol::TECNativeLayer
{
	typedef Uecnativemapcontrol::TECNativeLayer inherited;
	
private:
	double _FNELat;
	double FNELat;
	double _FNELng;
	double FNELng;
	double _FSWLat;
	double FSWLat;
	double _FSWLng;
	double FSWLng;
	Uecnativeshape::TECShapes* FTrafficShapes;
	bool FTrafficSignVisible;
	System::Byte FMinZoom;
	TMapillary* FMapillary;
	System::Classes::TNotifyEvent FOnBeginRequest;
	System::Classes::TNotifyEvent FOnEndRequest;
	TOnMapillarySequenceColor FOnMapillarySequenceColor;
	TOnMapillaryLayerClick FOnClick;
	TOnMapillaryLayerTrafficSignClick FOnTrafficSignClick;
	System::UnicodeString __fastcall getLocalCache();
	void __fastcall setLocalCache(const System::UnicodeString value);
	double __fastcall getMaxDayInCache();
	void __fastcall setMaxDayInCache(const double value);
	System::UnicodeString __fastcall getAccessToken();
	void __fastcall setAccessToken(const System::UnicodeString value);
	void __fastcall setTrafficSignVisible(const bool value);
	
protected:
	virtual void __fastcall setVisible(const bool value);
	virtual void __fastcall doOnMapEndMove(System::TObject* sender);
	virtual void __fastcall doOnShapeClick(System::TObject* sender);
	void __fastcall doOnCoverageTiles(System::TObject* sender);
	TMapillaryTiles* __fastcall getMapillaryTiles();
	
public:
	__fastcall virtual TECMapillaryLayer(Uecnativemapcontrol::TNativeMapControl* _FMap, const System::UnicodeString Name);
	__fastcall virtual ~TECMapillaryLayer();
	void __fastcall SearchBounds(double NorthEastLatitude, double NorthEastLongitude, double SouthWestLatitude, double SouthWestLongitude);
	void __fastcall Abort();
	int __fastcall FindImageClose(const double Lat, const double Lng, int DistanceMeter, TMapillarySequence* &seq, int &ImageIndex);
	int __fastcall SearchImageClose(const double Lat, const double Lng, int DistanceMeter, TListSequenceImage* ListSequenceImage)/* overload */;
	int __fastcall SearchImageClose(const double Lat, const double Lng, double DistanceKM, TListSequenceImage* ListSequenceImage)/* overload */;
	virtual void __fastcall Clear();
	void __fastcall ClearAll();
	bool __fastcall isActiveRequest();
	bool __fastcall LoadMapillaryBitmap(const System::UnicodeString url, Vcl::Graphics::TBitmap* const FBitmap);
	int __fastcall DetectionsImage(const __int64 image_id, TListDataDetections* const List);
	__property TMapillaryTiles* Tiles = {read=getMapillaryTiles};
	__property System::UnicodeString AccessToken = {read=getAccessToken, write=setAccessToken};
	__property System::UnicodeString LocalCache = {read=getLocalCache, write=setLocalCache};
	__property double MaxDayInCache = {read=getMaxDayInCache, write=setMaxDayInCache};
	__property System::Byte MinZoom = {read=FMinZoom, write=FMinZoom, nodefault};
	__property bool TrafficSignVisible = {read=FTrafficSignVisible, write=setTrafficSignVisible, nodefault};
	__property Uecnativeshape::TECShapes* TrafficShapes = {read=FTrafficShapes};
	__property TOnMapillaryLayerClick OnClick = {read=FOnClick, write=FOnClick};
	__property TOnMapillaryLayerTrafficSignClick OnTrafficSignClick = {read=FOnTrafficSignClick, write=FOnTrafficSignClick};
	__property TOnMapillarySequenceColor OnSequenceColor = {read=FOnMapillarySequenceColor, write=FOnMapillarySequenceColor};
	__property System::Classes::TNotifyEvent OnBeginRequest = {read=FOnBeginRequest, write=FOnBeginRequest};
	__property System::Classes::TNotifyEvent OnEndRequest = {read=FOnEndRequest, write=FOnEndRequest};
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE TECMapillaryLayer* __fastcall CreateMapillaryLayer(Uecnativemapcontrol::TNativeMapControl* FMap, System::Classes::TNotifyEvent BeginRequest = 0x0, System::Classes::TNotifyEvent EndRequest = 0x0, const System::UnicodeString Name = L"_mappilary");
}	/* namespace Uecmapillary */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_UECMAPILLARY)
using namespace Uecmapillary;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// uecMapillaryHPP
