﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'uecNativeShape.pas' rev: 37.00 (Windows)

#ifndef uecNativeShapeHPP
#define uecNativeShapeHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <Vcl.Forms.hpp>
#include <Winapi.Messages.hpp>
#include <System.SysUtils.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <Vcl.Controls.hpp>
#include <UECMapUtil.hpp>
#include <Vcl.Dialogs.hpp>
#include <System.StrUtils.hpp>
#include <Vcl.ImgList.hpp>
#include <Vcl.Imaging.pngimage.hpp>
#include <uecRstar_tree.hpp>
#include <uecHeatmap.hpp>
#include <uecWKTObjects.hpp>
#include <uecWKTParser.hpp>
#include <uecVectorStyles_standard.hpp>
#include <System.Generics.Collections.hpp>
#include <System.Generics.Defaults.hpp>
#include <System.Types.hpp>
#include <System.UITypes.hpp>
#include <System.Math.hpp>
#include <UECMapZIP.hpp>
#include <uecMapFile.hpp>
#include <Vcl.ExtCtrls.hpp>
#include <uecGeoLocalise.hpp>
#include <uecThreadGraphics.hpp>
#include <uecOpenWeather.hpp>
#include <UECGraphics.hpp>

//-- user supplied -----------------------------------------------------------

namespace Uecnativeshape
{
//-- forward type declarations -----------------------------------------------
struct TSlopeColor;
class DELPHICLASS TCSlopeColors;
class DELPHICLASS TPaireLatLng;
struct TNearestLine;
class DELPHICLASS TGlobalKeyValue;
class DELPHICLASS TThreadCSV;
class DELPHICLASS TecCSV;
class DELPHICLASS TECPointLine;
struct TNearestPolygone;
class DELPHICLASS TECMasterShape;
class DELPHICLASS TECCMasterShapeList;
class DELPHICLASS TECBaseGeofence;
class DELPHICLASS TECCirclegeoFence;
class DELPHICLASS TECPointGeofence;
class DELPHICLASS TECPolygonGeofence;
class DELPHICLASS TECLineGeofence;
class DELPHICLASS TECGeofences;
struct TValueIntegerRangeZoom;
struct TValueDoubleRangeZoom;
class DELPHICLASS TIntegerRangeZoom;
class DELPHICLASS TPoiShapeRangeZoom;
class DELPHICLASS TStyleIconRangeZoom;
class DELPHICLASS TLineTypeRangeZoom;
class DELPHICLASS TDoubleRangeZoom;
class DELPHICLASS TECCartoCSSValues;
class DELPHICLASS TECCartoStyles;
class DELPHICLASS TGeoJSONGeometryParser;
class DELPHICLASS TPropertyValue;
class DELPHICLASS TECShape;
class DELPHICLASS TECAnimationShape;
class DELPHICLASS TecAnimationDash;
class DELPHICLASS TecAnimationBlink;
class DELPHICLASS TECAnimationFade;
class DELPHICLASS TECAnimationScale;
class DELPHICLASS TECAnimationFadePOI;
class DELPHICLASS TECAnimationRadiusFov;
class DELPHICLASS TECAnimationAutoHide;
class DELPHICLASS TECAnimationAutoShow;
class DELPHICLASS TECAnimationCustom;
class DELPHICLASS TECAnimationShapeColor;
class DELPHICLASS TECAnimationSwapColorBorderColor;
class DELPHICLASS TECAnimationMarkerFilename;
class DELPHICLASS TECAnimationMarkerZoomFilename;
class DELPHICLASS TECAnimationGraphicWait;
class DELPHICLASS TECAnimationDrawPath;
class DELPHICLASS TECAnimationMoveOnPath;
class DELPHICLASS TECAnimationMoveToDirection;
class DELPHICLASS TecHotSpot;
class DELPHICLASS TLabelShape;
class DELPHICLASS TECShapeInfoWindow;
class DELPHICLASS TECShapePOI;
class DELPHICLASS TEditShapePOI;
class DELPHICLASS TOpenWeatherStationData;
class DELPHICLASS TECShapeLine;
class DELPHICLASS TECShapePolygone;
class DELPHICLASS TECTextFont;
class DELPHICLASS TECShapeMarker;
class DELPHICLASS TECShapeList;
class DELPHICLASS TECShapeInfoWindowList;
class DELPHICLASS TECShapeInfoWindowListEnumerator;
class DELPHICLASS TECShapeListHeatMap;
class DELPHICLASS TECShapePOIList;
class DELPHICLASS TECShapePOIListEnumerator;
class DELPHICLASS TECShapeMarkerList;
class DELPHICLASS TECShapeMarkerListEnumerator;
class DELPHICLASS TECShapeLineList;
class DELPHICLASS TECShapeLineListEnumerator;
class DELPHICLASS TECShapePolygoneList;
class DELPHICLASS TECShapePolygoneListEnumerator;
class DELPHICLASS TECNativeRoutePath;
class DELPHICLASS TECCluster;
struct TECClusterCategorie;
class DELPHICLASS TECClusterManager;
class DELPHICLASS TECClusterList;
class DELPHICLASS TECClusters;
class DELPHICLASS TECSelectedShapesList;
class DELPHICLASS TECSelectedShapesListEnumerator;
class DELPHICLASS TECGroupShapesEnumerator;
class DELPHICLASS TECGroupShapesList;
class DELPHICLASS TThreadWeatherRoute;
class DELPHICLASS TRStarTree;
class DELPHICLASS TThreadECDirection;
class DELPHICLASS TECShapeKMLStyle;
class DELPHICLASS TECShapesGroup;
class DELPHICLASS TThreadShapeList;
class DELPHICLASS TThreadShapesKml;
class DELPHICLASS TThreadShapesWKT;
class DELPHICLASS TThreadShapesgeoJson;
class DELPHICLASS TThreadShapesGPX;
class DELPHICLASS TThreadShapesTXT;
class DELPHICLASS TECShapes;
//-- type declarations -------------------------------------------------------
struct DECLSPEC_DRECORD TSlopeColor
{
public:
	double MinSlope;
	double MaxSlope;
	System::Uitypes::TColor Color;
};


typedef System::DynamicArray<TSlopeColor> TSlopeColors;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TCSlopeColors : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TSlopeColors FASlopeColors;
	System::Byte FOpacity;
	System::Byte FWeight;
	
public:
	__fastcall TCSlopeColors();
	__fastcall virtual ~TCSlopeColors();
	int __fastcall Count();
	void __fastcall Clear();
	int __fastcall Find(const double Slope, TSlopeColor &ASlopeColor);
	bool __fastcall FindColor(const double Slope, System::Uitypes::TColor &AColor);
	TSlopeColor __fastcall Get(const int index);
	void __fastcall Add(const double AMinSlope, const double AMaxSlope, System::Uitypes::TColor AColor);
	void __fastcall Delete(const int index);
	__property System::Byte Weight = {read=FWeight, write=FWeight, nodefault};
	__property System::Byte Opacity = {read=FOpacity, write=FOpacity, nodefault};
};

#pragma pack(pop)

typedef System::StaticArray<tagRGBQUAD, 65536> TRGBALine;

typedef TRGBALine *PRGBALine;

class PASCALIMPLEMENTATION TPaireLatLng : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Uecmaputil::TLatLng Point1;
	Uecmaputil::TLatLng Point2;
public:
	/* TObject.Create */ inline __fastcall TPaireLatLng() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TPaireLatLng() { }
	
};


typedef System::NativeInt PtrInt;

enum DECLSPEC_DENUM TNativeShape : unsigned char { nsPoi, nsMarker, nsPolygon, nsLine, nsInfoWindow };

typedef System::Set<TNativeShape, TNativeShape::nsPoi, TNativeShape::nsInfoWindow> TNativeShapes;

typedef void __fastcall (__closure *TOnNotify)(unsigned MsgConst, System::TObject* WParam);

typedef void __fastcall (__closure *TOnRoutePath)(System::TObject* sender, const System::UnicodeString params, Uecgeolocalise::TECRoutePath* routePath);

struct DECLSPEC_DRECORD TNearestLine
{
public:
	double Lat;
	double Lng;
	double Distance;
	TECShapeLine* Line;
};


typedef void __fastcall (__closure *TOnAddRoute)(TECShapeLine* sender, const System::UnicodeString params);

typedef void __fastcall (__closure *TOnChangeRoute)(TECShapeLine* sender, const System::UnicodeString params);

typedef void __fastcall (__closure *TOnErrorRoute)(System::TObject* sender, Uecgeolocalise::TECThreadDataRoute* const dataroute);

typedef void __fastcall (__closure *TOnDrawRoute)(TECShapeLine* sender);

typedef void __fastcall (__closure *TOnGetAltitude)(TECShapeLine* sender, const int Total, bool &cancel);

typedef void __fastcall (*TOnShapeFilter)(TECShape* const Shape, bool &cancel);

typedef void __fastcall (__closure *TOnOpenInfoWindow)(TECShapeInfoWindow* const infoWindow, bool &cancel);

typedef void __fastcall (__closure *TOnAddShapeToCluster)(TECCluster* sender, TECShape* const Shape, bool &cancel);

typedef void __fastcall (__closure *TOnAddShapeToView)(System::TObject* sender, TECShape* const Shape, bool &cancel);

typedef void __fastcall (__closure *TOnSelectShape)(System::TObject* sender, TECShape* const Shape, bool &cancel);

typedef void __fastcall (__closure *TOnShapeLocation)(TECShape* sender, Uecgeolocalise::TECGeoResult* const GeoResult, const bool Valid);

typedef void __fastcall (__closure *TOnDrawShape)(Uecgraphics::TECCanvas* const canvas, System::Types::TRect &rect, TECShape* item);

enum DECLSPEC_DENUM TClusterStyle : unsigned char { csEllipse, csStar, csRect, csTriangle, csTriangleDown, csHexagon, csDiamond, csCategories, csZIndex };

typedef void __fastcall (__closure *TOnDrawCluster)(Uecgraphics::TECCanvas* const canvas, System::Types::TRect &rect, TECCluster* Cluster);

typedef void __fastcall (__closure *TOnClusterGetText)(TECCluster* const Cluster, System::UnicodeString &Text);

typedef void __fastcall (__closure *TOnColorSizeCluster)(TECCluster* const Cluster, System::Uitypes::TColor &Color, System::Uitypes::TColor &BorderColor, System::Uitypes::TColor &TextColor, int &WidthHeight, int &FontSize, TClusterStyle &CStyle);

typedef void __fastcall (__closure *TOnNotifyEventCluster)(TECCluster* const Cluster);

typedef void __fastcall (__closure *TOnShapeFont)(Uecgraphics::TECCanvas* const canvas, TECShape* item);

typedef void __fastcall (__closure *TOnShapeMouseEvent)(System::TObject* sender, TECShape* const item);

typedef void __fastcall (__closure *TOnShapeMousePoint)(System::TObject* sender, const double Lat, const double Lng);

typedef void __fastcall (__closure *TOnShapeMove)(System::TObject* sender, TECShape* const item, bool &cancel);

typedef void __fastcall (__closure *TOnLoadShapes)(System::TObject* sender, const System::UnicodeString ShapeType, const int index, const int max, bool &cancel);

typedef void __fastcall (__closure *TOnHotSpot)(System::TObject* sender, const System::UnicodeString Url);

typedef void __fastcall (*TOnGetScale)(TECShape* Shape, double &ScaleValue);

enum DECLSPEC_DENUM TECLineType : unsigned char { ltStraight, ltBezier, ltDot, ltDotLine };

typedef System::DynamicArray<int> TCardinalKeyValue;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TGlobalKeyValue : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Uecmaputil::TFStringList* FKeys;
	Uecmaputil::TFStringList* FValues;
	
public:
	__fastcall TGlobalKeyValue();
	__fastcall virtual ~TGlobalKeyValue();
	void __fastcall AddKeyValue(const System::UnicodeString key, const System::UnicodeString value, int &iKey, int &iValue);
	System::UnicodeString __fastcall getKey(const int iKey)/* overload */;
	int __fastcall getKey(const System::UnicodeString key)/* overload */;
	System::UnicodeString __fastcall getValue(const int iValue)/* overload */;
	int __fastcall getValue(const System::UnicodeString value)/* overload */;
};

#pragma pack(pop)

typedef void __fastcall (__closure *TOnFilterCSV)(System::Classes::TStringList* const Data, bool &validCSV);

typedef void __fastcall (__closure *TOnCreateCSVPoint)(TECShapes* const Group, TECShape* &CSVPoint, const double Lat, const double Lng, System::Classes::TStringList* const Data);

typedef void __fastcall (__closure *TOnCreateWKTObject)(TECShapes* const Group, TECShape* const WKTObject, const double Lat, const double Lng, System::Classes::TStringList* const Data);

typedef void __fastcall (*TOnConvertLatLng)(double &Lat, double &Lng);

class PASCALIMPLEMENTATION TThreadCSV : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	TecCSV* FCSV;
	
public:
	__fastcall TThreadCSV(TecCSV* CSV, System::Classes::TNotifyEvent doOnTerminate);
	virtual void __fastcall Execute();
public:
	/* TThread.Destroy */ inline __fastcall virtual ~TThreadCSV() { }
	
};


class PASCALIMPLEMENTATION TecCSV : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Winapi::Windows::TRTLCriticalSection FCritSect;
	TThreadCSV* FThreadCSV;
	TECShapes* FShapes;
	Uecmaputil::TecCSVReader* FCSVReader;
	System::Classes::TStringList* FFields;
	System::Classes::TStringList* FData;
	System::UnicodeString FFieldNameWkt;
	System::UnicodeString FFieldNameLatitude;
	System::UnicodeString FFieldNameLongitude;
	int FIdxWKT;
	int FidxLatitude;
	int FidxLongitude;
	TOnFilterCSV FOnFilterCSV;
	TOnCreateCSVPoint FOnCreateCSVPoint;
	TOnCreateWKTObject FOnCreateWKTObject;
	TOnConvertLatLng FOnConvertLatLng;
	bool FinSave;
	System::WideChar FDelimiterLatLng;
	void __fastcall setDelimiter(const System::WideChar value);
	System::WideChar __fastcall getDelimiter();
	void __fastcall doLoad();
	void __fastcall doEndThread(System::TObject* sender);
	void __fastcall doSaveString(const System::UnicodeString S, System::Classes::TStream* const FileStream);
	void __fastcall SaveListToStream(System::Classes::TStream* const Stream, TECShapeList* const ShapeList);
	System::UnicodeString __fastcall SaveListToString(TECShapeList* const ShapeList);
	
public:
	__fastcall TecCSV(TECShapes* const Shapes);
	__fastcall virtual ~TecCSV();
	void __fastcall SaveToFile(const System::UnicodeString filename, TECShapeList* const ShapeList)/* overload */;
	void __fastcall SaveToStream(System::Classes::TStream* const Stream, TECShapeList* const ShapeList)/* overload */;
	void __fastcall SaveToFile(const System::UnicodeString filename, TECShapes* const Shapes)/* overload */;
	void __fastcall SaveToStream(System::Classes::TStream* const Stream, TECShapes* const Shapes)/* overload */;
	bool __fastcall LoadFromFile(const System::UnicodeString filename);
	bool __fastcall LoadFromStream(System::Classes::TStream* const Stream);
	bool __fastcall ASyncLoadFromFile(const System::UnicodeString filename);
	bool __fastcall ASyncLoadFromStream(System::Classes::TStream* const Stream);
	System::UnicodeString __fastcall getToCSV();
	__property System::UnicodeString FieldNameWKT = {read=FFieldNameWkt, write=FFieldNameWkt};
	__property System::UnicodeString FieldNameLatitude = {read=FFieldNameLatitude, write=FFieldNameLatitude};
	__property System::UnicodeString FieldNameLongitude = {read=FFieldNameLongitude, write=FFieldNameLongitude};
	__property int idxLatitude = {read=FidxLatitude, write=FidxLatitude, nodefault};
	__property int idxLongitude = {read=FidxLongitude, write=FidxLongitude, nodefault};
	__property int idxWKT = {read=FIdxWKT, write=FIdxWKT, nodefault};
	__property System::WideChar Delimiter = {read=getDelimiter, write=setDelimiter, nodefault};
	__property System::WideChar DelimiterLatLng = {read=FDelimiterLatLng, write=FDelimiterLatLng, nodefault};
	__property System::Classes::TStringList* Fields = {read=FFields};
	__property TOnCreateCSVPoint OnCreateCSVPoint = {read=FOnCreateCSVPoint, write=FOnCreateCSVPoint};
	__property TOnCreateWKTObject OnCreateWKTObject = {read=FOnCreateWKTObject, write=FOnCreateWKTObject};
	__property TOnConvertLatLng OnConvertLatLng = {read=FOnConvertLatLng, write=FOnConvertLatLng};
	__property TOnFilterCSV OnFilterCSV = {read=FOnFilterCSV, write=FOnFilterCSV};
};


class PASCALIMPLEMENTATION TECPointLine : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	bool FHide;
	double FLat;
	double FLng;
	double FAlt;
	System::TDateTime FTime;
	int FDistance;
	System::UnicodeString FManeuver;
	System::UnicodeString FText;
	System::TObject* FItem;
	
public:
	__property double Lat = {read=FLat, write=FLat};
	__property double Latitude = {read=FLat};
	__property double Lng = {read=FLng, write=FLng};
	__property double Longitude = {read=FLng};
	__property double Alt = {read=FAlt, write=FAlt};
	__property bool Hide = {read=FHide, write=FHide, nodefault};
	__property int Distance = {read=FDistance, write=FDistance, nodefault};
	__property System::UnicodeString Text = {read=FText, write=FText};
	__property System::TDateTime Time = {read=FTime, write=FTime};
	__property System::UnicodeString Maneuver = {read=FManeuver, write=FManeuver};
	__property System::TObject* item = {read=FItem, write=FItem};
public:
	/* TObject.Create */ inline __fastcall TECPointLine() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TECPointLine() { }
	
};


struct DECLSPEC_DRECORD TNearestPolygone
{
public:
	double Lat;
	double Lng;
	double Distance;
	TECShapePolygone* Polygone;
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECMasterShape : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECShape* Shape;
	int Top;
	int Left;
	int Top2;
	int Left2;
public:
	/* TObject.Create */ inline __fastcall TECMasterShape() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TECMasterShape() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECCMasterShapeList : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	virtual void __fastcall Clear();
public:
	/* TList.Destroy */ inline __fastcall virtual ~TECCMasterShapeList() { }
	
public:
	/* TObject.Create */ inline __fastcall TECCMasterShapeList() : System::Classes::TList() { }
	
};

#pragma pack(pop)

typedef System::Generics::Collections::TList__1<TECShape*> TECShapesList;

class PASCALIMPLEMENTATION TECBaseGeofence : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Uecmaputil::TLatLng FEnterPoint;
	Uecmaputil::TLatLng FExitPoint;
	TECShapes* FGroup;
	TECShape* FShape;
	System::TObject* FItem;
	PtrInt FTag;
	double FlatSW;
	double FlngSW;
	double FlatNE;
	double FlngNE;
	System::UnicodeString FName;
	__int64 FActiveDuration;
	__int64 FActiveStart;
	bool FDurationFading;
	bool FActive;
	TECShapesList* FShapes;
	void __fastcall setActive(const bool value);
	bool __fastcall isActive();
	System::Uitypes::TColor __fastcall getColor();
	void __fastcall setColor(System::Uitypes::TColor value);
	System::Uitypes::TColor __fastcall getHoverColor();
	void __fastcall setHoverColor(System::Uitypes::TColor value);
	int __fastcall getOpacity();
	void __fastcall setOpacity(int value);
	void __fastcall setActiveDuration(const __int64 value);
	bool __fastcall isInArea(const double Lat, const double Lng);
	void __fastcall setName(const System::UnicodeString value);
	
public:
	__fastcall TECBaseGeofence();
	__fastcall virtual ~TECBaseGeofence();
	virtual bool __fastcall isHit(const double Lat, const double Lng);
	virtual void __fastcall Bounds();
	__property System::UnicodeString Name = {read=FName, write=setName};
	__property bool Active = {read=FActive, write=setActive, nodefault};
	__property __int64 ActiveDuration = {read=FActiveDuration, write=setActiveDuration};
	__property bool DurationFading = {read=FDurationFading, write=FDurationFading, nodefault};
	__property TECShapesList* Shapes = {read=FShapes};
	__property System::Uitypes::TColor Color = {read=getColor, write=setColor, nodefault};
	__property System::Uitypes::TColor HoverColor = {read=getHoverColor, write=setHoverColor, nodefault};
	__property int Opacity = {read=getOpacity, write=setOpacity, nodefault};
	__property System::TObject* item = {read=FItem, write=FItem};
	__property PtrInt Tag = {read=FTag, write=FTag, nodefault};
	__property TECShape* ShapeFence = {read=FShape};
	__property Uecmaputil::TLatLng EnterPoint = {read=FEnterPoint, write=FEnterPoint};
	__property Uecmaputil::TLatLng ExitPoint = {read=FExitPoint, write=FExitPoint};
};


class PASCALIMPLEMENTATION TECCirclegeoFence : public TECBaseGeofence
{
	typedef TECBaseGeofence inherited;
	
private:
	double FLat;
	double FLng;
	int FRadiusMeter;
	TECShapeLine* FLineContact;
	System::UnicodeString __fastcall getToTxt();
	void __fastcall setTotxt(const System::UnicodeString value);
	void __fastcall SetRadiusMeter(const int value);
	
public:
	__fastcall TECCirclegeoFence(TECShapes* Group, const double Lat, const double Lng, const int RadiusMeter);
	virtual bool __fastcall isHit(const double Lat, const double Lng);
	virtual void __fastcall Bounds();
	__property int RadiusMeter = {read=FRadiusMeter, write=SetRadiusMeter, nodefault};
	__property System::UnicodeString toTxt = {read=getToTxt, write=setTotxt};
public:
	/* TECBaseGeofence.Destroy */ inline __fastcall virtual ~TECCirclegeoFence() { }
	
};


class PASCALIMPLEMENTATION TECPointGeofence : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	double FLat;
	double FLng;
	
public:
	__fastcall TECPointGeofence(const double dLat, const double dLng);
	__property double Latitude = {read=FLat};
	__property double Longitude = {read=FLng};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECPointGeofence() { }
	
};


class PASCALIMPLEMENTATION TECPolygonGeofence : public TECBaseGeofence
{
	typedef TECBaseGeofence inherited;
	
private:
	System::Generics::Collections::TList__1<TECPointGeofence*>* FPoints;
	virtual System::UnicodeString __fastcall getToTxt();
	virtual void __fastcall setTotxt(const System::UnicodeString value);
	
public:
	__fastcall TECPolygonGeofence(TECShapes* Group);
	__fastcall virtual ~TECPolygonGeofence();
	virtual void __fastcall AddPoint(const double Lat, const double Lng);
	virtual void __fastcall Clear();
	virtual bool __fastcall isHit(const double Lat, const double Lng);
	virtual void __fastcall Bounds();
	__property System::UnicodeString toTxt = {read=getToTxt, write=setTotxt};
};


class PASCALIMPLEMENTATION TECLineGeofence : public TECPolygonGeofence
{
	typedef TECPolygonGeofence inherited;
	
private:
	int FMargingMeter;
	virtual System::UnicodeString __fastcall getToTxt();
	virtual void __fastcall setTotxt(const System::UnicodeString value);
	
public:
	__fastcall TECLineGeofence(TECShapes* Group);
	__fastcall virtual ~TECLineGeofence();
	virtual void __fastcall AddPoint(const double Lat, const double Lng);
	virtual void __fastcall Clear();
	virtual bool __fastcall isHit(const double Lat, const double Lng);
	virtual void __fastcall Bounds();
	__property int MargingMeter = {read=FMargingMeter, write=FMargingMeter, nodefault};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECGeofences : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECBaseGeofence* operator[](int index) { return this->Geofence[index]; }
	
private:
	TECShapes* FShapes;
	bool FVisible;
	bool FActive;
	System::Generics::Collections::TList__1<TECBaseGeofence*>* FGeofences;
	TECCirclegeoFence* FCircleFence;
	TECPolygonGeofence* FPolygonFence;
	TECLineGeofence* FLineFence;
	TECBaseGeofence* __fastcall getGeofence(int index);
	void __fastcall setActive(const bool value);
	bool __fastcall getVisible();
	void __fastcall setVisible(const bool value);
	System::UnicodeString __fastcall getToTxt();
	void __fastcall setTotxt(const System::UnicodeString value);
	int __fastcall getZindex();
	void __fastcall setZIndex(const int value);
	
public:
	__fastcall TECGeofences(TECShapesGroup* Parent);
	__fastcall virtual ~TECGeofences();
	int __fastcall Add(const double Lat, const double Lng, const int RadiusMeter, const System::UnicodeString Name = System::UnicodeString())/* overload */;
	int __fastcall Add(const double *dLatLngs, const System::NativeInt dLatLngs_High, const System::UnicodeString Name = System::UnicodeString())/* overload */;
	int __fastcall Add(TECShapePolygone* const Polygone, const System::UnicodeString Name = System::UnicodeString())/* overload */;
	int __fastcall Add(TECShapeLine* const Line, const System::UnicodeString Name = System::UnicodeString())/* overload */;
	void __fastcall Delete(int index);
	int __fastcall Count();
	void __fastcall Clear();
	int __fastcall IndexOf(TECBaseGeofence* value);
	__property bool Active = {read=FActive, write=setActive, nodefault};
	__property bool Visible = {read=getVisible, write=setVisible, nodefault};
	__property System::UnicodeString toTxt = {read=getToTxt, write=setTotxt};
	__property TECBaseGeofence* Geofence[int index] = {read=getGeofence/*, default*/};
	__property int ZIndex = {read=getZindex, write=setZIndex, nodefault};
};

#pragma pack(pop)

enum DECLSPEC_DENUM TECCartoCSSPropertie : unsigned char { cpZindex, cpBorderSize, cpFillColor, cpColor, cpBorderColor, cpHoverColor, cpHoverBorderColor, cpGraphic, cpPenStyle, cpLineType, cpPolygonStyle, cpLevel, cpWeight, cpOpacity, cpFillOpacity, cpVisible, cpWidth, cpHeight, cpUnit, cpFontFamily, cpFontSize, cpFontBold, cpFontItalic, cpRotate, cpXAnchor, cpYAnchor, cpStyleIcon, cpScale, cpAngle, cpDark, cpLight, cpMeterWeight, cpCustomDash, cpFov, cpFontColor, cpPoishape };

typedef System::Set<TECCartoCSSPropertie, TECCartoCSSPropertie::cpZindex, TECCartoCSSPropertie::cpPoishape> TECartoCSSproperties;

enum DECLSPEC_DENUM TECCartoCSSCondition : unsigned char { ccNo, ccEgal, ccSup, ccInf, ccSupEgal, ccMod, ccInfEgal, ccDifferent, ccStartPos, ccPos };

enum DECLSPEC_DENUM TECStyleIcon : unsigned char { si3D, siFlat, siFlatNoBorder, siSVG, siOwnerDraw, siDirection, siText, siSVGPinGHole, siRoundSVGPinGHole };

struct DECLSPEC_DRECORD TValueIntegerRangeZoom
{
public:
	System::Byte min_zoom;
	System::Byte max_zoom;
	int value;
};


typedef System::DynamicArray<TValueIntegerRangeZoom> TArrayValueIntegerRangeZoom;

struct DECLSPEC_DRECORD TValueDoubleRangeZoom
{
public:
	System::Byte min_zoom;
	System::Byte max_zoom;
	double value;
};


typedef System::DynamicArray<TValueDoubleRangeZoom> TArrayValueDoubleRangeZoom;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TIntegerRangeZoom : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	bool FisProperty;
	System::UnicodeString FData;
	TArrayValueIntegerRangeZoom FValues;
	int FValue;
	void __fastcall setData(const System::UnicodeString datas);
	
public:
	int __fastcall getValueForZoom(const System::Byte Zoom, const int defvalue, TECShape* Shape = (TECShape*)(0x0));
	__property System::UnicodeString Data = {read=FData, write=setData};
public:
	/* TObject.Create */ inline __fastcall TIntegerRangeZoom() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TIntegerRangeZoom() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TPoiShapeRangeZoom : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FData;
	TArrayValueIntegerRangeZoom FValues;
	int FValue;
	void __fastcall setData(const System::UnicodeString datas);
	
public:
	Uecmaputil::TPOIShape __fastcall getValueForZoom(const System::Byte Zoom, const Uecmaputil::TPOIShape defvalue, TECShape* Shape = (TECShape*)(0x0));
	__property System::UnicodeString Data = {read=FData, write=setData};
public:
	/* TObject.Create */ inline __fastcall TPoiShapeRangeZoom() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TPoiShapeRangeZoom() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TStyleIconRangeZoom : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FData;
	TArrayValueIntegerRangeZoom FValues;
	int FValue;
	void __fastcall setData(const System::UnicodeString datas);
	
public:
	TECStyleIcon __fastcall getValueForZoom(const System::Byte Zoom, const TECStyleIcon defvalue, TECShape* Shape = (TECShape*)(0x0));
	__property System::UnicodeString Data = {read=FData, write=setData};
public:
	/* TObject.Create */ inline __fastcall TStyleIconRangeZoom() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TStyleIconRangeZoom() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TLineTypeRangeZoom : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FData;
	TArrayValueIntegerRangeZoom FValues;
	int FValue;
	void __fastcall setData(const System::UnicodeString datas);
	
public:
	TECLineType __fastcall getValueForZoom(const System::Byte Zoom, const TECLineType defvalue, TECShape* Shape = (TECShape*)(0x0));
	__property System::UnicodeString Data = {read=FData, write=setData};
public:
	/* TObject.Create */ inline __fastcall TLineTypeRangeZoom() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TLineTypeRangeZoom() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TDoubleRangeZoom : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	bool FisProperty;
	System::UnicodeString FData;
	TArrayValueDoubleRangeZoom FValues;
	double FValue;
	void __fastcall setData(const System::UnicodeString datas);
	
public:
	double __fastcall getValueForZoom(const System::Byte Zoom, const double defvalue, TECShape* Shape = (TECShape*)(0x0));
	__property System::UnicodeString Data = {read=FData, write=setData};
public:
	/* TObject.Create */ inline __fastcall TDoubleRangeZoom() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TDoubleRangeZoom() { }
	
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECCartoCSSValues : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TECCartoCSSValues* FNext;
	TECCartoCSSCondition FCondition;
	System::UnicodeString FConditionProperty;
	System::UnicodeString FConditionValue;
	TECartoCSSproperties FProperties;
	System::LongInt FZindex;
	TIntegerRangeZoom* FBorderSize;
	bool FMeterWeight;
	bool FisPointRule;
	bool FisDoublePointRule;
	bool FisHoverRule;
	bool FisSelectedRule;
	bool FisPressedRule;
	bool FisFocusedRule;
	System::UnicodeString FVisible;
	System::Uitypes::TColor FFontColor;
	System::Uitypes::TColor FFillColor;
	System::Uitypes::TColor FHoverColor;
	System::Uitypes::TColor FCOlor;
	System::Uitypes::TColor FBorderColor;
	System::Uitypes::TColor FHoverBorderColor;
	System::UnicodeString FGraphic;
	Uecmaputil::TPenStyle FPenStyle;
	Uecmaputil::TDashStyle FDashStyle;
	TLineTypeRangeZoom* FLineType;
	Vcl::Graphics::TBrushStyle FPolygoneStyle;
	TIntegerRangeZoom* FWidth;
	TIntegerRangeZoom* FHeight;
	System::UnicodeString FLevel;
	Uecmaputil::TPOIUnit FUnit;
	int FAngle;
	int FXAnchor;
	int FYAnchor;
	TIntegerRangeZoom* FFov;
	System::UnicodeString FFontFamily;
	TIntegerRangeZoom* FFontSize;
	bool FFontBold;
	bool FFontItalic;
	bool FRotate;
	TIntegerRangeZoom* FWeight;
	System::Byte FOpacity;
	System::Byte FFillOpacity;
	int FDarkLight;
	TPoiShapeRangeZoom* FPoiShape;
	TStyleIconRangeZoom* FStyleIcon;
	TDoubleRangeZoom* FScale;
	
public:
	__fastcall TECCartoCSSValues();
	__fastcall virtual ~TECCartoCSSValues();
	__property bool isHoverRule = {read=FisHoverRule, write=FisHoverRule, nodefault};
	__property bool isSelectedRule = {read=FisSelectedRule, write=FisSelectedRule, nodefault};
	__property bool isPressedRule = {read=FisPressedRule, write=FisPressedRule, nodefault};
	__property bool isFocusedRule = {read=FisFocusedRule, write=FisFocusedRule, nodefault};
	__property bool isPointRule = {read=FisPointRule, write=FisPointRule, nodefault};
	__property bool isDoublePointRule = {read=FisDoublePointRule, write=FisDoublePointRule, nodefault};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECCartoStyles : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	int L_S_SELEC;
	int L_S_HOVER;
	int L_S_PRESSED;
	int L_S_FOCUSED;
	System::UnicodeString S_SELEC;
	System::UnicodeString S_HOVER;
	System::UnicodeString S_PRESSED;
	System::UnicodeString S_FOCUSED;
	System::UnicodeString FActualZoom;
	Winapi::Windows::TRTLCriticalSection FCritSect;
	__int64 FTimeInStyle;
	__int64 FTimeChanged;
	bool FChanged;
	TECShapesGroup* FParent;
	System::Classes::TStringList* FParams;
	System::Classes::TStringList* FProperties;
	System::Classes::TStringList* FListRules;
	System::Classes::TStringList* FZoomRules;
	System::Classes::TStringList* FRules;
	TECShape* FSelectedItem;
	TECCartoCSSValues* FCssValues;
	System::UnicodeString FGraphicNameFormat;
	System::UnicodeString FGraphicDirectory;
	System::UnicodeString FTextRules;
	void __fastcall setGraphicDirectory(const System::UnicodeString directory);
	void __fastcall Lock();
	void __fastcall UnLock();
	void __fastcall setRule(const bool ruleForGroup = false);
	void __fastcall setTextRules(const System::UnicodeString value);
	void __fastcall _SetStyle(TECShape* const item, System::Classes::TStringList* const ListRules = (System::Classes::TStringList*)(0x0));
	
public:
	__fastcall TECCartoStyles(TECShapesGroup* const value);
	__fastcall virtual ~TECCartoStyles();
	void __fastcall LoadFromFile(const System::UnicodeString filename);
	void __fastcall SaveToFile(const System::UnicodeString filename);
	void __fastcall UpdateStyles(const bool ForceUpdate = false);
	void __fastcall UpdateStylesZoom();
	void __fastcall SetStyle(TECShape* const item);
	void __fastcall ClearAddRule(const System::UnicodeString value, const bool saveValue = true);
	void __fastcall addRule(const System::UnicodeString value, const bool saveValue = true);
	void __fastcall addRules(const System::UnicodeString value);
	void __fastcall Clear();
	void __fastcall ClearSelector(const System::UnicodeString Name, const bool Partial = false);
	__property bool Changed = {read=FChanged, nodefault};
	__property System::UnicodeString Rules = {read=FTextRules, write=setTextRules};
	__property __int64 TimeChanged = {read=FTimeChanged};
	__property __int64 TimeInStyle = {read=FTimeInStyle};
	__property System::UnicodeString GraphicDirectory = {read=FGraphicDirectory, write=setGraphicDirectory};
	__property System::UnicodeString GraphicNameFormat = {read=FGraphicNameFormat, write=FGraphicNameFormat};
};


typedef void __fastcall (__closure *TOnCreateJSONPoint)(System::TObject* sender, TECShapes* const Group, TECShape* &JSONPoint, const double Lat, const double Lng, const System::UnicodeString properties);

#pragma pack(push,4)
class PASCALIMPLEMENTATION TGeoJSONGeometryParser : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString geoType;
	System::UnicodeString geocoord;
	System::UnicodeString FJSON;
	Uecmaputil::TThreadStringList* FStrings;
	System::Classes::TStringList* FAddresses;
	System::Classes::TStringList* FProperties;
	int LengthJSON;
	int Index;
	bool FChunckBlock;
	TECShapes* FGroup;
	int FESPG;
	void __fastcall setJSON(const System::UnicodeString value);
	int __fastcall ExtractGeometry();
	void __fastcall Run();
	__property TECShapes* Group = {read=FGroup, write=FGroup};
	
public:
	__fastcall TGeoJSONGeometryParser();
	__fastcall virtual ~TGeoJSONGeometryParser();
	void __fastcall LoadFromStream(System::Classes::TStream* const value);
	void __fastcall LoadFromFile(const System::UnicodeString value);
	__property System::UnicodeString JSON = {read=FJSON, write=setJSON};
	__property bool ChunckBlock = {read=FChunckBlock, write=FChunckBlock, nodefault};
};

#pragma pack(pop)

typedef Vcl::Graphics::TBitmap TBitmapCache;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TPropertyValue : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FProperties;
	int FCountProperties;
	int FIndexFindNextProperties;
	int FLenProperties;
	int __fastcall getCountProperties();
	void __fastcall setProperties(const System::UnicodeString value);
	
public:
	__fastcall TPropertyValue();
	System::UnicodeString __fastcall Format(const System::UnicodeString MaskFormat);
	bool __fastcall setProperty(const System::UnicodeString index, const System::UnicodeString value);
	System::UnicodeString __fastcall getProperty(const System::UnicodeString index);
	bool __fastcall PropertiesFindFirst(System::UnicodeString &key, System::UnicodeString &value);
	bool __fastcall PropertiesFindNext(System::UnicodeString &key, System::UnicodeString &value);
	__property int Count = {read=getCountProperties, nodefault};
	__property System::UnicodeString properties = {read=FProperties, write=setProperties};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TPropertyValue() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECShape : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::UnicodeString operator[](const System::UnicodeString index) { return this->value[index]; }
	
private:
	TPropertyValue* FPropertyValue;
	TECCartoCSSValues* FDefCSS;
	bool FNoOnChangeEdit;
	bool FIsInView;
	bool FIsCreateBitmapCache;
	bool FEditable;
	bool FIsEditable;
	bool FEnabledHover;
	bool FClusterable;
	bool FEnabledHint;
	bool FDragStart;
	bool FHit;
	bool FRotation;
	bool FMinimalSize;
	bool FIsDrawTo;
	bool FChangeDescription;
	bool FOwnItem;
	bool FisLocationPending;
	bool FSerialize;
	bool FVisible;
	bool FSelected;
	bool FPressed;
	bool FHover;
	bool FReady;
	bool FClickable;
	bool FDraggable;
	bool FFocusable;
	System::Byte FPZoom;
	System::Byte FZindexOrderClass;
	System::Byte FOpacity;
	short FAngle;
	short FPTileSize;
	int RLeft;
	int RTop;
	int RWidth;
	int RHeight;
	int FWX;
	int FWY;
	int FXHover;
	int FYHover;
	int FXAnchor;
	int FYAnchor;
	int FTop;
	int FLeft;
	int FX;
	int FY;
	int FW;
	int FH;
	Uecmaputil::TDPoint FW01Pt;
	int FMaxShowHint;
	unsigned FDelayHint;
	unsigned FShowHintAfter;
	unsigned FTimeStyleChanged;
	double FZindexOrder;
	double CAngle;
	double SAngle;
	double FScale;
	double FPrevLat;
	double FPrevLng;
	double FLat;
	double FLng;
	double FAlt;
	double FMoveDistance;
	int FMoveDirection;
	System::TDateTime FPrevTime;
	System::TDateTime FTime;
	double FNorthEastLatitude;
	double FNorthEastLongitude;
	double FSouthWestLatitude;
	double FSouthWestLongitude;
	System::TObject* FTagObject;
	PtrInt FTag;
	__int64 _id;
	System::LongInt FZindex;
	Uecgraphics::TECCanvas* FECCanvas;
	Uecmaputil::TECWorldInfo* FWorldInfo;
	TECShapeList* FParentList;
	System::UnicodeString FHint;
	System::UnicodeString FDescription;
	System::UnicodeString FName;
	System::UnicodeString FAddress;
	System::Classes::TStringList* FReverseResult;
	TECAnimationShape* FECAnimationShape;
	TOnShapeMousePoint FOnShapeMouseOverPoint;
	TOnShapeLocation FOnShapeLocation;
	System::Classes::TNotifyEvent FOnShapeOverIntent;
	System::Classes::TNotifyEvent FOnDestroy;
	System::Classes::TNotifyEvent FOnShapeDragEnd;
	System::Classes::TNotifyEvent FOnUpdate;
	System::Classes::TNotifyEvent FOnChangeEditable;
	TOnDrawShape FOnOwnerDraw;
	TOnDrawShape FOnAfterDraw;
	TOnDrawShape FOnBeforeDraw;
	TOnShapeMove FOnShapeDrag;
	TOnShapeMove FOnShapeMove;
	TOnShapeMouseEvent FOnShapeMouseDown;
	TOnShapeMouseEvent FOnShapeMouseUp;
	TOnShapeMouseEvent FOnShapeClick;
	TOnShapeMouseEvent FOnShapeLongClick;
	TOnShapeMouseEvent FOnShapeLongPress;
	TOnShapeMouseEvent FOnShapeRightClick;
	TOnShapeMouseEvent FOnShapeDblClick;
	TOnShapeMouseEvent FOnshapeMouseOut;
	TOnShapeMouseEvent FOnShapeMouseOver;
	System::Classes::TNotifyEvent FOnShapeResize;
	System::TObject* _FItem;
	System::TObject* FItem;
	virtual void __fastcall CheckStyleUpdate();
	bool __fastcall getStyleUpdated();
	TECShapesGroup* __fastcall getOwnerShapes();
	Vcl::Controls::TControl* __fastcall getOwnerMap();
	System::UnicodeString __fastcall getOwnerName();
	void __fastcall doLocation(System::TObject* sender);
	virtual void __fastcall setEditable(const bool value);
	void __fastcall setItem(System::TObject* const value);
	System::TObject* __fastcall getItem();
	void __fastcall setName(const System::UnicodeString value);
	void __fastcall setProperties(const System::UnicodeString value);
	System::UnicodeString __fastcall getProperties();
	int __fastcall getCountProperties();
	System::UnicodeString __fastcall getValue(const System::UnicodeString index)/* overload */;
	System::UnicodeString __fastcall getProperty(const System::UnicodeString index);
	void __fastcall setProperty(const System::UnicodeString index, const System::UnicodeString value);
	virtual void __fastcall setDescription(const System::UnicodeString value);
	void __fastcall setHint(const System::UnicodeString value);
	System::UnicodeString __fastcall getHint();
	void __fastcall setDraggable(const bool value);
	virtual void __fastcall setAngle(const short value);
	virtual void __fastcall setScale(const double value);
	virtual void __fastcall setColor(const System::Uitypes::TColor value);
	virtual void __fastcall setHoverColor(const System::Uitypes::TColor value);
	TECShapes* __fastcall getGroup();
	System::UnicodeString __fastcall getAddress();
	void __fastcall setAddress(const System::UnicodeString value);
	double __fastcall getAltitude();
	virtual void __fastcall setVisible(const bool value);
	bool __fastcall getVisible();
	virtual void __fastcall setZIndex(const System::LongInt value);
	virtual bool __fastcall getClickable();
	void __fastcall setOpacity(const System::Byte value);
	virtual System::UnicodeString __fastcall getToTxt();
	virtual void __fastcall setTotxt(const System::UnicodeString value);
	virtual System::UnicodeString __fastcall getToGpx();
	virtual System::UnicodeString __fastcall getToKml();
	System::UnicodeString __fastcall getPropertiesJSON();
	virtual System::UnicodeString __fastcall getToGeoJSON();
	virtual System::UnicodeString __fastcall getToWkt();
	virtual void __fastcall setWidth(const int value);
	virtual int __fastcall getWidth();
	virtual void __fastcall setHeight(const int value);
	virtual int __fastcall getHeight();
	
protected:
	__fastcall virtual TECShape(TECShapeList* const owner);
	
private:
	bool __fastcall getSerialize();
	virtual void __fastcall Draw();
	virtual TBitmapCache* __fastcall CreateBitmap();
	virtual void __fastcall DrawTo(const int X, const int Y, Vcl::Graphics::TCanvas* canvas);
	void __fastcall DrawIcon();
	virtual bool __fastcall HandledCLick(const int _x, const int _y);
	void __fastcall setAnimationShape(TECAnimationShape* const value);
	void __fastcall setRotation(const bool value);
	void __fastcall removeAnimation();
	virtual void __fastcall setSelected(const bool value);
	virtual bool __fastcall getClusterable();
	void __fastcall setMaxShowHint(const int value);
	void __fastcall setShowHintAfter(const unsigned value);
	void __fastcall setXAnchor(const int value);
	int __fastcall getXAnchor();
	void __fastcall setYAnchor(const int value);
	int __fastcall getYAnchor();
	bool __fastcall getIsEditable();
	void __fastcall setFocusable(const bool value);
	bool __fastcall getFocusable();
	__property Uecgraphics::TECCanvas* canvas = {read=FECCanvas};
	
protected:
	int FBorderSize;
	System::Uitypes::TColor FHoverColor;
	System::Uitypes::TColor FCOlor;
	System::Uitypes::TColor FBorderColor;
	System::Uitypes::TColor FHoverBorder;
	TOnGetScale FOnGetScale;
	TECStyleIcon FStyleIcon;
	virtual void __fastcall setPressed(const bool value);
	virtual double __fastcall getScale();
	__property System::TObject* _Item = {read=_FItem, write=_FItem};
	
public:
	__fastcall virtual ~TECShape();
	virtual void __fastcall Update();
	System::UnicodeString __fastcall PropertyFormat(const System::UnicodeString mask);
	virtual TECShape* __fastcall CopyToGroup(TECShapes* Group);
	virtual TECShape* __fastcall CopyToGroupAndRemove(TECShapes* Group);
	virtual void __fastcall SaveState();
	virtual void __fastcall RestoreState();
	void __fastcall ZoomTo();
	void __fastcall infoWindow(const System::UnicodeString content)/* overload */;
	void __fastcall infoWindow(TECShapeInfoWindow* win)/* overload */;
	Vcl::Graphics::TBitmap* __fastcall ToBitmap();
	void __fastcall AlignToRoute();
	void __fastcall Remove();
	void __fastcall BringToFront();
	void __fastcall SendToBack();
	void __fastcall setFocus();
	void __fastcall unFocus();
	bool __fastcall Focused();
	virtual void __fastcall SetPosition(const double dLat, const double dLng);
	virtual void __fastcall SetDirection(const double dLat, const double dLng);
	void __fastcall SetDistanceBearing(const double Kilometers, const double Bearing, const bool vincenty = false);
	int __fastcall SpeedKmH();
	virtual bool __fastcall IsHover(const int iX, const int iY);
	virtual bool __fastcall isHit(const int _x, const int _y);
	virtual bool __fastcall isRepaintHover();
	int __fastcall IndexOf();
	virtual bool __fastcall ShowOnMap(const bool isMoving = false);
	virtual bool __fastcall isInArea(const double SWALat, const double SWALng, const double NEALat, const double NEALng);
	virtual bool __fastcall isMinimalSize();
	void __fastcall ShowHint();
	void __fastcall HideHint();
	virtual void __fastcall UpdateStyle();
	void __fastcall InvalidStyle();
	void __fastcall CenterOnMap();
	virtual void __fastcall ShowAll();
	void __fastcall PanTo();
	bool __fastcall Contains(const double dLat, const double dLng);
	virtual void __fastcall getBounds();
	Uecmaputil::TLocationDirection __fastcall LocationDirectionTo(TECShape* value);
	double __fastcall DistanceTo(TECShape* value);
	int __fastcall PixelDistanceTo(TECShape* value);
	void __fastcall Location();
	bool __fastcall PropertiesFindFirst(System::UnicodeString &key, System::UnicodeString &value);
	bool __fastcall PropertiesFindNext(System::UnicodeString &key, System::UnicodeString &value);
	__property bool isEditable = {read=getIsEditable, write=FIsEditable, nodefault};
	__property bool NoOnChangeEdit = {read=FNoOnChangeEdit, write=FNoOnChangeEdit, nodefault};
	__property short Angle = {read=FAngle, write=setAngle, nodefault};
	__property TECShapeList* Parent = {read=FParentList};
	__property TECShapesGroup* OwnerShapes = {read=getOwnerShapes};
	__property System::UnicodeString OwnerName = {read=getOwnerName};
	__property Vcl::Controls::TControl* OwnerMap = {read=getOwnerMap};
	__property System::UnicodeString Address = {read=getAddress, write=setAddress};
	__property TECAnimationShape* Animation = {read=FECAnimationShape, write=setAnimationShape};
	__property double Latitude = {read=FLat};
	__property double Longitude = {read=FLng};
	__property double Altitude = {read=getAltitude, write=FAlt};
	__property System::TDateTime Time = {read=FTime, write=FTime};
	__property double PrevLatitude = {read=FPrevLat};
	__property double PrevLongitude = {read=FPrevLng};
	__property System::TDateTime PrevTime = {read=FPrevTime};
	__property bool MinimalSize = {read=FMinimalSize, nodefault};
	__property int MoveDirection = {read=FMoveDirection, nodefault};
	__property double MoveDistance = {read=FMoveDistance};
	__property double NorthEastLat = {read=FNorthEastLatitude};
	__property double NorthEastLng = {read=FNorthEastLongitude};
	__property double SouthWestLat = {read=FSouthWestLatitude};
	__property double SouthWestLng = {read=FSouthWestLongitude};
	__property bool Editable = {read=FEditable, write=setEditable, nodefault};
	__property bool Selected = {read=FSelected, write=setSelected, nodefault};
	__property double Scale = {read=FScale, write=setScale};
	__property bool EnabledHint = {read=FEnabledHint, write=FEnabledHint, nodefault};
	__property bool StyleUpdated = {read=getStyleUpdated, nodefault};
	__property bool EnabledHover = {read=FEnabledHover, write=FEnabledHover, nodefault};
	__property int X = {read=FX, write=FX, nodefault};
	__property int Y = {read=FY, write=FY, nodefault};
	__property int Top = {read=FTop, write=FTop, nodefault};
	__property int Left = {read=FLeft, write=FLeft, nodefault};
	__property int Width = {read=getWidth, write=setWidth, nodefault};
	__property int Height = {read=getHeight, write=setHeight, nodefault};
	__property int OriginalWidth = {read=FW, nodefault};
	__property int OriginalHeight = {read=FH, nodefault};
	__property int XAnchor = {read=getXAnchor, write=setXAnchor, nodefault};
	__property int YAnchor = {read=getYAnchor, write=setYAnchor, nodefault};
	__property int XHover = {read=FXHover, nodefault};
	__property int YHover = {read=FYHover, nodefault};
	__property System::Uitypes::TColor Color = {read=FCOlor, write=setColor, nodefault};
	__property System::Uitypes::TColor HoverColor = {read=FHoverColor, write=setHoverColor, nodefault};
	__property PtrInt Tag = {read=FTag, write=FTag, nodefault};
	__property System::UnicodeString Name = {read=FName, write=setName};
	__property System::UnicodeString Description = {read=FDescription, write=setDescription};
	__property System::UnicodeString properties = {read=getProperties, write=setProperties};
	__property System::UnicodeString PropertyValue[const System::UnicodeString index] = {read=getProperty, write=setProperty};
	__property System::UnicodeString value[const System::UnicodeString index] = {read=getValue, write=setProperty/*, default*/};
	__property int CountProperties = {read=getCountProperties, nodefault};
	__property System::TObject* item = {read=getItem, write=setItem};
	__property System::TObject* TagObject = {read=FTagObject, write=FTagObject};
	__property bool OwnItem = {read=FOwnItem, write=FOwnItem, nodefault};
	__property __int64 Id = {read=_id};
	__property bool Visible = {read=getVisible, write=setVisible, nodefault};
	__property bool Serialize = {read=getSerialize, write=FSerialize, nodefault};
	__property bool isInView = {read=FIsInView, nodefault};
	__property bool Clickable = {read=getClickable, write=FClickable, nodefault};
	__property bool Clusterable = {read=getClusterable, nodefault};
	__property bool Focusable = {read=getFocusable, write=setFocusable, nodefault};
	__property System::Byte Opacity = {read=FOpacity, write=setOpacity, nodefault};
	__property bool Rotation = {read=FRotation, write=setRotation, nodefault};
	__property System::LongInt ZIndex = {read=FZindex, write=setZIndex, nodefault};
	__property System::Byte ZindexOrderClass = {read=FZindexOrderClass, nodefault};
	__property bool Draggable = {read=FDraggable, write=setDraggable, nodefault};
	__property bool DragStart = {read=FDragStart, write=FDragStart, nodefault};
	__property bool Hover = {read=FHover, nodefault};
	__property bool Pressed = {read=FPressed, write=setPressed, nodefault};
	__property bool Ready = {read=FReady, write=FReady, nodefault};
	__property System::UnicodeString Hint = {read=getHint, write=setHint};
	__property int MaxShowHint = {read=FMaxShowHint, write=setMaxShowHint, nodefault};
	__property unsigned ShowHintAfter = {read=FShowHintAfter, write=setShowHintAfter, nodefault};
	__property unsigned DelayHint = {read=FDelayHint, write=FDelayHint, nodefault};
	__property TECShapes* Group = {read=getGroup};
	__property System::UnicodeString toTxt = {read=getToTxt, write=setTotxt};
	__property System::UnicodeString ToGpx = {read=getToGpx};
	__property System::UnicodeString ToKml = {read=getToKml};
	__property System::UnicodeString ToGeoJSon = {read=getToGeoJSON};
	__property System::UnicodeString ToWKT = {read=getToWkt};
	__property Uecmaputil::TECWorldInfo* World = {read=FWorldInfo};
	__property TOnDrawShape OnOwnerDraw = {read=FOnOwnerDraw, write=FOnOwnerDraw};
	__property TOnDrawShape OnAfterDraw = {read=FOnAfterDraw, write=FOnAfterDraw};
	__property TOnDrawShape OnBeforeDraw = {read=FOnBeforeDraw, write=FOnBeforeDraw};
	__property TOnShapeMove OnShapeMove = {read=FOnShapeMove, write=FOnShapeMove};
	__property TOnShapeMove OnShapeDrag = {read=FOnShapeDrag, write=FOnShapeDrag};
	__property System::Classes::TNotifyEvent OnShapeDragEnd = {read=FOnShapeDragEnd, write=FOnShapeDragEnd};
	__property TOnShapeMouseEvent OnShapeMouseOver = {read=FOnShapeMouseOver, write=FOnShapeMouseOver};
	__property TOnShapeMouseEvent OnShapeMouseOut = {read=FOnshapeMouseOut, write=FOnshapeMouseOut};
	__property System::Classes::TNotifyEvent OnShapeOverIntent = {read=FOnShapeOverIntent, write=FOnShapeOverIntent};
	__property TOnShapeMouseEvent OnShapeMouseDown = {read=FOnShapeMouseDown, write=FOnShapeMouseDown};
	__property TOnShapeMouseEvent OnShapeMouseup = {read=FOnShapeMouseUp, write=FOnShapeMouseUp};
	__property TOnShapeMouseEvent OnShapeClick = {read=FOnShapeClick, write=FOnShapeClick};
	__property TOnShapeMouseEvent OnShapeLongClick = {read=FOnShapeLongClick, write=FOnShapeLongClick};
	__property TOnShapeMouseEvent OnShapeLongPress = {read=FOnShapeLongPress, write=FOnShapeLongPress};
	__property TOnShapeMouseEvent OnShapeRightClick = {read=FOnShapeRightClick, write=FOnShapeRightClick};
	__property TOnShapeMouseEvent OnShapeDblClick = {read=FOnShapeDblClick, write=FOnShapeDblClick};
	__property TOnShapeLocation OnShapeLocation = {read=FOnShapeLocation, write=FOnShapeLocation};
	__property TOnShapeMousePoint OnShapeMouseOverPoint = {read=FOnShapeMouseOverPoint, write=FOnShapeMouseOverPoint};
	__property System::Classes::TNotifyEvent OnShapeResize = {read=FOnShapeResize, write=FOnShapeResize};
	__property System::Classes::TNotifyEvent OnChangeEditable = {read=FOnChangeEditable, write=FOnChangeEditable};
	__property System::Classes::TNotifyEvent OnDestroy = {read=FOnDestroy, write=FOnDestroy};
};


class PASCALIMPLEMENTATION TECAnimationShape : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TECAnimationShape* FAnimations;
	bool FKillAnimationIfNotVisible;
	__int64 FMaxAnimation;
	__int64 FStartTick;
	__int64 FLastTick;
	__int64 FTiming;
	TECShape* FShape;
	bool FStop;
	System::Classes::TNotifyEvent FOnAnimation;
	System::Classes::TNotifyEvent FOnEndAnimation;
	virtual void __fastcall Draw(Uecgraphics::TECCanvas* const canvas, System::Types::TRect &rect, TECShape* item);
	virtual void __fastcall setShape(TECShape* value);
	void __fastcall doFreeAnimations(TECAnimationShape* value);
	virtual void __fastcall setAnimations(TECAnimationShape* value);
	
protected:
	virtual void __fastcall Animation();
	virtual void __fastcall InitAnimation();
	virtual void __fastcall FreeAnimation();
	
public:
	__fastcall virtual TECAnimationShape(unsigned value);
	__fastcall virtual ~TECAnimationShape();
	__property bool Stop = {read=FStop, write=FStop, nodefault};
	__property TECShape* Shape = {read=FShape, write=setShape};
	__property __int64 Timing = {read=FTiming, write=FTiming};
	__property TECAnimationShape* Animations = {read=FAnimations, write=setAnimations};
	__property __int64 MaxAnimation = {read=FMaxAnimation, write=FMaxAnimation};
	__property bool KillAnimationIfNotVisible = {read=FKillAnimationIfNotVisible, write=FKillAnimationIfNotVisible, nodefault};
	__property System::Classes::TNotifyEvent OnAnimation = {read=FOnAnimation, write=FOnAnimation};
	__property System::Classes::TNotifyEvent OnEndAnimation = {read=FOnEndAnimation, write=FOnEndAnimation};
};


class PASCALIMPLEMENTATION TecAnimationDash : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
private:
	bool FMoveForward;
	int FMaxOffset;
	
protected:
	virtual void __fastcall Animation();
	virtual void __fastcall InitAnimation();
	
public:
	__property bool MoveForward = {read=FMoveForward, write=FMoveForward, nodefault};
public:
	/* TECAnimationShape.Create */ inline __fastcall virtual TecAnimationDash(unsigned value) : TECAnimationShape(value) { }
	/* TECAnimationShape.Destroy */ inline __fastcall virtual ~TecAnimationDash() { }
	
};


class PASCALIMPLEMENTATION TecAnimationBlink : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
protected:
	virtual void __fastcall Animation();
	
public:
	__fastcall virtual TecAnimationBlink(unsigned value);
public:
	/* TECAnimationShape.Destroy */ inline __fastcall virtual ~TecAnimationBlink() { }
	
};


class PASCALIMPLEMENTATION TECAnimationFade : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
private:
	int FOpacity;
	int FSens;
	System::Byte FMinOpacity;
	System::Byte FStartOpacity;
	__int64 FTimingDraw;
	__int64 FDuration;
	void __fastcall setStartOpacity(const System::Byte value);
	
protected:
	virtual void __fastcall Animation();
	virtual void __fastcall InitAnimation();
	virtual void __fastcall FreeAnimation();
	
public:
	__fastcall TECAnimationFade(const unsigned ValueDuration);
	__property System::Byte StartOpacity = {read=FStartOpacity, write=setStartOpacity, nodefault};
	__property System::Byte MinOpacity = {read=FMinOpacity, write=FMinOpacity, nodefault};
public:
	/* TECAnimationShape.Destroy */ inline __fastcall virtual ~TECAnimationFade() { }
	
};


class PASCALIMPLEMENTATION TECAnimationScale : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
private:
	int FSens;
	int FStep;
	double FStartScale;
	double FMaxScale;
	
protected:
	virtual void __fastcall Animation();
	virtual void __fastcall FreeAnimation();
	
public:
	__fastcall virtual TECAnimationScale(unsigned value);
	__property double MaxScale = {read=FMaxScale, write=FMaxScale};
	__property double StartScale = {read=FStartScale, write=FStartScale};
	__property int Step = {read=FStep, write=FStep, nodefault};
public:
	/* TECAnimationShape.Destroy */ inline __fastcall virtual ~TECAnimationScale() { }
	
};


class PASCALIMPLEMENTATION TECAnimationFadePOI : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
private:
	int FSens;
	int FStep;
	int FStartSize;
	int FMaxSize;
	System::Byte FStartOpacity;
	System::Byte FSaveOpacity;
	System::Byte FSaveWidth;
	System::Byte FSaveHeight;
	virtual void __fastcall setShape(TECShape* value);
	
protected:
	virtual void __fastcall Animation();
	virtual void __fastcall InitAnimation();
	
public:
	__fastcall virtual TECAnimationFadePOI(unsigned value);
	__fastcall virtual ~TECAnimationFadePOI();
	__property int MaxSize = {read=FMaxSize, write=FMaxSize, nodefault};
	__property int StartSize = {read=FStartSize, write=FStartSize, nodefault};
	__property System::Byte StartOpacity = {read=FStartOpacity, write=FStartOpacity, nodefault};
	__property int Step = {read=FStep, write=FStep, nodefault};
};


class PASCALIMPLEMENTATION TECAnimationRadiusFov : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
private:
	int FStep;
	int FStartSize;
	int FMaxSize;
	int FSens;
	
protected:
	virtual void __fastcall Animation();
	virtual void __fastcall InitAnimation();
	
public:
	__fastcall virtual TECAnimationRadiusFov(unsigned value);
	__property int MaxSize = {read=FMaxSize, write=FMaxSize, nodefault};
	__property int StartSize = {read=FStartSize, write=FStartSize, nodefault};
	__property int Step = {read=FStep, write=FStep, nodefault};
public:
	/* TECAnimationShape.Destroy */ inline __fastcall virtual ~TECAnimationRadiusFov() { }
	
};


class PASCALIMPLEMENTATION TECAnimationAutoHide : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
private:
	__int64 FMaxTiming;
	
protected:
	virtual void __fastcall Animation();
	
public:
	__fastcall virtual TECAnimationAutoHide(unsigned value);
	void __fastcall Reset();
	__property __int64 MaxTiming = {read=FMaxTiming, write=FMaxTiming};
public:
	/* TECAnimationShape.Destroy */ inline __fastcall virtual ~TECAnimationAutoHide() { }
	
};


class PASCALIMPLEMENTATION TECAnimationAutoShow : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
private:
	__int64 FMaxTiming;
	
protected:
	virtual void __fastcall Animation();
	
public:
	__fastcall virtual TECAnimationAutoShow(unsigned value);
	void __fastcall Reset();
	__property __int64 MaxTiming = {read=FMaxTiming, write=FMaxTiming};
public:
	/* TECAnimationShape.Destroy */ inline __fastcall virtual ~TECAnimationAutoShow() { }
	
};


typedef void __fastcall (__closure *TOnExecuteAnimationCustom)(TECShape* sender);

class PASCALIMPLEMENTATION TECAnimationCustom : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
private:
	TOnExecuteAnimationCustom FOnExecute;
	
protected:
	virtual void __fastcall Animation();
	
public:
	__fastcall virtual TECAnimationCustom(unsigned value);
	void __fastcall Reset();
	__property TOnExecuteAnimationCustom OnExecute = {read=FOnExecute, write=FOnExecute};
public:
	/* TECAnimationShape.Destroy */ inline __fastcall virtual ~TECAnimationCustom() { }
	
};


class PASCALIMPLEMENTATION TECAnimationShapeColor : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
private:
	System::Uitypes::TColor FOrigineColor;
	
protected:
	virtual void __fastcall InitAnimation();
	virtual void __fastcall FreeAnimation();
	
public:
	virtual void __fastcall Animation();
public:
	/* TECAnimationShape.Create */ inline __fastcall virtual TECAnimationShapeColor(unsigned value) : TECAnimationShape(value) { }
	/* TECAnimationShape.Destroy */ inline __fastcall virtual ~TECAnimationShapeColor() { }
	
};


class PASCALIMPLEMENTATION TECAnimationSwapColorBorderColor : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
public:
	virtual void __fastcall Animation();
public:
	/* TECAnimationShape.Create */ inline __fastcall virtual TECAnimationSwapColorBorderColor(unsigned value) : TECAnimationShape(value) { }
	/* TECAnimationShape.Destroy */ inline __fastcall virtual ~TECAnimationSwapColorBorderColor() { }
	
};


class PASCALIMPLEMENTATION TECAnimationMarkerFilename : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
private:
	System::Classes::TStringList* FFileNames;
	__int64 FFrameKey;
	
protected:
	virtual void __fastcall Animation();
	
public:
	__fastcall virtual TECAnimationMarkerFilename(unsigned value);
	__fastcall virtual ~TECAnimationMarkerFilename();
	__property System::Classes::TStringList* Filenames = {read=FFileNames};
};


class PASCALIMPLEMENTATION TECAnimationMarkerZoomFilename : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
private:
	System::Classes::TStringList* FFileNames;
	System::UnicodeString FDefaultFilename;
	
protected:
	virtual void __fastcall Animation();
	
public:
	__fastcall TECAnimationMarkerZoomFilename(const System::UnicodeString DefaultFilename);
	__fastcall virtual ~TECAnimationMarkerZoomFilename();
	void __fastcall Add(const System::Byte Zoom, const System::UnicodeString filename);
};


class PASCALIMPLEMENTATION TECAnimationGraphicWait : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
	
private:
	typedef System::DynamicArray<System::Types::TPoint> _TECAnimationGraphicWait__1;
	
	
private:
	int FStep;
	int FDelta;
	_TECAnimationGraphicWait__1 XYPoints;
	System::Uitypes::TColor FCOlor;
	System::Uitypes::TColor FBackgroundColor;
	System::Byte FOpacity;
	virtual void __fastcall Draw(Uecgraphics::TECCanvas* const canvas, System::Types::TRect &rect, TECShape* item);
	
protected:
	virtual void __fastcall Animation();
	
public:
	__fastcall virtual TECAnimationGraphicWait(unsigned value);
	__fastcall virtual ~TECAnimationGraphicWait();
	__property System::Uitypes::TColor Color = {read=FCOlor, write=FCOlor, nodefault};
	__property System::Uitypes::TColor BackgroundColor = {read=FBackgroundColor, write=FBackgroundColor, nodefault};
	__property System::Byte Opacity = {read=FOpacity, write=FOpacity, nodefault};
};


class PASCALIMPLEMENTATION TECAnimationDrawPath : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
private:
	TECShapeLine* FShapeLine;
	__int64 FTimingDraw;
	__int64 FDuration;
	System::Classes::TNotifyEvent FOnDraw;
	double FLatitude;
	double FLongitude;
	
protected:
	virtual void __fastcall Animation();
	virtual void __fastcall InitAnimation();
	
public:
	__fastcall TECAnimationDrawPath(const unsigned ValueDuration);
	__property double Latitude = {read=FLatitude};
	__property double Longitude = {read=FLongitude};
	__property System::Classes::TNotifyEvent OnDraw = {read=FOnDraw, write=FOnDraw};
public:
	/* TECAnimationShape.Destroy */ inline __fastcall virtual ~TECAnimationDrawPath() { }
	
};


class PASCALIMPLEMENTATION TECAnimationMoveOnPath : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
private:
	TECShapeLine* FShapeLine;
	int FSegment;
	int FSpeed;
	bool FHeading;
	bool FComeBack;
	int FDistance;
	bool FStop;
	double FLat;
	double FLng;
	__int64 FTiming;
	System::Classes::TNotifyEvent FOnMove;
	System::Classes::TNotifyEvent FOnDriveUp;
	void __fastcall setStop(const bool value);
	void __fastcall setSpeed(const int Kmh);
	int __fastcall getSpeed();
	void __fastcall setShapeLine(TECShapeLine* value);
	void __fastcall doDestroyLine(System::TObject* sender);
	
protected:
	virtual void __fastcall Animation();
	
public:
	__fastcall TECAnimationMoveOnPath(TECShapeLine* const ShapeLine, const int Position, const int SpeedInKmH);
	__fastcall virtual ~TECAnimationMoveOnPath();
	void __fastcall Start();
	__property TECShapeLine* ShapeLine = {read=FShapeLine, write=setShapeLine};
	__property int Distance = {read=FDistance, write=FDistance, nodefault};
	__property int Speed = {read=getSpeed, write=setSpeed, nodefault};
	__property int Segment = {read=FSegment, nodefault};
	__property bool Stop = {read=FStop, write=setStop, nodefault};
	__property bool ComeBack = {read=FComeBack, write=FComeBack, nodefault};
	__property bool Heading = {read=FHeading, write=FHeading, nodefault};
	__property System::Classes::TNotifyEvent OnDriveUp = {read=FOnDriveUp, write=FOnDriveUp};
	__property System::Classes::TNotifyEvent OnMove = {read=FOnMove, write=FOnMove};
	__property double Lat = {read=FLat};
	__property double Lng = {read=FLng};
};


class PASCALIMPLEMENTATION TECAnimationMoveToDirection : public TECAnimationShape
{
	typedef TECAnimationShape inherited;
	
private:
	int FSpeed;
	double FDirection;
	int FDistance;
	bool FHeading;
	bool FStop;
	__int64 FStartTiming;
	__int64 FTimeOut;
	__int64 FTiming;
	void __fastcall setStop(const bool value);
	void __fastcall setSpeed(const int Kmh);
	int __fastcall getSpeed();
	
protected:
	virtual void __fastcall Animation();
	
public:
	__fastcall TECAnimationMoveToDirection(const int SpeedInKmH, const double DirectionAngle);
	__fastcall virtual ~TECAnimationMoveToDirection();
	void __fastcall Start();
	__property int Speed = {read=getSpeed, write=setSpeed, nodefault};
	__property bool Stop = {read=FStop, write=setStop, nodefault};
	__property double Direction = {read=FDirection, write=FDirection};
	__property bool Heading = {read=FHeading, write=FHeading, nodefault};
	__property __int64 TimeOut = {read=FTimeOut, write=FTimeOut};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TecHotSpot : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	int FLeft;
	int FTop;
	int FWidth;
	int FHeight;
	int Fid;
	System::UnicodeString FUrl;
	
public:
	bool __fastcall isHit(const int X, const int Y);
	__property int Left = {read=FLeft, write=FLeft, nodefault};
	__property int Top = {read=FTop, write=FTop, nodefault};
	__property int Width = {read=FWidth, write=FWidth, nodefault};
	__property int Height = {read=FHeight, write=FHeight, nodefault};
	__property System::UnicodeString Url = {read=FUrl, write=FUrl};
public:
	/* TObject.Create */ inline __fastcall TecHotSpot() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TecHotSpot() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TLabelShowOnly : unsigned char { lsoAll, lsoSelected, lsoPressed, lsoHover, lsoFocused, lsoNotMoving, lsoEdited };

enum DECLSPEC_DENUM TLabelShapeRotation : unsigned char { lsrRotation, lsrNoRotation, lsrHideRotation };

enum DECLSPEC_DENUM TLabelShapeStyle : unsigned char { lsRectangle, lsRoundRect, lsTransparent };

enum DECLSPEC_DENUM TLabelShapeColorType : unsigned char { lcColor, lcShape, lcInvertShape, lcProperty, lcContrasting };

enum DECLSPEC_DENUM TLabelShapeAlign : unsigned char { laTop, laBottom, laLeft, laRight, laCenter };

enum DECLSPEC_DENUM TLabelShapeType : unsigned char { ltHint, ltDescription, ltProperty, ltPosition, ltMask, ltIndexOf };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TLabelShape : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	int FMaxWidth;
	int FCount_Draw;
	int FMaxShow;
	int FMargin;
	TLabelShapeAlign FAlign;
	unsigned FTiming;
	TLabelShapeType FLabelType;
	System::UnicodeString FLabelMask;
	System::UnicodeString FLabelProperty;
	int FBorderSizeDiv2;
	int FBorderSize;
	System::Uitypes::TColor FBorderColor;
	System::Uitypes::TColor FCOlor;
	System::Uitypes::TColor FShadowColor;
	System::Uitypes::TColor FFontColor;
	int FFontSize;
	System::UnicodeString FFontFamily;
	bool FShadowText;
	bool FFontBold;
	bool FFontItalic;
	TLabelShowOnly FShowOnlyIf;
	System::Byte FFillOpacity;
	bool FConnectorLine;
	Uecmaputil::TPenStyle FConnectorLineStyle;
	System::Byte FPositionPrecision;
	TLabelShapeStyle FStyle;
	TLabelShapeColorType FColorType;
	bool FScale;
	bool FUseScaleMarkerToZoom;
	bool FTransparent;
	bool FVisible;
	TLabelShapeRotation FRotation;
	TECShapeList* FParent;
	int STextOff;
	System::Byte FShadowTextOffset;
	System::Byte FMinZoom;
	System::Byte FMaxZoom;
	void __fastcall setShowOnlyIf(const TLabelShowOnly value);
	void __fastcall setVisible(const bool value);
	bool __fastcall getVisible();
	void __fastcall setBorderSize(const int value);
	void __fastcall setRotation(const TLabelShapeRotation value);
	void __fastcall setAlign(const TLabelShapeAlign value);
	void __fastcall setColor(const System::Uitypes::TColor value);
	void __fastcall setBorderColor(const System::Uitypes::TColor value);
	void __fastcall setFontColor(const System::Uitypes::TColor value);
	void __fastcall setFontBold(const bool value);
	void __fastcall setFontItalic(const bool value);
	void __fastcall setFontFamily(const System::UnicodeString value);
	void __fastcall setFontSize(const int value);
	void __fastcall setMinZoom(const System::Byte value);
	void __fastcall setMaxZoom(const System::Byte value);
	void __fastcall setLabelType(const TLabelShapeType value);
	void __fastcall setLabelProperty(const System::UnicodeString value);
	void __fastcall setLabelMask(const System::UnicodeString value);
	void __fastcall setMargin(const int value);
	void __fastcall setMaxWidth(const int value);
	void __fastcall setMaxShow(const int value);
	void __fastcall setColorType(const TLabelShapeColorType value);
	void __fastcall SetStyle(const TLabelShapeStyle value);
	void __fastcall setTransparent(const bool value);
	void __fastcall setScale(const bool value);
	void __fastcall setUseScaleMarkerToZoom(const bool value);
	void __fastcall setFillOpacity(const System::Byte value);
	void __fastcall setShadowText(const bool value);
	void __fastcall setShadowTextOffset(const System::Byte value);
	void __fastcall setShadowColor(const System::Uitypes::TColor value);
	void __fastcall setConnectorLine(const bool value);
	void __fastcall setConnectorLineStyle(const Uecmaputil::TPenStyle value);
	void __fastcall Draw(Uecgraphics::TECCanvas* const canvas, System::Types::TRect &r, TECShape* item);
	void __fastcall Update();
	void __fastcall setPositionPrecision(const System::Byte value);
	
public:
	__fastcall TLabelShape(TECShapeList* const value);
	__property TLabelShapeAlign Align = {read=FAlign, write=setAlign, nodefault};
	__property int BorderSize = {read=FBorderSize, write=setBorderSize, nodefault};
	__property System::Uitypes::TColor BorderColor = {read=FBorderColor, write=setBorderColor, nodefault};
	__property System::Uitypes::TColor Color = {read=FCOlor, write=setColor, nodefault};
	__property bool ConnectorLine = {read=FConnectorLine, write=setConnectorLine, nodefault};
	__property Uecmaputil::TPenStyle ConnectorLineStyle = {read=FConnectorLineStyle, write=setConnectorLineStyle, nodefault};
	__property System::Uitypes::TColor FontColor = {read=FFontColor, write=setFontColor, nodefault};
	__property bool FontBold = {read=FFontBold, write=setFontBold, nodefault};
	__property bool FontItalic = {read=FFontItalic, write=setFontItalic, nodefault};
	__property int FontSize = {read=FFontSize, write=setFontSize, nodefault};
	__property System::UnicodeString FontFamily = {read=FFontFamily, write=setFontFamily};
	__property TLabelShapeType LabelType = {read=FLabelType, write=setLabelType, nodefault};
	__property System::UnicodeString LabelProperty = {read=FLabelProperty, write=setLabelProperty};
	__property System::UnicodeString LabelMask = {read=FLabelMask, write=setLabelMask};
	__property TLabelShowOnly ShowOnlyIf = {read=FShowOnlyIf, write=setShowOnlyIf, nodefault};
	__property int Margin = {read=FMargin, write=setMargin, nodefault};
	__property int MaxWidth = {read=FMaxWidth, write=setMaxWidth, nodefault};
	__property int MaxShow = {read=FMaxShow, write=setMaxShow, nodefault};
	__property TLabelShapeColorType ColorType = {read=FColorType, write=setColorType, nodefault};
	__property TLabelShapeStyle Style = {read=FStyle, write=SetStyle, nodefault};
	__property bool Visible = {read=getVisible, write=setVisible, nodefault};
	__property TLabelShapeRotation Rotation = {read=FRotation, write=setRotation, nodefault};
	__property bool Transparent = {read=FTransparent, write=setTransparent, nodefault};
	__property System::Byte FillOpacity = {read=FFillOpacity, write=setFillOpacity, nodefault};
	__property bool Scale = {read=FScale, write=setScale, nodefault};
	__property bool UseScaleMarkerToZoom = {read=FUseScaleMarkerToZoom, write=setUseScaleMarkerToZoom, nodefault};
	__property bool ShadowText = {read=FShadowText, write=setShadowText, nodefault};
	__property System::Byte ShadowTextOffset = {read=FShadowTextOffset, write=setShadowTextOffset, nodefault};
	__property System::Uitypes::TColor ShadowColor = {read=FShadowColor, write=setShadowColor, nodefault};
	__property System::Byte MaxZoom = {read=FMaxZoom, write=setMaxZoom, nodefault};
	__property System::Byte MinZoom = {read=FMinZoom, write=setMinZoom, nodefault};
	__property System::Byte PositionPrecision = {read=FPositionPrecision, write=setPositionPrecision, nodefault};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TLabelShape() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TInfoWindowStyle : unsigned char { iwsRectangle, iwsRoundRect, iwsTransparent };

enum DECLSPEC_DENUM TInfoWindowPeakLink : unsigned char { iwpNone, iwpArrowHead, iwpFixedHead };

typedef void __fastcall (__closure *TOnInfoWindowLink)(TECShapeInfoWindow* sender, const System::UnicodeString Url);

class PASCALIMPLEMENTATION TECShapeInfoWindow : public TECShape
{
	typedef TECShape inherited;
	
	
private:
	typedef System::DynamicArray<System::Types::TPoint> _TECShapeInfoWindow__1;
	
	
private:
	TOnInfoWindowLink FOnLink;
	TOnOpenInfoWindow FOnOpen;
	bool FShowAll;
	bool FBDRightToLeft;
	int FCalcWidth;
	int FMinHeight;
	int FMinWidth;
	TInfoWindowPeakLink FPeakLink;
	Uecmaputil::TPenStyle FPeakLineStyle;
	System::Generics::Collections::TList__1<TecHotSpot*>* FHotSpots;
	unsigned FcjhFlags;
	int FBorderSizeDiv2;
	int FHitId;
	int FHitHotSPot;
	float OldScale;
	bool FHintCRLF;
	bool FHintNoHTML;
	bool FHitCloseButton;
	bool FCloseButton;
	System::UnicodeString FContent;
	Uecmaputil::TDashStyle FDashStyle;
	_TECShapeInfoWindow__1 XYPeak;
	int FArrowLX;
	int FArrowRX;
	int FXCurve;
	int FYCurve;
	System::Uitypes::TColor FFontColor;
	System::UnicodeString FFontFamily;
	int FFontSize;
	Vcl::Graphics::TGraphic* FGraphic;
	int FYOffsetGraphic;
	int FXOffsetText;
	int FYOffsetText;
	TInfoWindowStyle FInfoWindowStyle;
	TECShapes* FShapes;
	void __fastcall setFontColor(const System::Uitypes::TColor value);
	void __fastcall setBorderSize(const int value);
	void __fastcall setBorderColor(const System::Uitypes::TColor value);
	void __fastcall setHoverBorderColor(const System::Uitypes::TColor value);
	virtual System::UnicodeString __fastcall getToTxt();
	virtual void __fastcall setTotxt(const System::UnicodeString value);
	virtual void __fastcall setWidth(const int value);
	virtual int __fastcall getWidth();
	void __fastcall setContent(const System::UnicodeString value);
	void __fastcall setMinHeight(const int value);
	void __fastcall setMinWidth(const int value);
	void __fastcall setCloseButton(const bool value);
	bool __fastcall getCloseButton();
	void __fastcall ClearHotSpot();
	void __fastcall SetStyle(const TInfoWindowStyle value);
	virtual void __fastcall setVisible(const bool value);
	virtual void __fastcall setZIndex(const System::LongInt value);
	void __fastcall CalcHeight();
	virtual bool __fastcall HandledCLick(const int _x, const int _y);
	void __fastcall getGraphic(const System::UnicodeString filename, Vcl::Graphics::TGraphic* &gfx, const int X, const int Y, int &w, int &h);
	void __fastcall GetAreaAnchor(const int X, const int Y, const int l, const int h, const int Id, const System::UnicodeString anchor);
	void __fastcall setContentCenter(bool value);
	bool __fastcall getContentCenter();
	void __fastcall setBDRightToLeft(bool value);
	void __fastcall setFontSize(const int value);
	void __fastcall setFontFamily(const System::UnicodeString value);
	void __fastcall setPeakLink(const TInfoWindowPeakLink value);
	void __fastcall setArrowLX(const int value);
	void __fastcall setArrowRX(const int value);
	void __fastcall setPeakLineStyle(const Uecmaputil::TPenStyle value);
	
public:
	__fastcall virtual TECShapeInfoWindow(TECShapeList* const owner);
	__fastcall virtual ~TECShapeInfoWindow();
	virtual void __fastcall ShowAll();
	void __fastcall forceWidth(const int value);
	HIDESBASE TECShapeInfoWindow* __fastcall CopyToGroup(TECShapes* Group);
	HIDESBASE TECShapeInfoWindow* __fastcall CopyToGroupAndRemove(TECShapes* Group);
	virtual void __fastcall SaveState();
	virtual void __fastcall RestoreState();
	virtual void __fastcall SetPosition(const double dLat, const double dLng);
	virtual bool __fastcall ShowOnMap(const bool isMoving = false);
	virtual void __fastcall Draw();
	virtual void __fastcall Update();
	virtual void __fastcall getBounds();
	virtual bool __fastcall isHit(const int _x, const int _y);
	virtual bool __fastcall IsHover(const int iX, const int iY);
	__property System::UnicodeString content = {read=FContent, write=setContent};
	__property bool CloseButton = {read=getCloseButton, write=setCloseButton, nodefault};
	__property int MinHeight = {read=FMinHeight, write=setMinHeight, nodefault};
	__property int MinWidth = {read=FMinWidth, write=setMinWidth, nodefault};
	__property TInfoWindowStyle Style = {read=FInfoWindowStyle, write=SetStyle, nodefault};
	__property TInfoWindowPeakLink PeakLink = {read=FPeakLink, write=setPeakLink, nodefault};
	__property Uecmaputil::TPenStyle PeakLineStyle = {read=FPeakLineStyle, write=setPeakLineStyle, nodefault};
	__property bool ContentCenter = {read=getContentCenter, write=setContentCenter, nodefault};
	__property bool BDRightToLeft = {read=FBDRightToLeft, write=setBDRightToLeft, nodefault};
	__property int FontSize = {read=FFontSize, write=setFontSize, nodefault};
	__property System::UnicodeString FontFamily = {read=FFontFamily, write=setFontFamily};
	__property System::Uitypes::TColor FontColor = {read=FFontColor, write=setFontColor, nodefault};
	__property System::Uitypes::TColor BorderColor = {read=FBorderColor, write=setBorderColor, nodefault};
	__property System::Uitypes::TColor HoverBorderColor = {read=FHoverBorder, write=setHoverBorderColor, nodefault};
	__property int BorderSize = {read=FBorderSize, write=setBorderSize, nodefault};
	__property int ArrowLX = {read=FArrowLX, write=setArrowLX, nodefault};
	__property int ArrowRX = {read=FArrowRX, write=setArrowRX, nodefault};
	__property int XCurve = {read=FXCurve, write=FXCurve, nodefault};
	__property int YCurve = {read=FYCurve, write=FYCurve, nodefault};
	__property Vcl::Graphics::TGraphic* Graphic = {read=FGraphic, write=FGraphic};
	__property int YOffsetGraphic = {read=FYOffsetGraphic, write=FYOffsetGraphic, nodefault};
	__property int XOffsetText = {read=FXOffsetText, write=FXOffsetText, nodefault};
	__property int YOffsetText = {read=FYOffsetText, write=FYOffsetText, nodefault};
	__property TOnOpenInfoWindow OnOpen = {read=FOnOpen, write=FOnOpen};
	__property TOnInfoWindowLink OnLink = {read=FOnLink, write=FOnLink};
};


class PASCALIMPLEMENTATION TECShapePOI : public TECShape
{
	typedef TECShape inherited;
	
	
private:
	typedef System::DynamicArray<System::Types::TPoint> _TECShapePOI__1;
	
	
private:
	_TECShapePOI__1 FPoints;
	Uecmaputil::TPOIUnit FUnit;
	bool FInCalculPosition;
	TECShapeLine* FTrackLine;
	int FHitX;
	int FHitY;
	int FHitW;
	int FHitH;
	int _left2;
	int _top2;
	int FPixelWidth;
	int FPixelHeight;
	int _FXAnchor;
	int _FYAnchor;
	int _FPixelWidth;
	int _FPIxelHeight;
	float _scale;
	bool FWithEgalHeight;
	bool FInPressed;
	System::UnicodeString FFontFamily;
	int FFontSize;
	bool FFontItalic;
	bool FFontBold;
	Uecmaputil::TDashStyle FDashStyle;
	Uecmaputil::TPenStyle FPenStyle;
	System::Byte FFillOpacity;
	bool FAutoWidth;
	Uecmaputil::TPOIShape FPoiShape;
	TOnShapeFont FOnShapeFont;
	void __fastcall setWithEgalHeight(const bool value);
	virtual void __fastcall setEditable(const bool value);
	void __fastcall setShape(Uecmaputil::TPOIShape value);
	virtual System::UnicodeString __fastcall getToWkt();
	virtual System::UnicodeString __fastcall getToKml();
	virtual System::UnicodeString __fastcall getToTxt();
	virtual void __fastcall setTotxt(const System::UnicodeString value);
	void __fastcall setBorderColor(const System::Uitypes::TColor value);
	void __fastcall setHoverBorder(const System::Uitypes::TColor value);
	void __fastcall setBorderSize(const int value);
	virtual void __fastcall setWidth(const int value);
	virtual void __fastcall setHeight(const int value);
	void __fastcall setUnit(const Uecmaputil::TPOIUnit value);
	void __fastcall setClusterable(const bool value);
	virtual bool __fastcall getClusterable();
	void __fastcall setFontFamily(const System::UnicodeString value);
	void __fastcall setFontSize(const int value);
	void __fastcall setFontBold(const bool value);
	void __fastcall setFontItalic(const bool value);
	virtual void __fastcall setScale(const double value);
	void __fastcall setFillOpacity(const System::Byte value);
	void __fastcall setPenStyle(const Uecmaputil::TPenStyle value);
	virtual void __fastcall Draw();
	void __fastcall CalculPosition();
	TECShapeLine* __fastcall getTrackLine();
	void __fastcall setTrackLine(TECShapeLine* value);
	
protected:
	virtual void __fastcall setPressed(const bool value);
	
public:
	__fastcall virtual TECShapePOI(TECShapeList* const owner);
	__fastcall virtual ~TECShapePOI();
	void __fastcall setCustomDash(const Uecmaputil::TDashStyle Dash);
	HIDESBASE TECShapePOI* __fastcall CopyToGroup(TECShapes* Group);
	HIDESBASE TECShapePOI* __fastcall CopyToGroupAndRemove(TECShapes* Group);
	virtual void __fastcall RestoreState();
	virtual void __fastcall SaveState();
	double __fastcall MeterWidth();
	double __fastcall MeterHeight();
	virtual TBitmapCache* __fastcall CreateBitmap();
	virtual void __fastcall getBounds();
	virtual bool __fastcall ShowOnMap(const bool isMoving = false);
	virtual bool __fastcall isInArea(const double SWALat, const double SWALng, const double NEALat, const double NEALng);
	bool __fastcall isTrackLineActive();
	virtual void __fastcall SetPosition(const double dLat, const double dLng);
	virtual bool __fastcall IsHover(const int iX, const int iY);
	void __fastcall setHitBox(const int ValueHitX, const int ValueHitY, const int ValueHitW, const int ValueHitH);
	void __fastcall setWidthHeight(const int w, const int h);
	__property System::Uitypes::TColor BorderColor = {read=FBorderColor, write=setBorderColor, nodefault};
	__property int BorderSize = {read=FBorderSize, write=setBorderSize, nodefault};
	__property bool Clusterable = {read=getClusterable, write=setClusterable, nodefault};
	__property System::Uitypes::TColor HoverBorderColor = {read=FHoverBorder, write=setHoverBorder, nodefault};
	__property System::UnicodeString FontFamily = {read=FFontFamily, write=setFontFamily};
	__property int FontSize = {read=FFontSize, write=setFontSize, nodefault};
	__property bool FontBold = {read=FFontBold, write=setFontBold, nodefault};
	__property bool FontItalic = {read=FFontItalic, write=setFontItalic, nodefault};
	__property int PixelWidth = {read=FPixelWidth, nodefault};
	__property int PixelHeight = {read=FPixelHeight, nodefault};
	__property Uecmaputil::TPenStyle PenStyle = {read=FPenStyle, write=setPenStyle, nodefault};
	__property Uecmaputil::TPOIShape POIShape = {read=FPoiShape, write=setShape, nodefault};
	__property Uecmaputil::TPOIUnit POIUnit = {read=FUnit, write=setUnit, default=0};
	__property double Scale = {read=getScale, write=setScale};
	__property bool WithEgalHeight = {read=FWithEgalHeight, write=setWithEgalHeight, nodefault};
	__property TOnShapeFont OnShapeFont = {read=FOnShapeFont, write=FOnShapeFont};
	__property TOnGetScale OnGetScale = {read=FOnGetScale, write=FOnGetScale};
	__property System::Byte FillOpacity = {read=FFillOpacity, write=setFillOpacity, nodefault};
	__property TECShapeLine* TrackLine = {read=getTrackLine, write=setTrackLine};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TEditShapePOI : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TECShapes* FShapes;
	TECShapePOI* HPoi;
	TECShapePOI* WPoi;
	TECShapePOI* FCible;
	bool FEqualWidthHeight;
	bool FOldDrag;
	void __fastcall doShapeRightClick(System::TObject* sender, TECShape* const item);
	void __fastcall doShapeDrag(System::TObject* sender, TECShape* const item, bool &cancel);
	void __fastcall doShapeEndDrag(System::TObject* sender);
	
public:
	void __fastcall Edit(TECShapePOI* const item);
	void __fastcall Clear();
public:
	/* TObject.Create */ inline __fastcall TEditShapePOI() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TEditShapePOI() { }
	
};

#pragma pack(pop)

typedef void __fastcall (__closure *TOnDragLine)(TECShape* sender, const int IndexPoint, const double NewLat, const double NewLng, bool &cancel);

typedef void __fastcall (__closure *TOnCreateShapeLinePoint)(System::TObject* sender, TECShapes* const Group, TECShape* &ShapeLinePoint, const double Lat, const double Lng, const int index);

class PASCALIMPLEMENTATION TOpenWeatherStationData : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Uecopenweather::TOpenWeatherData Data;
public:
	/* TObject.Create */ inline __fastcall TOpenWeatherStationData() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TOpenWeatherStationData() { }
	
};


enum DECLSPEC_DENUM TPathChange : unsigned char { pcDelete, pcAdd, pcMove, pcNone };

class PASCALIMPLEMENTATION TECShapeLine : public TECShape
{
	typedef TECShape inherited;
	
	
private:
	typedef System::DynamicArray<Uecmaputil::TDPoint> _TECShapeLine__1;
	
	typedef System::DynamicArray<System::Types::TPoint> _TECShapeLine__2;
	
	
public:
	TECPointLine* operator[](int index) { return this->value[index]; }
	
private:
	TOnDragLine FOnDblClickEditLine;
	TOnDragLine FOnDragEdit;
	TOnDragLine FOnDragEnd;
	Uecmaputil::TDashStyle FDashStyle;
	TECShapes* FWeatherGroup;
	bool FStateShowWeather;
	int FWeight;
	System::Byte ZoomWorldXYPoints;
	System::Byte FEncodePrecision;
	int FMeterPixelWeight;
	int FMeterPixelBorder;
	bool FMeterWeight;
	bool FPrevShowText;
	bool FBeginUpdate;
	bool FPathModified;
	bool FShowDirection;
	bool FShowText;
	int FVisiblePercentage;
	int LeftWorld;
	int TopWorld;
	int WidthWorld;
	int HeightWorld;
	int MaxWorldXYPoints;
	int MaxDrawPoints;
	int FDrawPoints;
	int FHOverSeg;
	int FPathIndexChange;
	TPathChange FPathChange;
	int FMinPointForUseDouglasPeucker;
	int FMaxPointForUseDouglasPeucker;
	int FAccuracyScaleZoom;
	int FDuration;
	double FAccuracyDraw;
	double FDistance;
	double FArea;
	Uecmaputil::TLatLng FCentroid;
	TECShapes* FDirectionLineShapes;
	TECShapes* FLineShapes;
	Uecmaputil::TPenStyle FPenStyle;
	TECLineType FPrevLineType;
	TECLineType FLineType;
	_TECShapeLine__1 World01Points;
	_TECShapeLine__2 XYPoints;
	TThreadWeatherRoute* FThreadWeatherRoute;
	float TileWorldXYPoints;
	System::Types::TPoint FLastDrawPoint;
	System::Generics::Collections::TList__1<TECPointLine*>* FPoints;
	TOnCreateShapeLinePoint FOnCreateShapeLinePoint;
	System::Classes::TNotifyEvent FOnWeatherComplete;
	System::Classes::TNotifyEvent FOnShapePathChange;
	double FKmDistanceBetweenWeatherStations;
	System::UnicodeString FEncodedString;
	System::UnicodeString FNameShapes;
	int FWaitBeforeAltitudesRequest;
	System::Byte FMaxAltitudesRequest;
	System::Byte FWeatherDateIndex;
	virtual void __fastcall CheckStyleUpdate();
	void __fastcall DecodeGeometry(const System::UnicodeString value);
	System::UnicodeString __fastcall EncodeGeometry();
	void __fastcall doPathChange();
	void __fastcall setWeight(const int value);
	void __fastcall setMeterWeight(const bool value);
	void __fastcall UpdateMeterWeight();
	TECShapes* __fastcall getShapes();
	TECShapes* __fastcall getDirectionShapes();
	virtual System::UnicodeString __fastcall getToTxt();
	virtual void __fastcall setTotxt(const System::UnicodeString value);
	virtual System::UnicodeString __fastcall getToGpx();
	virtual System::UnicodeString __fastcall getToKml();
	virtual System::UnicodeString __fastcall getToGeoJSON();
	virtual System::UnicodeString __fastcall getToWkt();
	TECPointLine* __fastcall getPoints(int index);
	HIDESBASE TECPointLine* __fastcall getValue(int index)/* overload */;
	virtual bool __fastcall UpdateWorldXYPoints();
	virtual void __fastcall UpdateXYPoints();
	void __fastcall setShowText(const bool value);
	void __fastcall setShowDirection(const bool value);
	virtual void __fastcall setEditable(const bool value);
	void __fastcall setVisiblePercentage(const int value);
	virtual void __fastcall setColor(const System::Uitypes::TColor value);
	virtual void __fastcall setHoverColor(const System::Uitypes::TColor value);
	virtual void __fastcall setBorderColor(const System::Uitypes::TColor value);
	virtual void __fastcall setBorderSize(const int value);
	void __fastcall setHoverBorder(const System::Uitypes::TColor value);
	void __fastcall DragEdit(System::TObject* sender, TECShape* const item, bool &cancel);
	void __fastcall DragEnd(System::TObject* sender);
	void __fastcall DblClickEdit(System::TObject* sender, TECShape* const item);
	void __fastcall ClickEdit(System::TObject* sender, TECShape* const item);
	void __fastcall doNotifygetAltitudes(System::TObject* sender);
	void __fastcall doNotifygetSlopeColors(System::TObject* sender);
	void __fastcall dogetAltitudes(System::TObject* sender);
	virtual void __fastcall Draw();
	virtual void __fastcall setVisible(const bool value);
	void __fastcall setLineType(const TECLineType value);
	void __fastcall setPenStyle(const Uecmaputil::TPenStyle value);
	void __fastcall setAccuracyDraw(const double value);
	void __fastcall setAccuracyScaleZoom(const int value);
	Uecopenweather::TOpenWeatherData __fastcall getWeatherData(int index);
	bool __fastcall getShowWeather();
	void __fastcall setShowWeather(bool value);
	virtual void __fastcall setAngle(const short value);
	void __fastcall setWeatherDateIndex(const System::Byte value);
	
public:
	__fastcall virtual TECShapeLine(TECShapeList* const owner);
	__fastcall virtual ~TECShapeLine();
	virtual void __fastcall Update();
	void __fastcall setCustomDash(const Uecmaputil::TDashStyle Dash);
	virtual void __fastcall UpdateStyle();
	void __fastcall UpdateShapeText();
	HIDESBASE TECShapeLine* __fastcall CopyToGroup(TECShapes* Group);
	HIDESBASE TECShapeLine* __fastcall CopyToGroupAndRemove(TECShapes* Group);
	void __fastcall Slice(const int StartIndex, const int EndIndex, TECShapeLine* Line)/* overload */;
	void __fastcall Slice(const double StartKm, const double EndKm, TECShapeLine* Line)/* overload */;
	TECShapeLine* __fastcall Slice(const double StartKm, const double EndKm, System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	TECShapeLine* __fastcall Slice(const int StartIndex, const int EndIndex, System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	void __fastcall Slice(double ALat, double ALng, double BLat, double BLng, TECShapeLine* Line)/* overload */;
	TECShapeLine* __fastcall Slice(double ALat, double ALng, double BLat, double BLng, System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	void __fastcall Slice(unsigned SegmentLengthMeters, TECShapeLine* const Line)/* overload */;
	void __fastcall Reverse();
	virtual void __fastcall SaveState();
	virtual void __fastcall RestoreState();
	virtual void __fastcall getBounds();
	void __fastcall fitBounds();
	virtual bool __fastcall IsHover(const int iX, const int iY);
	void __fastcall BeginUpdate();
	void __fastcall EndUpdate();
	void __fastcall Simplify(const Uecmaputil::TFloat Tolerance);
	double __fastcall Distance();
	double __fastcall DistanceToIndexPoint(const int idxPoint);
	double __fastcall DistanceBetweenIndexPoint(const int idxA, const int idxB);
	double __fastcall DistanceBetween(const double ALat, const double ALng, const double BLat, const double BLng);
	double __fastcall DistanceToPoint(const double ALat, const double ALng);
	double __fastcall GetDistanceMeterPointToSegment(const double prLatPt, const double prLngPt, const int IndexSegment);
	int __fastcall IndexAndPositionOfNearestPointTo(const double LatPt, const double LngPt, double &nrLatPt, double &nrLngPt);
	int __fastcall NextIndexInstruction(const int index);
	virtual double __fastcall PositionAndDistanceOfNearestPointTo(const double LatPt, const double LngPt, double &nrLatPt, double &nrLngPt);
	virtual double __fastcall HDPositionAndDistanceOfNearestPointTo(const double LatPt, const double LngPt, double &nrLatPt, double &nrLngPt);
	bool __fastcall getLatLngFromMeter(const bool SensStartEnd, const System::LongInt lMeter, double &dLatitude, double &dLongitude, int &idPoint, int &Heading, bool &bEnd);
	virtual void __fastcall SetPosition(const double dLat, const double dLng);
	void __fastcall setRoutePath(Uecgeolocalise::TECRoutePath* const value);
	void __fastcall Clear();
	void __fastcall Delete(int index);
	int __fastcall Add(const double Lat, const double Lng, const double Alt = -9.999000E+03)/* overload */;
	int __fastcall Add(const double *dLatLngs, const System::NativeInt dLatLngs_High)/* overload */;
	int __fastcall Add(TECPointLine* const P)/* overload */;
	int __fastcall Add(TECShapeLine* const dLine)/* overload */;
	void __fastcall Insert(const int index, const double Lat, const double Lng, const double Alt = -9.999000E+03);
	void __fastcall setPoint(const int index, const double Lat, const double Lng, const double Alt = -9.999000E+03);
	void __fastcall SetPath(const double *dLatLngs, const System::NativeInt dLatLngs_High);
	void __fastcall getAltitudes(TOnGetAltitude Event = 0x0)/* overload */;
	void __fastcall getAltitudes(const System::Classes::TNotifyEvent Notify)/* overload */;
	void __fastcall getSlopeColors(const System::Classes::TNotifyEvent Notify, TECShapes* const GroupSlopeColors = (TECShapes*)(0x0));
	int __fastcall Count();
	virtual bool __fastcall ShowOnMap(const bool isMoving = false);
	virtual bool __fastcall isMinimalSize();
	virtual bool __fastcall isInArea(const double SWALat, const double SWALng, const double NEALat, const double NEALng);
	bool __fastcall isInBox(const double FLat, const double FLng);
	int __fastcall WeatherStationCount();
	__property System::Byte WeatherDateIndex = {read=FWeatherDateIndex, write=setWeatherDateIndex, nodefault};
	__property bool ShowWeather = {read=getShowWeather, write=setShowWeather, nodefault};
	__property double KmDistanceBetweenWeatherStations = {read=FKmDistanceBetweenWeatherStations, write=FKmDistanceBetweenWeatherStations};
	__property Uecopenweather::TOpenWeatherData WeatherData[int index] = {read=getWeatherData};
	__property double AccuracyDraw = {read=FAccuracyDraw, write=setAccuracyDraw};
	__property int AccuracyScaleZoom = {read=FAccuracyScaleZoom, write=setAccuracyScaleZoom, nodefault};
	__property int MinPointForUseDouglasPeucker = {read=FMinPointForUseDouglasPeucker, write=FMinPointForUseDouglasPeucker, nodefault};
	__property int MaxPointForUseDouglasPeucker = {read=FMaxPointForUseDouglasPeucker, write=FMaxPointForUseDouglasPeucker, nodefault};
	__property int Weight = {read=FWeight, write=setWeight, nodefault};
	__property bool MeterWeight = {read=FMeterWeight, write=setMeterWeight, nodefault};
	__property int HoverPoint = {read=FHOverSeg, write=FHOverSeg, nodefault};
	__property TECPointLine* Path[int index] = {read=getPoints};
	__property TECPointLine* value[int index] = {read=getValue/*, default*/};
	__property int PathIndexChange = {read=FPathIndexChange, nodefault};
	__property TPathChange PathChange = {read=FPathChange, write=FPathChange, nodefault};
	__property int Duration = {read=FDuration, write=FDuration, nodefault};
	__property System::UnicodeString Encoded = {read=EncodeGeometry, write=DecodeGeometry};
	__property System::Byte EncodePrecision = {read=FEncodePrecision, write=FEncodePrecision, nodefault};
	__property bool ShowText = {read=FShowText, write=setShowText, nodefault};
	__property bool ShowDirection = {read=FShowDirection, write=setShowDirection, nodefault};
	__property int VisiblePercentage = {read=FVisiblePercentage, write=setVisiblePercentage, nodefault};
	__property System::Types::TPoint LastDrawPoint = {read=FLastDrawPoint};
	__property TECShapes* Shapes = {read=getShapes};
	__property TECShapes* DirectionShapes = {read=getDirectionShapes};
	__property TECLineType LineType = {read=FLineType, write=setLineType, nodefault};
	__property Uecmaputil::TPenStyle PenStyle = {read=FPenStyle, write=setPenStyle, nodefault};
	__property System::Classes::TNotifyEvent OnShapePathChange = {read=FOnShapePathChange, write=FOnShapePathChange};
	__property TOnCreateShapeLinePoint OnCreateShapeLinePoint = {read=FOnCreateShapeLinePoint, write=FOnCreateShapeLinePoint};
	__property System::Classes::TNotifyEvent OnWeatherComplete = {read=FOnWeatherComplete, write=FOnWeatherComplete};
	__property TOnDragLine OnDragEdit = {read=FOnDragEdit, write=FOnDragEdit};
	__property TOnDragLine OnDragEnd = {read=FOnDragEnd, write=FOnDragEnd};
	__property TOnDragLine OnDblClickEditLine = {read=FOnDblClickEditLine, write=FOnDblClickEditLine};
	__property System::Uitypes::TColor BorderColor = {read=FBorderColor, write=setBorderColor, nodefault};
	__property int BorderSize = {read=FBorderSize, write=setBorderSize, nodefault};
	__property System::Uitypes::TColor HoverBorderColor = {read=FHoverBorder, write=setHoverBorder, nodefault};
	__property int WaitBeforeAltitudesRequest = {read=FWaitBeforeAltitudesRequest, write=FWaitBeforeAltitudesRequest, nodefault};
	__property System::Byte MaxAltitudesRequest = {read=FMaxAltitudesRequest, write=FMaxAltitudesRequest, nodefault};
	/* Hoisted overloads: */
	
};


class PASCALIMPLEMENTATION TECShapePolygone : public TECShapeLine
{
	typedef TECShapeLine inherited;
	
private:
	bool FasHole;
	TECShapePolygone* FHoleParent;
	System::Uitypes::TColor FFillColor;
	Vcl::Graphics::TBrushStyle FPolygoneStyle;
	int FLevel;
	TECShapes* FLevelShapes;
	System::Byte FFillOpacity;
	virtual bool __fastcall UpdateWorldXYPoints();
	virtual void __fastcall UpdateXYPoints();
	void __fastcall setFillOpacity(const System::Byte value);
	void __fastcall setFillColor(const System::Uitypes::TColor value);
	void __fastcall SetStyle(const Vcl::Graphics::TBrushStyle value);
	void __fastcall setLevel(const int value);
	virtual System::UnicodeString __fastcall getToTxt();
	virtual void __fastcall setTotxt(const System::UnicodeString value);
	virtual System::UnicodeString __fastcall getToGpx();
	virtual System::UnicodeString __fastcall getToKml();
	virtual System::UnicodeString __fastcall getToGeoJSON();
	virtual System::UnicodeString __fastcall getToWkt();
	virtual void __fastcall setEditable(const bool value);
	virtual void __fastcall setBorderColor(const System::Uitypes::TColor value);
	virtual void __fastcall setBorderSize(const int value);
	
public:
	__fastcall virtual TECShapePolygone(TECShapeList* const owner);
	__fastcall virtual ~TECShapePolygone();
	HIDESBASE TECShapePolygone* __fastcall CopyToGroup(TECShapes* Group);
	HIDESBASE TECShapePolygone* __fastcall CopyToGroupAndRemove(TECShapes* Group);
	virtual void __fastcall SaveState();
	virtual void __fastcall RestoreState();
	double __fastcall Area();
	Uecmaputil::TLatLng __fastcall Centroid();
	virtual bool __fastcall isMinimalSize();
	virtual bool __fastcall isInArea(const double SWALat, const double SWALng, const double NEALat, const double NEALng);
	int __fastcall PathGetHitLatLng(const double startlat, const double startlng, const double Bearing, double &HitLat, double &HitLng, const double deltaKM = 5.000000E-02);
	bool __fastcall BoxGetHitLatLng(const double startlat, const double startlng, const double Bearing, double &HitLat, double &HitLng, const double deltaKM = 5.000000E-02);
	virtual double __fastcall PositionAndDistanceOfNearestPointTo(const double LatPt, const double LngPt, double &nrLatPt, double &nrLngPt);
	virtual double __fastcall HDPositionAndDistanceOfNearestPointTo(const double LatPt, const double LngPt, double &nrLatPt, double &nrLngPt);
	virtual bool __fastcall IsHover(const int iX, const int iY);
	bool __fastcall ContainsLatLng(const double Lat, const double Lng);
	virtual void __fastcall Draw();
	virtual void __fastcall Update();
	__property System::Byte FillOpacity = {read=FFillOpacity, write=setFillOpacity, nodefault};
	__property System::Uitypes::TColor FillColor = {read=FFillColor, write=setFillColor, nodefault};
	__property Vcl::Graphics::TBrushStyle Style = {read=FPolygoneStyle, write=SetStyle, nodefault};
	__property int Level = {read=FLevel, write=setLevel, nodefault};
	__property TECShapePolygone* HoleParent = {read=FHoleParent};
	__property bool asHole = {read=FasHole, nodefault};
};


class PASCALIMPLEMENTATION TECTextFont : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	bool FFontItalic;
	bool FFontBold;
	int FFontSize;
	System::UnicodeString FFontFamily;
	System::Classes::TNotifyEvent FOnchange;
	void __fastcall setBold(const bool value);
	void __fastcall setItalic(const bool value);
	void __fastcall setSize(const int value);
	void __fastcall setFamily(const System::UnicodeString value);
	void __fastcall doChange();
	
public:
	__fastcall TECTextFont(System::Classes::TNotifyEvent Notify);
	__property bool Bold = {read=FFontBold, write=setBold, nodefault};
	__property bool Italic = {read=FFontItalic, write=setItalic, nodefault};
	__property int Size = {read=FFontSize, write=setSize, nodefault};
	__property System::UnicodeString Family = {read=FFontFamily, write=setFamily};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECTextFont() { }
	
};


typedef System::Word TECAngleFov;

class PASCALIMPLEMENTATION TECShapeMarker : public TECShape
{
	typedef TECShape inherited;
	
	
private:
	typedef System::DynamicArray<System::Types::TPoint> _TECShapeMarker__1;
	
	
private:
	bool FOwnsGraphic;
	System::Classes::TNotifyEvent FOnLoad;
	TECShapeLine* FTrackLine;
	TECTextFont* FTextFont;
	bool FFitBounds;
	System::UnicodeString FFilename;
	int FOriginX;
	int FOriginy;
	int FIcon;
	Vcl::Graphics::TGraphic* FRotateBitmap;
	double FBufAngle;
	int FHitX;
	int FHitY;
	int FHitW;
	int FHitH;
	Vcl::Graphics::TGraphic* FGraphic;
	bool FWaitAnimation;
	System::Byte FFovOpacity;
	short FFovAngle;
	TECAngleFov FFov;
	int FFovRadius;
	bool FFovHit;
	_TECShapeMarker__1 FFovPts;
	TECTextFont* __fastcall getTextFont();
	void __fastcall setIcon(const int value);
	virtual void __fastcall setEditable(const bool value);
	void __fastcall setBorderColor(const System::Uitypes::TColor value);
	void __fastcall setBorderSize(const int value);
	void __fastcall setFovAngle(const short value);
	void __fastcall setFOV(const TECAngleFov value);
	void __fastcall setFovOpacity(const System::Byte value);
	void __fastcall setFovRadius(const int value);
	void __fastcall setFilename(const System::UnicodeString value);
	void __fastcall setGraphic(Vcl::Graphics::TGraphic* value);
	virtual System::UnicodeString __fastcall getToTxt();
	virtual void __fastcall setTotxt(const System::UnicodeString value);
	virtual System::UnicodeString __fastcall getToKml();
	virtual System::UnicodeString __fastcall getToGeoJSON();
	virtual System::UnicodeString __fastcall getToWkt();
	void __fastcall setOriginX(int value);
	void __fastcall setOriginY(int value);
	void __fastcall setFitBounds(const bool value);
	virtual void __fastcall setScale(const double value);
	void __fastcall setClusterable(const bool value);
	virtual bool __fastcall getClusterable();
	virtual int __fastcall getWidth();
	virtual int __fastcall getHeight();
	virtual void __fastcall setWidth(const int value);
	virtual void __fastcall setHeight(const int value);
	void __fastcall _Draw();
	virtual void __fastcall DrawTo(const int X, const int Y, Vcl::Graphics::TCanvas* canvas);
	virtual void __fastcall setColor(const System::Uitypes::TColor value);
	virtual void __fastcall setHoverColor(const System::Uitypes::TColor value);
	void __fastcall setHoverBorder(const System::Uitypes::TColor value);
	virtual void __fastcall setDescription(const System::UnicodeString value);
	virtual void __fastcall setSelected(const bool value);
	virtual TBitmapCache* __fastcall CreateBitmap();
	virtual void __fastcall setAngle(const short value);
	virtual void __fastcall Draw();
	void __fastcall DrawFov();
	void __fastcall setStyleIcon(const TECStyleIcon value);
	TECShapeLine* __fastcall getTrackLine();
	void __fastcall setTrackLine(TECShapeLine* value);
	void __fastcall doOnTextFontChange(System::TObject* sender);
	
public:
	__fastcall virtual TECShapeMarker(TECShapeList* const owner);
	__fastcall virtual ~TECShapeMarker();
	virtual void __fastcall Update();
	virtual void __fastcall SetPosition(const double dLat, const double dLng);
	HIDESBASE TECShapeMarker* __fastcall CopyToGroup(TECShapes* Group);
	HIDESBASE TECShapeMarker* __fastcall CopyToGroupAndRemove(TECShapes* Group);
	virtual void __fastcall RestoreState();
	virtual void __fastcall SaveState();
	bool __fastcall isTrackLineActive();
	virtual bool __fastcall isHit(const int _x, const int _y);
	virtual bool __fastcall IsHover(const int _x, const int _y);
	void __fastcall setHitBox(const int ValueHitX, const int ValueHitY, const int ValueHitW, const int ValueHitH);
	void __fastcall setText(const System::UnicodeString Text, const int FSize = 0xa, const bool FBold = false, const System::UnicodeString FFamily = System::UnicodeString(), const bool FItalic = false);
	void __fastcall setBounds(double NorthEastLatitude, double NorthEastLongitude, double SouthWestLatitude, double SouthWestLongitude);
	virtual bool __fastcall isInArea(const double SWALat, const double SWALng, const double NEALat, const double NEALng);
	virtual bool __fastcall ShowOnMap(const bool isMoving = false);
	virtual bool __fastcall isRepaintHover();
	__property bool Clusterable = {read=getClusterable, write=setClusterable, nodefault};
	__property bool fitBounds = {read=FFitBounds, write=setFitBounds, nodefault};
	__property System::UnicodeString filename = {read=FFilename, write=setFilename};
	__property int Icon = {read=FIcon, write=setIcon, nodefault};
	__property int OriginX = {read=FOriginX, write=setOriginX, nodefault};
	__property int OriginY = {read=FOriginy, write=setOriginY, nodefault};
	__property bool OwnsGraphic = {read=FOwnsGraphic, write=FOwnsGraphic, nodefault};
	__property Vcl::Graphics::TGraphic* Graphic = {read=FGraphic, write=setGraphic};
	__property double Scale = {read=getScale, write=setScale};
	__property bool WaitAnimation = {read=FWaitAnimation, write=FWaitAnimation, nodefault};
	__property TECStyleIcon StyleIcon = {read=FStyleIcon, write=setStyleIcon, nodefault};
	__property TECShapeLine* TrackLine = {read=getTrackLine, write=setTrackLine};
	__property TECAngleFov Fov = {read=FFov, write=setFOV, nodefault};
	__property short FovAngle = {read=FFovAngle, write=setFovAngle, nodefault};
	__property int FovRadius = {read=FFovRadius, write=setFovRadius, nodefault};
	__property bool FovHit = {read=FFovHit, nodefault};
	__property System::Byte FovOpacity = {read=FFovOpacity, write=setFovOpacity, nodefault};
	__property TECTextFont* TextFont = {read=getTextFont};
	__property System::Uitypes::TColor BorderColor = {read=FBorderColor, write=setBorderColor, nodefault};
	__property int BorderSize = {read=FBorderSize, write=setBorderSize, nodefault};
	__property System::Uitypes::TColor HoverBorderColor = {read=FHoverBorder, write=setHoverBorder, nodefault};
	__property TOnGetScale OnGetScale = {read=FOnGetScale, write=FOnGetScale};
	__property System::Classes::TNotifyEvent OnLoad = {read=FOnLoad, write=FOnLoad};
};


class PASCALIMPLEMENTATION TECShapeList : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Winapi::Windows::TRTLCriticalSection FCritSect;
	bool FChangedBounds;
	bool FShow;
	TOnGetScale FOnGetScale;
	int FMaxPointsShowOnMove;
	TECShapes* FParent;
	bool FSerialize;
	bool FVisible;
	bool FFreeObject;
	Uecmapfile::TECParamParser* FParser;
	Uecmaputil::TecToken* FToken;
	int FCount;
	__int64 Fid;
	System::Byte FMinZoom;
	System::Byte FMaxZoom;
	Uecmaputil::TECWorldInfo* FWorldInfo;
	System::Classes::TStringList* FNames;
	System::Generics::Collections::TList__1<TECShape*>* FList;
	double FlatSW;
	double FlngSW;
	double FlatNE;
	double FlngNE;
	System::Classes::TNotifyEvent FOnchange;
	System::Classes::TNotifyEvent FOnUpdate;
	System::Classes::TNotifyEvent FOnChangeEditable;
	TOnDrawShape FOnOwnerDraw;
	TOnDrawShape FOnAfterDraw;
	TOnDrawShape FOnBeforeDraw;
	TECShape* __fastcall getShape(int index);
	virtual TECShape* __fastcall getName(const System::UnicodeString index);
	__int64 __fastcall getID();
	virtual System::UnicodeString __fastcall getToTxt();
	virtual void __fastcall setTotxt(const System::UnicodeString value);
	virtual System::UnicodeString __fastcall getToGpx();
	virtual System::UnicodeString __fastcall getToKml();
	virtual System::UnicodeString __fastcall getToGeoJSON();
	virtual System::UnicodeString __fastcall getToWKT();
	void __fastcall setShow(const bool value);
	void __fastcall setVisible(const bool value);
	bool __fastcall getVisible();
	void __fastcall setSelected(const bool value);
	bool __fastcall getSelected();
	void __fastcall setMinZoom(const System::Byte value);
	void __fastcall setMaxZoom(const System::Byte value);
	TOnGetScale __fastcall getOnGetScale();
	__property Uecmapfile::TECParamParser* Parser = {read=FParser};
	
public:
	__fastcall virtual TECShapeList(TECShapes* ParentShapes, Uecmaputil::TECWorldInfo* const dWorld, System::Classes::TNotifyEvent FEvent);
	__fastcall virtual ~TECShapeList();
	void __fastcall Lock();
	void __fastcall UnLock();
	bool __fastcall isInArea(const double SWLat, const double SWLng, const double NELat, const double NELng);
	void __fastcall ChangeBounds();
	void __fastcall AddItem(TECShape* value);
	virtual void __fastcall Delete(int index);
	virtual void __fastcall Update(System::TObject* sender);
	virtual void __fastcall Clear();
	virtual void __fastcall ClearNoOnMap();
	virtual void __fastcall getBounds(const bool inView = false);
	virtual void __fastcall fitBounds();
	virtual bool __fastcall ShowOnMap(const bool isMoving = false);
	void __fastcall Exchange(int Index1, int Index2);
	int __fastcall Count();
	int __fastcall IndexOf(void * item);
	virtual TECShape* __fastcall ShapeByLatLng(double Lat, double Lng);
	__property System::Byte MinZoom = {read=FMinZoom, write=setMinZoom, nodefault};
	__property System::Byte MaxZoom = {read=FMaxZoom, write=setMaxZoom, nodefault};
	__property bool Selected = {read=getSelected, write=setSelected, nodefault};
	__property bool Visible = {read=getVisible, write=setVisible, nodefault};
	__property bool Show = {read=FShow, write=setShow, nodefault};
	__property TECShape* Shape[int index] = {read=getShape};
	__property Uecmaputil::TECWorldInfo* World = {read=FWorldInfo};
	__property int MaxPointsShowOnMove = {read=FMaxPointsShowOnMove, write=FMaxPointsShowOnMove, nodefault};
	__property TOnDrawShape OnOwnerDraw = {read=FOnOwnerDraw, write=FOnOwnerDraw};
	__property TOnDrawShape OnAfterDraw = {read=FOnAfterDraw, write=FOnAfterDraw};
	__property TOnDrawShape OnBeforeDraw = {read=FOnBeforeDraw, write=FOnBeforeDraw};
	__property System::Classes::TNotifyEvent OnChange = {read=FOnchange, write=FOnchange};
	__property System::Classes::TNotifyEvent OnChangeEditable = {read=FOnChangeEditable, write=FOnChangeEditable};
	__property double NorthEastLatitude = {read=FlatNE};
	__property double NorthEastLongitude = {read=FlngNE};
	__property double SouthWestLatitude = {read=FlatSW};
	__property double SouthWestLongitude = {read=FlngSW};
	__property System::UnicodeString toTxt = {read=getToTxt, write=setTotxt};
	__property System::UnicodeString ToGpx = {read=getToGpx};
	__property System::UnicodeString ToKml = {read=getToKml};
	__property System::UnicodeString ToWKT = {read=getToWKT};
	__property System::UnicodeString ToGeoJSon = {read=getToGeoJSON};
	__property __int64 Id = {read=getID};
	__property TECShapes* Parent = {read=FParent};
	__property bool Serialize = {read=FSerialize, write=FSerialize, nodefault};
	__property TOnGetScale OnGetScale = {read=getOnGetScale, write=FOnGetScale};
};


class PASCALIMPLEMENTATION TECShapeInfoWindowList : public TECShapeList
{
	typedef TECShapeList inherited;
	
public:
	TECShapeInfoWindow* operator[](int index) { return this->infoWindow[index]; }
	
private:
	TECShapeInfoWindow* __fastcall getInfoWindow(int index);
	virtual System::UnicodeString __fastcall getToTxt();
	virtual void __fastcall setTotxt(const System::UnicodeString value);
	virtual System::UnicodeString __fastcall getToKml();
	virtual System::UnicodeString __fastcall getToGpx();
	virtual System::UnicodeString __fastcall getToGeoJSON();
	HIDESBASE TECShapeInfoWindow* __fastcall getName(const System::UnicodeString index);
	
public:
	int __fastcall Add(const double dLatitude = -7.700000E+01, const double dLongitude = -7.700000E+01, const System::UnicodeString value = System::UnicodeString());
	virtual void __fastcall Clear();
	void __fastcall Draw();
	virtual void __fastcall getBounds(const bool inView = false);
	virtual void __fastcall Delete(int index);
	TECShapeInfoWindowListEnumerator* __fastcall GetEnumerator();
	__property TECShapeInfoWindow* infoWindow[int index] = {read=getInfoWindow/*, default*/};
	__property TECShapeInfoWindow* Name[const System::UnicodeString index] = {read=getName};
public:
	/* TECShapeList.Create */ inline __fastcall virtual TECShapeInfoWindowList(TECShapes* ParentShapes, Uecmaputil::TECWorldInfo* const dWorld, System::Classes::TNotifyEvent FEvent) : TECShapeList(ParentShapes, dWorld, FEvent) { }
	/* TECShapeList.Destroy */ inline __fastcall virtual ~TECShapeInfoWindowList() { }
	
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECShapeInfoWindowListEnumerator : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	int FIndex;
	TECShapeInfoWindowList* FList;
	
public:
	__fastcall TECShapeInfoWindowListEnumerator(TECShapeInfoWindowList* AMyList);
	bool __fastcall MoveNext();
	TECShapeInfoWindow* __fastcall GetCurrent();
	__property TECShapeInfoWindow* Current = {read=GetCurrent};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECShapeInfoWindowListEnumerator() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECShapeListHeatMap : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TECShapeList* FShapeList;
	System::TObject* FHeatMapLayer;
	bool FShow;
	bool FVisible;
	System::Classes::TNotifyEvent FOnUpdate;
	void __fastcall CheckInitialize();
	Uecheatmap::THeatPalette* __fastcall getPalette();
	void __fastcall setVisible(const bool AValue);
	System::Byte __fastcall getMaxZoom();
	void __fastcall setMaxZoom(const System::Byte AValue);
	System::Byte __fastcall getMinZoom();
	void __fastcall setMinZoom(const System::Byte AValue);
	void __fastcall setRadius(const int AValue);
	int __fastcall getRadius();
	void __fastcall doOnUpdate(System::TObject* sender);
	void __fastcall doOnChangeZoom(System::TObject* sender);
	
public:
	__fastcall TECShapeListHeatMap(TECShapeList* AShapeList);
	__fastcall virtual ~TECShapeListHeatMap();
	void __fastcall Update(const System::UnicodeString KeyWeight = System::UnicodeString());
	void __fastcall setSize(const int AValue);
	__property System::Byte MaxZoom = {read=getMaxZoom, write=setMaxZoom, nodefault};
	__property System::Byte MinZoom = {read=getMinZoom, write=setMinZoom, nodefault};
	__property int Radius = {read=getRadius, write=setRadius, nodefault};
	__property Uecheatmap::THeatPalette* Palette = {read=getPalette};
	__property bool Visible = {read=FVisible, write=setVisible, nodefault};
	__property System::Classes::TNotifyEvent OnUpdate = {read=FOnUpdate, write=FOnUpdate};
	__property TECShapeList* ShapeList = {read=FShapeList};
};


class PASCALIMPLEMENTATION TECShapePOIList : public TECShapeList
{
	typedef TECShapeList inherited;
	
public:
	TECShapePOI* operator[](int index) { return this->Poi[index]; }
	
private:
	TECShapeListHeatMap* FShapeListHeatMap;
	int FHitBorder;
	TLabelShape* FLabelShape;
	TECShapePOI* __fastcall getPoi(int index);
	virtual System::UnicodeString __fastcall getToTxt();
	virtual void __fastcall setTotxt(const System::UnicodeString value);
	virtual System::UnicodeString __fastcall getToKml();
	virtual System::UnicodeString __fastcall getToGpx();
	virtual System::UnicodeString __fastcall getToGeoJSON();
	virtual System::UnicodeString __fastcall getToWKT();
	HIDESBASE TECShapePOI* __fastcall getName(const System::UnicodeString index);
	
public:
	__fastcall virtual TECShapePOIList(TECShapes* ParentShapes, Uecmaputil::TECWorldInfo* const dWorld, System::Classes::TNotifyEvent FEvent);
	__fastcall virtual ~TECShapePOIList();
	TECShapePOI* __fastcall AddPoi(const double dLatitude, const double dLongitude)/* overload */;
	TECShapePOI* __fastcall AddPoi(const double SWLat, const double SWLng, const double NELat, const double NELng)/* overload */;
	int __fastcall Add(const double dLatitude, const double dLongitude);
	virtual void __fastcall Clear();
	virtual void __fastcall ClearNoOnMap();
	void __fastcall Draw(Vcl::Graphics::TCanvas* canvas);
	virtual void __fastcall getBounds(const bool inView = false);
	virtual void __fastcall Delete(int index);
	TECShapePOIListEnumerator* __fastcall GetEnumerator();
	__property TECShapePOI* Poi[int index] = {read=getPoi/*, default*/};
	__property TECShapePOI* Name[const System::UnicodeString index] = {read=getName};
	__property int HitBorder = {read=FHitBorder, write=FHitBorder, nodefault};
	__property TLabelShape* Labels = {read=FLabelShape};
	__property TECShapeListHeatMap* HeatMap = {read=FShapeListHeatMap};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECShapePOIListEnumerator : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	int FIndex;
	TECShapePOIList* FList;
	
public:
	__fastcall TECShapePOIListEnumerator(TECShapePOIList* AMyList);
	bool __fastcall MoveNext();
	TECShapePOI* __fastcall GetCurrent();
	__property TECShapePOI* Current = {read=GetCurrent};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECShapePOIListEnumerator() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECShapeMarkerList : public TECShapeList
{
	typedef TECShapeList inherited;
	
public:
	TECShapeMarker* operator[](int index) { return this->Marker[index]; }
	
private:
	TECShapeListHeatMap* FShapeListHeatMap;
	Vcl::Graphics::TIcon* FIcon;
	TECShapeMarker* _M;
	bool FBitmapFlatMarker;
	TLabelShape* FLabelShape;
	TECShapeMarker* __fastcall getMarker(int index);
	virtual System::UnicodeString __fastcall getToTxt();
	virtual void __fastcall setTotxt(const System::UnicodeString value);
	virtual System::UnicodeString __fastcall getToKml();
	virtual System::UnicodeString __fastcall getToGeoJSON();
	virtual System::UnicodeString __fastcall getToWKT();
	virtual System::UnicodeString __fastcall getToGpx();
	HIDESBASE TECShapeMarker* __fastcall getName(const System::UnicodeString index);
	
public:
	__fastcall virtual TECShapeMarkerList(TECShapes* ParentShapes, Uecmaputil::TECWorldInfo* const dWorld, System::Classes::TNotifyEvent FEvent);
	__fastcall virtual ~TECShapeMarkerList();
	virtual void __fastcall getBounds(const bool inView = false);
	int __fastcall Add(const double dLatitude, const double dLongitude)/* overload */;
	TECShapeMarker* __fastcall AddMarker(const double dLatitude, const double dLongitude)/* overload */;
	int __fastcall Add(const double NorthEastLatitude, const double NorthEastLongitude, const double SouthWestLatitude, const double SouthWestLongitude)/* overload */;
	TECShapeMarker* __fastcall AddMarker(const double NorthEastLatitude, const double NorthEastLongitude, const double SouthWestLatitude, const double SouthWestLongitude)/* overload */;
	virtual void __fastcall Clear();
	virtual void __fastcall ClearNoOnMap();
	void __fastcall Draw();
	Vcl::Graphics::TGraphic* __fastcall getPng(const int idIcon, const int w, const int h);
	void __fastcall DrawIcon(const int Left, const int Top, const int idIcon, const double WorldScale = 1.000000E+00);
	virtual void __fastcall Delete(int index);
	int __fastcall IndexOfFilename(const System::UnicodeString filename);
	TECShapeMarkerListEnumerator* __fastcall GetEnumerator();
	__property bool BitmapFlatMarker = {read=FBitmapFlatMarker, write=FBitmapFlatMarker, nodefault};
	__property TECShapeMarker* Marker[int index] = {read=getMarker/*, default*/};
	__property TECShapeMarker* Name[const System::UnicodeString index] = {read=getName};
	__property TLabelShape* Labels = {read=FLabelShape};
	__property TECShapeListHeatMap* HeatMap = {read=FShapeListHeatMap};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECShapeMarkerListEnumerator : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	int FIndex;
	TECShapeMarkerList* FList;
	
public:
	__fastcall TECShapeMarkerListEnumerator(TECShapeMarkerList* AMyList);
	bool __fastcall MoveNext();
	TECShapeMarker* __fastcall GetCurrent();
	__property TECShapeMarker* Current = {read=GetCurrent};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECShapeMarkerListEnumerator() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECShapeLineList : public TECShapeList
{
	typedef TECShapeList inherited;
	
public:
	TECShapeLine* operator[](int index) { return this->Line[index]; }
	
private:
	Uecmaputil::TPOIShape FDirectionPOIShape;
	int FDirectionPoiWith;
	int FDirectionPoiHeigh;
	TLabelShape* FLabelShape;
	TECShapeLine* __fastcall getLine(int index);
	virtual System::UnicodeString __fastcall getToTxt();
	virtual void __fastcall setTotxt(const System::UnicodeString value);
	virtual System::UnicodeString __fastcall getToKml();
	virtual System::UnicodeString __fastcall getToGeoJSON();
	virtual System::UnicodeString __fastcall getToWKT();
	virtual System::UnicodeString __fastcall getToGpx();
	HIDESBASE TECShapeLine* __fastcall getName(const System::UnicodeString index);
	
public:
	__fastcall virtual TECShapeLineList(TECShapes* ParentShapes, Uecmaputil::TECWorldInfo* const dWorld, System::Classes::TNotifyEvent FEvent);
	__fastcall virtual ~TECShapeLineList();
	int __fastcall Add(const double dLatitude, const double dLongitude)/* overload */;
	int __fastcall Add(const double *dLatLngs, const System::NativeInt dLatLngs_High)/* overload */;
	TECShapeLine* __fastcall Add()/* overload */;
	TECShapeLine* __fastcall AddLine()/* overload */;
	TECShapeLine* __fastcall AddLine(const double dLatitude, const double dLongitude)/* overload */;
	TECShapeLine* __fastcall AddLine(const double *dLatLngs, const System::NativeInt dLatLngs_High)/* overload */;
	virtual void __fastcall Clear();
	virtual void __fastcall ClearNoOnMap();
	virtual void __fastcall getBounds(const bool inView = false);
	void __fastcall Draw();
	TNearestLine __fastcall NearestLineToPoint(const double Lat, const double Lng, int MinDistanceMeter = 0x64);
	virtual void __fastcall Delete(int index);
	TECShapeLineListEnumerator* __fastcall GetEnumerator();
	__property TECShapeLine* Line[int index] = {read=getLine/*, default*/};
	__property TECShapeLine* Name[const System::UnicodeString index] = {read=getName};
	__property TLabelShape* Labels = {read=FLabelShape};
	__property Uecmaputil::TPOIShape DirectionPOIShape = {read=FDirectionPOIShape, write=FDirectionPOIShape, nodefault};
	__property int DirectionPoiWith = {read=FDirectionPoiWith, write=FDirectionPoiWith, nodefault};
	__property int DirectionPoiHeight = {read=FDirectionPoiHeigh, write=FDirectionPoiHeigh, nodefault};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECShapeLineListEnumerator : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	int FIndex;
	TECShapeLineList* FList;
	
public:
	__fastcall TECShapeLineListEnumerator(TECShapeLineList* AMyList);
	bool __fastcall MoveNext();
	TECShapeLine* __fastcall GetCurrent();
	__property TECShapeLine* Current = {read=GetCurrent};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECShapeLineListEnumerator() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECShapePolygoneList : public TECShapeList
{
	typedef TECShapeList inherited;
	
public:
	TECShapePolygone* operator[](int index) { return this->Polygone[index]; }
	
private:
	TLabelShape* FLabelShape;
	TECShapePolygone* __fastcall getPoly(int index);
	virtual System::UnicodeString __fastcall getToTxt();
	virtual void __fastcall setTotxt(const System::UnicodeString value);
	virtual System::UnicodeString __fastcall getToKml();
	virtual System::UnicodeString __fastcall getToGeoJSON();
	virtual System::UnicodeString __fastcall getToWKT();
	virtual System::UnicodeString __fastcall getToGpx();
	HIDESBASE TECShapePolygone* __fastcall getName(const System::UnicodeString index);
	
public:
	__fastcall virtual TECShapePolygoneList(TECShapes* ParentShapes, Uecmaputil::TECWorldInfo* const dWorld, System::Classes::TNotifyEvent FEvent);
	__fastcall virtual ~TECShapePolygoneList();
	TECShapePolygone* __fastcall AddPoly()/* overload */;
	TECShapePolygone* __fastcall AddPoly(const double dLatitude, const double dLongitude)/* overload */;
	TECShapePolygone* __fastcall AddPoly(const double *dLatLngs, const System::NativeInt dLatLngs_High)/* overload */;
	TECShapePolygone* __fastcall AddPoly(TECShapeLine* const dLine)/* overload */;
	int __fastcall Add(const double dLatitude, const double dLongitude)/* overload */;
	int __fastcall Add(const double *dLatLngs, const System::NativeInt dLatLngs_High)/* overload */;
	int __fastcall Add(TECShapeLine* const dLine)/* overload */;
	TECShapePolygone* __fastcall Add()/* overload */;
	virtual void __fastcall Clear();
	virtual void __fastcall ClearNoOnMap();
	virtual void __fastcall getBounds(const bool inView = false);
	TNearestPolygone __fastcall NearestPolygoneToPoint(const double Lat, const double Lng, int MinDistanceMeter = 0x64);
	void __fastcall Draw();
	virtual TECShape* __fastcall ShapeByLatLng(double Lat, double Lng);
	virtual void __fastcall Delete(int index);
	TECShapePolygoneListEnumerator* __fastcall GetEnumerator();
	__property TECShapePolygone* Polygone[int index] = {read=getPoly/*, default*/};
	__property TECShapePolygone* Name[const System::UnicodeString index] = {read=getName};
	__property TLabelShape* Labels = {read=FLabelShape};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECShapePolygoneListEnumerator : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	int FIndex;
	TECShapePolygoneList* FList;
	
public:
	__fastcall TECShapePolygoneListEnumerator(TECShapePolygoneList* AMyList);
	bool __fastcall MoveNext();
	TECShapePolygone* __fastcall GetCurrent();
	__property TECShapePolygone* Current = {read=GetCurrent};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECShapePolygoneListEnumerator() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECNativeRoutePath : public Uecgeolocalise::TECRoutePath
{
	typedef Uecgeolocalise::TECRoutePath inherited;
	
private:
	TECShapesGroup* FOwner;
	
public:
	__fastcall virtual ~TECNativeRoutePath();
public:
	/* TECRoutePath.create */ inline __fastcall TECNativeRoutePath() : Uecgeolocalise::TECRoutePath() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECCluster : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FHint;
	Uecmaputil::TECAGraphInfo FGraphCategorie;
	bool FZoomWhenClicked;
	TECShapes* FGroup;
	double FLat;
	double FLng;
	double FlatNE;
	double FlngNE;
	double FlatSW;
	double FlngSW;
	bool FClickable;
	bool FHover;
	int FCount;
	int FX;
	int FY;
	int FLeft;
	int FTop;
	int FWidth;
	int FHeight;
	TECShape* FFirstItem;
	System::TObject* FData;
	TECShapesList* FShapes;
	TECShape* FShapecsZIndex;
	TECCluster* FPrev;
	TECCluster* FNext;
	
public:
	__fastcall TECCluster(TECShapes* Group);
	__fastcall virtual ~TECCluster();
	__property int Count = {read=FCount, nodefault};
	__property bool Clickable = {read=FClickable, nodefault};
	__property double Latitude = {read=FLat};
	__property double Longitude = {read=FLng};
	__property double LatNE = {read=FlatNE};
	__property double LngNE = {read=FlngNE};
	__property double LatSW = {read=FlatSW};
	__property double LngSW = {read=FlngSW};
	__property int Width = {read=FWidth, nodefault};
	__property int Height = {read=FHeight, nodefault};
	__property bool Hover = {read=FHover, nodefault};
	__property int Top = {read=FTop, nodefault};
	__property int Left = {read=FLeft, nodefault};
	__property int X = {read=FX, nodefault};
	__property int Y = {read=FY, nodefault};
	__property System::TObject* Data = {read=FData, write=FData};
	__property TECCluster* Next = {read=FNext};
	__property TECCluster* Prev = {read=FPrev};
	__property System::UnicodeString Hint = {read=FHint, write=FHint};
	__property TECShapes* Group = {read=FGroup};
	__property Uecmaputil::TECAGraphInfo Categories = {read=FGraphCategorie};
	__property TECShapesList* Shapes = {read=FShapes};
	__property bool ZoomWhenClicked = {read=FZoomWhenClicked, write=FZoomWhenClicked, nodefault};
};


struct DECLSPEC_DRECORD TECClusterCategorie
{
public:
	System::UnicodeString Categorie;
	System::Uitypes::TColor Color;
};


typedef System::DynamicArray<TECClusterCategorie> TECAClusterCategorie;

enum DECLSPEC_DENUM TECCategorieSort : unsigned char { ctsNone, ctsAscending, ctsDescending };

class PASCALIMPLEMENTATION TECClusterManager : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TECAClusterCategorie FCategories;
	System::UnicodeString FHint;
	System::UnicodeString FCategorieKey;
	bool FZoomWhenClicked;
	TECShapes* FGroup;
	TClusterStyle FClusterStyle;
	int FCategorieFontSize;
	System::UnicodeString FSCategorieFontSize;
	TECCategorieSort FCategorieSort;
	System::Classes::TStringList* FCacheGraphicCategorie;
	System::Uitypes::TColor FTextColor;
	System::Uitypes::TColor FBorderColor;
	System::Uitypes::TColor FCOlor;
	bool FProportional;
	bool FFillClusterList;
	int FMaxCount;
	int FMaxPixelDistance;
	int FWidthHeight;
	int FFontSize;
	int FBorderSize;
	int FMinWidthHeight;
	System::Byte FMinZoom;
	System::Byte FMaxZoom;
	System::Byte FOpacity;
	bool FDrawWhenMoving;
	TECCluster* FHoverCluster;
	bool FClickable;
	System::Classes::TNotifyEvent FOnUpdate;
	TOnAddShapeToCluster FOnAddShapeToCluster;
	TOnDrawCluster FOnDrawCluster;
	TOnClusterGetText FOnClusterGetText;
	TOnNotifyEventCluster FOnMouseOverCluster;
	TOnNotifyEventCluster FOnMouseOutCluster;
	TOnColorSizeCluster FOnColorSizeCluster;
	void __fastcall setCategorieSort(const TECCategorieSort value);
	void __fastcall setTextColor(const System::Uitypes::TColor value);
	void __fastcall setBorderColor(const System::Uitypes::TColor value);
	void __fastcall setColor(const System::Uitypes::TColor value);
	void __fastcall setMaxPixelDistance(const int value);
	void __fastcall setBorderSize(const int value);
	void __fastcall setWidthHeight(const int value);
	void __fastcall setMinWidthHeight(const int value);
	void __fastcall setFontSize(const int value);
	void __fastcall setProportional(const bool value);
	void __fastcall setOpacity(const System::Byte value);
	void __fastcall setMaxZoom(const System::Byte value);
	void __fastcall setMinZoom(const System::Byte value);
	void __fastcall setHoverCluster(TECCluster* const value);
	void __fastcall setClusterStyle(const TClusterStyle value);
	void __fastcall setCategorieFontSize(const int value);
	void __fastcall ClearCacheGraphicCategorie();
	Vcl::Graphics::TGraphic* __fastcall getGraphicCategorie(const int Size, const Uecmaputil::TECAGraphInfo &graph);
	
public:
	__fastcall TECClusterManager(TECShapes* Parent);
	__fastcall virtual ~TECClusterManager();
	int __fastcall AddCategorie(const System::UnicodeString Categorie, System::Uitypes::TColor Color);
	void __fastcall DeleteCategorie(const System::UnicodeString Categorie)/* overload */;
	void __fastcall DeleteCategorie(const int indexCategorie)/* overload */;
	void __fastcall ClearCategorie();
	__property TECAClusterCategorie Categories = {read=FCategories};
	__property System::Uitypes::TColor Color = {read=FCOlor, write=setColor, nodefault};
	__property int CategorieFontSize = {read=FCategorieFontSize, write=setCategorieFontSize, nodefault};
	__property TECCategorieSort CategorieSort = {read=FCategorieSort, write=setCategorieSort, nodefault};
	__property System::UnicodeString Hint = {read=FHint, write=FHint};
	__property System::UnicodeString CategorieKey = {read=FCategorieKey, write=FCategorieKey};
	__property TClusterStyle Style = {read=FClusterStyle, write=setClusterStyle, nodefault};
	__property System::Uitypes::TColor TextColor = {read=FTextColor, write=setTextColor, nodefault};
	__property System::Uitypes::TColor BorderColor = {read=FBorderColor, write=setBorderColor, nodefault};
	__property int BorderSize = {read=FBorderSize, write=setBorderSize, nodefault};
	__property int FontSize = {read=FFontSize, write=setFontSize, nodefault};
	__property bool FillClusterList = {read=FFillClusterList, write=FFillClusterList, nodefault};
	__property int MaxPixelDistance = {read=FMaxPixelDistance, write=setMaxPixelDistance, nodefault};
	__property bool DrawWhenMoving = {read=FDrawWhenMoving, write=FDrawWhenMoving, nodefault};
	__property System::Byte Opacity = {read=FOpacity, write=setOpacity, nodefault};
	__property System::Byte MaxZoom = {read=FMaxZoom, write=setMaxZoom, nodefault};
	__property System::Byte MinZoom = {read=FMinZoom, write=setMinZoom, nodefault};
	__property int MaxCount = {read=FMaxCount, nodefault};
	__property int WidthHeight = {read=FWidthHeight, write=setWidthHeight, nodefault};
	__property int MinWidthHeight = {read=FMinWidthHeight, write=setMinWidthHeight, nodefault};
	__property TECCluster* HoverCluster = {read=FHoverCluster, write=setHoverCluster};
	__property bool Proportional = {read=FProportional, write=setProportional, nodefault};
	__property bool Clickable = {read=FClickable, write=FClickable, nodefault};
	__property bool ZoomWhenClicked = {read=FZoomWhenClicked, write=FZoomWhenClicked, nodefault};
	__property TOnAddShapeToCluster OnAddShapeToCluster = {read=FOnAddShapeToCluster, write=FOnAddShapeToCluster};
	__property TOnColorSizeCluster OnColorSizeCluster = {read=FOnColorSizeCluster, write=FOnColorSizeCluster};
	__property TOnDrawCluster OnDrawCluster = {read=FOnDrawCluster, write=FOnDrawCluster};
	__property TOnClusterGetText OnClusterGetText = {read=FOnClusterGetText, write=FOnClusterGetText};
	__property TOnNotifyEventCluster OnMouseOverCluster = {read=FOnMouseOverCluster, write=FOnMouseOverCluster};
	__property TOnNotifyEventCluster OnMouseOutCluster = {read=FOnMouseOutCluster, write=FOnMouseOutCluster};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECClusterList : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	bool FOwnsObjects;
	TECCluster* FHead;
	TECCluster* FLast;
	int FCount;
	void __fastcall Add(TECCluster* value);
	void __fastcall Delete(TECCluster* value);
	void __fastcall Clear();
	
public:
	__fastcall TECClusterList();
	__fastcall virtual ~TECClusterList();
	__property TECCluster* Head = {read=FHead};
	__property int Count = {read=FCount, nodefault};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECClusters : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TECClusterList* FECClusterList;
	TECCluster* __fastcall getHead();
	TECCluster* __fastcall getLast();
	int __fastcall getCount();
	
public:
	__property TECCluster* Head = {read=getHead};
	__property TECCluster* Last = {read=getLast};
	__property int Count = {read=getCount, nodefault};
public:
	/* TObject.Create */ inline __fastcall TECClusters() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TECClusters() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECSelectedShapesList : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECShape* operator[](int index) { return this->item[index]; }
	
private:
	TECShapesGroup* FECShapesGroup;
	TECShapesList* FFilterShapes;
	TECShapesList* FSelectedShapes;
	System::Classes::TNotifyEvent FOnchange;
	TOnSelectShape FOnSelectShape;
	System::Classes::TStringList* FGroupFilter;
	double FNELat;
	double FNELng;
	double FSWLat;
	double FSWLng;
	TECShape* __fastcall getShape(int index);
	bool __fastcall Add(TECShape* const value);
	void __fastcall Remove(TECShape* const value);
	System::UnicodeString __fastcall getToCSV();
	System::UnicodeString __fastcall getToTxt();
	System::UnicodeString __fastcall getToKml();
	System::UnicodeString __fastcall getToGeoJSON();
	System::UnicodeString __fastcall getToGpx();
	
public:
	__fastcall TECSelectedShapesList(TECShapesGroup* ShapesGroup);
	__fastcall virtual ~TECSelectedShapesList();
	void __fastcall UnSelectedAll();
	int __fastcall UnSelectedByKeyValue(const System::UnicodeString key, const System::UnicodeString value);
	int __fastcall UnSelectByArea(const double SWALat, const double SWALng, const double NEALat, const double NEALng);
	int __fastcall UnSelectByKMDistance(const double FLat, const double FLng, const double FKMDistance);
	int __fastcall All();
	int __fastcall ByArea(const double NEALat, const double NEALng, const double SWALat, const double SWALng);
	int __fastcall ByKMDistance(const double FLat, const double FLng, const double FKMDistance);
	int __fastcall ByKeyValue(const System::UnicodeString key, const System::UnicodeString value);
	int __fastcall Filter(TOnShapeFilter doFilter, TECShapesList* list)/* overload */;
	int __fastcall Filter(const System::UnicodeString GroupName, TECShapesList* list)/* overload */;
	int __fastcall Filter(TOnShapeFilter doFilter)/* overload */;
	int __fastcall Filter(const System::UnicodeString GroupName)/* overload */;
	void __fastcall Clear();
	int __fastcall Count();
	void __fastcall fitBounds(const System::UnicodeString GroupName = L"*");
	TECSelectedShapesListEnumerator* __fastcall GetEnumerator();
	void __fastcall SaveToFile(const System::UnicodeString filename);
	__property TECShape* item[int index] = {read=getShape/*, default*/};
	__property System::Classes::TStringList* GroupFilter = {read=FGroupFilter};
	__property TECShapesList* FilterList = {read=FFilterShapes};
	__property double NELat = {read=FNELat};
	__property double NELng = {read=FNELng};
	__property double SWLat = {read=FSWLat};
	__property double SWLng = {read=FSWLng};
	__property System::UnicodeString toTxt = {read=getToTxt};
	__property System::UnicodeString ToKml = {read=getToKml};
	__property System::UnicodeString ToGeoJSon = {read=getToGeoJSON};
	__property System::UnicodeString ToGpx = {read=getToGpx};
	__property System::UnicodeString ToCSV = {read=getToCSV};
	__property System::Classes::TNotifyEvent OnChange = {read=FOnchange, write=FOnchange};
	__property TOnSelectShape OnSelectShape = {read=FOnSelectShape, write=FOnSelectShape};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECSelectedShapesListEnumerator : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	int FIndex;
	TECSelectedShapesList* FList;
	
public:
	__fastcall TECSelectedShapesListEnumerator(TECSelectedShapesList* AMyList);
	bool __fastcall MoveNext();
	TECShape* __fastcall GetCurrent();
	__property TECShape* Current = {read=GetCurrent};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECSelectedShapesListEnumerator() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECGroupShapesEnumerator : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	int FIndex;
	Uecmaputil::TThreadStringList* FList;
	
public:
	__fastcall TECGroupShapesEnumerator(Uecmaputil::TThreadStringList* AMyList);
	bool __fastcall MoveNext();
	TECShapes* __fastcall GetCurrent();
	__property TECShapes* Current = {read=GetCurrent};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECGroupShapesEnumerator() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECGroupShapesList : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TECShapes* operator[](int index) { return this->Group[index]; }
	
private:
	Uecmaputil::TThreadStringList* FList;
	TECShapes* __fastcall getShapes(int index);
	
public:
	__fastcall TECGroupShapesList(Uecmaputil::TThreadStringList* list);
	int __fastcall Count();
	TECGroupShapesEnumerator* __fastcall GetEnumerator();
	__property TECShapes* Group[int index] = {read=getShapes/*, default*/};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECGroupShapesList() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TThreadWeatherRoute : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	Uecopenweather::TECOpenWeather* FWeather;
	TECShapes* FWeatherGroup;
	TECShapeLine* FLine;
	TECShapePolygone* FPoly;
	double FKMDistance;
	int FDateTimeIndex;
	void __fastcall doWeatherOnLine();
	void __fastcall doWeatherInPolygone();
	
public:
	__fastcall TThreadWeatherRoute(Uecopenweather::TECOpenWeather* Weather, TECShapes* WeatherGroup, TECShapeLine* Line, double KmDistance, int DateTimeIndex);
	virtual void __fastcall Execute();
	__fastcall virtual ~TThreadWeatherRoute();
};


typedef void __fastcall (*TOnFilterRStarTree)(TECShape* sender, bool &ValidFilter);

class PASCALIMPLEMENTATION TRStarTree : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Uecrstar_tree::TRtree* FTree;
	Uecrstar_tree::TRStarTreeList* FFindList;
	TOnFilterRStarTree FFilter;
	double FSWLat;
	double FSWLng;
	double FNELat;
	double FNELng;
	TECShape* __fastcall getShape(const int index);
	void __fastcall doFilter(Uecrstar_tree::TObjTree* sender, bool &ValidFilter);
	void __fastcall setFilter(TOnFilterRStarTree value);
	
public:
	__fastcall TRStarTree();
	__fastcall virtual ~TRStarTree();
	void __fastcall Clear();
	void __fastcall AddGroup(TECShapes* const value);
	void __fastcall AddShape(TECShape* const value);
	int __fastcall FindByArea(const double SWLat, const double SWLng, const double NELat, const double NELng, Uecrstar_tree::TRStarTreeList* const ShapeList = (System::Generics::Collections::TList__1<System::TObject*>*)(0x0));
	int __fastcall FindCount();
	void __fastcall FindClear();
	__property TECShape* FindShapes[const int index] = {read=getShape};
	__property TOnFilterRStarTree FindFilter = {read=FFilter, write=setFilter};
	__property double SWLat = {read=FSWLat};
	__property double SWLng = {read=FSWLng};
	__property double NELat = {read=FNELat};
	__property double NELng = {read=FNELng};
};


typedef void __fastcall (*TECRoutingAddressUrlBuilder)(const System::UnicodeString StartAdress, const System::UnicodeString EndAdress, const Uecmaputil::TMQRouteType RouteType, const System::UnicodeString Locale, const System::UnicodeString params, System::UnicodeString &Url);

typedef void __fastcall (*TECRoutingLatLngUrlBuilder)(const double *LatLngs, const System::NativeInt LatLngs_High, const int DecimalPrecision, const System::UnicodeString SFrom, const System::UnicodeString STo, const Uecmaputil::TMQRouteType RouteType, const System::UnicodeString Locale, const System::UnicodeString params, System::UnicodeString &Url);

typedef void __fastcall (*TECRoutingRun)(Uecgeolocalise::TECThreadDataRoute* const dataroute);

class PASCALIMPLEMENTATION TThreadECDirection : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	Uecgeolocalise::TECThreadDataRoute* FDataRoute;
	System::Classes::TStringStream* FStringStream;
	
public:
	__fastcall TThreadECDirection(Uecgeolocalise::TECThreadDataRoute* value);
	virtual void __fastcall Execute();
	__fastcall virtual ~TThreadECDirection();
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECShapeKMLStyle : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	bool isColor;
	System::UnicodeString Data;
public:
	/* TObject.Create */ inline __fastcall TECShapeKMLStyle() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TECShapeKMLStyle() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECShapesGroup : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	bool FShapesReady;
	unsigned FStartDraw;
	System::Classes::TNotifyEvent FOnChangeEditable;
	bool FExitEditableClickLastPointLine;
	System::UnicodeString FDefaultHintProperty;
	bool FisUpdateStyles;
	int FPPI;
	int FMarginHint;
	bool FNoRotateInfoWindow;
	System::Classes::TStringList* FKMLStyles;
	Uecmaputil::TECFilterColor* FBaseMapColorsFilter;
	bool FDontScaleToZoomIfSelected;
	TECShapeLine* FEditShadowLine;
	TECShape* FEditShape;
	System::TObject* FOSMFile;
	bool FFlagDestroy;
	bool FWaitingForDestruction;
	bool FForceBounds;
	bool FOnlyOneOpenInfoWindow;
	TECShapeInfoWindow* FLastOpenInfoWindow;
	Uecopenweather::TECOpenWeather* FECOpenWeather;
	Uecmapzip::TECMapZip* FMapZip;
	TOnGetScale FOnGetScale;
	bool FisOffScreen;
	int FMovingDrawPolygon;
	TECRoutingAddressUrlBuilder FAddressUrlBuilder;
	TECRoutingLatLngUrlBuilder FLatLngUrlBuilder;
	TECRoutingRun FRoutingRun;
	Uecgeolocalise::TECThreadRoutingUrl FOnRoutingUrl;
	Uecgeolocalise::TECThreadRoutingUrl FOnValidRoutingUrl;
	Uecgeolocalise::TECThreadRoutingDownload FOnRoutingDownload;
	Uecgeolocalise::TECThreadRoutingExecute FOnRoutingExecute;
	TECCartoStyles* FStyles;
	bool FOnlyLocal;
	TECShapesGroup* FMasterGroup;
	TECShapes* FMasterShapes;
	TECCMasterShapeList* FMasterFakeShapeList;
	TECShapesList* FMasterShapeList;
	Winapi::Windows::TRTLCriticalSection FCritSect;
	TECSelectedShapesList* FSelectedShapesList;
	TOnAddShapeToView FOnAddShapeToView;
	Uecmaputil::TThreadStringList* FList;
	TECGroupShapesList* FGroupList;
	TOnCreateJSONPoint FOnCreateJSONPoint;
	TEditShapePOI* FEditShapePOI;
	Vcl::Graphics::TBitmap* FTemporyBitmap;
	Uecgraphics::TECCanvas* FECCanvas;
	__int64 FLastTrafficSearch;
	System::UnicodeString FFilenameStartEditLine;
	System::UnicodeString FFilenameEndEditLine;
	System::UnicodeString FFilenamePointEditLine;
	System::UnicodeString FLocale;
	int FMaxShapesToDraw;
	bool FDrawVectorTiles;
	bool FChanged;
	bool FStateUseD2Canvas;
	bool FUseGDICanvasWhenMove;
	bool FIsMoving;
	bool FisLoading;
	Uecthreadgraphics::TThreadGraphicPool* FGraphicPool;
	Uecgeolocalise::TECGeoLocalise* FGeoLocalise;
	System::Classes::TNotifyEvent FOnShapeAutoHide;
	System::Classes::TNotifyEvent FOnShapeAutoShow;
	System::Classes::TNotifyEvent FOnCloseInfoWindow;
	TECShapesList* FShapesFirstDraw;
	int FBeginUpdate;
	System::Generics::Collections::TList__1<TECShapes*>* FZIndexShapes;
	System::Generics::Collections::TList__1<TECShapes*>* FRecycleShapes;
	System::Generics::Collections::TList__1<TECNativeRoutePath*>* FECRoutePathList;
	System::Classes::TStringList* FASyncAdress;
	Uecmaputil::TThreadStringList* FBitmapsCache;
	Uecmaputil::TThreadStringList* FASyncWaitingRoutes;
	bool FTrafficLayer;
	bool FFindingRoute;
	bool FFindingAddress;
	Vcl::Imglist::TCustomImageList* FIcons;
	Vcl::Controls::TWinControl* FParent;
	Uecmaputil::TECWorldInfo* FWorld;
	System::Classes::TNotifyEvent FOnShapePathChange;
	System::Classes::TNotifyEvent FonTraffic;
	System::Classes::TNotifyEvent FEvent;
	System::Classes::TNotifyEvent FOnLoad;
	TOnShapeMove FOnMove;
	__int64 FTickTimeStyles;
	Uecthreadgraphics::TThreadRest* FThreadRest;
	TCSlopeColors* FSlopeColors;
	System::Classes::TList* FToolTipsList;
	TECShape* FHintBringToFront;
	TECShape* FtoolTipsBringToFront;
	TECShape* FShapeBringToFront;
	TECShape* FShapeHover;
	TECShape* FShapeDrag;
	TECCluster* FClusterHover;
	bool FUpdateStylesZoom;
	bool FStopAnim;
	bool FScreenComplete;
	bool isTraffic;
	bool FCancelLoad;
	bool FSerializeGroup;
	bool FInUpdateStyles;
	bool FInDraw;
	bool FMapSaveEncodedPolyline;
	bool FMapDraggable;
	int FDrawCount;
	TOnRoutePath FOnRoutePath;
	TOnLoadShapes FOnLoadShapes;
	TOnHotSpot FOnHotSpot;
	TOnNotify FOnNotify;
	System::Classes::TNotifyEvent FOnRepaint;
	System::Classes::TNotifyEvent FOnChangeFilterColors;
	System::Classes::TNotifyEvent FOnChangeTileServer;
	TECShapes* FHintShapes;
	System::Classes::TNotifyEvent FOnOSMLoaded;
	bool FFreeHand;
	bool FStopDraw;
	bool FIsMaster;
	System::UnicodeString FBaseDir;
	TECShapes* FPrivateServiceGroup;
	System::UnicodeString FRoutingEngineKey;
	System::UnicodeString FRoutingEngineName;
	void __fastcall setIsMoving(const bool value);
	void __fastcall setEditShape(TECShape* const value);
	void __fastcall doOnDirectionsRequest(System::TObject* sender);
	void __fastcall doGetGraphic(System::TObject* sender);
	void __fastcall Repaint(const bool Ready = false);
	void __fastcall setShapeHover(TECShape* value);
	void __fastcall setShapeDrag(TECShape* value);
	void __fastcall setShapeBringToFront(TECShape* value);
	System::UnicodeString __fastcall getToTxt();
	void __fastcall setTotxt(const System::UnicodeString value);
	System::UnicodeString __fastcall getToGpx();
	void __fastcall setToGpx(const System::UnicodeString value);
	System::UnicodeString __fastcall getToGeoJSON();
	void __fastcall setToGeoJSon(const System::UnicodeString value);
	System::UnicodeString __fastcall getToWKT();
	void __fastcall setToWKT(const System::UnicodeString value);
	void __fastcall clearKMLStyles();
	System::UnicodeString __fastcall getStyleKML(const System::Uitypes::TColor AColor, const System::Byte AOpacity)/* overload */;
	System::UnicodeString __fastcall getStyleKML(const System::UnicodeString AValue)/* overload */;
	System::UnicodeString __fastcall getToKml();
	void __fastcall setToKml(const System::UnicodeString value);
	void __fastcall setTrafficLayer(const bool value);
	System::UnicodeString __fastcall getLocale();
	void __fastcall CreateHintWindow();
	TECShapeInfoWindow* __fastcall getHintWindow();
	int __fastcall getTileSize();
	void __fastcall setTileSize(const int value);
	void __fastcall setPause(const bool value);
	bool __fastcall getPause();
	void __fastcall getDrawHTMLGraphic(const System::UnicodeString filename, Vcl::Graphics::TGraphic* &gfx, const int X, const int Y, int &w, int &h);
	void __fastcall doWeatherShapeClick(System::TObject* sender, TECShape* const item);
	void __fastcall doOnOSMLoaded(System::TObject* sender);
	void __fastcall doOnChangeFilterColors(System::TObject* sender);
	
public:
	__fastcall TECShapesGroup(Uecgraphics::TECCanvas* canvas, Vcl::Controls::TWinControl* _Parent, Uecmaputil::TECWorldInfo* const dWorld, System::Classes::TNotifyEvent EvtUpdate, System::Classes::TNotifyEvent EvtLoad, TOnShapeMove EvtMove);
	__fastcall virtual ~TECShapesGroup();
	void __fastcall RemoveGraphic(const System::UnicodeString filename);
	bool __fastcall isValidGraphic(const System::UnicodeString filename);
	void __fastcall setMQRoutingEngine();
	void __fastcall setMapZenRoutingEngine();
	void __fastcall setOSRMRoutingEngine();
	void __fastcall setOpenStreetMapRoutingEngine();
	void __fastcall setMapBoxRoutingEngine();
	void __fastcall setTomTomRoutingEngine();
	void __fastcall setPTVRoutingEngine();
	void __fastcall setHereRoutingEngine();
	void __fastcall setCustomRoutingEngine();
	void __fastcall ClearFirstDraw();
	void __fastcall Invalidate();
	void __fastcall TileServerChanged(System::TObject* sender);
	void __fastcall Lock();
	void __fastcall UnLock();
	void __fastcall reload();
	void __fastcall ShowHintAtPos(const double Lat, const double Lng, const System::UnicodeString Hint, const unsigned DelayHint = (unsigned)(0x7d0), TECShapes* const Group = (TECShapes*)(0x0), const int YAnchor = 0xffffe19f);
	void __fastcall HideHint();
	int __fastcall FindByArea(TECShapesGroup* const sender, const double SWALat, const double SWALng, const double NEALat, const double NEALng, System::Generics::Collections::TList__1<TECShape*>* const ShapeList, const TNativeShapes FilterShapes = TNativeShapes() , TOnShapeFilter Filter = 0x0);
	int __fastcall FindByKMDistance(const double FLat, const double FLng, const double FKMDistance, System::Generics::Collections::TList__1<TECShape*>* const ShapeList, const TNativeShapes FilterShapes = TNativeShapes() , TOnShapeFilter Filter = 0x0);
	int __fastcall SelectByArea(const double SWALat, const double SWALng, const double NEALat, const double NEALng);
	int __fastcall SelectByKMDistance(const double FLat, const double FLng, const double FKMDistance);
	int __fastcall SelectAll();
	int __fastcall UnSelectByArea(const double SWALat, const double SWALng, const double NEALat, const double NEALng);
	int __fastcall UnSelectByKMDistance(const double FLat, const double FLng, const double FKMDistance);
	int __fastcall UnSelectByKeyValue(const System::UnicodeString key, const System::UnicodeString value);
	int __fastcall FindByKeyValue(const System::UnicodeString key, const System::UnicodeString value, System::Generics::Collections::TList__1<TECShape*>* const ShapeList)/* overload */;
	int __fastcall FindByKeyValue(TECShapes* const Group, const System::UnicodeString key, const System::UnicodeString value, System::Generics::Collections::TList__1<TECShape*>* const ShapeList)/* overload */;
	int __fastcall SelectByKeyValue(const System::UnicodeString key, const System::UnicodeString value);
	void __fastcall doTraffic(System::TObject* sender, const System::UnicodeString value);
	__int64 __fastcall ASyncLoad(const System::UnicodeString Url, const System::Classes::TNotifyEvent Notify, System::TObject* const TagObject = (System::TObject*)(0x0))/* overload */;
	__int64 __fastcall ASyncLoad(const System::UnicodeString Url, const System::Classes::TNotifyEvent Notify, const System::Classes::TNotifyEvent Execute, System::TObject* const TagObject = (System::TObject*)(0x0))/* overload */;
	bool __fastcall HandledCLick(TECShape* sender, const int _x, const int _y);
	bool __fastcall AnimationShapes();
	int __fastcall AnimationShapesCount();
	TECShape* __fastcall Add(const TNativeShape Shape, const double Lat, const double Lng, const System::UnicodeString GroupName = System::UnicodeString())/* overload */;
	void __fastcall Remove(TECShape* const Shape);
	void __fastcall MapEndMove();
	void __fastcall ZoomChanged();
	void __fastcall UpdateView();
	void __fastcall PreLoadGraphic(const System::UnicodeString filename);
	Vcl::Graphics::TGraphic* __fastcall getGraphic(const System::UnicodeString filename);
	void __fastcall setGraphic(const System::UnicodeString filename, Vcl::Graphics::TGraphic* Graphic);
	TECShapeLine* __fastcall AddRoute(Uecgeolocalise::TECRoutePath* const routePath, const System::UnicodeString GroupName = System::UnicodeString());
	void __fastcall RoutingRequest(const System::UnicodeString StartAdress, const System::UnicodeString EndAdress, const Uecmaputil::TMQRouteType RouteType, const int RouteDrawingTime = 0x0, TECShapeLine* Line = (TECShapeLine*)(0x0), const System::UnicodeString params = System::UnicodeString(), const System::UnicodeString GroupName = System::UnicodeString(), const bool Asynchronous = true)/* overload */;
	void __fastcall RoutingRequest(const double *dLatLngs, const System::NativeInt dLatLngs_High, const Uecmaputil::TMQRouteType RouteType, const int RouteDrawingTime = 0x0, TECShapeLine* Line = (TECShapeLine*)(0x0), const System::UnicodeString params = System::UnicodeString(), const System::UnicodeString GroupName = System::UnicodeString(), const bool Asynchronous = true)/* overload */;
	void __fastcall ClearPendingRoutingRequests();
	int __fastcall PendingRoutingRequests();
	bool __fastcall AlignLatLngToRoute(double &dLatitude, double &dLongitude);
	bool __fastcall isBeginUpdate();
	void __fastcall BeginUpdate();
	void __fastcall EndUpdate();
	void __fastcall DecEndUpdate();
	void __fastcall UpdateZIndexShapes();
	System::LongInt __fastcall TopZindex();
	bool __fastcall isLoading();
	void __fastcall SaveToFile(const System::UnicodeString filename);
	bool __fastcall LoadFromFile(const System::UnicodeString filename);
	void __fastcall Clear();
	TECCluster* __fastcall HoverCluster(const int iX, const int iY);
	TECShape* __fastcall ShapeByHover(const int iX, const int iY);
	void __fastcall getBounds();
	void __fastcall ShapesToDraw();
	void __fastcall Draw();
	void __fastcall UpdateStyles();
	void __fastcall ClearNoOnMapVectorTiles();
	void __fastcall FreeTempCache();
	void __fastcall UpdateBounds();
	int __fastcall Count();
	void __fastcall InvalideAll();
	bool __fastcall Ready();
	bool __fastcall isExistsShapes(const System::UnicodeString Name);
	TECShapes* __fastcall getShapes(const System::UnicodeString Name);
	void __fastcall RemoveShapes(TECShapes* const value);
	TECShapes* __fastcall GetPrivateServiceGroup();
	void __fastcall AbortOSM();
	bool __fastcall LoadFromOSMFile(const System::UnicodeString filename, TECShapes* const Group);
	bool __fastcall LoadFromOSMStream(System::Classes::TStream* const Stream, TECShapes* const Group);
	bool __fastcall LoadFromOSMString(const System::UnicodeString Data, TECShapes* const Group);
	__property Uecmaputil::TECFilterColor* BaseMapColorsFilter = {read=FBaseMapColorsFilter};
	__property bool ShapesReady = {read=FShapesReady, write=FShapesReady, nodefault};
	__property bool Changed = {read=FChanged, nodefault};
	__property int MarginHint = {read=FMarginHint, write=FMarginHint, nodefault};
	__property int PPI = {read=FPPI, write=FPPI, nodefault};
	__property bool ForceBounds = {read=FForceBounds, write=FForceBounds, nodefault};
	__property bool isOffScreen = {read=FisOffScreen, write=FisOffScreen, nodefault};
	__property bool FlagDestroy = {read=FFlagDestroy, write=FFlagDestroy, nodefault};
	__property bool WaitingForDestruction = {read=FWaitingForDestruction, write=FWaitingForDestruction, nodefault};
	__property Vcl::Imglist::TCustomImageList* Icons = {read=FIcons, write=FIcons};
	__property System::UnicodeString BaseDir = {read=FBaseDir, write=FBaseDir};
	__property bool NoRotateInfoWindow = {read=FNoRotateInfoWindow, write=FNoRotateInfoWindow, nodefault};
	__property TECCartoStyles* Styles = {read=FStyles};
	__property System::UnicodeString DefaultHintProperty = {read=FDefaultHintProperty, write=FDefaultHintProperty};
	__property System::Classes::TNotifyEvent OnRePaint = {read=FOnRepaint, write=FOnRepaint};
	__property System::Classes::TNotifyEvent OnChangeTileServer = {read=FOnChangeTileServer, write=FOnChangeTileServer};
	__property System::Classes::TNotifyEvent OnChangeFilterColors = {read=FOnChangeFilterColors, write=FOnChangeFilterColors};
	__property TECGroupShapesList* GroupList = {read=FGroupList};
	__property TECShapesGroup* MasterGroup = {read=FMasterGroup, write=FMasterGroup};
	__property TECShapes* MasterShapes = {read=FMasterShapes, write=FMasterShapes};
	__property bool isMaster = {read=FIsMaster, write=FIsMaster, nodefault};
	__property bool isUpdateStyles = {read=FisUpdateStyles, nodefault};
	__property bool InDraw = {read=FInDraw, write=FInDraw, nodefault};
	__property Uecmapzip::TECMapZip* MapZip = {read=FMapZip, write=FMapZip};
	__property TECShapes* HintShapes = {read=FHintShapes};
	__property bool OnlyOneOpenInfoWindow = {read=FOnlyOneOpenInfoWindow, write=FOnlyOneOpenInfoWindow, nodefault};
	__property bool TrafficLayer = {read=FTrafficLayer, write=setTrafficLayer, nodefault};
	__property int TileSize = {read=getTileSize, write=setTileSize, nodefault};
	__property Uecthreadgraphics::TThreadGraphicPool* GraphicPool = {read=FGraphicPool, write=FGraphicPool};
	__property bool UpdateStylesZoom = {read=FUpdateStylesZoom, write=FUpdateStylesZoom, nodefault};
	__property bool StopDraw = {read=FStopDraw, write=FStopDraw, nodefault};
	__property bool FreeHand = {read=FFreeHand, write=FFreeHand, nodefault};
	__property TECShape* ShapeHover = {read=FShapeHover, write=setShapeHover};
	__property TECShape* ShapeDrag = {read=FShapeDrag, write=setShapeDrag};
	__property TECCluster* ClusterHover = {read=FClusterHover, write=FClusterHover};
	__property TECShape* ShapeBringToFront = {read=FShapeBringToFront, write=setShapeBringToFront};
	__property System::UnicodeString toTxt = {read=getToTxt, write=setTotxt};
	__property System::UnicodeString ToGpx = {read=getToGpx, write=setToGpx};
	__property System::UnicodeString ToKml = {read=getToKml, write=setToKml};
	__property System::UnicodeString ToWKT = {read=getToWKT, write=setToWKT};
	__property System::UnicodeString ToGeoJSon = {read=getToGeoJSON, write=setToGeoJSon};
	__property bool MapSaveEncodedPolyline = {read=FMapSaveEncodedPolyline, write=FMapSaveEncodedPolyline, nodefault};
	__property bool MapDraggable = {read=FMapDraggable, write=FMapDraggable, nodefault};
	__property System::UnicodeString Locale = {read=getLocale, write=FLocale};
	__property Uecopenweather::TECOpenWeather* OpenWeather = {read=FECOpenWeather};
	__property bool OnlyLocal = {read=FOnlyLocal, write=FOnlyLocal, nodefault};
	__property bool DrawVectorTiles = {read=FDrawVectorTiles, write=FDrawVectorTiles, nodefault};
	__property bool ExitEditableClickLastPointLine = {read=FExitEditableClickLastPointLine, write=FExitEditableClickLastPointLine, nodefault};
	__property System::UnicodeString FilenameStartEditLine = {read=FFilenameStartEditLine, write=FFilenameStartEditLine};
	__property System::UnicodeString FilenameEndEditLine = {read=FFilenameEndEditLine, write=FFilenameEndEditLine};
	__property System::UnicodeString FilenamePointEditLine = {read=FFilenamePointEditLine, write=FFilenamePointEditLine};
	__property bool UseGDICanvasWhenMove = {read=FUseGDICanvasWhenMove, write=FUseGDICanvasWhenMove, nodefault};
	__property bool DontScaleToZoomIfSelected = {read=FDontScaleToZoomIfSelected, write=FDontScaleToZoomIfSelected, nodefault};
	__property bool Pause = {read=getPause, write=setPause, nodefault};
	__property TCSlopeColors* SlopeColors = {read=FSlopeColors};
	__property System::Classes::TNotifyEvent OnTraffic = {read=FonTraffic, write=FonTraffic};
	__property Uecgeolocalise::TECGeoLocalise* GeoLocalise = {read=FGeoLocalise, write=FGeoLocalise};
	__property bool isFindingRoute = {read=FFindingRoute, nodefault};
	__property TOnRoutePath OnRoutePath = {read=FOnRoutePath, write=FOnRoutePath};
	__property System::Classes::TNotifyEvent OnShapePathChange = {read=FOnShapePathChange, write=FOnShapePathChange};
	__property TOnCreateJSONPoint OnCreateJSONPoint = {read=FOnCreateJSONPoint, write=FOnCreateJSONPoint};
	__property TOnAddShapeToView OnAddShapeToView = {read=FOnAddShapeToView, write=FOnAddShapeToView};
	__property System::Classes::TNotifyEvent OnCloseInfoWindow = {read=FOnCloseInfoWindow, write=FOnCloseInfoWindow};
	__property System::Classes::TNotifyEvent OnShapeAutoHide = {read=FOnShapeAutoHide, write=FOnShapeAutoHide};
	__property System::Classes::TNotifyEvent OnShapeAutoShow = {read=FOnShapeAutoShow, write=FOnShapeAutoShow};
	__property System::Classes::TNotifyEvent OnChangeEditable = {read=FOnChangeEditable, write=FOnChangeEditable};
	__property TOnHotSpot OnHotSpot = {read=FOnHotSpot, write=FOnHotSpot};
	__property TOnLoadShapes OnLoadShapes = {read=FOnLoadShapes, write=FOnLoadShapes};
	__property TOnGetScale OnGetScale = {read=FOnGetScale, write=FOnGetScale};
	__property TOnNotify OnNotify = {read=FOnNotify, write=FOnNotify};
	__property Vcl::Controls::TWinControl* Parent = {read=FParent, write=FParent};
	__property int DrawCount = {read=FDrawCount, nodefault};
	__property bool isMoving = {read=FIsMoving, write=setIsMoving, nodefault};
	__property TECSelectedShapesList* SelectedShapes = {read=FSelectedShapesList};
	__property int MAxShapesToDraw = {read=FMaxShapesToDraw, write=FMaxShapesToDraw, nodefault};
	__property Uecmaputil::TECWorldInfo* World = {read=FWorld};
	__property System::Classes::TNotifyEvent OnOSMLoaded = {read=FOnOSMLoaded, write=FOnOSMLoaded};
	__property bool ScreenComplete = {read=FScreenComplete, write=FScreenComplete, nodefault};
	__property Uecgeolocalise::TECThreadRoutingUrl RoutingEngineUrl = {read=FOnRoutingUrl, write=FOnRoutingUrl};
	__property Uecgeolocalise::TECThreadRoutingUrl RoutingEngineValidUrl = {read=FOnValidRoutingUrl, write=FOnValidRoutingUrl};
	__property Uecgeolocalise::TECThreadRoutingDownload RoutingEngineDownload = {read=FOnRoutingDownload, write=FOnRoutingDownload};
	__property Uecgeolocalise::TECThreadRoutingExecute RoutingEngineExecute = {read=FOnRoutingExecute, write=FOnRoutingExecute};
	__property System::UnicodeString RoutingEngineKey = {read=FRoutingEngineKey, write=FRoutingEngineKey};
	__property System::UnicodeString RoutingEngineName = {read=FRoutingEngineName, write=FRoutingEngineName};
	__property TECShapeLine* EditShadowLine = {read=FEditShadowLine, write=FEditShadowLine};
	__property TECShape* EditShape = {read=FEditShape, write=setEditShape};
};


class PASCALIMPLEMENTATION TThreadShapeList : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	TECShapes* FShapes;
	System::Classes::TNotifyEvent FEvent;
	System::UnicodeString FTxt;
	
public:
	__fastcall TThreadShapeList(bool ACreateSuspended, TECShapes* Shapes, const System::UnicodeString txt, System::Classes::TNotifyEvent Event);
	__fastcall virtual ~TThreadShapeList();
	virtual void __fastcall Execute();
};


class PASCALIMPLEMENTATION TThreadShapesKml : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	TECShapes* FShapes;
	System::UnicodeString FBaseDir;
	System::UnicodeString FTxt;
	
public:
	__fastcall TThreadShapesKml(bool ACreateSuspended, TECShapes* Shapes, const System::UnicodeString txt, const System::UnicodeString BaseDir);
	__fastcall virtual ~TThreadShapesKml();
	virtual void __fastcall Execute();
};


class PASCALIMPLEMENTATION TThreadShapesWKT : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	TECShapes* FShapes;
	System::UnicodeString FTxt;
	Uecmaputil::TThreadStringList* FData;
	Uecwktparser::TWKTParser* FWKTParser;
	bool FAbort;
	void __fastcall doToTxt();
	void __fastcall addPolygon(Uecwktobjects::TWKTGeometry* LGeometry);
	void __fastcall AddLine(Uecwktobjects::TWKTGeometry* LGeometry);
	void __fastcall AddMPoint(Uecwktobjects::TWKTGeometry* LGeometry);
	void __fastcall AddMPolygon(Uecwktobjects::TWKTGeometry* LGeometry);
	void __fastcall AddMLine(Uecwktobjects::TWKTGeometry* LGeometry);
	void __fastcall AddCollection(Uecwktobjects::TWKTGeometry* LGeometry);
	
public:
	__fastcall TThreadShapesWKT(bool ACreateSuspended, TECShapes* Shapes, const System::UnicodeString txt);
	void __fastcall Add(const System::UnicodeString value);
	void __fastcall Abort();
	__fastcall virtual ~TThreadShapesWKT();
	virtual void __fastcall Execute();
};


class PASCALIMPLEMENTATION TThreadShapesgeoJson : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	TECShapes* FShapes;
	System::UnicodeString FTxt;
	System::Classes::TStream* FStream;
	Uecmaputil::TThreadStringList* FData;
	bool FAbort;
	void __fastcall doToTxt();
	
public:
	__fastcall TThreadShapesgeoJson(bool ACreateSuspended, TECShapes* Shapes, const System::UnicodeString txt, System::Classes::TStream* Stream);
	void __fastcall Add(const System::UnicodeString value);
	void __fastcall Abort();
	__fastcall virtual ~TThreadShapesgeoJson();
	virtual void __fastcall Execute();
};


class PASCALIMPLEMENTATION TThreadShapesGPX : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	TECShapes* FShapes;
	System::UnicodeString FTxt;
	void __fastcall doToTxt();
	
public:
	__fastcall TThreadShapesGPX(bool ACreateSuspended, TECShapes* Shapes, const System::UnicodeString txt);
	virtual void __fastcall Execute();
public:
	/* TThread.Destroy */ inline __fastcall virtual ~TThreadShapesGPX() { }
	
};


class PASCALIMPLEMENTATION TThreadShapesTXT : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	TECShapes* FShapes;
	System::UnicodeString FTxt;
	void __fastcall doToTxt();
	
public:
	__fastcall TThreadShapesTXT(bool ACreateSuspended, TECShapes* Shapes, const System::UnicodeString txt);
	virtual void __fastcall Execute();
public:
	/* TThread.Destroy */ inline __fastcall virtual ~TThreadShapesTXT() { }
	
};


typedef void __fastcall (*TOnLoadText)(TECShapes* sender);

class PASCALIMPLEMENTATION TECShapes : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::UnicodeString operator[](const System::UnicodeString index) { return this->PropertyValue[index]; }
	
private:
	bool FDefaultOsmStyles;
	bool FIsEditable;
	TPropertyValue* FPropertyValue;
	TecCSV* FCSV;
	int FClustersCount;
	int FShapesInClustersCount;
	System::Classes::TNotifyEvent FOnClusterChange;
	bool FOnLoadShapes;
	bool FUseGraphicDirectory;
	TOnLoadText FOnLoadText;
	PtrInt FTag;
	System::TObject* FData;
	bool FDefaultRotationShape;
	bool FDefaultVisibilityShape;
	bool FMarkedForRemove;
	bool FRemoveIfZoomOut;
	TGeoJSONGeometryParser* FGeoJSONGeometryParser;
	TThreadShapesgeoJson* FThreadShapesgeoJson;
	TThreadShapesWKT* FThreadShapesWKT;
	System::UnicodeString FHint;
	System::UnicodeString FBaseDir;
	Vcl::Imglist::TCustomImageList* FIcons;
	Winapi::Windows::TRTLCriticalSection CritSect;
	Uecmaputil::TThreadStringList* FToTxtThreads;
	TECShapesGroup* FOwner;
	Vcl::Controls::TWinControl* FParent;
	TECClusterList* FClusters;
	TECClusterManager* FClusterManager;
	TECClusters* FECClusters;
	System::UnicodeString FName;
	int FHintOffsetY;
	bool FDontScaleToZoom;
	bool FHintColorShape;
	bool FHintCenter;
	System::Uitypes::TColor FHintColor;
	TECShapeInfoWindowList* FInfoWindows;
	TECShapePOIList* FPois;
	TECShapeMarkerList* FMarkers;
	TECShapeLineList* FLines;
	TECShapePolygoneList* FPolys;
	System::LongInt FZindex;
	System::Byte FMinZoom;
	System::Byte FMaxZoom;
	TECShapesList* FShapesAnim;
	TECShapesList* FShapesDraw;
	Uecmaputil::TECWorldInfo* FWorld;
	bool FShow;
	bool FForceDraw;
	bool FIsMoving;
	bool FModified;
	bool InDraw;
	bool FSerialize;
	bool FClickable;
	bool FVisible;
	bool FisLoading;
	TOnShapeLocation FOnShapeLocation;
	System::Classes::TNotifyEvent FOnShapeOverIntent;
	TOnShapeMove FOnMove;
	System::Classes::TNotifyEvent FOnLoad;
	System::Classes::TNotifyEvent FOnUpdate;
	System::Classes::TNotifyEvent FOnchange;
	bool FcheckAllStyles;
	bool FShowHint;
	bool FFocusable;
	bool FBubblingClick;
	int FHintFontSize;
	int FHintMinHeight;
	int FHintMinWidth;
	int FStartIndexUpdateStyles;
	int FBeginUpdate;
	TECShape* FShapeDrag;
	TECShape* FShapeHover;
	double FlatSW;
	double FlngSW;
	double FlatNE;
	double FlngNE;
	bool FSignalInvalide;
	bool FClusterable;
	bool FProtectToExternClear;
	unsigned FDelayHint;
	unsigned FShowHintAfter;
	int FDetectionMarginInPixel;
	bool FAllStylesUpdate;
	System::Byte FOpacity;
	TecCSV* __fastcall getCsv();
	void __fastcall setOpacity(const System::Byte value);
	void __fastcall ShapeListToDraw();
	void __fastcall GetShapeList(TECShapeList* const value, TECShapesList* const _ShapesList);
	void __fastcall Update(System::TObject* sender);
	void __fastcall setShapeHover(TECShape* const value);
	void __fastcall setShapeDrag(TECShape* const value);
	void __fastcall setClusterable(const bool value);
	System::UnicodeString __fastcall getToTxt();
	void __fastcall setTotxt(const System::UnicodeString value);
	void __fastcall _setToTxt(const System::UnicodeString value);
	System::UnicodeString __fastcall getToGpx();
	void __fastcall setToGpx(const System::UnicodeString value);
	System::UnicodeString __fastcall getToGeoJSON();
	void __fastcall setToGeoJSon(const System::UnicodeString value);
	void __fastcall setToWKT(const System::UnicodeString value);
	System::UnicodeString __fastcall getToWKT();
	System::UnicodeString __fastcall getToKml();
	void __fastcall setToKml(const System::UnicodeString value);
	void __fastcall setMaxZoom(const System::Byte value);
	void __fastcall setMinZoom(const System::Byte value);
	void __fastcall setZIndex(const System::LongInt value);
	void __fastcall setShow(const bool value);
	void __fastcall setVisible(const bool value);
	bool __fastcall getVisible();
	void __fastcall setSelected(const bool value);
	bool __fastcall getSelected();
	int __fastcall Draw();
	void __fastcall UpdateStyles();
	void __fastcall FreeTempCache();
	void __fastcall ChangeBounds();
	System::UnicodeString __fastcall getProperty(const System::UnicodeString index);
	void __fastcall setProperty(const System::UnicodeString index, const System::UnicodeString value);
	System::UnicodeString __fastcall getProperties();
	void __fastcall setProperties(const System::UnicodeString value);
	int __fastcall ShapesToDraw();
	int __fastcall ShapesFirstToDraw(TECShapesList* const FirstShapesDraw);
	
protected:
	__fastcall TECShapes(TECShapesGroup* _Owner, Vcl::Controls::TWinControl* _Parent, Uecmaputil::TECWorldInfo* const dWorld, System::Classes::TNotifyEvent FEvent);
	
private:
	void __fastcall resetProperty();
	bool __fastcall getReady();
	int __fastcall AnimationShapes();
	int __fastcall AnimationCount();
	void __fastcall ForceUpdate();
	void __fastcall doInvalidate();
	void __fastcall setModified(const bool value);
	__property bool Modified = {read=FModified, write=setModified, nodefault};
	__property System::UnicodeString BaseDir = {read=FBaseDir, write=FBaseDir};
	
public:
	__fastcall virtual ~TECShapes();
	void __fastcall ClearShapesDraw();
	bool __fastcall isInArea(const double SWLat, const double SWLng, const double NELat, const double NELng);
	TECShapePOI* __fastcall AddPoint(const double Lat, const double Lng, const System::Uitypes::TColor Color = (System::Uitypes::TColor)(0x4848ff), const int Size = 0xa, const int BSize = 0x2);
	TECShape* __fastcall ShapeByHover(const int iX, const int iY);
	TECCluster* __fastcall ClusterByHover(const int iX, const int iY);
	TECShapeMarker* __fastcall AddMarker(const double Lat, const double Lng);
	TECShapePOI* __fastcall AddPoi(const double Lat, const double Lng)/* overload */;
	TECShapePOI* __fastcall AddPoi(const double SWLat, const double SWLng, const double NELat, const double NELng)/* overload */;
	TECShapePOI* __fastcall AddCircle(const double Lat, const double Lng)/* overload */;
	TECShapePOI* __fastcall AddCircle(const double SWLat, const double SWLng, const double NELat, const double NELng)/* overload */;
	TECShapeLine* __fastcall AddLine()/* overload */;
	TECShapeLine* __fastcall AddEncodedLine(const System::UnicodeString EncodedLine, const System::Byte precision = (System::Byte)(0x5))/* overload */;
	TECShapeLine* __fastcall AddLine(const double *dLatLngs, const System::NativeInt dLatLngs_High)/* overload */;
	TECShapeLine* __fastcall AddLine(TECShapeLine* const dLine)/* overload */;
	TECShapePolygone* __fastcall AddPolygone()/* overload */;
	TECShapePolygone* __fastcall AddPolygone(TECShapeLine* const dLine)/* overload */;
	TECShapePolygone* __fastcall AddEncodedPolygone(const System::UnicodeString EncodedLine, const System::Byte precision = (System::Byte)(0x5))/* overload */;
	TECShapePolygone* __fastcall AddPolygone(const Uecmaputil::TLatLng &SouthWest, const Uecmaputil::TLatLng &NorthEast)/* overload */;
	TECShapePolygone* __fastcall AddPolygone(const double *dLatLngs, const System::NativeInt dLatLngs_High)/* overload */;
	TECShapeInfoWindow* __fastcall AddInfoWindow(const System::UnicodeString content = System::UnicodeString())/* overload */;
	void __fastcall Lock();
	void __fastcall UnLock();
	void __fastcall UpdateBounds();
	void __fastcall Remove();
	void __fastcall Clear();
	void __fastcall ClearNoOnMap();
	bool __fastcall ShowOnMap();
	void __fastcall getBounds(const bool inView = false);
	void __fastcall fitBounds();
	int __fastcall Count();
	System::LongInt __fastcall TopZindex();
	System::LongInt __fastcall TopAllZindex();
	void __fastcall BeginUpdate();
	void __fastcall EndUpdate(const bool ResetUpdate = false);
	void __fastcall DecEndUpdate();
	void __fastcall Invalidate();
	void __fastcall NotifyLoad();
	void __fastcall SaveToFile(const System::UnicodeString filename);
	bool __fastcall LoadFromFile(const System::UnicodeString filename);
	bool __fastcall LoadFromOSMStream(System::Classes::TStream* const Stream);
	bool __fastcall LoadFromOSMString(const System::UnicodeString Data);
	void __fastcall ASyncToTxt(const System::UnicodeString value);
	bool __fastcall ASyncLoadFromFile(const System::UnicodeString filename);
	bool __fastcall ASyncLoadFromGeoJSONStream(System::Classes::TStream* const Stream);
	__property bool DontScaleToZoom = {read=FDontScaleToZoom, write=FDontScaleToZoom, nodefault};
	__property bool HintColorShape = {read=FHintColorShape, write=FHintColorShape, nodefault};
	__property bool HintCenter = {read=FHintCenter, write=FHintCenter, nodefault};
	__property System::Uitypes::TColor HintColor = {read=FHintColor, write=FHintColor, nodefault};
	__property int HintMinHeight = {read=FHintMinHeight, write=FHintMinHeight, nodefault};
	__property int HintMinWidth = {read=FHintMinWidth, write=FHintMinWidth, nodefault};
	__property int HintFontSize = {read=FHintFontSize, write=FHintFontSize, nodefault};
	__property bool RemoveIfZoomOut = {read=FRemoveIfZoomOut, write=FRemoveIfZoomOut, nodefault};
	__property TGeoJSONGeometryParser* GeoJSONParser = {read=FGeoJSONGeometryParser};
	__property bool isLoading = {read=FisLoading, nodefault};
	__property bool ForceDraw = {read=FForceDraw, write=FForceDraw, nodefault};
	__property System::TObject* Data = {read=FData, write=FData};
	__property bool Focusable = {read=FFocusable, write=FFocusable, nodefault};
	__property PtrInt Tag = {read=FTag, write=FTag, nodefault};
	__property System::UnicodeString properties = {read=getProperties, write=setProperties};
	__property System::UnicodeString PropertyValue[const System::UnicodeString index] = {read=getProperty, write=setProperty/*, default*/};
	__property Vcl::Imglist::TCustomImageList* Icons = {read=FIcons, write=FIcons};
	__property unsigned DelayHint = {read=FDelayHint, write=FDelayHint, nodefault};
	__property unsigned ShowHintAfter = {read=FShowHintAfter, write=FShowHintAfter, nodefault};
	__property int DetectionMarginInPixel = {read=FDetectionMarginInPixel, write=FDetectionMarginInPixel, nodefault};
	__property System::Byte MaxZoom = {read=FMaxZoom, write=setMaxZoom, nodefault};
	__property System::Byte MinZoom = {read=FMinZoom, write=setMinZoom, nodefault};
	__property System::LongInt ZIndex = {read=FZindex, write=setZIndex, nodefault};
	__property System::Byte Opacity = {read=FOpacity, write=setOpacity, nodefault};
	__property bool BubblingClick = {read=FBubblingClick, write=FBubblingClick, nodefault};
	__property bool Clickable = {read=FClickable, write=FClickable, nodefault};
	__property bool Show = {read=FShow, write=setShow, nodefault};
	__property bool checkAllStyles = {read=FcheckAllStyles, nodefault};
	__property bool Serialize = {read=FSerialize, write=FSerialize, nodefault};
	__property bool Visible = {read=getVisible, write=setVisible, nodefault};
	__property bool Selected = {read=getSelected, write=setSelected, nodefault};
	__property bool isEditable = {read=FIsEditable, write=FIsEditable, nodefault};
	__property bool DefaultVisibilityShape = {read=FDefaultVisibilityShape, write=FDefaultVisibilityShape, nodefault};
	__property bool DefaultRotationShape = {read=FDefaultRotationShape, write=FDefaultRotationShape, nodefault};
	__property bool Ready = {read=getReady, nodefault};
	__property System::UnicodeString Name = {read=FName};
	__property bool UseGraphicDirectory = {read=FUseGraphicDirectory, write=FUseGraphicDirectory, nodefault};
	__property TECClusterManager* ClusterManager = {read=FClusterManager};
	__property TECClusters* Clusters = {read=FECClusters};
	__property bool Clusterable = {read=FClusterable, write=setClusterable, nodefault};
	__property System::UnicodeString Hint = {read=FHint, write=FHint};
	__property TECShapeInfoWindowList* InfoWindows = {read=FInfoWindows};
	__property TECShapePOIList* Pois = {read=FPois};
	__property TECShapeMarkerList* Markers = {read=FMarkers};
	__property TECShapeLineList* Lines = {read=FLines};
	__property TECShapePolygoneList* Polygones = {read=FPolys};
	__property TECShape* ShapeHover = {read=FShapeHover, write=setShapeHover};
	__property TECShape* ShapeDrag = {read=FShapeDrag, write=setShapeDrag};
	__property double NorthEastLatitude = {read=FlatNE};
	__property double NorthEastLongitude = {read=FlngNE};
	__property double SouthWestLatitude = {read=FlatSW};
	__property double SouthWestLongitude = {read=FlngSW};
	__property bool ProtectToExternClear = {read=FProtectToExternClear, write=FProtectToExternClear, nodefault};
	__property TecCSV* CSV = {read=getCsv};
	__property int HintOffsetY = {read=FHintOffsetY, write=FHintOffsetY, nodefault};
	__property System::UnicodeString toTxt = {read=getToTxt, write=setTotxt};
	__property System::UnicodeString ToGpx = {read=getToGpx, write=setToGpx};
	__property System::UnicodeString ToKml = {read=getToKml, write=setToKml};
	__property System::UnicodeString ToGeoJSon = {read=getToGeoJSON, write=setToGeoJSon};
	__property System::UnicodeString ToWKT = {read=getToWKT, write=setToWKT};
	__property bool ShowHint = {read=FShowHint, write=FShowHint, nodefault};
	__property Uecmaputil::TECWorldInfo* World = {read=FWorld};
	__property TECShapesGroup* owner = {read=FOwner};
	__property System::Classes::TNotifyEvent OnLoad = {read=FOnLoad, write=FOnLoad};
	__property TOnLoadText OnText = {read=FOnLoadText, write=FOnLoadText};
	__property TOnShapeMove OnMove = {read=FOnMove, write=FOnMove};
	__property System::Classes::TNotifyEvent OnChange = {read=FOnchange, write=FOnchange};
	__property TOnShapeLocation OnShapeLocation = {read=FOnShapeLocation, write=FOnShapeLocation};
	__property System::Classes::TNotifyEvent OnShapeOverIntent = {read=FOnShapeOverIntent, write=FOnShapeOverIntent};
	__property System::Classes::TNotifyEvent OnClusterChange = {read=FOnClusterChange, write=FOnClusterChange};
};


//-- var, const, procedure ---------------------------------------------------
static _DELPHI_CONST System::Int8 ECMAP_USER_ZINDEX = System::Int8(-20);
extern DELPHI_PACKAGE void __fastcall GeodesicArc(const double startlat, const double startlng, const double EndLat, const double EndLng, const int MaxLength, TECShapeLine* const Line);
extern DELPHI_PACKAGE void __fastcall ConvertToPNG(Vcl::Graphics::TGraphic* Source, /* out */ Vcl::Imaging::Pngimage::TPngImage* &Dest, const int w, const int h);
}	/* namespace Uecnativeshape */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_UECNATIVESHAPE)
using namespace Uecnativeshape;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// uecNativeShapeHPP
