﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'uecNativeTileServer.pas' rev: 37.00 (Windows)

#ifndef uecNativeTileServerHPP
#define uecNativeTileServerHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.SysUtils.hpp>
#include <Vcl.Forms.hpp>
#include <Winapi.Windows.hpp>
#include <System.Classes.hpp>
#include <Vcl.Controls.hpp>
#include <Vcl.Graphics.hpp>
#include <UECMapZIP.hpp>
#include <Vcl.Imaging.pngimage.hpp>
#include <uecHttp.hpp>
#include <UECGraphics.hpp>
#include <vector_tile.hpp>
#include <Winapi.Messages.hpp>
#include <Vcl.ExtCtrls.hpp>
#include <UECMapUtil.hpp>
#include <uecThreadGraphics.hpp>
#include <uecNativeShape.hpp>
#include <uecBingRest.hpp>
#include <System.UITypes.hpp>

//-- user supplied -----------------------------------------------------------

namespace Uecnativetileserver
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TFactoryGraphicTile;
class DELPHICLASS TWMS;
class DELPHICLASS TTileServerInfo;
class DELPHICLASS TECProjection;
class DELPHICLASS TECProjectionEllipticalMercator;
class DELPHICLASS TNativeMapServer;
//-- type declarations -------------------------------------------------------
typedef void __fastcall (__closure *TOnLoadTile)(System::TObject* sender, const int x, const int y, const int z, const int t);

typedef bool __fastcall (*TOnTileFromCache)(const bool MoveOnTop, const System::UnicodeString _Mask);

typedef Uecmaputil::TThreadStringList TPyramidCacheTile;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TFactoryGraphicTile : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Uecmaputil::TThreadStringList* FTiles;
	
public:
	__fastcall TFactoryGraphicTile();
	__fastcall virtual ~TFactoryGraphicTile();
	Vcl::Graphics::TGraphic* __fastcall Get();
	void __fastcall Release(Vcl::Graphics::TGraphic* const value);
};

#pragma pack(pop)

enum DECLSPEC_DENUM TLegendPosition : unsigned char { lpTopLeft, lpTopRight, lpBottomLeft, lpBottomRight, lpTopCenter, lpBottomCenter, lpLeftCenter, lpRightCenter };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TWMS : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Uecmaputil::TECWorldInfo* FWorldInfo;
	System::UnicodeString FServer;
	System::UnicodeString FVersion;
	System::UnicodeString FLayers;
	System::UnicodeString FTime;
	System::UnicodeString FStyle;
	int FESPG;
	void __fastcall setZoom(const int Value);
	int __fastcall getZoom();
	void __fastcall setLayers(const System::UnicodeString Value);
	
public:
	__fastcall TWMS(const System::UnicodeString AServer);
	__fastcall virtual ~TWMS();
	System::UnicodeString __fastcall GetUrl(double NELat, double NELng, double SWLat, double SWLng)/* overload */;
	System::UnicodeString __fastcall GetUrl(const int x, const int y, const int z)/* overload */;
	__property int EPSG = {read=FESPG, write=FESPG, nodefault};
	__property System::UnicodeString Layers = {read=FLayers, write=setLayers};
	__property System::UnicodeString Server = {read=FServer, write=FServer};
	__property System::UnicodeString Style = {read=FStyle, write=FStyle};
	__property System::UnicodeString Version = {read=FVersion, write=FVersion};
	__property System::UnicodeString Time = {read=FTime, write=FTime};
	__property int Zoom = {read=getZoom, write=setZoom, nodefault};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TTileServerInfo : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Uecmaputil::TOnSaveLocalStream FOnSaveLocalStream;
	Uecmaputil::TOnLoadLocalStream FOnLoadLocalStream;
	System::UnicodeString FHttp_Https;
	System::UnicodeString FStyle;
	System::UnicodeString FName;
	bool FBing;
	int FMaxTilesPending;
	Vcl::Graphics::TGraphic* FErrorTile;
	int FMaxReloadErrorTile;
	TNativeMapServer* FServer;
	System::Classes::TNotifyEvent FChangeServerTiles;
	System::Classes::TNotifyEvent FSaveChangeServerTiles;
	System::Classes::TNotifyEvent FUpdateSSL;
	System::Classes::TNotifyEvent FUpdateTimeout;
	System::Classes::TNotifyEvent FUpdate;
	System::Classes::TNotifyEvent FSaveUpdate;
	int FConnexionTimeout;
	int FResponseTimeout;
	Uecmaputil::TECWorldInfo* FWorldInfo;
	System::UnicodeString FUrlWMS;
	System::UnicodeString FVersionWMS;
	System::UnicodeString FUrlLegendWMS;
	System::UnicodeString FLayersWMS;
	System::UnicodeString FSESPG;
	System::UnicodeString FTimeWMS;
	System::UnicodeString FStyleWMS;
	bool FLegendWMS;
	int FLegendXMarginWMS;
	int FLegendYMarginWMS;
	System::Byte FOpacityLegendWMS;
	TLegendPosition FLegendPosition;
	int FESPG;
	Vcl::Graphics::TGraphic* FGraphicLegend;
	System::UnicodeString FUserAgent;
	System::Classes::TStringList* FMapStyles;
	bool FSSL;
	Uecmaputil::TOnMapServerTilePath FGetTileFilename;
	Uecmaputil::TOnMapServerTileStream FGetTileStream;
	System::UnicodeString _Name;
	Uecmaputil::TOnMapServerTilePath _FGetTileFilename;
	void __fastcall setErrorTile(Vcl::Graphics::TGraphic* const value);
	void __fastcall setStreamType(const Uecmaputil::TStreamType value);
	void __fastcall setOnSaveLocalStream(const Uecmaputil::TOnSaveLocalStream value);
	void __fastcall setOnLoadLocalStream(const Uecmaputil::TOnLoadLocalStream value);
	void __fastcall setGetTileFilename(const Uecmaputil::TOnMapServerTilePath value);
	void __fastcall setGetTileStream(const Uecmaputil::TOnMapServerTileStream value);
	void __fastcall setName(const System::UnicodeString value);
	void __fastcall setStyle(const System::UnicodeString value);
	void __fastcall setSSL(const bool value);
	void __fastcall setConnexionTimout(const int value);
	void __fastcall setResponseTimeout(const int value);
	void __fastcall setUserAgent(const System::UnicodeString value);
	void __fastcall setMaxTilesPending(const int value);
	void __fastcall GetTileWMS(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall setTimeWMS(const System::UnicodeString value);
	void __fastcall setLegendWMS(bool value);
	void __fastcall setLegendXMarginWMS(int value);
	void __fastcall setLegendYMarginWMS(int value);
	void __fastcall setOpacityLegendWMS(System::Byte value);
	void __fastcall setLegendPosition(TLegendPosition value);
	void __fastcall setStyleWMS(const System::UnicodeString value);
	void __fastcall setVersionWMS(const System::UnicodeString value);
	
public:
	Uecmaputil::TStreamType StreamType;
	System::Byte MinZoom;
	System::Byte MaxZoom;
	System::UnicodeString Key;
	System::UnicodeString CopyRight;
	System::UnicodeString TilePath;
	bool LocalExt;
	bool LocalPath;
	__fastcall TTileServerInfo(Uecmaputil::TECWorldInfo* WorldInfo);
	__fastcall virtual ~TTileServerInfo();
	void __fastcall AddWMSLayer(const System::UnicodeString url, const System::UnicodeString layers, const int ESPG = 0x10e6);
	void __fastcall DeleteWMSLayer();
	void __fastcall beginupdate();
	void __fastcall endupdate();
	__property System::UnicodeString WMS_Url = {read=FUrlWMS};
	__property System::UnicodeString WMS_UrlLegend = {read=FUrlLegendWMS};
	__property System::UnicodeString WMS_Layers = {read=FLayersWMS, write=FLayersWMS};
	__property System::UnicodeString WMS_Time = {read=FTimeWMS, write=setTimeWMS};
	__property System::UnicodeString WMS_Style = {read=FStyleWMS, write=setStyleWMS};
	__property bool WMS_Legend = {read=FLegendWMS, write=setLegendWMS, nodefault};
	__property int WMS_LegendXMargin = {read=FLegendXMarginWMS, write=setLegendXMarginWMS, nodefault};
	__property int WMS_LegendYMargin = {read=FLegendYMarginWMS, write=setLegendYMarginWMS, nodefault};
	__property System::Byte WMS_OpacityLegend = {read=FOpacityLegendWMS, write=setOpacityLegendWMS, nodefault};
	__property TLegendPosition WMS_LegendPosition = {read=FLegendPosition, write=setLegendPosition, nodefault};
	__property Vcl::Graphics::TGraphic* WMS_GraphicLegend = {read=FGraphicLegend, write=FGraphicLegend};
	__property System::UnicodeString WMS_Version = {read=FVersionWMS, write=setVersionWMS};
	__property System::UnicodeString Name = {read=FName, write=setName};
	__property System::UnicodeString MapStyle = {read=FStyle, write=setStyle};
	__property System::UnicodeString Style = {read=FStyle, write=setStyle};
	__property TNativeMapServer* Server = {read=FServer};
	__property Uecmaputil::TOnSaveLocalStream OnSaveLocalStream = {read=FOnSaveLocalStream, write=setOnSaveLocalStream};
	__property Uecmaputil::TOnLoadLocalStream OnLoadLocalStream = {read=FOnLoadLocalStream, write=setOnLoadLocalStream};
	__property Uecmaputil::TOnMapServerTilePath GetTileFilename = {read=FGetTileFilename, write=setGetTileFilename};
	__property Uecmaputil::TOnMapServerTileStream GetTileStream = {read=FGetTileStream, write=setGetTileStream};
	__property Uecmaputil::TStreamType TileFormat = {read=StreamType, write=setStreamType, nodefault};
	__property bool SSL = {read=FSSL, write=setSSL, nodefault};
	__property int ConnexionTimeout = {read=FConnexionTimeout, write=setConnexionTimout, nodefault};
	__property int ResponseTimeout = {read=FResponseTimeout, write=setResponseTimeout, nodefault};
	__property System::UnicodeString UserAgent = {read=FUserAgent, write=setUserAgent};
	__property int MaxTilesPending = {read=FMaxTilesPending, write=setMaxTilesPending, nodefault};
	__property Vcl::Graphics::TGraphic* ErrorTile = {read=FErrorTile, write=setErrorTile};
	__property int MaxReloadErrorTile = {read=FMaxReloadErrorTile, write=FMaxReloadErrorTile, nodefault};
	__property System::Classes::TStringList* MapStyles = {read=FMapStyles};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TECProjection : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Uecnativeshape::TECShapesGroup* FECShapesGroup;
	
public:
	__fastcall TECProjection(Uecnativeshape::TECShapesGroup* const ShapesGroup);
	virtual void __fastcall getProjLatLngToXY(const double Lat, const double Lng, double &x, double &y);
	virtual void __fastcall getProjXYToLatLng(const double x, const double y, double &Lat, double &Lng);
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TECProjection() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECProjectionEllipticalMercator : public TECProjection
{
	typedef TECProjection inherited;
	
private:
	Uecmaputil::TECTilesCoordinatesConverter* FCoordConvertor;
	
public:
	__fastcall TECProjectionEllipticalMercator(Uecnativeshape::TECShapesGroup* const ShapesGroup);
	__fastcall virtual ~TECProjectionEllipticalMercator();
	virtual void __fastcall getProjLatLngToXY(const double Lat, const double Lng, double &x, double &y);
	virtual void __fastcall getProjXYToLatLng(const double x, const double y, double &Lat, double &Lng);
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TNativeMapServer : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	bool FSynchronize;
	bool FFreeCache;
	Vcl::Graphics::TGraphic* FErrorTile;
	Vector_tile::TDecodedTile* FErrorTileVMT;
	TECProjection* FProjection;
	Uecnativeshape::TECShapesGroup* FECShapesGroup;
	int FIntervalThreadPool;
	Vcl::Graphics::TCanvas* FCanvas;
	Uecgraphics::TECCanvas* FECCanvas;
	bool FDraw;
	bool FGoogleTraffic;
	System::UnicodeString FGoogleLang;
	System::UnicodeString FGoogleRegion;
	System::UnicodeString FGoogleStyles;
	System::UnicodeString FLocale;
	System::UnicodeString FLocale_2;
	System::UnicodeString FGeoApifyKey;
	System::UnicodeString FOpenCycleMapKey;
	System::UnicodeString FDigitalGlobeToken;
	System::UnicodeString FMapBoxToken;
	System::UnicodeString FIgnKey;
	System::UnicodeString FTomTomKey;
	System::UnicodeString FVectorMapZenKey;
	System::UnicodeString FHereParam;
	System::UnicodeString FHereApp_id;
	System::UnicodeString FGoogleKey;
	System::UnicodeString FGoogleSession;
	System::UnicodeString FHereApp_code;
	System::UnicodeString FAqicnKey;
	System::UnicodeString FPTVKey;
	System::UnicodeString FStadiaMapsKey;
	System::UnicodeString FMapToolKitKey;
	System::UnicodeString FMaptilerKey;
	System::UnicodeString FAzureKey;
	Uecbingrest::TecBingRest* FecBingRest;
	Winapi::Windows::TRTLCriticalSection FLock;
	TTileServerInfo* FTileServerInfo;
	Uecmaputil::TThreadStringList* FTileVisible;
	System::Classes::TStringList* _FTileVisible;
	TPyramidCacheTile* FCache;
	System::Word F3CacheSize;
	System::Word F3QCacheSize;
	System::Word FCacheSize;
	System::Word FNeverthisCacheSize;
	Vcl::Controls::TWinControl* FParent;
	System::Classes::TMemoryStream* FMemoryFile;
	Vcl::Graphics::TGraphic* FTile;
	Vector_tile::TDecodedTile* FTileVMT;
	Uecmapzip::TECMapZip* FMapZip;
	Uecthreadgraphics::TThreadSaveTile* FThreadSaveTile;
	System::Byte FIDThreadTilePool;
	Uecthreadgraphics::TThreadTilePool* FThreadTilePool;
	Uecthreadgraphics::TThreadTilePool* FThreadTilePoolB;
	Uecthreadgraphics::TThreadTilePool* FThreadTilePoolC;
	Uecthreadgraphics::TThreadTilePool* FThreadTilePoolD;
	Uecthreadgraphics::TThreadSendObject* FThreadSendObject;
	TOnLoadTile FOnLoadTile;
	TOnLoadTile FOnErrorTile;
	System::Classes::TNotifyEvent FOnErrorConnexion;
	System::Classes::TNotifyEvent FOnClearCache;
	Uechttp::TuecHttp* FDHttp;
	System::Classes::TMemoryStream* DStream;
	Vcl::Graphics::TWICImage* FTilePng;
	Vcl::Graphics::TWICImage* FTileJpeg;
	bool FStringGrid;
	bool FCancel;
	System::Classes::TStringList* FStringTile;
	Vcl::Graphics::TBitmap* FWaitTile;
	Uecmaputil::TTileServer FSaveTileServer;
	Uecmaputil::TTileServer FTileServer;
	Uecmaputil::TOnMapServerTilePath FSaveTileFilename;
	Uecmaputil::TOnMapServerTileStream FSaveTileStream;
	System::UnicodeString FSaveName;
	System::UnicodeString FSaveCopyright;
	System::UnicodeString FMASK_LocalTile;
	System::UnicodeString FMASK_Tile;
	System::UnicodeString FMASK_ZOOM;
	System::UnicodeString FMASK_SEPA;
	System::UnicodeString FMASK_SOURCE_X_Y_Z;
	System::UnicodeString FSaveLocalCache;
	System::UnicodeString FLocalCache;
	Uecmaputil::TLocalCacheSetting FLocalCacheSetting;
	System::UnicodeString FTileServerInfoName;
	System::UnicodeString FPPI;
	System::UnicodeString FTileSize;
	bool FFirstRun;
	bool FFilterColors;
	System::UnicodeString FVariableName;
	bool FInCheckCacheSize;
	bool FDirectLoadLocalTile;
	Uecmaputil::TNbrThreadTile FNbrThreadTile;
	bool FOnlyLocal;
	bool FPause;
	bool FTileOk;
	int FIntTileSize;
	int FLastZoom;
	double FMaxDayInCache;
	double FOpacity;
	bool FIsOverlay;
	void __fastcall setLocale(const System::UnicodeString value);
	void __fastcall setMaxDayInCache(double value);
	void __fastcall setSSL(const bool value);
	bool __fastcall getSSL();
	System::Word __fastcall GetCacheCount();
	void __fastcall SetCacheSize(const System::Word AValue);
	void __fastcall UpdateGoogleSession();
	void __fastcall SetTileServer(const Uecmaputil::TTileServer value);
	void __fastcall setGoogleTraffic(const bool value);
	void __fastcall setGoogleStyles(const System::UnicodeString value);
	void __fastcall setGoogleLang(const System::UnicodeString value);
	void __fastcall setGoogleRegion(const System::UnicodeString value);
	Uecmaputil::TOnProjectionLatLngToXY __fastcall getProjLatLngToXY();
	Uecmaputil::TOnProjectionXYToLatLng __fastcall getProjXYToLatLng();
	bool __fastcall GetStringTileFromCache(const bool MoveOnTop, const System::UnicodeString _Mask);
	bool __fastcall GetTileFromCache(const bool MoveOnTop, const System::UnicodeString _Mask);
	void __fastcall doTileInfoAddCache(System::TObject* sender);
	bool __fastcall GetFromLocalCacheStream(int x, int y, int z, System::Classes::TMemoryStream* const stream);
	void __fastcall ReleaseToCache(Uecmaputil::TTileServer source, int x, int y, int z);
	System::UnicodeString __fastcall getUrlTile(const int x, const int y, const int z)/* overload */;
	void __fastcall UpdateTileFormat(System::TObject* sender);
	void __fastcall UpdateSSL(System::TObject* sender);
	void __fastcall UpdateServerTiles(System::TObject* sender);
	void __fastcall UpdateServerTimeout(System::TObject* sender);
	void __fastcall setStringGrid(bool value);
	void __fastcall setCancel(bool value);
	void __fastcall setPause(bool value);
	void __fastcall setLocalCache(const System::UnicodeString value);
	void __fastcall setLocalCacheSetting(const Uecmaputil::TLocalCacheSetting value);
	void __fastcall getTileStreamZ(const int ThreadIndex, System::Classes::TMemoryStream* &TileStream, const int x, const int y, const int z);
	void __fastcall setMapZip(Uecmapzip::TECMapZip* ArchiveZip);
	void __fastcall GetBaseSnowMap(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetPisteSnowMap(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetIGN_Plan(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOpenRailWay(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetEmpty(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOSM(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOSMCH(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall getWayMarkedTrails(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOSMFr(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHotOSM(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall getCyclOSM(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOSMDe(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetVectorMapZen(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetTomTomBasic(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetTomTomSat(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetTomTomHybrid(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetTomTomNight(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetTomTomIncident(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetTomTomFlow(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetTopPlusWebOpen(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHyddaFull(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOpenMapQuest(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetArcGisWorldTopoMap(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetArcGisWorldImagery(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetArcGisWorldOceanBase(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetArcGisWorldStreetMap(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOpenMapQuestSat(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetCloudMade(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOpenCycleMap(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GeThunderForest(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetStadiaMaps(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetGeoapify(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOPNV(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetAqicn(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetMappilaryCoverage(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetAzure(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereNormal(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereTerrain(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHere(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetMaptiler(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetGoogle(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereSatellite(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereHybrid(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereMobile(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereHiRes(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereTransit(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereTruck(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereTruckTransparent(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereTraffic(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereFlow(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereReducedNight(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereNormalNight(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetHereXBNormalNight(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetYandexNormal(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetYandexSatellite(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetYandexHybrid(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetYandexPeople(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetOpenTopoMap(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetMapBoxStreet(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetMapBoxSatellite(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetMapBoxStreetSatellite(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetMapBoxStreetBasic(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetMapBoxOutdoors(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetDigitalGlobeRecent(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall GetDigitalGlobeTerrain(System::UnicodeString &TileFilename, const int x, const int y, const int z);
	void __fastcall setOpacity(const double value);
	void __fastcall setTileSize(const System::UnicodeString value);
	void __fastcall updateTileServerInfoName();
	void __fastcall setFilterColors(const bool value);
	System::UnicodeString __fastcall getQualifiedName();
	
public:
	__fastcall TNativeMapServer(Uecnativeshape::TECShapesGroup* ShapesGroup, Vcl::Controls::TWinControl* WinControl, int IntervalThread, System::Uitypes::TColor BackColor);
	__fastcall virtual ~TNativeMapServer();
	void __fastcall CloneCache(TNativeMapServer* Master);
	void __fastcall Lock();
	void __fastcall UnLock();
	void __fastcall BeginDraw();
	void __fastcall EndDraw();
	void __fastcall CheckCacheSize();
	void __fastcall Repaint();
	void __fastcall setCustomHeader(const System::UnicodeString header, const System::UnicodeString value);
	void __fastcall setUseWinINET(const bool use);
	void __fastcall setProxyParams(const System::UnicodeString Server, const int port, const System::UnicodeString username = System::UnicodeString(), System::UnicodeString password = System::UnicodeString());
	void __fastcall AddToCache(Uecmaputil::TTileServer source, int x, int y, int z, System::Classes::TMemoryStream* const stream)/* overload */;
	void __fastcall AddToCache(Uecmaputil::TTileServer source, Uecthreadgraphics::TTileInfo* t)/* overload */;
	System::Byte __fastcall IsScreenComplete(const int StartX, const int StartY, const int MaxX, const int MaxY, const int z);
	void __fastcall DrawTile(const bool visible, const __int64 x, const __int64 y, const __int64 z, const __int64 tsize, const __int64 tzoom, const __int64 xb, const __int64 yb, Vcl::Graphics::TGraphic* Tile = (Vcl::Graphics::TGraphic*)(0x0), const bool _update = true);
	void __fastcall PrechargingTile(const int x, const int y, const int z, const bool clear = false);
	bool __fastcall DownLoadTile(const int x, const int y, const int z);
	void __fastcall FreeDownLoadTile();
	bool __fastcall GetStreamTile(System::Classes::TMemoryStream* &MemoryStream, const int x, const int y, const int z);
	void __fastcall PreChargingTiles(const int TileX, const int TileY, const int TileX2, const int TileY2, const int z);
	void __fastcall ChargingTileFromBounds(int z, double NorthEastLatitude, double NorthEastLongitude, double SouthWestLatitude, double SouthWestLongitude);
	System::UnicodeString __fastcall GetStringTile(int x, int y, int z);
	void __fastcall CancelActiveThread();
	void __fastcall ClearThread();
	void __fastcall ClearThreadNoPreload();
	void __fastcall ClearCache();
	void __fastcall Disconnect();
	int __fastcall LoadingTiles();
	int __fastcall LoadingViewTiles();
	void __fastcall setOnlyLocal(const bool value);
	int __fastcall AddTilesToListFromBounds(System::Classes::TStringList* &List, int z, double NorthEastLatitude, double NorthEastLongitude, double SouthWestLatitude, double SouthWestLongitude);
	void __fastcall reLoad();
	void __fastcall reLoadNoWait();
	__property System::UnicodeString VariableName = {read=FVariableName, write=FVariableName};
	__property Uecbingrest::TecBingRest* BingRest = {read=FecBingRest};
	__property Vcl::Graphics::TCanvas* Canvas = {read=FCanvas, write=FCanvas};
	__property Uecgraphics::TECCanvas* ECanvas = {read=FECCanvas, write=FECCanvas};
	__property bool Draw = {read=FDraw, write=FDraw, nodefault};
	__property System::UnicodeString Locale = {read=FLocale, write=setLocale};
	__property bool FilterColors = {read=FFilterColors, write=setFilterColors, nodefault};
	__property bool DirectLoadLocalTile = {read=FDirectLoadLocalTile, write=FDirectLoadLocalTile, nodefault};
	__property System::UnicodeString ThunderForestKey = {read=FOpenCycleMapKey, write=FOpenCycleMapKey};
	__property System::UnicodeString GeoApifyKey = {read=FGeoApifyKey, write=FGeoApifyKey};
	__property System::UnicodeString StadiaMapsKey = {read=FStadiaMapsKey, write=FStadiaMapsKey};
	__property System::UnicodeString MapToolKitKey = {read=FMapToolKitKey, write=FMapToolKitKey};
	__property System::UnicodeString MapBoxToken = {read=FMapBoxToken, write=FMapBoxToken};
	__property System::UnicodeString DigitalGlobeToken = {read=FDigitalGlobeToken, write=FDigitalGlobeToken};
	__property System::UnicodeString AzureKey = {read=FAzureKey, write=FAzureKey};
	__property System::UnicodeString HereApp_id = {read=FHereApp_id, write=FHereApp_id};
	__property System::UnicodeString HereApp_code = {read=FHereApp_code, write=FHereApp_code};
	__property System::UnicodeString HereParam = {read=FHereParam, write=FHereParam};
	__property System::UnicodeString VectorMapZenKey = {read=FVectorMapZenKey, write=FVectorMapZenKey};
	__property System::UnicodeString TomTomKey = {read=FTomTomKey, write=FTomTomKey};
	__property System::UnicodeString PTVKey = {read=FPTVKey, write=FPTVKey};
	__property System::UnicodeString AqicnKey = {read=FAqicnKey, write=FAqicnKey};
	__property System::UnicodeString GoogleKey = {read=FGoogleKey, write=FGoogleKey};
	__property System::UnicodeString MaptilerKey = {read=FMaptilerKey, write=FMaptilerKey};
	__property System::UnicodeString IgnKey = {read=FIgnKey, write=FIgnKey};
	__property System::Word CacheSize = {read=FCacheSize, write=SetCacheSize, nodefault};
	__property System::Word CacheCount = {read=GetCacheCount, nodefault};
	__property Uecmapzip::TECMapZip* MapZip = {read=FMapZip, write=setMapZip};
	__property System::UnicodeString LocalCache = {read=FLocalCache, write=setLocalCache};
	__property Uecmaputil::TLocalCacheSetting LocalCacheSetting = {read=FLocalCacheSetting, write=setLocalCacheSetting, nodefault};
	__property System::UnicodeString TileSize = {read=FTileSize, write=setTileSize};
	__property System::UnicodeString PPI = {read=FPPI, write=FPPI};
	__property Vcl::Graphics::TGraphic* GraphicTile = {read=FTile};
	__property TPyramidCacheTile* CacheTile = {read=FCache};
	__property Uecmaputil::TThreadStringList* TileVisible = {read=FTileVisible};
	__property int IntTileSize = {read=FIntTileSize, nodefault};
	__property bool GoogleTraffic = {read=FGoogleTraffic, write=setGoogleTraffic, nodefault};
	__property System::UnicodeString GoogleStyles = {read=FGoogleStyles, write=setGoogleStyles};
	__property System::UnicodeString GoogleLang = {read=FGoogleLang, write=setGoogleLang};
	__property System::UnicodeString GoogleRegion = {read=FGoogleRegion, write=setGoogleRegion};
	__property Uecmaputil::TTileServer TileServer = {read=FTileServer, write=SetTileServer, default=4};
	__property TTileServerInfo* TileServerInfo = {read=FTileServerInfo};
	__property bool StringGrid = {read=FStringGrid, write=setStringGrid, nodefault};
	__property bool Cancel = {read=FCancel, write=setCancel, nodefault};
	__property bool Pause = {read=FPause, write=setPause, nodefault};
	__property bool TileOK = {read=FTileOk, write=FTileOk, nodefault};
	__property bool OnlyLocal = {read=FOnlyLocal, write=setOnlyLocal, nodefault};
	__property bool FuturOnlyLocal = {read=FOnlyLocal, write=FOnlyLocal, nodefault};
	__property double Opacity = {read=FOpacity, write=setOpacity};
	__property TOnLoadTile OnLoadTile = {read=FOnLoadTile, write=FOnLoadTile};
	__property TOnLoadTile OnErrorTile = {read=FOnErrorTile, write=FOnErrorTile};
	__property System::Classes::TNotifyEvent OnErrorConnexion = {read=FOnErrorConnexion, write=FOnErrorConnexion};
	__property System::Classes::TNotifyEvent OnClearCache = {read=FOnClearCache, write=FOnClearCache};
	__property Uecmaputil::TNbrThreadTile NbrThreadTile = {read=FNbrThreadTile, write=FNbrThreadTile, nodefault};
	__property System::Classes::TStringList* StringTile = {read=FStringTile};
	__property System::UnicodeString MASK_SOURCE_X_Y_Z = {read=FMASK_SOURCE_X_Y_Z};
	__property Uecmaputil::TOnProjectionLatLngToXY ProjLatLngToXY = {read=getProjLatLngToXY};
	__property Uecmaputil::TOnProjectionXYToLatLng ProjXYToLatLng = {read=getProjXYToLatLng};
	__property bool SSL = {read=getSSL, write=setSSL, nodefault};
	__property bool Synchronize = {read=FSynchronize, write=FSynchronize, nodefault};
	__property double MaxDayInCache = {read=FMaxDayInCache, write=setMaxDayInCache};
	__property System::UnicodeString QualifiedName = {read=getQualifiedName};
	__property bool IsOverlay = {read=FIsOverlay, write=FIsOverlay, nodefault};
};


//-- var, const, procedure ---------------------------------------------------
}	/* namespace Uecnativetileserver */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_UECNATIVETILESERVER)
using namespace Uecnativetileserver;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// uecNativeTileServerHPP
