﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'uecOSM.pas' rev: 37.00 (Windows)

#ifndef uecOSMHPP
#define uecOSMHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <Winapi.Messages.hpp>
#include <System.SysUtils.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <Vcl.StdCtrls.hpp>
#include <Vcl.Controls.hpp>
#include <uecNativeMapControl.hpp>
#include <uecNativeShape.hpp>
#include <System.Math.hpp>
#include <System.Generics.Collections.hpp>
#include <System.AnsiStrings.hpp>
#include <Vcl.Dialogs.hpp>
#include <Vcl.Forms.hpp>
#include <Vcl.ExtCtrls.hpp>
#include <UECMapUtil.hpp>
#include <uecHttp.hpp>
#include <System.StrUtils.hpp>
#include <System.SyncObjs.hpp>
#include <System.Generics.Defaults.hpp>
#include <System.Types.hpp>

//-- user supplied -----------------------------------------------------------

namespace Uecosm
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TFilterOSM;
class DELPHICLASS TOnlyThisFilterOSM;
class DELPHICLASS TExcludeThisFilterOSM;
class DELPHICLASS TListFilterOSM;
class DELPHICLASS TFilterBounds;
class DELPHICLASS TBaseOSM;
class DELPHICLASS TNodeOSM;
class DELPHICLASS TNodeGeo;
class DELPHICLASS TListNodeGeo;
class DELPHICLASS TListNodeOSM;
class DELPHICLASS TWayOSM;
class DELPHICLASS TListWayOSM;
class DELPHICLASS TMemberOSM;
class DELPHICLASS TRelationOSM;
class DELPHICLASS TListRelationOSM;
class DELPHICLASS TOSMSearch;
class DELPHICLASS TSubNodeList;
class DELPHICLASS TSubWayList;
class DELPHICLASS TSubRelationList;
class DELPHICLASS TRelationMultList;
class DELPHICLASS TNodeMultList;
class DELPHICLASS TWayMultList;
class DELPHICLASS TThreadSaveOSMFile;
class DELPHICLASS TThreadOSMToOLT;
class DELPHICLASS TThreadOSMToShapes;
class DELPHICLASS TThreadSaveOSMShapes;
class DELPHICLASS TThreadSaveOSMStream;
class DELPHICLASS TThreadParceOSMFile;
class DELPHICLASS TPositionId;
class DELPHICLASS TUniqueStringId;
class DELPHICLASS TUniqueStringList;
class DELPHICLASS TOSMFile;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TFileTypeOSM : unsigned char { ftOSM, ftOLT, ftUnknow };

enum DECLSPEC_DENUM TPrimitiveOSM : unsigned char { poNode, poWay, poRelation };

typedef System::Set<TPrimitiveOSM, TPrimitiveOSM::poNode, TPrimitiveOSM::poRelation> TSetPrimitiveOSM;

enum DECLSPEC_DENUM TTagOSM : unsigned char { tagNone, tagXml, tagOsm, tagBounds, tagNode, tagEndNode, tagTag, tagWay, tagEndWay, tagND, tagRelation, tagEndRelation, tagMember, tagEndOSM };

enum DECLSPEC_DENUM TBlockOLT : unsigned char { btNone, btKey, btValue, btNode, btWay, btRelation };

enum DECLSPEC_DENUM TActionOSMFilter : unsigned char { afAccept, afCancel, afStop };

typedef void __fastcall (__closure *TOnOSMBlockRead)(const int percentage, bool &cancel);

typedef void __fastcall (__closure *TOnSaveToShapes)(Uecnativeshape::TECShapes* const Shapes);

typedef void __fastcall (__closure *TOnParseOSMFile)(void);

typedef void __fastcall (*TFilterKeyValue)(const System::UnicodeString key, const System::UnicodeString value, bool &cancel);

typedef System::DynamicArray<unsigned> TKeyValuePair;

typedef double TOSMLatLng;

typedef int TOSMIntLatLng;

typedef System::Classes::TStringList TOSMStringList;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TFilterOSM : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FKey;
	System::UnicodeString FValue;
	int FIdKey;
	int FIdValue;
	bool FisInclude;
	virtual TActionOSMFilter __fastcall Filter(TOSMFile* const OSMFile, TBaseOSM* const OSMElement);
	
public:
	__fastcall TFilterOSM(const System::UnicodeString key, const System::UnicodeString value, bool IsInclude);
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TFilterOSM() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TOnlyThisFilterOSM : public TFilterOSM
{
	typedef TFilterOSM inherited;
	
private:
	virtual TActionOSMFilter __fastcall Filter(TOSMFile* const OSMFile, TBaseOSM* const OSMElement);
public:
	/* TFilterOSM.Create */ inline __fastcall TOnlyThisFilterOSM(const System::UnicodeString key, const System::UnicodeString value, bool IsInclude) : TFilterOSM(key, value, IsInclude) { }
	
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TOnlyThisFilterOSM() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TExcludeThisFilterOSM : public TFilterOSM
{
	typedef TFilterOSM inherited;
	
private:
	virtual TActionOSMFilter __fastcall Filter(TOSMFile* const OSMFile, TBaseOSM* const OSMElement);
public:
	/* TFilterOSM.Create */ inline __fastcall TExcludeThisFilterOSM(const System::UnicodeString key, const System::UnicodeString value, bool IsInclude) : TFilterOSM(key, value, IsInclude) { }
	
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TExcludeThisFilterOSM() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TListFilterOSM : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::Classes::TList* FList;
	TActionOSMFilter __fastcall Filter(TOSMFile* const OSMFile, TBaseOSM* const OSMElement);
	
public:
	__fastcall TListFilterOSM();
	__fastcall virtual ~TListFilterOSM();
	bool __fastcall Active();
	void __fastcall Clear();
	void __fastcall Add(TFilterOSM* const FilterOSM);
	void __fastcall ExcludeKeyValue(const System::UnicodeString key, const System::UnicodeString value);
	void __fastcall OnlyKeyValue(const System::UnicodeString key, const System::UnicodeString value);
	void __fastcall ExcludeIfKeyExist(const System::UnicodeString key);
	void __fastcall OnlyIfKeyExist(const System::UnicodeString key);
};

#pragma pack(pop)

enum DECLSPEC_DENUM TBoundsPosition : unsigned char { bpInclude, bpExclude };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TFilterBounds : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	Uecmaputil::TArrayBoundsLatLng FABoundsLatLng;
	TBoundsPosition FBoundsPosition;
	
public:
	__fastcall TFilterBounds();
	void __fastcall Clear();
	void __fastcall Add(double NELat, double NELng, double SWLat, double SWLng);
	bool __fastcall Get(const int index, double &NELat, double &NELng, double &SWLat, double &SWLng);
	int __fastcall Count();
	bool __fastcall IsValidPosition(const double Lat, const double Lng);
	bool __fastcall IsValidArea(const double SWLat, const double SWLng, const double NELat, const double NELng);
	__property TBoundsPosition BoundsPosition = {read=FBoundsPosition, write=FBoundsPosition, nodefault};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TFilterBounds() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TBaseOSM : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	__int64 Id;
	TKeyValuePair KeyValues;
	void __fastcall addKeyValue(const unsigned key, const unsigned value);
public:
	/* TObject.Create */ inline __fastcall TBaseOSM() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TBaseOSM() { }
	
};


class PASCALIMPLEMENTATION TNodeOSM : public TBaseOSM
{
	typedef TBaseOSM inherited;
	
public:
	TOSMLatLng Lat;
	TOSMLatLng Lng;
	System::Byte Junction;
public:
	/* TObject.Create */ inline __fastcall TNodeOSM() : TBaseOSM() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TNodeOSM() { }
	
};


typedef void __fastcall (*TOnOSMFilter)(TOSMFile* const OSMFile, TBaseOSM* const OSMElement, TActionOSMFilter &action);

class PASCALIMPLEMENTATION TNodeGeo : public TNodeOSM
{
	typedef TNodeOSM inherited;
	
public:
	/* TObject.Create */ inline __fastcall TNodeGeo() : TNodeOSM() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TNodeGeo() { }
	
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TListNodeGeo : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TNodeGeo* operator[](int index) { return this->NodeGeo[index]; }
	
private:
	System::Generics::Collections::TList__1<TNodeGeo*>* FList;
	TNodeGeo* __fastcall getNode(int index);
	System::UnicodeString __fastcall EncodeGeometry(const System::Byte EncodePrecision = (System::Byte)(0x6));
	void __fastcall DecodeGeometry(const System::UnicodeString value, const System::Byte EncodePrecision = (System::Byte)(0x6));
	
public:
	__fastcall virtual ~TListNodeGeo();
	__fastcall TListNodeGeo();
	int __fastcall Count();
	void __fastcall Delete(int index);
	void __fastcall Add(TBaseOSM* Node);
	void __fastcall Clear();
	__property TNodeGeo* NodeGeo[int index] = {read=getNode/*, default*/};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TListNodeOSM : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	TNodeOSM* operator[](int index) { return this->NodeOSM[index]; }
	
private:
	TUniqueStringList* FKeyList;
	TUniqueStringList* FValueList;
	TNodeOSM* __fastcall getNode(int index);
	System::UnicodeString __fastcall NodesToGeoJSON(TUniqueStringList* const FKeyList, TUniqueStringList* const FValueList, System::Classes::TStream* const FileStream = (System::Classes::TStream*)(0x0));
	
public:
	__fastcall TListNodeOSM(TUniqueStringList* KeyList, TUniqueStringList* ValueList);
	void __fastcall TOShapes(Uecnativeshape::TECShapes* const Shapes);
	System::UnicodeString __fastcall ToGeoJSON();
	TNodeOSM* __fastcall Find(const __int64 idkey);
	__property TNodeOSM* NodeOSM[int index] = {read=getNode/*, default*/};
public:
	/* TList.Destroy */ inline __fastcall virtual ~TListNodeOSM() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TWayOSM : public TBaseOSM
{
	typedef TBaseOSM inherited;
	
public:
	Uecmaputil::TBoundsLatLng Bounds;
	TListNodeGeo* Nodes;
	__fastcall TWayOSM();
	__fastcall virtual ~TWayOSM();
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TListWayOSM : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	TWayOSM* operator[](int index) { return this->WayOSM[index]; }
	
private:
	TUniqueStringList* FKeyList;
	TUniqueStringList* FValueList;
	TWayOSM* __fastcall getWay(int index);
	
public:
	__fastcall TListWayOSM(TUniqueStringList* KeyList, TUniqueStringList* ValueList);
	void __fastcall TOShapes(Uecnativeshape::TECShapes* const Shapes);
	System::UnicodeString __fastcall ToGeoJSON(System::Classes::TFileStream* const FileStream = (System::Classes::TFileStream*)(0x0));
	__property TWayOSM* WayOSM[int index] = {read=getWay/*, default*/};
public:
	/* TList.Destroy */ inline __fastcall virtual ~TListWayOSM() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TMemberOSM : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TPrimitiveOSM EType;
	__int64 Ref;
	unsigned idRole;
public:
	/* TObject.Create */ inline __fastcall TMemberOSM() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TMemberOSM() { }
	
};


class PASCALIMPLEMENTATION TRelationOSM : public TBaseOSM
{
	typedef TBaseOSM inherited;
	
public:
	TMemberOSM* operator[](int index) { return this->Member[index]; }
	
private:
	System::Classes::TList* FList;
	bool FComplete;
	TMemberOSM* __fastcall getMemberOSM(int index);
	
public:
	__fastcall TRelationOSM();
	__fastcall virtual ~TRelationOSM();
	void __fastcall Clear();
	int __fastcall Count();
	void __fastcall Add(TMemberOSM* const Member);
	__property bool Complete = {read=FComplete, nodefault};
	__property TMemberOSM* Member[int index] = {read=getMemberOSM/*, default*/};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TListRelationOSM : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	TRelationOSM* operator[](const int index) { return this->Relations[index]; }
	
private:
	TRelationOSM* __fastcall getRelation(const int index);
	
public:
	__property TRelationOSM* Relations[const int index] = {read=getRelation/*, default*/};
public:
	/* TList.Destroy */ inline __fastcall virtual ~TListRelationOSM() { }
	
public:
	/* TObject.Create */ inline __fastcall TListRelationOSM() : System::Classes::TList() { }
	
};

#pragma pack(pop)

typedef System::DynamicArray<int> TArrayOfValues;

class PASCALIMPLEMENTATION TOSMSearch : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	Uecmaputil::TBoundsLatLng Bounds;
	__int64 key;
	TArrayOfValues Values;
public:
	/* TObject.Create */ inline __fastcall TOSMSearch() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TOSMSearch() { }
	
};


class PASCALIMPLEMENTATION TSubNodeList : public System::Classes::TStringList
{
	typedef System::Classes::TStringList inherited;
	
private:
	int __fastcall FindNodeOSMByArea(const double SWLat, const double SWLng, const double NELat, const double NELng, TListNodeOSM* const List);
	TNodeOSM* __fastcall FindNodeOSM(const System::UnicodeString key)/* overload */;
	TNodeOSM* __fastcall FindNodeOSM(const __int64 idkey)/* overload */;
	int __fastcall FindNodeOSM(TOSMSearch* const Search, TListNodeOSM* const List)/* overload */;
	System::UnicodeString __fastcall ToGeoJSON(TUniqueStringList* const FKeyList, TUniqueStringList* const FValueList, System::Classes::TStream* const FileStream = (System::Classes::TStream*)(0x0));
	void __fastcall TOShapes(TUniqueStringList* const FKeyList, TUniqueStringList* const FValueList, Uecnativeshape::TECShapes* const Shapes);
	System::UnicodeString __fastcall ToOLT(System::Classes::TStream* const FileStream = (System::Classes::TStream*)(0x0));
	
public:
	virtual bool __fastcall Find(const System::UnicodeString S, int &index);
	virtual void __fastcall Sort();
public:
	/* TStringList.Create */ inline __fastcall TSubNodeList()/* overload */ : System::Classes::TStringList() { }
	/* TStringList.Create */ inline __fastcall TSubNodeList(bool OwnsObjects)/* overload */ : System::Classes::TStringList(OwnsObjects) { }
	/* TStringList.Create */ inline __fastcall TSubNodeList(System::WideChar QuoteChar, System::WideChar Delimiter)/* overload */ : System::Classes::TStringList(QuoteChar, Delimiter) { }
	/* TStringList.Create */ inline __fastcall TSubNodeList(System::WideChar QuoteChar, System::WideChar Delimiter, System::Classes::TStringsOptions Options)/* overload */ : System::Classes::TStringList(QuoteChar, Delimiter, Options) { }
	/* TStringList.Create */ inline __fastcall TSubNodeList(System::Classes::TDuplicates Duplicates, bool Sorted, bool CaseSensitive)/* overload */ : System::Classes::TStringList(Duplicates, Sorted, CaseSensitive) { }
	/* TStringList.Create */ inline __fastcall TSubNodeList(System::Classes::TStringsOptions Options, System::Classes::TDuplicates Duplicates)/* overload */ : System::Classes::TStringList(Options, Duplicates) { }
	/* TStringList.Destroy */ inline __fastcall virtual ~TSubNodeList() { }
	
};


class PASCALIMPLEMENTATION TSubWayList : public System::Classes::TStringList
{
	typedef System::Classes::TStringList inherited;
	
private:
	TWayOSM* __fastcall FindWayOSM(const System::UnicodeString key)/* overload */;
	TWayOSM* __fastcall FindWayOSM(const __int64 idkey)/* overload */;
	int __fastcall FindWayOSM(TOSMSearch* const Search, TListWayOSM* const List)/* overload */;
	int __fastcall FindWayOSMByArea(const double SWLat, const double SWLng, const double NELat, const double NELng, TListWayOSM* const List);
	System::UnicodeString __fastcall ToGeoJSON(TUniqueStringList* const FKeyList, TUniqueStringList* const FValueList, System::Classes::TStream* const FileStream = (System::Classes::TStream*)(0x0));
	void __fastcall TOShapes(TUniqueStringList* const FKeyList, TUniqueStringList* const FValueList, Uecnativeshape::TECShapes* const Shapes);
	System::UnicodeString __fastcall ToOLT(TUniqueStringList* const FKeyList, TUniqueStringList* const FValueList, System::Classes::TStream* const FileStream = (System::Classes::TStream*)(0x0));
	
public:
	virtual bool __fastcall Find(const System::UnicodeString S, int &index);
	virtual void __fastcall Sort();
public:
	/* TStringList.Create */ inline __fastcall TSubWayList()/* overload */ : System::Classes::TStringList() { }
	/* TStringList.Create */ inline __fastcall TSubWayList(bool OwnsObjects)/* overload */ : System::Classes::TStringList(OwnsObjects) { }
	/* TStringList.Create */ inline __fastcall TSubWayList(System::WideChar QuoteChar, System::WideChar Delimiter)/* overload */ : System::Classes::TStringList(QuoteChar, Delimiter) { }
	/* TStringList.Create */ inline __fastcall TSubWayList(System::WideChar QuoteChar, System::WideChar Delimiter, System::Classes::TStringsOptions Options)/* overload */ : System::Classes::TStringList(QuoteChar, Delimiter, Options) { }
	/* TStringList.Create */ inline __fastcall TSubWayList(System::Classes::TDuplicates Duplicates, bool Sorted, bool CaseSensitive)/* overload */ : System::Classes::TStringList(Duplicates, Sorted, CaseSensitive) { }
	/* TStringList.Create */ inline __fastcall TSubWayList(System::Classes::TStringsOptions Options, System::Classes::TDuplicates Duplicates)/* overload */ : System::Classes::TStringList(Options, Duplicates) { }
	/* TStringList.Destroy */ inline __fastcall virtual ~TSubWayList() { }
	
};


class PASCALIMPLEMENTATION TSubRelationList : public System::Classes::TStringList
{
	typedef System::Classes::TStringList inherited;
	
private:
	TRelationOSM* __fastcall FindRelationOSM(const System::UnicodeString idRelation)/* overload */;
	TRelationOSM* __fastcall FindRelationOSM(const __int64 idRelation)/* overload */;
	int __fastcall FindRelationOSM(TOSMSearch* const Search, TListRelationOSM* const List)/* overload */;
	System::UnicodeString __fastcall ToOLT(TUniqueStringList* const FKeyList, TUniqueStringList* const FValueList, System::Classes::TStream* const FileStream = (System::Classes::TStream*)(0x0));
	
public:
	virtual bool __fastcall Find(const System::UnicodeString S, int &index);
	virtual void __fastcall Sort();
public:
	/* TStringList.Create */ inline __fastcall TSubRelationList()/* overload */ : System::Classes::TStringList() { }
	/* TStringList.Create */ inline __fastcall TSubRelationList(bool OwnsObjects)/* overload */ : System::Classes::TStringList(OwnsObjects) { }
	/* TStringList.Create */ inline __fastcall TSubRelationList(System::WideChar QuoteChar, System::WideChar Delimiter)/* overload */ : System::Classes::TStringList(QuoteChar, Delimiter) { }
	/* TStringList.Create */ inline __fastcall TSubRelationList(System::WideChar QuoteChar, System::WideChar Delimiter, System::Classes::TStringsOptions Options)/* overload */ : System::Classes::TStringList(QuoteChar, Delimiter, Options) { }
	/* TStringList.Create */ inline __fastcall TSubRelationList(System::Classes::TDuplicates Duplicates, bool Sorted, bool CaseSensitive)/* overload */ : System::Classes::TStringList(Duplicates, Sorted, CaseSensitive) { }
	/* TStringList.Create */ inline __fastcall TSubRelationList(System::Classes::TStringsOptions Options, System::Classes::TDuplicates Duplicates)/* overload */ : System::Classes::TStringList(Options, Duplicates) { }
	/* TStringList.Destroy */ inline __fastcall virtual ~TSubRelationList() { }
	
};


class PASCALIMPLEMENTATION TRelationMultList : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TRelationOSM* operator[](System::LongInt index) { return this->RelationOSM[index]; }
	
private:
	Uecmaputil::TBoundsLatLng FBounds;
	TSubRelationList* FLastList;
	TOSMSearch* FSearch;
	TOSMStringList* FMultList;
	TListRelationOSM* FFindRelationList;
	TUniqueStringList* FKeyList;
	TUniqueStringList* FValueList;
	TRelationOSM* __fastcall Get(System::LongInt index);
	void __fastcall removeLast();
	System::UnicodeString __fastcall ToOLT(System::Classes::TStream* const FileStream = (System::Classes::TStream*)(0x0));
	
public:
	__fastcall TRelationMultList(TUniqueStringList* KeyList, TUniqueStringList* ValueList);
	__fastcall virtual ~TRelationMultList();
	void __fastcall Add(const System::UnicodeString key, TRelationOSM* Node);
	void __fastcall Clear();
	void __fastcall Delete(const System::UnicodeString key);
	System::UnicodeString __fastcall ReadKey(const int iRelation, const System::UnicodeString KeyName);
	int __fastcall ReadValuesForKey(const System::UnicodeString KeyName, System::Classes::TStringList* valuesList);
	TRelationOSM* __fastcall Find(const System::UnicodeString idRelation)/* overload */;
	TRelationOSM* __fastcall Find(const __int64 idRelation)/* overload */;
	int __fastcall Search(const System::UnicodeString key, const System::UnicodeString Values)/* overload */;
	int __fastcall Search(const System::UnicodeString key)/* overload */;
	System::LongInt __fastcall Count();
	__property Uecmaputil::TBoundsLatLng Bounds = {read=FBounds};
	__property TRelationOSM* RelationOSM[System::LongInt index] = {read=Get/*, default*/};
};


class PASCALIMPLEMENTATION TNodeMultList : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TNodeOSM* operator[](System::LongInt index) { return this->NodeOSM[index]; }
	
private:
	TSubNodeList* FLastList;
	Uecmaputil::TBoundsLatLng FBounds;
	TOSMSearch* FSearch;
	TOSMStringList* FMultList;
	TListNodeOSM* FFindNodeList;
	TUniqueStringList* FKeyList;
	TUniqueStringList* FValueList;
	TNodeOSM* __fastcall Get(System::LongInt index);
	void __fastcall removeLast(bool FreeNode = true);
	System::UnicodeString __fastcall ToGeoJSON(System::Classes::TStream* const FileStream = (System::Classes::TStream*)(0x0));
	System::UnicodeString __fastcall ToOLT(System::Classes::TStream* const FileStream = (System::Classes::TStream*)(0x0));
	void __fastcall TOShapes(Uecnativeshape::TECShapes* const Shapes);
	
public:
	__fastcall TNodeMultList(TUniqueStringList* KeyList, TUniqueStringList* ValueList);
	__fastcall virtual ~TNodeMultList();
	void __fastcall Add(const System::UnicodeString key, TNodeOSM* Node);
	void __fastcall Clear();
	void __fastcall Delete(const System::UnicodeString key);
	System::UnicodeString __fastcall ReadKey(const int iNode, const System::UnicodeString KeyName);
	int __fastcall ReadValuesForKey(const System::UnicodeString KeyName, System::Classes::TStringList* valuesList);
	TNodeOSM* __fastcall Find(const System::UnicodeString IdNode)/* overload */;
	TNodeOSM* __fastcall Find(const __int64 IdNode)/* overload */;
	int __fastcall Search(const double Lat, const double Lng, const double radiusKM)/* overload */;
	int __fastcall Search(const double SWLat, const double SWLng, const double NELat, const double NELng)/* overload */;
	int __fastcall Search(const double SWLat, const double SWLng, const double NELat, const double NELng, const System::UnicodeString key, const System::UnicodeString Values)/* overload */;
	int __fastcall Search(const System::UnicodeString key, const System::UnicodeString Values)/* overload */;
	int __fastcall Search(const System::UnicodeString key)/* overload */;
	System::LongInt __fastcall Count();
	__property Uecmaputil::TBoundsLatLng Bounds = {read=FBounds};
	__property TNodeOSM* NodeOSM[System::LongInt index] = {read=Get/*, default*/};
	__property TListNodeOSM* SearchResult = {read=FFindNodeList};
};


class PASCALIMPLEMENTATION TWayMultList : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TWayOSM* operator[](System::LongInt index) { return this->WayOSM[index]; }
	
private:
	Uecmaputil::TBoundsLatLng FBounds;
	TSubWayList* FLastList;
	TOSMSearch* FSearch;
	TOSMStringList* FMultList;
	TListWayOSM* FFindWayList;
	TNodeMultList* FNodeList;
	TUniqueStringList* FKeyList;
	TUniqueStringList* FValueList;
	void __fastcall removeLast();
	TWayOSM* __fastcall Get(System::LongInt index);
	System::UnicodeString __fastcall ToGeoJSON(System::Classes::TStream* const FileStream = (System::Classes::TStream*)(0x0));
	System::UnicodeString __fastcall ToOLT(System::Classes::TStream* const FileStream = (System::Classes::TStream*)(0x0));
	void __fastcall TOShapes(Uecnativeshape::TECShapes* const Shapes);
	
public:
	__fastcall TWayMultList(TNodeMultList* NodeList, TUniqueStringList* KeyList, TUniqueStringList* ValueList);
	__fastcall virtual ~TWayMultList();
	void __fastcall Add(const System::UnicodeString key, TWayOSM* Way);
	void __fastcall Clear();
	void __fastcall Delete(const System::UnicodeString key);
	System::UnicodeString __fastcall ReadKey(const int iWay, const System::UnicodeString KeyName);
	int __fastcall ReadValuesForKey(const System::UnicodeString KeyName, System::Classes::TStringList* valuesList);
	TWayOSM* __fastcall Find(const System::UnicodeString idWay)/* overload */;
	TWayOSM* __fastcall Find(const __int64 idWay)/* overload */;
	int __fastcall Search(const double Lat, const double Lng, const double radiusKM)/* overload */;
	int __fastcall Search(const double SWLat, const double SWLng, const double NELat, const double NELng)/* overload */;
	int __fastcall Search(const double SWLat, const double SWLng, const double NELat, const double NELng, const System::UnicodeString key, const System::UnicodeString Values)/* overload */;
	int __fastcall Search(const System::UnicodeString key, const System::UnicodeString Values)/* overload */;
	int __fastcall Search(const System::UnicodeString key)/* overload */;
	System::LongInt __fastcall Count();
	__property Uecmaputil::TBoundsLatLng Bounds = {read=FBounds};
	__property TWayOSM* WayOSM[System::LongInt index] = {read=Get/*, default*/};
	__property TListWayOSM* SearchResult = {read=FFindWayList};
};


typedef TNodeMultList TNodeList;

typedef TWayMultList TWayList;

typedef TRelationMultList TRelationList;

class PASCALIMPLEMENTATION TThreadSaveOSMFile : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	System::Classes::TNotifyEvent FNotifyEvent;
	TOSMFile* FOSMFile;
	System::UnicodeString FFilename;
	void __fastcall doNotify();
	
protected:
	virtual void __fastcall Execute();
	
public:
	__fastcall TThreadSaveOSMFile(const System::UnicodeString Filename, TOSMFile* OSMFile, System::Classes::TNotifyEvent Notify);
public:
	/* TThread.Destroy */ inline __fastcall virtual ~TThreadSaveOSMFile() { }
	
};


class PASCALIMPLEMENTATION TThreadOSMToOLT : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	System::Classes::TNotifyEvent FNotifyEvent;
	TOSMFile* FOSMFile;
	System::UnicodeString FFilename;
	bool FinSave;
	void __fastcall doNotify();
	virtual void __fastcall doLoad(System::TObject* sender);
	
protected:
	virtual void __fastcall Execute();
	
public:
	__fastcall TThreadOSMToOLT(const System::UnicodeString Filename, TSetPrimitiveOSM Primitives, __int64 MaxBytesBeforeReduceMemory, System::Classes::TNotifyEvent Notify);
	void __fastcall Abort();
public:
	/* TThread.Destroy */ inline __fastcall virtual ~TThreadOSMToOLT() { }
	
};


class PASCALIMPLEMENTATION TThreadOSMToShapes : public TThreadOSMToOLT
{
	typedef TThreadOSMToOLT inherited;
	
private:
	Uecnativeshape::TECShapes* FShapes;
	virtual void __fastcall doLoad(System::TObject* sender);
	
public:
	__fastcall TThreadOSMToShapes(const System::UnicodeString Filename, TSetPrimitiveOSM Primitives, Uecnativeshape::TECShapes* Shapes, __int64 MaxBytesBeforeReduceMemory, System::Classes::TNotifyEvent Notify);
public:
	/* TThread.Destroy */ inline __fastcall virtual ~TThreadOSMToShapes() { }
	
};


class PASCALIMPLEMENTATION TThreadSaveOSMShapes : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	System::Classes::TNotifyEvent FNotifyEvent;
	TOnSaveToShapes FSaveToshapes;
	TOSMFile* FOSMFile;
	Uecnativeshape::TECShapes* FShapes;
	void __fastcall doNotify();
	
protected:
	virtual void __fastcall Execute();
	
public:
	__fastcall TThreadSaveOSMShapes(Uecnativeshape::TECShapes* Shapes, TOSMFile* OSMFile, TOnSaveToShapes SaveToshapes, System::Classes::TNotifyEvent Notify);
public:
	/* TThread.Destroy */ inline __fastcall virtual ~TThreadSaveOSMShapes() { }
	
};


class PASCALIMPLEMENTATION TThreadSaveOSMStream : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	System::Classes::TNotifyEvent FNotifyEvent;
	TOSMFile* FOSMFile;
	System::Classes::TStream* FStream;
	void __fastcall doNotify();
	
protected:
	virtual void __fastcall Execute();
	
public:
	__fastcall TThreadSaveOSMStream(System::Classes::TStream* const Stream, TOSMFile* OSMFile, System::Classes::TNotifyEvent Notify);
public:
	/* TThread.Destroy */ inline __fastcall virtual ~TThreadSaveOSMStream() { }
	
};


class PASCALIMPLEMENTATION TThreadParceOSMFile : public System::Classes::TThread
{
	typedef System::Classes::TThread inherited;
	
private:
	System::Classes::TNotifyEvent FNotifyEvent;
	TOSMFile* FOSMFile;
	TOnParseOSMFile FParse;
	void __fastcall doBlockRead(System::TObject* sender);
	void __fastcall doEndParse();
	
protected:
	virtual void __fastcall Execute();
	
public:
	__fastcall TThreadParceOSMFile(TOSMFile* OSMFile, TOnParseOSMFile Parse, System::Classes::TNotifyEvent Notify);
public:
	/* TThread.Destroy */ inline __fastcall virtual ~TThreadParceOSMFile() { }
	
};


class PASCALIMPLEMENTATION TPositionId : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	__int64 Id;
public:
	/* TObject.Create */ inline __fastcall TPositionId() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TPositionId() { }
	
};


class PASCALIMPLEMENTATION TUniqueStringId : public System::Classes::TStringList
{
	typedef System::Classes::TStringList inherited;
	
public:
	__int64 __fastcall GetID(const System::UnicodeString value);
	void __fastcall AddID(const System::UnicodeString value, __int64 Id);
	virtual void __fastcall Clear();
	virtual bool __fastcall Find(const System::UnicodeString S, int &index);
	__fastcall virtual ~TUniqueStringId();
public:
	/* TStringList.Create */ inline __fastcall TUniqueStringId()/* overload */ : System::Classes::TStringList() { }
	/* TStringList.Create */ inline __fastcall TUniqueStringId(bool OwnsObjects)/* overload */ : System::Classes::TStringList(OwnsObjects) { }
	/* TStringList.Create */ inline __fastcall TUniqueStringId(System::WideChar QuoteChar, System::WideChar Delimiter)/* overload */ : System::Classes::TStringList(QuoteChar, Delimiter) { }
	/* TStringList.Create */ inline __fastcall TUniqueStringId(System::WideChar QuoteChar, System::WideChar Delimiter, System::Classes::TStringsOptions Options)/* overload */ : System::Classes::TStringList(QuoteChar, Delimiter, Options) { }
	/* TStringList.Create */ inline __fastcall TUniqueStringId(System::Classes::TDuplicates Duplicates, bool Sorted, bool CaseSensitive)/* overload */ : System::Classes::TStringList(Duplicates, Sorted, CaseSensitive) { }
	/* TStringList.Create */ inline __fastcall TUniqueStringId(System::Classes::TStringsOptions Options, System::Classes::TDuplicates Duplicates)/* overload */ : System::Classes::TStringList(Options, Duplicates) { }
	
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TUniqueStringList : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::UnicodeString operator[](int index) { return this->Strings[index]; }
	
private:
	int fkey_area;
	int fkey_amenity;
	int fkey_power;
	int fkey_border_type;
	int fkey_natural;
	int fkey_highway;
	int fkey_waterway;
	int fkey_barrier;
	int fkey_boundary;
	int fkey_leisure;
	int fkey_building;
	int fkey_landuse;
	int fkey_man_made;
	int fkey_aeroway;
	int fkey_railway;
	int fvalue_empty;
	int fvalue_river;
	int fvalue_brook;
	int fvalue_stream;
	int fvalue_drain;
	int fvalue_ditch;
	int fvalue_weir;
	int fvalue_tree_row;
	int fkey_name;
	int fkey_address;
	int fkey_hamlet;
	int fkey_locality;
	int fkey_village;
	int fkey_suburb;
	int fkey_town;
	int fkey_addr_housenumber;
	int fvalue_yes;
	TOSMStringList* FStrings;
	TUniqueStringId* FUniqueStrings;
	System::UnicodeString __fastcall Get(int index);
	__int64 __fastcall GetID(System::UnicodeString value);
	void __fastcall Add(System::UnicodeString value);
	void __fastcall Clear();
	void __fastcall ClearCache();
	__property __int64 Id[System::UnicodeString value] = {read=GetID};
	
public:
	__fastcall TUniqueStringList();
	__fastcall virtual ~TUniqueStringList();
	void __fastcall UpdateSpecialKeyValues();
	int __fastcall Count();
	void __fastcall getStrings(System::Classes::TStrings* const List);
	int __fastcall indexOf(const System::UnicodeString S);
	__property System::UnicodeString Strings[int index] = {read=Get/*, default*/};
	__property int key_name = {read=fkey_name, nodefault};
	__property int key_address = {read=fkey_address, nodefault};
	__property int key_hamlet = {read=fkey_hamlet, nodefault};
	__property int key_locality = {read=fkey_locality, nodefault};
	__property int key_village = {read=fkey_village, nodefault};
	__property int key_suburb = {read=fkey_suburb, nodefault};
	__property int key_town = {read=fkey_town, nodefault};
	__property int key_addr_housenumber = {read=fkey_addr_housenumber, nodefault};
	__property int value_yes = {read=fvalue_yes, nodefault};
	__property int key_area = {read=fkey_area, nodefault};
	__property int key_amenity = {read=fkey_amenity, nodefault};
	__property int key_power = {read=fkey_power, nodefault};
	__property int key_border_type = {read=fkey_border_type, nodefault};
	__property int key_natural = {read=fkey_natural, nodefault};
	__property int key_highway = {read=fkey_highway, nodefault};
	__property int key_waterway = {read=fkey_waterway, nodefault};
	__property int key_barrier = {read=fkey_barrier, nodefault};
	__property int key_boundary = {read=fkey_boundary, nodefault};
	__property int key_leisure = {read=fkey_leisure, nodefault};
	__property int key_building = {read=fkey_building, nodefault};
	__property int key_landuse = {read=fkey_landuse, nodefault};
	__property int key_man_made = {read=fkey_man_made, nodefault};
	__property int key_aeroway = {read=fkey_aeroway, nodefault};
	__property int key_railway = {read=fkey_railway, nodefault};
	__property int value_empty = {read=fvalue_empty, nodefault};
	__property int value_brook = {read=fvalue_brook, nodefault};
	__property int value_stream = {read=fvalue_stream, nodefault};
	__property int value_drain = {read=fvalue_drain, nodefault};
	__property int value_ditch = {read=fvalue_ditch, nodefault};
	__property int value_weir = {read=fvalue_weir, nodefault};
	__property int value_river = {read=fvalue_river, nodefault};
	__property int value_tree_row = {read=fvalue_tree_row, nodefault};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TOSMFile : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::WideChar Quote_Car;
	Uecnativeshape::TECShapes* FShapes;
	bool FSaveOltData;
	System::Classes::TMemoryStream* FMemoryStreamOSMtoOLT;
	__int64 FMaxBytesBeforeReduceMemory;
	TFileTypeOSM FFileTypeOSM;
	TThreadParceOSMFile* FThreadParceOSMFile;
	TListFilterOSM* FFilterNode;
	TListFilterOSM* FFilterWay;
	TListFilterOSM* FFilterRelation;
	TFilterBounds* FFilterBounds;
	TSetPrimitiveOSM FFilterPrimitive;
	System::Classes::TNotifyEvent FOnParse;
	System::Classes::TNotifyEvent FOnFillBuffet;
	TOnOSMBlockRead FOnBlockRead;
	double FOltVersion;
	int FTagCount;
	Uecmaputil::TBoundsLatLng FBounds;
	System::UnicodeString FTimestamp;
	TPrimitiveOSM FBlockOSM;
	TBlockOLT FBlockOLT;
	int FMaxTagByElement;
	TNodeOSM* FNode;
	TWayOSM* FWay;
	TRelationOSM* FRelation;
	TUniqueStringList* FValueList;
	TUniqueStringList* FKeyList;
	TNodeList* FNodeList;
	TWayList* FWayList;
	TRelationList* FRelationList;
	__int64 FOffsetFile;
	__int64 FileLength;
	__int64 iReaded;
	bool FClearAfterToShapes;
	int FOffsetStringBuffet;
	int FBuffetSize;
	int FbuffetReadSize;
	System::Classes::TStream* OSMFileStream;
	System::Sysutils::TBytes FBytesBuffet;
	System::UnicodeString FStringBuffet;
	System::WideChar *FPStringBuffet;
	bool FInReload;
	bool FInParsing;
	bool FInFindSave;
	bool FinSave;
	bool FCancelParse;
	System::UnicodeString FTag;
	System::UnicodeString FFilename;
	TFileTypeOSM __fastcall getFileTypeOSM(const System::UnicodeString Filename);
	System::UnicodeString __fastcall getRole(TMemberOSM* Member);
	int __fastcall getIDKey(const System::UnicodeString KeyName);
	int __fastcall getIDValue(const System::UnicodeString ValueName);
	void __fastcall setBuffetSize(const int value);
	bool __fastcall FillBuffet();
	void __fastcall ClearBlocks();
	void __fastcall doBlockRead();
	void __fastcall doEndParse(System::TObject* sender);
	bool __fastcall LoadOsmAndConvertOlt(const System::UnicodeString sFilename);
	void __fastcall doSaveString(const System::UnicodeString S, System::Classes::TStream* const FileStream);
	void __fastcall doSaveToFile(const System::UnicodeString Filename);
	void __fastcall doSaveToStream(System::Classes::TStream* const Stream);
	void __fastcall doSaveToShapes(Uecnativeshape::TECShapes* const Shapes);
	void __fastcall doFindSaveToShapes(Uecnativeshape::TECShapes* const Shapes);
	void __fastcall doSaveToJSONStream(System::Classes::TStream* const FileStream);
	void __fastcall doSaveToOLTStream(System::Classes::TStream* const FileStream);
	bool __fastcall CheckSignatureOLT();
	bool __fastcall ReadLineOLT();
	void __fastcall ParseOLT();
	bool __fastcall ASyncParseOLT();
	bool __fastcall ASyncParseOLTToShapes();
	void __fastcall NodeTOShapes(TNodeOSM* Node, Uecnativeshape::TECShapes* const Shapes);
	void __fastcall WayTOShapes(TWayOSM* Way, Uecnativeshape::TECShapes* const Shapes);
	void __fastcall ParseOLTToShapes();
	int __fastcall getMaxTagByElement();
	void __fastcall setMaxTagByElement(const int value);
	void __fastcall ParseOSM();
	void __fastcall ParseOSMToShapes();
	bool __fastcall ASyncParseOSM();
	bool __fastcall ASyncParseOSMToShapes();
	TTagOSM __fastcall ReadTagOSM();
	bool __fastcall CheckSignatureOSM();
	__property System::Classes::TNotifyEvent OnFillBuffet = {read=FOnFillBuffet, write=FOnFillBuffet};
	__property System::UnicodeString Tag = {read=FTag};
	
public:
	__fastcall TOSMFile();
	__fastcall virtual ~TOSMFile();
	bool __fastcall isReadyToLoad();
	bool __fastcall LoadFromFile(const System::UnicodeString sFilename, Uecnativeshape::TECShapes* const Shapes = (Uecnativeshape::TECShapes*)(0x0), bool SaveOltData = false);
	bool __fastcall LoadFromStream(System::Classes::TStream* const OSMStream, Uecnativeshape::TECShapes* const Shapes = (Uecnativeshape::TECShapes*)(0x0), bool SaveOltData = false);
	bool __fastcall LoadFromString(const System::UnicodeString OSMData, Uecnativeshape::TECShapes* const Shapes = (Uecnativeshape::TECShapes*)(0x0), bool SaveOltData = false);
	bool __fastcall ReLoad(Uecnativeshape::TECShapes* const AShapes = (Uecnativeshape::TECShapes*)(0x0));
	void __fastcall Clear();
	void __fastcall Abort();
	void __fastcall TOShapes(Uecnativeshape::TECShapes* Shapes, System::Classes::TNotifyEvent NotifyEvent = 0x0);
	void __fastcall FindToShapes(Uecnativeshape::TECShapes* Shapes, System::Classes::TNotifyEvent NotifyEvent = 0x0);
	void __fastcall saveToFile(const System::UnicodeString Filename, System::Classes::TNotifyEvent NotifyEvent = 0x0);
	void __fastcall SaveToStream(System::Classes::TStream* const Stream, System::Classes::TNotifyEvent NotifyEvent = 0x0);
	System::UnicodeString __fastcall ToGeoJSON();
	System::UnicodeString __fastcall SearchToGeoJSON();
	int __fastcall CountKey(TBaseOSM* Node);
	System::UnicodeString __fastcall getKey(TBaseOSM* Node, const int index);
	System::UnicodeString __fastcall getValue(TBaseOSM* Node, const int index);
	int __fastcall ReadKey(TBaseOSM* Node, const int idkey)/* overload */;
	System::UnicodeString __fastcall ReadKey(TBaseOSM* Node, const System::UnicodeString KeyName)/* overload */;
	System::UnicodeString __fastcall ReadKey(TBaseOSM* Node)/* overload */;
	int __fastcall ReadValuesForKey(const System::UnicodeString KeyName, System::Classes::TStringList* valuesList);
	__property bool Aborted = {read=FCancelParse, nodefault};
	__property Uecmaputil::TBoundsLatLng Bounds = {read=FBounds};
	__property double OltVersion = {read=FOltVersion};
	__property TFileTypeOSM FileFormat = {read=FFileTypeOSM, nodefault};
	__property System::UnicodeString Filename = {read=FFilename};
	__property __int64 FileSize = {read=FileLength};
	__property TNodeList* Nodes = {read=FNodeList};
	__property TWayList* Ways = {read=FWayList};
	__property TRelationList* Relations = {read=FRelationList};
	__property TUniqueStringList* Keys = {read=FKeyList};
	__property TUniqueStringList* Values = {read=FValueList};
	__property System::UnicodeString Role[TMemberOSM* Member] = {read=getRole};
	__property int idkey[const System::UnicodeString KeyName] = {read=getIDKey};
	__property int idValue[const System::UnicodeString ValueName] = {read=getIDValue};
	__property int MaxTagByElement = {read=getMaxTagByElement, write=setMaxTagByElement, nodefault};
	__property System::UnicodeString Timestamp = {read=FTimestamp};
	__property bool ClearAfterToShapes = {read=FClearAfterToShapes, write=FClearAfterToShapes, nodefault};
	__property TFilterBounds* FilterBounds = {read=FFilterBounds, write=FFilterBounds};
	__property TListFilterOSM* FilterNode = {read=FFilterNode, write=FFilterNode};
	__property TListFilterOSM* FilterWay = {read=FFilterWay, write=FFilterWay};
	__property TListFilterOSM* FilterRelation = {read=FFilterRelation, write=FFilterRelation};
	__property TSetPrimitiveOSM FilterPrimitive = {read=FFilterPrimitive, write=FFilterPrimitive, nodefault};
	__property TOnOSMBlockRead OnRead = {read=FOnBlockRead, write=FOnBlockRead};
	__property System::Classes::TNotifyEvent OnLoaded = {read=FOnParse, write=FOnParse};
	__property Uecnativeshape::TECShapes* Group = {read=FShapes};
};


//-- var, const, procedure ---------------------------------------------------
static _DELPHI_CONST int MAX_OSM_BUFFET = int(0x80000);
extern DELPHI_PACKAGE TThreadOSMToOLT* __fastcall OSMFileToOLT(const System::UnicodeString OSMFilename, const TSetPrimitiveOSM Primitives = (TSetPrimitiveOSM() << TPrimitiveOSM::poNode << TPrimitiveOSM::poWay << TPrimitiveOSM::poRelation ), const System::Classes::TNotifyEvent Notify = 0x0, const __int64 MaxBytesBeforeReduceMemory = 0x0000000165a0bc00LL);
extern DELPHI_PACKAGE TThreadOSMToOLT* __fastcall OSMFileToShapes(const System::UnicodeString OSMFilename, const TSetPrimitiveOSM Primitives = (TSetPrimitiveOSM() << TPrimitiveOSM::poNode << TPrimitiveOSM::poWay << TPrimitiveOSM::poRelation ), Uecnativeshape::TECShapes* const Shapes = (Uecnativeshape::TECShapes*)(0x0), const System::Classes::TNotifyEvent Notify = 0x0, const __int64 MaxBytesBeforeReduceMemory = 0x0000000165a0bc00LL);
}	/* namespace Uecosm */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_UECOSM)
using namespace Uecosm;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// uecOSMHPP
