﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'uecOpenWeather.pas' rev: 37.00 (Windows)

#ifndef uecOpenWeatherHPP
#define uecOpenWeatherHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <Winapi.Messages.hpp>
#include <System.SysUtils.hpp>
#include <System.Classes.hpp>
#include <System.Math.hpp>
#include <Vcl.Graphics.hpp>
#include <Vcl.StdCtrls.hpp>
#include <Vcl.Controls.hpp>
#include <UECMapZIP.hpp>
#include <System.Generics.Collections.hpp>
#include <Vcl.Dialogs.hpp>
#include <Vcl.Forms.hpp>
#include <Vcl.ExtCtrls.hpp>
#include <UECMapUtil.hpp>
#include <uecHttp.hpp>
#include <System.StrUtils.hpp>
#include <System.SyncObjs.hpp>
#include <System.UITypes.hpp>

//-- user supplied -----------------------------------------------------------

namespace Uecopenweather
{
//-- forward type declarations -----------------------------------------------
struct TOWWeather;
struct TOWWind;
struct TOpenWeatherData;
class DELPHICLASS TECBaseOpenWeather;
class DELPHICLASS TECBaseWeather;
class DELPHICLASS TECWeather;
class DELPHICLASS TECForecast;
class DELPHICLASS TECForecastDaily;
class DELPHICLASS TECOpenWeather;
//-- type declarations -------------------------------------------------------
struct DECLSPEC_DRECORD TOWWeather
{
public:
	__int64 id;
	System::UnicodeString main;
	System::UnicodeString description;
	System::UnicodeString FilenameIcon;
	System::UnicodeString icon;
};


struct DECLSPEC_DRECORD TOWWind
{
public:
	double speed;
	double deg;
};


struct DECLSPEC_DRECORD TOpenWeatherData
{
public:
	System::TDateTime UTCDateTime;
	__int64 id;
	System::UnicodeString name;
	Uecmaputil::TLatLng coord;
	TOWWeather weather;
	TOWWind wind;
	double temp;
	double pressure;
	int humidity;
	double visibility;
	double temp_min;
	double temp_max;
	double sea_level;
	double grnd_level;
	int clouds_all;
	double rain;
	double snow;
};


typedef System::DynamicArray<TOpenWeatherData> TOpenWeatherDataArray;

typedef void __fastcall (__closure *TOnAdaptToWeatherId)(int WeatherId, System::UnicodeString &FilenameIcon, System::Uitypes::TColor &Color);

typedef void __fastcall (__closure *TOnWeatherClick)(System::TObject* sender, const TOpenWeatherData &WeatherData);

enum DECLSPEC_DENUM TOpenWeatherUnits : unsigned char { metric, imperial, standard };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECBaseOpenWeather : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FBaseFilenameIcon;
	int FMaxCallByMinute;
	TOpenWeatherDataArray FArrayData;
	Uechttp::TuecHttp* FHttp;
	int FCount;
	System::UnicodeString FJsonResponse;
	System::UnicodeString FKey;
	System::UnicodeString FApi;
	System::UnicodeString FApiName;
	System::UnicodeString FLang;
	System::UnicodeString FLocalCache;
	TOpenWeatherUnits FUnits;
	int FMaxMinutesInCache;
	Uecmapzip::TECMapZip* FMapZip;
	System::UnicodeString __fastcall ApiUrl();
	int __fastcall Query(const System::UnicodeString SQuery);
	void __fastcall setLocalCache(const System::UnicodeString value);
	void __fastcall JsonToOpenWeatherDataIdNameCoord(const System::UnicodeString json, TOpenWeatherData &data, const bool ClearData = true);
	bool __fastcall JsonToOpenWeatherData(const System::UnicodeString json, TOpenWeatherData &data);
	
public:
	__fastcall TECBaseOpenWeather();
	__fastcall virtual ~TECBaseOpenWeather();
	__property System::UnicodeString Api = {read=FApi, write=FApi};
	__property System::UnicodeString Key = {read=FKey, write=FKey};
	__property System::UnicodeString LocalCache = {read=FLocalCache, write=setLocalCache};
	__property System::UnicodeString Lang = {read=FLang, write=FLang};
	__property TOpenWeatherUnits Units = {read=FUnits, write=FUnits, nodefault};
	__property System::UnicodeString BaseFilenameIcon = {read=FBaseFilenameIcon, write=FBaseFilenameIcon};
	__property int Count = {read=FCount, nodefault};
	__property TOpenWeatherDataArray Data = {read=FArrayData};
	__property System::UnicodeString JSonResponse = {read=FJsonResponse};
	__property Uecmapzip::TECMapZip* MapZip = {read=FMapZip, write=FMapZip};
	__property int MaxMinutesInCache = {read=FMaxMinutesInCache, write=FMaxMinutesInCache, nodefault};
	__property int MaxCallByMinute = {read=FMaxCallByMinute, write=FMaxCallByMinute, nodefault};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECBaseWeather : public TECBaseOpenWeather
{
	typedef TECBaseOpenWeather inherited;
	
public:
	int __fastcall ByCity(const System::UnicodeString City);
	int __fastcall ByZipCode(const System::UnicodeString ZipCode);
	int __fastcall ById(const System::UnicodeString id)/* overload */;
	int __fastcall ById(const int id)/* overload */;
	int __fastcall ByLatLng(const double Lat, const double Lng);
	TOpenWeatherData __fastcall Weather(const double lat, const double lng)/* overload */;
	TOpenWeatherData __fastcall Weather(const System::UnicodeString city)/* overload */;
	TOpenWeatherData __fastcall Weather(const int id)/* overload */;
public:
	/* TECBaseOpenWeather.Create */ inline __fastcall TECBaseWeather() : TECBaseOpenWeather() { }
	/* TECBaseOpenWeather.Destroy */ inline __fastcall virtual ~TECBaseWeather() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECWeather : public TECBaseWeather
{
	typedef TECBaseWeather inherited;
	
public:
	__fastcall TECWeather();
	int __fastcall ByGroupId(const System::UnicodeString ids);
	int __fastcall ByBox(const double NorthEastLat, const double NorthEastLng, const double SouthWestLat, const double SouthWestLng, const int Zoom = 0xa);
	int __fastcall Around(const double Lat, const double Lng, int MaxCity = 0xa);
public:
	/* TECBaseOpenWeather.Destroy */ inline __fastcall virtual ~TECWeather() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECForecast : public TECBaseWeather
{
	typedef TECBaseWeather inherited;
	
public:
	__fastcall TECForecast();
public:
	/* TECBaseOpenWeather.Destroy */ inline __fastcall virtual ~TECForecast() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TECForecastDaily : public TECBaseOpenWeather
{
	typedef TECBaseOpenWeather inherited;
	
public:
	__fastcall TECForecastDaily();
	int __fastcall ByCity(const System::UnicodeString City);
	int __fastcall ById(const System::UnicodeString id)/* overload */;
	int __fastcall ById(const int id)/* overload */;
	int __fastcall ByLatLng(const double Lat, const double Lng);
public:
	/* TECBaseOpenWeather.Destroy */ inline __fastcall virtual ~TECForecastDaily() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TECOpenWeather : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TOnAdaptToWeatherId FOnAdaptToWeatherId;
	TOnWeatherClick FOnWeatherClick;
	TECForecast* FForecast;
	TECForecastDaily* FDaily;
	TECWeather* FNow;
	System::UnicodeString FKey;
	System::UnicodeString FLang;
	System::UnicodeString FLocalCache;
	TOpenWeatherUnits FUnits;
	int FMaxCallByMinute;
	int FMaxMinutesInCache;
	Uecmapzip::TECMapZip* FMapZip;
	void __fastcall setLocalCache(const System::UnicodeString value);
	void __fastcall setKey(const System::UnicodeString value);
	void __fastcall setLang(const System::UnicodeString value);
	void __fastcall setUnits(const TOpenWeatherUnits value);
	void __fastcall setMapZip(Uecmapzip::TECMapZip* const value);
	void __fastcall setMaxMinutesInCache(const int value);
	void __fastcall setMaxCallByMinute(const int value);
	
public:
	__fastcall TECOpenWeather();
	__fastcall virtual ~TECOpenWeather();
	__property System::UnicodeString Key = {read=FKey, write=setKey};
	__property System::UnicodeString LocalCache = {read=FLocalCache, write=setLocalCache};
	__property System::UnicodeString Lang = {read=FLang, write=setLang};
	__property TOpenWeatherUnits Units = {read=FUnits, write=setUnits, nodefault};
	__property Uecmapzip::TECMapZip* MapZip = {read=FMapZip, write=setMapZip};
	__property int MaxMinutesInCache = {read=FMaxMinutesInCache, write=setMaxMinutesInCache, nodefault};
	__property int MaxCallByMinute = {read=FMaxCallByMinute, write=setMaxCallByMinute, nodefault};
	__property TECForecastDaily* Daily = {read=FDaily};
	__property TECWeather* Now = {read=FNow};
	__property TECForecast* Forecast = {read=FForecast};
	__property TOnAdaptToWeatherId OnAdaptToWeatherId = {read=FOnAdaptToWeatherId, write=FOnAdaptToWeatherId};
	__property TOnWeatherClick OnWeatherClick = {read=FOnWeatherClick, write=FOnWeatherClick};
};


//-- var, const, procedure ---------------------------------------------------
}	/* namespace Uecopenweather */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_UECOPENWEATHER)
using namespace Uecopenweather;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// uecOpenWeatherHPP
