﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'uecRstar_tree.pas' rev: 37.00 (Windows)

#ifndef uecRstar_treeHPP
#define uecRstar_treeHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.SysUtils.hpp>
#include <System.Generics.Collections.hpp>
#include <System.Generics.Defaults.hpp>
#include <System.Math.hpp>
#include <System.Classes.hpp>
#include <System.Types.hpp>

//-- user supplied -----------------------------------------------------------

namespace Uecrstar_tree
{
//-- forward type declarations -----------------------------------------------
struct TGpsPoint;
struct TMBR;
struct TRObject;
class DELPHICLASS TRNode;
class DELPHICLASS TRtree;
//-- type declarations -------------------------------------------------------
typedef System::TObject TObjTree;

typedef System::Generics::Collections::TList__1<System::TObject*> TRStarTreeList;

typedef void __fastcall (__closure *TOnFilterRTree)(TObjTree* sender, bool &ValidFilter);

enum DECLSPEC_DENUM TAxis : unsigned char { X, Y };

enum DECLSPEC_DENUM TBound : unsigned char { Left, Right };

struct DECLSPEC_DRECORD TGpsPoint
{
public:
	double X;
	double Y;
};


struct DECLSPEC_DRECORD TMBR
{
public:
	TGpsPoint Left;
	TGpsPoint Right;
};


struct DECLSPEC_DRECORD TRObject
{
public:
	TMBR mbr;
	TObjTree* idx;
};


class PASCALIMPLEMENTATION TRNode : public System::TObject
{
	typedef System::TObject inherited;
	
	
private:
	typedef System::DynamicArray<int> _TRNode__1;
	
	typedef System::DynamicArray<TRObject> _TRNode__2;
	
	
private:
	TMBR fmbr;
	int FParent;
	_TRNode__1 FChildren;
	_TRNode__2 FObjects;
	bool FisLeaf;
	int FLevel;
	
protected:
	bool __fastcall getIsLeaf();
	int __fastcall getChild(int Index);
	TRObject __fastcall getObject(int Index);
	void __fastcall setChild(int Index, int node_id);
	void __fastcall setObject(int Index, const TRObject &obj);
	void __fastcall setParent(int parent_id);
	void __fastcall copy(TRNode* node);
	void __fastcall clearObjects();
	void __fastcall clearChildren();
	
public:
	__fastcall TRNode()/* overload */;
	__fastcall TRNode(TRNode* node)/* overload */;
	__fastcall virtual ~TRNode();
	__property TMBR mbr = {read=fmbr, write=fmbr};
	__property bool isLeaf = {read=FisLeaf, nodefault};
	__property int Children[int Index] = {read=getChild, write=setChild};
	__property TRObject Objects[int Index] = {read=getObject, write=setObject};
	__property int Parent = {read=FParent, write=setParent, nodefault};
	__property int Level = {read=FLevel, write=FLevel, nodefault};
	bool __fastcall isIntersected(const TMBR &mbr1, const TMBR &mbr2)/* overload */;
	bool __fastcall isIntersected(const TMBR &mbr)/* overload */;
	double __fastcall Overlap(const TMBR &mbr_ovrl);
	double __fastcall Area()/* overload */;
	double __fastcall Area(const TMBR &mbr)/* overload */;
	double __fastcall margin();
};


class PASCALIMPLEMENTATION TRtree : public System::TObject
{
	typedef System::TObject inherited;
	
	
private:
	typedef System::DynamicArray<TRObject> _TRtree__1;
	
	typedef System::DynamicArray<int> _TRtree__2;
	
	typedef System::DynamicArray<TRNode*> _TRtree__3;
	
	
private:
	_TRtree__1 arr_obj;
	_TRtree__2 arr_node;
	TRNode* node_1_min;
	TRNode* node_2_min;
	TRNode* node_1;
	TRNode* node_2;
	TOnFilterRTree FFilter;
	_TRtree__3 FNodeArr;
	int FRoot;
	int FHeight;
	void __fastcall QuickSort(TRObject *List, const System::NativeInt List_High, int iLo, int iHi, TAxis axe, TBound bound)/* overload */;
	void __fastcall QuickSort(int *List, const System::NativeInt List_High, int iLo, int iHi, TAxis axe, TBound bound)/* overload */;
	void __fastcall splitNodeRStar(int node_id, const TRObject &obj)/* overload */;
	void __fastcall splitNodeRStar(int splited_Node_Id, int inserted_Node_Id)/* overload */;
	void __fastcall updateMBR(int node_id)/* overload */;
	void __fastcall updateMBR(TRNode* node)/* overload */;
	void __fastcall chooseSubtree(const TRObject &obj, int &node_id);
	TAxis __fastcall chooseSplitAxis(const TRObject &obj, int node_id)/* overload */;
	TAxis __fastcall chooseSplitAxis(int nodeFather, int nodeChild)/* overload */;
	void __fastcall findObjectsInArea(const TMBR &mbr, int node_id, TRStarTreeList* obj)/* overload */;
	bool __fastcall isRoot(int node_id);
	int __fastcall newNode();
	
public:
	__fastcall TRtree();
	__fastcall virtual ~TRtree();
	void __fastcall Clear();
	void __fastcall insertObject(const TRObject &obj)/* overload */;
	void __fastcall insertObject(double lx, double ly, double rx, double ry, TObjTree* idx)/* overload */;
	void __fastcall findObjectsInArea(const TMBR &mbr, TRStarTreeList* obj)/* overload */;
	__property TOnFilterRTree Filter = {read=FFilter, write=FFilter};
	__property int Height = {read=FHeight, nodefault};
};


//-- var, const, procedure ---------------------------------------------------
static _DELPHI_CONST System::Int8 MAX_M = System::Int8(0x10);
static _DELPHI_CONST __int64 MIN_M = 6LL;
extern DELPHI_PACKAGE TRObject __fastcall toRObject(double lx, double ly, double rx, double ry, TObjTree* idx)/* overload */;
extern DELPHI_PACKAGE TRObject __fastcall toRObject(const TMBR &mbr, TObjTree* idx)/* overload */;
}	/* namespace Uecrstar_tree */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_UECRSTAR_TREE)
using namespace Uecrstar_tree;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// uecRstar_treeHPP
