﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'vector_tile.pas' rev: 37.00 (Windows)

#ifndef vector_tileHPP
#define vector_tileHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.SysUtils.hpp>
#include <System.Math.hpp>
#include <System.Types.hpp>
#include <System.Classes.hpp>
#include <System.Generics.Collections.hpp>
#include <pbInput.hpp>
#include <pbOutput.hpp>
#include <pbPublic.hpp>
#include <uAbstractProtoBufClasses.hpp>
#include <System.Generics.Defaults.hpp>

//-- user supplied -----------------------------------------------------------

namespace Vector_tile
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TValue;
class DELPHICLASS TFeature;
class DELPHICLASS TLayer;
class DELPHICLASS TTile;
class DELPHICLASS TDecodedFeature;
class DELPHICLASS TDecodedLayer;
class DELPHICLASS TDecodedTile;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TGeomType : unsigned char { UNKNOWN, VMT_POINT, VMT_LINESTRING, VMT_POLYGON };

enum DECLSPEC_DENUM TCommandID : unsigned char { MOVETO = 1, LINETO, CLOSEPATH = 7 };

typedef System::Generics::Collections::TList__1<unsigned> TListCardinal;

class PASCALIMPLEMENTATION TValue : public Uabstractprotobufclasses::TAbstractProtoBufClass
{
	typedef Uabstractprotobufclasses::TAbstractProtoBufClass inherited;
	
private:
	System::UnicodeString Fstring_value;
	float Ffloat_value;
	double Fdouble_value;
	__int64 Fint_value;
	unsigned __int64 Fuint_value;
	__int64 Fsint_value;
	bool Fbool_value;
	
protected:
	virtual bool __fastcall LoadSingleFieldFromBuf(Pbinput::TProtoBufInput* ProtoBuf, int FieldNumber, int WireType);
	virtual void __fastcall SaveFieldsToBuf(Pboutput::TProtoBufOutput* ProtoBuf);
	
public:
	__property System::UnicodeString string_value = {read=Fstring_value, write=Fstring_value};
	__property float float_value = {read=Ffloat_value, write=Ffloat_value};
	__property double double_value = {read=Fdouble_value, write=Fdouble_value};
	__property __int64 int_value = {read=Fint_value, write=Fint_value};
	__property unsigned __int64 uint_value = {read=Fuint_value, write=Fuint_value};
	__property __int64 sint_value = {read=Fsint_value, write=Fsint_value};
	__property bool bool_value = {read=Fbool_value, write=Fbool_value, nodefault};
public:
	/* TAbstractProtoBufClass.Create */ inline __fastcall virtual TValue() : Uabstractprotobufclasses::TAbstractProtoBufClass() { }
	/* TAbstractProtoBufClass.Destroy */ inline __fastcall virtual ~TValue() { }
	
};


class PASCALIMPLEMENTATION TFeature : public Uabstractprotobufclasses::TAbstractProtoBufClass
{
	typedef Uabstractprotobufclasses::TAbstractProtoBufClass inherited;
	
private:
	unsigned __int64 Fid;
	TListCardinal* FtagsList;
	TGeomType Ftype;
	TListCardinal* FgeometryList;
	
protected:
	virtual bool __fastcall LoadSingleFieldFromBuf(Pbinput::TProtoBufInput* ProtoBuf, int FieldNumber, int WireType);
	virtual void __fastcall SaveFieldsToBuf(Pboutput::TProtoBufOutput* ProtoBuf);
	
public:
	__fastcall virtual TFeature();
	__fastcall virtual ~TFeature();
	__property unsigned __int64 id = {read=Fid, write=Fid, default=0};
	__property TListCardinal* tagsList = {read=FtagsList};
	__property TGeomType Geomtype = {read=Ftype, write=Ftype, default=0};
	__property TListCardinal* geometryList = {read=FgeometryList};
};


typedef Uabstractprotobufclasses::TProtoBufClassList__1<TFeature*> TProtoBufClassListFeature;

typedef System::Classes::TStringList TListString;

typedef Uabstractprotobufclasses::TProtoBufClassList__1<TValue*> TProtoBufClassListValue;

class PASCALIMPLEMENTATION TLayer : public Uabstractprotobufclasses::TAbstractProtoBufClass
{
	typedef Uabstractprotobufclasses::TAbstractProtoBufClass inherited;
	
private:
	System::UnicodeString Fname;
	TProtoBufClassListFeature* FfeaturesList;
	TListString* FkeysList;
	TProtoBufClassListValue* FvaluesList;
	unsigned Fextent;
	unsigned Fversion;
	
protected:
	virtual bool __fastcall LoadSingleFieldFromBuf(Pbinput::TProtoBufInput* ProtoBuf, int FieldNumber, int WireType);
	virtual void __fastcall SaveFieldsToBuf(Pboutput::TProtoBufOutput* ProtoBuf);
	
public:
	__fastcall virtual TLayer();
	__fastcall virtual ~TLayer();
	__property System::UnicodeString name = {read=Fname, write=Fname};
	__property TProtoBufClassListFeature* featuresList = {read=FfeaturesList};
	__property TListString* keysList = {read=FkeysList};
	__property TProtoBufClassListValue* valuesList = {read=FvaluesList};
	__property unsigned extent = {read=Fextent, write=Fextent, default=4096};
	__property unsigned version = {read=Fversion, write=Fversion, default=1};
};


typedef Uabstractprotobufclasses::TProtoBufClassList__1<TLayer*> TProtoBufClassListLayer;

class PASCALIMPLEMENTATION TTile : public Uabstractprotobufclasses::TAbstractProtoBufClass
{
	typedef Uabstractprotobufclasses::TAbstractProtoBufClass inherited;
	
private:
	TProtoBufClassListLayer* FlayersList;
	
protected:
	virtual bool __fastcall LoadSingleFieldFromBuf(Pbinput::TProtoBufInput* ProtoBuf, int FieldNumber, int WireType);
	virtual void __fastcall SaveFieldsToBuf(Pboutput::TProtoBufOutput* ProtoBuf);
	
public:
	__fastcall virtual TTile();
	__fastcall virtual ~TTile();
	void __fastcall Clear();
	__property TProtoBufClassListLayer* layersList = {read=FlayersList};
};


typedef System::Generics::Collections::TDictionary__2<System::UnicodeString,System::UnicodeString> TDecodeKeys;

typedef System::DynamicArray<System::Types::TPoint> TArrayPoint;

typedef System::DynamicArray<System::Types::TRect> TArrayRect;

class PASCALIMPLEMENTATION TDecodedFeature : public System::TObject
{
	typedef System::TObject inherited;
	
	
private:
	typedef System::DynamicArray<TArrayPoint> _TDecodedFeature__1;
	
	typedef System::DynamicArray<TArrayPoint> _TDecodedFeature__2;
	
	
private:
	_TDecodedFeature__1 LPoints;
	TArrayRect LBounds;
	System::Types::TRect FBound;
	int FXTranslate;
	int FYTranslate;
	double FZoom;
	
public:
	TDecodeKeys* FDecodeKeys;
	_TDecodedFeature__2 Points;
	TLayer* Layer;
	TFeature* featuresList;
	System::UnicodeString __fastcall getKeys();
	System::UnicodeString __fastcall getKey(const System::UnicodeString AKey);
	void __fastcall getBound();
	void __fastcall Transform(const int Xtranslate, const int YTranslate, const double AZoom);
	__property double Zoom = {read=FZoom};
	__property TArrayRect Bounds = {read=LBounds};
	__property System::Types::TRect Bound = {read=FBound, write=FBound};
	__fastcall TDecodedFeature();
	__fastcall virtual ~TDecodedFeature();
};


typedef System::DynamicArray<TDecodedFeature*> TDecodedFeatures;

class PASCALIMPLEMENTATION TDecodedLayer : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	int FXTranslate;
	int FYTranslate;
	double FZoom;
	TLayer* Layer;
	TDecodedFeatures Features;
	void __fastcall Transform(const int Xtranslate, const int YTranslate, const double AZoom);
	__fastcall virtual ~TDecodedLayer();
public:
	/* TObject.Create */ inline __fastcall TDecodedLayer() : System::TObject() { }
	
};


typedef System::DynamicArray<TDecodedLayer*> TDecodedLayers;

class PASCALIMPLEMENTATION TDecodedTile : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TTile* FTile;
	TDecodedLayers FLayers;
	System::Classes::TStringList* FNameLayers;
	int FXTranslate;
	int FYTranslate;
	double FZoom;
	int FPrepareZoom;
	void __fastcall Decode(const int TileSize);
	
public:
	__fastcall TDecodedTile();
	__fastcall virtual ~TDecodedTile();
	void __fastcall Clear();
	void __fastcall LoadFromStream(System::Classes::TStream* const AStream, const int TileSize = 0x200);
	void __fastcall Transform(const int Xtranslate, const int YTranslate, const double AZoom);
	TDecodedLayer* __fastcall getLayer(const System::UnicodeString AName);
	__property TTile* Tile = {read=FTile};
	__property TDecodedLayers Layers = {read=FLayers};
	__property int PrepareZoom = {read=FPrepareZoom, write=FPrepareZoom, nodefault};
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE void __fastcall getCommandCount(const int value, TCommandID &ACommandId, int &ACommandCount);
}	/* namespace Vector_tile */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_VECTOR_TILE)
using namespace Vector_tile;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// vector_tileHPP
